/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.data.nc.NcVarSorting;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import javax.swing.Box;
import javax.swing.BoxLayout;

public class PanDnvLayoutPrefsPanel
extends PanAbstractPrefsPanel {
    private PanCheckBox expandNodesCB_;
    private PanCheckBox sortAlphabeticCB_;
    private boolean refreshing_;

    public PanDnvLayoutPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.expandNodesCB_ = PanCheckBox.create("Expand newly opened file nodes in Sources datasets panel");
        this.sortAlphabeticCB_ = PanCheckBox.create("Sort Sources datasets panel entries alphabetically (requires restart)");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(GuiUtils.createPaddedTitleBorder("Sources Window"));
        this.add(QuickBox.createLeftBox(this.expandNodesCB_));
        this.add(Box.createVerticalStrut(2));
        this.add(QuickBox.createLeftBox(this.sortAlphabeticCB_));
    }

    private void attachListeners() {
        this.expandNodesCB_.addItemListener(e -> {
            if (!this.refreshing_) {
                boolean bb = this.expandNodesCB_.isSelected();
                prefs_.setBoolean("sources:nodes.expanded", bb);
            }
            PanSourcesFrame.getSharedInstance().refresh();
        });
        this.sortAlphabeticCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean bb = this.sortAlphabeticCB_.isSelected();
            if (bb) {
                prefs_.set("sources:datasets.sorting", NcVarSorting.ALPHA.name());
            } else {
                prefs_.set("sources:datasets.sorting", NcVarSorting.NONE.name());
            }
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.expandNodesCB_.setSelected(prefs_.getBoolean("sources:nodes.expanded"));
        this.sortAlphabeticCB_.setSelected(NcVarSorting.ALPHA.matches(prefs_.getString("sources:datasets.sorting")));
        this.refreshing_ = false;
    }
}

