/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.ui.color.ColorTableComboBoxRenderer;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import java.lang.invoke.MethodHandles;
import javax.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanColorTableComboBox
extends JComboBox<AbstractColorTable>
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean hiliteFaves_ = true;
    private boolean refreshing_;

    private PanColorTableComboBox(boolean showSample) {
        this(SizeVariant.REGULAR, showSample);
    }

    private PanColorTableComboBox(SizeVariant size, boolean showSample) {
        this.refresh();
        this.setSelectedItem(PanResourceUtils.getPreferredColorTable());
        if (showSample) {
            this.setRenderer(new ColorTableComboBoxRenderer());
        }
        GuiUtils.applyComboBoxUI(this, size);
        PanResourceUtils.getColorTableList().addListDataListener(this);
    }

    public boolean isRefreshing() {
        return this.refreshing_;
    }

    public void refresh() {
        AbstractColorTable newItem;
        int i;
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        Object selItem = this.getSelectedItem();
        this.removeAllItems();
        ColorTableResourceList reslist = PanResourceUtils.getColorTableList();
        int isize = reslist.getSize();
        boolean skippedOne = false;
        for (i = 0; i < isize; ++i) {
            if (!reslist.isFavorite(i)) {
                skippedOne = true;
                continue;
            }
            newItem = PanResourceUtils.getColorTable(i);
            if (newItem == null) continue;
            this.addItem(newItem);
        }
        if (skippedOne) {
            this.addItem(null);
            for (i = 0; i < isize; ++i) {
                if (reslist.isFavorite(i) || (newItem = PanResourceUtils.getColorTable(i)) == null) continue;
                this.addItem(newItem);
            }
        }
        if (selItem != null) {
            this.setSelectedItem(selItem);
        }
        this.refreshing_ = false;
    }

    public void setSelectedItemByName(String name) {
        if (name == null) {
            return;
        }
        int isize = this.getItemCount();
        for (int i = 0; i < isize; ++i) {
            Object o = this.getItemAt(i);
            if (o == null || !name.equalsIgnoreCase(o.toString())) continue;
            this.setSelectedIndex(i);
            return;
        }
        LOGGER.warn("Could not find matching item for name {}", (Object)name);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        this.refresh();
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
        this.refresh();
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        this.refresh();
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PanColorTableComboBox panColorTableComboBox = this;
        synchronized (panColorTableComboBox) {
            PanResourceUtils.getColorTableList().removeListDataListener(this);
            this.removeAll();
        }
    }

    public static PanColorTableComboBox create(boolean showSample) {
        return new PanColorTableComboBox(SizeVariant.REGULAR, showSample);
    }

    public static PanColorTableComboBox create(String name, boolean showSample) {
        PanColorTableComboBox result = PanColorTableComboBox.create(showSample);
        if (name != null) {
            result.setName(name);
        }
        return result;
    }

    public static PanColorTableComboBox small(boolean showSample) {
        return new PanColorTableComboBox(SizeVariant.SMALL, showSample);
    }

    public static PanColorTableComboBox small(String name, boolean showSample) {
        PanColorTableComboBox result = PanColorTableComboBox.small(showSample);
        if (name != null) {
            result.setName(name);
        }
        return result;
    }
}

