/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.planet;

import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.time.ClockType;
import gov.nasa.giss.time.HourFormatter;
import gov.nasa.giss.time.TimeUnits;
import gov.nasa.giss.time.planet.AbstractPlanetTime;
import gov.nasa.giss.time.planet.DistanceUnits;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class EarthTime
extends AbstractPlanetTime {
    private static final DecimalFormat FORMAT_30 = new DecimalFormat("000");
    private double rE_;
    private double lambdaE_;
    private final GregorianCalendar gregorian_ = new GregorianCalendar();
    private final Date date_ = new Date();
    private static TimeZone localZone_ = TimeZone.getDefault();
    private static SimpleTimeZone utZone_ = new SimpleTimeZone(0, "GMT+0:00");

    public EarthTime() {
        this(System.currentTimeMillis());
    }

    public EarthTime(long millis) {
        super(millis);
        this.calculate();
    }

    @Override
    protected final void calculate() {
        this.semimajorAxisAU_ = 1.0;
        this.flattening_ = 0.0;
        this.obliquity_ = 23.4393;
        this.eccentricity_ = 0.01671;
        double g = 357.528 + 0.9856003 * this.delta2000_;
        double gRad = g * (Math.PI / 180);
        this.rE_ = 1.00014 - 0.01671 * Math.cos(gRad) - 1.4E-4 * Math.cos(2.0 * gRad);
        this.lambdaE_ = 102.944 + g + 1.915 * Math.sin(gRad) + 0.02 * Math.sin(2.0 * gRad);
        this.lambdaE_ = EarthTime.normalize360(this.lambdaE_);
    }

    @Override
    protected void calculateOrbitParams() {
    }

    @Override
    protected void calculateEarthParams() {
    }

    @Override
    public double getVernalEquinox() {
        return -4.6E-5 * this.delta2000_;
    }

    @Override
    public double getHeliocentricLongitudeAtPerihelion() {
        return 282.9317 + 4.7076E-5 * this.delta2000_ + this.getVernalEquinox();
    }

    @Override
    public double getHeliocentricLongitude() {
        return this.lambdaE_;
    }

    @Override
    public double getHeliocentricLatitude() {
        return 0.0;
    }

    @Override
    public double getDistanceToSun(DistanceUnits units) {
        switch (units) {
            case AU: {
                return this.rE_;
            }
            case KM: {
                return this.rE_ * 1.495978707E8;
            }
            case LIGHTSEC: {
                return this.rE_ * 499.0047838361564;
            }
            case LIGHTMIN: {
                return this.rE_ * 499.0047838361564 / 60.0;
            }
        }
        throw new IllegalArgumentException("No switch case for DistanceUnits");
    }

    @Override
    public double getEarthDistance(DistanceUnits units) {
        return 0.0;
    }

    @Override
    public PointLL getSubEarthPoint() {
        return new PointLL(0.0, 0.0);
    }

    @Override
    public Point2D.Double getEarthAngleAt(double lon, double lat) {
        return new Point2D.Double(0.0, 0.0);
    }

    @Override
    public double getTimeHours(double lon, ClockType ctype) {
        return 0.0;
    }

    public String getTimeString(double lon, ClockType ctype, boolean appendSuffix) {
        return "";
    }

    public String getTimeStringMinutes(boolean local) {
        String append;
        this.date_.setTime(this.unixMillis_);
        this.gregorian_.setTime(this.date_);
        if (local) {
            this.gregorian_.setTimeZone(localZone_);
            append = localZone_.getDisplayName(localZone_.inDaylightTime(this.date_), 0);
        } else {
            this.gregorian_.setTimeZone(utZone_);
            append = "UT";
        }
        return HourFormatter.format(this.gregorian_.get(11), this.gregorian_.get(12), 0, 0, TimeUnits.MINUTES, null, append);
    }

    public String getTimeStringSeconds(boolean local) {
        return this.getTimeStringSeconds(local, true);
    }

    public String getTimeStringSeconds(boolean local, boolean withSuffix) {
        this.date_.setTime(this.unixMillis_);
        this.gregorian_.setTime(this.date_);
        if (local) {
            this.gregorian_.setTimeZone(localZone_);
        } else {
            this.gregorian_.setTimeZone(utZone_);
        }
        String append = null;
        if (withSuffix) {
            append = local ? localZone_.getDisplayName(localZone_.inDaylightTime(this.date_), 0) : "UT";
        }
        return HourFormatter.format(this.gregorian_.get(11), this.gregorian_.get(12), this.gregorian_.get(13), 0, TimeUnits.SECONDS, null, append);
    }

    public String getZoneString(boolean local) {
        if (local) {
            return localZone_.getDisplayName(localZone_.inDaylightTime(this.date_), 0);
        }
        return "UT";
    }

    public String getZoneDescription(boolean local) {
        if (local) {
            int offset = localZone_.getOffset(this.unixMillis_);
            String sign = "+";
            if (offset < 0) {
                offset = -offset;
                sign = "-";
            }
            int secs = offset / 1000;
            int mins = secs / 60;
            double hours = (double)mins / 60.0;
            String s = HourFormatter.format(hours, TimeUnits.MINUTES, null, null);
            return localZone_.getDisplayName(localZone_.inDaylightTime(this.date_), 0) + " (UT" + sign + s + ")";
        }
        return "UT";
    }

    public String getDateString(boolean local, boolean asDOY) {
        this.date_.setTime(this.unixMillis_);
        this.gregorian_.setTime(this.date_);
        if (local) {
            this.gregorian_.setTimeZone(localZone_);
        } else {
            this.gregorian_.setTimeZone(utZone_);
        }
        StringBuilder sb = new StringBuilder().append(this.gregorian_.get(1)).append("-");
        if (asDOY) {
            sb.append(FORMAT_30.format(this.gregorian_.get(6)));
        } else {
            sb.append(FORMAT_20.format(this.gregorian_.get(2) + 1)).append('-').append(FORMAT_20.format(this.gregorian_.get(5)));
        }
        return sb.toString();
    }
}

