/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CheckBoxBorder
extends TitledBorder {
    protected JCheckBox checkbox_;

    public CheckBoxBorder(JCheckBox jcb) {
        this(null, jcb, 1, 2);
    }

    public CheckBoxBorder(Border border) {
        this(border, (JCheckBox)null, 1, 2);
    }

    public CheckBoxBorder(Border border, JCheckBox jcb) {
        this(border, jcb, 1, 2);
    }

    public CheckBoxBorder(Border border, JCheckBox jcb, int justification, int position) {
        super(border, "", justification, position, null, null);
        this.checkbox_ = jcb;
        if (border == null) {
            this.border = super.getBorder();
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Rectangle borderRect = new Rectangle(x + 2, y + 2, w - 4, h - 4);
        Insets borderInsets = this.border == null ? new Insets(0, 0, 0, 0) : this.border.getBorderInsets(c);
        Rectangle rect = new Rectangle(x, y, w, h);
        Insets insets = this.getBorderInsets(c);
        Rectangle crect = this.getCheckBoxRect(rect, insets);
        switch (this.titlePosition) {
            case 1: {
                int diff = crect.height + 2;
                borderRect.y += diff;
                borderRect.height -= diff;
                break;
            }
            case 0: 
            case 2: {
                int diff = insets.top / 2 - borderInsets.top - 2;
                borderRect.y += diff;
                borderRect.height -= diff;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                borderRect.height -= diff;
                break;
            }
            case 6: {
                int diff = crect.height + 2;
                borderRect.height -= diff;
            }
        }
        this.border.paintBorder(c, g, borderRect.x, borderRect.y, borderRect.width, borderRect.height);
        Color col = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(crect.x, crect.y, crect.width, crect.height);
        g.setColor(col);
        this.checkbox_.repaint();
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets borderInsets = this.border == null ? new Insets(0, 0, 0, 0) : this.border.getBorderInsets(c);
        insets.top = borderInsets.top + 2 + 2;
        insets.right = borderInsets.right + 2 + 2;
        insets.bottom = borderInsets.bottom + 2 + 2;
        insets.left = borderInsets.left + 2 + 2;
        if (c == null || this.checkbox_ == null) {
            return insets;
        }
        int cheight = 0;
        if (this.checkbox_ != null) {
            cheight = this.checkbox_.getPreferredSize().height;
        }
        switch (this.titlePosition) {
            case 1: {
                insets.top += cheight + 2;
                break;
            }
            case 0: 
            case 2: {
                insets.top += Math.max(cheight, borderInsets.top) - borderInsets.top;
                break;
            }
            case 3: {
                insets.top += cheight + 2;
                break;
            }
            case 4: {
                insets.bottom += cheight + 2;
                break;
            }
            case 5: {
                insets.bottom += Math.max(cheight, borderInsets.bottom) - borderInsets.top;
                break;
            }
            case 6: {
                insets.top += cheight + 2;
            }
        }
        return insets;
    }

    public JCheckBox getCheckBox() {
        return this.checkbox_;
    }

    public void setCheckBox(JCheckBox jcb) {
        this.checkbox_ = jcb;
    }

    public Rectangle getCheckBoxRect(Rectangle rect, Insets borderInsets) {
        Dimension csize = this.checkbox_.getPreferredSize();
        Rectangle crect = new Rectangle(0, 0, csize.width, csize.height);
        switch (this.titlePosition) {
            case 1: {
                crect.y = 2;
                break;
            }
            case 0: 
            case 2: {
                crect.y = 2 + (borderInsets.top - 2 - 2 - csize.height) / 2;
                break;
            }
            case 3: {
                crect.y = borderInsets.top - csize.height - 2;
                break;
            }
            case 4: {
                crect.y = rect.height - borderInsets.bottom + 2;
                break;
            }
            case 5: {
                crect.y = rect.height - borderInsets.bottom + 2 + (borderInsets.bottom - 2 - 2 - csize.height) / 2;
                break;
            }
            case 6: {
                crect.y = rect.height - csize.height - 2;
            }
        }
        switch (this.titleJustification) {
            case 0: 
            case 1: {
                crect.x = 5 + borderInsets.left;
                break;
            }
            case 3: {
                crect.x = rect.width - borderInsets.right - 5 - crect.width;
                break;
            }
            case 2: {
                crect.x = (rect.width - crect.width) / 2;
            }
        }
        this.checkbox_.setBounds(crect.x, crect.y, csize.width, csize.height);
        return crect;
    }
}

