/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.ColorTableEvent;
import gov.nasa.giss.graphics.clut.ColorTableListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;

public class ColorTableGridPanel
extends JComponent
implements ColorTableListener {
    private static final String NO_OUTLIERS = "No special outlier colors";
    private static final String LT_MIN = "min.<";
    private static final String GT_MAX = ">max.";
    private static final Color FOCUS_COLOR = UIManager.getColor("Table.focusCellForeground").darker();
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final Border HILITE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createLineBorder(FOCUS_COLOR, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final Font DEFAULT_FONT = new Font("Lucida Sans", 0, 10);
    private static final int PANEL_WIDTH = 600;
    private int binInside_ = 20;
    private int binSize_ = this.binInside_ + 2;
    private int binGap_ = 4;
    private int cellSize_ = this.binSize_ + this.binGap_;
    private int binsPerRow_ = 16;
    private AbstractColorTable ctable_;
    private int colorCount_;
    private Point[] binLoci_;
    private boolean binIdsVisible_;

    public ColorTableGridPanel(AbstractColorTable act) {
        this.setFont(DEFAULT_FONT);
        this.ctable_ = act;
        this.ctable_.addColorTableListener(this);
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        this.measure();
        BinMouseHandler mouseAdapter = new BinMouseHandler();
        this.addMouseListener(mouseAdapter);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ColorTableGridPanel.this.setBorder(SIMPLE_OUTLINE_BORDER);
            }

            @Override
            public void focusGained(FocusEvent e) {
                ColorTableGridPanel.this.setBorder(HILITE_OUTLINE_BORDER);
            }
        });
        this.attachAction(new ToggleLabelsAction(), "SPACE");
    }

    private void attachAction(AbstractAction action, String keyStroke) {
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        am.put(action.getValue("Name"), action);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private void measure() {
        this.colorCount_ = this.ctable_.getColorCount();
        this.binLoci_ = this.ctable_.hasOutlierColors() ? new Point[this.colorCount_ + 2] : new Point[this.colorCount_];
        this.binsPerRow_ = (int)Math.sqrt(this.colorCount_);
        if (this.binsPerRow_ % 2 > 0) {
            --this.binsPerRow_;
        }
        this.binsPerRow_ = Math.max(16, this.binsPerRow_);
        this.binsPerRow_ = Math.min(50, this.binsPerRow_);
        this.binGap_ = 4;
        this.binInside_ = Math.min(22, 600 / this.binsPerRow_ - this.binGap_ - 2);
        this.binInside_ = Math.max(12, this.binInside_);
        this.binsPerRow_ = 600 / (this.binInside_ + 2 + this.binGap_);
        this.binsPerRow_ = Math.max(16, this.binsPerRow_);
        this.binSize_ = this.binInside_ + 2;
        this.cellSize_ = this.binSize_ + this.binGap_;
        int numRows = this.colorCount_ / this.binsPerRow_;
        if (this.colorCount_ % this.binsPerRow_ > 0) {
            ++numRows;
        }
        Insets ins = this.getInsets();
        int w = Math.max(600, this.binsPerRow_ * this.cellSize_);
        int h = this.ctable_.hasOutlierColors() ? (numRows + 1) * this.cellSize_ + 2 * this.binGap_ : numRows * this.cellSize_ + 2 * this.binGap_ + this.getFont().getSize();
        w += ins.left + ins.right;
        h += ins.top + ins.bottom;
        if (this.ctable_.hasRangeLimits()) {
            h += this.cellSize_;
        }
        int extrax = Math.max(0, 600 - this.binsPerRow_ * this.cellSize_) / 2;
        Dimension size = new Dimension(w, h);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        int bin = 0;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < this.binsPerRow_ && (bin = row * this.binsPerRow_ + col) < this.colorCount_; ++col) {
                int x = ins.left + extrax + col * this.cellSize_ + this.binGap_ / 2;
                int y = ins.top + row * this.cellSize_ + this.binGap_ / 2;
                if (row == numRows - 1 && this.colorCount_ % this.binsPerRow_ != 0) {
                    x += this.cellSize_ * (this.binsPerRow_ - this.colorCount_ % this.binsPerRow_) / 2;
                }
                this.binLoci_[bin] = new Point(x + 1, y + 1);
            }
            if (bin >= this.colorCount_) break;
        }
        if (this.ctable_.hasOutlierColors()) {
            int xTop = ins.top + numRows * this.cellSize_ + 2 * this.binGap_;
            this.binLoci_[this.colorCount_] = new Point(w / 2 - 12 + 1 - this.binSize_, xTop);
            this.binLoci_[this.colorCount_ + 1] = new Point(w / 2 + 12 + 1, xTop);
        }
    }

    public AbstractColorTable getColorTable() {
        return this.ctable_;
    }

    public void setColorTable(AbstractColorTable act) {
        if (this.ctable_ != null) {
            this.ctable_.removeColorTableListener(this);
        }
        this.ctable_ = act;
        this.ctable_.addColorTableListener(this);
        this.measure();
        this.invalidate();
        if (this.getTopLevelAncestor() != null) {
            ((JFrame)this.getTopLevelAncestor()).pack();
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        for (int i = 0; i < this.colorCount_; ++i) {
            Color c = this.ctable_.getColorAt(i);
            this.drawBin(g2d, i, c);
            if (!this.binIdsVisible_) continue;
            int lum = (c.getRed() + c.getGreen() + c.getBlue()) / 2;
            if (lum < 142) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(Color.BLACK);
            }
            String s = Integer.toString(i + 1);
            GraphicUtils.drawString(g2d, (Object)s, this.binLoci_[i].x + (this.binInside_ - fm.stringWidth(s)) / 2, this.binLoci_[i].y + this.getFont().getSize() + 2);
        }
        int outTop = 0;
        if (this.ctable_.hasOutlierColors()) {
            outTop = this.binLoci_[this.colorCount_].y + (this.binInside_ + fm.getAscent()) / 2;
            g2d.setColor(Color.BLACK);
            GraphicUtils.drawString(g2d, (Object)LT_MIN, this.binLoci_[this.colorCount_].x - 5 - fm.stringWidth(LT_MIN), outTop);
            GraphicUtils.drawString(g2d, (Object)GT_MAX, this.binLoci_[this.colorCount_ + 1].x + this.binInside_ + 5, outTop);
            this.drawBin(g2d, this.colorCount_, this.ctable_.getMinOutlierColor());
            this.drawBin(g2d, this.colorCount_ + 1, this.ctable_.getMaxOutlierColor());
        } else {
            outTop = this.binLoci_[this.colorCount_ - 1].y + this.cellSize_ + fm.getAscent();
            g2d.setColor(Color.BLACK);
            GraphicUtils.drawString(g2d, (Object)NO_OUTLIERS, (this.getWidth() - fm.stringWidth(NO_OUTLIERS)) / 2, outTop);
        }
        if (this.ctable_.hasRangeLimits()) {
            int limTop = outTop + this.cellSize_;
            String limitStr = "Color table defines range limits " + this.ctable_.getRangeMinimum() + ", " + this.ctable_.getRangeMaximum();
            g2d.setColor(Color.BLACK);
            GraphicUtils.drawString(g2d, (Object)limitStr, (this.getWidth() - fm.stringWidth(limitStr)) / 2, limTop);
        }
        g2d.dispose();
    }

    private void drawBin(Graphics2D g2d, int bin, Color c) {
        if (bin < 0 || bin >= this.binLoci_.length) {
            return;
        }
        Point p = this.binLoci_[bin];
        g2d.setColor(Color.DARK_GRAY);
        g2d.fillRect(p.x - 1, p.y - 1, this.binInside_ + 2, this.binInside_ + 2);
        g2d.setColor(c);
        g2d.fillRect(p.x, p.y, this.binInside_, this.binInside_);
    }

    @Override
    public void colorTableChanged(ColorTableEvent e) {
        this.repaint();
    }

    class ToggleLabelsAction
    extends AbstractAction {
        ToggleLabelsAction() {
            super("toggle bin labels");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorTableGridPanel.this.binIdsVisible_ = !ColorTableGridPanel.this.binIdsVisible_;
            ColorTableGridPanel.this.repaint();
        }
    }

    private class BinMouseHandler
    extends MouseInputAdapter {
        BinMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ColorTableGridPanel.this.grabFocus();
            ColorTableGridPanel.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ColorTableGridPanel.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ColorTableGridPanel.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ColorTableGridPanel.this.grabFocus();
            ColorTableGridPanel.this.repaint();
        }
    }
}

