/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.cursor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.lang.invoke.MethodHandles;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CursorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object LOCK = new Object();
    private static final String HELP_32 = "help_32.png";
    private static final String ZOOMIN_32 = "zoomin_32.png";
    private static final String ZOOMOUT_32 = "zoomout_32.png";
    private static final String NOZOOM_32 = "nozoom_32.png";
    private static final String HELP_16 = "help_16.png";
    private static final String ZOOMIN_16 = "zoomin_16.png";
    private static final String ZOOMOUT_16 = "zoomout_16.png";
    private static final String NOZOOM_16 = "nozoom_16.png";
    private static final String HELP_NAME = "help";
    private static final String ZOOMIN_NAME = "zoom-in";
    private static final String ZOOMOUT_NAME = "zoom-out";
    private static final String NOZOOM_NAME = "no-zoom";
    private static final Dimension BEST_SIZE = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
    private static Cursor helpCursor;
    private static Cursor zoomInCursor;
    private static Cursor zoomOutCursor;
    private static Cursor noZoomCursor;

    public static void setDefaultCursor(Component c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void setCrosshairCursor(Component c) {
        c.setCursor(Cursor.getPredefinedCursor(1));
    }

    public static void setWaitCursor(Component c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setHelpCursor(Component c) {
        Object object = LOCK;
        synchronized (object) {
            if (helpCursor == null) {
                try {
                    String fname = CursorUtils.BEST_SIZE.width < 24 ? HELP_16 : HELP_32;
                    helpCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(CursorUtils.class.getResource(fname)).getImage(), new Point(2, 2), HELP_NAME);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        c.setCursor(helpCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setZoomInCursor(Component c) {
        Object object = LOCK;
        synchronized (object) {
            if (zoomInCursor == null) {
                try {
                    String fname = CursorUtils.BEST_SIZE.width < 24 ? ZOOMIN_16 : ZOOMIN_32;
                    zoomInCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(CursorUtils.class.getResource(fname)).getImage(), new Point(2, 2), ZOOMIN_NAME);
                }
                catch (Exception exc) {
                    LOGGER.debug("{}", (Object)exc.toString());
                }
            }
        }
        c.setCursor(zoomInCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setZoomOutCursor(Component c) {
        Object object = LOCK;
        synchronized (object) {
            if (zoomOutCursor == null) {
                try {
                    String fname = CursorUtils.BEST_SIZE.width < 24 ? ZOOMOUT_16 : ZOOMOUT_32;
                    zoomOutCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(CursorUtils.class.getResource(fname)).getImage(), new Point(2, 2), ZOOMOUT_NAME);
                }
                catch (Exception exc) {
                    LOGGER.debug("{}", (Object)exc.toString());
                }
            }
        }
        c.setCursor(zoomOutCursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNoZoomCursor(Component c) {
        Object object = LOCK;
        synchronized (object) {
            if (noZoomCursor == null) {
                try {
                    String fname = CursorUtils.BEST_SIZE.width < 24 ? NOZOOM_16 : NOZOOM_32;
                    noZoomCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(CursorUtils.class.getResource(fname)).getImage(), new Point(2, 2), NOZOOM_NAME);
                }
                catch (Exception exc) {
                    LOGGER.debug("{}", (Object)exc.toString());
                }
            }
        }
        c.setCursor(noZoomCursor);
    }

    private CursorUtils() {
    }
}

