/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.query;

import com.j256.ormlite.stmt.QueryBuilder;
import io.javalin.http.Context;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Orderable
extends LinkedHashMap<String, Boolean> {
    private final Map<String, String> dto2DatabaseNames = new HashMap<String, String>();

    public Orderable(Map<String, Boolean> def, Context ctx) {
        if (ctx != null && !ctx.queryParams("orderBy").isEmpty()) {
            this.appendOrders(ctx);
            for (Map.Entry<String, Boolean> entry : def.entrySet()) {
                this.putIfAbsent(entry.getKey(), entry.getValue());
            }
        } else {
            this.appendOrders(def);
        }
    }

    private Orderable appendOrders(String field, boolean asc) {
        this.put(field, asc);
        return this;
    }

    private Orderable appendOrders(Map<String, Boolean> fields) {
        this.putAll(fields);
        return this;
    }

    public Orderable addMapping(String nameForDatabase, String nameForDto) {
        this.dto2DatabaseNames.put(nameForDto, nameForDatabase);
        return this;
    }

    public Orderable addMappings(Map<String, String> dto2Databases) {
        this.dto2DatabaseNames.putAll(dto2Databases);
        return this;
    }

    private Orderable appendOrders(Context ctx) {
        for (String orderBy : ctx.queryParams("orderBy")) {
            String[] spilt = orderBy.split("\\|");
            if (spilt.length == 0) continue;
            String dtoName = spilt[0];
            boolean asc = spilt.length < 2 || !spilt[1].equalsIgnoreCase("desc") && !spilt[1].equalsIgnoreCase("descend");
            this.put(dtoName, asc);
        }
        return this;
    }

    public <T, ID> QueryBuilder<T, ID> apply(QueryBuilder<T, ID> queryBuilder) {
        for (Map.Entry entry : this.entrySet()) {
            queryBuilder.orderByRaw(this.dto2DatabaseNames.getOrDefault(entry.getKey(), (String)entry.getKey()) + " " + ((Boolean)entry.getValue() != false ? "ASC" : "DESC"));
        }
        return queryBuilder;
    }

    public String generateOrderBy() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(this.dto2DatabaseNames.getOrDefault(entry.getKey(), (String)entry.getKey())).append(" ").append((Boolean)entry.getValue() != false ? "ASC" : "DESC");
        }
        return sb.toString();
    }
}

