/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.maxmind.geoip2.WebServiceProvider;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.AuthenticationException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.exception.HttpException;
import com.maxmind.geoip2.exception.InvalidRequestException;
import com.maxmind.geoip2.exception.OutOfQueriesException;
import com.maxmind.geoip2.exception.PermissionRequiredException;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.InsightsResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebServiceClient
implements WebServiceProvider {
    private final String host;
    private final List<String> locales;
    private final String authHeader;
    private final boolean useHttps;
    private final int port;
    private final Duration requestTimeout;
    private final String userAgent = "GeoIP2/" + this.getClass().getPackage().getImplementationVersion() + " (Java/" + System.getProperty("java.version") + ")";
    private final ObjectMapper mapper;
    private final HttpClient httpClient;

    private WebServiceClient(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.useHttps = builder.useHttps;
        this.locales = builder.locales;
        this.authHeader = "Basic " + Base64.getEncoder().encodeToString((builder.accountId + ":" + builder.licenseKey).getBytes(StandardCharsets.UTF_8));
        this.mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).addModule((Module)new JavaTimeModule())).build();
        this.requestTimeout = builder.requestTimeout;
        this.httpClient = builder.httpClient != null ? builder.httpClient : HttpClient.newBuilder().connectTimeout(builder.connectTimeout).proxy(builder.proxy).build();
    }

    @Override
    public CountryResponse country() throws IOException, GeoIp2Exception {
        return this.country(null);
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("country", ipAddress, CountryResponse.class);
    }

    @Override
    public CityResponse city() throws IOException, GeoIp2Exception {
        return this.city(null);
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("city", ipAddress, CityResponse.class);
    }

    @Override
    public InsightsResponse insights() throws IOException, GeoIp2Exception {
        return this.insights(null);
    }

    @Override
    public InsightsResponse insights(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.responseFor("insights", ipAddress, InsightsResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T responseFor(String path, InetAddress ipAddress, Class<T> cls) throws IOException, GeoIp2Exception {
        URI uri = this.createUri(path, ipAddress);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(this.requestTimeout).header("Accept", "application/json").header("Authorization", this.authHeader).header("User-Agent", this.userAgent).GET().build();
        try {
            HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            try {
                T t = this.handleResponse(response, cls);
                return t;
            }
            finally {
                response.body().close();
            }
        }
        catch (InterruptedException e) {
            throw new GeoIp2Exception("Interrupted sending request", e);
        }
    }

    private <T> T handleResponse(HttpResponse<InputStream> response, Class<T> cls) throws GeoIp2Exception, IOException {
        int status = response.statusCode();
        URI uri = response.uri();
        if (status >= 400 && status < 500) {
            this.handle4xxStatus(response);
        } else {
            if (status >= 500 && status < 600) {
                this.exhaustBody(response);
                throw new HttpException("Received a server error (" + status + ") for " + String.valueOf(uri), status, uri);
            }
            if (status != 200) {
                this.exhaustBody(response);
                throw new HttpException("Received an unexpected HTTP status (" + status + ") for " + String.valueOf(uri), status, uri);
            }
        }
        InjectableValues.Std inject = new InjectableValues.Std().addValue("locales", this.locales);
        try {
            return (T)this.mapper.readerFor(cls).with((InjectableValues)inject).readValue(response.body());
        }
        catch (IOException e) {
            throw new GeoIp2Exception("Received a 200 response but could not decode it as JSON", e);
        }
    }

    private void handle4xxStatus(HttpResponse<InputStream> response) throws GeoIp2Exception, IOException {
        int status = response.statusCode();
        URI uri = response.uri();
        String body = WebServiceClient.readBody(response);
        if (body.isEmpty()) {
            throw new HttpException("Received a " + status + " error for " + String.valueOf(uri) + " with no body", status, uri);
        }
        try {
            HashMap content = (HashMap)this.mapper.readValue(body, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            WebServiceClient.handleErrorWithJsonBody(content, body, status, uri);
        }
        catch (HttpException e) {
            throw e;
        }
        catch (IOException e) {
            throw new HttpException("Received a " + status + " error for " + String.valueOf(uri) + " but it did not include the expected JSON body: " + body, status, uri);
        }
    }

    private static void handleErrorWithJsonBody(Map<String, String> content, String body, int status, URI uri) throws GeoIp2Exception, HttpException {
        String error = content.get("error");
        String code = content.get("code");
        if (error == null || code == null) {
            throw new HttpException("Error response contains JSON but it does not specify code or error keys: " + body, status, uri);
        }
        switch (code) {
            case "IP_ADDRESS_NOT_FOUND": 
            case "IP_ADDRESS_RESERVED": {
                throw new AddressNotFoundException(error);
            }
            case "ACCOUNT_ID_REQUIRED": 
            case "ACCOUNT_ID_UNKNOWN": 
            case "AUTHORIZATION_INVALID": 
            case "LICENSE_KEY_REQUIRED": 
            case "USER_ID_REQUIRED": 
            case "USER_ID_UNKNOWN": {
                throw new AuthenticationException(error);
            }
            case "INSUFFICIENT_FUNDS": 
            case "OUT_OF_QUERIES": {
                throw new OutOfQueriesException(error);
            }
            case "PERMISSION_REQUIRED": {
                throw new PermissionRequiredException(error);
            }
        }
        throw new InvalidRequestException(error, code, uri);
    }

    private URI createUri(String service, InetAddress ipAddress) throws GeoIp2Exception {
        String path = "/geoip/v2.1/" + service + "/" + (ipAddress == null ? "me" : ipAddress.getHostAddress());
        try {
            return new URI(this.useHttps ? "https" : "http", null, this.host, this.port, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new GeoIp2Exception("Syntax error creating service URL", e);
        }
    }

    private void exhaustBody(HttpResponse<InputStream> response) throws HttpException {
        try (InputStream body = response.body();){
            while (body.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new HttpException("Error reading response body", response.statusCode(), response.uri(), e);
        }
    }

    private static String readBody(HttpResponse<InputStream> response) throws IOException {
        try (InputStream bodyStream = response.body();){
            String string = new String(bodyStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public String toString() {
        return "WebServiceClient{host='" + this.host + "', locales=" + String.valueOf(this.locales) + ", useHttps=" + this.useHttps + ", port=" + this.port + ", requestTimeout=" + String.valueOf(this.requestTimeout) + ", userAgent='" + this.userAgent + "', mapper=" + String.valueOf(this.mapper) + ", httpClient=" + String.valueOf(this.httpClient) + "}";
    }

    public static final class Builder {
        final int accountId;
        final String licenseKey;
        String host = "geoip.maxmind.com";
        int port = 443;
        boolean useHttps = true;
        Duration connectTimeout = null;
        Duration requestTimeout = Duration.ofSeconds(20L);
        List<String> locales = List.of("en");
        private ProxySelector proxy = null;
        private HttpClient httpClient = null;

        public Builder(int accountId, String licenseKey) {
            this.accountId = accountId;
            this.licenseKey = licenseKey;
        }

        public Builder connectTimeout(Duration val) {
            this.connectTimeout = val;
            return this;
        }

        public Builder disableHttps() {
            this.useHttps = false;
            return this;
        }

        public Builder host(String val) {
            this.host = val;
            return this;
        }

        public Builder port(int val) {
            this.port = val;
            return this;
        }

        public Builder locales(List<String> val) {
            this.locales = List.copyOf(val);
            return this;
        }

        public Builder requestTimeout(Duration val) {
            this.requestTimeout = val;
            return this;
        }

        public Builder proxy(ProxySelector val) {
            this.proxy = val;
            return this;
        }

        public Builder httpClient(HttpClient val) {
            this.httpClient = val;
            return this;
        }

        public WebServiceClient build() {
            if (this.httpClient != null) {
                if (this.connectTimeout != null) {
                    throw new IllegalArgumentException("Cannot set both httpClient and connectTimeout. Configure timeout on the provided HttpClient instead.");
                }
                if (this.proxy != null) {
                    throw new IllegalArgumentException("Cannot set both httpClient and proxy. Configure proxy on the provided HttpClient instead.");
                }
            } else {
                if (this.connectTimeout == null) {
                    this.connectTimeout = Duration.ofSeconds(3L);
                }
                if (this.proxy == null) {
                    this.proxy = ProxySelector.getDefault();
                }
            }
            return new WebServiceClient(this);
        }
    }
}

