/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.btn.ping.BtnSwarm;
import com.ghostchu.peerbanhelper.btn.ping.BtnSwarmPeerPing;
import com.ghostchu.peerbanhelper.database.dao.impl.MetadataDao;
import com.ghostchu.peerbanhelper.database.dao.impl.tmp.TrackedSwarmDao;
import com.ghostchu.peerbanhelper.database.table.tmp.TrackedSwarmEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.gson.JsonObject;
import com.j256.ormlite.dao.CloseableWrappedIterable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilitySubmitSwarm
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilitySubmitSwarm.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final String endpoint;
    private final long randomInitialDelay;
    private final MetadataDao metadataDao;
    private final TrackedSwarmDao swarmDao;
    private final boolean powCaptcha;

    public BtnAbilitySubmitSwarm(BtnNetwork btnNetwork, JsonObject ability, MetadataDao metadataDao, TrackedSwarmDao swarmDao) {
        this.btnNetwork = btnNetwork;
        this.metadataDao = metadataDao;
        this.swarmDao = swarmDao;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
    }

    @Override
    public String getName() {
        return "BtnAbilitySubmitSwarm";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_SWARM);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_SUBMIT_SWARM_DESCRIPTION);
    }

    @Override
    public void load() {
        Main.getEventBus().register((Object)this);
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_NO_CONTENT_REPORTED_YET));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::submit, ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unload() {
        Main.getEventBus().unregister((Object)this);
    }

    private int setMemCursor(long position) {
        return this.metadataDao.set("BtnAbilitySubmitSwarm.memCursor", String.valueOf(position));
    }

    private long getMemCursor() {
        return Long.parseLong(this.metadataDao.getOrDefault("BtnAbilitySubmitSwarm.memCursor", "0"));
    }

    private void submit() {
        try {
            log.info(TextManager.tlUI(Lang.BTN_SUBMITTING_SWARM, new Object[0]));
            this.swarmDao.flushAll();
            int size = 0;
            int requests = 0;
            ArrayList<TrackedSwarmEntity> trackedSwarmEntities = new ArrayList<TrackedSwarmEntity>(500);
            try (CloseableWrappedIterable<TrackedSwarmEntity> it = this.createSubmitIterator(this.getMemCursor());){
                for (TrackedSwarmEntity entity : it) {
                    trackedSwarmEntities.add(entity);
                    if (trackedSwarmEntities.size() < 500) continue;
                    this.setMemCursor(this.createSubmitRequest(trackedSwarmEntities).getTime());
                    ++requests;
                    size += trackedSwarmEntities.size();
                    trackedSwarmEntities.clear();
                }
            }
            if (!trackedSwarmEntities.isEmpty()) {
                this.setMemCursor(this.createSubmitRequest(trackedSwarmEntities).getTime());
                ++requests;
                size += trackedSwarmEntities.size();
            }
            log.info(TextManager.tlUI(Lang.BTN_SUBMITTED_SWARM, size, requests));
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_REPORTED_DATA, size));
        }
        catch (IllegalStateException size) {
        }
        catch (Throwable e) {
            log.error(TextManager.tlUI(Lang.BTN_UNKNOWN_ERROR, new Object[0]), e);
            this.setLastStatus(false, new TranslationComponent(Lang.BTN_UNKNOWN_ERROR, e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    private CloseableWrappedIterable<TrackedSwarmEntity> createSubmitIterator(long memCursor) throws SQLException {
        return this.swarmDao.getWrappedIterable(this.swarmDao.queryBuilder().where().gt("lastTimeSeen", (Object)memCursor).queryBuilder().orderBy("lastTimeSeen", true).prepare());
    }

    private Timestamp createSubmitRequest(List<TrackedSwarmEntity> swarmEntities) throws RuntimeException {
        Timestamp timestamp;
        block10: {
            BtnSwarmPeerPing ping = new BtnSwarmPeerPing(swarmEntities.stream().map(BtnSwarm::from).toList());
            byte[] jsonBytes = JsonUtil.getGson().toJson((Object)ping).getBytes(StandardCharsets.UTF_8);
            RequestBody body = this.createGzipRequestBody(jsonBytes);
            Request.Builder request = new Request.Builder().url(this.endpoint).post(body).header("Content-Encoding", "gzip");
            if (this.powCaptcha) {
                this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "submit_swarm");
            }
            Response resp = this.btnNetwork.getHttpClient().newCall(request.build()).execute();
            try {
                if (resp.code() < 200 || resp.code() >= 400) {
                    String responseBody = resp.body().string();
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, resp.code() + " - " + responseBody));
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, resp.code(), responseBody));
                    throw new IllegalStateException(TextManager.tlUI(new TranslationComponent(Lang.BTN_HTTP_ERROR, resp.code(), responseBody)));
                }
                timestamp = swarmEntities.getLast().getLastTimeSeen();
                if (resp == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, e.getMessage()), (Throwable)e);
                    this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, -1, e.getMessage()));
                    throw new IllegalStateException(TextManager.tlUI(new TranslationComponent(Lang.BTN_HTTP_ERROR, -1, e.getMessage())), e);
                }
            }
            resp.close();
        }
        return timestamp;
    }

    private RequestBody createGzipRequestBody(final byte[] data) {
        return new RequestBody(this){
            {
                Objects.requireNonNull(this$0);
            }

            public MediaType contentType() {
                return MediaType.get((String)"application/json");
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                gzipSink.write(data);
                gzipSink.close();
            }
        };
    }
}

