/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.config;

import com.ghostchu.peerbanhelper.config.UpdateScript;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.InvalidConfigurationException;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PBHConfigUpdater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHConfigUpdater.class);
    private static final String CONFIG_VERSION_KEY = "config-version";
    private final YamlConfiguration yaml;
    private final YamlConfiguration bundle;
    private final File file;

    public PBHConfigUpdater(File file, YamlConfiguration yaml, InputStream resourceAsStream) {
        this.yaml = yaml;
        this.file = file;
        this.bundle = new YamlConfiguration();
        try (InputStream inputStream = resourceAsStream;
             InputStreamReader reader = new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8);){
            this.bundle.loadFromString(CharStreams.toString((Readable)reader));
        }
        catch (IOException | InvalidConfigurationException e) {
            log.error("Unable to load the bundled config from classloader resource", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@NotNull Object configUpdateScript) {
        log.info("Checking if configuration {} needs any upgrade...", (Object)configUpdateScript.getClass().getName());
        boolean anyUpgradeExecuted = false;
        int selectedVersion = this.yaml.getInt(CONFIG_VERSION_KEY, -1);
        String oldContent = this.yaml.saveToString();
        for (Method method : this.getUpdateScripts(configUpdateScript)) {
            try {
                UpdateScript updateScript = method.getAnnotation(UpdateScript.class);
                int current = this.yaml.getInt(CONFIG_VERSION_KEY);
                if (current >= updateScript.version()) continue;
                log.info("Upgrading configuration from {} to {}...", (Object)current, (Object)updateScript.version());
                String scriptName = updateScript.description();
                if (scriptName == null || scriptName.isEmpty()) {
                    scriptName = method.getName();
                }
                log.info("Executing upgrade script: {}", (Object)scriptName);
                try {
                    if (method.getParameterCount() == 0) {
                        method.invoke(configUpdateScript, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == YamlConfiguration.class) {
                        method.invoke(configUpdateScript, this.bundle);
                    }
                }
                catch (Exception e) {
                    log.info("Error while executing upgrade script: method={}, target_ver={}", new Object[]{method.getName(), updateScript.version(), e});
                }
                finally {
                    anyUpgradeExecuted = true;
                }
                this.yaml.set(CONFIG_VERSION_KEY, (Object)updateScript.version());
                log.info("Configuration successfully updated");
            }
            catch (Throwable throwable) {
                log.error("Error while updating configuration, method={}, target_ver={}", new Object[]{method.getName(), method.getAnnotation(UpdateScript.class).version(), throwable});
            }
        }
        if (anyUpgradeExecuted) {
            log.info("Saving configuration changes for {}...", (Object)configUpdateScript.getClass().getName());
            try {
                this.migrateComments(this.yaml, this.bundle);
                String newContent = this.yaml.saveToString();
                if (!newContent.equals(oldContent)) {
                    this.yaml.save(this.file);
                }
            }
            catch (IOException e) {
                log.error("Failed to save configuration!", (Throwable)e);
            }
        }
    }

    private void migrateComments(YamlConfiguration yaml, YamlConfiguration bundle) {
        for (String key : yaml.getKeys(true)) {
            List inlineBundled = bundle.getInlineComments(key);
            List inlineYaml = yaml.getInlineComments(key);
            List stdBundled = bundle.getComments(key);
            List stdYaml = yaml.getComments(key);
            if (inlineYaml.isEmpty() && !inlineBundled.isEmpty()) {
                yaml.setInlineComments(key, inlineBundled);
            }
            if (!stdYaml.isEmpty() || stdBundled.isEmpty()) continue;
            yaml.setComments(key, stdBundled);
        }
    }

    @NotNull
    public List<Method> getUpdateScripts(@NotNull Object configUpdateScript) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method declaredMethod : configUpdateScript.getClass().getDeclaredMethods()) {
            if (declaredMethod.getAnnotation(UpdateScript.class) == null) continue;
            methods.add(declaredMethod);
        }
        methods.sort(Comparator.comparingInt(o -> o.getAnnotation(UpdateScript.class).version()));
        return methods;
    }
}

