/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.ScriptStorageEntity;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ScriptStorageDao
extends AbstractPBHDao<ScriptStorageEntity, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptStorageDao.class);

    public ScriptStorageDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, ScriptStorageEntity.class);
    }

    public void put(String key, String value) {
        ScriptStorageEntity entity = new ScriptStorageEntity(key, value);
        try {
            this.createOrUpdate(entity);
        }
        catch (SQLException e) {
            log.warn("Unable to create/update script storage entity", (Throwable)e);
        }
    }

    public String get(String key) {
        try {
            ScriptStorageEntity entity = (ScriptStorageEntity)this.queryForId(key);
            if (entity != null) {
                return entity.getValue();
            }
            return null;
        }
        catch (SQLException e) {
            log.warn("Unable to get script storage entity", (Throwable)e);
            return null;
        }
    }

    public List<String> keys(long offset, long limit) {
        try {
            return this.queryBuilder().offset(Long.valueOf(offset)).limit(Long.valueOf(limit)).query().stream().map(ScriptStorageEntity::getKey).toList();
        }
        catch (SQLException e) {
            log.warn("Unable to get script storage keys", (Throwable)e);
            return List.of();
        }
    }

    public List<String> values(long offset, long limit) {
        try {
            return this.queryBuilder().offset(Long.valueOf(offset)).limit(Long.valueOf(limit)).query().stream().map(ScriptStorageEntity::getValue).toList();
        }
        catch (SQLException e) {
            log.warn("Unable to get script storage values", (Throwable)e);
            return List.of();
        }
    }

    public List<String> keysStartWith(String prefix) {
        try {
            return this.query(this.queryBuilder().where().like("key", (Object)new SelectArg((Object)(prefix + "%"))).prepare()).stream().map(ScriptStorageEntity::getKey).toList();
        }
        catch (SQLException e) {
            log.warn("Unable to get script storage keys", (Throwable)e);
            return List.of();
        }
    }

    public List<String> valuesStartWith(String prefix) {
        try {
            return this.queryBuilder().where().like("value", (Object)new SelectArg((Object)(prefix + "%"))).query().stream().map(ScriptStorageEntity::getValue).toList();
        }
        catch (SQLException e) {
            log.warn("Unable to get script storage values", (Throwable)e);
            return List.of();
        }
    }

    public Map<String, String> entries(long offset, long limit) {
        try {
            return this.queryBuilder().offset(Long.valueOf(offset)).limit(Long.valueOf(limit)).query().stream().collect(Collectors.toMap(ScriptStorageEntity::getKey, ScriptStorageEntity::getValue, (existing, replacement) -> {
                log.warn("Duplicate key found: {}", existing);
                return replacement;
            }));
        }
        catch (SQLException e) {
            log.warn("Unable to get script storage entries", (Throwable)e);
            return Map.of();
        }
    }
}

