/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.bittorrent.peer.PeerFlag;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerConnectionMetricDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerRecordDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TrafficJournalDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.database.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.ActiveMonitoringModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerConnectionMetricsDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SimpleLongIntKVDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.SimpleStringIntKVDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.peerbanhelper.util.WebUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDB;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHChartController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHChartController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private PeerRecordDao peerRecordDao;
    @Autowired
    private HistoryDao historyDao;
    @Autowired
    private TrafficJournalDao trafficJournalDao;
    @Autowired
    private IPDBManager iPDBManager;
    @Autowired
    private ActiveMonitoringModule activeMonitoringModule;
    @Autowired
    private PeerConnectionMetricDao peerConnectionMetricDao;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Charts";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-charts";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/chart/geoIpInfo", this::handleGeoIP, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/trend", this::handlePeerTrends, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/traffic", this::handleTrafficClassic, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/sessionBetween", this::handleSessionBetween, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/sessionDayBucket", this::handleSessionAnalyse, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/sessionAnalyse", this::handleSessionAnalyse, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/chart/clientAnalyse", this::handleClientAnalyse, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS});
    }

    private void handleClientAnalyse(@NotNull Context ctx) throws Exception {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        Pageable pageable = new Pageable(ctx);
        Orderable orderable = new Orderable(Map.of("uploaded", false), ctx);
        String generatedOrderBy = "ORDER BY " + orderable.generateOrderBy();
        try (GenericRawResults r = this.peerRecordDao.queryRaw("SELECT peerId, clientName, SUM(uploaded) AS uploaded, SUM(downloaded) AS downloaded, COUNT(*) AS count\nFROM peer_records\nWHERE firstTimeSeen >= ? AND lastTimeSeen <= ? AND uploaded != 0 AND downloaded != 0\n  AND (? IS NULL OR ? = '' OR downloader = ?)\nGROUP BY peerId, clientName\n%s\nLIMIT %s OFFSET %s\n".formatted(generatedOrderBy, pageable.getSize(), pageable.getZeroBasedPage() * pageable.getSize()), new String[]{String.valueOf(timeQueryModel.startAt().getTime()), String.valueOf(timeQueryModel.endAt()), downloader, downloader, downloader});
             GenericRawResults ct = this.peerRecordDao.queryRaw("SELECT COUNT(*)\nFROM (\n    SELECT 1\n    FROM peer_records\n    WHERE firstTimeSeen >= ? AND lastTimeSeen <= ? AND uploaded != 0 AND downloaded != 0\n      AND (? IS NULL OR ? = '' OR downloader = ?)\n    GROUP BY peerId, clientName\n) AS grouped_records\n", new String[]{String.valueOf(timeQueryModel.startAt().getTime()), String.valueOf(timeQueryModel.endAt()), downloader, downloader, downloader});){
            ArrayList<ClientAnalyseDTO> rList = new ArrayList<ClientAnalyseDTO>();
            for (String[] row : r.getResults()) {
                String peerId = row[0];
                String clientName = row[1];
                long uploaded = Long.parseLong(row[2]);
                long downloaded = Long.parseLong(row[3]);
                long count = Long.parseLong(row[4]);
                rList.add(new ClientAnalyseDTO(peerId, clientName, uploaded, downloaded, count));
            }
            long ctr = Long.parseLong(((String[])ct.getFirstResult())[0]);
            ctx.json((Object)new StdResp(true, null, new Page(pageable, ctr, rList)));
        }
    }

    private void handleSessionAnalyse(@NotNull Context ctx) {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        List<PeerConnectionMetricsDTO> data = this.peerConnectionMetricDao.getMetricsSince(timeQueryModel.startAt(), timeQueryModel.endAt(), downloader);
        ctx.json((Object)new StdResp(true, null, data));
    }

    private void handleSessionBetween(@NotNull Context ctx) throws SQLException {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        if (downloader == null || downloader.isBlank()) {
            downloader = "%";
        }
        ctx.json((Object)new StdResp(true, null, this.peerRecordDao.sessionBetween(downloader, timeQueryModel.startAt(), timeQueryModel.endAt())));
    }

    private void handleSessionDayBucket(@NotNull Context ctx) throws Exception {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        long startAtTs = timeQueryModel.startAt().getTime();
        long endAtTs = timeQueryModel.endAt().getTime();
        LinkedHashMap<Long, SessionTimeRangeCounter> sessionDayBucket = new LinkedHashMap<Long, SessionTimeRangeCounter>();
        Where where = this.peerRecordDao.queryBuilder().where();
        if (downloader != null) {
            where.eq("downloader", (Object)downloader).and().ge("firstTimeSeen", (Object)startAtTs).and().le("lastTimeSeen", (Object)endAtTs);
        } else {
            where.ge("firstTimeSeen", (Object)startAtTs).and().le("lastTimeSeen", (Object)endAtTs);
        }
        LinkedHashSet peerRecords = new LinkedHashSet(where.query());
        for (PeerRecordEntity record : peerRecords) {
            long firstDay = MiscUtil.getStartOfToday(record.getFirstTimeSeen().getTime());
            long lastDay = MiscUtil.getStartOfToday(record.getLastTimeSeen().getTime());
            for (long day = firstDay; day <= lastDay; day += 86400000L) {
                if (day < startAtTs || day > endAtTs) continue;
                SessionTimeRangeCounter counter = sessionDayBucket.computeIfAbsent(day, k -> new SessionTimeRangeCounter());
                counter.getTotal().incrementAndGet();
                if (!StringUtils.isNotBlank((CharSequence)record.getLastFlags()) || new PeerFlag(record.getLastFlags()).isLocalConnection()) continue;
                counter.getIncoming().incrementAndGet();
            }
        }
        ctx.json((Object)new StdResp(true, null, sessionDayBucket.entrySet().stream().map(e -> new SessionDayBucketDTO((Long)e.getKey(), ((SessionTimeRangeCounter)e.getValue()).total.intValue(), ((SessionTimeRangeCounter)e.getValue()).incoming.intValue())).sorted(Comparator.comparingLong(SessionDayBucketDTO::key)).toList()));
    }

    private void handleTraffic(Context ctx) throws Exception {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        if (downloader == null || downloader.isBlank()) {
            ctx.json((Object)new StdResp(true, null, this.fixTimezone(ctx, this.trafficJournalDao.getAllDownloadersOverallData(timeQueryModel.startAt(), timeQueryModel.endAt()))));
        } else {
            ctx.json((Object)new StdResp(true, null, this.fixTimezone(ctx, this.trafficJournalDao.getSpecificDownloaderOverallData(downloader, timeQueryModel.startAt(), timeQueryModel.endAt()))));
        }
    }

    private void handleTrafficClassic(Context ctx) throws Exception {
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        String downloader = ctx.queryParam("downloader");
        List<TrafficJournalDao.TrafficDataComputed> records = this.trafficJournalDao.getDayOffsetData(downloader, timeQueryModel.startAt(), timeQueryModel.endAt());
        HashMap<Long, TrafficJournalDao.TrafficDataComputed> mergedData = new HashMap<Long, TrafficJournalDao.TrafficDataComputed>();
        for (TrafficJournalDao.TrafficDataComputed record : records) {
            Timestamp ts = record.getTimestamp();
            long dayStart = MiscUtil.getStartOfToday(ts.getTime());
            mergedData.compute(dayStart, (key, existing) -> {
                if (existing == null) {
                    return new TrafficJournalDao.TrafficDataComputed(new Timestamp((long)key), record.getDataOverallUploaded(), record.getDataOverallDownloaded());
                }
                existing.setDataOverallUploaded(existing.getDataOverallUploaded() + record.getDataOverallUploaded());
                existing.setDataOverallDownloaded(existing.getDataOverallDownloaded() + record.getDataOverallDownloaded());
                return existing;
            });
        }
        ArrayList mergedRecords = new ArrayList(mergedData.values());
        mergedRecords.sort(Comparator.comparing(data -> data.getTimestamp().getTime()));
        ctx.json((Object)new StdResp(true, null, mergedRecords));
    }

    private TrafficJournalDao.TrafficDataComputed fixTimezone(Context ctx, TrafficJournalDao.TrafficDataComputed data) {
        Timestamp ts = data.getTimestamp();
        long epochSecond = ts.toLocalDateTime().atZone(this.timezone(ctx).toZoneId().getRules().getOffset(Instant.now())).truncatedTo(ChronoUnit.DAYS).toEpochSecond();
        data.setTimestamp(new Timestamp(epochSecond * 1000L));
        return data;
    }

    private List<TrafficJournalDao.TrafficDataComputed> fixTimezone(Context ctx, List<TrafficJournalDao.TrafficDataComputed> data) {
        data.forEach(d -> this.fixTimezone(ctx, (TrafficJournalDao.TrafficDataComputed)d));
        return data;
    }

    private void handlePeerTrends(Context ctx) throws Exception {
        long startOfDay;
        String downloader = ctx.queryParam("downloader");
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        ConcurrentHashMap<Long, AtomicInteger> connectedPeerTrends = new ConcurrentHashMap<Long, AtomicInteger>();
        ConcurrentHashMap<Long, AtomicInteger> bannedPeerTrends = new ConcurrentHashMap<Long, AtomicInteger>();
        Where queryConnected = this.peerRecordDao.queryBuilder().selectColumns(new String[]{"id", "lastTimeSeen"}).where().ge("lastTimeSeen", (Object)timeQueryModel.startAt()).and().le("lastTimeSeen", (Object)timeQueryModel.endAt());
        Where queryBanned = this.historyDao.queryBuilder().selectColumns(new String[]{"id", "banAt"}).where().ge("banAt", (Object)timeQueryModel.startAt()).and().le("banAt", (Object)timeQueryModel.endAt());
        if (downloader != null && !downloader.isBlank()) {
            queryConnected.and().eq("downloader", (Object)new SelectArg((Object)downloader));
            queryBanned.and().eq("downloader", (Object)new SelectArg((Object)downloader));
        }
        try (CloseableIterator it = queryConnected.iterator();){
            while (it.hasNext()) {
                startOfDay = MiscUtil.getStartOfToday(((PeerRecordEntity)it.next()).getLastTimeSeen().getTime());
                connectedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
            }
        }
        it = queryBanned.iterator();
        try {
            while (it.hasNext()) {
                startOfDay = MiscUtil.getStartOfToday(((HistoryEntity)it.next()).getBanAt().getTime());
                bannedPeerTrends.computeIfAbsent(startOfDay, k -> new AtomicInteger()).addAndGet(1);
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        ctx.json((Object)new StdResp(true, null, Map.of("connectedPeersTrend", connectedPeerTrends.entrySet().stream().map(e -> new SimpleLongIntKVDTO((Long)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted(Comparator.comparingLong(SimpleLongIntKVDTO::key)).toList(), "bannedPeersTrend", bannedPeerTrends.entrySet().stream().map(e -> new SimpleLongIntKVDTO((Long)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted(Comparator.comparingLong(SimpleLongIntKVDTO::key)).toList())));
    }

    private void handleGeoIP(Context ctx) throws Exception {
        IPDB ipdb = this.iPDBManager.getIpdb();
        if (ipdb == null) {
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.CHARTS_IPDB_NEED_INIT, new Object[0]), null));
            return;
        }
        WebUtil.TimeQueryModel timeQueryModel = WebUtil.parseTimeQueryModel(ctx);
        final boolean bannedOnly = Boolean.parseBoolean(ctx.queryParam("bannedOnly"));
        String downloader = ctx.queryParam("downloader");
        ConcurrentHashMap ispCounter = new ConcurrentHashMap();
        ConcurrentHashMap cnProvinceCounter = new ConcurrentHashMap();
        ConcurrentHashMap cnCityCounter = new ConcurrentHashMap();
        ConcurrentHashMap countryOrRegionCounter = new ConcurrentHashMap();
        ConcurrentHashMap netTypeCounter = new ConcurrentHashMap();
        Where queryBanned = this.historyDao.queryBuilder().distinct().selectColumns(new String[]{"id", "ip"}).where().ge("banAt", (Object)timeQueryModel.startAt()).and().le("banAt", (Object)timeQueryModel.endAt());
        Where queryConnected = this.peerRecordDao.queryBuilder().distinct().selectColumns(new String[]{"id", "address"}).where().ge("lastTimeSeen", (Object)timeQueryModel.startAt()).and().le("lastTimeSeen", (Object)timeQueryModel.endAt());
        if (downloader != null && !downloader.isBlank()) {
            queryBanned.and().eq("downloader", (Object)new SelectArg((Object)downloader));
            queryConnected.and().eq("downloader", (Object)new SelectArg((Object)downloader));
        }
        try (final CloseableIterator itBanned = queryBanned.iterator();
             final CloseableIterator itConnected = queryConnected.iterator();
             ExecutorService service = Executors.newWorkStealingPool();){
            var ipIterator = new Iterator<String>(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean hasNext() {
                    return bannedOnly ? itBanned.hasNext() : itConnected.hasNext();
                }

                @Override
                public String next() {
                    return bannedOnly ? ((HistoryEntity)itBanned.next()).getIp() : ((PeerRecordEntity)itConnected.next()).getAddress();
                }
            };
            while (ipIterator.hasNext()) {
                String ip = ipIterator.next();
                service.submit(() -> {
                    try {
                        String determindIp = ip;
                        if (IPAddressUtil.getIPAddress(determindIp).isPrefixed()) {
                            determindIp = IPAddressUtil.getIPAddress(determindIp).toPrefixBlock().getLower().withoutPrefixLength().toNormalizedString();
                        }
                        IPGeoData ipGeoData = ipdb.query(InetAddress.getByName(determindIp));
                        String isp = "N/A";
                        if (ipGeoData.getAs() != null) {
                            isp = ipGeoData.getAs().getOrganization();
                        }
                        String countryOrRegion = "N/A";
                        String province = "N/A";
                        Object city = "N/A";
                        String netType = "N/A";
                        if (ipGeoData.getCountry() != null) {
                            countryOrRegion = ipGeoData.getCountry().getName();
                        }
                        if (ipGeoData.getCity() != null) {
                            city = ipGeoData.getCity().getName();
                            if (ipGeoData.getCity().getCnProvince() != null) {
                                province = ipGeoData.getCity().getCnProvince();
                            }
                            if (ipGeoData.getCity().getCnCity() != null) {
                                city = ipGeoData.getCity().getCnProvince() + " " + ipGeoData.getCity().getCnCity();
                            }
                        }
                        if (ipGeoData.getNetwork() != null) {
                            isp = ipGeoData.getNetwork().getIsp();
                            netType = ipGeoData.getNetwork().getNetType();
                        }
                        ispCounter.computeIfAbsent(isp, k -> new AtomicInteger()).incrementAndGet();
                        cnProvinceCounter.computeIfAbsent(province, k -> new AtomicInteger()).incrementAndGet();
                        cnCityCounter.computeIfAbsent(city, k -> new AtomicInteger()).incrementAndGet();
                        countryOrRegionCounter.computeIfAbsent(countryOrRegion, k -> new AtomicInteger()).incrementAndGet();
                        netTypeCounter.computeIfAbsent(netType, k -> new AtomicInteger()).incrementAndGet();
                    }
                    catch (UnknownHostException e) {
                        log.error("Unable to resolve the GeoIP data for ip {}", (Object)ip, (Object)e);
                    }
                });
            }
        }
        ctx.json((Object)new StdResp(true, null, Map.of("isp", ispCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList(), "province", cnProvinceCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList(), "region", countryOrRegionCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList(), "city", cnCityCounter.entrySet().stream().map(e -> new SimpleStringIntKVDTO((String)e.getKey(), ((AtomicInteger)e.getValue()).intValue())).sorted((o1, o2) -> Integer.compare(o2.value(), o1.value())).toList())));
    }

    @Override
    public void onDisable() {
    }

    static class ClientAnalyseDTO {
        public String peerId;
        public String clientName;
        public long uploaded;
        public long downloaded;
        public long count;

        public ClientAnalyseDTO(String peerId, String clientName, long uploaded, long downloaded, long count) {
            this.peerId = peerId;
            this.clientName = clientName;
            this.uploaded = uploaded;
            this.downloaded = downloaded;
            this.count = count;
        }
    }

    private static class SessionTimeRangeCounter {
        private final AtomicInteger total = new AtomicInteger(0);
        private final AtomicInteger incoming = new AtomicInteger(0);

        private SessionTimeRangeCounter() {
        }

        @Generated
        public AtomicInteger getTotal() {
            return this.total;
        }

        @Generated
        public AtomicInteger getIncoming() {
            return this.incoming;
        }
    }

    public record SessionDayBucketDTO(long key, long total, long incoming) {
    }

    record TrafficJournalRecord(long timestamp, long uploaded, long downloaded) {
    }

    record SimpleLongLongKV(long key, long value) {
    }
}

