/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util;

import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.Objects;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.springframework.stereotype.Component;

@Component
public final class MemoryMonitor {
    private static final long MB = 0x100000L;
    private static long maxHeapMB;

    public MemoryMonitor(final AlertManager alertManager) {
        try {
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            MemoryPoolMXBean poolToMonitor = null;
            long ptmSize = 0L;
            long overallMax = 0L;
            for (MemoryPoolMXBean pool : pools) {
                long max;
                long poolMax = pool.getUsage().getMax();
                if (poolMax > 0L && pool.getType() == MemoryType.HEAP) {
                    overallMax += poolMax;
                }
                if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported() || (max = pool.getUsage().getMax()) <= ptmSize) continue;
                poolToMonitor = pool;
                ptmSize = max;
            }
            maxHeapMB = (overallMax + 0x100000L - 1L) / 0x100000L;
            if (poolToMonitor != null) {
                long threshold = poolToMonitor.getUsage().getMax() * 3L / 4L;
                threshold = Math.min(threshold, 0x500000L);
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                NotificationEmitter emitter = (NotificationEmitter)((Object)memoryMXBean);
                emitter.addNotificationListener(new NotificationListener(){
                    private long lastMBLog;
                    {
                        Objects.requireNonNull(this$0);
                        this.lastMBLog = Long.MAX_VALUE;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        MemoryPoolMXBean pool = (MemoryPoolMXBean)handback;
                        long used = pool.getCollectionUsage().getUsed();
                        long max = pool.getUsage().getMax();
                        long available = Math.max(0L, max - used);
                        long mbAvailable = (available + 0x100000L - 1L) / 0x100000L;
                        if (mbAvailable <= 4L) {
                            1 var12_8 = this;
                            synchronized (var12_8) {
                                if (mbAvailable >= this.lastMBLog) {
                                    return;
                                }
                                this.lastMBLog = mbAvailable;
                            }
                            alertManager.publishAlert(true, AlertLevel.FATAL, "outofmemory", new TranslationComponent(Lang.PROGRAM_OUT_OF_MEMORY_TITLE), new TranslationComponent(Lang.PROGRAM_OUT_OF_MEMORY_DESCRIPTION, mbAvailable == 0L ? "< 0" : Long.valueOf(mbAvailable), maxHeapMB));
                        }
                    }
                }, null, poolToMonitor);
                poolToMonitor.setCollectionUsageThreshold(threshold);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (maxHeapMB == 0L) {
            maxHeapMB = (Runtime.getRuntime().maxMemory() + 0x100000L - 1L) / 0x100000L;
        }
    }

    public long getMaxHeapMB() {
        return maxHeapMB;
    }
}

