/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.ipdb;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBDownloadSource;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.maxmind.db.CacheKey;
import com.maxmind.db.DecodedValue;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IPDB
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IPDB.class);
    private final long updateInterval = 3888000000L;
    private final File directory;
    private final File mmdbCityFile;
    private final File mmdbASNFile;
    private final boolean autoUpdate;
    private final File mmdbGeoCNFile;
    private final OkHttpClient httpClient;
    private final HTTPUtil httpUtil;
    private DatabaseReader mmdbCity;
    private DatabaseReader mmdbASN;
    private Reader geoCN;
    private List<String> languageTag;

    public IPDB(File dataFolder, String accountId, String licenseKey, String databaseCity, String databaseASN, boolean autoUpdate, String userAgent, HTTPUtil httpUtil) throws IllegalArgumentException, IOException {
        this.directory = new File(dataFolder, "geoip");
        this.directory.mkdirs();
        this.mmdbCityFile = new File(this.directory, "GeoIP-City.mmdb");
        this.mmdbASNFile = new File(this.directory, "GeoIP-ASN.mmdb");
        this.mmdbGeoCNFile = new File(this.directory, "GeoCN.mmdb");
        this.autoUpdate = autoUpdate;
        this.httpUtil = httpUtil;
        this.httpClient = httpUtil.addProgressTracker(httpUtil.newBuilder().connectTimeout(Duration.ofSeconds(15L)).readTimeout(Duration.ofMinutes(3L)).callTimeout(Duration.ofMinutes(3L)).followRedirects(true).authenticator((route, response) -> {
            if (response.request().header("Authorization") != null) {
                return null;
            }
            String credential = Credentials.basic((String)accountId, (String)licenseKey);
            return response.request().newBuilder().header("Authorization", credential).build();
        })).build();
        if (this.needUpdateMMDB(this.mmdbCityFile)) {
            this.updateMMDB(databaseCity, this.mmdbCityFile);
        }
        if (this.needUpdateMMDB(this.mmdbASNFile)) {
            this.updateMMDB(databaseASN, this.mmdbASNFile);
        }
        if (this.needUpdateMMDB(this.mmdbGeoCNFile)) {
            this.updateGeoCN(this.mmdbGeoCNFile);
        }
        this.loadMMDB();
    }

    public IPGeoData query(InetAddress address) {
        String iso;
        IPGeoData geoData = new IPGeoData();
        geoData.setAs(this.queryAS(address));
        geoData.setCountry(this.queryCountry(address));
        geoData.setCity(this.queryCity(address));
        geoData.setNetwork(this.queryNetwork(address));
        if (geoData.getCountry() != null && geoData.getCountry().getIso() != null && ((iso = geoData.getCountry().getIso()).equalsIgnoreCase("CN") || iso.equalsIgnoreCase("TW") || iso.equalsIgnoreCase("HK") || iso.equalsIgnoreCase("MO"))) {
            this.queryGeoCN(address, geoData);
        }
        return geoData;
    }

    private void queryGeoCN(InetAddress address, IPGeoData geoData) {
        try {
            CNLookupResult cnLookupResult = (CNLookupResult)this.geoCN.get(address, CNLookupResult.class);
            if (cnLookupResult == null) {
                return;
            }
            IPGeoData.CityData cityResponse = Objects.requireNonNullElse(geoData.getCity(), new IPGeoData.CityData());
            String cityName = (cnLookupResult.getProvince() + " " + cnLookupResult.getCity() + " " + cnLookupResult.getDistricts()).trim();
            if (!cityName.isBlank()) {
                cityResponse.setName(cityName);
            }
            Integer code = null;
            if (cnLookupResult.getProvinceCode() != null) {
                code = cnLookupResult.getProvinceCode().intValue();
            }
            if (cnLookupResult.getCityCode() != null) {
                code = cnLookupResult.getCityCode().intValue();
            }
            if (cnLookupResult.getDistrictsCode() != null) {
                code = cnLookupResult.getDistrictsCode().intValue();
            }
            cityResponse.setIso(Long.parseLong("86" + code));
            cityResponse.setCnProvince(cnLookupResult.getProvince());
            cityResponse.setCnCity(cnLookupResult.getCity());
            cityResponse.setCnDistricts(cnLookupResult.getDistricts());
            geoData.setCity(cityResponse);
            IPGeoData.NetworkData networkData = Objects.requireNonNullElse(geoData.getNetwork(), new IPGeoData.NetworkData());
            if (cnLookupResult.getIsp() != null && !cnLookupResult.getIsp().isBlank()) {
                networkData.setIsp(cnLookupResult.getIsp());
            }
            if (cnLookupResult.getNet() != null && !cnLookupResult.getNet().isBlank()) {
                TranslationComponent component = new TranslationComponent(cnLookupResult.getNet());
                switch (cnLookupResult.getNet()) {
                    case "\u5bbd\u5e26": {
                        new TranslationComponent(Lang.NET_TYPE_WIDEBAND);
                        break;
                    }
                    case "\u57fa\u7ad9": {
                        new TranslationComponent(Lang.NET_TYPE_BASE_STATION);
                        break;
                    }
                    case "\u653f\u4f01\u4e13\u7ebf": {
                        new TranslationComponent(Lang.NET_TYPE_GOVERNMENT_AND_ENTERPRISE_LINE);
                        break;
                    }
                    case "\u4e1a\u52a1\u5e73\u53f0": {
                        new TranslationComponent(Lang.NET_TYPE_BUSINESS_PLATFORM);
                        break;
                    }
                    case "\u9aa8\u5e72\u7f51": {
                        new TranslationComponent(Lang.NET_TYPE_BACKBONE_NETWORK);
                        break;
                    }
                    case "IP\u4e13\u7f51": {
                        new TranslationComponent(Lang.NET_TYPE_IP_PRIVATE_NETWORK);
                        break;
                    }
                    case "\u7f51\u5427": {
                        new TranslationComponent(Lang.NET_TYPE_INTERNET_CAFE);
                        break;
                    }
                    case "\u7269\u8054\u7f51": {
                        new TranslationComponent(Lang.NET_TYPE_IOT);
                        break;
                    }
                    case "\u6570\u636e\u4e2d\u5fc3": {
                        new TranslationComponent(Lang.NET_TYPE_DATACENTER);
                    }
                }
                networkData.setNetType(TextManager.tlUI(component));
            }
            geoData.setNetwork(networkData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IPGeoData.NetworkData queryNetwork(InetAddress address) {
        try {
            IPGeoData.NetworkData networkData = new IPGeoData.NetworkData();
            AsnResponse asnResponse = this.mmdbASN.asn(address);
            networkData.setIsp(asnResponse.autonomousSystemOrganization());
            networkData.setNetType(null);
            return networkData;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private IPGeoData.CityData queryCity(InetAddress address) {
        try {
            IPGeoData.CityData cityData = new IPGeoData.CityData();
            IPGeoData.CityData.LocationData locationData = new IPGeoData.CityData.LocationData();
            CityResponse cityResponse = this.mmdbCity.city(address);
            City city = cityResponse.city();
            Location location = cityResponse.location();
            cityData.setName(city.name());
            cityData.setIso(city.geonameId());
            locationData.setTimeZone(location.timeZone());
            locationData.setLongitude(location.longitude());
            locationData.setLatitude(location.latitude());
            locationData.setAccuracyRadius(location.accuracyRadius());
            cityData.setLocation(locationData);
            return cityData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private IPGeoData.CountryData queryCountry(InetAddress address) {
        try {
            IPGeoData.CountryData countryData = new IPGeoData.CountryData();
            CountryResponse countryResponse = this.mmdbCity.country(address);
            Country country = countryResponse.country();
            countryData.setIso(country.isoCode());
            Object countryRegionName = country.name();
            String code = this.languageTag.getFirst();
            code = code.toLowerCase(Locale.ROOT).replace("-", "_");
            if ((code.equals("zh_cn") || code.equals("zh_hk") || code.equals("zh_mo")) && (country.isoCode().equals("TW") || country.isoCode().equals("HK") || country.isoCode().equalsIgnoreCase("MO"))) {
                countryRegionName = "\u4e2d\u56fd" + (String)countryRegionName;
            }
            countryData.setName((String)countryRegionName);
            return countryData;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private IPGeoData.ASData queryAS(InetAddress address) {
        try {
            IPGeoData.ASData asData = new IPGeoData.ASData();
            AsnResponse asnResponse = this.mmdbASN.asn(address);
            IPGeoData.ASData.ASNetwork network = new IPGeoData.ASData.ASNetwork();
            network.setPrefixLength(asnResponse.network().prefixLength());
            network.setIpAddress(asnResponse.network().networkAddress().getHostAddress());
            asData.setNumber(asnResponse.autonomousSystemNumber());
            asData.setOrganization(asnResponse.autonomousSystemOrganization());
            asData.setIpAddress(asnResponse.ipAddress().getHostAddress());
            asData.setNetwork(network);
            return asData;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void updateGeoCN(File mmdbGeoCNFile) throws IOException {
        log.info(TextManager.tlUI(Lang.IPDB_UPDATING, "GeoCN (github.com/ljxi/GeoCN)"));
        IPDBDownloadSource mirror1 = new IPDBDownloadSource("https://github.com/ljxi/GeoCN/releases/download/Latest/", "GeoCN");
        IPDBDownloadSource mirror3 = new IPDBDownloadSource("https://pbh-static.paulzzh.com/ipdb/", "GeoCN", true);
        IPDBDownloadSource mirror4 = new IPDBDownloadSource("https://pbh-static.ghostchu.com/ipdb/", "GeoCN", true);
        Path tmp = Files.createTempFile("GeoCN", ".mmdb", new FileAttribute[0]);
        this.downloadFile(tmp, "GeoCN", mirror1, mirror3, mirror4).join();
        if (!tmp.toFile().exists()) {
            throw new IllegalStateException("Download mmdb database failed!");
        }
        Files.move(tmp, mmdbGeoCNFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void loadMMDB() throws IOException {
        this.languageTag = List.of(Main.DEF_LOCALE, "en");
        this.mmdbCity = new DatabaseReader.Builder(this.mmdbCityFile).locales(List.of(Main.DEF_LOCALE, "en")).fileMode(Reader.FileMode.MEMORY_MAPPED).withCache((NodeCache)new MaxMindNodeCache()).build();
        this.mmdbASN = new DatabaseReader.Builder(this.mmdbASNFile).locales(List.of(Main.DEF_LOCALE, "en")).fileMode(Reader.FileMode.MEMORY_MAPPED).withCache((NodeCache)new MaxMindNodeCache()).build();
        this.geoCN = new Reader(this.mmdbGeoCNFile, Reader.FileMode.MEMORY_MAPPED, (NodeCache)new MaxMindNodeCache());
    }

    private void updateMMDB(String databaseName, File target) throws IOException {
        log.info(TextManager.tlUI(Lang.IPDB_UPDATING, databaseName));
        IPDBDownloadSource mirror1 = new IPDBDownloadSource("https://github.com/PBH-BTN/GeoLite.mmdb/releases/latest/download/", databaseName, true);
        IPDBDownloadSource mirror3 = new IPDBDownloadSource("https://pbh-static.paulzzh.com/ipdb/", databaseName, true);
        IPDBDownloadSource mirror4 = new IPDBDownloadSource("https://pbh-static.ghostchu.com/ipdb/", databaseName, true);
        Path tmp = Files.createTempFile(databaseName, ".mmdb", new FileAttribute[0]);
        this.downloadFile(tmp, databaseName, mirror1, mirror3, mirror4).join();
        if (!tmp.toFile().exists()) {
            if (this.isMmdbNeverDownloaded(target)) {
                throw new IllegalStateException("Download mmdb database failed!");
            }
            log.warn(TextManager.tlUI(Lang.IPDB_EXISTS_UPDATE_FAILED, databaseName));
        }
        Files.move(tmp, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private boolean isMmdbNeverDownloaded(File target) {
        return !target.exists();
    }

    private boolean needUpdateMMDB(File target) {
        if (!target.exists()) {
            return true;
        }
        if (!this.autoUpdate) {
            return false;
        }
        return System.currentTimeMillis() - target.lastModified() > 3888000000L;
    }

    private CompletableFuture<Void> downloadFile(Path path, String databaseName, IPDBDownloadSource ... mirrorList) {
        return this.downloadFile(Arrays.stream(mirrorList).collect(Collectors.toList()), path, databaseName);
    }

    private CompletableFuture<Void> downloadFile(List<IPDBDownloadSource> mirrorList, Path path, String databaseName) {
        return CompletableFuture.runAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 38[SIMPLE_IF_ELSE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private void validateMMDB(File tmp) throws IOException {
        try (FileInputStream is = new FileInputStream(tmp);
             Reader reader = new Reader((InputStream)is, (NodeCache)NoCache.getInstance());){
            log.debug("Validate mmdb {} success: {}", (Object)tmp.getName(), (Object)reader.getMetadata().databaseType());
        }
    }

    @Override
    public void close() {
        if (this.mmdbCity != null) {
            try {
                this.mmdbCity.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mmdbASN != null) {
            try {
                this.mmdbASN.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.geoCN != null) {
            try {
                this.geoCN.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Generated
    public DatabaseReader getMmdbCity() {
        return this.mmdbCity;
    }

    @Generated
    public DatabaseReader getMmdbASN() {
        return this.mmdbASN;
    }

    public static class CNLookupResult {
        private final String isp;
        private final String net;
        private final String province;
        private final Long provinceCode;
        private final String city;
        private final Long cityCode;
        private final String districts;
        private final Long districtsCode;

        @MaxMindDbConstructor
        public CNLookupResult(@MaxMindDbParameter(name="isp") String isp, @MaxMindDbParameter(name="net") String net, @MaxMindDbParameter(name="province") String province, @MaxMindDbParameter(name="provinceCode") Object provinceCode, @MaxMindDbParameter(name="city") String city, @MaxMindDbParameter(name="cityCode") Object cityCode, @MaxMindDbParameter(name="districts") String districts, @MaxMindDbParameter(name="districtsCode") Object districtsCode) {
            this.isp = isp;
            this.net = net;
            this.province = province;
            this.provinceCode = Long.parseLong(provinceCode.toString());
            this.city = city;
            this.cityCode = Long.parseLong(cityCode.toString());
            this.districts = districts;
            this.districtsCode = Long.parseLong(districtsCode.toString());
        }

        @Generated
        public String getIsp() {
            return this.isp;
        }

        @Generated
        public String getNet() {
            return this.net;
        }

        @Generated
        public String getProvince() {
            return this.province;
        }

        @Generated
        public Long getProvinceCode() {
            return this.provinceCode;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public Long getCityCode() {
            return this.cityCode;
        }

        @Generated
        public String getDistricts() {
            return this.districts;
        }

        @Generated
        public Long getDistrictsCode() {
            return this.districtsCode;
        }

        @Generated
        public String toString() {
            return "IPDB.CNLookupResult(isp=" + this.getIsp() + ", net=" + this.getNet() + ", province=" + this.getProvince() + ", provinceCode=" + this.getProvinceCode() + ", city=" + this.getCity() + ", cityCode=" + this.getCityCode() + ", districts=" + this.getDistricts() + ", districtsCode=" + this.getDistrictsCode() + ")";
        }
    }

    public static final class MaxMindNodeCache
    implements NodeCache {
        private static final Cache<CacheKey, DecodedValue> cache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterAccess(1L, TimeUnit.HOURS).build();

        public DecodedValue get(CacheKey cacheKey, NodeCache.Loader loader) {
            return (DecodedValue)cache.get((Object)cacheKey, () -> loader.load(cacheKey));
        }
    }
}

