/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.time;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.time.RestrictedExecResult;
import com.ghostchu.peerbanhelper.util.time.RestrictedExecutor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutProtect
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeoutProtect.class);
    private final String name;
    private final ExecutorService service;
    private final long timeRestrict;
    private boolean timeout;
    private List<Runnable> unfinishedTasks;
    private Consumer<TimeoutProtect> timeoutCallback;

    public TimeoutProtect(String name, long timeRestrict, ExecutorService service) {
        this.name = name;
        this.timeRestrict = timeRestrict;
        this.service = service;
    }

    public TimeoutProtect(String name, long timeRestrict, ExecutorService service, Consumer<TimeoutProtect> timeoutCallback) {
        this.name = name;
        this.timeRestrict = timeRestrict;
        this.service = service;
        this.timeoutCallback = timeoutCallback;
    }

    public TimeoutProtect(String name, long timeRestrict, Consumer<TimeoutProtect> timeoutCallback) {
        this.name = name;
        this.timeRestrict = timeRestrict;
        this.service = Executors.newWorkStealingPool(Math.max(4, Runtime.getRuntime().availableProcessors()));
        this.timeoutCallback = timeoutCallback;
    }

    public boolean isGracefullyShutdown() {
        return this.unfinishedTasks.isEmpty();
    }

    public void runIfTimeout(Consumer<TimeoutProtect> timeout) {
        if (this.timeout) {
            timeout.accept(this);
        }
        this.timeoutCallback = timeout;
    }

    public void printUnfinishedTasks() {
        if (this.unfinishedTasks != null) {
            this.unfinishedTasks.forEach(r -> log.warn(TextManager.tlUI(Lang.TIMING_UNFINISHED_TASK, r)));
        }
    }

    @Override
    public void close() {
        RestrictedExecResult<Object> result = RestrictedExecutor.execute(this.name, this.timeRestrict, () -> {
            this.service.close();
            return null;
        });
        this.timeout = result.timeout();
        this.unfinishedTasks = this.service.shutdownNow();
        if (this.timeout) {
            this.timeoutCallback.accept(this);
        }
        this.printUnfinishedTasks();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ExecutorService getService() {
        return this.service;
    }

    @Generated
    public long getTimeRestrict() {
        return this.timeRestrict;
    }

    @Generated
    public boolean isTimeout() {
        return this.timeout;
    }

    @Generated
    public List<Runnable> getUnfinishedTasks() {
        return this.unfinishedTasks;
    }
}

