/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.maxmind.db.DatabaseRecord;
import com.maxmind.db.Metadata;
import com.maxmind.db.Network;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseProvider;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.AnonymousPlusResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.model.IpRiskResponse;
import com.maxmind.geoip2.model.IspResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;

public class DatabaseReader
implements DatabaseProvider,
Closeable {
    private final Reader reader;
    private final List<String> locales;
    private final int databaseType;

    private DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream, builder.cache);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode, builder.cache);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.locales = builder.locales;
        this.databaseType = this.getDatabaseType();
    }

    private int getDatabaseType() {
        String databaseType = this.metadata().databaseType();
        int type = 0;
        if (databaseType.contains("GeoIP2-Anonymous-IP")) {
            type |= DatabaseType.ANONYMOUS_IP.type;
        }
        if (databaseType.contains("GeoIP-Anonymous-Plus")) {
            type |= DatabaseType.ANONYMOUS_PLUS.type;
        }
        if (databaseType.contains("GeoIP2-IP-Risk")) {
            type |= DatabaseType.IP_RISK.type;
        }
        if (databaseType.contains("GeoLite2-ASN")) {
            type |= DatabaseType.ASN.type;
        }
        if (databaseType.contains("City")) {
            type |= DatabaseType.CITY.type | DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-Connection-Type")) {
            type |= DatabaseType.CONNECTION_TYPE.type;
        }
        if (databaseType.contains("Country")) {
            type |= DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-Domain")) {
            type |= DatabaseType.DOMAIN.type;
        }
        if (databaseType.contains("Enterprise")) {
            type |= DatabaseType.ENTERPRISE.type | DatabaseType.CITY.type | DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-ISP")) {
            type |= DatabaseType.ISP.type;
        }
        if (type == 0) {
            throw new IllegalArgumentException("Unsupported database type: " + databaseType);
        }
        return type;
    }

    private <T> LookupResult<T> get(InetAddress ipAddress, Class<T> cls, DatabaseType expectedType, String caller) throws IOException {
        if ((this.databaseType & expectedType.type) == 0) {
            throw new UnsupportedOperationException("Invalid attempt to open a " + this.metadata().databaseType() + " database using the " + caller + " method");
        }
        DatabaseRecord record = this.reader.getRecord(ipAddress, cls);
        Object o = record.data();
        return new LookupResult<Object>(o, ipAddress.getHostAddress(), record.network());
    }

    private <T> Optional<T> getResponse(InetAddress ipAddress, Class<T> cls, DatabaseType expectedType, String caller) throws IOException {
        LookupResult<T> result = this.get(ipAddress, cls, expectedType, caller);
        T response = result.model();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(response);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryCountry(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<CountryResponse> tryCountry(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<CountryResponse> response = this.getResponse(ipAddress, CountryResponse.class, DatabaseType.COUNTRY, "country");
        return response.map(r -> new CountryResponse((CountryResponse)r, this.locales));
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryCity(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<CityResponse> tryCity(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<CityResponse> response = this.getResponse(ipAddress, CityResponse.class, DatabaseType.CITY, "city");
        return response.map(r -> new CityResponse((CityResponse)r, this.locales));
    }

    @Override
    public AnonymousIpResponse anonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryAnonymousIp(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<AnonymousIpResponse> tryAnonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, AnonymousIpResponse.class, DatabaseType.ANONYMOUS_IP, "anonymousIp");
    }

    @Override
    public AnonymousPlusResponse anonymousPlus(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryAnonymousPlus(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<AnonymousPlusResponse> tryAnonymousPlus(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, AnonymousPlusResponse.class, DatabaseType.ANONYMOUS_PLUS, "anonymousPlus");
    }

    @Override
    public IpRiskResponse ipRisk(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryIpRisk(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<IpRiskResponse> tryIpRisk(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, IpRiskResponse.class, DatabaseType.IP_RISK, "ipRisk");
    }

    @Override
    public AsnResponse asn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryAsn(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<AsnResponse> tryAsn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, AsnResponse.class, DatabaseType.ASN, "asn");
    }

    @Override
    public ConnectionTypeResponse connectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryConnectionType(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<ConnectionTypeResponse> tryConnectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, ConnectionTypeResponse.class, DatabaseType.CONNECTION_TYPE, "connectionType");
    }

    @Override
    public DomainResponse domain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryDomain(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<DomainResponse> tryDomain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, DomainResponse.class, DatabaseType.DOMAIN, "domain");
    }

    @Override
    public EnterpriseResponse enterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryEnterprise(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<EnterpriseResponse> tryEnterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<EnterpriseResponse> response = this.getResponse(ipAddress, EnterpriseResponse.class, DatabaseType.ENTERPRISE, "enterprise");
        return response.map(r -> new EnterpriseResponse((EnterpriseResponse)r, this.locales));
    }

    @Override
    public IspResponse isp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.tryIsp(ipAddress).orElseThrow(() -> new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database."));
    }

    @Override
    public Optional<IspResponse> tryIsp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getResponse(ipAddress, IspResponse.class, DatabaseType.ISP, "isp");
    }

    public Metadata metadata() {
        return this.reader.getMetadata();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public Metadata getMetadata() {
        return this.metadata();
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = List.of("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;
        NodeCache cache = NoCache.getInstance();

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder withCache(NodeCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && Reader.FileMode.MEMORY != val) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }

    private static enum DatabaseType {
        ANONYMOUS_IP,
        ANONYMOUS_PLUS,
        ASN,
        CITY,
        CONNECTION_TYPE,
        COUNTRY,
        DOMAIN,
        ENTERPRISE,
        IP_RISK,
        ISP;

        final int type = 1 << this.ordinal();
    }

    record LookupResult<T>(T model, String ipAddress, Network network) {
    }
}

