/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.bundled;

import io.javalin.config.JavalinConfig;
import io.javalin.http.Context;
import io.javalin.http.HandlerType;
import io.javalin.http.HttpStatus;
import io.javalin.plugin.Plugin;
import io.javalin.plugin.bundled.CorsPluginConfig;
import io.javalin.plugin.bundled.CorsUtils;
import io.javalin.plugin.bundled.OriginParts;
import io.javalin.router.JavalinDefaultRouting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\b\u0002\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lio/javalin/plugin/bundled/CorsPlugin;", "Lio/javalin/plugin/Plugin;", "Lio/javalin/plugin/bundled/CorsPluginConfig;", "userConfig", "Ljava/util/function/Consumer;", "(Ljava/util/function/Consumer;)V", "handleCors", "", "ctx", "Lio/javalin/http/Context;", "cfg", "Lio/javalin/plugin/bundled/CorsPluginConfig$CorsRule;", "matchOrigin", "", "clientOrigin", "", "origins", "", "onStart", "config", "Lio/javalin/config/JavalinConfig;", "javalin"})
@SourceDebugExtension(value={"SMAP\nCorsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorsPlugin.kt\nio/javalin/plugin/bundled/CorsPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1549#2:178\n1620#2,3:179\n1747#2,3:182\n1855#2,2:185\n*S KotlinDebug\n*F\n+ 1 CorsPlugin.kt\nio/javalin/plugin/bundled/CorsPlugin\n*L\n171#1:178\n171#1:179,3\n173#1:182,3\n91#1:185,2\n*E\n"})
public final class CorsPlugin
extends Plugin<CorsPluginConfig> {
    public CorsPlugin(@Nullable Consumer<CorsPluginConfig> userConfig) {
        super(userConfig, new CorsPluginConfig());
        if (!(!((Collection)((CorsPluginConfig)this.pluginConfig).getRules$javalin()).isEmpty())) {
            boolean bl = false;
            String string = "At least one cors config has to be provided. Use CorsPluginConfig.addRule() to add one.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ CorsPlugin(Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            consumer = null;
        }
        this(consumer);
    }

    @Override
    public void onStart(@NotNull JavalinConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        config.router.mount(arg_0 -> CorsPlugin.onStart$lambda$7(this, arg_0));
    }

    private final void handleCors(Context ctx, CorsPluginConfig.CorsRule cfg) {
        List<String> headersToExpose;
        String string;
        String string2 = ctx.header("Origin");
        if (string2 == null) {
            return;
        }
        String clientOrigin = string2;
        if (!CorsUtils.INSTANCE.isValidOrigin$javalin(clientOrigin)) {
            return;
        }
        if (ctx.method() == HandlerType.OPTIONS) {
            String headerValue;
            String string3;
            boolean requestedHeader = false;
            String string4 = ctx.header("Access-Control-Request-Headers");
            if (string4 != null) {
                headerValue = string3 = string4;
                boolean bl = false;
                ctx.header("Access-Control-Allow-Headers", headerValue);
                requestedHeader = true;
            }
            String string5 = ctx.header("Access-Control-Request-Method");
            if (string5 != null) {
                headerValue = string3 = string5;
                boolean bl = false;
                ctx.header("Access-Control-Allow-Methods", headerValue);
                requestedHeader = true;
            }
            if (requestedHeader && cfg.maxAge >= 0) {
                ctx.header("Access-Control-Max-Age", String.valueOf(cfg.maxAge));
            }
        }
        List<String> origins = cfg.allowedOrigins();
        if (origins.contains("*")) {
            string = "*";
        } else {
            if (Intrinsics.areEqual((Object)clientOrigin, (Object)"null")) {
                return;
            }
            if (cfg.reflectClientOrigin) {
                string = clientOrigin;
            } else if (this.matchOrigin(clientOrigin, origins)) {
                string = clientOrigin;
            } else {
                ctx.status(HttpStatus.BAD_REQUEST);
                return;
            }
        }
        String allowOriginValue = string;
        ctx.header("Access-Control-Allow-Origin", allowOriginValue);
        ctx.header("Vary", "Origin");
        if (cfg.allowCredentials) {
            ctx.header("Access-Control-Allow-Credentials", "true");
        }
        if (!((Collection)(headersToExpose = cfg.headersToExpose())).isEmpty()) {
            ctx.header("Access-Control-Expose-Headers", CollectionsKt.joinToString$default((Iterable)headersToExpose, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final boolean matchOrigin(String clientOrigin, List<String> origins) {
        boolean bl;
        block5: {
            String p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            OriginParts clientOriginPart = CorsUtils.INSTANCE.parseAsOriginParts$javalin(CorsUtils.INSTANCE.normalizeOrigin$javalin(clientOrigin));
            Iterable iterable = origins;
            CorsUtils corsUtils = CorsUtils.INSTANCE;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(corsUtils.normalizeOrigin$javalin(p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            corsUtils = CorsUtils.INSTANCE;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(corsUtils.parseAsOriginParts$javalin(p0));
            }
            List serverOriginParts = (List)destination$iv$iv;
            Iterable $this$any$iv = serverOriginParts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OriginParts it = (OriginParts)element$iv;
                    boolean bl4 = false;
                    if (!CorsUtils.INSTANCE.originsMatch$javalin(clientOriginPart, it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void onStart$lambda$7$lambda$6$lambda$4(CorsPlugin this$0, CorsPluginConfig.CorsRule $corsRule, Context ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$corsRule, (String)"$corsRule");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.handleCors(ctx, $corsRule);
    }

    private static final void onStart$lambda$7$lambda$6$lambda$5(List $validOptionStatusCodes, Context ctx) {
        Intrinsics.checkNotNullParameter((Object)$validOptionStatusCodes, (String)"$validOptionStatusCodes");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (ctx.method() == HandlerType.OPTIONS && $validOptionStatusCodes.contains((Object)ctx.status())) {
            ctx.result("").status(200);
        }
    }

    private static final void onStart$lambda$7(CorsPlugin this$0, JavalinDefaultRouting it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$forEach$iv = ((CorsPluginConfig)this$0.pluginConfig).getRules$javalin();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CorsPluginConfig.CorsRule corsRule = (CorsPluginConfig.CorsRule)element$iv;
            boolean bl = false;
            List<String> origins = corsRule.allowedOrigins();
            if (!(!((Collection)origins).isEmpty() || corsRule.reflectClientOrigin)) {
                boolean $i$a$-require-CorsPlugin$onStart$1$1$42 = false;
                String $i$a$-require-CorsPlugin$onStart$1$1$42 = "Origins cannot be empty if `reflectClientOrigin` is false.";
                throw new IllegalArgumentException($i$a$-require-CorsPlugin$onStart$1$1$42.toString());
            }
            if (!(origins.isEmpty() || !corsRule.reflectClientOrigin)) {
                boolean $i$a$-require-CorsPlugin$onStart$1$1$52 = false;
                String $i$a$-require-CorsPlugin$onStart$1$1$52 = "Cannot set `allowedOrigins` if `reflectClientOrigin` is true";
                throw new IllegalArgumentException($i$a$-require-CorsPlugin$onStart$1$1$52.toString());
            }
            if (!(!origins.contains("*") || !corsRule.allowCredentials)) {
                boolean bl2 = false;
                String string = "Cannot use `anyHost()` / Origin: * if `allowCredentials` is true as that is rejected by all browsers.\nPlease use either an explicit list of allowed origins via `allowHost()` or use `reflectClientOrigin = true` without any origins.\nDocs: https://javalin.io/plugins/cors";
                throw new IllegalArgumentException(string.toString());
            }
            HttpStatus[] httpStatusArray = new HttpStatus[]{HttpStatus.NOT_FOUND, HttpStatus.METHOD_NOT_ALLOWED};
            List validOptionStatusCodes = CollectionsKt.listOf((Object[])httpStatusArray);
            it.before(corsRule.path, arg_0 -> CorsPlugin.onStart$lambda$7$lambda$6$lambda$4(this$0, corsRule, arg_0));
            it.after(corsRule.path, arg_0 -> CorsPlugin.onStart$lambda$7$lambda$6$lambda$5(validOptionStatusCodes, arg_0));
        }
    }

    public CorsPlugin() {
        this(null, 1, null);
    }
}

