# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_pgp_sig2dot_global_optspecs
	string join \n v/verbose q/quiet import= k/fingerprint= gossip= p/show-primary-uid-only a/show-self-sigs online simple keyserver= h/help V/version
end

function __fish_pgp_sig2dot_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_pgp_sig2dot_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_pgp_sig2dot_using_subcommand
	set -l cmd (__fish_pgp_sig2dot_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -l import -d 'Import keyring from file or stdin' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s k -l fingerprint -d 'Import keys from keyserver by fingerprint' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -l gossip -d 'Gossip the trust paths from the trust root(given above by `--fingerprint`), with an integer value which means the depth limit of gossiping Specially, 0 means no depth limit, it\'s only allowed without online mode' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -l keyserver -d 'Key server' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s p -l show-primary-uid-only -d 'Show only primary UIDs'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s a -l show-self-sigs -d 'Show self-signatures'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -l online -d 'Fetch the newest signature from key server for each key in keyring'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -l simple -d 'Keep the output simple instead of JSON'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s h -l help -d 'Print help'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -s V -l version -d 'Print version'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -f -a "gen" -d 'Generate manual or shell auto complete file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -l import -d 'Import keyring from file or stdin' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -s k -l fingerprint -d 'Import keys from keyserver by fingerprint' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -l gossip -d 'Gossip the trust paths from the trust root(given above by `--fingerprint`), with an integer value which means the depth limit of gossiping Specially, 0 means no depth limit, it\'s only allowed without online mode' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -l keyserver -d 'Key server' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -s p -l show-primary-uid-only -d 'Show only primary UIDs'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -s a -l show-self-sigs -d 'Show self-signatures'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -l online -d 'Fetch the newest signature from key server for each key in keyring'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -l simple -d 'Keep the output simple instead of JSON'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -s h -l help -d 'Print help'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -f -a "man" -d 'Generate manual file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -f -a "complete" -d 'Generate shell auto complete file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and not __fish_seen_subcommand_from man complete help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -l path -d 'Output Path' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -l import -d 'Import keyring from file or stdin' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -s k -l fingerprint -d 'Import keys from keyserver by fingerprint' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -l gossip -d 'Gossip the trust paths from the trust root(given above by `--fingerprint`), with an integer value which means the depth limit of gossiping Specially, 0 means no depth limit, it\'s only allowed without online mode' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -l keyserver -d 'Key server' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -s p -l show-primary-uid-only -d 'Show only primary UIDs'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -s a -l show-self-sigs -d 'Show self-signatures'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -l online -d 'Fetch the newest signature from key server for each key in keyring'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -l simple -d 'Keep the output simple instead of JSON'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from man" -s h -l help -d 'Print help'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -l output -d 'Output Path' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -l import -d 'Import keyring from file or stdin' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -s k -l fingerprint -d 'Import keys from keyserver by fingerprint' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -l gossip -d 'Gossip the trust paths from the trust root(given above by `--fingerprint`), with an integer value which means the depth limit of gossiping Specially, 0 means no depth limit, it\'s only allowed without online mode' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -l keyserver -d 'Key server' -r
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -s v -l verbose -d 'Increase logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -s p -l show-primary-uid-only -d 'Show only primary UIDs'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -s a -l show-self-sigs -d 'Show self-signatures'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -l online -d 'Fetch the newest signature from key server for each key in keyring'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -l simple -d 'Keep the output simple instead of JSON'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from complete" -s h -l help -d 'Print help'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from help" -f -a "man" -d 'Generate manual file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from help" -f -a "complete" -d 'Generate shell auto complete file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand gen; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand help; and not __fish_seen_subcommand_from gen help" -f -a "gen" -d 'Generate manual or shell auto complete file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand help; and not __fish_seen_subcommand_from gen help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand help; and __fish_seen_subcommand_from gen" -f -a "man" -d 'Generate manual file'
complete -c pgp-sig2dot -n "__fish_pgp_sig2dot_using_subcommand help; and __fish_seen_subcommand_from gen" -f -a "complete" -d 'Generate shell auto complete file'
