import QtQuick
import QtQuick.Controls as QQC2
import QtQuick.Layouts
import org.kde.kirigami as Kirigami

QQC2.Pane {
    id: root

    property string cfg_clock_fontfamily: ""
    property alias cfg_show_time_in_compact_mode: show_time_in_compact_mode.checked
    property alias cfg_show_fullscreen_break: show_fullscreen_break.checked
    property alias cfg_hide_fullscreen_buttons: hide_fullscreen_buttons.checked
    property alias cfg_timer_auto_next_enabled: timer_auto_next_enabled.checked
    property alias cfg_autostart: autostart.checked

    onCfg_clock_fontfamilyChanged: {
        if (cfg_clock_fontfamily) {
            for (var i = 0, j = clock_fontfamilyComboBox.model.length; i < j; ++i) {
                if (clock_fontfamilyComboBox.model[i].value == cfg_clock_fontfamily) {
                    clock_fontfamilyComboBox.currentIndex = i;
                    break;
                }
            }
        }
    }

    Kirigami.FormLayout {
        anchors.fill: parent

        QQC2.ComboBox {
            id: clock_fontfamilyComboBox

            Kirigami.FormData.label: i18n("Timer font:")
            textRole: "text"
            Component.onCompleted: {
                var arr = [];
                arr.push({
                    "text": i18n("Default"),
                    "value": ""
                });
                var fonts = Qt.fontFamilies();
                var foundIndex = 0;
                for (var i = 0, j = fonts.length; i < j; ++i) {
                    arr.push({
                        "text": fonts[i],
                        "value": fonts[i]
                    });
                }
                model = arr;
            }
            onCurrentIndexChanged: {
                var current = model[currentIndex];
                if (current)
                    cfg_clock_fontfamily = current.value;

            }
        }

        Item {
            Kirigami.FormData.isSection: true
        }

        QQC2.CheckBox {
            id: show_time_in_compact_mode

            Kirigami.FormData.label: i18n("Show time in compact view:")
        }

        QQC2.CheckBox {
            id: show_fullscreen_break

            Kirigami.FormData.label: i18n("Show fullscreen overlay on break:")
        }

        QQC2.CheckBox {
            id: hide_fullscreen_buttons

            Kirigami.FormData.label: i18n("Hide fullscreen buttons:")
        }

        QQC2.CheckBox {
            id: autostart

            Kirigami.FormData.label: i18n("Autostart after system boot:")
        }

        QQC2.CheckBox {
            id: timer_auto_next_enabled

            Kirigami.FormData.label: i18n("Automatically start next timer:")
        }

    }

}
