/* Generated by generate.py. Do not modify! */
#include "helpers.h"

static inline double 
eval_OP_ABS_n (double x)
{
  return fabs (x);
}

static inline double 
eval_OP_ACOS_n (double x)
{
  return acos (x);
}

static inline double 
eval_OP_ANY_nn (double x, double a[], size_t n)
{
  double retval = SYSMIS;
  if (x != SYSMIS)
    {
      for (size_t i = 0; i < n; i++)
        if (a[i] == x)
          return 1.;
        else if (a[i] != SYSMIS)
          retval = 0.;
    }
  return retval;
}

static inline double 
eval_OP_ANY_ss (struct substring x, struct substring a[], size_t n)
{
  size_t i;

  for (i = 0; i < n; i++)
    if (!compare_string_3way (&x, &a[i]))
      return 1.;
  return 0.;
}

static inline double 
eval_OP_ARCOS_n (double x)
{
  return acos (x);
}

static inline double 
eval_OP_ARSIN_n (double x)
{
  return asin (x);
}

static inline double 
eval_OP_ARTAN_n (double x)
{
  return atan (x);
}

static inline double 
eval_OP_ASIN_n (double x)
{
  return asin (x);
}

static inline double 
eval_OP_ATAN_n (double x)
{
  return atan (x);
}

static inline double 
eval_OP_CDF_BERNOULLI_nn (double k, double p)
{
  return k ? 1 : 1 - p;
}

static inline double 
eval_OP_CDF_BETA_nnn (double x, double a, double b)
{
  return gsl_cdf_beta_P (x, a, b);
}

static inline double 
eval_OP_CDF_BINOM_nnn (double k, double n, double p)
{
  return gsl_cdf_binomial_P (k, p, n);
}

static inline double 
eval_OP_CDF_BVNOR_nnn (double x0, double x1, double r)
{
  return cdf_bvnor (x0, x1, r);
}

static inline double 
eval_OP_CDF_CAUCHY_nnn (double x, double a, double b)
{
  return gsl_cdf_cauchy_P ((x - a) / b, 1);
}

static inline double 
eval_OP_CDF_CHISQ_nn (double x, double df)
{
  return gsl_cdf_chisq_P (x, df);
}

static inline double 
eval_OP_CDF_EXP_nn (double x, double a)
{
  return gsl_cdf_exponential_P (x, 1. / a);
}

static inline double 
eval_OP_CDF_F_nnn (double x, double df1, double df2)
{
  return gsl_cdf_fdist_P (x, df1, df2);
}

static inline double 
eval_OP_CDF_GAMMA_nnn (double x, double a, double b)
{
  return gsl_cdf_gamma_P (x, a, 1. / b);
}

static inline double 
eval_OP_CDF_GEOM_nn (double k, double p)
{
  return gsl_cdf_geometric_P (k, p);
}

static inline double 
eval_OP_CDF_HYPER_nnnn (double k, double a, double b, double c)
{
  return gsl_cdf_hypergeometric_P (k, c, a - c, b);
}

static inline double 
eval_OP_CDF_LAPLACE_nnn (double x, double a, double b)
{
  return gsl_cdf_laplace_P ((x - a) / b, 1);
}

static inline double 
eval_OP_CDF_LNORMAL_nnn (double x, double m, double s)
{
  return gsl_cdf_lognormal_P (x, log (m), s);
}

static inline double 
eval_OP_CDF_LOGISTIC_nnn (double x, double a, double b)
{
  return gsl_cdf_logistic_P ((x - a) / b, 1);
}

static inline double 
eval_OP_CDF_NEGBIN_nnn (double k, double n, double p)
{
  return gsl_cdf_negative_binomial_P (k, p, n);
}

static inline double 
eval_OP_CDF_NORMAL_nnn (double x, double u, double s)
{
  return gsl_cdf_gaussian_P (x - u, s);
}

static inline double 
eval_OP_CDF_PARETO_nnn (double x, double a, double b)
{
  return gsl_cdf_pareto_P (x, b, a);
}

static inline double 
eval_OP_CDF_POISSON_nn (double k, double mu)
{
  return gsl_cdf_poisson_P (k, mu);
}

static inline double 
eval_OP_CDF_RAYLEIGH_nn (double x, double sigma)
{
  return gsl_cdf_rayleigh_P (x, sigma);
}

static inline double 
eval_OP_CDF_T_nn (double x, double df)
{
  return gsl_cdf_tdist_P (x, df);
}

static inline double 
eval_OP_CDF_T1G_nnn (double x, double a, double b)
{
  return gsl_cdf_gumbel1_P (x, a, b);
}

static inline double 
eval_OP_CDF_T2G_nnn (double x, double a, double b)
{
  return gsl_cdf_gumbel2_P (x, a, b);
}

static inline double 
eval_OP_CDF_UNIFORM_nnn (double x, double a, double b)
{
  return gsl_cdf_flat_P (x, a, b);
}

static inline double 
eval_OP_CDF_WEIBULL_nnn (double x, double a, double b)
{
  return gsl_cdf_weibull_P (x, a, b);
}

static inline double 
eval_OP_CDFNORM_n (double x)
{
  return gsl_cdf_ugaussian_P (x);
}

static inline double 
eval_OP_CFVAR_n (double a[], size_t n)
{
  double mean, variance;

  moments_of_doubles (a, n, NULL, &mean, &variance, NULL, NULL);

  if (mean == SYSMIS || mean == 0 || variance == SYSMIS)
    return SYSMIS;
  else
    return sqrt (variance) / mean;
}

static inline struct substring 
eval_OP_CONCAT_s (struct substring a[], size_t n, struct expression *e)
{
  struct substring dst;
  size_t i;

  dst = alloc_string (e, MAX_STRING);
  dst.length = 0;
  for (i = 0; i < n; i++)
    {
      struct substring *src = &a[i];
      size_t copy_len;

      copy_len = src->length;
      if (dst.length + copy_len > MAX_STRING)
        copy_len = MAX_STRING - dst.length;
      memcpy (&dst.string[dst.length], src->string, copy_len);
      dst.length += copy_len;
    }

  return dst;
}

static inline double 
eval_OP_COS_n (double x)
{
  return cos (x);
}

static inline double 
eval_OP_CTIME_DAYS_n (double time)
{
  return time / DAY_S;
}

static inline double 
eval_OP_CTIME_HOURS_n (double time)
{
  return time / H_S;
}

static inline double 
eval_OP_CTIME_MINUTES_n (double time)
{
  return time / MIN_S;
}

static inline double 
eval_OP_CTIME_SECONDS_n (double time)
{
  return time;
}

static inline double 
eval_OP_DATE_DMY_nnn (int d, int m, int y, struct expression *e, const struct expr_node *n)
{
  return expr_ymd_to_date (y, m, d, e, n, 3, 2, 1);
}

static inline double 
eval_OP_DATE_MDY_nnn (int m, int d, int y, struct expression *e, const struct expr_node *n)
{
  return expr_ymd_to_date (y, m, d, e, n, 3, 1, 2);
}

static inline double 
eval_OP_DATE_MOYR_nn (int m, int y, struct expression *e, const struct expr_node *n)
{
  return expr_ymd_to_date (y, m, 1, e, n, 2, 1, 0);
}

static inline double 
eval_OP_DATE_QYR_nn (int q, int y, struct expression *e, const struct expr_node *n)
{
  if (q < 1 || q > 4)
    {
      msg_at (SW, expr_location (e, n->args[0]),
              _("Argument 1 to DATE.QYR must be 1, 2, 3, or 4 (not %d)."), q);
      return SYSMIS;
    }
  return expr_ymd_to_date (y, q * 3 - 2, 1, e, n, 2, 0, 0);
}

static inline double 
eval_OP_DATE_WKYR_nn (int w, int y, struct expression *e, const struct expr_node *n)
{
  if (w < 1 || w > 53)
    {
      msg_at (SE, expr_location (e, n->args[0]),
              _("The week argument to DATE.WKYR is outside the acceptable "
                "range of 1 to 53.  The result will be system-missing."));
      return SYSMIS;
    }
  else
    {
      double yr_1_1 = expr_ymd_to_ofs (y, 1, 1, e, n, 2, 0, 0);
      if (yr_1_1 != SYSMIS)
        return DAY_S * (yr_1_1 + WEEK_DAY * (w - 1));
      else
        return SYSMIS;
    }
}

static inline double 
eval_OP_DATE_YRDAY_nn (int y, int yd, struct expression *e, const struct expr_node *n)
{
  if (yd < 1 || yd > 366)
    {
      msg_at (SE, expr_location (e, n->args[1]),
              _("The value %d as day argument to DATE.YRDAY is outside the "
                "acceptable range of 1 to 366.  "
                "The result will be system-missing."), yd);
      return SYSMIS;
    }
  else
    {
      double yr_1_1 = expr_ymd_to_ofs (y, 1, 1, e, n, 1, 0, 0);
      if (yr_1_1 != SYSMIS)
        return DAY_S * (yr_1_1 + yd - 1.);
      else
        return SYSMIS;
    }
}

static inline double 
eval_OP_DATEDIFF_nns (double date2, double date1, struct substring unit, struct expression *e, const struct expr_node *n)
{
  return expr_date_difference (date1, date2, unit, e, n);
}

static inline double 
eval_OP_DATESUM_nns (double date, double quantity, struct substring unit, struct expression *e, const struct expr_node *n)
{
  return expr_date_sum_closest (date, quantity, unit, e, n);
}

static inline double 
eval_OP_DATESUM_nnss (double date, double quantity, struct substring unit, struct substring method, struct expression *e, const struct expr_node *n)
{
  return expr_date_sum (date, quantity, unit, method, e, n);
}

static inline double 
eval_OP_EXP_n (double x)
{
  return check_errno (exp (x));
}

static inline double 
eval_OP_IDF_BETA_nnn (double P, double a, double b)
{
  return gsl_cdf_beta_Pinv (P, a, b);
}

static inline double 
eval_OP_IDF_CAUCHY_nnn (double P, double a, double b)
{
  return a + b * gsl_cdf_cauchy_Pinv (P, 1);
}

static inline double 
eval_OP_IDF_CHISQ_nn (double P, double df)
{
  return gsl_cdf_chisq_Pinv (P, df);
}

static inline double 
eval_OP_IDF_EXP_nn (double P, double a)
{
  return gsl_cdf_exponential_Pinv (P, 1. / a);
}

static inline double 
eval_OP_IDF_F_nnn (double P, double df1, double df2)
{
  return idf_fdist (P, df1, df2);
}

static inline double 
eval_OP_IDF_GAMMA_nnn (double P, double a, double b)
{
  return gsl_cdf_gamma_Pinv (P, a, 1. / b);
}

static inline double 
eval_OP_IDF_LAPLACE_nnn (double P, double a, double b)
{
  return a + b * gsl_cdf_laplace_Pinv (P, 1);
}

static inline double 
eval_OP_IDF_LNORMAL_nnn (double P, double m, double s)
{
  return gsl_cdf_lognormal_Pinv (P, log (m), s);
}

static inline double 
eval_OP_IDF_LOGISTIC_nnn (double P, double a, double b)
{
  return a + b * gsl_cdf_logistic_Pinv (P, 1);
}

static inline double 
eval_OP_IDF_NORMAL_nnn (double P, double u, double s)
{
  return u + gsl_cdf_gaussian_Pinv (P, s);
}

static inline double 
eval_OP_IDF_PARETO_nnn (double P, double a, double b)
{
  return gsl_cdf_pareto_Pinv (P, b, a);
}

static inline double 
eval_OP_IDF_RAYLEIGH_nn (double P, double sigma)
{
  return gsl_cdf_rayleigh_Pinv (P, sigma);
}

static inline double 
eval_OP_IDF_T_nn (double P, double df)
{
  return gsl_cdf_tdist_Pinv (P, df);
}

static inline double 
eval_OP_IDF_T1G_nnn (double P, double a, double b)
{
  return gsl_cdf_gumbel1_Pinv (P, a, b);
}

static inline double 
eval_OP_IDF_T2G_nnn (double P, double a, double b)
{
  return gsl_cdf_gumbel2_Pinv (P, a, b);
}

static inline double 
eval_OP_IDF_UNIFORM_nnn (double P, double a, double b)
{
  return gsl_cdf_flat_Pinv (P, a, b);
}

static inline double 
eval_OP_IDF_WEIBULL_nnn (double P, double a, double b)
{
  return gsl_cdf_weibull_Pinv (P, a, b);
}

static inline double 
eval_OP_INDEX_ss (struct substring haystack, struct substring needle)
{
  if (haystack.length >= needle.length)
    {
      size_t limit = haystack.length - needle.length + 1;
      for (size_t i = 1; i <= limit; i++)
        if (!memcmp (&haystack.string[i - 1], needle.string, needle.length))
          return i;
    }
  return 0;
}

static inline double 
eval_OP_INDEX_ssn (struct substring haystack, struct substring needles, int needle_len, struct expression *e, const struct expr_node *n)
{
  if (needle_len <= 0 || needles.length % needle_len != 0)
    {
      msg_at (SE, expr_location (e, n),
              _("INDEX needle length argument must evenly divide the "
                "length of the needles argument."));
      msg_at (SN, expr_location (e, n->args[1]),
              _("The needles argument has length %zu."), needles.length);
      msg_at (SN, expr_location (e, n->args[2]),
              _("The needle length argument has value %d."), needle_len);
      return SYSMIS;
    }

  if (haystack.length >= needle_len)
    {
      size_t limit = haystack.length - needle_len + 1;
      for (size_t i = 1; i <= limit; i++)
        for (size_t j = 0; j < needles.length; j += needle_len)
          if (!memcmp (&haystack.string[i - 1], &needles.string[j], needle_len))
            return i;
    }

  return 0;
}

static inline double 
eval_OP_LAG_Vn (const struct variable *v, struct dataset *ds)
{
  const struct ccase *c = lagged_case (ds, 1);
  if (c != NULL)
    {
      double x = case_num (c, v);
      return var_is_num_missing (v, x) ? SYSMIS : x;
    }
  else
    return SYSMIS;
}

static inline double 
eval_OP_LAG_Vnn (const struct variable *v, int n_before, struct dataset *ds)
{
  const struct ccase *c = lagged_case (ds, n_before);
  if (c != NULL)
    {
      double x = case_num (c, v);
      return var_is_num_missing (v, x) ? SYSMIS : x;
    }
  else
    return SYSMIS;
}

static inline struct substring 
eval_OP_LAG_Vs (const struct variable *v, struct expression *e, struct dataset *ds)
{
  const struct ccase *c = lagged_case (ds, 1);
  if (c != NULL)
    return copy_string (e, CHAR_CAST_BUG (char *, case_str (c, v)),
                        var_get_width (v));
  else
    return empty_string;
}

static inline struct substring 
eval_OP_LAG_Vsn (const struct variable *v, int n_before, struct expression *e, struct dataset *ds)
{
  const struct ccase *c = lagged_case (ds, n_before);
  if (c != NULL)
    return copy_string (e, CHAR_CAST_BUG (char *, case_str (c, v)),
                        var_get_width (v));
  else
    return empty_string;
}

static inline double 
eval_OP_LENGTH_s (struct substring s)
{
  return s.length;
}

static inline double 
eval_OP_LG10_n (double x)
{
  return check_errno (log10 (x));
}

static inline double 
eval_OP_LN_n (double x)
{
  return check_errno (log (x));
}

static inline double 
eval_OP_LNGAMMA_n (double x)
{
  return gsl_sf_lngamma (x);
}

static inline struct substring 
eval_OP_LOWER_s (struct substring s)
{
  int i;

  for (i = 0; i < s.length; i++)
    s.string[i] = tolower ((unsigned char) s.string[i]);
  return s;
}

static inline struct substring 
eval_OP_LPAD_sn (struct substring s, int n, struct expression *e, const struct expr_node *node)
{
  if (n < 0 || n > MAX_STRING)
    {
      if (n != INT_MIN)
        {
          msg_at (SE, expr_location (e, node),
                  _("The length argument to LPAD must be between 0 and %d."),
                  MAX_STRING);
          msg_at (SN, expr_location (e, node->args[1]),
                  _("The length argument is %d."), n);
        }

      return s;
    }
  else if (s.length >= n)
    return s;
  else
    {
      struct substring t = alloc_string (e, n);
      size_t pad = n - s.length;
      memset (t.string, ' ', pad);
      memcpy (&t.string[pad], s.string, s.length);
      return t;
    }
}

static inline struct substring 
eval_OP_LPAD_sns (struct substring s, int n, struct substring c, struct expression *e, const struct expr_node *node)
{
  if (n < 0 || n > MAX_STRING)
    {
      if (n != INT_MIN)
        {
          msg_at (SE, expr_location (e, node),
                  _("The length argument to LPAD must be between 0 and %d."),
                  MAX_STRING);
          msg_at (SN, expr_location (e, node->args[1]),
                  _("The length argument is %d."), n);
        }

      return s;
    }
  else if (s.length >= n)
    return s;
  else if (c.length == 0)
    {
      msg_at (SE, expr_location (e, node),
              _("The padding argument to LPAD must not be an empty string."));
      return s;
    }
  else
    {
      size_t n_pad = (n - s.length) / c.length;
      if (!n_pad)
        return s;

      struct substring t = alloc_string (e, n);
      t.length = 0;
      for (size_t i = 0; i < n_pad; i++)
        {
          memcpy (t.string + t.length, c.string, c.length);
          t.length += c.length;
        }
      memcpy (t.string + t.length, s.string, s.length);
      t.length += s.length;
      return t;
    }
}

static inline struct substring 
eval_OP_LTRIM_s (struct substring s)
{
  while (s.length > 0 && s.string[0] == ' ')
    {
      s.length--;
      s.string++;
    }
  return s;
}

static inline struct substring 
eval_OP_LTRIM_ss (struct substring s, struct substring c)
{
  if (c.length > 0)
    while (s.length >= c.length && !memcmp (s.string, c.string, c.length))
      {
        s.length -= c.length;
        s.string += c.length;
      }
  return s;
}

static inline double 
eval_OP_MAX_n (double a[], size_t n)
{
  double max;
  size_t i;

  max = -DBL_MAX;
  for (i = 0; i < n; i++)
    if (a[i] != SYSMIS && a[i] > max)
      max = a[i];
  return max;
}

static inline struct substring 
eval_OP_MAX_s (struct substring a[], size_t n)
{
  struct substring *max;
  size_t i;

  max = &a[0];
  for (i = 1; i < n; i++)
    if (compare_string_3way (&a[i], max) > 0)
      max = &a[i];
  return *max;
}

static inline double 
eval_OP_MBLEN_BYTE_sn (struct substring s, double idx)
{
  if (idx < 0 || idx >= s.length || (int) idx != idx)
    return SYSMIS;
  else
    return 1;
}

static inline double 
eval_OP_MEAN_n (double a[], size_t n)
{
  double mean;
  moments_of_doubles (a, n, NULL, &mean, NULL, NULL, NULL);
  return mean;
}

static inline double 
eval_OP_MEDIAN_n (double a[], size_t n)
{
  return median (a, n);
}

static inline double 
eval_OP_MIN_n (double a[], size_t n)
{
  double min;
  size_t i;

  min = DBL_MAX;
  for (i = 0; i < n; i++)
    if (a[i] != SYSMIS && a[i] < min)
      min = a[i];
  return min;
}

static inline struct substring 
eval_OP_MIN_s (struct substring a[], size_t n)
{
  struct substring *min;
  size_t i;

  min = &a[0];
  for (i = 1; i < n; i++)
    if (compare_string_3way (&a[i], min) < 0)
      min = &a[i];
  return *min;
}

static inline double 
eval_OP_MISSING_n (double x)
{
  return x == SYSMIS || !isfinite (x);
}

static inline double 
eval_OP_MOD_nn (double n, double d)
{
  if (d != SYSMIS)
    return n != SYSMIS ? fmod (n, d) : SYSMIS;
  else
    return n != 0. ? SYSMIS : 0.;
}

static inline double 
eval_OP_MOD10_n (double x)
{
  return fmod (x, 10);
}

static inline double 
eval_OP_NCDF_BETA_nnnn (double x, double a, double b, double lambda)
{
  return ncdf_beta (x, a, b, lambda);
}

static inline double 
eval_OP_NMISS_n (double a[], size_t n)
{
  size_t n_missings = 0;
  for (size_t i = 0; i < n; i++)
    n_missings += a[i] == SYSMIS;
  return n_missings;
}

static inline double 
eval_OP_NORMAL_n (double s)
{
  return gsl_ran_gaussian (get_rng (), s);
}

static inline double 
eval_OP_NPDF_BETA_nnnn (double x, double a, double b, double lambda)
{
  return npdf_beta (x, a, b, lambda);
}

static inline double 
eval_OP_NUMBER_sf (struct substring s, struct fmt_spec f, struct expression *e, const struct expr_node *n)
{
  if (s.length > f.w)
    s.length = f.w;

  union value out;
  char *error = data_in (s, C_ENCODING, f.type, settings_get_fmt_settings (),
                         &out, 0, NULL);
  if (error == NULL)
    data_in_imply_decimals (s, C_ENCODING, f.type, f.d,
                            settings_get_fmt_settings (), &out);
  else
    {
      msg_at (SE, expr_location (e, n->args[0]),
              _("Cannot parse \"%.*s\" as format %s: %s"),
              (int) s.length, s.string, fmt_name (f.type), error);
      free (error);
    }
  return out.f;
}

static inline double 
eval_OP_NVALID_n (double a[], size_t n)
{
  size_t n_valids = 0;
  for (size_t i = 0; i < n; i++)
    n_valids += a[i] != SYSMIS;
  return n_valids;
}

static inline double 
eval_OP_PDF_BERNOULLI_nn (double k, double p)
{
  return gsl_ran_bernoulli_pdf (k, p);
}

static inline double 
eval_OP_PDF_BETA_nnn (double x, double a, double b)
{
  return gsl_ran_beta_pdf (x, a, b);
}

static inline double 
eval_OP_PDF_BINOM_nnn (double k, double n, double p)
{
  return gsl_ran_binomial_pdf (k, p, n);
}

static inline double 
eval_OP_PDF_BVNOR_nnn (double x0, double x1, double r)
{
  return gsl_ran_bivariate_gaussian_pdf (x0, x1, 1, 1, r);
}

static inline double 
eval_OP_PDF_CAUCHY_nnn (double x, double a, double b)
{
  return gsl_ran_cauchy_pdf ((x - a) / b, 1) / b;
}

static inline double 
eval_OP_PDF_CHISQ_nn (double x, double df)
{
  return gsl_ran_chisq_pdf (x, df);
}

static inline double 
eval_OP_PDF_EXP_nn (double x, double a)
{
  return gsl_ran_exponential_pdf (x, 1. / a);
}

static inline double 
eval_OP_PDF_F_nnn (double x, double df1, double df2)
{
  return gsl_ran_fdist_pdf (x, df1, df2);
}

static inline double 
eval_OP_PDF_GAMMA_nnn (double x, double a, double b)
{
  return gsl_ran_gamma_pdf (x, a, 1. / b);
}

static inline double 
eval_OP_PDF_GEOM_nn (double k, double p)
{
  return gsl_ran_geometric_pdf (k, p);
}

static inline double 
eval_OP_PDF_HYPER_nnnn (double k, double a, double b, double c)
{
  return gsl_ran_hypergeometric_pdf (k, c, a - c, b);
}

static inline double 
eval_OP_PDF_LANDAU_n (double x)
{
  return gsl_ran_landau_pdf (x);
}

static inline double 
eval_OP_PDF_LAPLACE_nnn (double x, double a, double b)
{
  return gsl_ran_laplace_pdf ((x - a) / b, 1) / b;
}

static inline double 
eval_OP_PDF_LNORMAL_nnn (double x, double m, double s)
{
  return gsl_ran_lognormal_pdf (x, log (m), s);
}

static inline double 
eval_OP_PDF_LOG_nn (double k, double p)
{
  return gsl_ran_logarithmic_pdf (k, p);
}

static inline double 
eval_OP_PDF_LOGISTIC_nnn (double x, double a, double b)
{
  return gsl_ran_logistic_pdf ((x - a) / b, 1) / b;
}

static inline double 
eval_OP_PDF_NEGBIN_nnn (double k, double n, double p)
{
  return gsl_ran_negative_binomial_pdf (k, p, n);
}

static inline double 
eval_OP_PDF_NORMAL_nnn (double x, double u, double s)
{
  return gsl_ran_gaussian_pdf ((x - u) / s, 1) / s;
}

static inline double 
eval_OP_PDF_NTAIL_nnn (double x, double a, double sigma)
{
  return gsl_ran_gaussian_tail_pdf (x, a, sigma);
}

static inline double 
eval_OP_PDF_PARETO_nnn (double x, double a, double b)
{
  return gsl_ran_pareto_pdf (x, b, a);
}

static inline double 
eval_OP_PDF_POISSON_nn (double k, double mu)
{
  return gsl_ran_poisson_pdf (k, mu);
}

static inline double 
eval_OP_PDF_RAYLEIGH_nn (double x, double sigma)
{
  return gsl_ran_rayleigh_pdf (x, sigma);
}

static inline double 
eval_OP_PDF_RTAIL_nnn (double x, double a, double sigma)
{
  return gsl_ran_rayleigh_tail_pdf (x, a, sigma);
}

static inline double 
eval_OP_PDF_T_nn (double x, double df)
{
  return gsl_ran_tdist_pdf (x, df);
}

static inline double 
eval_OP_PDF_T1G_nnn (double x, double a, double b)
{
  return gsl_ran_gumbel1_pdf (x, a, b);
}

static inline double 
eval_OP_PDF_T2G_nnn (double x, double a, double b)
{
  return gsl_ran_gumbel2_pdf (x, a, b);
}

static inline double 
eval_OP_PDF_UNIFORM_nnn (double x, double a, double b)
{
  return gsl_ran_flat_pdf (x, a, b);
}

static inline double 
eval_OP_PDF_WEIBULL_nnn (double x, double a, double b)
{
  return gsl_ran_weibull_pdf (x, a, b);
}

static inline double 
eval_OP_PDF_XPOWER_nnn (double x, double a, double b)
{
  return gsl_ran_exppow_pdf (x, a, b);
}

static inline double 
eval_OP_PROBIT_n (double P)
{
  return gsl_cdf_ugaussian_Pinv (P);
}

static inline double 
eval_OP_RANGE_nn (double x, double a[], size_t n)
{
  bool found = false;
  bool valid = false;
  for (size_t i = 0; i < n; i++)
    {
      double w = a[2 * i];
      double y = a[2 * i + 1];
      if (w != SYSMIS && y != SYSMIS)
        {
          if (w <= x && x <= y)
            found = true;
          else if (w <= y)
            valid = true;
          else
            return SYSMIS;
        }
    }
  return found ? true : valid ? false : SYSMIS;
}

static inline double 
eval_OP_RANGE_ss (struct substring x, struct substring a[], size_t n)
{
  bool found = false;
  for (size_t i = 0; i < n; i++)
    {
      struct substring *w = &a[2 * i];
      struct substring *y = &a[2 * i + 1];
      if (compare_string_3way (w, &x) <= 0 && compare_string_3way (&x, y) <= 0)
        found = true;
      else if (compare_string_3way (w, y) > 0)
        return SYSMIS;
    }
  return found;
}

static inline struct substring 
eval_OP_REPLACE_sss (struct substring haystack, struct substring needle, struct substring replacement, struct expression *e)
{
  return replace_string (e, haystack, needle, replacement, INT_MAX);
}

static inline struct substring 
eval_OP_REPLACE_sssn (struct substring haystack, struct substring needle, struct substring replacement, int n, struct expression *e)
{
  return replace_string (e, haystack, needle, replacement, n);
}

static inline double 
eval_OP_RINDEX_ss (struct substring haystack, struct substring needle)
{
  if (haystack.length >= needle.length)
    {
      size_t limit = haystack.length - needle.length + 1;
      for (size_t i = limit; i >= 1; i--)
        if (!memcmp (&haystack.string[i - 1], needle.string, needle.length))
          return i;
    }

  return 0;
}

static inline double 
eval_OP_RINDEX_ssn (struct substring haystack, struct substring needles, int needle_len, struct expression *e, const struct expr_node *n)
{
  if (needle_len <= 0 || needles.length % needle_len != 0)
    {
      msg_at (SE, expr_location (e, n),
              _("RINDEX needle length argument must evenly divide the "
                "length of the needles argument."));
      msg_at (SN, expr_location (e, n->args[1]),
              _("The needles argument has length %zu."), needles.length);
      msg_at (SN, expr_location (e, n->args[2]),
              _("The needle length argument has value %d."), needle_len);
      return SYSMIS;
    }

  if (haystack.length >= needle_len)
    {
      size_t limit = haystack.length - needle_len + 1;
      for (size_t i = limit; i >= 1; i--)
        for (size_t j = 0; j < needles.length; j += needle_len)
          if (!memcmp (&haystack.string[i - 1], &needles.string[j], needle_len))
            return i;
    }

  return 0;
}

static inline double 
eval_OP_RND_n (double x)
{
  return round_nearest (x, 1, 0);
}

static inline double 
eval_OP_RND_nn (double x, double mult)
{
  return round_nearest (x, mult, 0);
}

static inline double 
eval_OP_RND_nnn (double x, double mult, double fuzzbits)
{
  return round_nearest (x, mult, fuzzbits);
}

static inline struct substring 
eval_OP_RPAD_sn (struct substring s, int n, struct expression *e, const struct expr_node *node)
{
  if (n < 0 || n > MAX_STRING)
    {
      if (n != INT_MIN)
        {
          msg_at (SE, expr_location (e, node),
                  _("The length argument to RPAD must be between 0 and %d."),
                  MAX_STRING);
          msg_at (SN, expr_location (e, node->args[1]),
                  _("The length argument is %d."), n);
        }

      return s;
    }
  else if (s.length >= n)
    return s;
  else
    {
      struct substring t = alloc_string (e, n);
      size_t pad = n - s.length;
      memcpy (t.string, s.string, s.length);
      memset (t.string + s.length, ' ', pad);
      return t;
    }
}

static inline struct substring 
eval_OP_RPAD_sns (struct substring s, int n, struct substring c, struct expression *e, const struct expr_node *node)
{
  if (n < 0 || n > MAX_STRING)
    {
      if (n != INT_MIN)
        {
          msg_at (SE, expr_location (e, node),
                  _("The length argument to RPAD must be between 0 and %d."),
                  MAX_STRING);
          msg_at (SN, expr_location (e, node->args[1]),
                  _("The length argument is %d."), n);
        }

      return s;
    }
  else if (s.length >= n)
    return s;
  else if (c.length == 0)
    {
      msg_at (SE, expr_location (e, node),
              _("The padding argument to RPAD must not be an empty string."));
      return s;
    }
  else
    {
      size_t n_pad = (n - s.length) / c.length;
      if (!n_pad)
        return s;

      struct substring t = alloc_string (e, n);
      memcpy (t.string, s.string, s.length);
      t.length = s.length;
      for (size_t i = 0; i < n_pad; i++)
        {
          memcpy (t.string + t.length, c.string, c.length);
          t.length += c.length;
        }
      return t;
    }
}

static inline struct substring 
eval_OP_RTRIM_s (struct substring s)
{
  while (s.length > 0 && s.string[s.length - 1] == ' ')
    s.length--;
  return s;
}

static inline struct substring 
eval_OP_RTRIM_ss (struct substring s, struct substring c)
{
  if (c.length > 0)
    while (s.length >= c.length
           && !memcmp (&s.string[s.length - c.length], c.string, c.length))
      s.length -= c.length;
  return s;
}

static inline double 
eval_OP_RV_BERNOULLI_n (double p)
{
  return gsl_ran_bernoulli (get_rng (), p);
}

static inline double 
eval_OP_RV_BETA_nn (double a, double b)
{
  return gsl_ran_beta (get_rng (), a, b);
}

static inline double 
eval_OP_RV_BINOM_nn (double p, double n)
{
  return gsl_ran_binomial (get_rng (), p, n);
}

static inline double 
eval_OP_RV_CAUCHY_nn (double a, double b)
{
  return a + b * gsl_ran_cauchy (get_rng (), 1);
}

static inline double 
eval_OP_RV_CHISQ_n (double df)
{
  return gsl_ran_chisq (get_rng (), df);
}

static inline double 
eval_OP_RV_EXP_n (double a)
{
  return gsl_ran_exponential (get_rng (), 1. / a);
}

static inline double 
eval_OP_RV_F_nn (double df1, double df2)
{
  return gsl_ran_fdist (get_rng (), df1, df2);
}

static inline double 
eval_OP_RV_GAMMA_nn (double a, double b)
{
  return gsl_ran_gamma (get_rng (), a, 1. / b);
}

static inline double 
eval_OP_RV_GEOM_n (double p)
{
  return gsl_ran_geometric (get_rng (), p);
}

static inline double 
eval_OP_RV_HYPER_nnn (double a, double b, double c)
{
  return gsl_ran_hypergeometric (get_rng (), c, a - c, b);
}

static inline double 
eval_OP_RV_LANDAU_ (void)
{
  return gsl_ran_landau (get_rng ());
}

static inline double 
eval_OP_RV_LAPLACE_nn (double a, double b)
{
  return a + b * gsl_ran_laplace (get_rng (), 1);
}

static inline double 
eval_OP_RV_LEVY_nn (double c, double alpha)
{
  return gsl_ran_levy (get_rng (), c, alpha);
}

static inline double 
eval_OP_RV_LNORMAL_nn (double m, double s)
{
  return gsl_ran_lognormal (get_rng (), log (m), s);
}

static inline double 
eval_OP_RV_LOG_n (double p)
{
  return gsl_ran_logarithmic (get_rng (), p);
}

static inline double 
eval_OP_RV_LOGISTIC_nn (double a, double b)
{
  return a + b * gsl_ran_logistic (get_rng (), 1);
}

static inline double 
eval_OP_RV_LVSKEW_nnn (double c, double alpha, double beta)
{
  return gsl_ran_levy_skew (get_rng (), c, alpha, beta);
}

static inline double 
eval_OP_RV_NEGBIN_nn (double n, double p)
{
  return gsl_ran_negative_binomial (get_rng (), p, n);
}

static inline double 
eval_OP_RV_NORMAL_nn (double u, double s)
{
  return u + gsl_ran_gaussian (get_rng (), s);
}

static inline double 
eval_OP_RV_NTAIL_nn (double a, double sigma)
{
  return gsl_ran_gaussian_tail (get_rng (), a, sigma);
}

static inline double 
eval_OP_RV_PARETO_nn (double a, double b)
{
  return gsl_ran_pareto (get_rng (), b, a);
}

static inline double 
eval_OP_RV_POISSON_n (double mu)
{
  return gsl_ran_poisson (get_rng (), mu);
}

static inline double 
eval_OP_RV_RAYLEIGH_n (double sigma)
{
  return gsl_ran_rayleigh (get_rng (), sigma);
}

static inline double 
eval_OP_RV_RTAIL_nn (double a, double sigma)
{
  return gsl_ran_rayleigh_tail (get_rng (), a, sigma);
}

static inline double 
eval_OP_RV_T_n (double df)
{
  return gsl_ran_tdist (get_rng (), df);
}

static inline double 
eval_OP_RV_T1G_nn (double a, double b)
{
  return gsl_ran_gumbel1 (get_rng (), a, b);
}

static inline double 
eval_OP_RV_T2G_nn (double a, double b)
{
  return gsl_ran_gumbel2 (get_rng (), a, b);
}

static inline double 
eval_OP_RV_UNIFORM_nn (double a, double b)
{
  return gsl_ran_flat (get_rng (), a, b);
}

static inline double 
eval_OP_RV_WEIBULL_nn (double a, double b)
{
  return gsl_ran_weibull (get_rng (), a, b);
}

static inline double 
eval_OP_RV_XPOWER_nn (double a, double b)
{
  return gsl_ran_exppow (get_rng (), a, b);
}

static inline double 
eval_OP_SD_n (double a[], size_t n)
{
  double variance;
  moments_of_doubles (a, n, NULL, NULL, &variance, NULL, NULL);
  return sqrt (variance);
}

static inline double 
eval_OP_SIG_CHISQ_nn (double x, double df)
{
  return gsl_cdf_chisq_Q (x, df);
}

static inline double 
eval_OP_SIG_F_nnn (double x, double df1, double df2)
{
  return gsl_cdf_fdist_Q (x, df1, df2);
}

static inline double 
eval_OP_SIN_n (double x)
{
  return sin (x);
}

static inline double 
eval_OP_SQRT_n (double x)
{
  return sqrt (x);
}

static inline struct substring 
eval_OP_STRING_nf (double x, struct fmt_spec f, struct expression *e)
{
  union value v;
  struct substring dst;
  char *s;

  v.f = x;

  assert (!fmt_is_string (f.type));
  s = data_out (&v, C_ENCODING, f, settings_get_fmt_settings ());
  dst = alloc_string (e, strlen (s));
  strcpy (dst.string, s);
  free (s);
  return dst;
}

static inline struct substring 
eval_OP_STRUNC_sn (struct substring s, int n)
{
  if (n < 1)
    return n == INT_MIN ? s : empty_string;

  if (n < s.length)
    s.length = n;
  while (s.length > 0 && s.string[s.length - 1] == ' ')
    s.length--;
  return s;
}

static inline struct substring 
eval_OP_SUBSTR_sn (struct substring s, int ofs)
{
  return (ofs >= 1 && ofs <= s.length
          ? ss_substr (s, ofs - 1, SIZE_MAX)
          : empty_string);
}

static inline struct substring 
eval_OP_SUBSTR_snn (struct substring s, int ofs, int len)
{
  return (ofs >= 1 && len >= 1
          ? ss_substr (s, ofs - 1, len)
          : empty_string);
}

static inline double 
eval_OP_SUM_n (double a[], size_t n)
{
  double sum;
  size_t i;

  sum = 0.;
  for (i = 0; i < n; i++)
    if (a[i] != SYSMIS)
      sum += a[i];
  return sum;
}

static inline double 
eval_OP_SYSMIS_Vn (const struct variable *v, const struct ccase *c)
{
  return case_num (c, v) == SYSMIS;
}

static inline double 
eval_OP_SYSMIS_n (double x)
{
  return x == SYSMIS || !isfinite (x);
}

static inline double 
eval_OP_TAN_n (double x)
{
  return check_errno (tan (x));
}

static inline double 
eval_OP_TIME_DAYS_n (double days)
{
  return days * DAY_S;
}

static inline double 
eval_OP_TIME_HMS_nnn (double h, double m, double s, struct expression *e, const struct expr_node *n)
{
  if ((h > 0. || m > 0. || s > 0.) && (h < 0. || m < 0. || s < 0.))
    {
      msg_at (SW, expr_location (e, n),
              _("TIME.HMS cannot accept a mix of positive and negative "
                "arguments."));
      double args[] = { h, m, s };
      for (size_t i = 0; i < 3; i++)
        if (args[i] > 0)
          msg_at (SN, expr_location (e, n->args[i]),
                  _("This argument has positive value %g."), args[i]);
        else if (args[i] < 0)
          msg_at (SN, expr_location (e, n->args[i]),
                  _("This argument has negative value %g."), args[i]);
      return SYSMIS;
    }
  else
    return H_S * h + MIN_S * m + s;
}

static inline double 
eval_OP_TRUNC_n (double x)
{
  return round_zero (x, 1, 0);
}

static inline double 
eval_OP_TRUNC_nn (double x, double mult)
{
  return round_zero (x, mult, 0);
}

static inline double 
eval_OP_TRUNC_nnn (double x, double mult, double fuzzbits)
{
  return round_zero (x, mult, fuzzbits);
}

static inline double 
eval_OP_UNIFORM_n (double b)
{
  return gsl_ran_flat (get_rng (), 0, b);
}

static inline struct substring 
eval_OP_UPCASE_s (struct substring s)
{
  int i;

  for (i = 0; i < s.length; i++)
    s.string[i] = toupper ((unsigned char) s.string[i]);
  return s;
}

static inline double 
eval_OP_VALUE_Vn (const struct variable *v, const struct ccase *c)
{
  return case_num (c, v);
}

static inline double 
eval_OP_VALUE_n (double v)
{
  return v;
}

static inline struct substring 
eval_OP_VALUELABEL_V (const struct variable *v, struct expression *e, const struct ccase *c)
{
  const char *label = var_lookup_value_label (v, case_data (c, v));
  if (label != NULL)
    return copy_string (e, label, strlen (label));
  else
    return empty_string;
}

static inline double 
eval_OP_VARIANCE_n (double a[], size_t n)
{
  double variance;
  moments_of_doubles (a, n, NULL, NULL, &variance, NULL, NULL);
  return variance;
}

static inline double 
eval_OP_XDATE_DATE_n (double date)
{
  return floor (date / DAY_S) * DAY_S;
}

static inline double 
eval_OP_XDATE_HOUR_n (double date)
{
  return fmod (floor (date / H_S), DAY_H);
}

static inline double 
eval_OP_XDATE_JDAY_n (double date)
{
  return calendar_offset_to_yday (date / DAY_S);
}

static inline double 
eval_OP_XDATE_MDAY_n (double date)
{
  return calendar_offset_to_mday (date / DAY_S);
}

static inline double 
eval_OP_XDATE_MINUTE_n (double date)
{
  return fmod (floor (date / H_MIN), H_MIN);
}

static inline double 
eval_OP_XDATE_MONTH_n (double date)
{
  return calendar_offset_to_month (date / DAY_S);
}

static inline double 
eval_OP_XDATE_QUARTER_n (double date)
{
  return (calendar_offset_to_month (date / DAY_S) - 1) / 3 + 1;
}

static inline double 
eval_OP_XDATE_SECOND_n (double date)
{
  return fmod (date, MIN_S);
}

static inline double 
eval_OP_XDATE_TDAY_n (double date)
{
  return floor (date / DAY_S);
}

static inline double 
eval_OP_XDATE_TIME_n (double date)
{
  return fmod (date, DAY_S);
}

static inline double 
eval_OP_XDATE_WEEK_n (double date)
{
  return (calendar_offset_to_yday (date / DAY_S) - 1) / 7 + 1;
}

static inline double 
eval_OP_XDATE_WKDAY_n (double date)
{
  return calendar_offset_to_wday (date / DAY_S);
}

static inline double 
eval_OP_XDATE_YEAR_n (double date)
{
  return calendar_offset_to_year (date / DAY_S);
}

static inline double 
eval_OP_YRMODA_nnn (int y, int m, int d, struct expression *e, const struct expr_node *n)
{
  if (y >= 0 && y <= 99)
    y += 1900;
  else if (y > 47516)
    {
      msg_at (SE, expr_location (e, n->args[0]),
              _("The year argument to YRMODA is greater than 47516.  "
                "The result will be system-missing."));
      return SYSMIS;
    }

  return expr_ymd_to_ofs (y, m, d, e, n, 1, 2, 3);
}

static inline double 
eval_OP_ADD (double a, double b)
{
  return a + b;
}

static inline double 
eval_OP_AND (double a, double b)
{
  return (a == 0. ? 0.
   : b == 0. ? 0.
   : b == SYSMIS ? SYSMIS
   : a);
}

static inline double 
eval_OP_BOOLEAN_TO_NUM (double x)
{
  return x;
}

static inline double 
eval_OP_CASENUM (size_t idx)
{
  return idx;
}

static inline double 
eval_OP_DIV (double a, double b)
{
  return (a == 0. ? 0.
   : a == SYSMIS || b == SYSMIS ? SYSMIS
   : a / b);
}

static inline double 
eval_OP_EQ (double a, double b)
{
  return a == b;
}

static inline double 
eval_OP_EQ_STRING (struct substring a, struct substring b)
{
  return compare_string_3way (&a, &b) == 0;
}

static inline double 
eval_OP_EXPR_TO_BOOLEAN (double x, struct expression *e, const struct expr_node *n)
{
  if (x == 0. || x == 1. || x == SYSMIS)
    return x;

  msg_at (SE, expr_location (e, n),
          _("This expression, which must be 0 or 1, evaluated to %g.  "
            "It will be treated as 0."), x);
  return 0.;
}

static inline double 
eval_OP_GE (double a, double b)
{
  return a >= b;
}

static inline double 
eval_OP_GE_STRING (struct substring a, struct substring b)
{
  return compare_string_3way (&a, &b) >= 0;
}

static inline double 
eval_OP_GT (double a, double b)
{
  return a > b;
}

static inline double 
eval_OP_GT_STRING (struct substring a, struct substring b)
{
  return compare_string_3way (&a, &b) > 0;
}

static inline double 
eval_OP_LE (double a, double b)
{
  return a <= b;
}

static inline double 
eval_OP_LE_STRING (struct substring a, struct substring b)
{
  return compare_string_3way (&a, &b) <= 0;
}

static inline double 
eval_OP_LT (double a, double b)
{
  return a < b;
}

static inline double 
eval_OP_LT_STRING (struct substring a, struct substring b)
{
  return compare_string_3way (&a, &b) < 0;
}

static inline double 
eval_OP_MUL (double a, double b)
{
  return (a == 0. || b == 0. ? 0.
   : a == SYSMIS || b == SYSMIS ? SYSMIS
   : a * b);
}

static inline double 
eval_OP_NE (double a, double b)
{
  return a != b;
}

static inline double 
eval_OP_NEG (double x)
{
  return -x;
}

static inline double 
eval_OP_NE_STRING (struct substring a, struct substring b)
{
  return compare_string_3way (&a, &b) != 0;
}

static inline double 
eval_OP_NOT (double a)
{
  return (a == 0. ? 1.
   : a == 1. ? 0.
   : SYSMIS);
}

static inline double 
eval_OP_NUM_SYS (const struct ccase *c, const struct variable *v)
{
  return case_num (c, v) == SYSMIS;
}

static inline double 
eval_OP_NUM_TO_INTEGER (double x, struct expression *e, const struct expr_node *n)
{
  if (x == floor (x) && x > INT_MIN && x <= INT_MAX)
    return x;

  msg_at (SE, expr_location (e, n),
          _("Treating unexpected non-integer value %g as missing."), x);
  return SYSMIS;
}

static inline double 
eval_OP_NUM_VAL (const struct ccase *c, const struct variable *v)
{
  return case_num (c, v);
}

static inline double 
eval_OP_NUM_VAR (const struct ccase *c, const struct variable *v)
{
  double d = case_num (c, v);
  return var_is_num_missing (v, d) ? SYSMIS : d;
}

static inline double 
eval_OP_OPERAND_TO_BOOLEAN (double x, const struct expr_node *parent, struct expression *e, const struct expr_node *n)
{
  if (x == 0. || x == 1. || x == SYSMIS)
    return x;

  switch (parent->n_args)
    {
    case 2:
      msg_at (SE, expr_location (e, parent),
              /* TRANSLATORS: There are exactly two operands. */
              _("The operands of %s must have value 0 or 1."),
              operations[parent->type].name);
      break;

    case 1:
      msg_at (SE, expr_location (e, parent),
              _("The operand of %s must have value 0 or 1."),
              operations[parent->type].name);
      break;

    default:
      NOT_REACHED ();
    }

  msg_at (SN, expr_location (e, n),
          _("This operand with unexpected value %g will be treated as 0."), x);
  return 0.;
}

static inline double 
eval_OP_OR (double a, double b)
{
  return (a == 1. ? 1.
   : b == 1. ? 1.
   : b == SYSMIS ? SYSMIS
   : a);
}

static inline double 
eval_OP_POW (double a, double b)
{
  return (a == SYSMIS ? (b == 0. ? 1. : a)
   : b == SYSMIS ? (a == 0. ? 0. : SYSMIS)
   : a == 0. && b <= 0. ? SYSMIS
   : pow (a, b));
}

static inline double 
eval_OP_SQUARE (double x)
{
  return x * x;
}

static inline struct substring 
eval_OP_STR_VAR (const struct ccase *c, struct expression *e, const struct variable *v)
{
  struct substring s = alloc_string (e, var_get_width (v));
  memcpy (s.string, case_str (c, v), var_get_width (v));
  return s;
}

static inline double 
eval_OP_SUB (double a, double b)
{
  return a - b;
}

static inline double 
eval_OP_VEC_ELEM_NUM (double idx, const struct vector *v, const struct ccase *c, struct expression *e, const struct expr_node *n)
{
  const struct variable *var = expr_index_vector (e, n, v, idx);
  if (var)
    {
      double d = case_num (c, var);
      if (var_is_num_missing (var, d) != MV_USER)
        return d;
    }
  return SYSMIS;
}

static inline double 
eval_OP_VEC_ELEM_NUM_RAW (double idx, const struct vector *v, const struct ccase *c, struct expression *e, const struct expr_node *n)
{
  const struct variable *var = expr_index_vector (e, n, v, idx);
  return var ? case_num (c, var) : SYSMIS;
}

static inline struct substring 
eval_OP_VEC_ELEM_STR (double idx, struct expression *e, const struct vector *v, const struct ccase *c, const struct expr_node *n)
{
  const struct variable *var = expr_index_vector (e, n, v, idx);
  return (var
          ? copy_string (e, CHAR_CAST_BUG (char *, case_str (c, var)),
                         var_get_width (var))
          : empty_string);
}


/*
   Local Variables:
   mode: c
   buffer-read-only: t
   End:
*/
