from typing import Iterable, overload, List, TypeVar, overload
from collections.abc import MutableSequence

from ._value import AbstractBaseMutableTag
from ._dtype import AnyNBT
from ._int import ByteTag, ShortTag, IntTag, LongTag
from ._float import FloatTag, DoubleTag
from ._string import StringTag
from ._compound import CompoundTag
from ._array import ByteArrayTag, IntArrayTag, LongArrayTag

AnyNBTT = TypeVar("AnyNBTT", bound=AnyNBT)

class ListTag(AbstractBaseMutableTag, MutableSequence[AnyNBTT]):
    tag_id: int
    list_data_type: int
    @overload
    def __init__(self, value: Iterable[AnyNBTT] = ()) -> None: ...
    @overload
    def __init__(self, value: Iterable[AnyNBTT] = (), list_data_type=1) -> None: ...
    @property
    def py_list(self) -> List[AnyNBTT]: ...
    def copy(self) -> ListTag[AnyNBTT]: ...
    def get_byte(self, index: int) -> ByteTag: ...
    def get_short(self, index: int) -> ShortTag: ...
    def get_int(self, index: int) -> IntTag: ...
    def get_long(self, index: int) -> LongTag: ...
    def get_float(self, index: int) -> FloatTag: ...
    def get_double(self, index: int) -> DoubleTag: ...
    def get_string(self, index: int) -> StringTag: ...
    def get_list(self, index: int) -> ListTag: ...
    def get_compound(self, index: int) -> CompoundTag: ...
    def get_byte_array(self, index: int) -> ByteArrayTag: ...
    def get_int_array(self, index: int) -> IntArrayTag: ...
    def get_long_array(self, index: int) -> LongArrayTag: ...
    def __getitem__(self, item: int) -> AnyNBTT: ...
    def __setitem__(self, key: int, value: AnyNBTT) -> None: ...
    def __delitem__(self, key: int) -> None: ...
    def __len__(self) -> int: ...
    def insert(self, index: int, item: AnyNBTT) -> None: ...
