#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <srtp2/srtp.h>

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(srtp_crypto_policy_t *, srtp_profile_t)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 33), // srtp_crypto_policy_t *
/*  2 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // srtp_profile_t
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(srtp_ctx_t * *, srtp_policy_t const *)
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 9), // srtp_ctx_t * *
/*  6 */ _CFFI_OP(_CFFI_OP_POINTER, 36), // srtp_policy_t const *
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(srtp_ctx_t *)
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 34), // srtp_ctx_t *
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(srtp_ctx_t *, srtp_policy_t const *)
/* 12 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 13 */ _CFFI_OP(_CFFI_OP_NOOP, 6),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(srtp_ctx_t *, unsigned int)
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(srtp_ctx_t *, void *, int *)
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 21 */ _CFFI_OP(_CFFI_OP_POINTER, 42), // void *
/* 22 */ _CFFI_OP(_CFFI_OP_POINTER, 32), // int *
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 35), // srtp_err_status_t()(void)
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // unsigned int()(srtp_profile_t)
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 42), // void()(srtp_crypto_policy_t *)
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 33 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // srtp_crypto_policy_t
/* 34 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // srtp_ctx_t
/* 35 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // srtp_err_status_t
/* 36 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // srtp_policy_t
/* 37 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // srtp_ssrc_t
/* 38 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // srtp_ssrc_type_t
/* 39 */ _CFFI_OP(_CFFI_OP_POINTER, 40), // unsigned char *
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 41 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10), // unsigned long
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_srtp_err_status_ok(unsigned long long *o)
{
  int n = (srtp_err_status_ok) <= 0;
  *o = (unsigned long long)((srtp_err_status_ok) | 0);  /* check that srtp_err_status_ok is an integer */
  return n;
}

static int _cffi_const_srtp_profile_aes128_cm_sha1_80(unsigned long long *o)
{
  int n = (srtp_profile_aes128_cm_sha1_80) <= 0;
  *o = (unsigned long long)((srtp_profile_aes128_cm_sha1_80) | 0);  /* check that srtp_profile_aes128_cm_sha1_80 is an integer */
  return n;
}

static int _cffi_const_srtp_profile_aes128_cm_sha1_32(unsigned long long *o)
{
  int n = (srtp_profile_aes128_cm_sha1_32) <= 0;
  *o = (unsigned long long)((srtp_profile_aes128_cm_sha1_32) | 0);  /* check that srtp_profile_aes128_cm_sha1_32 is an integer */
  return n;
}

static int _cffi_const_srtp_profile_aead_aes_128_gcm(unsigned long long *o)
{
  int n = (srtp_profile_aead_aes_128_gcm) <= 0;
  *o = (unsigned long long)((srtp_profile_aead_aes_128_gcm) | 0);  /* check that srtp_profile_aead_aes_128_gcm is an integer */
  return n;
}

static int _cffi_const_srtp_profile_aead_aes_256_gcm(unsigned long long *o)
{
  int n = (srtp_profile_aead_aes_256_gcm) <= 0;
  *o = (unsigned long long)((srtp_profile_aead_aes_256_gcm) | 0);  /* check that srtp_profile_aead_aes_256_gcm is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_srtp_ssrc_t(srtp_ssrc_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { srtp_ssrc_type_t *tmp = &p->type; (void)tmp; }
  (void)((p->value) | 0);  /* check that 'srtp_ssrc_t.value' is an integer */
}
struct _cffi_align_typedef_srtp_ssrc_t { char x; srtp_ssrc_t y; };

static int _cffi_const_ssrc_undefined(unsigned long long *o)
{
  int n = (ssrc_undefined) <= 0;
  *o = (unsigned long long)((ssrc_undefined) | 0);  /* check that ssrc_undefined is an integer */
  return n;
}

static int _cffi_const_ssrc_specific(unsigned long long *o)
{
  int n = (ssrc_specific) <= 0;
  *o = (unsigned long long)((ssrc_specific) | 0);  /* check that ssrc_specific is an integer */
  return n;
}

static int _cffi_const_ssrc_any_inbound(unsigned long long *o)
{
  int n = (ssrc_any_inbound) <= 0;
  *o = (unsigned long long)((ssrc_any_inbound) | 0);  /* check that ssrc_any_inbound is an integer */
  return n;
}

static int _cffi_const_ssrc_any_outbound(unsigned long long *o)
{
  int n = (ssrc_any_outbound) <= 0;
  *o = (unsigned long long)((ssrc_any_outbound) | 0);  /* check that ssrc_any_outbound is an integer */
  return n;
}

static srtp_err_status_t _cffi_d_srtp_add_stream(srtp_ctx_t * x0, srtp_policy_t const * x1)
{
  return srtp_add_stream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_add_stream(PyObject *self, PyObject *args)
{
  srtp_ctx_t * x0;
  srtp_policy_t const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "srtp_add_stream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (srtp_policy_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_add_stream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_add_stream _cffi_d_srtp_add_stream
#endif

static srtp_err_status_t _cffi_d_srtp_create(srtp_ctx_t * * x0, srtp_policy_t const * x1)
{
  return srtp_create(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_create(PyObject *self, PyObject *args)
{
  srtp_ctx_t * * x0;
  srtp_policy_t const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "srtp_create", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(5), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(5), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(6), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (srtp_policy_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(6), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_create(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_create _cffi_d_srtp_create
#endif

static srtp_err_status_t _cffi_d_srtp_crypto_policy_set_from_profile_for_rtcp(srtp_crypto_policy_t * x0, srtp_profile_t x1)
{
  return srtp_crypto_policy_set_from_profile_for_rtcp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_crypto_policy_set_from_profile_for_rtcp(PyObject *self, PyObject *args)
{
  srtp_crypto_policy_t * x0;
  srtp_profile_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "srtp_crypto_policy_set_from_profile_for_rtcp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_crypto_policy_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(2), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_crypto_policy_set_from_profile_for_rtcp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_crypto_policy_set_from_profile_for_rtcp _cffi_d_srtp_crypto_policy_set_from_profile_for_rtcp
#endif

static srtp_err_status_t _cffi_d_srtp_crypto_policy_set_from_profile_for_rtp(srtp_crypto_policy_t * x0, srtp_profile_t x1)
{
  return srtp_crypto_policy_set_from_profile_for_rtp(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_crypto_policy_set_from_profile_for_rtp(PyObject *self, PyObject *args)
{
  srtp_crypto_policy_t * x0;
  srtp_profile_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "srtp_crypto_policy_set_from_profile_for_rtp", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_crypto_policy_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(2), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_crypto_policy_set_from_profile_for_rtp(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_crypto_policy_set_from_profile_for_rtp _cffi_d_srtp_crypto_policy_set_from_profile_for_rtp
#endif

static void _cffi_d_srtp_crypto_policy_set_rtcp_default(srtp_crypto_policy_t * x0)
{
  srtp_crypto_policy_set_rtcp_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_crypto_policy_set_rtcp_default(PyObject *self, PyObject *arg0)
{
  srtp_crypto_policy_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_crypto_policy_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { srtp_crypto_policy_set_rtcp_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_srtp_crypto_policy_set_rtcp_default _cffi_d_srtp_crypto_policy_set_rtcp_default
#endif

static void _cffi_d_srtp_crypto_policy_set_rtp_default(srtp_crypto_policy_t * x0)
{
  srtp_crypto_policy_set_rtp_default(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_crypto_policy_set_rtp_default(PyObject *self, PyObject *arg0)
{
  srtp_crypto_policy_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_crypto_policy_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { srtp_crypto_policy_set_rtp_default(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_srtp_crypto_policy_set_rtp_default _cffi_d_srtp_crypto_policy_set_rtp_default
#endif

static srtp_err_status_t _cffi_d_srtp_dealloc(srtp_ctx_t * x0)
{
  return srtp_dealloc(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_dealloc(PyObject *self, PyObject *arg0)
{
  srtp_ctx_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_dealloc(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_dealloc _cffi_d_srtp_dealloc
#endif

static srtp_err_status_t _cffi_d_srtp_init(void)
{
  return srtp_init();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_init(PyObject *self, PyObject *noarg)
{
  srtp_err_status_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_init(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  return pyresult;
}
#else
#  define _cffi_f_srtp_init _cffi_d_srtp_init
#endif

static unsigned int _cffi_d_srtp_profile_get_master_key_length(srtp_profile_t x0)
{
  return srtp_profile_get_master_key_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_profile_get_master_key_length(PyObject *self, PyObject *arg0)
{
  srtp_profile_t x0;
  unsigned int result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(2), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_profile_get_master_key_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_srtp_profile_get_master_key_length _cffi_d_srtp_profile_get_master_key_length
#endif

static unsigned int _cffi_d_srtp_profile_get_master_salt_length(srtp_profile_t x0)
{
  return srtp_profile_get_master_salt_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_profile_get_master_salt_length(PyObject *self, PyObject *arg0)
{
  srtp_profile_t x0;
  unsigned int result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(2), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_profile_get_master_salt_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_srtp_profile_get_master_salt_length _cffi_d_srtp_profile_get_master_salt_length
#endif

static srtp_err_status_t _cffi_d_srtp_protect(srtp_ctx_t * x0, void * x1, int * x2)
{
  return srtp_protect(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_protect(PyObject *self, PyObject *args)
{
  srtp_ctx_t * x0;
  void * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "srtp_protect", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_protect(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_protect _cffi_d_srtp_protect
#endif

static srtp_err_status_t _cffi_d_srtp_protect_rtcp(srtp_ctx_t * x0, void * x1, int * x2)
{
  return srtp_protect_rtcp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_protect_rtcp(PyObject *self, PyObject *args)
{
  srtp_ctx_t * x0;
  void * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "srtp_protect_rtcp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_protect_rtcp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_protect_rtcp _cffi_d_srtp_protect_rtcp
#endif

static srtp_err_status_t _cffi_d_srtp_remove_stream(srtp_ctx_t * x0, unsigned int x1)
{
  return srtp_remove_stream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_remove_stream(PyObject *self, PyObject *args)
{
  srtp_ctx_t * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "srtp_remove_stream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_remove_stream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_remove_stream _cffi_d_srtp_remove_stream
#endif

static srtp_err_status_t _cffi_d_srtp_unprotect(srtp_ctx_t * x0, void * x1, int * x2)
{
  return srtp_unprotect(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_unprotect(PyObject *self, PyObject *args)
{
  srtp_ctx_t * x0;
  void * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "srtp_unprotect", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_unprotect(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_unprotect _cffi_d_srtp_unprotect
#endif

static srtp_err_status_t _cffi_d_srtp_unprotect_rtcp(srtp_ctx_t * x0, void * x1, int * x2)
{
  return srtp_unprotect_rtcp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_srtp_unprotect_rtcp(PyObject *self, PyObject *args)
{
  srtp_ctx_t * x0;
  void * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  srtp_err_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "srtp_unprotect_rtcp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (srtp_ctx_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = srtp_unprotect_rtcp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(35));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_srtp_unprotect_rtcp _cffi_d_srtp_unprotect_rtcp
#endif

_CFFI_UNUSED_FN
static void _cffi_checkfld__srtp_crypto_policy_t(srtp_crypto_policy_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
}
struct _cffi_align__srtp_crypto_policy_t { char x; srtp_crypto_policy_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__srtp_policy_t(srtp_policy_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { srtp_ssrc_t *tmp = &p->ssrc; (void)tmp; }
  { srtp_crypto_policy_t *tmp = &p->rtp; (void)tmp; }
  { srtp_crypto_policy_t *tmp = &p->rtcp; (void)tmp; }
  { unsigned char * *tmp = &p->key; (void)tmp; }
  (void)((p->window_size) | 0);  /* check that 'srtp_policy_t.window_size' is an integer */
  (void)((p->allow_repeat_tx) | 0);  /* check that 'srtp_policy_t.allow_repeat_tx' is an integer */
}
struct _cffi_align__srtp_policy_t { char x; srtp_policy_t y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "srtp_add_stream", (void *)_cffi_f_srtp_add_stream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 11), (void *)_cffi_d_srtp_add_stream },
  { "srtp_create", (void *)_cffi_f_srtp_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 4), (void *)_cffi_d_srtp_create },
  { "srtp_crypto_policy_set_from_profile_for_rtcp", (void *)_cffi_f_srtp_crypto_policy_set_from_profile_for_rtcp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_srtp_crypto_policy_set_from_profile_for_rtcp },
  { "srtp_crypto_policy_set_from_profile_for_rtp", (void *)_cffi_f_srtp_crypto_policy_set_from_profile_for_rtp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_srtp_crypto_policy_set_from_profile_for_rtp },
  { "srtp_crypto_policy_set_rtcp_default", (void *)_cffi_f_srtp_crypto_policy_set_rtcp_default, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d_srtp_crypto_policy_set_rtcp_default },
  { "srtp_crypto_policy_set_rtp_default", (void *)_cffi_f_srtp_crypto_policy_set_rtp_default, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d_srtp_crypto_policy_set_rtp_default },
  { "srtp_dealloc", (void *)_cffi_f_srtp_dealloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 8), (void *)_cffi_d_srtp_dealloc },
  { "srtp_err_status_ok", (void *)_cffi_const_srtp_err_status_ok, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "srtp_init", (void *)_cffi_f_srtp_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 24), (void *)_cffi_d_srtp_init },
  { "srtp_profile_aead_aes_128_gcm", (void *)_cffi_const_srtp_profile_aead_aes_128_gcm, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "srtp_profile_aead_aes_256_gcm", (void *)_cffi_const_srtp_profile_aead_aes_256_gcm, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "srtp_profile_aes128_cm_sha1_32", (void *)_cffi_const_srtp_profile_aes128_cm_sha1_32, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "srtp_profile_aes128_cm_sha1_80", (void *)_cffi_const_srtp_profile_aes128_cm_sha1_80, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "srtp_profile_get_master_key_length", (void *)_cffi_f_srtp_profile_get_master_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_srtp_profile_get_master_key_length },
  { "srtp_profile_get_master_salt_length", (void *)_cffi_f_srtp_profile_get_master_salt_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_srtp_profile_get_master_salt_length },
  { "srtp_protect", (void *)_cffi_f_srtp_protect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_srtp_protect },
  { "srtp_protect_rtcp", (void *)_cffi_f_srtp_protect_rtcp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_srtp_protect_rtcp },
  { "srtp_remove_stream", (void *)_cffi_f_srtp_remove_stream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 15), (void *)_cffi_d_srtp_remove_stream },
  { "srtp_unprotect", (void *)_cffi_f_srtp_unprotect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_srtp_unprotect },
  { "srtp_unprotect_rtcp", (void *)_cffi_f_srtp_unprotect_rtcp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_srtp_unprotect_rtcp },
  { "ssrc_any_inbound", (void *)_cffi_const_ssrc_any_inbound, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ssrc_any_outbound", (void *)_cffi_const_ssrc_any_outbound, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ssrc_specific", (void *)_cffi_const_ssrc_specific, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ssrc_undefined", (void *)_cffi_const_ssrc_undefined, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "type", offsetof(srtp_ssrc_t, type),
            sizeof(((srtp_ssrc_t *)0)->type),
            _CFFI_OP(_CFFI_OP_NOOP, 38) },
  { "value", offsetof(srtp_ssrc_t, value),
             sizeof(((srtp_ssrc_t *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 17) },
  { "ssrc", offsetof(srtp_policy_t, ssrc),
            sizeof(((srtp_policy_t *)0)->ssrc),
            _CFFI_OP(_CFFI_OP_NOOP, 37) },
  { "rtp", offsetof(srtp_policy_t, rtp),
           sizeof(((srtp_policy_t *)0)->rtp),
           _CFFI_OP(_CFFI_OP_NOOP, 33) },
  { "rtcp", offsetof(srtp_policy_t, rtcp),
            sizeof(((srtp_policy_t *)0)->rtcp),
            _CFFI_OP(_CFFI_OP_NOOP, 33) },
  { "key", offsetof(srtp_policy_t, key),
           sizeof(((srtp_policy_t *)0)->key),
           _CFFI_OP(_CFFI_OP_NOOP, 39) },
  { "window_size", offsetof(srtp_policy_t, window_size),
                   sizeof(((srtp_policy_t *)0)->window_size),
                   _CFFI_OP(_CFFI_OP_NOOP, 41) },
  { "allow_repeat_tx", offsetof(srtp_policy_t, allow_repeat_tx),
                       sizeof(((srtp_policy_t *)0)->allow_repeat_tx),
                       _CFFI_OP(_CFFI_OP_NOOP, 32) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$srtp_ssrc_t", 37, _CFFI_F_CHECK_FIELDS,
    sizeof(srtp_ssrc_t), offsetof(struct _cffi_align_typedef_srtp_ssrc_t, y), 0, 2 },
  { "srtp_crypto_policy_t", 33, 0,
    sizeof(srtp_crypto_policy_t), offsetof(struct _cffi_align__srtp_crypto_policy_t, y), 2, 0 },
  { "srtp_ctx_t_", 34, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "srtp_policy_t", 36, 0,
    sizeof(srtp_policy_t), offsetof(struct _cffi_align__srtp_policy_t, y), 2, 6 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$srtp_err_status_t", 35, _cffi_prim_int(sizeof(srtp_err_status_t), ((srtp_err_status_t)-1) <= 0),
    "srtp_err_status_ok" },
  { "$srtp_profile_t", 2, _cffi_prim_int(sizeof(srtp_profile_t), ((srtp_profile_t)-1) <= 0),
    "srtp_profile_aes128_cm_sha1_80,srtp_profile_aes128_cm_sha1_32,srtp_profile_aead_aes_128_gcm,srtp_profile_aead_aes_256_gcm" },
  { "$srtp_ssrc_type_t", 38, _cffi_prim_int(sizeof(srtp_ssrc_type_t), ((srtp_ssrc_type_t)-1) <= 0),
    "ssrc_undefined,ssrc_specific,ssrc_any_inbound,ssrc_any_outbound" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "srtp_crypto_policy_t", 33 },
  { "srtp_ctx_t", 34 },
  { "srtp_err_status_t", 35 },
  { "srtp_policy_t", 36 },
  { "srtp_profile_t", 2 },
  { "srtp_ssrc_t", 37 },
  { "srtp_ssrc_type_t", 38 },
  { "srtp_t", 9 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  24,  /* num_globals */
  4,  /* num_struct_unions */
  3,  /* num_enums */
  8,  /* num_typenames */
  NULL,  /* no includes */
  43,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__binding(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__binding(void) { return NULL; }
#  else
     init_binding(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__binding(void)
{
  return _cffi_init("pylibsrtp._binding", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_binding(void)
{
  _cffi_init("pylibsrtp._binding", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
