/* Generated by wayland-scanner 1.23.1 */

#ifndef XCOMPOSITE_SERVER_PROTOCOL_H
#define XCOMPOSITE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xcomposite The xcomposite protocol
 * @section page_ifaces_xcomposite Interfaces
 * - @subpage page_iface_qt_xcomposite - 
 * @section page_copyright_xcomposite Copyright
 * <pre>
 *
 * Copyright (C) 2015 The Qt Company Ltd.
 * Contact: http://www.qt.io/licensing/
 *
 * This file is part of the plugins of the Qt Toolkit.
 *
 * $QT_BEGIN_LICENSE:BSD$
 * You may use this file under the terms of the BSD license as follows:
 *
 * "Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * * Neither the name of The Qt Company Ltd nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 *
 * $QT_END_LICENSE$
 * </pre>
 */
struct qt_xcomposite;
struct wl_buffer;

#ifndef QT_XCOMPOSITE_INTERFACE
#define QT_XCOMPOSITE_INTERFACE
/**
 * @page page_iface_qt_xcomposite qt_xcomposite
 * @section page_iface_qt_xcomposite_api API
 * See @ref iface_qt_xcomposite.
 */
/**
 * @defgroup iface_qt_xcomposite The qt_xcomposite interface
 */
extern const struct wl_interface qt_xcomposite_interface;
#endif

/**
 * @ingroup iface_qt_xcomposite
 * @struct qt_xcomposite_interface
 */
struct qt_xcomposite_interface {
	/**
	 */
	void (*create_buffer)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t id,
			      uint32_t x_window,
			      int32_t width,
			      int32_t height);
};

#define QT_XCOMPOSITE_ROOT 0

/**
 * @ingroup iface_qt_xcomposite
 */
#define QT_XCOMPOSITE_ROOT_SINCE_VERSION 1

/**
 * @ingroup iface_qt_xcomposite
 */
#define QT_XCOMPOSITE_CREATE_BUFFER_SINCE_VERSION 1

/**
 * @ingroup iface_qt_xcomposite
 * Sends an root event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_xcomposite_send_root(struct wl_resource *resource_, const char *display_name, uint32_t root_window)
{
	wl_resource_post_event(resource_, QT_XCOMPOSITE_ROOT, display_name, root_window);
}

#ifdef  __cplusplus
}
#endif

#endif
