// This file was generated by qtwaylandscanner
// source file is /build/qt5-wayland-decorations/src/qtwayland/src/extensions/xcomposite.xml

#include "qwayland-server-xcomposite.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {
    qt_xcomposite::qt_xcomposite(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(client, id, version);
    }

    qt_xcomposite::qt_xcomposite(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(display, version);
    }

    qt_xcomposite::qt_xcomposite(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
        init(resource);
    }

    qt_xcomposite::qt_xcomposite()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
    {
    }

    qt_xcomposite::~qt_xcomposite()
    {
        for (auto resource : qAsConst(m_resource_map))
            resource->xcomposite_object = nullptr;

        if (m_resource)
            m_resource->xcomposite_object = nullptr;

        if (m_global) {
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void qt_xcomposite::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void qt_xcomposite::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    qt_xcomposite::Resource *qt_xcomposite::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    qt_xcomposite::Resource *qt_xcomposite::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void qt_xcomposite::init(struct ::wl_display *display, int version)
    {
        m_global = wl_global_create(display, &::qt_xcomposite_interface, version, this, bind_func);
        m_globalVersion = version;
        m_displayDestroyedListener.notify = qt_xcomposite::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *qt_xcomposite::interface()
    {
        return &::qt_xcomposite_interface;
    }

    qt_xcomposite::Resource *qt_xcomposite::xcomposite_allocate()
    {
        return new Resource;
    }

    void qt_xcomposite::xcomposite_bind_resource(Resource *)
    {
    }

    void qt_xcomposite::xcomposite_destroy_resource(Resource *)
    {
    }

    void qt_xcomposite::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        qt_xcomposite *that = static_cast<qt_xcomposite *>(data);
        that->add(client, id, qMin(that->m_globalVersion, version));
    }

    void qt_xcomposite::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        qt_xcomposite *that = static_cast<qt_xcomposite::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
    }

    void qt_xcomposite::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        qt_xcomposite *that = resource->xcomposite_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->xcomposite_destroy_resource(resource);

            that = resource->xcomposite_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }

    qt_xcomposite::Resource *qt_xcomposite::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::qt_xcomposite_interface, version, id);
        return bind(handle);
    }

    qt_xcomposite::Resource *qt_xcomposite::bind(struct ::wl_resource *handle)
    {
        Resource *resource = xcomposite_allocate();
        resource->xcomposite_object = this;

        wl_resource_set_implementation(handle, &m_qt_xcomposite_interface, resource, destroy_func);
        resource->handle = handle;
        xcomposite_bind_resource(resource);
        return resource;
    }
    qt_xcomposite::Resource *qt_xcomposite::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::qt_xcomposite_interface, &m_qt_xcomposite_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::qt_xcomposite_interface qt_xcomposite::m_qt_xcomposite_interface = {
        qt_xcomposite::handle_create_buffer
    };

    void qt_xcomposite::xcomposite_create_buffer(Resource *, uint32_t, uint32_t , int32_t , int32_t )
    {
    }


    void qt_xcomposite::handle_create_buffer(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        uint32_t x_window,
        int32_t width,
        int32_t height)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->xcomposite_object)) {
            return;
        }
        static_cast<qt_xcomposite *>(r->xcomposite_object)->xcomposite_create_buffer(
            r,
            id,
            x_window,
            width,
            height);
    }

    void qt_xcomposite::send_root(const QString &display_name, uint32_t root_window)
    {
        Q_ASSERT_X(m_resource, "qt_xcomposite::root", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call qt_xcomposite::root as it's not initialised");
            return;
        }
        send_root(
            m_resource->handle,
            display_name,
            root_window);
    }

    void qt_xcomposite::send_root(struct ::wl_resource *resource, const QString &display_name, uint32_t root_window)
    {
        qt_xcomposite_send_root(
            resource,
            display_name.toUtf8().constData(),
            root_window);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
