/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         SPICE_STYPE
/* Substitute the variable and function names.  */
#define yyparse         spice_parse
#define yylex           spice_lex
#define yyerror         spice_error
#define yydebug         spice_debug
#define yynerrs         spice_nerrs
#define yylval          spice_lval
#define yychar          spice_char

/* First part of user prologue.  */
#line 3 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"

/*
 * parse_spice.y - parser for a Spice netlist
 *
 * Copyright (C) 2004, 2005, 2006, 2007, 2009 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * $Id$
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#if defined(_WIN32) && defined(_MSC_VER)
#define strcasecmp stricmp
#endif

#define YYERROR_VERBOSE 42
#define YYDEBUG 1
#define YYMAXDEPTH 1000000

#include "check_spice.h"

// Converts the given string into upper case.
static char * spice_toupper (char * str) {
  for (unsigned int i = 0; i < strlen (str); i++) {
    if (str[i] >= 'a' && str[i] <= 'z') str[i] = toupper (str[i]);
  }
  return str;
}

// Creates a device instance.
static struct definition_t * spice_create_device (char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_COMPONENT;
  def->instance = spice_toupper (instance);
  def->type = (char *) calloc (2, 1);
  def->type[0] = def->instance[0];
  def->line = spice_lineno;
  return def;
}

// Creates an action instance.
static struct definition_t * spice_create_action (char * type,
						  char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_ACTION;
  def->instance = spice_toupper (instance);
  def->type = spice_toupper (type);
  def->line = spice_lineno;
  return def;
}

// Create a string value.
static struct value_t * spice_create_str_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = spice_toupper (value);
  val->hint |= hint;
  return val;
}

// Create a real value.
static struct value_t * spice_create_val_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = value;
  val->value = strtod (value, NULL);
  val->hint |= hint;
  return val;
}

// Create a key/value pair.
static struct value_t * spice_create_par_value (char * key, char * value) {
  struct value_t * val = spice_create_str_value (key, HINT_PAIR);
  val->unit = value;
  return val;
}

// Append a string value to the definition.
static void spice_append_str_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a string value to the given values.
static struct value_t * spice_append_str_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  return netlist_append_values (values, val);
}

// Append a real value to the definition.
static void spice_append_val_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a real value to the given values.
static struct value_t * spice_append_val_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  return netlist_append_values (values, val);
}


#line 207 "parse_spice.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parse_spice.hpp"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TitleLine = 3,                  /* TitleLine  */
  YYSYMBOL_InvalidCharacter = 4,           /* InvalidCharacter  */
  YYSYMBOL_End = 5,                        /* End  */
  YYSYMBOL_Eol = 6,                        /* Eol  */
  YYSYMBOL_Identifier = 7,                 /* Identifier  */
  YYSYMBOL_Digits = 8,                     /* Digits  */
  YYSYMBOL_Floats = 9,                     /* Floats  */
  YYSYMBOL_Nodes = 10,                     /* Nodes  */
  YYSYMBOL_Options = 11,                   /* Options  */
  YYSYMBOL_Function = 12,                  /* Function  */
  YYSYMBOL_SUBCKT_Action = 13,             /* SUBCKT_Action  */
  YYSYMBOL_ENDS_Action = 14,               /* ENDS_Action  */
  YYSYMBOL_AC_Action = 15,                 /* AC_Action  */
  YYSYMBOL_OP_Action = 16,                 /* OP_Action  */
  YYSYMBOL_I_Source = 17,                  /* I_Source  */
  YYSYMBOL_SAVE_Action = 18,               /* SAVE_Action  */
  YYSYMBOL_RLC_Device = 19,                /* RLC_Device  */
  YYSYMBOL_L_Device = 20,                  /* L_Device  */
  YYSYMBOL_K_Device = 21,                  /* K_Device  */
  YYSYMBOL_IV_Source = 22,                 /* IV_Source  */
  YYSYMBOL_GE_Source = 23,                 /* GE_Source  */
  YYSYMBOL_FH_Source = 24,                 /* FH_Source  */
  YYSYMBOL_V_Source = 25,                  /* V_Source  */
  YYSYMBOL_Diode_Device = 26,              /* Diode_Device  */
  YYSYMBOL_Bipolar_Device = 27,            /* Bipolar_Device  */
  YYSYMBOL_JFET_Device = 28,               /* JFET_Device  */
  YYSYMBOL_MOSFET_Device = 29,             /* MOSFET_Device  */
  YYSYMBOL_MESFET_Device = 30,             /* MESFET_Device  */
  YYSYMBOL_MODEL_Action = 31,              /* MODEL_Action  */
  YYSYMBOL_MODEL_Spec = 32,                /* MODEL_Spec  */
  YYSYMBOL_TRAN_Action = 33,               /* TRAN_Action  */
  YYSYMBOL_PLOT_Action = 34,               /* PLOT_Action  */
  YYSYMBOL_VoltFunc = 35,                  /* VoltFunc  */
  YYSYMBOL_CurrFunc = 36,                  /* CurrFunc  */
  YYSYMBOL_DC_Action = 37,                 /* DC_Action  */
  YYSYMBOL_PRINT_Action = 38,              /* PRINT_Action  */
  YYSYMBOL_OPTIONS_Action = 39,            /* OPTIONS_Action  */
  YYSYMBOL_WIDTH_Action = 40,              /* WIDTH_Action  */
  YYSYMBOL_NOISE_Action = 41,              /* NOISE_Action  */
  YYSYMBOL_PZ_Action = 42,                 /* PZ_Action  */
  YYSYMBOL_CurVol = 43,                    /* CurVol  */
  YYSYMBOL_PoleZero = 44,                  /* PoleZero  */
  YYSYMBOL_ALL_Special = 45,               /* ALL_Special  */
  YYSYMBOL_X_Device = 46,                  /* X_Device  */
  YYSYMBOL_O_Device = 47,                  /* O_Device  */
  YYSYMBOL_ModelProps = 48,                /* ModelProps  */
  YYSYMBOL_OFF_Special = 49,               /* OFF_Special  */
  YYSYMBOL_IC_Special = 50,                /* IC_Special  */
  YYSYMBOL_SIM_Type = 51,                  /* SIM_Type  */
  YYSYMBOL_TEMP_Special = 52,              /* TEMP_Special  */
  YYSYMBOL_MOS_Special = 53,               /* MOS_Special  */
  YYSYMBOL_B_Source = 54,                  /* B_Source  */
  YYSYMBOL_DISTO_Action = 55,              /* DISTO_Action  */
  YYSYMBOL_INCLUDE_Action = 56,            /* INCLUDE_Action  */
  YYSYMBOL_File = 57,                      /* File  */
  YYSYMBOL_BranchFunc = 58,                /* BranchFunc  */
  YYSYMBOL_NODESET_Action = 59,            /* NODESET_Action  */
  YYSYMBOL_T_Device = 60,                  /* T_Device  */
  YYSYMBOL_U_Device = 61,                  /* U_Device  */
  YYSYMBOL_S_Device = 62,                  /* S_Device  */
  YYSYMBOL_W_Device = 63,                  /* W_Device  */
  YYSYMBOL_ON_Special = 64,                /* ON_Special  */
  YYSYMBOL_TF_Action = 65,                 /* TF_Action  */
  YYSYMBOL_SENS_Action = 66,               /* SENS_Action  */
  YYSYMBOL_FOUR_Action = 67,               /* FOUR_Action  */
  YYSYMBOL_OpFunc = 68,                    /* OpFunc  */
  YYSYMBOL_Behave = 69,                    /* Behave  */
  YYSYMBOL_TC_Special = 70,                /* TC_Special  */
  YYSYMBOL_TEMP_Action = 71,               /* TEMP_Action  */
  YYSYMBOL_YYACCEPT = 72,                  /* $accept  */
  YYSYMBOL_Input = 73,                     /* Input  */
  YYSYMBOL_InputList = 74,                 /* InputList  */
  YYSYMBOL_InputLine = 75,                 /* InputLine  */
  YYSYMBOL_DefinitionLine = 76,            /* DefinitionLine  */
  YYSYMBOL_TC_Value_1 = 77,                /* TC_Value_1  */
  YYSYMBOL_TC_Value_2 = 78,                /* TC_Value_2  */
  YYSYMBOL_IC_Condition_1 = 79,            /* IC_Condition_1  */
  YYSYMBOL_IC_Condition_2 = 80,            /* IC_Condition_2  */
  YYSYMBOL_IC_Condition_3 = 81,            /* IC_Condition_3  */
  YYSYMBOL_IC_Condition_4 = 82,            /* IC_Condition_4  */
  YYSYMBOL_Output_Range = 83,              /* Output_Range  */
  YYSYMBOL_VOLTAGE_Output = 84,            /* VOLTAGE_Output  */
  YYSYMBOL_IV_Reference = 85,              /* IV_Reference  */
  YYSYMBOL_CURRENT_Output = 86,            /* CURRENT_Output  */
  YYSYMBOL_PLOT_List = 87,                 /* PLOT_List  */
  YYSYMBOL_SWITCH_State = 88,              /* SWITCH_State  */
  YYSYMBOL_PRINT_List = 89,                /* PRINT_List  */
  YYSYMBOL_OPTIONS_List = 90,              /* OPTIONS_List  */
  YYSYMBOL_MODEL_List = 91,                /* MODEL_List  */
  YYSYMBOL_NODESET_List = 92,              /* NODESET_List  */
  YYSYMBOL_DEVICE_List_1 = 93,             /* DEVICE_List_1  */
  YYSYMBOL_DEVICE_List_2 = 94,             /* DEVICE_List_2  */
  YYSYMBOL_DEVICE_List_3 = 95,             /* DEVICE_List_3  */
  YYSYMBOL_MODEL_Ident = 96,               /* MODEL_Ident  */
  YYSYMBOL_DC_List = 97,                   /* DC_List  */
  YYSYMBOL_Value = 98,                     /* Value  */
  YYSYMBOL_Node = 99,                      /* Node  */
  YYSYMBOL_FH_Node = 100,                  /* FH_Node  */
  YYSYMBOL_PairList = 101,                 /* PairList  */
  YYSYMBOL_ValueList = 102,                /* ValueList  */
  YYSYMBOL_NodeValueList = 103,            /* NodeValueList  */
  YYSYMBOL_NodeList = 104,                 /* NodeList  */
  YYSYMBOL_VSourceList = 105,              /* VSourceList  */
  YYSYMBOL_Expr = 106,                     /* Expr  */
  YYSYMBOL_ExprList = 107,                 /* ExprList  */
  YYSYMBOL_Subcircuit = 108,               /* Subcircuit  */
  YYSYMBOL_BeginSub = 109,                 /* BeginSub  */
  YYSYMBOL_SubBody = 110,                  /* SubBody  */
  YYSYMBOL_SubCkt_Ident = 111,             /* SubCkt_Ident  */
  YYSYMBOL_EndSub = 112,                   /* EndSub  */
  YYSYMBOL_SubBodyLine = 113               /* SubBodyLine  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined SPICE_STYPE_IS_TRIVIAL && SPICE_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  113
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   722

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  72
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  42
/* YYNRULES -- Number of rules.  */
#define YYNRULES  150
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  360

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   326


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71
};

#if SPICE_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   182,   182,   184,   187,   189,   194,   195,   199,   204,
     211,   215,   223,   232,   240,   248,   256,   264,   273,   280,
     287,   295,   310,   315,   324,   340,   345,   353,   360,   368,
     377,   386,   396,   407,   417,   426,   431,   437,   442,   446,
     451,   456,   462,   467,   473,   478,   483,   488,   495,   505,
     511,   521,   530,   539,   548,   557,   567,   571,   575,   579,
     583,   587,   591,   596,   604,   612,   619,   627,   635,   643,
     653,   664,   672,   678,   684,   694,   694,   697,   703,   709,
     717,   718,   721,   725,   728,   734,   735,   738,   743,   744,
     747,   752,   753,   757,   763,   764,   768,   772,   778,   779,
     788,   789,   793,   797,   801,   806,   807,   811,   815,   819,
     822,   828,   829,   833,   837,   841,   845,   850,   850,   853,
     863,   863,   865,   865,   865,   867,   867,   869,   870,   876,
     877,   883,   884,   888,   894,   895,   901,   902,   909,   916,
     917,   923,   931,   937,   938,   949,   952,   953,   957,   963,
     964
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if SPICE_DEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TitleLine",
  "InvalidCharacter", "End", "Eol", "Identifier", "Digits", "Floats",
  "Nodes", "Options", "Function", "SUBCKT_Action", "ENDS_Action",
  "AC_Action", "OP_Action", "I_Source", "SAVE_Action", "RLC_Device",
  "L_Device", "K_Device", "IV_Source", "GE_Source", "FH_Source",
  "V_Source", "Diode_Device", "Bipolar_Device", "JFET_Device",
  "MOSFET_Device", "MESFET_Device", "MODEL_Action", "MODEL_Spec",
  "TRAN_Action", "PLOT_Action", "VoltFunc", "CurrFunc", "DC_Action",
  "PRINT_Action", "OPTIONS_Action", "WIDTH_Action", "NOISE_Action",
  "PZ_Action", "CurVol", "PoleZero", "ALL_Special", "X_Device", "O_Device",
  "ModelProps", "OFF_Special", "IC_Special", "SIM_Type", "TEMP_Special",
  "MOS_Special", "B_Source", "DISTO_Action", "INCLUDE_Action", "File",
  "BranchFunc", "NODESET_Action", "T_Device", "U_Device", "S_Device",
  "W_Device", "ON_Special", "TF_Action", "SENS_Action", "FOUR_Action",
  "OpFunc", "Behave", "TC_Special", "TEMP_Action", "$accept", "Input",
  "InputList", "InputLine", "DefinitionLine", "TC_Value_1", "TC_Value_2",
  "IC_Condition_1", "IC_Condition_2", "IC_Condition_3", "IC_Condition_4",
  "Output_Range", "VOLTAGE_Output", "IV_Reference", "CURRENT_Output",
  "PLOT_List", "SWITCH_State", "PRINT_List", "OPTIONS_List", "MODEL_List",
  "NODESET_List", "DEVICE_List_1", "DEVICE_List_2", "DEVICE_List_3",
  "MODEL_Ident", "DC_List", "Value", "Node", "FH_Node", "PairList",
  "ValueList", "NodeValueList", "NodeList", "VSourceList", "Expr",
  "ExprList", "Subcircuit", "BeginSub", "SubBody", "SubCkt_Ident",
  "EndSub", "SubBodyLine", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-240)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-125)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     217,   589,  -240,    29,    27,    65,    83,   221,    81,   221,
     221,   201,   221,   221,   221,   221,   221,    62,   167,    64,
     134,    78,    12,    91,    39,   221,   221,   221,   116,    27,
      68,   104,   221,   221,   221,   221,   141,   146,   152,   167,
     161,   163,   589,  -240,  -240,   651,   174,  -240,   221,   167,
     180,  -240,  -240,  -240,  -240,  -240,   221,   175,   221,   221,
    -240,  -240,   201,   221,   221,   221,   221,   221,  -240,  -240,
     166,  -240,  -240,   167,   194,   147,  -240,  -240,  -240,   167,
     185,   221,   182,    92,  -240,  -240,   147,   147,   216,  -240,
     167,    12,   228,   167,   231,    18,   221,   221,   236,   221,
    -240,   246,   247,   221,   254,   221,   221,   221,   221,  -240,
    -240,  -240,   255,  -240,  -240,  -240,  -240,  -240,  -240,   213,
     651,  -240,   259,  -240,  -240,   103,   167,    33,    22,   -17,
      62,   221,   221,   221,   221,     8,  -240,  -240,   294,   294,
     263,   167,  -240,   264,   221,  -240,   268,   275,  -240,  -240,
    -240,    12,  -240,  -240,    91,  -240,    27,   221,  -240,  -240,
     221,  -240,  -240,   167,  -240,   221,   221,   221,   267,  -240,
      29,  -240,  -240,  -240,   278,    -5,   287,    27,    27,   288,
     124,   221,   167,   159,   154,   162,    62,   221,    62,   282,
       8,   289,   205,   147,  -240,   167,   147,  -240,  -240,   167,
    -240,  -240,  -240,  -240,  -240,  -240,   290,   221,   221,   104,
     221,    62,   221,    62,  -240,   291,   293,   167,    96,   167,
     304,   306,    91,   307,  -240,   308,  -240,  -240,  -240,    96,
     167,   310,  -240,   292,   154,   167,   167,   154,  -240,   154,
     109,   135,   162,   135,    62,   135,     8,     8,  -240,  -240,
    -240,  -240,  -240,  -240,  -240,   257,    62,  -240,    91,    91,
      62,   -27,  -240,  -240,    96,    96,   312,   167,  -240,  -240,
     313,  -240,  -240,   314,   315,  -240,   292,    96,  -240,  -240,
     154,  -240,  -240,   135,   167,   167,   167,   135,  -240,   135,
     135,    62,  -240,   140,  -240,  -240,  -240,   279,   316,    10,
     318,   -27,  -240,  -240,   319,  -240,  -240,  -240,  -240,  -240,
    -240,  -240,  -240,   325,  -240,  -240,   167,   135,   135,  -240,
    -240,  -240,   135,   140,   167,   167,   167,   140,  -240,   140,
     327,  -240,  -240,   167,   328,  -240,   330,  -240,  -240,  -240,
    -240,  -240,  -240,  -240,   167,   140,   140,  -240,  -240,  -240,
     167,  -240,  -240,   167,  -240,  -240,   167,  -240,   167,  -240
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       6,     6,    10,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
       0,    88,    91,   127,     0,     0,   134,     0,     0,     0,
       0,    98,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     4,     6,     9,     8,   143,     5,   145,   134,   129,
       0,    56,    57,   124,   122,   123,     0,     0,     0,     0,
     126,   125,     0,     0,     0,     0,     0,     0,   117,   118,
       0,   120,   121,   129,     0,    80,    38,    75,    76,     0,
       0,     0,     0,    88,    78,    79,    80,    80,     0,    72,
       0,    91,     0,     0,     0,     0,     0,   134,     0,     0,
      61,     0,     0,     0,     0,     0,     0,     0,     0,    59,
      58,    60,     0,     1,     2,     7,   150,   148,   149,     0,
     143,     3,     0,   138,    37,     0,     0,   139,     0,     0,
       0,     0,     0,     0,     0,    94,   130,    35,    80,    80,
       0,     0,    39,     0,    73,    77,     0,     0,    89,    90,
      42,    91,    92,    44,   127,    46,     0,     0,   135,    49,
       0,    62,    63,     0,    64,     0,     0,     0,     0,    45,
     146,   141,   144,   142,   127,   127,     0,   139,   139,     0,
       0,     0,     0,     0,   100,     0,     0,     0,     0,     0,
      94,     0,   122,    80,    81,     0,    80,    83,    36,     0,
      40,    74,    43,    41,    93,   128,     0,     0,     0,    98,
       0,     0,     0,     0,   147,     0,     0,   117,   131,     0,
       0,     0,   127,     0,    18,     0,   140,    19,    22,   131,
       0,     0,    25,   136,   100,     0,     0,   100,    28,   100,
     117,   105,     0,   105,     0,   105,    94,    94,    95,    27,
      82,    71,    84,   119,    47,     0,     0,    99,   127,   127,
       0,    85,    13,    14,   131,   131,     0,    65,    15,    16,
       0,    11,    20,     0,     0,    26,   136,   131,   103,    67,
     100,   104,   102,   105,     0,     0,     0,   105,    30,   105,
     105,     0,    29,   111,    34,    97,    96,     0,     0,     0,
       0,    85,    87,    86,     0,   133,   132,    17,    66,    12,
      21,    23,   137,     0,   101,   108,     0,   105,   105,   109,
     107,    31,   105,   111,     0,     0,     0,   111,    33,   111,
       0,    52,    54,     0,     0,    53,     0,    51,    24,    68,
     106,   110,    32,   115,     0,   111,   111,   116,   114,    48,
       0,    55,    50,     0,   112,   113,     0,    69,     0,    70
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -240,  -240,    16,  -240,   -40,  -240,  -240,  -240,  -240,  -240,
    -240,   198,   -10,   256,    -1,   -62,    48,   270,   -88,  -150,
     145,  -147,  -239,  -149,  -118,   276,   -18,   332,   298,  -141,
     -11,  -211,   -38,    74,    -3,    47,   -36,  -240,   235,   191,
    -240,  -240
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    40,    41,    42,    43,   220,   221,   237,   287,   327,
     334,   193,   138,    79,   139,   140,   304,    88,    92,   191,
     104,   238,   288,   328,    70,    80,   289,    89,    62,    94,
      74,   266,    98,   277,   178,   179,    44,    45,   119,    48,
     171,   120
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      73,    50,   217,   152,   292,   117,   294,   174,   182,   118,
     122,    86,   184,   205,    95,   189,   332,    46,   273,    90,
      87,    73,   302,    91,   148,   149,   101,    69,   112,    53,
      54,    73,    55,   216,   223,    77,    47,   303,   123,    49,
     248,    71,    72,    78,   315,    49,    53,    54,   319,    55,
     320,   321,   183,   305,   306,    73,   190,   222,   115,   158,
     333,   141,   136,   204,   218,   219,   313,   241,   243,    68,
     245,    51,   151,    86,    81,   154,   194,   197,   340,   341,
     117,   270,    87,   342,   118,    53,    54,   278,    55,    52,
     281,   180,   282,   259,    69,   261,   295,   296,    93,    53,
      54,    57,    55,    53,    54,   264,    55,   175,   176,   177,
      68,    71,    72,    81,    82,    75,  -124,   299,   300,  -124,
     195,   195,   100,   199,   290,   102,   293,    81,    82,    83,
     228,   250,   229,   314,   252,    69,    84,   146,   298,   103,
      76,  -124,   301,    71,    72,   209,    85,   109,    71,    72,
      84,    77,   110,   206,    53,    54,   215,    55,   111,    78,
      85,   113,    71,    72,   231,   232,   239,   233,   114,   240,
      54,   247,    55,   322,   343,    71,    72,   251,   347,   121,
     348,   253,    81,    82,   283,   284,   124,   285,   286,   323,
     324,   142,   325,   326,    69,   126,   354,   355,   135,   154,
     137,   267,    77,   234,   235,    84,   236,   145,    53,    54,
      78,    55,   274,  -120,  -120,    85,   239,   279,   280,   239,
       1,   239,   150,     2,   225,   226,    60,   170,    53,    54,
       3,    55,     4,     5,   153,     6,     7,   155,     8,     9,
      10,    11,   159,    12,    13,    14,    15,    16,    17,   308,
      18,    19,   161,   162,    20,    21,    22,    23,    24,    25,
     164,   169,   239,    26,    27,   173,   316,   317,   318,   198,
     200,    28,    29,    30,   202,   329,    31,    32,    33,    34,
      35,   203,    36,    37,    38,    93,    71,    72,    39,   246,
      71,    72,   213,   224,   227,   249,   254,   262,   339,   263,
     297,    53,   192,    72,    55,   329,   344,   345,   346,   329,
     268,   329,   269,   271,   272,   350,   275,   276,   307,   309,
     310,   311,   331,   330,   335,   337,   353,   329,   329,    81,
      82,   338,   356,   349,   351,   357,   352,   196,   358,    56,
     359,    58,    59,    61,    63,    64,    65,    66,    67,   336,
     312,   156,    84,   147,   257,   172,   143,    96,    97,    99,
     129,   214,    85,     0,   105,   106,   107,   108,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      97,     0,     0,     0,     0,     0,     0,     0,   125,     0,
     127,   128,     0,     0,    61,   130,   131,   132,   133,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   157,    97,
       0,   160,     0,     0,     0,   163,     0,   165,   166,   167,
     168,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,     0,     0,   185,   186,   187,   188,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   207,
       0,     0,   208,     0,     0,     0,     0,   210,   211,   212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   230,     0,     0,     0,   242,     0,   244,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   255,
     256,     0,   258,     0,   260,     0,     0,     0,     0,     0,
     265,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   265,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   291,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     2,   265,   265,     0,     0,
       0,     0,     3,     0,     4,     5,     0,     6,     7,   265,
       8,     9,    10,    11,     0,    12,    13,    14,    15,    16,
      17,     0,    18,    19,     0,     0,    20,    21,    22,    23,
      24,    25,     0,     0,     0,    26,    27,     0,     0,     0,
       0,     0,     0,    28,    29,    30,     0,     0,    31,    32,
      33,    34,    35,     0,    36,    37,    38,   116,     0,     0,
      39,     0,     0,     0,     3,     0,     4,     5,     0,     6,
       7,     0,     8,     9,    10,    11,     0,    12,    13,    14,
      15,    16,    17,     0,    18,    19,     0,     0,    20,    21,
      22,    23,    24,    25,     0,     0,     0,    26,    27,     0,
       0,     0,     0,     0,     0,    28,    29,    30,     0,     0,
      31,    32,    33,    34,    35,     0,    36,    37,    38,     0,
       0,     0,    39
};

static const yytype_int16 yycheck[] =
{
      18,     4,     7,    91,   243,    45,   245,   125,    25,    45,
      48,    21,   130,   154,    24,     7,     6,     1,   229,     7,
      21,    39,    49,    11,    86,    87,    29,    32,    39,     7,
       8,    49,    10,   174,   175,    17,     7,    64,    49,    12,
     190,     8,     9,    25,   283,    12,     7,     8,   287,    10,
     289,   290,    69,   264,   265,    73,    48,   175,    42,    97,
      50,    79,    73,   151,    69,    70,   277,   185,   186,     7,
     188,     6,    90,    83,    35,    93,   138,   139,   317,   318,
     120,   222,    83,   322,   120,     7,     8,   234,    10,     6,
     237,    69,   239,   211,    32,   213,   246,   247,     7,     7,
       8,    20,    10,     7,     8,     9,    10,   125,   126,   127,
       7,     8,     9,    35,    36,    51,     7,   258,   259,    10,
     138,   139,     6,   141,   242,    57,   244,    35,    36,    51,
       6,   193,     8,   280,   196,    32,    58,    45,   256,    35,
       6,    32,   260,     8,     9,   163,    68,     6,     8,     9,
      58,    17,     6,   156,     7,     8,   174,    10,     6,    25,
      68,     0,     8,     9,   182,     6,   184,     8,     5,     7,
       8,   189,    10,   291,   323,     8,     9,   195,   327,     5,
     329,   199,    35,    36,    49,    50,     6,    52,    53,    49,
      50,     6,    52,    53,    32,    20,   345,   346,    32,   217,
       6,   219,    17,    49,    50,    58,    52,    25,     7,     8,
      25,    10,   230,     8,     9,    68,   234,   235,   236,   237,
       3,   239,     6,     6,   177,   178,    25,    14,     7,     8,
      13,    10,    15,    16,     6,    18,    19,     6,    21,    22,
      23,    24,     6,    26,    27,    28,    29,    30,    31,   267,
      33,    34,     6,     6,    37,    38,    39,    40,    41,    42,
       6,     6,   280,    46,    47,     6,   284,   285,   286,     6,
       6,    54,    55,    56,     6,   293,    59,    60,    61,    62,
      63,     6,    65,    66,    67,     7,     8,     9,    71,     7,
       8,     9,    25,     6,     6,     6,     6,     6,   316,     6,
      43,     7,     8,     9,    10,   323,   324,   325,   326,   327,
       6,   329,     6,     6,     6,   333,     6,    25,     6,     6,
       6,     6,     6,    44,     6,     6,   344,   345,   346,    35,
      36,     6,   350,     6,     6,   353,     6,   139,   356,     7,
     358,     9,    10,    11,    12,    13,    14,    15,    16,   301,
     276,    95,    58,    83,   209,   120,    80,    25,    26,    27,
      62,   170,    68,    -1,    32,    33,    34,    35,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    56,    -1,
      58,    59,    -1,    -1,    62,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    96,    97,
      -1,    99,    -1,    -1,    -1,   103,    -1,   105,   106,   107,
     108,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     128,    -1,    -1,   131,   132,   133,   134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   157,
      -1,    -1,   160,    -1,    -1,    -1,    -1,   165,   166,   167,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   181,    -1,    -1,    -1,   185,    -1,   187,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   207,
     208,    -1,   210,    -1,   212,    -1,    -1,    -1,    -1,    -1,
     218,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   242,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     6,   264,   265,    -1,    -1,
      -1,    -1,    13,    -1,    15,    16,    -1,    18,    19,   277,
      21,    22,    23,    24,    -1,    26,    27,    28,    29,    30,
      31,    -1,    33,    34,    -1,    -1,    37,    38,    39,    40,
      41,    42,    -1,    -1,    -1,    46,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    54,    55,    56,    -1,    -1,    59,    60,
      61,    62,    63,    -1,    65,    66,    67,     6,    -1,    -1,
      71,    -1,    -1,    -1,    13,    -1,    15,    16,    -1,    18,
      19,    -1,    21,    22,    23,    24,    -1,    26,    27,    28,
      29,    30,    31,    -1,    33,    34,    -1,    -1,    37,    38,
      39,    40,    41,    42,    -1,    -1,    -1,    46,    47,    -1,
      -1,    -1,    -1,    -1,    -1,    54,    55,    56,    -1,    -1,
      59,    60,    61,    62,    63,    -1,    65,    66,    67,    -1,
      -1,    -1,    71
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     6,    13,    15,    16,    18,    19,    21,    22,
      23,    24,    26,    27,    28,    29,    30,    31,    33,    34,
      37,    38,    39,    40,    41,    42,    46,    47,    54,    55,
      56,    59,    60,    61,    62,    63,    65,    66,    67,    71,
      73,    74,    75,    76,   108,   109,    74,     7,   111,    12,
     106,     6,     6,     7,     8,    10,    99,    20,    99,    99,
      25,    99,   100,    99,    99,    99,    99,    99,     7,    32,
      96,     8,     9,    98,   102,    51,     6,    17,    25,    85,
      97,    35,    36,    51,    58,    68,    84,    86,    89,    99,
       7,    11,    90,     7,   101,    84,    99,    99,   104,    99,
       6,   106,    57,    35,    92,    99,    99,    99,    99,     6,
       6,     6,   102,     0,     5,    74,     6,    76,   108,   110,
     113,     5,   104,   102,     6,    99,    20,    99,    99,   100,
      99,    99,    99,    99,    99,    32,   102,     6,    84,    86,
      87,    98,     6,    97,    99,    25,    45,    89,    87,    87,
       6,    98,    90,     6,    98,     6,    85,    99,   104,     6,
      99,     6,     6,    99,     6,    99,    99,    99,    99,     6,
      14,   112,   110,     6,    96,    98,    98,    98,   106,   107,
      69,    99,    25,    69,    96,    99,    99,    99,    99,     7,
      48,    91,     8,    83,    87,    98,    83,    87,     6,    98,
       6,    99,     6,     6,    90,   101,   106,    99,    99,    98,
      99,    99,    99,    25,   111,    98,   101,     7,    69,    70,
      77,    78,    96,   101,     6,   107,   107,     6,     6,     8,
      99,    98,     6,     8,    49,    50,    52,    79,    93,    98,
       7,    96,    99,    96,    99,    96,     7,    98,    91,     6,
      87,    98,    87,    98,     6,    99,    99,    92,    99,    96,
      99,    96,     6,     6,     9,    99,   103,    98,     6,     6,
     101,     6,     6,   103,    98,     6,    25,   105,    93,    98,
      98,    93,    93,    49,    50,    52,    53,    80,    94,    98,
      96,    99,    94,    96,    94,    91,    91,    43,    96,   101,
     101,    96,    49,    64,    88,   103,   103,     6,    98,     6,
       6,     6,   105,   103,    93,    94,    98,    98,    98,    94,
      94,    94,    96,    49,    50,    52,    53,    81,    95,    98,
      44,     6,     6,    50,    82,     6,    88,     6,     6,    98,
      94,    94,    94,    95,    98,    98,    98,    95,    95,     6,
      98,     6,     6,    98,    95,    95,    98,    98,    98,    98
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    72,    73,    73,    73,    73,    74,    74,    75,    75,
      75,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    76,    76,    76,    76,    76,
      76,    76,    76,    76,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    84,    84,    85,    85,    86,    86,    86,
      87,    87,    87,    87,    87,    88,    88,    88,    89,    89,
      89,    90,    90,    90,    91,    91,    91,    91,    92,    92,
      93,    93,    93,    93,    93,    94,    94,    94,    94,    94,
      94,    95,    95,    95,    95,    95,    95,    96,    96,    97,
      98,    98,    99,    99,    99,   100,   100,   101,   101,   102,
     102,   103,   103,   103,   104,   104,   105,   105,   106,   107,
     107,   108,   109,   110,   110,   111,   112,   112,   113,   113,
     113
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     3,     1,     2,     0,     2,     1,     1,
       1,     6,     7,     6,     6,     6,     6,     7,     5,     5,
       6,     7,     5,     7,     8,     5,     6,     5,     5,     6,
       6,     7,     8,     7,     6,     3,     4,     3,     2,     3,
       4,     4,     3,     4,     3,     3,     3,     5,     8,     3,
       8,     7,     7,     7,     7,     8,     2,     2,     2,     2,
       2,     2,     3,     3,     3,     2,     3,     2,     3,     4,
       5,     2,     1,     2,     3,     1,     1,     2,     1,     1,
       0,     2,     3,     2,     3,     0,     1,     1,     0,     2,
       2,     0,     2,     3,     0,     2,     3,     3,     0,     4,
       0,     3,     2,     2,     2,     0,     3,     2,     2,     2,
       3,     0,     3,     3,     2,     2,     2,     1,     1,     4,
       1,     1,     1,     1,     1,     1,     1,     0,     3,     0,
       2,     0,     2,     2,     0,     2,     0,     2,     2,     0,
       2,     3,     4,     0,     2,     1,     1,     2,     1,     1,
       1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = SPICE_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == SPICE_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use SPICE_error or SPICE_UNDEF. */
#define YYERRCODE SPICE_UNDEF


/* Enable debugging if requested.  */
#if SPICE_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !SPICE_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !SPICE_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = SPICE_EMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == SPICE_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= SPICE_EOF)
    {
      yychar = SPICE_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == SPICE_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = SPICE_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = SPICE_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* Input: InputList End  */
#line 182 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                {
  }
#line 1625 "parse_spice.cpp"
    break;

  case 3: /* Input: TitleLine InputList End  */
#line 184 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                            {
    spice_title = (yyvsp[-2].str);
  }
#line 1633 "parse_spice.cpp"
    break;

  case 4: /* Input: InputList  */
#line 187 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
              {
  }
#line 1640 "parse_spice.cpp"
    break;

  case 5: /* Input: TitleLine InputList  */
#line 189 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        {
    spice_title = (yyvsp[-1].str);
  }
#line 1648 "parse_spice.cpp"
    break;

  case 8: /* InputLine: Subcircuit  */
#line 199 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
             {
    /* chain definition root */
    (yyvsp[0].definition)->next = definition_root;
    definition_root = (yyvsp[0].definition);
  }
#line 1658 "parse_spice.cpp"
    break;

  case 9: /* InputLine: DefinitionLine  */
#line 204 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                   {
    /* chain definition root */
    if ((yyvsp[0].definition)) {
      (yyvsp[0].definition)->next = definition_root;
      definition_root = (yyvsp[0].definition);
    }
  }
#line 1670 "parse_spice.cpp"
    break;

  case 10: /* InputLine: Eol  */
#line 211 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
        { /* nothing to do here */ }
#line 1676 "parse_spice.cpp"
    break;

  case 11: /* DefinitionLine: RLC_Device Node Node Value PairList Eol  */
#line 215 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                          {
    /* R, L and C definitions */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1689 "parse_spice.cpp"
    break;

  case 12: /* DefinitionLine: RLC_Device Node Node Value MODEL_Ident PairList Eol  */
#line 223 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                        {
    /* R, L and C definitions specified by a Model */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-3].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1703 "parse_spice.cpp"
    break;

  case 13: /* DefinitionLine: RLC_Device Node Node MODEL_Ident Value Eol  */
#line 232 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                               {
    /* R, L and C definitions specified by a Model, a variant */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-1].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
  }
#line 1716 "parse_spice.cpp"
    break;

  case 14: /* DefinitionLine: RLC_Device Node Node MODEL_Ident PairList Eol  */
#line 240 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                  {
    /* R definitions specified by a Model, yet another variant */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1729 "parse_spice.cpp"
    break;

  case 15: /* DefinitionLine: RLC_Device Node Node Value TC_Value_1 Eol  */
#line 248 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                              {
    /* R definitions including TC1 */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1742 "parse_spice.cpp"
    break;

  case 16: /* DefinitionLine: RLC_Device Node Node Value TC_Value_2 Eol  */
#line 256 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                              {
    /* R definitions including TC1/TC2 */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1755 "parse_spice.cpp"
    break;

  case 17: /* DefinitionLine: RLC_Device Node Node Value Behave NodeValueList Eol  */
#line 264 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                        {
    /* non-linear C and L poly definitions */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-3].ident), HINT_NUMBER);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1769 "parse_spice.cpp"
    break;

  case 18: /* DefinitionLine: K_Device L_Device L_Device Value Eol  */
#line 273 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                         {
    /* Mutual inductors */
    (yyval.definition) = spice_create_device ((yyvsp[-4].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    spice_append_val_value ((yyval.definition), (yyvsp[-1].ident), HINT_NUMBER);
  }
#line 1781 "parse_spice.cpp"
    break;

  case 19: /* DefinitionLine: IV_Source Node Node ExprList Eol  */
#line 280 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    /* independent current/voltage sources */
    (yyval.definition) = spice_create_device ((yyvsp[-4].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1793 "parse_spice.cpp"
    break;

  case 20: /* DefinitionLine: IV_Source Node Node Value ExprList Eol  */
#line 287 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                           {
    /* independent current/voltage sources given the value */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1806 "parse_spice.cpp"
    break;

  case 21: /* DefinitionLine: GE_Source Node Node Behave Digits NodeValueList Eol  */
#line 295 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                        {
    /* voltage controlled source POLY */
    if (!strcasecmp ((yyvsp[-3].ident), "POLY")) {
      (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
      spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NAME);
      spice_append_val_value ((yyval.definition), (yyvsp[-2].ident), HINT_NUMBER);
      (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
    }
    else {
      fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[-6].ident));
      (yyval.definition) = NULL;
    }
  }
#line 1826 "parse_spice.cpp"
    break;

  case 22: /* DefinitionLine: GE_Source Node Node Behave Eol  */
#line 310 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                   {
    /* voltage controlled sources OTHER behavioural */
    fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[-4].ident));
    (yyval.definition) = NULL;
  }
#line 1836 "parse_spice.cpp"
    break;

  case 23: /* DefinitionLine: GE_Source Node Node Node Node Value Eol  */
#line 315 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                            {
    /* voltage controlled sources */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_val_value ((yyval.definition), (yyvsp[-1].ident), HINT_NUMBER);
  }
#line 1850 "parse_spice.cpp"
    break;

  case 24: /* DefinitionLine: FH_Source FH_Node FH_Node Behave Digits VSourceList NodeValueList Eol  */
#line 324 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                                          {
    /* current controlled source POLY */
    if (!strcasecmp ((yyvsp[-4].ident), "POLY")) {
      (yyval.definition) = spice_create_device ((yyvsp[-7].ident));
      spice_append_str_value ((yyval.definition), (yyvsp[-6].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
      spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NAME);
      spice_append_val_value ((yyval.definition), (yyvsp[-3].ident), HINT_NUMBER);
      (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-2].value));
      (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
    }
    else {
      fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[-7].ident));
      (yyval.definition) = NULL;
    }
  }
#line 1871 "parse_spice.cpp"
    break;

  case 25: /* DefinitionLine: FH_Source FH_Node FH_Node Behave Eol  */
#line 340 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                         {
    /* current controlled sources OTHER behavioural */
    fprintf (stderr, "spice notice, behavioural %s source ignored\n", (yyvsp[-4].ident));
    (yyval.definition) = NULL;
  }
#line 1881 "parse_spice.cpp"
    break;

  case 26: /* DefinitionLine: FH_Source FH_Node FH_Node V_Source Value Eol  */
#line 345 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                 {
    /* current controlled sources */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    spice_append_val_value ((yyval.definition), (yyvsp[-1].ident), HINT_NUMBER);
  }
#line 1894 "parse_spice.cpp"
    break;

  case 27: /* DefinitionLine: MODEL_Action MODEL_Ident MODEL_Spec MODEL_List Eol  */
#line 353 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                       {
    /* device specification */
    (yyval.definition) = spice_create_action ((yyvsp[-4].ident), (yyvsp[-3].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME | HINT_MSTART);
    spice_add_last_hint ((yyvsp[-1].value), HINT_MSTOP);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 1906 "parse_spice.cpp"
    break;

  case 28: /* DefinitionLine: Diode_Device Node Node MODEL_Ident DEVICE_List_1  */
#line 360 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                     {
    /* diode */
    (yyval.definition) = spice_create_device ((yyvsp[-4].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 1919 "parse_spice.cpp"
    break;

  case 29: /* DefinitionLine: JFET_Device Node Node Node MODEL_Ident DEVICE_List_2  */
#line 368 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                         {
    /* JFET */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 1933 "parse_spice.cpp"
    break;

  case 30: /* DefinitionLine: Bipolar_Device Node Node Node MODEL_Ident DEVICE_List_2  */
#line 377 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                            {
    /* 3 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 1947 "parse_spice.cpp"
    break;

  case 31: /* DefinitionLine: Bipolar_Device Node Node Node Node MODEL_Ident DEVICE_List_2  */
#line 386 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                                 {
    /* 4 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 1962 "parse_spice.cpp"
    break;

  case 32: /* DefinitionLine: Bipolar_Device Node Node Node Node Node MODEL_Ident DEVICE_List_2  */
#line 396 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                                      {
    /* 5 node BJT */
    (yyval.definition) = spice_create_device ((yyvsp[-7].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-6].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 1978 "parse_spice.cpp"
    break;

  case 33: /* DefinitionLine: MOSFET_Device Node Node Node Node MODEL_Ident DEVICE_List_3  */
#line 407 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                                {
    /* MOS */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 1993 "parse_spice.cpp"
    break;

  case 34: /* DefinitionLine: MESFET_Device Node Node Node MODEL_Ident DEVICE_List_2  */
#line 417 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                           {
    /* MES */
    (yyval.definition) = spice_create_device ((yyvsp[-5].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[0].value));
  }
#line 2007 "parse_spice.cpp"
    break;

  case 35: /* DefinitionLine: TRAN_Action ValueList Eol  */
#line 426 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    /* transient analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2017 "parse_spice.cpp"
    break;

  case 36: /* DefinitionLine: PLOT_Action SIM_Type PLOT_List Eol  */
#line 431 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                       {
    /* plotting */
    (yyval.definition) = spice_create_action ((yyvsp[-3].ident), strdup ((yyvsp[-3].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2028 "parse_spice.cpp"
    break;

  case 37: /* DefinitionLine: AC_Action Expr Eol  */
#line 437 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                       {
    /* AC analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2038 "parse_spice.cpp"
    break;

  case 38: /* DefinitionLine: DC_Action Eol  */
#line 442 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                  {
    /* single DC analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-1].ident), strdup ((yyvsp[-1].ident)));
  }
#line 2047 "parse_spice.cpp"
    break;

  case 39: /* DefinitionLine: DC_Action DC_List Eol  */
#line 446 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          {
    /* DC analysis first order */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2057 "parse_spice.cpp"
    break;

  case 40: /* DefinitionLine: DC_Action DC_List DC_List Eol  */
#line 451 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                  {
    /* DC analysis second order */
    (yyval.definition) = spice_create_action ((yyvsp[-3].ident), strdup ((yyvsp[-3].ident)));
    (yyval.definition)->values = netlist_append_values ((yyvsp[-2].value), (yyvsp[-1].value));
  }
#line 2067 "parse_spice.cpp"
    break;

  case 41: /* DefinitionLine: PRINT_Action SIM_Type PRINT_List Eol  */
#line 456 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                         {
    /* printing specifying the analysis type */
    (yyval.definition) = spice_create_action ((yyvsp[-3].ident), strdup ((yyvsp[-3].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2078 "parse_spice.cpp"
    break;

  case 42: /* DefinitionLine: PRINT_Action PRINT_List Eol  */
#line 462 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                {
    /* printing */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2088 "parse_spice.cpp"
    break;

  case 43: /* DefinitionLine: PRINT_Action SIM_Type ALL_Special Eol  */
#line 467 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                          {
    /* printing */
    (yyval.definition) = spice_create_action ((yyvsp[-3].ident), strdup ((yyvsp[-3].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
  }
#line 2099 "parse_spice.cpp"
    break;

  case 44: /* DefinitionLine: OPTIONS_Action OPTIONS_List Eol  */
#line 473 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                    {
    /* general analysis options */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2109 "parse_spice.cpp"
    break;

  case 45: /* DefinitionLine: TEMP_Action ValueList Eol  */
#line 478 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    /* temperature analysis (Spice 2g6) */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2119 "parse_spice.cpp"
    break;

  case 46: /* DefinitionLine: WIDTH_Action PairList Eol  */
#line 483 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    /* TODO: default width of ??? */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2129 "parse_spice.cpp"
    break;

  case 47: /* DefinitionLine: NOISE_Action VOLTAGE_Output IV_Reference Expr Eol  */
#line 488 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                      {
    /* noise analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-4].ident), strdup ((yyvsp[-4].ident)));
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-3].value));
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2141 "parse_spice.cpp"
    break;

  case 48: /* DefinitionLine: PZ_Action Node Node Node Node CurVol PoleZero Eol  */
#line 495 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                      {
    /* pole-zero analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-7].ident), strdup ((yyvsp[-7].ident)));
    spice_append_str_value ((yyval.definition), (yyvsp[-6].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
  }
#line 2156 "parse_spice.cpp"
    break;

  case 49: /* DefinitionLine: X_Device NodeList Eol  */
#line 505 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          {
    /* subcircuit call */
    (yyval.definition) = spice_create_device ((yyvsp[-2].ident));
    spice_set_last_hint ((yyvsp[-1].value), HINT_NAME);
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2167 "parse_spice.cpp"
    break;

  case 50: /* DefinitionLine: S_Device Node Node Node Node MODEL_Ident SWITCH_State Eol  */
#line 511 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                              {
    /* voltage controlled switch */
    (yyval.definition) = spice_create_device ((yyvsp[-7].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-6].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2182 "parse_spice.cpp"
    break;

  case 51: /* DefinitionLine: W_Device Node Node V_Source MODEL_Ident SWITCH_State Eol  */
#line 521 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                             {
    /* current controlled switch */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NAME);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2196 "parse_spice.cpp"
    break;

  case 52: /* DefinitionLine: O_Device Node Node Node Node MODEL_Ident Eol  */
#line 530 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                 {
    /* lossy transline */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-1].ident), HINT_NAME);
  }
#line 2210 "parse_spice.cpp"
    break;

  case 53: /* DefinitionLine: U_Device Node Node Node MODEL_Ident PairList Eol  */
#line 539 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                     {
    /* distributed lossy transline */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NAME);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2224 "parse_spice.cpp"
    break;

  case 54: /* DefinitionLine: T_Device Node Node Node Node PairList Eol  */
#line 548 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                              {
    /* lossless transline */
    (yyval.definition) = spice_create_device ((yyvsp[-6].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-2].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2238 "parse_spice.cpp"
    break;

  case 55: /* DefinitionLine: T_Device Node Node Node Node PairList IC_Condition_4 Eol  */
#line 557 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                                             {
    /* lossless transline and initial condition */
    (yyval.definition) = spice_create_device ((yyvsp[-7].ident));
    spice_append_str_value ((yyval.definition), (yyvsp[-6].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-5].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-4].ident), HINT_NODE);
    spice_append_str_value ((yyval.definition), (yyvsp[-3].ident), HINT_NODE);
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-2].value));
    (yyval.definition)->values = netlist_append_values ((yyval.definition)->values, (yyvsp[-1].value));
  }
#line 2253 "parse_spice.cpp"
    break;

  case 56: /* DefinitionLine: OP_Action Eol  */
#line 567 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                  {
    /* operating point analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-1].ident), strdup ((yyvsp[-1].ident)));
  }
#line 2262 "parse_spice.cpp"
    break;

  case 57: /* DefinitionLine: SAVE_Action Eol  */
#line 571 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                    {
    /* saving action */
    (yyval.definition) = spice_create_action ((yyvsp[-1].ident), strdup ((yyvsp[-1].ident)));
  }
#line 2271 "parse_spice.cpp"
    break;

  case 58: /* DefinitionLine: SENS_Action Eol  */
#line 575 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                    {
    /* sensitivity analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-1].ident), strdup ((yyvsp[-1].ident)));
  }
#line 2280 "parse_spice.cpp"
    break;

  case 59: /* DefinitionLine: TF_Action Eol  */
#line 579 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                  {
    /* transfer function analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-1].ident), strdup ((yyvsp[-1].ident)));
  }
#line 2289 "parse_spice.cpp"
    break;

  case 60: /* DefinitionLine: FOUR_Action Eol  */
#line 583 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                    {
    /* fourier analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-1].ident), strdup ((yyvsp[-1].ident)));
  }
#line 2298 "parse_spice.cpp"
    break;

  case 61: /* DefinitionLine: B_Source Eol  */
#line 587 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                 {
    /* non-linear dependent sources */
    (yyval.definition) = spice_create_device ((yyvsp[-1].ident));
  }
#line 2307 "parse_spice.cpp"
    break;

  case 62: /* DefinitionLine: DISTO_Action Expr Eol  */
#line 591 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          {
    /* distortion analysis */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2317 "parse_spice.cpp"
    break;

  case 63: /* DefinitionLine: INCLUDE_Action File Eol  */
#line 596 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                            {
    /* file include */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    struct value_t * file = create_value ();
    file->ident = (yyvsp[-1].ident);
    file->hint = HINT_NAME;
    (yyval.definition)->values = file;
  }
#line 2330 "parse_spice.cpp"
    break;

  case 64: /* DefinitionLine: NODESET_Action NODESET_List Eol  */
#line 604 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                    {
    /* nodeset functionality */
    (yyval.definition) = spice_create_action ((yyvsp[-2].ident), strdup ((yyvsp[-2].ident)));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2340 "parse_spice.cpp"
    break;

  case 65: /* TC_Value_1: TC_Special Value  */
#line 612 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                   {
    (yyval.value) = NULL;
    (yyval.value) = spice_create_par_value ((yyvsp[-1].ident), (yyvsp[0].ident));
  }
#line 2349 "parse_spice.cpp"
    break;

  case 66: /* TC_Value_2: TC_Special Value Value  */
#line 619 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         {
    (yyval.value) = NULL;
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER);
  }
#line 2359 "parse_spice.cpp"
    break;

  case 67: /* IC_Condition_1: IC_Special Value  */
#line 627 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                   {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-1].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER);
  }
#line 2369 "parse_spice.cpp"
    break;

  case 68: /* IC_Condition_2: IC_Special Value Value  */
#line 635 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-2].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER);
  }
#line 2380 "parse_spice.cpp"
    break;

  case 69: /* IC_Condition_3: IC_Special Value Value Value  */
#line 643 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                               {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-3].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER);
  }
#line 2392 "parse_spice.cpp"
    break;

  case 70: /* IC_Condition_4: IC_Special Value Value Value Value  */
#line 653 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-4].ident), HINT_NAME);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-3].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER);
  }
#line 2405 "parse_spice.cpp"
    break;

  case 71: /* Output_Range: Value Value  */
#line 664 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
              { /* range specification during plotting */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER);
  }
#line 2415 "parse_spice.cpp"
    break;

  case 72: /* VOLTAGE_Output: Node  */
#line 672 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
       { // TODO: 2 reduce/reduce, 2 shift/reduce
    /* print/plot specification of node voltage */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), strdup ("V"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[0].ident), HINT_NODE | HINT_MSTOP);
  }
#line 2426 "parse_spice.cpp"
    break;

  case 73: /* VOLTAGE_Output: VoltFunc Node  */
#line 678 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                  { // TODO: 2 reduce/reduce
    /* print/plot specification of node voltage */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-1].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[0].ident), HINT_NODE | HINT_MSTOP);
  }
#line 2437 "parse_spice.cpp"
    break;

  case 74: /* VOLTAGE_Output: VoltFunc Node Node  */
#line 684 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                       {
    /* print/plot specification of differential node voltages */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-2].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-1].ident), HINT_NODE);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[0].ident), HINT_NODE | HINT_MSTOP);
  }
#line 2449 "parse_spice.cpp"
    break;

  case 77: /* CURRENT_Output: CurrFunc V_Source  */
#line 697 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                    {
    /* print/plot specification of branch current */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-1].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[0].ident), HINT_NAME | HINT_MSTOP);
  }
#line 2460 "parse_spice.cpp"
    break;

  case 78: /* CURRENT_Output: BranchFunc  */
#line 703 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
               {
    /* print/plot specification of branch current */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), strdup ("I"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[0].ident), HINT_NAME | HINT_MSTOP);
  }
#line 2471 "parse_spice.cpp"
    break;

  case 79: /* CURRENT_Output: OpFunc  */
#line 709 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
           {
    /* print/plot specification of operating point */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), strdup ("OP"), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[0].ident), HINT_NAME | HINT_MSTOP);
  }
#line 2482 "parse_spice.cpp"
    break;

  case 80: /* PLOT_List: %empty  */
#line 717 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         { (yyval.value) = NULL; }
#line 2488 "parse_spice.cpp"
    break;

  case 81: /* PLOT_List: VOLTAGE_Output PLOT_List  */
#line 718 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2496 "parse_spice.cpp"
    break;

  case 82: /* PLOT_List: VOLTAGE_Output Output_Range PLOT_List  */
#line 721 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                          {
    (yyval.value) = netlist_append_values ((yyvsp[-2].value), (yyvsp[-1].value));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2505 "parse_spice.cpp"
    break;

  case 83: /* PLOT_List: CURRENT_Output PLOT_List  */
#line 725 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2513 "parse_spice.cpp"
    break;

  case 84: /* PLOT_List: CURRENT_Output Output_Range PLOT_List  */
#line 728 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                          {
    (yyval.value) = netlist_append_values ((yyvsp[-2].value), (yyvsp[-1].value));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2522 "parse_spice.cpp"
    break;

  case 85: /* SWITCH_State: %empty  */
#line 734 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                            { (yyval.value) = NULL; }
#line 2528 "parse_spice.cpp"
    break;

  case 86: /* SWITCH_State: ON_Special  */
#line 735 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
               {
    (yyval.value) = spice_create_str_value ((yyvsp[0].ident), HINT_NAME);
  }
#line 2536 "parse_spice.cpp"
    break;

  case 87: /* SWITCH_State: OFF_Special  */
#line 738 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                {
    (yyval.value) = spice_create_str_value ((yyvsp[0].ident), HINT_NAME);
  }
#line 2544 "parse_spice.cpp"
    break;

  case 88: /* PRINT_List: %empty  */
#line 743 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          { (yyval.value) = NULL; }
#line 2550 "parse_spice.cpp"
    break;

  case 89: /* PRINT_List: VOLTAGE_Output PLOT_List  */
#line 744 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2558 "parse_spice.cpp"
    break;

  case 90: /* PRINT_List: CURRENT_Output PLOT_List  */
#line 747 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2566 "parse_spice.cpp"
    break;

  case 91: /* OPTIONS_List: %empty  */
#line 752 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                            { (yyval.value) = NULL; }
#line 2572 "parse_spice.cpp"
    break;

  case 92: /* OPTIONS_List: Options OPTIONS_List  */
#line 753 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         {
    (yyval.value) = spice_create_str_value ((yyvsp[-1].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2581 "parse_spice.cpp"
    break;

  case 93: /* OPTIONS_List: Identifier Value OPTIONS_List  */
#line 757 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                  {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2590 "parse_spice.cpp"
    break;

  case 94: /* MODEL_List: %empty  */
#line 763 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          { (yyval.value) = NULL; }
#line 2596 "parse_spice.cpp"
    break;

  case 95: /* MODEL_List: ModelProps MODEL_List  */
#line 764 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          {
    (yyval.value) = spice_create_str_value ((yyvsp[-1].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2605 "parse_spice.cpp"
    break;

  case 96: /* MODEL_List: Identifier Value MODEL_List  */
#line 768 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2614 "parse_spice.cpp"
    break;

  case 97: /* MODEL_List: Identifier Identifier MODEL_List  */
#line 772 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2623 "parse_spice.cpp"
    break;

  case 98: /* NODESET_List: %empty  */
#line 778 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                            { (yyval.value) = NULL; }
#line 2629 "parse_spice.cpp"
    break;

  case 99: /* NODESET_List: VoltFunc Node Value NODESET_List  */
#line 779 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-3].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-2].ident), HINT_NODE | HINT_MSTOP);
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2641 "parse_spice.cpp"
    break;

  case 100: /* DEVICE_List_1: %empty  */
#line 788 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             { (yyval.value) = NULL; }
#line 2647 "parse_spice.cpp"
    break;

  case 101: /* DEVICE_List_1: TEMP_Special Value DEVICE_List_1  */
#line 789 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2656 "parse_spice.cpp"
    break;

  case 102: /* DEVICE_List_1: Value DEVICE_List_1  */
#line 793 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        {
    (yyval.value) = spice_create_par_value (strdup ("Area"), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2665 "parse_spice.cpp"
    break;

  case 103: /* DEVICE_List_1: OFF_Special DEVICE_List_1  */
#line 797 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    (yyval.value) = spice_create_val_value ((yyvsp[-1].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2674 "parse_spice.cpp"
    break;

  case 104: /* DEVICE_List_1: IC_Condition_1 DEVICE_List_1  */
#line 801 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                 {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2682 "parse_spice.cpp"
    break;

  case 105: /* DEVICE_List_2: %empty  */
#line 806 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             { (yyval.value) = NULL; }
#line 2688 "parse_spice.cpp"
    break;

  case 106: /* DEVICE_List_2: TEMP_Special Value DEVICE_List_2  */
#line 807 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2697 "parse_spice.cpp"
    break;

  case 107: /* DEVICE_List_2: Value DEVICE_List_2  */
#line 811 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        {
    (yyval.value) = spice_create_par_value (strdup ("Area"), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2706 "parse_spice.cpp"
    break;

  case 108: /* DEVICE_List_2: OFF_Special DEVICE_List_2  */
#line 815 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    (yyval.value) = spice_create_val_value ((yyvsp[-1].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2715 "parse_spice.cpp"
    break;

  case 109: /* DEVICE_List_2: IC_Condition_2 DEVICE_List_2  */
#line 819 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                 {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2723 "parse_spice.cpp"
    break;

  case 110: /* DEVICE_List_2: MOS_Special Value DEVICE_List_2  */
#line 822 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                    {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2732 "parse_spice.cpp"
    break;

  case 111: /* DEVICE_List_3: %empty  */
#line 828 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             { (yyval.value) = NULL; }
#line 2738 "parse_spice.cpp"
    break;

  case 112: /* DEVICE_List_3: TEMP_Special Value DEVICE_List_3  */
#line 829 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                     {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2747 "parse_spice.cpp"
    break;

  case 113: /* DEVICE_List_3: MOS_Special Value DEVICE_List_3  */
#line 833 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                    {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2756 "parse_spice.cpp"
    break;

  case 114: /* DEVICE_List_3: Value DEVICE_List_3  */
#line 837 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        {
    (yyval.value) = spice_create_val_value ((yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2765 "parse_spice.cpp"
    break;

  case 115: /* DEVICE_List_3: OFF_Special DEVICE_List_3  */
#line 841 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    (yyval.value) = spice_create_val_value ((yyvsp[-1].ident), HINT_NAME);
    (yyval.value) = netlist_append_values ((yyval.value), (yyvsp[0].value));
  }
#line 2774 "parse_spice.cpp"
    break;

  case 116: /* DEVICE_List_3: IC_Condition_3 DEVICE_List_3  */
#line 845 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                 {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2782 "parse_spice.cpp"
    break;

  case 119: /* DC_List: IV_Reference Value Value Value  */
#line 853 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                 {
    /* identification of a DC sweep */
    (yyval.value) = NULL;
    (yyval.value) = spice_append_str_values ((yyval.value), (yyvsp[-3].ident), HINT_NAME | HINT_MSTART);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-2].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value) = spice_append_val_values ((yyval.value), (yyvsp[0].ident), HINT_NUMBER | HINT_MSTOP);
  }
#line 2795 "parse_spice.cpp"
    break;

  case 127: /* PairList: %empty  */
#line 869 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        { (yyval.value) = NULL; }
#line 2801 "parse_spice.cpp"
    break;

  case 128: /* PairList: Identifier Value PairList  */
#line 870 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                              {
    (yyval.value) = spice_create_par_value ((yyvsp[-2].ident), (yyvsp[-1].ident));
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2810 "parse_spice.cpp"
    break;

  case 129: /* ValueList: %empty  */
#line 876 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         { (yyval.value) = NULL; }
#line 2816 "parse_spice.cpp"
    break;

  case 130: /* ValueList: Value ValueList  */
#line 877 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                    {
    (yyval.value) = spice_create_val_value ((yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2825 "parse_spice.cpp"
    break;

  case 131: /* NodeValueList: %empty  */
#line 883 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             { (yyval.value) = NULL; }
#line 2831 "parse_spice.cpp"
    break;

  case 132: /* NodeValueList: Node NodeValueList  */
#line 884 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                       {
    (yyval.value) = spice_create_str_value ((yyvsp[-1].ident), HINT_NODE);
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2840 "parse_spice.cpp"
    break;

  case 133: /* NodeValueList: Floats NodeValueList  */
#line 888 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         {
    (yyval.value) = spice_create_val_value ((yyvsp[-1].ident), HINT_NUMBER);
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2849 "parse_spice.cpp"
    break;

  case 134: /* NodeList: %empty  */
#line 894 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        { (yyval.value) = NULL; }
#line 2855 "parse_spice.cpp"
    break;

  case 135: /* NodeList: Node NodeList  */
#line 895 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                  {
    (yyval.value) = spice_create_str_value ((yyvsp[-1].ident), HINT_NODE);
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2864 "parse_spice.cpp"
    break;

  case 136: /* VSourceList: %empty  */
#line 901 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                           { (yyval.value) = NULL; }
#line 2870 "parse_spice.cpp"
    break;

  case 137: /* VSourceList: V_Source VSourceList  */
#line 902 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                         {
    (yyval.value) = spice_create_str_value ((yyvsp[-1].ident), HINT_NAME);
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2879 "parse_spice.cpp"
    break;

  case 138: /* Expr: Function ValueList  */
#line 909 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                     {
    (yyval.value) = spice_create_str_value ((yyvsp[-1].ident), HINT_NAME | HINT_MSTART);
    spice_add_last_hint ((yyvsp[0].value), HINT_MSTOP);
    (yyval.value)->next = (yyvsp[0].value);
  }
#line 2889 "parse_spice.cpp"
    break;

  case 139: /* ExprList: %empty  */
#line 916 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        { (yyval.value) = NULL; }
#line 2895 "parse_spice.cpp"
    break;

  case 140: /* ExprList: Expr ExprList  */
#line 917 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                  {
    (yyval.value) = netlist_append_values ((yyvsp[-1].value), (yyvsp[0].value));
  }
#line 2903 "parse_spice.cpp"
    break;

  case 141: /* Subcircuit: BeginSub SubBody EndSub  */
#line 923 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                          {
    (yyvsp[-2].definition)->sub = (yyvsp[-1].definition);
    (yyval.definition) = (yyvsp[-2].definition);
    (yyvsp[-1].definition) = NULL;
  }
#line 2913 "parse_spice.cpp"
    break;

  case 142: /* BeginSub: SUBCKT_Action SubCkt_Ident NodeList Eol  */
#line 931 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                                          {
    (yyval.definition) = spice_create_action ((yyvsp[-3].ident), (yyvsp[-2].ident));
    (yyval.definition)->values = (yyvsp[-1].value);
  }
#line 2922 "parse_spice.cpp"
    break;

  case 143: /* SubBody: %empty  */
#line 937 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                       { (yyval.definition) = NULL; }
#line 2928 "parse_spice.cpp"
    break;

  case 144: /* SubBody: SubBodyLine SubBody  */
#line 938 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                        { /* chain definitions here */
    if ((yyvsp[-1].definition)) {
      (yyvsp[-1].definition)->next = (yyvsp[0].definition);
      (yyval.definition) = (yyvsp[-1].definition);
    }
    else {
      (yyval.definition) = (yyvsp[0].definition);
    }
  }
#line 2942 "parse_spice.cpp"
    break;

  case 146: /* EndSub: ENDS_Action  */
#line 952 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                { /* nothing to do */ }
#line 2948 "parse_spice.cpp"
    break;

  case 147: /* EndSub: ENDS_Action SubCkt_Ident  */
#line 953 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                             { free ((yyvsp[0].ident)); /* nothing to do */ }
#line 2954 "parse_spice.cpp"
    break;

  case 148: /* SubBodyLine: DefinitionLine  */
#line 957 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
                 { /* chain definitions here */
    if ((yyvsp[0].definition)) {
      (yyvsp[0].definition)->next = (yyval.definition);
      (yyval.definition) = (yyvsp[0].definition);
    }
  }
#line 2965 "parse_spice.cpp"
    break;

  case 149: /* SubBodyLine: Subcircuit  */
#line 963 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
               { /* do nothing here, see subcircuit rule */ }
#line 2971 "parse_spice.cpp"
    break;

  case 150: /* SubBodyLine: Eol  */
#line 964 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"
        {
    (yyval.definition) = NULL;
  }
#line 2979 "parse_spice.cpp"
    break;


#line 2983 "parse_spice.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == SPICE_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= SPICE_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == SPICE_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = SPICE_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != SPICE_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 969 "/build/qucs-s/src/qucs-s-25.1.2/qucsator_rf/src/converter/parse_spice.ypp"


int spice_error (const char * error) {
  fprintf (stderr, "line %d: %s\n", spice_lineno, error);
  return 0;
}
