import { ConvenienceRenderer, type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import { DependencyName, type Name, type Namer } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import { type ClassProperty, type ClassType, EnumType, type Type, type UnionType } from "../../Type";
import type { dartOptions } from "./language";
export declare class DartRenderer extends ConvenienceRenderer {
    private readonly _options;
    private readonly _gettersAndSettersForPropertyName;
    private _needEnumValues;
    private classCounter;
    private classPropertyCounter;
    private readonly _topLevelDependents;
    private readonly _enumValues;
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, _options: OptionValues<typeof dartOptions>);
    protected forbiddenNamesForGlobalNamespace(): readonly string[];
    protected forbiddenForObjectProperties(_c: ClassType, _className: Name): ForbiddenWordsInfo;
    protected makeNamedTypeNamer(): Namer;
    protected namerForObjectProperty(): Namer;
    protected makeUnionMemberNamer(): Namer;
    protected makeEnumCaseNamer(): Namer;
    protected unionNeedsName(u: UnionType): boolean;
    protected namedTypeToNameForTopLevel(type: Type): Type | undefined;
    protected get toJson(): string;
    protected get fromJson(): string;
    protected makeTopLevelDependencyNames(_t: Type, name: Name): DependencyName[];
    protected makeNamesForPropertyGetterAndSetter(_c: ClassType, _className: Name, _p: ClassProperty, _jsonName: string, name: Name): [Name, Name];
    protected makePropertyDependencyNames(c: ClassType, className: Name, p: ClassProperty, jsonName: string, name: Name): Name[];
    protected makeNamedTypeDependencyNames(t: Type, name: Name): DependencyName[];
    protected emitFileHeader(): void;
    protected emitDescriptionBlock(lines: Sourcelike[]): void;
    protected emitBlock(line: Sourcelike, f: () => void): void;
    protected dartType(t: Type, withIssues?: boolean, forceNullable?: boolean): Sourcelike;
    protected mapList(isNullable: boolean, itemType: Sourcelike, list: Sourcelike, mapper: Sourcelike): Sourcelike;
    protected mapMap(isNullable: boolean, valueType: Sourcelike, map: Sourcelike, valueMapper: Sourcelike): Sourcelike;
    protected mapClass(isNullable: boolean, classType: ClassType, dynamic: Sourcelike): Sourcelike;
    protected fromDynamicExpression(isNullable: boolean | undefined, t: Type, ...dynamic: Sourcelike[]): Sourcelike;
    protected toDynamicExpression(isNullable: boolean | undefined, t: Type, ...dynamic: Sourcelike[]): Sourcelike;
    private _emitEmptyConstructor;
    private _emitConstructor;
    private _emitVariables;
    private _emitCopyConstructor;
    private _emitStringJsonEncoderDecoder;
    private _emitMapEncoderDecoder;
    protected emitClassDefinition(c: ClassType, className: Name): void;
    protected emitFreezedClassDefinition(c: ClassType, className: Name): void;
    protected emitEnumDefinition(e: EnumType, enumName: Name): void;
    protected emitEnumValues(): void;
    private _emitTopLvlEncoderDecoder;
    protected emitSourceStructure(): void;
}
