import { ConvenienceRenderer, type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import { type Name, type Namer } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import { type ClassProperty, ClassType, EnumType, type Type, UnionType } from "../../Type";
import { type JavaDateTimeProvider } from "./DateTimeProvider";
import type { javaOptions } from "./language";
export declare class JavaRenderer extends ConvenienceRenderer {
    protected readonly _options: OptionValues<typeof javaOptions>;
    private _currentFilename;
    private readonly _gettersAndSettersForPropertyName;
    private _haveEmittedLeadingComments;
    protected readonly _dateTimeProvider: JavaDateTimeProvider;
    protected readonly _converterClassname: string;
    protected readonly _converterKeywords: string[];
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, _options: OptionValues<typeof javaOptions>);
    protected forbiddenNamesForGlobalNamespace(): string[];
    protected forbiddenForObjectProperties(_c: ClassType, _className: Name): ForbiddenWordsInfo;
    protected makeNamedTypeNamer(): Namer;
    protected namerForObjectProperty(): Namer;
    protected makeUnionMemberNamer(): Namer;
    protected makeEnumCaseNamer(): Namer;
    protected unionNeedsName(u: UnionType): boolean;
    protected namedTypeToNameForTopLevel(type: Type): Type | undefined;
    protected makeNamesForPropertyGetterAndSetter(_c: ClassType, _className: Name, _p: ClassProperty, _jsonName: string, name: Name): [Name, Name];
    protected makePropertyDependencyNames(c: ClassType, className: Name, p: ClassProperty, jsonName: string, name: Name): Name[];
    private getNameStyling;
    protected fieldOrMethodName(methodName: string, topLevelName: Name): Sourcelike;
    protected methodName(prefix: string, suffix: string, topLevelName: Name): Sourcelike;
    protected decoderName(topLevelName: Name): Sourcelike;
    protected encoderName(topLevelName: Name): Sourcelike;
    protected readerGetterName(topLevelName: Name): Sourcelike;
    protected writerGetterName(topLevelName: Name): Sourcelike;
    protected startFile(basename: Sourcelike): void;
    protected finishFile(): void;
    protected emitPackageAndImports(imports: string[]): void;
    protected emitFileHeader(fileName: Sourcelike, imports: string[]): void;
    emitDescriptionBlock(lines: Sourcelike[]): void;
    emitBlock(line: Sourcelike, f: () => void): void;
    emitTryCatch(main: () => void, handler: () => void, exception?: string): void;
    emitIgnoredTryCatchBlock(f: () => void): void;
    protected javaType(reference: boolean, t: Type, withIssues?: boolean): Sourcelike;
    protected javaImport(t: Type): string[];
    protected javaTypeWithoutGenerics(reference: boolean, t: Type): Sourcelike;
    protected emitClassAttributes(_c: ClassType, _className: Name): void;
    protected annotationsForAccessor(_c: ClassType, _className: Name, _propertyName: Name, _jsonName: string, _p: ClassProperty, _isSetter: boolean): string[];
    protected importsForType(t: ClassType | UnionType | EnumType): string[];
    protected importsForClass(c: ClassType): string[];
    protected importsForUnionMembers(u: UnionType): string[];
    protected emitClassDefinition(c: ClassType, className: Name): void;
    protected unionField(u: UnionType, t: Type, withIssues?: boolean): {
        fieldName: Sourcelike;
        fieldType: Sourcelike;
    };
    protected emitUnionAttributes(_u: UnionType, _unionName: Name): void;
    protected emitUnionSerializer(_u: UnionType, _unionName: Name): void;
    protected emitUnionDefinition(u: UnionType, unionName: Name): void;
    protected emitEnumSerializationAttributes(_e: EnumType): void;
    protected emitEnumDeserializationAttributes(_e: EnumType): void;
    protected emitEnumDefinition(e: EnumType, enumName: Name): void;
    protected emitSourceStructure(): void;
}
