import { type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import { DependencyName, type Name } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import { type Transformation } from "../../Transformers";
import { type ClassProperty, ClassType, type Type } from "../../Type";
import { CSharpRenderer } from "./CSharpRenderer";
import type { newtonsoftCSharpOptions } from "./language";
export declare class NewtonsoftCSharpRenderer extends CSharpRenderer {
    private readonly _options;
    private readonly _enumExtensionsNames;
    private readonly _needHelpers;
    private readonly _needAttributes;
    private readonly _needNamespaces;
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, _options: OptionValues<typeof newtonsoftCSharpOptions>);
    protected forbiddenNamesForGlobalNamespace(): string[];
    protected forbiddenForObjectProperties(c: ClassType, className: Name): ForbiddenWordsInfo;
    protected makeNameForTransformation(xf: Transformation, typeName: Name | undefined): Name;
    protected makeNamedTypeDependencyNames(t: Type, name: Name): DependencyName[];
    protected emitUsings(): void;
    protected baseclassForType(_t: Type): Sourcelike | undefined;
    protected emitDefaultLeadingComments(): void;
    private converterForType;
    protected attributesForProperty(property: ClassProperty, _name: Name, _c: ClassType, jsonName: string): Sourcelike[] | undefined;
    protected blankLinesBetweenAttributes(): boolean;
    private topLevelResultType;
    private emitFromJsonForTopLevel;
    private emitDecoderSwitch;
    private emitTokenCase;
    private emitThrow;
    private deserializeTypeCode;
    private serializeValueCode;
    private emitSerializeClass;
    private emitCanConvert;
    private emitReadJson;
    private emitWriteJson;
    private converterObject;
    private emitConverterClass;
    private emitDecoderTransformerCase;
    private emitConsume;
    private emitDecodeTransformer;
    private stringCaseValue;
    private emitTransformer;
    private emitTransformation;
    protected emitRequiredHelpers(): void;
    protected needNamespace(): boolean;
}
