import { ConvenienceRenderer, type ForbiddenWordsInfo } from "../../ConvenienceRenderer";
import type { Name, Namer } from "../../Naming";
import type { RenderContext } from "../../Renderer";
import type { OptionValues } from "../../RendererOptions";
import { type Sourcelike } from "../../Source";
import type { TargetLanguage } from "../../TargetLanguage";
import { type ClassType, type EnumType, type Type, UnionType } from "../../Type";
import type { rustOptions } from "./language";
export declare class RustRenderer extends ConvenienceRenderer {
    private readonly _options;
    constructor(targetLanguage: TargetLanguage, renderContext: RenderContext, _options: OptionValues<typeof rustOptions>);
    protected makeNamedTypeNamer(): Namer;
    protected namerForObjectProperty(): Namer | null;
    protected makeUnionMemberNamer(): Namer | null;
    protected makeEnumCaseNamer(): Namer | null;
    protected forbiddenNamesForGlobalNamespace(): readonly string[];
    protected forbiddenForObjectProperties(_c: ClassType, _className: Name): ForbiddenWordsInfo;
    protected forbiddenForUnionMembers(_u: UnionType, _unionName: Name): ForbiddenWordsInfo;
    protected forbiddenForEnumCases(_e: EnumType, _enumName: Name): ForbiddenWordsInfo;
    protected get commentLineStart(): string;
    private nullableRustType;
    protected isImplicitCycleBreaker(t: Type): boolean;
    private rustType;
    private breakCycle;
    private emitRenameAttribute;
    private emitSkipSerializeNone;
    private get visibility();
    protected emitStructDefinition(c: ClassType, className: Name): void;
    protected emitBlock(line: Sourcelike, f: () => void): void;
    protected emitUnion(u: UnionType, unionName: Name): void;
    protected emitEnumDefinition(e: EnumType, enumName: Name): void;
    protected emitTopLevelAlias(t: Type, name: Name): void;
    protected emitLeadingComments(): void;
    protected emitSourceStructure(): void;
}
