'use strict';

// ESLint suggests unquoting some object keys, which would render the file unparseable by Opera 12.
/* eslint-disable quote-props */
(function () {
    const toUpperMapping = {
        'ß': 0,
        'ŉ': 0,
        'ǰ': 0,
        'ʂ': 0,
        'ͅ': 0,
        'ΐ': 0,
        'ΰ': 0,
        'և': 0,
        'ა': 0,
        'ბ': 0,
        'გ': 0,
        'დ': 0,
        'ე': 0,
        'ვ': 0,
        'ზ': 0,
        'თ': 0,
        'ი': 0,
        'კ': 0,
        'ლ': 0,
        'მ': 0,
        'ნ': 0,
        'ო': 0,
        'პ': 0,
        'ჟ': 0,
        'რ': 0,
        'ს': 0,
        'ტ': 0,
        'უ': 0,
        'ფ': 0,
        'ქ': 0,
        'ღ': 0,
        'ყ': 0,
        'შ': 0,
        'ჩ': 0,
        'ც': 0,
        'ძ': 0,
        'წ': 0,
        'ჭ': 0,
        'ხ': 0,
        'ჯ': 0,
        'ჰ': 0,
        'ჱ': 0,
        'ჲ': 0,
        'ჳ': 0,
        'ჴ': 0,
        'ჵ': 0,
        'ჶ': 0,
        'ჷ': 0,
        'ჸ': 0,
        'ჹ': 0,
        'ჺ': 0,
        'ჽ': 0,
        'ჾ': 0,
        'ჿ': 0,
        'ᶎ': 0,
        'ẖ': 0,
        'ẗ': 0,
        'ẘ': 0,
        'ẙ': 0,
        'ẚ': 0,
        'ὐ': 0,
        'ὒ': 0,
        'ὔ': 0,
        'ὖ': 0,
        'ᾀ': 'ᾈ',
        'ᾁ': 'ᾉ',
        'ᾂ': 'ᾊ',
        'ᾃ': 'ᾋ',
        'ᾄ': 'ᾌ',
        'ᾅ': 'ᾍ',
        'ᾆ': 'ᾎ',
        'ᾇ': 'ᾏ',
        'ᾈ': 0,
        'ᾉ': 0,
        'ᾊ': 0,
        'ᾋ': 0,
        'ᾌ': 0,
        'ᾍ': 0,
        'ᾎ': 0,
        'ᾏ': 0,
        'ᾐ': 'ᾘ',
        'ᾑ': 'ᾙ',
        'ᾒ': 'ᾚ',
        'ᾓ': 'ᾛ',
        'ᾔ': 'ᾜ',
        'ᾕ': 'ᾝ',
        'ᾖ': 'ᾞ',
        'ᾗ': 'ᾟ',
        'ᾘ': 0,
        'ᾙ': 0,
        'ᾚ': 0,
        'ᾛ': 0,
        'ᾜ': 0,
        'ᾝ': 0,
        'ᾞ': 0,
        'ᾟ': 0,
        'ᾠ': 'ᾨ',
        'ᾡ': 'ᾩ',
        'ᾢ': 'ᾪ',
        'ᾣ': 'ᾫ',
        'ᾤ': 'ᾬ',
        'ᾥ': 'ᾭ',
        'ᾦ': 'ᾮ',
        'ᾧ': 'ᾯ',
        'ᾨ': 0,
        'ᾩ': 0,
        'ᾪ': 0,
        'ᾫ': 0,
        'ᾬ': 0,
        'ᾭ': 0,
        'ᾮ': 0,
        'ᾯ': 0,
        'ᾲ': 0,
        'ᾳ': 'ᾼ',
        'ᾴ': 0,
        'ᾶ': 0,
        'ᾷ': 0,
        'ᾼ': 0,
        'ῂ': 0,
        'ῃ': 'ῌ',
        'ῄ': 0,
        'ῆ': 0,
        'ῇ': 0,
        'ῌ': 0,
        'ῒ': 0,
        'ΐ': 0,
        'ῖ': 0,
        'ῗ': 0,
        'ῢ': 0,
        'ΰ': 0,
        'ῤ': 0,
        'ῦ': 0,
        'ῧ': 0,
        'ῲ': 0,
        'ῳ': 'ῼ',
        'ῴ': 0,
        'ῶ': 0,
        'ῷ': 0,
        'ῼ': 0,
        'ⅰ': 0,
        'ⅱ': 0,
        'ⅲ': 0,
        'ⅳ': 0,
        'ⅴ': 0,
        'ⅵ': 0,
        'ⅶ': 0,
        'ⅷ': 0,
        'ⅸ': 0,
        'ⅹ': 0,
        'ⅺ': 0,
        'ⅻ': 0,
        'ⅼ': 0,
        'ⅽ': 0,
        'ⅾ': 0,
        'ⅿ': 0,
        'ⓐ': 0,
        'ⓑ': 0,
        'ⓒ': 0,
        'ⓓ': 0,
        'ⓔ': 0,
        'ⓕ': 0,
        'ⓖ': 0,
        'ⓗ': 0,
        'ⓘ': 0,
        'ⓙ': 0,
        'ⓚ': 0,
        'ⓛ': 0,
        'ⓜ': 0,
        'ⓝ': 0,
        'ⓞ': 0,
        'ⓟ': 0,
        'ⓠ': 0,
        'ⓡ': 0,
        'ⓢ': 0,
        'ⓣ': 0,
        'ⓤ': 0,
        'ⓥ': 0,
        'ⓦ': 0,
        'ⓧ': 0,
        'ⓨ': 0,
        'ⓩ': 0,
        'ꞔ': 0,
        'ꞹ': 0,
        'ꞻ': 0,
        'ꞽ': 0,
        'ꞿ': 0,
        'ꟃ': 0,
        'ﬀ': 0,
        'ﬁ': 0,
        'ﬂ': 0,
        'ﬃ': 0,
        'ﬄ': 0,
        'ﬅ': 0,
        'ﬆ': 0,
        'ﬓ': 0,
        'ﬔ': 0,
        'ﬕ': 0,
        'ﬖ': 0,
        'ﬗ': 0,
        '𖹠': 0,
        '𖹡': 0,
        '𖹢': 0,
        '𖹣': 0,
        '𖹤': 0,
        '𖹥': 0,
        '𖹦': 0,
        '𖹧': 0,
        '𖹨': 0,
        '𖹩': 0,
        '𖹪': 0,
        '𖹫': 0,
        '𖹬': 0,
        '𖹭': 0,
        '𖹮': 0,
        '𖹯': 0,
        '𖹰': 0,
        '𖹱': 0,
        '𖹲': 0,
        '𖹳': 0,
        '𖹴': 0,
        '𖹵': 0,
        '𖹶': 0,
        '𖹷': 0,
        '𖹸': 0,
        '𖹹': 0,
        '𖹺': 0,
        '𖹻': 0,
        '𖹼': 0,
        '𖹽': 0,
        '𖹾': 0,
        '𖹿': 0
    };
    module.exports = (chr) => {
        const compatUpper = toUpperMapping[chr];
        const mapped = (compatUpper === 0) ? chr : compatUpper;
        return mapped || chr.toUpperCase();
    };
}());
