"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    COLUMN_ID: function() {
        return COLUMN_ID;
    },
    END_POS_ID: function() {
        return END_POS_ID;
    },
    LINE_ID: function() {
        return LINE_ID;
    },
    START_POS_ID: function() {
        return START_POS_ID;
    },
    TYPE_ATTR_NAME: function() {
        return TYPE_ATTR_NAME;
    },
    TYPE_ATTR_VALUE: function() {
        return TYPE_ATTR_VALUE;
    },
    TYPE_ID: function() {
        return TYPE_ID;
    },
    TYPE_NEW_LINE: function() {
        return TYPE_NEW_LINE;
    },
    TYPE_SPACE: function() {
        return TYPE_SPACE;
    },
    TYPE_TAG: function() {
        return TYPE_TAG;
    },
    TYPE_WORD: function() {
        return TYPE_WORD;
    },
    Token: function() {
        return Token;
    },
    VALUE_ID: function() {
        return VALUE_ID;
    },
    default: function() {
        return _default;
    }
});
var _pluginhelper = require("@bbob/plugin-helper");
function _defineProperties(target, props) {
    for(var i = 0; i < props.length; i++){
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}
function _create_class(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
}
var TYPE_ID = "t"; // 0;
var VALUE_ID = "v"; // 1;
var LINE_ID = "l"; // 3;
var COLUMN_ID = "r"; // 2;
var START_POS_ID = "s"; // 4;
var END_POS_ID = "e"; // 5;
var TYPE_WORD = 1; // 'word';
var TYPE_TAG = 2; // 'tag';
var TYPE_ATTR_NAME = 3; // 'attr-name';
var TYPE_ATTR_VALUE = 4; // 'attr-value';
var TYPE_SPACE = 5; // 'space';
var TYPE_NEW_LINE = 6; // 'new-line';
var getTokenValue = function(token) {
    if (token && typeof token[VALUE_ID] !== "undefined") {
        return token[VALUE_ID];
    }
    return "";
};
var getTokenLine = function(token) {
    return token && token[LINE_ID] || 0;
};
var getTokenColumn = function(token) {
    return token && token[COLUMN_ID] || 0;
};
var getStartPosition = function(token) {
    return token && token[START_POS_ID] || 0;
};
var getEndPosition = function(token) {
    return token && token[END_POS_ID] || 0;
};
var isTextToken = function(token) {
    if (token && typeof token[TYPE_ID] !== "undefined") {
        return token[TYPE_ID] === TYPE_SPACE || token[TYPE_ID] === TYPE_NEW_LINE || token[TYPE_ID] === TYPE_WORD;
    }
    return false;
};
var isTagToken = function(token) {
    if (token && typeof token[TYPE_ID] !== "undefined") {
        return token[TYPE_ID] === TYPE_TAG;
    }
    return false;
};
var isTagEnd = function(token) {
    return getTokenValue(token).charCodeAt(0) === _pluginhelper.SLASH.charCodeAt(0);
};
var isTagStart = function(token) {
    return !isTagEnd(token);
};
var isAttrNameToken = function(token) {
    if (token && typeof token[TYPE_ID] !== "undefined") {
        return token[TYPE_ID] === TYPE_ATTR_NAME;
    }
    return false;
};
var isAttrValueToken = function(token) {
    if (token && typeof token[TYPE_ID] !== "undefined") {
        return token[TYPE_ID] === TYPE_ATTR_VALUE;
    }
    return false;
};
var getTagName = function(token) {
    var value = getTokenValue(token);
    return isTagEnd(token) ? value.slice(1) : value;
};
var tokenToText = function(token, openTag, closeTag) {
    if (openTag === void 0) openTag = _pluginhelper.OPEN_BRAKET;
    if (closeTag === void 0) closeTag = _pluginhelper.CLOSE_BRAKET;
    var text = openTag;
    text += getTokenValue(token);
    text += closeTag;
    return text;
};
/**
 * @export
 * @class Token
 */ var Token = /*#__PURE__*/ function() {
    "use strict";
    function Token(type, value, row, col, start, end) {
        if (row === void 0) row = 0;
        if (col === void 0) col = 0;
        if (start === void 0) start = 0;
        if (end === void 0) end = 0;
        this[LINE_ID] = row;
        this[COLUMN_ID] = col;
        this[TYPE_ID] = type || 0;
        this[VALUE_ID] = String(value);
        this[START_POS_ID] = start;
        this[END_POS_ID] = end;
    }
    var _proto = Token.prototype;
    _proto.isEmpty = function isEmpty() {
        return this[TYPE_ID] === 0 || isNaN(this[TYPE_ID]);
    };
    _proto.isText = function isText() {
        return isTextToken(this);
    };
    _proto.isTag = function isTag() {
        return isTagToken(this);
    };
    _proto.isAttrName = function isAttrName() {
        return isAttrNameToken(this);
    };
    _proto.isAttrValue = function isAttrValue() {
        return isAttrValueToken(this);
    };
    _proto.isStart = function isStart() {
        return isTagStart(this);
    };
    _proto.isEnd = function isEnd() {
        return isTagEnd(this);
    };
    _proto.getName = function getName() {
        return getTagName(this);
    };
    _proto.getValue = function getValue() {
        return getTokenValue(this);
    };
    _proto.getLine = function getLine() {
        return getTokenLine(this);
    };
    _proto.getColumn = function getColumn() {
        return getTokenColumn(this);
    };
    _proto.getStart = function getStart() {
        return getStartPosition(this);
    };
    _proto.getEnd = function getEnd() {
        return getEndPosition(this);
    };
    _proto.toString = function toString(param) {
        var _ref = param === void 0 ? {} : param, _ref_openTag = _ref.openTag, openTag = _ref_openTag === void 0 ? _pluginhelper.OPEN_BRAKET : _ref_openTag, _ref_closeTag = _ref.closeTag, closeTag = _ref_closeTag === void 0 ? _pluginhelper.CLOSE_BRAKET : _ref_closeTag;
        return tokenToText(this, openTag, closeTag);
    };
    _create_class(Token, [
        {
            key: "type",
            get: function get() {
                return this[TYPE_ID];
            }
        }
    ]);
    return Token;
}();
var _default = Token;
