import {
  jsonp
} from "./chunk-IPDEGCWU.js";
import {
  NarouNovel
} from "./chunk-6BZWV4ZC.js";

// src/narou-jsonp.ts
var NarouNovelJsonp = class extends NarouNovel {
  async execute(params, endpoint) {
    const query = { ...params, out: "jsonp" };
    query.gzip = 0;
    const url = new URL(endpoint);
    Object.entries(query).forEach(([key, value]) => {
      if (value !== void 0) {
        url.searchParams.append(key, value.toString());
      }
    });
    return await jsonp(url.toString());
  }
};

export {
  NarouNovelJsonp
};
//# sourceMappingURL=chunk-LQLNWSWV.js.map