import { DevtoolServer } from '../devtool';
import { DevtoolMessageListener, RequestCenter } from '../request-center';

export interface PluginContext {
    devtool: DevtoolServer;
    core: RequestCenter;
}
export interface CoreCotext {
    devtool: DevtoolServer;
    core: RequestCenter;
    plugins: PluginInstance<any>[];
}
export type PluginHandler<T> = (props: CoreCotext) => T;
export type PluginInstance<T> = {
    (props: CoreCotext): T;
    id: string;
};
/**
 * @description create a plugin for devtool
 * @param fn
 *  the plugin handler, you can use hook in it.
 *  if you want to do some clean work, you can return a function
 * @example
 * ```ts
 * createPlugin(({ devtool, core }) => {
 *   const store = new Map()
 *   useHandler('Network.requestWillBeSent', ({ id, request }) => {
 *     store.set(id, request)
 *   })
 *   useHandler('Network.loadingFinished', ({ id }) => {
 *     store.delete(id)
 *   })
 *  setInterval(() => {
 *    console.log(store.size)
 *  }, 1000)
 *   return () => {
 *     store.clear()
 *   }
 * })
 * ```
 * @returns PluginInstance
 */
export declare const createPlugin: <T>(id: string, fn: PluginHandler<T>) => PluginInstance<T>;
/**
 * @param type the method name of CDP message / custom type from main process
 * @mark all hook can only be used in createPlugin
 * @returns
 */
export declare const useHandler: <T>(type: string, fn: DevtoolMessageListener<T>) => (() => void) | undefined;
export declare const useConnect: (fn: () => void) => (() => void) | undefined;
/**
 * @mark all hook can only be used in createPlugin
 */
export declare const useContext: () => PluginContext;
//# sourceMappingURL=common.d.ts.map