"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    default: function() {
        return _default;
    },
    html: function() {
        return html;
    },
    render: function() {
        return render;
    }
});
var _core = /*#__PURE__*/ _interop_require_default(require("@bbob/core"));
var _pluginhelper = require("@bbob/plugin-helper");
function _extends() {
    _extends = Object.assign || function(target) {
        for(var i = 1; i < arguments.length; i++){
            var source = arguments[i];
            for(var key in source){
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }
        return target;
    };
    return _extends.apply(this, arguments);
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
var SELFCLOSE_END_TAG = "/>";
var CLOSE_START_TAG = "</";
var START_TAG = "<";
var END_TAG = ">";
function renderNode(node, options) {
    var _ref = options || {}, _ref_stripTags = _ref.stripTags, stripTags = _ref_stripTags === void 0 ? false : _ref_stripTags;
    if (typeof node === "undefined" || node === null) {
        return "";
    }
    if (typeof node === "string" || typeof node === "number") {
        return String(node);
    }
    if (Array.isArray(node)) {
        return render(node, options);
    }
    if ((0, _pluginhelper.isTagNode)(node)) {
        if (stripTags) {
            return render(node.content, options);
        }
        var attrs = (0, _pluginhelper.attrsToString)(node.attrs);
        if (node.content === null) {
            return START_TAG + node.tag + attrs + SELFCLOSE_END_TAG;
        }
        return START_TAG + node.tag + attrs + END_TAG + render(node.content, options) + CLOSE_START_TAG + node.tag + END_TAG;
    }
    return "";
}
function render(nodes, options) {
    if (nodes && Array.isArray(nodes)) {
        return nodes.reduce(function(r, node) {
            return r + renderNode(node, options);
        }, "");
    }
    if (nodes) {
        return renderNode(nodes, options);
    }
    return "";
}
function html(source, plugins, options) {
    return (0, _core.default)(plugins).process(source, _extends({}, options, {
        render: render
    })).html;
}
var _default = html;
