import { z } from "zod";
const htmlRenderingConfigurationSchema = z.object({
  /**
   * The URL to the Scalar API Reference JS CDN.
   *
   * Use this to pin a specific version of the Scalar API Reference.
   *
   * @default https://cdn.jsdelivr.net/npm/@scalar/api-reference
   *
   * @example https://cdn.jsdelivr.net/npm/@scalar/api-reference@1.25.122
   */
  cdn: z.string().optional().default("https://cdn.jsdelivr.net/npm/@scalar/api-reference"),
  /**
   * The title of the page.
   */
  pageTitle: z.string().optional().default("Scalar API Reference")
});
export {
  htmlRenderingConfigurationSchema
};
//# sourceMappingURL=html-rendering-configuration.js.map
