import type Fanfou from './fanfou.js';
import type { DirectMessage, Status, Trend, User } from './types.js';
export type APIMode = 'default' | 'lite';
export type APIFormat = 'html';
export type SearchPublicTimelineOptions = {
    q: string;
    sinceId?: string;
    maxId?: string;
    count?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const searchPublicTimeline: (ff: Fanfou, options: SearchPublicTimelineOptions) => Promise<Status[]>;
export type SearchUsersOptions = {
    q: string;
    count?: number;
    page?: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export type SearchUsersResult = {
    totalNumber: number;
    users: User[];
};
export declare const searchUsers: (ff: Fanfou, options: SearchUsersOptions) => Promise<SearchUsersResult>;
export type SearchUserTimelineOptions = {
    q: string;
    id?: string;
    sinceId?: string;
    maxId?: string;
    count?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const searchUserTimeline: (ff: Fanfou, options: SearchUserTimelineOptions) => Promise<Status[]>;
export declare const getBlockedIds: (ff: Fanfou) => Promise<string[]>;
export type GetBlockedUsersOptions = {
    mode?: APIMode;
    page?: number;
    count?: number;
};
export declare const getBlockedUsers: (ff: Fanfou, options?: GetBlockedUsersOptions) => Promise<User[]>;
export type CreateBlockedUserOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const createBlockedUser: (ff: Fanfou, options: CreateBlockedUserOptions) => Promise<User>;
export type CheckBlockExistsOptions = {
    id: string;
    mode?: APIMode;
};
export declare const checkBlockExists: (ff: Fanfou, options: CheckBlockExistsOptions) => Promise<User>;
export type DropBlockedUserOptions = {
    id: string;
    mode?: APIMode;
};
export declare const dropBlockedUser: (ff: Fanfou, options: DropBlockedUserOptions) => Promise<User>;
export type GetTaggedUsersOptions = {
    tag?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getTaggedUsers: (ff: Fanfou, options?: GetTaggedUsersOptions) => Promise<User[]>;
export type GetUserOptions = {
    id?: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getUser: (ff: Fanfou, options?: GetUserOptions) => Promise<User>;
export type GetUserTagsOptions = {
    id?: string;
    callback?: string;
};
export declare const getUserTags: (ff: Fanfou, options?: GetUserTagsOptions) => Promise<string[]>;
export type GetRecentFollowersOptions = {
    id?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getRecentFollowers: (ff: Fanfou, options?: GetRecentFollowersOptions) => Promise<User[]>;
export type GetRecommendedUsersOptions = {
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getRecommendedUsers: (ff: Fanfou, options?: GetRecommendedUsersOptions) => Promise<User[]>;
export type DismissRecommendedUserOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const dismissRecommendedUser: (ff: Fanfou, options: DismissRecommendedUserOptions) => Promise<User>;
export type GetRecentUsersOptions = {
    id?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getRecentUsers: (ff: Fanfou, options?: GetRecentUsersOptions) => Promise<User[]>;
export type VerifyCredentialsOptions = {
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const verifyCredentials: (ff: Fanfou, options?: VerifyCredentialsOptions) => Promise<User>;
export type UpdateProfileImageOptions = {
    image: ReadableStream | Uint8Array;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const updateProfileImage: (ff: Fanfou, options: UpdateProfileImageOptions) => Promise<User>;
export type GetRateLimitStatusOptions = {
    callback?: string;
};
export type GetRateLimitStatusResult = {
    resetTime: string;
    remainingHit: number;
    hourlyLimit: number;
    resetTimeInSeconds: number;
};
export declare const getRateLimitStatus: (ff: Fanfou, options?: GetRateLimitStatusOptions) => Promise<GetRateLimitStatusResult>;
export type UpdateProfileOptions = {
    url?: string;
    mode?: APIMode;
    callback?: string;
    location?: string;
    description?: string;
    name?: string;
    email?: string;
};
export declare const updateProfile: (ff: Fanfou, options?: UpdateProfileOptions) => Promise<User>;
export type GetNotificationResult = {
    mentions: number;
    directMessages: number;
    friendRequest: number;
};
export declare const getNotification: (ff: Fanfou) => Promise<GetNotificationResult>;
export type UpdateNotifyNumberOptions = {
    notifyNum: number;
};
export type UpdateNotifyNumberResult = {
    result: string;
    notifyNum: number;
};
export declare const updateNotifyNumber: (ff: Fanfou, options?: UpdateNotifyNumberOptions) => Promise<UpdateNotifyNumberResult>;
export type CreateSavedSearchOptions = {
    query?: string;
    callback?: string;
};
export declare const createSavedSearch: (ff: Fanfou, options?: CreateSavedSearchOptions) => Promise<Trend>;
export type DropSavedSearchOptions = {
    id: number;
    callback?: string;
};
export declare const dropSavedSearch: (ff: Fanfou, options: DropSavedSearchOptions) => Promise<Trend>;
export type GetSavedSearchOptions = {
    id?: number;
    callback?: string;
};
export declare const getSavedSearch: (ff: Fanfou, options?: GetSavedSearchOptions) => Promise<Trend>;
export type GetSavedSearchesOptions = {
    callback?: string;
};
export declare const getSavedSearches: (ff: Fanfou, options?: GetSavedSearchesOptions) => Promise<Trend[]>;
export type GetUserPhotosOptions = {
    id?: string;
    sinceId?: string;
    maxId?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getUserPhotos: (ff: Fanfou, options?: GetUserPhotosOptions) => Promise<Status>;
export type UploadPhotoOptions = {
    photo: ReadableStream | Uint8Array;
    status?: string;
    source?: string;
    location?: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const uploadPhoto: (ff: Fanfou, options: UploadPhotoOptions) => Promise<Status>;
export type GetTrendsOptions = {
    callback?: string;
};
export type GetTrendsResult = {
    asOf: string;
    trends: Trend[];
};
export declare const getTrends: (ff: Fanfou, options?: GetTrendsOptions) => Promise<GetTrendsResult>;
export type GetFollowerIdsOptions = {
    id?: string;
    page?: number;
    count?: number;
    callback?: string;
};
export declare const getFollowerIds: (ff: Fanfou, options?: GetFollowerIdsOptions) => Promise<string[]>;
export type DropFavoriteOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
};
export declare const dropFavorite: (ff: Fanfou, options: DropFavoriteOptions) => Promise<Status>;
export type GetFavoritesOptions = {
    id?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getFavorites: (ff: Fanfou, options?: GetFavoritesOptions) => Promise<Status[]>;
export type CreateFavoriteOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const createFavorite: (ff: Fanfou, options: CreateFavoriteOptions) => Promise<Status>;
export type CreateFriendshipOptions = {
    id: string;
    mode?: APIMode;
};
export declare const createFriendship: (ff: Fanfou, options: CreateFriendshipOptions) => Promise<User>;
export type DropFriendshipOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const dropFriendship: (ff: Fanfou, options: DropFriendshipOptions) => Promise<User>;
export type CheckFriendshipRequestsOptions = {
    page?: number;
    count?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const checkFriendshipRequests: (ff: Fanfou, options: CheckFriendshipRequestsOptions) => Promise<User[]>;
export type DenyFriendshipOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const denyFriendship: (ff: Fanfou, options: DenyFriendshipOptions) => Promise<User>;
export type CheckFriendshipOptions = {
    userA: string;
    userB: string;
};
export declare const checkFriendship: (ff: Fanfou, options: CheckFriendshipOptions) => Promise<boolean>;
export type AcceptFriendshipOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const acceptFriendship: (ff: Fanfou, options: AcceptFriendshipOptions) => Promise<User>;
export type CheckFriendshipDetailOptions = {
    sourceLoginName?: string;
    targetLoginName?: string;
    source_id?: string;
    target_id?: string;
};
export type FriendshipResult = {
    id: string;
    screenName: string;
    following: boolean;
    followedBy: boolean;
    notificationEnabled?: boolean;
    blocking?: boolean;
};
export type CheckFriendshipDetailResult = {
    relationship: {
        source: FriendshipResult;
        target: FriendshipResult;
    };
};
export declare const checkFriendshipDetail: (ff: Fanfou, options: CheckFriendshipDetailOptions) => Promise<CheckFriendshipDetailResult>;
export type GetFollowingIdsOptions = {
    id?: string;
    page?: number;
    count?: number;
    callback?: string;
};
export declare const getFollowingIds: (ff: Fanfou, options?: GetFollowingIdsOptions) => Promise<string[]>;
export type DropStatusOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const dropStatus: (ff: Fanfou, options: DropStatusOptions) => Promise<User>;
export type GetHomeTimelineOptions = {
    id?: string;
    sinceId?: string;
    maxId?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getHomeTimeline: (ff: Fanfou, options?: GetHomeTimelineOptions) => Promise<Status[]>;
export type GetPublicTimelineOptions = {
    count?: number;
    sinceId?: string;
    maxId?: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getPublicTimeline: (ff: Fanfou, options?: GetPublicTimelineOptions) => Promise<Status[]>;
export type GetRepliesOptions = {
    sinceId?: string;
    maxId?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getReplies: (ff: Fanfou, options?: GetRepliesOptions) => Promise<Status[]>;
export type GetFollowersOptions = {
    id?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getFollowers: (ff: Fanfou, options?: GetFollowersOptions) => Promise<User[]>;
export type CreateStatusOptions = {
    status: string;
    inReplyToStatusId?: string;
    inReplyToUserId?: string;
    repostStatusId?: string;
    source?: string;
    mode?: APIMode;
    location?: string;
    callback?: string;
};
export declare const createStatus: (ff: Fanfou, options: CreateStatusOptions) => Promise<Status>;
export type GetUserTimelineOptions = {
    id?: string;
    sinceId?: string;
    maxId?: string;
    count?: string;
    page?: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getUserTimeline: (ff: Fanfou, options?: GetUserTimelineOptions) => Promise<Status[]>;
export type GetFollowingsOptions = {
    id?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    callback?: string;
};
export declare const getFollowings: (ff: Fanfou, options?: GetFollowingsOptions) => Promise<User[]>;
export type GetContextTimelineOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getContextTimeline: (ff: Fanfou, options: GetContextTimelineOptions) => Promise<Status[]>;
export type GetMentionsOptions = {
    sinceId?: string;
    maxId?: string;
    count?: number;
    page?: number;
    mode?: APIMode;
    format?: APIFormat;
};
export declare const getMentions: (ff: Fanfou, options: GetMentionsOptions) => Promise<Status[]>;
export type GetStatusOptions = {
    id: string;
    mode?: APIMode;
    format?: APIFormat;
    callback?: string;
};
export declare const getStatus: (ff: Fanfou, options: GetStatusOptions) => Promise<Status>;
export type DropDirectMessageOptions = {
    id: string;
    callback?: string;
};
export declare const dropDirectMessage: (ff: Fanfou, options: DropDirectMessageOptions) => Promise<DirectMessage>;
export type GetConversationOptions = {
    id: string;
    count?: number;
    page?: number;
    maxId?: string;
    sinceId?: string;
    mode?: APIMode;
    callback?: string;
};
export declare const getConversation: (ff: Fanfou, options: GetConversationOptions) => Promise<DirectMessage[]>;
export type CreateDirectMessageOptions = {
    user: string;
    text: string;
    inReplyToId?: string;
    mode?: APIMode;
    callback?: string;
};
export declare const createDirectMessage: (ff: Fanfou, options: CreateDirectMessageOptions) => Promise<DirectMessage>;
export type GetConversationsOptions = {
    count?: number;
    page?: number;
    mode?: string;
    callback?: string;
};
export type GetConversationsResult = {
    dm: DirectMessage;
    otherid: string;
    msgNum: number;
    newConv: boolean;
};
export declare const getConversations: (ff: Fanfou, options?: GetConversationsOptions) => Promise<GetConversationsOptions>;
export type GetInboxOptions = {
    count?: number;
    page?: number;
    sinceId?: string;
    maxId?: string;
    mode?: string;
    callback?: string;
};
export declare const getInbox: (ff: Fanfou, options?: GetInboxOptions) => Promise<DirectMessage[]>;
export type GetSentOptions = {
    count?: number;
    page?: number;
    sinceId?: string;
    maxId?: string;
    mode?: APIMode;
    callback?: string;
};
export declare const getSent: (ff: Fanfou, options?: GetSentOptions) => Promise<DirectMessage[]>;
