import { State } from './state';
import { Request } from './request';
import { FeedFactory } from './feed.factory';
import { AccountRepository } from '../repositories/account.repository';
import { MediaRepository } from '../repositories/media.repository';
import { ChallengeRepository } from '../repositories/challenge.repository';
import { FriendshipRepository } from '../repositories/friendship.repository';
import { UploadRepository } from '../repositories/upload.repository';
import { PublishService } from '../services/publish.service';
import { DirectThreadRepository } from '../repositories/direct-thread.repository';
import { EntityFactory } from './entity.factory';
import { QeRepository } from '../repositories/qe.repository';
import { ZrRepository } from '../repositories/zr.repository';
import { LauncherRepository } from '../repositories/launcher.repository';
import { DirectRepository } from '../repositories/direct.repository';
import { LoomRepository } from '../repositories/loom.repository';
import { QpRepository } from '../repositories/qp.repository';
import { CreativesRepository } from '../repositories/creatives.repository';
import { LinkedAccountRepository } from '../repositories/linked-account.repository';
import { AttributionRepository } from '../repositories/attribution.repository';
import { FbsearchRepository } from '../repositories/fbsearch.repository';
import { SimulateService } from '../services/simulate.service';
import { DiscoverRepository } from '../repositories/discover.repository';
import { ConsentRepository } from '../repositories/consent.repository';
import { UserRepository } from '../repositories/user.repository';
import { TagRepository } from '../repositories/tag.repository';
import { SearchService } from '../services/search.service';
import { StoryService } from '../services/story.service';
import { LiveRepository } from '../repositories/live.repository';
import { LocationRepository } from '../repositories/location.repository';
import { LocationSearch } from '../repositories/location-search.repository';
import { MusicRepository } from '../repositories/music.repository';
import { NewsRepository } from '../repositories/news.repository';
import { HighlightsRepository } from '../repositories/highlights.repository';
import { AdsRepository } from '../repositories/ads.repository';
import { InsightsService } from '../services/insights.service';
import { RestrictActionRepository } from '../repositories/restrict-action.repository';
import { AddressBookRepository } from '../repositories/address-book.repository';
import { StatusRepository } from '../repositories/status.repository';
import { IgtvRepository } from '../repositories/igtv.repository';
export declare class IgApiClient {
    state: State;
    request: Request;
    feed: FeedFactory;
    entity: EntityFactory;
    account: AccountRepository;
    attribution: AttributionRepository;
    challenge: ChallengeRepository;
    consent: ConsentRepository;
    creatives: CreativesRepository;
    direct: DirectRepository;
    directThread: DirectThreadRepository;
    discover: DiscoverRepository;
    fbsearch: FbsearchRepository;
    friendship: FriendshipRepository;
    launcher: LauncherRepository;
    linkedAccount: LinkedAccountRepository;
    loom: LoomRepository;
    media: MediaRepository;
    qe: QeRepository;
    qp: QpRepository;
    tag: TagRepository;
    upload: UploadRepository;
    user: UserRepository;
    zr: ZrRepository;
    live: LiveRepository;
    location: LocationRepository;
    locationSearch: LocationSearch;
    music: MusicRepository;
    news: NewsRepository;
    highlights: HighlightsRepository;
    ads: AdsRepository;
    restrictAction: RestrictActionRepository;
    addressBook: AddressBookRepository;
    status: StatusRepository;
    igtv: IgtvRepository;
    publish: PublishService;
    search: SearchService;
    simulate: SimulateService;
    story: StoryService;
    insights: InsightsService;
    destroy(): void;
}
