import { proto } from "../proto.mjs";
import protobuf from "protobufjs";

//#region src/lib/decode.ts
function decode(data, type) {
	return new Promise((resolve) => {
		const root = protobuf.parse(proto).root;
		const messageType = root.lookupType(`mixi.${type}`).decode(data);
		resolve(root.lookupType(`mixi.${type}`).toObject(messageType));
	});
}

//#endregion
export { decode };