import {
  NovelSearchBuilderBase
} from "./chunk-HOBLKBZ6.js";

// src/search-builder-r18.ts
var SearchBuilderR18 = class extends NovelSearchBuilderBase {
  /**
   * なろう小説APIへの検索リクエストを実行する
   * @override
   * @returns {Promise<NarouSearchResults>} 検索結果
   */
  execute() {
    return this.api.executeNovel18(this.params);
  }
  /**
   * 抽出するR18サイトを指定します (nocgenre)。
   * @param sites R18サイトコード、またはR18サイトコードの配列 (1: ノクターンノベルズ, 2: ムーンライトノベルズ(男性向け), 3: ムーンライトノベルズ(BL), 4: ミッドナイトノベルズ)
   * @return {this}
   */
  r18Site(sites) {
    this.set({ nocgenre: NovelSearchBuilderBase.array2string(sites) });
    return this;
  }
  /**
   * X-IDを指定して取得します (xid)。
   * @param ids X-ID、またはX-IDの配列
   * @return {this}
   */
  xid(ids) {
    this.set({ xid: NovelSearchBuilderBase.array2string(ids) });
    return this;
  }
  /**
   * 出力する項目を個別に指定します (of)。
   * 未指定時は全項目出力されます。転送量軽減のため、このパラメータの使用が推奨されます。
   * @param fields 出力するR18フィールド名、またはR18フィールド名の配列
   * @return {SearchBuilderR18<SearchResultR18Fields<R18Fields>>} 型が更新されたビルダー
   */
  fields(fields) {
    this.set({ of: NovelSearchBuilderBase.array2string(fields) });
    return this;
  }
  /**
   * 出力オプション項目を指定します (opt)。
   * @param option 出力するオプションフィールド名、またはオプションフィールド名の配列
   * @return {SearchBuilderR18<T, SearchResultOptionalFields<TFields>>} 型が更新されたビルダー
   */
  opt(option) {
    this.set({ opt: NovelSearchBuilderBase.array2string(option) });
    return this;
  }
};

export {
  SearchBuilderR18
};
//# sourceMappingURL=chunk-E2H3AJSQ.js.map