import { R as RankingType } from './narou-search-results-DT0YdaBn.js';
import './util/type.js';

interface RankingHistoryRawResult {
    rtype: `${string}-${RankingType}`;
    pt: number;
    rank: number;
}
interface RankingHistoryResult {
    type: RankingType;
    date: Date;
    pt: number;
    rank: number;
}
/**
 * 生のランキング履歴エントリを構造化された形式にフォーマットします。
 *
 * @param rankin - フォーマットする生のランキング履歴データ
 * @returns 日付とタイプが解析されたフォーマット済みランキング履歴
 *
 * @example
 * const rawData = { rtype: "20230101-daily", pt: 500, rank: 10 };
 * const formattedData = formatRankingHistory(rawData);
 * // 返り値: { type: "daily", date: [Dateオブジェクト], pt: 500, rank: 10 }
 */
declare function formatRankingHistory(rankin: RankingHistoryRawResult): RankingHistoryResult;

export { type RankingHistoryRawResult, type RankingHistoryResult, formatRankingHistory };
