(function addThemePicker() {
    const rightButtonsElement = document.querySelector('.right-buttons');
    rightButtonsElement.insertAdjacentHTML("afterbegin", `
        <button id="language-toggle" class="icon-button" type="button"
                title="Change language" aria-label="Change language"
                aria-haspopup="true" aria-expanded="false"
                aria-controls="language-list">
            <i class="fa fa-globe"></i>
        </button>
        <ul id="language-list" class="theme-popup" aria-label="Languages" role="menu">
          <li role="none"><button role="menuitem" class="theme">
              <a id="en">English</a>
          </button></li>
          <li role="none"><button role="menuitem" class="theme">
              <a id="ja">日本語</a>
          </button></li>
          <li role="none"><button role="menuitem" class="theme">
              <a id="zh">中文</a>
          </button></li>
          <li role="none"><button role="menuitem" class="theme">
              <a id="es">Español</a>
          </button></li>
        </ul>
    `);

    const language = document.documentElement.getAttribute("lang");
    let langToggle = document.getElementById("language-toggle");
    let langList = document.getElementById("language-list");
    langToggle.addEventListener("click", (event) => {
        langList.style.display =
            langList.style.display == "block" ? "none" : "block";
    });
    let selectedLang = document.getElementById(language);
    if (selectedLang) {
        selectedLang.parentNode.classList.add("theme-selected");
    }

    // The path to the root, taking the current language into account.
    let full_path_to_root =
        language == "en" ? `${mdbookPathToRoot}` : `${mdbookPathToRoot}../`;
    // The page path (mdbook only gives us access to the path to the Markdown file).
    let path = mdbookPath.replace(/\.md$/, ".html");
    const langAnchors = Array.from(langList.querySelectorAll("a"));
    for (let lang of langAnchors) {
        if (lang.id == "en") {
            lang.href = `${full_path_to_root}${path}`;
        } else {
            lang.href = `${full_path_to_root}${lang.id}/${path}`;
        }
    }

    // Hide languages whose target page is not available (e.g., not deployed).
    // This prevents users from hitting 404s on sites that only ship some locales.
    for (let lang of langAnchors) {
        const url = lang.href;
        // Attempt a lightweight HEAD request; fall back to hiding on failure.
        fetch(url, { method: "HEAD" }).then((resp) => {
            if (!resp.ok) {
                const li = lang.parentNode && lang.parentNode.parentNode;
                if (li) li.style.display = "none";
            }
        }).catch(() => {
            const li = lang.parentNode && lang.parentNode.parentNode;
            if (li) li.style.display = "none";
        });
    }
})();
