
'use strict';
{
  const globals = this;
  const django = globals.django || (globals.django = {});

  
  django.pluralidx = function(n) {
    const v = (n != 1);
    if (typeof v === 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  /* gettext library */

  django.catalog = django.catalog || {};
  
  const newcatalog = {
    "(If left blank, owner will be admin)": "(If left blank, owner will be admin)",
    "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)": "(at least {passwordMinLength} characters and includes {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols)",
    "(at least {placeholder} characters)": "(at least {placeholder} characters)",
    "(current notification)": "(current notification)",
    "(current version)": "(current version)",
    "1 cell copied": "1 cell copied",
    "1 filter": "1 filter",
    "1 hidden property": "1 hidden property",
    "1 month ago": "1 month ago",
    "1 preset hidden property": "1 preset hidden property",
    "1 record selected": "1 record selected",
    "1 row is copied.": "1 row is copied.",
    "1 sort": "1 sort",
    "1 week ago": "1 week ago",
    "3 days ago": "3 days ago",
    "A file is being uploaded. Are you sure you want to leave this page?": "A file is being uploaded. Are you sure you want to leave this page?",
    "A file with the same name already exists in this folder.": "A file with the same name already exists in this folder.",
    "API Token": "API Token",
    "API token is copied to the clipboard.": "API token is copied to the clipboard.",
    "About Us": "About Us",
    "Abuse Content": "Abuse Content",
    "Abuse Reports": "Abuse Reports",
    "Abuse Type": "Abuse Type",
    "Abuse report added": "Abuse report added",
    "Accept": "Accept",
    "Accepted": "Accepted",
    "Accepted at": "Accepted at",
    "Accepter": "Accepter",
    "Access Log": "Access Log",
    "Accurate to minute": "Accurate to minute",
    "Action": "Action",
    "Actions": "Actions",
    "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email": "Activate user immediately after registration. If unchecked, a user need to be activated by administrator or via activation email",
    "Activated": "Activated",
    "Activated Users": "Activated Users",
    "Active": "Active",
    "Active Users": "Active Users",
    "Add": "Add",
    "Add Admin": "Add Admin",
    "Add Member": "Add Member",
    "Add Organization": "Add Organization",
    "Add Terms and Conditions": "Add Terms and Conditions",
    "Add User": "Add User",
    "Add Wiki": "Add Wiki",
    "Add admin": "Add admin",
    "Add cover": "Add cover",
    "Add custom permission": "Add custom permission",
    "Add group": "Add group",
    "Add group member": "Add group member",
    "Add icon": "Add icon",
    "Add institution": "Add institution",
    "Add new notification": "Add new notification",
    "Add option": "Add option",
    "Add password protection": "Add password protection",
    "Add permission": "Add permission",
    "Add user": "Add user",
    "Add view": "Add view",
    "Added": "Added",
    "Added user {user}": "Added user {user}",
    "Admin": "Admin",
    "Admin Login Logs": "Admin Login Logs",
    "Admin Operation Logs": "Admin Operation Logs",
    "Admin access": "Admin access",
    "Admins": "Admins",
    "Advanced": "Advanced",
    "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.": "After enable extended properties for files, you can add different properties to files, like collaborators, file expiring time, file description. You can also create different views for files based extended properties.",
    "All": "All",
    "All Groups": "All Groups",
    "All Notifications": "All Notifications",
    "All Public Links": "All Public Links",
    "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.": "Allow new user registrations. Uncheck this to prevent anyone from creating a new account.",
    "An integer that is greater than 0 or equal to -2.": "An integer that is greater than 0 or equal to -2.",
    "An integer that is greater than or equal to 0.": "An integer that is greater than or equal to 0.",
    "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.": "An internal link is a link to a file or folder that can be accessed by users with read permission to the file or folder.",
    "And": "And",
    "Anonymous User": "Anonymous User",
    "Another property has this property type": "Another property has this property type",
    "Another user is editing this file!": "Another user is editing this file!",
    "Anyone with the link": "Anyone with the link",
    "Are you sure to change group {placeholder} to department ?": "Are you sure to change group {placeholder} to department ?",
    "Are you sure to delete ": "Are you sure to delete ",
    "Are you sure to revoke access of user {placeholder} ?": "Are you sure to revoke access of user {placeholder} ?",
    "Are you sure you want to clear trash?": "Are you sure you want to clear trash?",
    "Are you sure you want to delete": "Are you sure you want to delete",
    "Are you sure you want to delete %s ?": "Are you sure you want to delete %s ?",
    "Are you sure you want to delete WebDAV password?": "Are you sure you want to delete WebDAV password?",
    "Are you sure you want to delete the notification ?": "Are you sure you want to delete the notification ?",
    "Are you sure you want to delete the selected share link(s) ?": "Are you sure you want to delete the selected share link(s) ?",
    "Are you sure you want to delete the selected user(s) ?": "Are you sure you want to delete the selected user(s) ?",
    "Are you sure you want to delete this page?": "Are you sure you want to delete this page?",
    "Are you sure you want to delete {placeholder} ?": "Are you sure you want to delete {placeholder} ?",
    "Are you sure you want to delete {placeholder} completely?": "Are you sure you want to delete {placeholder} completely?",
    "Are you sure you want to disconnect?": "Are you sure you want to disconnect?",
    "Are you sure you want to remove {placeholder} ?": "Are you sure you want to remove {placeholder} ?",
    "Are you sure you want to reset the password of {placeholder} ?": "Are you sure you want to reset the password of {placeholder} ?",
    "Are you sure you want to restore this library?": "Are you sure you want to restore this library?",
    "Are you sure you want to restore {placeholder}?": "Are you sure you want to restore {placeholder}?",
    "Are you sure you want to revoke the admin permission of {placeholder} ?": "Are you sure you want to revoke the admin permission of {placeholder} ?",
    "Are you sure you want to set {placeholder} as Admin?": "Are you sure you want to set {placeholder} as Admin?",
    "Are you sure you want to set {user_placeholder} inactive?": "Are you sure you want to set {user_placeholder} inactive?",
    "Are you sure you want to unlink this device?": "Are you sure you want to unlink this device?",
    "At server": "At server",
    "Audio": "Audio",
    "Auth Token created": "Auth Token created",
    "Auth Token deleted": "Auth Token deleted",
    "Auto deletion": "Auto deletion",
    "Automatically delete files that are not modified within certain days:": "Automatically delete files that are not modified within certain days:",
    "Avatar": "Avatar",
    "Avatar updated": "Avatar updated",
    "Back": "Back",
    "Basic": "Basic",
    "Bell Icon": "Bell Icon",
    "Besides Write permission, user can also share the library.": "Besides Write permission, user can also share the library.",
    "Branding": "Branding",
    "By day": "By day",
    "By month": "By month",
    "By name ascending": "By name ascending",
    "By name descending": "By name descending",
    "By quarter": "By quarter",
    "By size ascending": "By size ascending",
    "By size descending": "By size descending",
    "By time ascending": "By time ascending",
    "By time descending": "By time descending",
    "By week": "By week",
    "By year": "By year",
    "Can not copy folder %(src)s to its subfolder %(des)s": "Can not copy folder %(src)s to its subfolder %(des)s",
    "Can not move folder %(src)s to its subfolder %(des)s": "Can not move folder %(src)s to its subfolder %(des)s",
    "Cancel": "Cancel",
    "Cancel All": "Cancel All",
    "Cannot move parent page to child page": "Cannot move parent page to child page",
    "Capture information": "Capture information",
    "Capture time": "Capture time",
    "Certificate": "Certificate",
    "Change": "Change",
    "Change Password": "Change Password",
    "Change Password of Library {placeholder}": "Change Password of Library {placeholder}",
    "Change cover": "Change cover",
    "Change group to department": "Change group to department",
    "Change to department": "Change to department",
    "Changes": "Changes",
    "Checkbox": "Checkbox",
    "Choose date": "Choose date",
    "Clean": "Clean",
    "Clean succeeded.": "Clean succeeded.",
    "Cleaned trash": "Cleaned trash",
    "Clear": "Clear",
    "Clear Trash": "Clear Trash",
    "Clear files in trash and history\uff1a": "Clear files in trash and history\uff1a",
    "Clear selected": "Clear selected",
    "Close": "Close",
    "Code": "Code",
    "Collaborator": "Collaborator",
    "Collapse all": "Collapse all",
    "Color space": "Color space",
    "Community Edition": "Community Edition",
    "Compressed": "Compressed",
    "Configure Seafile": "Configure Seafile",
    "Configure your Identity Provider": "Configure your Identity Provider",
    "Confirm": "Confirm",
    "Confirm password": "Confirm password",
    "Connect": "Connect",
    "Contact Email": "Contact Email",
    "Contact Email:": "Contact Email:",
    "Contact Information": "Contact Information",
    "Contact information is required.": "Contact information is required.",
    "Content Scan Records": "Content Scan Records",
    "Convert & Export": "Convert & Export",
    "Convert Wiki": "Convert Wiki",
    "Convert to Markdown": "Convert to Markdown",
    "Convert to docx": "Convert to docx",
    "Convert to sdoc": "Convert to sdoc",
    "Convert with ONLYOFFICE": "Convert with ONLYOFFICE",
    "Converting, please wait...": "Converting, please wait...",
    "Copied": "Copied",
    "Copied link to clipboard": "Copied link to clipboard",
    "Copy": "Copy",
    "Copy failed": "Copy failed",
    "Copy link": "Copy link",
    "Copy selected": "Copy selected",
    "Copy selected item(s) to:": "Copy selected item(s) to:",
    "Copy the IdP's certificate and paste it here. The certificate format is as follows:": "Copy the IdP's certificate and paste it here. The certificate format is as follows:",
    "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.": "Copy the domain DNS TXT and add it to your domain's DNS records, then click the button to verify domain ownership. You must verify the ownership of domain before Single Sign-On.",
    "Copy {num} items": "Copy {num} items",
    "Copy {placeholder} to": "Copy {placeholder} to",
    "Copyright Infringement": "Copyright Infringement",
    "Count": "Count",
    "Cover": "Cover",
    "Create": "Create",
    "Create At": "Create At",
    "Create Group": "Create Group",
    "Create Library": "Create Library",
    "Create Report": "Create Report",
    "Create a DNS TXT record to confirm the ownership of your Email Domain.": "Create a DNS TXT record to confirm the ownership of your Email Domain.",
    "Create a new tag": "Create a new tag",
    "Created": "Created",
    "Created At": "Created At",
    "Created Files": "Created Files",
    "Created draft": "Created draft",
    "Created file": "Created file",
    "Created folder": "Created folder",
    "Created group {group_name}": "Created group {group_name}",
    "Created library": "Created library",
    "Created library {library_name} with {owner} as its owner": "Created library {library_name} with {owner} as its owner",
    "Created time": "Created time",
    "Created {n} files": "Created {n} files",
    "Creator": "Creator",
    "Current Connected Devices": "Current Connected Devices",
    "Current Path: ": "Current Path: ",
    "Current page": "Current page",
    "Current password": "Current password",
    "Current password cannot be blank": "Current password cannot be blank",
    "Current path: ": "Current path: ",
    "Custom CSS": "Custom CSS",
    "Custom properties": "Custom properties",
    "Custom sharing permissions": "Custom sharing permissions",
    "Customize URL": "Customize URL",
    "DNS TXT Value": "DNS TXT Value",
    "Date": "Date",
    "Date Invalid.": "Date Invalid.",
    "Day": "Day",
    "Default": "Default",
    "Delete": "Delete",
    "Delete Account": "Delete Account",
    "Delete Department": "Delete Department",
    "Delete Expired Invitations": "Delete Expired Invitations",
    "Delete File": "Delete File",
    "Delete Folder": "Delete Folder",
    "Delete Group": "Delete Group",
    "Delete Library": "Delete Library",
    "Delete Member": "Delete Member",
    "Delete Notification": "Delete Notification",
    "Delete Password": "Delete Password",
    "Delete T&C": "Delete T&C",
    "Delete User": "Delete User",
    "Delete Users": "Delete Users",
    "Delete WebDAV Password": "Delete WebDAV Password",
    "Delete file": "Delete file",
    "Delete files from this device the next time it comes online.": "Delete files from this device the next time it comes online.",
    "Delete folder": "Delete folder",
    "Delete group": "Delete group",
    "Delete page": "Delete page",
    "Delete property": "Delete property",
    "Delete selected": "Delete selected",
    "Delete share links": "Delete share links",
    "Deleted": "Deleted",
    "Deleted Libraries": "Deleted Libraries",
    "Deleted Time": "Deleted Time",
    "Deleted directories": "Deleted directories",
    "Deleted draft": "Deleted draft",
    "Deleted file": "Deleted file",
    "Deleted files": "Deleted files",
    "Deleted folder": "Deleted folder",
    "Deleted group {group_name}": "Deleted group {group_name}",
    "Deleted library": "Deleted library",
    "Deleted library {library_name}": "Deleted library {library_name}",
    "Deleted option": "Deleted option",
    "Deleted user %s": "Deleted user %s",
    "Deleted user {user}": "Deleted user {user}",
    "Department renamed": "Department renamed",
    "Departments": "Departments",
    "Description": "Description",
    "Description is required": "Description is required",
    "Desktop": "Desktop",
    "Detail": "Detail",
    "Details": "Details",
    "Device": "Device",
    "Device Name": "Device Name",
    "Device make": "Device make",
    "Device model": "Device model",
    "Dimensions": "Dimensions",
    "Direct download link": "Direct download link",
    "Direct download link is copied to the clipboard.": "Direct download link is copied to the clipboard.",
    "Disable SAML user email / password login": "Disable SAML user email / password login",
    "Disconnect": "Disconnect",
    "Display files": "Display files",
    "Do not automatically delete files": "Do not automatically delete files",
    "Do you really want to turn off extended properties? Existing properties will all be deleted.": "Do you really want to turn off extended properties? Existing properties will all be deleted.",
    "Document": "Document",
    "Document conversion failed.": "Document conversion failed.",
    "Document keywords": "Document keywords",
    "Domain verified": "Domain verified",
    "Don't ignore": "Don't ignore",
    "Don't keep history": "Don't keep history",
    "Don't replace": "Don't replace",
    "Don't send emails": "Don't send emails",
    "Done": "Done",
    "Down": "Down",
    "Download": "Download",
    "Download and upload": "Download and upload",
    "Duplicate": "Duplicate",
    "Duplicate page": "Duplicate page",
    "Edit": "Edit",
    "Edit format settings": "Edit format settings",
    "Edit labels": "Edit labels",
    "Edit metadata properties": "Edit metadata properties",
    "Edit multiple select": "Edit multiple select",
    "Edit on cloud and download": "Edit on cloud and download",
    "Edit on cloud only": "Edit on cloud only",
    "Edit permission": "Edit permission",
    "Edit single select": "Edit single select",
    "Edit succeeded": "Edit succeeded",
    "Edit succeeded.": "Edit succeeded.",
    "Email": "Email",
    "Email Domain": "Email Domain",
    "Email Notification": "Email Notification",
    "Email is invalid.": "Email is invalid.",
    "Email notification updated": "Email notification updated",
    "Emails": "Emails",
    "Emails, separated by ','": "Emails, separated by ','",
    "Emojis": "Emojis",
    "Empty": "Empty",
    "Enable extended properties": "Enable extended properties",
    "Enable face recognition to identify people in your photos.": "Enable face recognition to identify people in your photos.",
    "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.": "Enable system admin to add Terms and Conditions, and all users will have to accept the terms.",
    "Enable two factor authentication": "Enable two factor authentication",
    "Enable users to share libraries to any groups in the system.": "Enable users to share libraries to any groups in the system.",
    "Encrypt": "Encrypt",
    "Encrypted library": "Encrypted library",
    "End date": "End date",
    "Enter characters to start searching": "Enter characters to start searching",
    "Error": "Error",
    "Errors": "Errors",
    "European": "European",
    "Exact date": "Exact date",
    "Exit Institution Admin": "Exit Institution Admin",
    "Exit Organization Admin": "Exit Organization Admin",
    "Exit System Admin": "Exit System Admin",
    "Expand all": "Expand all",
    "Expiration": "Expiration",
    "Expiration days": "Expiration days",
    "Expiration time": "Expiration time",
    "Expired": "Expired",
    "Expired at": "Expired at",
    "Export": "Export",
    "Export Excel": "Export Excel",
    "Export as docx": "Export as docx",
    "Export as zip": "Export as zip",
    "Export tags": "Export tags",
    "Exporting": "Exporting",
    "Exporting...": "Exporting...",
    "Exposure time": "Exposure time",
    "Extended properties": "Extended properties",
    "Extension Prompts": "Extension Prompts",
    "Extensions of text files that can be online previewed, each suffix is separated by a comma.": "Extensions of text files that can be online previewed, each suffix is separated by a comma.",
    "Extract file detail": "Extract file detail",
    "Extract file details": "Extract file details",
    "F number": "F number",
    "Face recognition": "Face recognition",
    "Failed": "Failed",
    "Failed imported options": "Failed imported options",
    "Failed to convert {name}.": "Failed to convert {name}.",
    "Failed to copy %(name)s": "Failed to copy %(name)s",
    "Failed to copy %(name)s and %(amount)s other item(s).": "Failed to copy %(name)s and %(amount)s other item(s).",
    "Failed to copy %(name)s.": "Failed to copy %(name)s.",
    "Failed to copy files to another library.": "Failed to copy files to another library.",
    "Failed to delete %(virus_file) from library %(library): %(error_msg)": "Failed to delete %(virus_file) from library %(library): %(error_msg)",
    "Failed to delete property": "Failed to delete property",
    "Failed to delete records": "Failed to delete records",
    "Failed to delete {name}": "Failed to delete {name}",
    "Failed to delete {name} and {n} other items.": "Failed to delete {name} and {n} other items.",
    "Failed to delete {name}.": "Failed to delete {name}.",
    "Failed to download. The total size of the files exceeded the limit.": "Failed to download. The total size of the files exceeded the limit.",
    "Failed to duplicate page": "Failed to duplicate page",
    "Failed to export. Please check whether the size of table attachments exceeds the limit.": "Failed to export. Please check whether the size of table attachments exceeds the limit.",
    "Failed to extract file details": "Failed to extract file details",
    "Failed to generate description": "Failed to generate description",
    "Failed to ignore %(virus_file) from library %(library): %(error_msg)": "Failed to ignore %(virus_file) from library %(library): %(error_msg)",
    "Failed to insert property": "Failed to insert property",
    "Failed to modify filter": "Failed to modify filter",
    "Failed to modify group": "Failed to modify group",
    "Failed to modify hidden properties": "Failed to modify hidden properties",
    "Failed to modify people name": "Failed to modify people name",
    "Failed to modify property data": "Failed to modify property data",
    "Failed to modify property order": "Failed to modify property order",
    "Failed to modify records": "Failed to modify records",
    "Failed to modify sort": "Failed to modify sort",
    "Failed to move %(name)s and %(amount)s other item(s).": "Failed to move %(name)s and %(amount)s other item(s).",
    "Failed to move %(name)s.": "Failed to move %(name)s.",
    "Failed to move files to another library.": "Failed to move files to another library.",
    "Failed to move {name}.": "Failed to move {name}.",
    "Failed to rename property": "Failed to rename property",
    "Failed to restore records": "Failed to restore records",
    "Failed to restore {name}": "Failed to restore {name}",
    "Failed to restore {name} and {n} other items": "Failed to restore {name} and {n} other items",
    "Failed to save": "Failed to save",
    "Failed to send to {email_placeholder}: {errorMsg_placeholder}": "Failed to send to {email_placeholder}: {errorMsg_placeholder}",
    "Failed to unshare {name}": "Failed to unshare {name}",
    "Failed to upload {file_name}.": "Failed to upload {file_name}.",
    "Failed. Please check the network.": "Failed. Please check the network.",
    "File": "File",
    "File Access": "File Access",
    "File Operations": "File Operations",
    "File Update": "File Update",
    "File Upload": "File Upload",
    "File Uploading...": "File Uploading...",
    "File already exists.": "File already exists.",
    "File collaborators": "File collaborators",
    "File details": "File details",
    "File download is disabled: the share link traffic of owner is used up.": "File download is disabled: the share link traffic of owner is used up.",
    "File expire time": "File expire time",
    "File extension white list": "File extension white list",
    "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.": "File extension white list for file upload via web UI and API. For example, \"md;txt;docx\". Empty means no limit.",
    "File extensions can only be {placeholder}.": "File extensions can only be {placeholder}.",
    "File is locked by others.": "File is locked by others.",
    "File name": "File name",
    "File owner": "File owner",
    "File reviewer": "File reviewer",
    "File size is too large.": "File size is too large.",
    "File status": "File status",
    "File too large": "File too large",
    "File type": "File type",
    "Files": "Files",
    "Files and folders": "Files and folders",
    "Filter": "Filter",
    "Filters": "Filters",
    "Find a tag": "Find a tag",
    "Find modifiers": "Find modifiers",
    "Focal length": "Focal length",
    "Folder": "Folder",
    "Folder Permission": "Folder Permission",
    "Folder does not exist.": "Folder does not exist.",
    "Force user to change password when account is newly added or reset by admin": "Force user to change password when account is newly added or reset by admin",
    "Force user to use SSO login if SAML account is bound": "Force user to use SSO login if SAML account is bound",
    "Force user to use a strong password when sign up or change password.": "Force user to use a strong password when sign up or change password.",
    "Format": "Format",
    "Freeze Document": "Freeze Document",
    "Freeze user account when failed login attempts exceed limit.": "Freeze user account when failed login attempts exceed limit.",
    "Frozen by {name}": "Frozen by {name}",
    "Gallery": "Gallery",
    "General information": "General information",
    "Generate Link": "Generate Link",
    "Generate description": "Generate description",
    "Generate links in batch": "Generate links in batch",
    "Generate share link": "Generate share link",
    "Germany Russia etc": "Germany Russia etc",
    "Global Address Book": "Global Address Book",
    "Greater than or equal to {minDays_placeholder} days": "Greater than or equal to {minDays_placeholder} days",
    "Grid view": "Grid view",
    "Group Permission": "Group Permission",
    "Group Shares": "Group Shares",
    "Group by": "Group by",
    "Group members": "Group members",
    "Grouped by 1 property": "Grouped by 1 property",
    "Groups": "Groups",
    "Guest": "Guest",
    "Handled": "Handled",
    "Help": "Help",
    "Hide": "Hide",
    "Hide all": "Hide all",
    "Hide properties": "Hide properties",
    "History": "History",
    "History Versions": "History Versions",
    "IP": "IP",
    "ISO": "ISO",
    "If notifications have not been read within one hour, they will be sent to your mailbox.": "If notifications have not been read within one hour, they will be sent to your mailbox.",
    "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.": "If turn on, the desktop clients will not be able to sync a folder outside the default Seafile folder.",
    "Ignore": "Ignore",
    "Ignored": "Ignored",
    "Import Users": "Import Users",
    "Import members": "Import members",
    "Import members from a .xlsx file": "Import members from a .xlsx file",
    "Import options": "Import options",
    "Import sdoc": "Import sdoc",
    "Import tags": "Import tags",
    "Import users": "Import users",
    "Import users from a .xlsx file": "Import users from a .xlsx file",
    "In progress": "In progress",
    "In review": "In review",
    "Inactive": "Inactive",
    "Info": "Info",
    "Institution Admin": "Institution Admin",
    "Internal Link": "Internal Link",
    "Internal Server Error": "Internal Server Error",
    "Internal link has been copied to clipboard": "Internal link has been copied to clipboard",
    "Invalid destination path": "Invalid destination path",
    "Invalid filename.": "Invalid filename.",
    "Invalid filter": "Invalid filter",
    "Invalid month, should be yyyymm.": "Invalid month, should be yyyymm.",
    "Invalid regular expression": "Invalid regular expression",
    "Invisible": "Invisible",
    "Invitations": "Invitations",
    "Invite Guest": "Invite Guest",
    "Invite Time": "Invite Time",
    "Invite users": "Invite users",
    "Invited at": "Invited at",
    "Inviter": "Inviter",
    "Is expired": "Is expired",
    "It is required.": "It is required.",
    "It may take some time, please wait.": "It may take some time, please wait.",
    "Keep full history": "Keep full history",
    "Keep sharing": "Keep sharing",
    "LDAP": "LDAP",
    "LDAP(imported)": "LDAP(imported)",
    "Label": "Label",
    "Label Current State": "Label Current State",
    "Labels": "Labels",
    "Language": "Language",
    "Language Setting": "Language Setting",
    "Last Access": "Last Access",
    "Last Login": "Last Login",
    "Last Update": "Last Update",
    "Last modified by": "Last modified by",
    "Last modified time": "Last modified time",
    "Last modifier": "Last modifier",
    "Leave": "Leave",
    "Leave Group": "Leave Group",
    "Leave Share": "Leave Share",
    "Leave group": "Leave group",
    "Leave this page? The system may not save your changes.": "Leave this page? The system may not save your changes.",
    "Less than or equal to {maxDays_placeholder} days": "Less than or equal to {maxDays_placeholder} days",
    "Libraries": "Libraries",
    "Library": "Library",
    "Library Type": "Library Type",
    "Library share permission not found.": "Library share permission not found.",
    "Limits": "Limits",
    "Link": "Link",
    "Link has been copied to clipboard": "Link has been copied to clipboard",
    "Linked Devices": "Linked Devices",
    "List view": "List view",
    "List your account in global address book, so that others can find you by typing your name.": "List your account in global address book, so that others can find you by typing your name.",
    "Load all": "Load all",
    "Loading": "Loading",
    "Location": "Location",
    "Lock": "Lock",
    "Login": "Login",
    "Login ID": "Login ID",
    "Logo updated": "Logo updated",
    "Long text": "Long text",
    "Manage group members": "Manage group members",
    "Manage members": "Manage members",
    "Mark all read": "Mark all read",
    "Max": "Max",
    "Max number of members": "Max number of members",
    "Member": "Member",
    "Members": "Members",
    "Message": "Message",
    "Message (optional):": "Message (optional):",
    "Migrate User": "Migrate User",
    "Mobile": "Mobile",
    "Modification Details": "Modification Details",
    "Modified": "Modified",
    "Modified by": "Modified by",
    "Modified by:": "Modified by:",
    "Modified files": "Modified files",
    "Modifier": "Modifier",
    "Modify": "Modify",
    "Modify includes modify file, move/rename file and folder": "Modify includes modify file, move/rename file and folder",
    "Modify name": "Modify name",
    "Month": "Month",
    "Month:": "Month:",
    "Monthly User Traffic": "Monthly User Traffic",
    "More": "More",
    "More operations": "More operations",
    "Move": "Move",
    "Move selected item(s) to:": "Move selected item(s) to:",
    "Move {num} items": "Move {num} items",
    "Move {placeholder} to": "Move {placeholder} to",
    "Moved file": "Moved file",
    "Moved folder": "Moved folder",
    "Multiple select": "Multiple select",
    "My Libraries": "My Libraries",
    "My Wikis": "My Wikis",
    "Name": "Name",
    "Name already exists": "Name already exists",
    "Name cannot be double dots": "Name cannot be double dots",
    "Name cannot be empty": "Name cannot be empty",
    "Name cannot contain backslash": "Name cannot contain backslash",
    "Name cannot contain backtick": "Name cannot contain backtick",
    "Name cannot contain curly braces": "Name cannot contain curly braces",
    "Name cannot contain dots": "Name cannot contain dots",
    "Name cannot contain slash": "Name cannot contain slash",
    "Name is required": "Name is required",
    "Name is required.": "Name is required.",
    "Name or ID": "Name or ID",
    "Name should be string": "Name should be string",
    "Name should not include '/'.": "Name should not include '/'.",
    "Name updated": "Name updated",
    "Name(optional)": "Name(optional)",
    "Network error": "Network error",
    "New": "New",
    "New Department": "New Department",
    "New Department Library": "New Department Library",
    "New Excel File": "New Excel File",
    "New File": "New File",
    "New Folder": "New Folder",
    "New Group": "New Group",
    "New Library": "New Library",
    "New Markdown File": "New Markdown File",
    "New Password": "New Password",
    "New Password Again": "New Password Again",
    "New PowerPoint File": "New PowerPoint File",
    "New SeaDoc File": "New SeaDoc File",
    "New Sub-department": "New Sub-department",
    "New Wiki name": "New Wiki name",
    "New Word File": "New Word File",
    "New directories": "New directories",
    "New file name": "New file name",
    "New files": "New files",
    "New folder name": "New folder name",
    "New page": "New page",
    "New password": "New password",
    "New password cannot be the same as old password": "New password cannot be the same as old password",
    "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.": "New password has been sent to your email {mail}. Please check your mailbox. If you don\u2019t receive the password, please check if your email address is properly configured.",
    "New password is too short": "New password is too short",
    "New passwords don't match": "New passwords don't match",
    "New view": "New view",
    "Next": "Next",
    "No Admin login logs": "No Admin login logs",
    "No Admin operation logs": "No Admin operation logs",
    "No Wikis": "No Wikis",
    "No changes": "No changes",
    "No collaborators": "No collaborators",
    "No collaborators available": "No collaborators available",
    "No connected devices": "No connected devices",
    "No deleted libraries": "No deleted libraries",
    "No favorites": "No favorites",
    "No file": "No file",
    "No file access logs": "No file access logs",
    "No file update logs": "No file update logs",
    "No filters": "No filters",
    "No folders shared": "No folders shared",
    "No groupings applied to this view.": "No groupings applied to this view.",
    "No groups": "No groups",
    "No guest invitations": "No guest invitations",
    "No invitations": "No invitations",
    "No libraries": "No libraries",
    "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.": "No libraries have been shared directly with you. A shared library can be shared with full or restricted permission. If you need access to a library owned by another user, ask the user to share the library with you.",
    "No libraries have been shared with you": "No libraries have been shared with you",
    "No libraries have been shared with you from other servers.": "No libraries have been shared with you from other servers.",
    "No libraries shared": "No libraries shared",
    "No libraries shared with this group": "No libraries shared with this group",
    "No linked devices": "No linked devices",
    "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "No linked devices. You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "No login logs": "No login logs",
    "No members": "No members",
    "No more activities": "No more activities",
    "No notifications": "No notifications",
    "No option": "No option",
    "No options": "No options",
    "No options available": "No options available",
    "No permission logs": "No permission logs",
    "No properties available to be hidden": "No properties available to be hidden",
    "No record": "No record",
    "No result": "No result",
    "No results": "No results",
    "No results matching": "No results matching",
    "No share links": "No share links",
    "No sync errors": "No sync errors",
    "No tags": "No tags",
    "No terms and conditions": "No terms and conditions",
    "No upload links": "No upload links",
    "No version history": "No version history",
    "Not allow user to clean library trash": "Not allow user to clean library trash",
    "Not allow user to create encrypted libraries": "Not allow user to create encrypted libraries",
    "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.": "Note: Settings via web interface are saved in database table (seahub-db/constance_config). They have a higher priority over the settings in config files.",
    "Notification Detail": "Notification Detail",
    "Notifications": "Notifications",
    "Notifications of file changes": "Notifications of file changes",
    "Number": "Number",
    "Number of days ago": "Number of days ago",
    "Number of days from now": "Number of days from now",
    "Number of days that keep user sign in.": "Number of days that keep user sign in.",
    "Number of groups": "Number of groups",
    "Number of links": "Number of links",
    "Number of members": "Number of members",
    "Off": "Off",
    "Old Password": "Old Password",
    "Old Wikis": "Old Wikis",
    "On": "On",
    "One month ago": "One month ago",
    "One month from now": "One month from now",
    "One week ago": "One week ago",
    "One week from now": "One week from now",
    "Online Preview": "Online Preview",
    "Online Read-Only": "Online Read-Only",
    "Online Read-Only folder": "Online Read-Only folder",
    "Online Read-Only library": "Online Read-Only library",
    "Online Read-Write": "Online Read-Write",
    "Online Read-Write folder": "Online Read-Write folder",
    "Online Read-Write library": "Online Read-Write library",
    "Online view is not applicable to this file format": "Online view is not applicable to this file format",
    "Only Show": "Only Show",
    "Only files": "Only files",
    "Only folders": "Only folders",
    "Only keep a period of history:": "Only keep a period of history:",
    "Only pictures": "Only pictures",
    "Only videos": "Only videos",
    "Open file": "Open file",
    "Open file in new tab": "Open file in new tab",
    "Open folder": "Open folder",
    "Open folder in new tab": "Open folder in new tab",
    "Open in new tab": "Open in new tab",
    "Open parent folder": "Open parent folder",
    "Open via Client": "Open via Client",
    "Operation": "Operation",
    "Operation succeeded.": "Operation succeeded.",
    "Operations": "Operations",
    "Optional": "Optional",
    "Options imported": "Options imported",
    "Or": "Or",
    "Organization": "Organization",
    "Organization Admin": "Organization Admin",
    "Organizations": "Organizations",
    "Original path": "Original path",
    "Other": "Other",
    "Others": "Others",
    "Out of quota.": "Out of quota.",
    "Outdated": "Outdated",
    "Owned Libraries": "Owned Libraries",
    "Owner": "Owner",
    "Owner can use admin panel in an organization, must be a new account.": "Owner can use admin panel in an organization, must be a new account.",
    "Packaging...": "Packaging...",
    "Page name": "Page name",
    "Parent folder": "Parent folder",
    "Password": "Password",
    "Password again": "Password again",
    "Password cannot be blank": "Password cannot be blank",
    "Password is too short": "Password is too short",
    "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols": "Password must be at least 8 characters long and contain different characters: uppercase letters, lowercase letters, numbers, and special symbols",
    "Password removed": "Password removed",
    "Password reset": "Password reset",
    "Password set": "Password set",
    "Password strength": "Password strength",
    "Password updated": "Password updated",
    "Passwords do not match.": "Passwords do not match.",
    "Passwords don't match": "Passwords don't match",
    "Path": "Path",
    "Per 4 hours": "Per 4 hours",
    "Per day": "Per day",
    "Per hour": "Per hour",
    "Per week": "Per week",
    "Permission": "Permission",
    "Permission denied": "Permission denied",
    "Permission denied. Please try {placeholder-left}login again.{placeholder-right}": "Permission denied. Please try {placeholder-left}login again.{placeholder-right}",
    "Permission name": "Permission name",
    "Person image": "Person image",
    "Picture": "Picture",
    "Pictures and videos": "Pictures and videos",
    "Platform": "Platform",
    "Please check the network.": "Please check the network.",
    "Please choose a .sdoczip file.": "Please choose a .sdoczip file.",
    "Please choose a .xlsx file.": "Please choose a .xlsx file.",
    "Please choose an image file.": "Please choose an image file.",
    "Please enter 1 or more character": "Please enter 1 or more character",
    "Please enter a new password": "Please enter a new password",
    "Please enter a non-negative integer": "Please enter a non-negative integer",
    "Please enter a password.": "Please enter a password.",
    "Please enter a positive integer": "Please enter a positive integer",
    "Please enter an integer bigger than 1 as number of links.": "Please enter an integer bigger than 1 as number of links.",
    "Please enter an integer not bigger than {max_number} as number of links.": "Please enter an integer not bigger than {max_number} as number of links.",
    "Please enter days": "Please enter days",
    "Please enter password": "Please enter password",
    "Please enter the new password again": "Please enter the new password again",
    "Please enter the old password": "Please enter the old password",
    "Please enter the password again": "Please enter the password again",
    "Please input at least an email.": "Please input at least an email.",
    "Please select a file": "Please select a file",
    "Please select a library to share.": "Please select a library to share.",
    "Please select an expiration time": "Please select an expiration time",
    "Please upload no more than {maxFiles} files at a time.": "Please upload no more than {maxFiles} files at a time.",
    "Preset hide properties": "Preset hide properties",
    "Preview and download": "Preview and download",
    "Preview online": "Preview online",
    "Preview only": "Preview only",
    "Previous": "Previous",
    "Print": "Print",
    "Professional Edition": "Professional Edition",
    "Profile": "Profile",
    "Profile Setting": "Profile Setting",
    "Properties": "Properties",
    "Property name": "Property name",
    "Publish": "Publish",
    "Publish Wiki": "Publish Wiki",
    "Quota": "Quota",
    "Quota is invalid.": "Quota is invalid.",
    "Rate": "Rate",
    "Read-Only": "Read-Only",
    "Read-Only folder": "Read-Only folder",
    "Read-Only library": "Read-Only library",
    "Read-Write": "Read-Write",
    "Read-Write folder": "Read-Write folder",
    "Read-Write library": "Read-Write library",
    "Really want to delete this group?": "Really want to delete this group?",
    "Really want to delete your account?": "Really want to delete your account?",
    "Really want to leave this group?": "Really want to leave this group?",
    "Recognizing portraits. Please refresh the page later.": "Recognizing portraits. Please refresh the page later.",
    "Refresh": "Refresh",
    "Remove": "Remove",
    "Rename": "Rename",
    "Rename Department": "Rename Department",
    "Rename File": "Rename File",
    "Rename Folder": "Rename Folder",
    "Rename Group": "Rename Group",
    "Rename Wiki": "Rename Wiki",
    "Rename file": "Rename file",
    "Rename folder": "Rename folder",
    "Rename group to": "Rename group to",
    "Rename property": "Rename property",
    "Renamed file": "Renamed file",
    "Renamed folder": "Renamed folder",
    "Renamed library": "Renamed library",
    "Renamed or Moved files": "Renamed or Moved files",
    "Renaming {name} failed": "Renaming {name} failed",
    "Replace": "Replace",
    "Replace file {filename}?": "Replace file {filename}?",
    "Replacing it will overwrite its content.": "Replacing it will overwrite its content.",
    "Report Abuse": "Report Abuse",
    "Reporter": "Reporter",
    "Reports": "Reports",
    "Required at least three letters.": "Required at least three letters.",
    "Reset": "Reset",
    "Reset Password": "Reset Password",
    "Reset WebDAV Password": "Reset WebDAV Password",
    "Reset library password": "Reset library password",
    "Resetting user's password, please wait for a moment.": "Resetting user's password, please wait for a moment.",
    "Restore": "Restore",
    "Restore Library": "Restore Library",
    "Restored file": "Restored file",
    "Restored folder": "Restored folder",
    "Restored library": "Restored library",
    "Restored {name}": "Restored {name}",
    "Restored {name} and {n} other items": "Restored {name} and {n} other items",
    "Result": "Result",
    "Revoke Access": "Revoke Access",
    "Revoke Admin": "Revoke Admin",
    "Role": "Role",
    "SAML config": "SAML config",
    "SAML config updated": "SAML config updated",
    "Save": "Save",
    "Save Selected Items": "Save Selected Items",
    "Save to:": "Save to:",
    "Saving...": "Saving...",
    "Scan the QR code to view the shared content directly": "Scan the QR code to view the shared content directly",
    "SeaTable integration": "SeaTable integration",
    "Seafile": "Seafile",
    "Search": "Search",
    "Search Groups": "Search Groups",
    "Search Libraries": "Search Libraries",
    "Search Organizations": "Search Organizations",
    "Search Users": "Search Users",
    "Search collaborator": "Search collaborator",
    "Search collaborators": "Search collaborators",
    "Search files": "Search files",
    "Search files in this library": "Search files in this library",
    "Search groups": "Search groups",
    "Search groups by name": "Search groups by name",
    "Search libraries by name or ID": "Search libraries by name or ID",
    "Search libraries by owner": "Search libraries by owner",
    "Search option": "Search option",
    "Search organizations": "Search organizations",
    "Search property": "Search property",
    "Search users": "Search users",
    "Select File": "Select File",
    "Select a department": "Select a department",
    "Select a user": "Select a user",
    "Select a user as admin": "Select a user as admin",
    "Select all": "Select all",
    "Select an option": "Select an option",
    "Select collaborators": "Select collaborators",
    "Select libraries to share": "Select libraries to share",
    "Select option(s)": "Select option(s)",
    "Select up to 50 files": "Select up to 50 files",
    "Send": "Send",
    "Send activation Email after user registration.": "Send activation Email after user registration.",
    "Send to:": "Send to:",
    "Sending new password...": "Sending new password...",
    "Sending...": "Sending...",
    "Server Version: ": "Server Version: ",
    "Set Admin": "Set Admin",
    "Set Contact Email": "Set Contact Email",
    "Set Download Rate Limit": "Set Download Rate Limit",
    "Set Login ID": "Set Login ID",
    "Set Name": "Set Name",
    "Set Password": "Set Password",
    "Set Quota": "Set Quota",
    "Set Upload Rate Limit": "Set Upload Rate Limit",
    "Set WebDAV Password": "Set WebDAV Password",
    "Set max number of members": "Set max number of members",
    "Set password": "Set password",
    "Set permission of {placeholder}": "Set permission of {placeholder}",
    "Set to current": "Set to current",
    "Set user contact email": "Set user contact email",
    "Set user default quota": "Set user default quota",
    "Set user name": "Set user name",
    "Set user quota": "Set user quota",
    "Setting library history is disabled by Admin.": "Setting library history is disabled by Admin.",
    "Settings": "Settings",
    "Share": "Share",
    "Share Admin": "Share Admin",
    "Share From": "Share From",
    "Share Link": "Share Link",
    "Share Links": "Share Links",
    "Share To": "Share To",
    "Share To:": "Share To:",
    "Share link download": "Share link download",
    "Share link is copied to the clipboard.": "Share link is copied to the clipboard.",
    "Share link upload": "Share link upload",
    "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.": "Share links cannot be generated because \"Invisible\", \"Online Read-Write\" or \"Online Read-Only\" is set for you on some folder(s) in the library.",
    "Share to group": "Share to group",
    "Share to other server": "Share to other server",
    "Share to user": "Share to user",
    "Shared By": "Shared By",
    "Shared Libraries": "Shared Libraries",
    "Shared Links": "Shared Links",
    "Shared with me": "Shared with me",
    "Show": "Show",
    "Show all": "Show all",
    "Show changes": "Show changes",
    "Side Nav Menu": "Side Nav Menu",
    "Single select": "Single select",
    "Site name used in email sending": "Site name used in email sending",
    "Site title shown in a browser tab": "Site title shown in a browser tab",
    "Size": "Size",
    "Sort": "Sort",
    "Sort ascending": "Sort ascending",
    "Sort descending": "Sort descending",
    "Space Used": "Space Used",
    "Space Used / Quota": "Space Used / Quota",
    "Specific people with email address": "Specific people with email address",
    "Specific users in the team": "Specific users in the team",
    "Star": "Star",
    "Start date": "Start date",
    "Status": "Status",
    "Status: enabled": "Status: enabled",
    "Storage": "Storage",
    "Storage Backend": "Storage Backend",
    "Storage Used": "Storage Used",
    "Style": "Style",
    "Submit": "Submit",
    "Success": "Success",
    "Successfully added label(s) for library {placeholder}": "Successfully added label(s) for library {placeholder}",
    "Successfully change the group": "Successfully change the group",
    "Successfully changed library password.": "Successfully changed library password.",
    "Successfully cleared trash.": "Successfully cleared trash.",
    "Successfully converted the file.": "Successfully converted the file.",
    "Successfully copied %(name)s and %(amount)s other items.": "Successfully copied %(name)s and %(amount)s other items.",
    "Successfully copied %(name)s and 1 other item.": "Successfully copied %(name)s and 1 other item.",
    "Successfully copied %(name)s.": "Successfully copied %(name)s.",
    "Successfully copied files to another library.": "Successfully copied files to another library.",
    "Successfully deleted 1 item.": "Successfully deleted 1 item.",
    "Successfully deleted 1 share link": "Successfully deleted 1 share link",
    "Successfully deleted 1 user.": "Successfully deleted 1 user.",
    "Successfully deleted {name}": "Successfully deleted {name}",
    "Successfully deleted {name} and {n} other items": "Successfully deleted {name} and {n} other items",
    "Successfully deleted {name} and {n} other items.": "Successfully deleted {name} and {n} other items.",
    "Successfully deleted {name}.": "Successfully deleted {name}.",
    "Successfully deleted {number_placeholder} share links": "Successfully deleted {number_placeholder} share links",
    "Successfully deleted {user_number_placeholder} users.": "Successfully deleted {user_number_placeholder} users.",
    "Successfully edited labels.": "Successfully edited labels.",
    "Successfully invited %(email) and %(num) other people.": "Successfully invited %(email) and %(num) other people.",
    "Successfully invited %(email).": "Successfully invited %(email).",
    "Successfully moved %(name)s and %(amount)s other items.": "Successfully moved %(name)s and %(amount)s other items.",
    "Successfully moved %(name)s and 1 other item.": "Successfully moved %(name)s and 1 other item.",
    "Successfully moved %(name)s.": "Successfully moved %(name)s.",
    "Successfully moved files to another library.": "Successfully moved files to another library.",
    "Successfully moved {name}.": "Successfully moved {name}.",
    "Successfully restored the library {library_name}.": "Successfully restored the library {library_name}.",
    "Successfully restored the library.": "Successfully restored the library.",
    "Successfully restored.": "Successfully restored.",
    "Successfully revoke the admin permission of %s": "Successfully revoke the admin permission of %s",
    "Successfully revoked access of user {placeholder}.": "Successfully revoked access of user {placeholder}.",
    "Successfully revoked the admin permission of {placeholder}.": "Successfully revoked the admin permission of {placeholder}.",
    "Successfully saved": "Successfully saved",
    "Successfully sent to {placeholder}": "Successfully sent to {placeholder}",
    "Successfully set %s as admin.": "Successfully set %s as admin.",
    "Successfully set it.": "Successfully set it.",
    "Successfully set library history.": "Successfully set library history.",
    "Successfully starred {library_name_placeholder}.": "Successfully starred {library_name_placeholder}.",
    "Successfully transferred the group.": "Successfully transferred the group.",
    "Successfully transferred the library.": "Successfully transferred the library.",
    "Successfully unlinked the device.": "Successfully unlinked the device.",
    "Successfully unshared {name}": "Successfully unshared {name}",
    "Successfully unstarred {library_name_placeholder}.": "Successfully unstarred {library_name_placeholder}.",
    "Suggestion": "Suggestion",
    "Switch sort mode": "Switch sort mode",
    "Switch to plain text editor": "Switch to plain text editor",
    "Switch to rich text editor": "Switch to rich text editor",
    "Switch view mode": "Switch view mode",
    "Sync": "Sync",
    "Sync Download": "Sync Download",
    "Sync Upload": "Sync Upload",
    "System": "System",
    "System Admin": "System Admin",
    "System Info": "System Info",
    "System settings updated": "System settings updated",
    "Table": "Table",
    "Tag not found": "Tag not found",
    "Tagged Files": "Tagged Files",
    "Tags": "Tags",
    "Team name": "Team name",
    "Template": "Template",
    "Terms": "Terms",
    "Terms and Conditions": "Terms and Conditions",
    "Text": "Text",
    "Text is required.": "Text is required.",
    "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved": "The content of the document has exceeded the limit of 100000 characters, and only the first 100000 characters are saved",
    "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved": "The content of the document has exceeded the limit of 100000 characters, and the content cannot be saved",
    "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.": "The custom part of the URL must be between 5 and 30 characters long and may only contain letters (a-z), numbers, and hyphens.",
    "The file is too large. Allowed maximum size is 1MB.": "The file is too large. Allowed maximum size is 1MB.",
    "The imported options are invalid": "The imported options are invalid",
    "The least number of characters a share/upload link password should include.": "The least number of characters a share/upload link password should include.",
    "The least number of characters an encrypted library password should include.": "The least number of characters an encrypted library password should include.",
    "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols": "The level(1-4) of a share/upload link password's strength. For example, '3' means password must have at least 3 of the following: num, upper letter, lower letter and other symbols",
    "The link is copied to the clipboard.": "The link is copied to the clipboard.",
    "The list of added, deleted and modified files will be sent to your mailbox.": "The list of added, deleted and modified files will be sent to your mailbox.",
    "The maximum number of failed login attempts before showing CAPTCHA.": "The maximum number of failed login attempts before showing CAPTCHA.",
    "The name \"{name}\" is already taken. Please choose a different name.": "The name \"{name}\" is already taken. Please choose a different name.",
    "The next month": "The next month",
    "The next numbers of days": "The next numbers of days",
    "The next week": "The next week",
    "The next year": "The next year",
    "The password is too short.": "The password is too short.",
    "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.": "The password is too weak. It should include at least {passwordStrengthLevel} of the following: number, upper letter, lower letter and other symbols.",
    "The past month": "The past month",
    "The past numbers of days": "The past numbers of days",
    "The past week": "The past week",
    "The past year": "The past year",
    "There is another option with this name": "There is another option with this name",
    "There is another property with this name": "There is another property with this name",
    "There is no information to display.": "There is no information to display.",
    "This file has been updated.": "This file has been updated.",
    "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).": "This folder has been shared to {user_amount} user(s) and {group_amount} group(s).",
    "This folder has no content at this time.": "This folder has no content at this time.",
    "This is a special group representing a department.": "This is a special group representing a department.",
    "This is required": "This is required",
    "This library has been set to read-only by admin and cannot be updated.": "This library has been set to read-only by admin and cannot be updated.",
    "This library has been shared to {user_amount} user(s) and {group_amount} group(s).": "This library has been shared to {user_amount} user(s) and {group_amount} group(s).",
    "This month": "This month",
    "This operation will not be reverted. Please think twice!": "This operation will not be reverted. Please think twice!",
    "This property can not be deleted": "This property can not be deleted",
    "This property does not support sorting": "This property does not support sorting",
    "This property is not editable": "This property is not editable",
    "This user has not created or joined any groups": "This user has not created or joined any groups",
    "This week": "This week",
    "This year": "This year",
    "Thumbnail": "Thumbnail",
    "Time": "Time",
    "Tip: -2 means no limit.": "Tip: -2 means no limit.",
    "Tip: 0 means default limit": "Tip: 0 means default limit",
    "Tip: a snapshot will be generated after modification, which records the library state after the modification.": "Tip: a snapshot will be generated after modification, which records the library state after the modification.",
    "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.": "Tip: libraries deleted {placeholder} days ago will be cleaned automatically.",
    "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.": "Tip: libraries deleted {trashReposExpireDays} days ago will be cleaned automatically.",
    "Tip: you can search by keyword in name or ID.": "Tip: you can search by keyword in name or ID.",
    "Tip: you can search by keyword in name.": "Tip: you can search by keyword in name.",
    "Today": "Today",
    "Token": "Token",
    "Token:": "Token:",
    "Tomorrow": "Tomorrow",
    "Too many requests": "Too many requests",
    "Total Devices": "Total Devices",
    "Total Storage": "Total Storage",
    "Total Users": "Total Users",
    "Traffic": "Traffic",
    "Transfer": "Transfer",
    "Transfer Group": "Transfer Group",
    "Transfer Group {placeholder} to": "Transfer Group {placeholder} to",
    "Transfer Library": "Transfer Library",
    "Transfer Library {library_name}": "Transfer Library {library_name}",
    "Transfer group to": "Transfer group to",
    "Transfer to department": "Transfer to department",
    "Transfer to user": "Transfer to user",
    "Transferred group {group_name} from {user_from} to {user_to}": "Transferred group {group_name} from {user_from} to {user_to}",
    "Transferred library {library_name} from {user_from} to {user_to}": "Transferred library {library_name} from {user_from} to {user_to}",
    "Trash": "Trash",
    "Turn off": "Turn off",
    "Turn off extended properties": "Turn off extended properties",
    "Turn on extensible properties and views to experience a new way of managing files": "Turn on extensible properties and views to experience a new way of managing files",
    "Two-Factor Authentication": "Two-Factor Authentication",
    "Type": "Type",
    "Type characters to start search": "Type characters to start search",
    "URL is copied to the clipboard": "URL is copied to the clipboard",
    "URL is required": "URL is required",
    "US": "US",
    "Undo": "Undo",
    "Unfreeze Document": "Unfreeze Document",
    "Unhandled": "Unhandled",
    "Unlink": "Unlink",
    "Unlink device": "Unlink device",
    "Unlock": "Unlock",
    "Unselect": "Unselect",
    "Unshare": "Unshare",
    "Unstar": "Unstar",
    "Untitled": "Untitled",
    "Unwatch File Changes": "Unwatch File Changes",
    "Up": "Up",
    "Update": "Update",
    "Update Terms and Conditions": "Update Terms and Conditions",
    "Update password": "Update password",
    "Update succeeded.": "Update succeeded.",
    "Updated draft": "Updated draft",
    "Updated file": "Updated file",
    "Upgrade to Pro Edition": "Upgrade to Pro Edition",
    "Upload": "Upload",
    "Upload Files": "Upload Files",
    "Upload Folder": "Upload Folder",
    "Upload Link": "Upload Link",
    "Upload Links": "Upload Links",
    "Upload license": "Upload license",
    "Upload link is copied to the clipboard.": "Upload link is copied to the clipboard.",
    "Uploading...": "Uploading...",
    "Use custom CSS": "Use custom CSS",
    "Use information from your Identity Provider to configure Seafile": "Use information from your Identity Provider to configure Seafile",
    "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.": "Use the import/export function to transfer options quickly. (The export is in JSON format.) By pasting cells, copied from a text column, an Excel or a TXT file, you can also add options quickly.",
    "Use these values to configure your Identity Provider": "Use these values to configure your Identity Provider",
    "User": "User",
    "User Permission": "User Permission",
    "User Shares": "User Shares",
    "User Storage": "User Storage",
    "User can not see this folder.": "User can not see this folder.",
    "User can only view files online via browser. Files can't be downloaded.": "User can only view files online via browser. Files can't be downloaded.",
    "User can read, download and sync files.": "User can read, download and sync files.",
    "User can read, write, upload, download and sync files.": "User can read, write, upload, download and sync files.",
    "User can view and edit file online via browser. Files can't be downloaded.": "User can view and edit file online via browser. Files can't be downloaded.",
    "User info updated": "User info updated",
    "User migrate from {user_from} to {user_to}": "User migrate from {user_from} to {user_to}",
    "User not found": "User not found",
    "User {user_link} has added you to {group_link}": "User {user_link} has added you to {group_link}",
    "Username:": "Username:",
    "Users": "Users",
    "Verified": "Verified",
    "Verify": "Verify",
    "Verify Domain": "Verify Domain",
    "Version": "Version",
    "Version Number": "Version Number",
    "Version Number is required.": "Version Number is required.",
    "Version Number must be a number.": "Version Number must be a number.",
    "Video": "Video",
    "View": "View",
    "View Link": "View Link",
    "View Related Snapshot": "View Related Snapshot",
    "View profile and more": "View profile and more",
    "Views": "Views",
    "Virus": "Virus",
    "Virus File": "Virus File",
    "Visit count": "Visit count",
    "Visit old version page": "Visit old version page",
    "Visited": "Visited",
    "Visits": "Visits",
    "Watch File Changes": "Watch File Changes",
    "Web API Auth Token": "Web API Auth Token",
    "Web Download": "Web Download",
    "Web Upload": "Web Upload",
    "WebDAV Access": "WebDAV Access",
    "WebDAV password:": "WebDAV password:",
    "WebDAV username:": "WebDAV username:",
    "Wiki custom URL deleted": "Wiki custom URL deleted",
    "Wiki owner": "Wiki owner",
    "Wiki published": "Wiki published",
    "Wikis": "Wikis",
    "Year": "Year",
    "Yesterday": "Yesterday",
    "You can also add a user as a guest, who will not be allowed to create libraries and groups.": "You can also add a user as a guest, who will not be allowed to create libraries and groups.",
    "You can create files quickly": "You can create files quickly",
    "You can enter multiple emails. An invitation link will be sent to each of them.": "You can enter multiple emails. An invitation link will be sent to each of them.",
    "You can use this field at login.": "You can use this field at login.",
    "You do not have permission": "You do not have permission",
    "You don't have any favorite items yet": "You don't have any favorite items yet",
    "You don't have any share links": "You don't have any share links",
    "You don't have any upload links": "You don't have any upload links",
    "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.": "You have not accessed your files with any client (desktop or mobile) yet. Configure clients on your devices to access your data more comfortably.",
    "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.": "You have not added any libraries, folders or files to your favorites yet. A favorite gives you quick access to your most frequently used objects. You can add a library, folder or file to your favorites by clicking the star to the left of its name.",
    "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.": "You have not created any share links yet. A share link can be used to share files and folders with anyone. You can create a share link for a file or folder by clicking the share icon to the right of its name.",
    "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.": "You have not created any upload links yet. An upload link allows anyone to upload files to a folder or library. You can create an upload link for a folder or library by clicking the share icon to the right of its name.",
    "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.": "You have not deleted any libraries in the last {placeholder} days. A deleted library will be cleaned automatically after this period.",
    "You have not shared any folders": "You have not shared any folders",
    "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.": "You have not shared any folders with other users yet. You can share a folder with other users by clicking the share icon to the right of a folder's name.",
    "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".": "You have not shared any libraries with other users yet. You can share a library with other users by clicking the share icon to the right of a library's name in \"My Libraries\".",
    "Your notifications will be sent to this email.": "Your notifications will be sent to this email.",
    "all": "all",
    "contains": "contains",
    "days": "days",
    "deleted": "deleted",
    "deleted option": "deleted option",
    "details": "details",
    "does not contain": "does not contain",
    "email is required": "email is required",
    "freezed": "freezed",
    "has all of...": "has all of...",
    "has any of...": "has any of...",
    "has none of...": "has none of...",
    "icon": "icon",
    "in all libraries": "in all libraries",
    "include the current user": "include the current user",
    "is": "is",
    "is after...": "is after...",
    "is any of...": "is any of...",
    "is before...": "is before...",
    "is current user's ID": "is current user's ID",
    "is empty": "is empty",
    "is exactly...": "is exactly...",
    "is none of...": "is none of...",
    "is not": "is not",
    "is not empty": "is not empty",
    "is on or after...": "is on or after...",
    "is on or before...": "is on or before...",
    "is within...": "is within...",
    "items": "items",
    "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}": "licensed to {placeholder_license_to}, expires on {placeholder_license_expiration}",
    "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}": "licensed to {placeholder_license_to}, upgrade service expired in {placeholder_license_expiration}",
    "locked": "locked",
    "locked by {name}": "locked by {name}",
    "mm": "mm",
    "not set": "not set",
    "only show {placeholder}": "only show {placeholder}",
    "s": "s",
    "selected": "selected",
    "show more": "show more",
    "sorts": "sorts",
    "starred": "starred",
    "successfully added user %s.": "successfully added user %s.",
    "successfully sent email to %s.": "successfully sent email to %s.",
    "unstarred": "unstarred",
    "xxx cells copied": "xxx cells copied",
    "xxx cells selected": "xxx cells selected",
    "xxx record": "xxx record",
    "xxx records": "xxx records",
    "xxx records selected": "xxx records selected",
    "xxx rows are copied.": "xxx rows are copied.",
    "{failed_files_num} file(s) failed to upload": "{failed_files_num} file(s) failed to upload",
    "{file} and {n} other files": "{file} and {n} other files",
    "{minDays_placeholder} - {maxDays_placeholder} days": "{minDays_placeholder} - {maxDays_placeholder} days",
    "{number_placeholder} / Page": "{number_placeholder} / Page",
    "{placeholder} Access Log": "{placeholder} Access Log",
    "{placeholder} Folder Permission": "{placeholder} Folder Permission",
    "{placeholder} History Setting": "{placeholder} History Setting",
    "{placeholder} Modification History": "{placeholder} Modification History",
    "{placeholder} Share Admin": "{placeholder} Share Admin",
    "{placeholder} Snapshot": "{placeholder} Snapshot",
    "{placeholder} Trash": "{placeholder} Trash",
    "{placeholder} Wiki Trash": "{placeholder} Wiki Trash",
    "{share_from} has cancelled the sharing of folder {repo_name}.": "{share_from} has cancelled the sharing of folder {repo_name}.",
    "{share_from} has cancelled the sharing of library {repo_name}.": "{share_from} has cancelled the sharing of library {repo_name}.",
    "{share_from} has changed the permission of folder {repo_link} to {permission}.": "{share_from} has changed the permission of folder {repo_link} to {permission}.",
    "{share_from} has changed the permission of library {repo_link} to {permission}.": "{share_from} has changed the permission of library {repo_link} to {permission}.",
    "{share_from} has shared a folder named {repo_link} to group {group_link}.": "{share_from} has shared a folder named {repo_link} to group {group_link}.",
    "{share_from} has shared a folder named {repo_link} to you.": "{share_from} has shared a folder named {repo_link} to you.",
    "{share_from} has shared a library named {repo_link} to group {group_link}.": "{share_from} has shared a library named {repo_link} to group {group_link}.",
    "{share_from} has shared a library named {repo_link} to you.": "{share_from} has shared a library named {repo_link} to you.",
    "{uploaded_files_num}/{all_files_num} Files": "{uploaded_files_num}/{all_files_num} Files",
    "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.": "{userCount} user(s) and {repoCount} libraries of this organization will also be deleted.",
    "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} created file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} created file {fileName} in library {libraryName}.": "{user} created file {fileName} in library {libraryName}.",
    "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} created folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} created folder {folderName} in library {libraryName}.": "{user} created folder {folderName} in library {libraryName}.",
    "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} deleted file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} deleted file {fileName} in library {libraryName}.": "{user} deleted file {fileName} in library {libraryName}.",
    "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} deleted folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} deleted folder {folderName} in library {libraryName}.": "{user} deleted folder {folderName} in library {libraryName}.",
    "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.": "{user} moved file {fileName} and {fileCount} other file(s) in library {libraryName}.",
    "{user} moved file {fileName} in library {libraryName}.": "{user} moved file {fileName} in library {libraryName}.",
    "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.": "{user} moved folder {folderName} and {folderCount} other folder(s) in library {libraryName}.",
    "{user} moved folder {folderName} in library {libraryName}.": "{user} moved folder {folderName} in library {libraryName}.",
    "{user} renamed file {oldFileName} {fileName} in library {libraryName}.": "{user} renamed file {oldFileName} {fileName} in library {libraryName}.",
    "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.": "{user} renamed folder {oldFolderName} {folderName} in library {libraryName}.",
    "{user} restored file {fileName} in library {libraryName}.": "{user} restored file {fileName} in library {libraryName}.",
    "{user} restored folder {folderName} in library {libraryName}.": "{user} restored folder {folderName} in library {libraryName}.",
    "{user} updated file {fileName} in library {libraryName}.": "{user} updated file {fileName} in library {libraryName}."
  };
  for (const key in newcatalog) {
    django.catalog[key] = newcatalog[key];
  }
  

  if (!django.jsi18n_initialized) {
    django.gettext = function(msgid) {
      const value = django.catalog[msgid];
      if (typeof value === 'undefined') {
        return msgid;
      } else {
        return (typeof value === 'string') ? value : value[0];
      }
    };

    django.ngettext = function(singular, plural, count) {
      const value = django.catalog[singular];
      if (typeof value === 'undefined') {
        return (count == 1) ? singular : plural;
      } else {
        return value.constructor === Array ? value[django.pluralidx(count)] : value;
      }
    };

    django.gettext_noop = function(msgid) { return msgid; };

    django.pgettext = function(context, msgid) {
      let value = django.gettext(context + '\x04' + msgid);
      if (value.includes('\x04')) {
        value = msgid;
      }
      return value;
    };

    django.npgettext = function(context, singular, plural, count) {
      let value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
      if (value.includes('\x04')) {
        value = django.ngettext(singular, plural, count);
      }
      return value;
    };

    django.interpolate = function(fmt, obj, named) {
      if (named) {
        return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
      } else {
        return fmt.replace(/%s/g, function(match){return String(obj.shift())});
      }
    };


    /* formatting library */

    django.formats = {
    "DATETIME_FORMAT": "N j, Y, P",
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S",
      "%Y-%m-%d %H:%M:%S.%f",
      "%Y-%m-%d %H:%M",
      "%m/%d/%Y %H:%M:%S",
      "%m/%d/%Y %H:%M:%S.%f",
      "%m/%d/%Y %H:%M",
      "%m/%d/%y %H:%M:%S",
      "%m/%d/%y %H:%M:%S.%f",
      "%m/%d/%y %H:%M",
      "%Y-%m-%d"
    ],
    "DATE_FORMAT": "N j, Y",
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d",
      "%m/%d/%Y",
      "%m/%d/%y",
      "%b %d %Y",
      "%b %d, %Y",
      "%d %b %Y",
      "%d %b, %Y",
      "%B %d %Y",
      "%B %d, %Y",
      "%d %B %Y",
      "%d %B, %Y"
    ],
    "DECIMAL_SEPARATOR": ".",
    "FIRST_DAY_OF_WEEK": 0,
    "MONTH_DAY_FORMAT": "F j",
    "NUMBER_GROUPING": 3,
    "SHORT_DATETIME_FORMAT": "m/d/Y P",
    "SHORT_DATE_FORMAT": "m/d/Y",
    "THOUSAND_SEPARATOR": ",",
    "TIME_FORMAT": "P",
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S",
      "%H:%M:%S.%f",
      "%H:%M"
    ],
    "YEAR_MONTH_FORMAT": "F Y"
  };

    django.get_format = function(format_type) {
      const value = django.formats[format_type];
      if (typeof value === 'undefined') {
        return format_type;
      } else {
        return value;
      }
    };

    /* add to global namespace */
    globals.pluralidx = django.pluralidx;
    globals.gettext = django.gettext;
    globals.ngettext = django.ngettext;
    globals.gettext_noop = django.gettext_noop;
    globals.pgettext = django.pgettext;
    globals.npgettext = django.npgettext;
    globals.interpolate = django.interpolate;
    globals.get_format = django.get_format;

    django.jsi18n_initialized = true;
  }
};

