#include "sysdeps.h"
#include "m68k.h"
#include "memory.h"
#include "readcpu.h"
#include "newcpu.h"
#include "compiler/compemu.h"
#include "fpu/fpu.h"
#include "cputbl.h"
#define SET_CFLG_ALWAYS(x) SET_CFLG(x)
#define SET_NFLG_ALWAYS(x) SET_NFLG(x)
#define CPUFUNC_FF(x) x##_ff
#define CPUFUNC_NF(x) x##_nf
#define CPUFUNC(x) CPUFUNC_FF(x)
#ifdef NOFLAGS
# include "noflags.h"
#endif
struct cputbl CPUFUNC(op_smalltbl_0)[] = {
{ CPUFUNC(op_0_0), 0, 0 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_10_0), 0, 16 }, /* OR.B #<data>.B,(An) */
{ CPUFUNC(op_18_0), 0, 24 }, /* OR.B #<data>.B,(An)+ */
{ CPUFUNC(op_20_0), 0, 32 }, /* OR.B #<data>.B,-(An) */
{ CPUFUNC(op_28_0), 0, 40 }, /* OR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_30_0), 0, 48 }, /* OR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_38_0), 0, 56 }, /* OR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_39_0), 0, 57 }, /* OR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_3c_0), 0, 60 }, /* ORSR.B #<data>.W */
{ CPUFUNC(op_40_0), 0, 64 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_50_0), 0, 80 }, /* OR.W #<data>.W,(An) */
{ CPUFUNC(op_58_0), 0, 88 }, /* OR.W #<data>.W,(An)+ */
{ CPUFUNC(op_60_0), 0, 96 }, /* OR.W #<data>.W,-(An) */
{ CPUFUNC(op_68_0), 0, 104 }, /* OR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_70_0), 0, 112 }, /* OR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_78_0), 0, 120 }, /* OR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_79_0), 0, 121 }, /* OR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_7c_0), 0, 124 }, /* ORSR.W #<data>.W */
{ CPUFUNC(op_80_0), 0, 128 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_90_0), 0, 144 }, /* OR.L #<data>.L,(An) */
{ CPUFUNC(op_98_0), 0, 152 }, /* OR.L #<data>.L,(An)+ */
{ CPUFUNC(op_a0_0), 0, 160 }, /* OR.L #<data>.L,-(An) */
{ CPUFUNC(op_a8_0), 0, 168 }, /* OR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_b0_0), 0, 176 }, /* OR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_b8_0), 0, 184 }, /* OR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_b9_0), 0, 185 }, /* OR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_d0_0), 0, 208 }, /* CHK2.B #<data>.W,(An) */
{ CPUFUNC(op_e8_0), 0, 232 }, /* CHK2.B #<data>.W,(d16,An) */
{ CPUFUNC(op_f0_0), 0, 240 }, /* CHK2.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_f8_0), 0, 248 }, /* CHK2.B #<data>.W,(xxx).W */
{ CPUFUNC(op_f9_0), 0, 249 }, /* CHK2.B #<data>.W,(xxx).L */
{ CPUFUNC(op_fa_0), 0, 250 }, /* CHK2.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_fb_0), 0, 251 }, /* CHK2.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_100_0), 0, 256 }, /* BTST.L Dn,Dn */
{ CPUFUNC_FF(op_108_0), 0, 264 }, /* MVPMR.W (d16,An),Dn */
{ CPUFUNC(op_110_0), 0, 272 }, /* BTST.B Dn,(An) */
{ CPUFUNC(op_118_0), 0, 280 }, /* BTST.B Dn,(An)+ */
{ CPUFUNC(op_120_0), 0, 288 }, /* BTST.B Dn,-(An) */
{ CPUFUNC(op_128_0), 0, 296 }, /* BTST.B Dn,(d16,An) */
{ CPUFUNC(op_130_0), 0, 304 }, /* BTST.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_138_0), 0, 312 }, /* BTST.B Dn,(xxx).W */
{ CPUFUNC(op_139_0), 0, 313 }, /* BTST.B Dn,(xxx).L */
{ CPUFUNC(op_13a_0), 0, 314 }, /* BTST.B Dn,(d16,PC) */
{ CPUFUNC(op_13b_0), 0, 315 }, /* BTST.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_13c_0), 0, 316 }, /* BTST.B Dn,#<data>.B */
{ CPUFUNC(op_140_0), 0, 320 }, /* BCHG.L Dn,Dn */
{ CPUFUNC_FF(op_148_0), 0, 328 }, /* MVPMR.L (d16,An),Dn */
{ CPUFUNC(op_150_0), 0, 336 }, /* BCHG.B Dn,(An) */
{ CPUFUNC(op_158_0), 0, 344 }, /* BCHG.B Dn,(An)+ */
{ CPUFUNC(op_160_0), 0, 352 }, /* BCHG.B Dn,-(An) */
{ CPUFUNC(op_168_0), 0, 360 }, /* BCHG.B Dn,(d16,An) */
{ CPUFUNC(op_170_0), 0, 368 }, /* BCHG.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_178_0), 0, 376 }, /* BCHG.B Dn,(xxx).W */
{ CPUFUNC(op_179_0), 0, 377 }, /* BCHG.B Dn,(xxx).L */
{ CPUFUNC(op_17a_0), 0, 378 }, /* BCHG.B Dn,(d16,PC) */
{ CPUFUNC(op_17b_0), 0, 379 }, /* BCHG.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_180_0), 0, 384 }, /* BCLR.L Dn,Dn */
{ CPUFUNC_FF(op_188_0), 0, 392 }, /* MVPRM.W Dn,(d16,An) */
{ CPUFUNC(op_190_0), 0, 400 }, /* BCLR.B Dn,(An) */
{ CPUFUNC(op_198_0), 0, 408 }, /* BCLR.B Dn,(An)+ */
{ CPUFUNC(op_1a0_0), 0, 416 }, /* BCLR.B Dn,-(An) */
{ CPUFUNC(op_1a8_0), 0, 424 }, /* BCLR.B Dn,(d16,An) */
{ CPUFUNC(op_1b0_0), 0, 432 }, /* BCLR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1b8_0), 0, 440 }, /* BCLR.B Dn,(xxx).W */
{ CPUFUNC(op_1b9_0), 0, 441 }, /* BCLR.B Dn,(xxx).L */
{ CPUFUNC(op_1ba_0), 0, 442 }, /* BCLR.B Dn,(d16,PC) */
{ CPUFUNC(op_1bb_0), 0, 443 }, /* BCLR.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_1c0_0), 0, 448 }, /* BSET.L Dn,Dn */
{ CPUFUNC_FF(op_1c8_0), 0, 456 }, /* MVPRM.L Dn,(d16,An) */
{ CPUFUNC(op_1d0_0), 0, 464 }, /* BSET.B Dn,(An) */
{ CPUFUNC(op_1d8_0), 0, 472 }, /* BSET.B Dn,(An)+ */
{ CPUFUNC(op_1e0_0), 0, 480 }, /* BSET.B Dn,-(An) */
{ CPUFUNC(op_1e8_0), 0, 488 }, /* BSET.B Dn,(d16,An) */
{ CPUFUNC(op_1f0_0), 0, 496 }, /* BSET.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1f8_0), 0, 504 }, /* BSET.B Dn,(xxx).W */
{ CPUFUNC(op_1f9_0), 0, 505 }, /* BSET.B Dn,(xxx).L */
{ CPUFUNC(op_1fa_0), 0, 506 }, /* BSET.B Dn,(d16,PC) */
{ CPUFUNC(op_1fb_0), 0, 507 }, /* BSET.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_200_0), 0, 512 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_210_0), 0, 528 }, /* AND.B #<data>.B,(An) */
{ CPUFUNC(op_218_0), 0, 536 }, /* AND.B #<data>.B,(An)+ */
{ CPUFUNC(op_220_0), 0, 544 }, /* AND.B #<data>.B,-(An) */
{ CPUFUNC(op_228_0), 0, 552 }, /* AND.B #<data>.B,(d16,An) */
{ CPUFUNC(op_230_0), 0, 560 }, /* AND.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_238_0), 0, 568 }, /* AND.B #<data>.B,(xxx).W */
{ CPUFUNC(op_239_0), 0, 569 }, /* AND.B #<data>.B,(xxx).L */
{ CPUFUNC(op_23c_0), 0, 572 }, /* ANDSR.B #<data>.W */
{ CPUFUNC(op_240_0), 0, 576 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_250_0), 0, 592 }, /* AND.W #<data>.W,(An) */
{ CPUFUNC(op_258_0), 0, 600 }, /* AND.W #<data>.W,(An)+ */
{ CPUFUNC(op_260_0), 0, 608 }, /* AND.W #<data>.W,-(An) */
{ CPUFUNC(op_268_0), 0, 616 }, /* AND.W #<data>.W,(d16,An) */
{ CPUFUNC(op_270_0), 0, 624 }, /* AND.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_278_0), 0, 632 }, /* AND.W #<data>.W,(xxx).W */
{ CPUFUNC(op_279_0), 0, 633 }, /* AND.W #<data>.W,(xxx).L */
{ CPUFUNC(op_27c_0), 0, 636 }, /* ANDSR.W #<data>.W */
{ CPUFUNC(op_280_0), 0, 640 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_290_0), 0, 656 }, /* AND.L #<data>.L,(An) */
{ CPUFUNC(op_298_0), 0, 664 }, /* AND.L #<data>.L,(An)+ */
{ CPUFUNC(op_2a0_0), 0, 672 }, /* AND.L #<data>.L,-(An) */
{ CPUFUNC(op_2a8_0), 0, 680 }, /* AND.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2b0_0), 0, 688 }, /* AND.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_2b8_0), 0, 696 }, /* AND.L #<data>.L,(xxx).W */
{ CPUFUNC(op_2b9_0), 0, 697 }, /* AND.L #<data>.L,(xxx).L */
{ CPUFUNC(op_2d0_0), 0, 720 }, /* CHK2.W #<data>.W,(An) */
{ CPUFUNC(op_2e8_0), 0, 744 }, /* CHK2.W #<data>.W,(d16,An) */
{ CPUFUNC(op_2f0_0), 0, 752 }, /* CHK2.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_2f8_0), 0, 760 }, /* CHK2.W #<data>.W,(xxx).W */
{ CPUFUNC(op_2f9_0), 0, 761 }, /* CHK2.W #<data>.W,(xxx).L */
{ CPUFUNC(op_2fa_0), 0, 762 }, /* CHK2.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_2fb_0), 0, 763 }, /* CHK2.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_400_0), 0, 1024 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_410_0), 0, 1040 }, /* SUB.B #<data>.B,(An) */
{ CPUFUNC(op_418_0), 0, 1048 }, /* SUB.B #<data>.B,(An)+ */
{ CPUFUNC(op_420_0), 0, 1056 }, /* SUB.B #<data>.B,-(An) */
{ CPUFUNC(op_428_0), 0, 1064 }, /* SUB.B #<data>.B,(d16,An) */
{ CPUFUNC(op_430_0), 0, 1072 }, /* SUB.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_438_0), 0, 1080 }, /* SUB.B #<data>.B,(xxx).W */
{ CPUFUNC(op_439_0), 0, 1081 }, /* SUB.B #<data>.B,(xxx).L */
{ CPUFUNC(op_440_0), 0, 1088 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_450_0), 0, 1104 }, /* SUB.W #<data>.W,(An) */
{ CPUFUNC(op_458_0), 0, 1112 }, /* SUB.W #<data>.W,(An)+ */
{ CPUFUNC(op_460_0), 0, 1120 }, /* SUB.W #<data>.W,-(An) */
{ CPUFUNC(op_468_0), 0, 1128 }, /* SUB.W #<data>.W,(d16,An) */
{ CPUFUNC(op_470_0), 0, 1136 }, /* SUB.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_478_0), 0, 1144 }, /* SUB.W #<data>.W,(xxx).W */
{ CPUFUNC(op_479_0), 0, 1145 }, /* SUB.W #<data>.W,(xxx).L */
{ CPUFUNC(op_480_0), 0, 1152 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC(op_490_0), 0, 1168 }, /* SUB.L #<data>.L,(An) */
{ CPUFUNC(op_498_0), 0, 1176 }, /* SUB.L #<data>.L,(An)+ */
{ CPUFUNC(op_4a0_0), 0, 1184 }, /* SUB.L #<data>.L,-(An) */
{ CPUFUNC(op_4a8_0), 0, 1192 }, /* SUB.L #<data>.L,(d16,An) */
{ CPUFUNC(op_4b0_0), 0, 1200 }, /* SUB.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_4b8_0), 0, 1208 }, /* SUB.L #<data>.L,(xxx).W */
{ CPUFUNC(op_4b9_0), 0, 1209 }, /* SUB.L #<data>.L,(xxx).L */
{ CPUFUNC(op_4d0_0), 0, 1232 }, /* CHK2.L #<data>.W,(An) */
{ CPUFUNC(op_4e8_0), 0, 1256 }, /* CHK2.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4f0_0), 0, 1264 }, /* CHK2.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4f8_0), 0, 1272 }, /* CHK2.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4f9_0), 0, 1273 }, /* CHK2.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4fa_0), 0, 1274 }, /* CHK2.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4fb_0), 0, 1275 }, /* CHK2.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_600_0), 0, 1536 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_610_0), 0, 1552 }, /* ADD.B #<data>.B,(An) */
{ CPUFUNC(op_618_0), 0, 1560 }, /* ADD.B #<data>.B,(An)+ */
{ CPUFUNC(op_620_0), 0, 1568 }, /* ADD.B #<data>.B,-(An) */
{ CPUFUNC(op_628_0), 0, 1576 }, /* ADD.B #<data>.B,(d16,An) */
{ CPUFUNC(op_630_0), 0, 1584 }, /* ADD.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_638_0), 0, 1592 }, /* ADD.B #<data>.B,(xxx).W */
{ CPUFUNC(op_639_0), 0, 1593 }, /* ADD.B #<data>.B,(xxx).L */
{ CPUFUNC(op_640_0), 0, 1600 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_650_0), 0, 1616 }, /* ADD.W #<data>.W,(An) */
{ CPUFUNC(op_658_0), 0, 1624 }, /* ADD.W #<data>.W,(An)+ */
{ CPUFUNC(op_660_0), 0, 1632 }, /* ADD.W #<data>.W,-(An) */
{ CPUFUNC(op_668_0), 0, 1640 }, /* ADD.W #<data>.W,(d16,An) */
{ CPUFUNC(op_670_0), 0, 1648 }, /* ADD.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_678_0), 0, 1656 }, /* ADD.W #<data>.W,(xxx).W */
{ CPUFUNC(op_679_0), 0, 1657 }, /* ADD.W #<data>.W,(xxx).L */
{ CPUFUNC(op_680_0), 0, 1664 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC(op_690_0), 0, 1680 }, /* ADD.L #<data>.L,(An) */
{ CPUFUNC(op_698_0), 0, 1688 }, /* ADD.L #<data>.L,(An)+ */
{ CPUFUNC(op_6a0_0), 0, 1696 }, /* ADD.L #<data>.L,-(An) */
{ CPUFUNC(op_6a8_0), 0, 1704 }, /* ADD.L #<data>.L,(d16,An) */
{ CPUFUNC(op_6b0_0), 0, 1712 }, /* ADD.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_6b8_0), 0, 1720 }, /* ADD.L #<data>.L,(xxx).W */
{ CPUFUNC(op_6b9_0), 0, 1721 }, /* ADD.L #<data>.L,(xxx).L */
{ CPUFUNC(op_6c0_0), 0, 1728 }, /* RTM.L Dn */
{ CPUFUNC(op_6c8_0), 0, 1736 }, /* RTM.L An */
{ CPUFUNC_FF(op_6d0_0), 0, 1744 }, /* CALLM.L (An) */
{ CPUFUNC_FF(op_6e8_0), 0, 1768 }, /* CALLM.L (d16,An) */
{ CPUFUNC_FF(op_6f0_0), 0, 1776 }, /* CALLM.L (d8,An,Xn) */
{ CPUFUNC_FF(op_6f8_0), 0, 1784 }, /* CALLM.L (xxx).W */
{ CPUFUNC_FF(op_6f9_0), 0, 1785 }, /* CALLM.L (xxx).L */
{ CPUFUNC_FF(op_6fa_0), 0, 1786 }, /* CALLM.L (d16,PC) */
{ CPUFUNC_FF(op_6fb_0), 0, 1787 }, /* CALLM.L (d8,PC,Xn) */
{ CPUFUNC(op_800_0), 0, 2048 }, /* BTST.L #<data>.W,Dn */
{ CPUFUNC(op_810_0), 0, 2064 }, /* BTST.B #<data>.W,(An) */
{ CPUFUNC(op_818_0), 0, 2072 }, /* BTST.B #<data>.W,(An)+ */
{ CPUFUNC(op_820_0), 0, 2080 }, /* BTST.B #<data>.W,-(An) */
{ CPUFUNC(op_828_0), 0, 2088 }, /* BTST.B #<data>.W,(d16,An) */
{ CPUFUNC(op_830_0), 0, 2096 }, /* BTST.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_838_0), 0, 2104 }, /* BTST.B #<data>.W,(xxx).W */
{ CPUFUNC(op_839_0), 0, 2105 }, /* BTST.B #<data>.W,(xxx).L */
{ CPUFUNC(op_83a_0), 0, 2106 }, /* BTST.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_83b_0), 0, 2107 }, /* BTST.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_83c_0), 0, 2108 }, /* BTST.B #<data>.W,#<data>.B */
{ CPUFUNC(op_840_0), 0, 2112 }, /* BCHG.L #<data>.W,Dn */
{ CPUFUNC(op_850_0), 0, 2128 }, /* BCHG.B #<data>.W,(An) */
{ CPUFUNC(op_858_0), 0, 2136 }, /* BCHG.B #<data>.W,(An)+ */
{ CPUFUNC(op_860_0), 0, 2144 }, /* BCHG.B #<data>.W,-(An) */
{ CPUFUNC(op_868_0), 0, 2152 }, /* BCHG.B #<data>.W,(d16,An) */
{ CPUFUNC(op_870_0), 0, 2160 }, /* BCHG.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_878_0), 0, 2168 }, /* BCHG.B #<data>.W,(xxx).W */
{ CPUFUNC(op_879_0), 0, 2169 }, /* BCHG.B #<data>.W,(xxx).L */
{ CPUFUNC(op_87a_0), 0, 2170 }, /* BCHG.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_87b_0), 0, 2171 }, /* BCHG.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_880_0), 0, 2176 }, /* BCLR.L #<data>.W,Dn */
{ CPUFUNC(op_890_0), 0, 2192 }, /* BCLR.B #<data>.W,(An) */
{ CPUFUNC(op_898_0), 0, 2200 }, /* BCLR.B #<data>.W,(An)+ */
{ CPUFUNC(op_8a0_0), 0, 2208 }, /* BCLR.B #<data>.W,-(An) */
{ CPUFUNC(op_8a8_0), 0, 2216 }, /* BCLR.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8b0_0), 0, 2224 }, /* BCLR.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8b8_0), 0, 2232 }, /* BCLR.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8b9_0), 0, 2233 }, /* BCLR.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8ba_0), 0, 2234 }, /* BCLR.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8bb_0), 0, 2235 }, /* BCLR.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_8c0_0), 0, 2240 }, /* BSET.L #<data>.W,Dn */
{ CPUFUNC(op_8d0_0), 0, 2256 }, /* BSET.B #<data>.W,(An) */
{ CPUFUNC(op_8d8_0), 0, 2264 }, /* BSET.B #<data>.W,(An)+ */
{ CPUFUNC(op_8e0_0), 0, 2272 }, /* BSET.B #<data>.W,-(An) */
{ CPUFUNC(op_8e8_0), 0, 2280 }, /* BSET.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8f0_0), 0, 2288 }, /* BSET.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8f8_0), 0, 2296 }, /* BSET.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8f9_0), 0, 2297 }, /* BSET.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8fa_0), 0, 2298 }, /* BSET.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8fb_0), 0, 2299 }, /* BSET.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_a00_0), 0, 2560 }, /* EOR.B #<data>.B,Dn */
{ CPUFUNC(op_a10_0), 0, 2576 }, /* EOR.B #<data>.B,(An) */
{ CPUFUNC(op_a18_0), 0, 2584 }, /* EOR.B #<data>.B,(An)+ */
{ CPUFUNC(op_a20_0), 0, 2592 }, /* EOR.B #<data>.B,-(An) */
{ CPUFUNC(op_a28_0), 0, 2600 }, /* EOR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_a30_0), 0, 2608 }, /* EOR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_a38_0), 0, 2616 }, /* EOR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_a39_0), 0, 2617 }, /* EOR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_a3c_0), 0, 2620 }, /* EORSR.B #<data>.W */
{ CPUFUNC(op_a40_0), 0, 2624 }, /* EOR.W #<data>.W,Dn */
{ CPUFUNC(op_a50_0), 0, 2640 }, /* EOR.W #<data>.W,(An) */
{ CPUFUNC(op_a58_0), 0, 2648 }, /* EOR.W #<data>.W,(An)+ */
{ CPUFUNC(op_a60_0), 0, 2656 }, /* EOR.W #<data>.W,-(An) */
{ CPUFUNC(op_a68_0), 0, 2664 }, /* EOR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_a70_0), 0, 2672 }, /* EOR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_a78_0), 0, 2680 }, /* EOR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_a79_0), 0, 2681 }, /* EOR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_a7c_0), 0, 2684 }, /* EORSR.W #<data>.W */
{ CPUFUNC(op_a80_0), 0, 2688 }, /* EOR.L #<data>.L,Dn */
{ CPUFUNC(op_a90_0), 0, 2704 }, /* EOR.L #<data>.L,(An) */
{ CPUFUNC(op_a98_0), 0, 2712 }, /* EOR.L #<data>.L,(An)+ */
{ CPUFUNC(op_aa0_0), 0, 2720 }, /* EOR.L #<data>.L,-(An) */
{ CPUFUNC(op_aa8_0), 0, 2728 }, /* EOR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_ab0_0), 0, 2736 }, /* EOR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_ab8_0), 0, 2744 }, /* EOR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_ab9_0), 0, 2745 }, /* EOR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_ad0_0), 0, 2768 }, /* CAS.B #<data>.W,(An) */
{ CPUFUNC(op_ad8_0), 0, 2776 }, /* CAS.B #<data>.W,(An)+ */
{ CPUFUNC(op_ae0_0), 0, 2784 }, /* CAS.B #<data>.W,-(An) */
{ CPUFUNC(op_ae8_0), 0, 2792 }, /* CAS.B #<data>.W,(d16,An) */
{ CPUFUNC(op_af0_0), 0, 2800 }, /* CAS.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_af8_0), 0, 2808 }, /* CAS.B #<data>.W,(xxx).W */
{ CPUFUNC(op_af9_0), 0, 2809 }, /* CAS.B #<data>.W,(xxx).L */
{ CPUFUNC(op_c00_0), 0, 3072 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_c10_0), 0, 3088 }, /* CMP.B #<data>.B,(An) */
{ CPUFUNC(op_c18_0), 0, 3096 }, /* CMP.B #<data>.B,(An)+ */
{ CPUFUNC(op_c20_0), 0, 3104 }, /* CMP.B #<data>.B,-(An) */
{ CPUFUNC(op_c28_0), 0, 3112 }, /* CMP.B #<data>.B,(d16,An) */
{ CPUFUNC(op_c30_0), 0, 3120 }, /* CMP.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_c38_0), 0, 3128 }, /* CMP.B #<data>.B,(xxx).W */
{ CPUFUNC(op_c39_0), 0, 3129 }, /* CMP.B #<data>.B,(xxx).L */
{ CPUFUNC(op_c3a_0), 0, 3130 }, /* CMP.B #<data>.B,(d16,PC) */
{ CPUFUNC(op_c3b_0), 0, 3131 }, /* CMP.B #<data>.B,(d8,PC,Xn) */
{ CPUFUNC(op_c40_0), 0, 3136 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_c50_0), 0, 3152 }, /* CMP.W #<data>.W,(An) */
{ CPUFUNC(op_c58_0), 0, 3160 }, /* CMP.W #<data>.W,(An)+ */
{ CPUFUNC(op_c60_0), 0, 3168 }, /* CMP.W #<data>.W,-(An) */
{ CPUFUNC(op_c68_0), 0, 3176 }, /* CMP.W #<data>.W,(d16,An) */
{ CPUFUNC(op_c70_0), 0, 3184 }, /* CMP.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_c78_0), 0, 3192 }, /* CMP.W #<data>.W,(xxx).W */
{ CPUFUNC(op_c79_0), 0, 3193 }, /* CMP.W #<data>.W,(xxx).L */
{ CPUFUNC(op_c7a_0), 0, 3194 }, /* CMP.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_c7b_0), 0, 3195 }, /* CMP.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_c80_0), 0, 3200 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_c90_0), 0, 3216 }, /* CMP.L #<data>.L,(An) */
{ CPUFUNC(op_c98_0), 0, 3224 }, /* CMP.L #<data>.L,(An)+ */
{ CPUFUNC(op_ca0_0), 0, 3232 }, /* CMP.L #<data>.L,-(An) */
{ CPUFUNC(op_ca8_0), 0, 3240 }, /* CMP.L #<data>.L,(d16,An) */
{ CPUFUNC(op_cb0_0), 0, 3248 }, /* CMP.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_cb8_0), 0, 3256 }, /* CMP.L #<data>.L,(xxx).W */
{ CPUFUNC(op_cb9_0), 0, 3257 }, /* CMP.L #<data>.L,(xxx).L */
{ CPUFUNC(op_cba_0), 0, 3258 }, /* CMP.L #<data>.L,(d16,PC) */
{ CPUFUNC(op_cbb_0), 0, 3259 }, /* CMP.L #<data>.L,(d8,PC,Xn) */
{ CPUFUNC(op_cd0_0), 0, 3280 }, /* CAS.W #<data>.W,(An) */
{ CPUFUNC(op_cd8_0), 0, 3288 }, /* CAS.W #<data>.W,(An)+ */
{ CPUFUNC(op_ce0_0), 0, 3296 }, /* CAS.W #<data>.W,-(An) */
{ CPUFUNC(op_ce8_0), 0, 3304 }, /* CAS.W #<data>.W,(d16,An) */
{ CPUFUNC(op_cf0_0), 0, 3312 }, /* CAS.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_cf8_0), 0, 3320 }, /* CAS.W #<data>.W,(xxx).W */
{ CPUFUNC(op_cf9_0), 0, 3321 }, /* CAS.W #<data>.W,(xxx).L */
{ CPUFUNC(op_cfc_0), 0, 3324 }, /* CAS2.W #<data>.L */
{ CPUFUNC_FF(op_e10_0), 0, 3600 }, /* MOVES.B #<data>.W,(An) */
{ CPUFUNC_FF(op_e18_0), 0, 3608 }, /* MOVES.B #<data>.W,(An)+ */
{ CPUFUNC_FF(op_e20_0), 0, 3616 }, /* MOVES.B #<data>.W,-(An) */
{ CPUFUNC_FF(op_e28_0), 0, 3624 }, /* MOVES.B #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_e30_0), 0, 3632 }, /* MOVES.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_e38_0), 0, 3640 }, /* MOVES.B #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_e39_0), 0, 3641 }, /* MOVES.B #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_e50_0), 0, 3664 }, /* MOVES.W #<data>.W,(An) */
{ CPUFUNC_FF(op_e58_0), 0, 3672 }, /* MOVES.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_e60_0), 0, 3680 }, /* MOVES.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_e68_0), 0, 3688 }, /* MOVES.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_e70_0), 0, 3696 }, /* MOVES.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_e78_0), 0, 3704 }, /* MOVES.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_e79_0), 0, 3705 }, /* MOVES.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_e90_0), 0, 3728 }, /* MOVES.L #<data>.W,(An) */
{ CPUFUNC_FF(op_e98_0), 0, 3736 }, /* MOVES.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_ea0_0), 0, 3744 }, /* MOVES.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_ea8_0), 0, 3752 }, /* MOVES.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_eb0_0), 0, 3760 }, /* MOVES.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_eb8_0), 0, 3768 }, /* MOVES.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_eb9_0), 0, 3769 }, /* MOVES.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ed0_0), 0, 3792 }, /* CAS.L #<data>.W,(An) */
{ CPUFUNC(op_ed8_0), 0, 3800 }, /* CAS.L #<data>.W,(An)+ */
{ CPUFUNC(op_ee0_0), 0, 3808 }, /* CAS.L #<data>.W,-(An) */
{ CPUFUNC(op_ee8_0), 0, 3816 }, /* CAS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ef0_0), 0, 3824 }, /* CAS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ef8_0), 0, 3832 }, /* CAS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ef9_0), 0, 3833 }, /* CAS.L #<data>.W,(xxx).L */
{ CPUFUNC(op_efc_0), 0, 3836 }, /* CAS2.L #<data>.L */
{ CPUFUNC(op_1000_0), 0, 4096 }, /* MOVE.B Dn,Dn */
{ CPUFUNC(op_1010_0), 0, 4112 }, /* MOVE.B (An),Dn */
{ CPUFUNC(op_1018_0), 0, 4120 }, /* MOVE.B (An)+,Dn */
{ CPUFUNC(op_1020_0), 0, 4128 }, /* MOVE.B -(An),Dn */
{ CPUFUNC(op_1028_0), 0, 4136 }, /* MOVE.B (d16,An),Dn */
{ CPUFUNC(op_1030_0), 0, 4144 }, /* MOVE.B (d8,An,Xn),Dn */
{ CPUFUNC(op_1038_0), 0, 4152 }, /* MOVE.B (xxx).W,Dn */
{ CPUFUNC(op_1039_0), 0, 4153 }, /* MOVE.B (xxx).L,Dn */
{ CPUFUNC(op_103a_0), 0, 4154 }, /* MOVE.B (d16,PC),Dn */
{ CPUFUNC(op_103b_0), 0, 4155 }, /* MOVE.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_103c_0), 0, 4156 }, /* MOVE.B #<data>.B,Dn */
{ CPUFUNC(op_1080_0), 0, 4224 }, /* MOVE.B Dn,(An) */
{ CPUFUNC(op_1090_0), 0, 4240 }, /* MOVE.B (An),(An) */
{ CPUFUNC(op_1098_0), 0, 4248 }, /* MOVE.B (An)+,(An) */
{ CPUFUNC(op_10a0_0), 0, 4256 }, /* MOVE.B -(An),(An) */
{ CPUFUNC(op_10a8_0), 0, 4264 }, /* MOVE.B (d16,An),(An) */
{ CPUFUNC(op_10b0_0), 0, 4272 }, /* MOVE.B (d8,An,Xn),(An) */
{ CPUFUNC(op_10b8_0), 0, 4280 }, /* MOVE.B (xxx).W,(An) */
{ CPUFUNC(op_10b9_0), 0, 4281 }, /* MOVE.B (xxx).L,(An) */
{ CPUFUNC(op_10ba_0), 0, 4282 }, /* MOVE.B (d16,PC),(An) */
{ CPUFUNC(op_10bb_0), 0, 4283 }, /* MOVE.B (d8,PC,Xn),(An) */
{ CPUFUNC(op_10bc_0), 0, 4284 }, /* MOVE.B #<data>.B,(An) */
{ CPUFUNC(op_10c0_0), 0, 4288 }, /* MOVE.B Dn,(An)+ */
{ CPUFUNC(op_10d0_0), 0, 4304 }, /* MOVE.B (An),(An)+ */
{ CPUFUNC(op_10d8_0), 0, 4312 }, /* MOVE.B (An)+,(An)+ */
{ CPUFUNC(op_10e0_0), 0, 4320 }, /* MOVE.B -(An),(An)+ */
{ CPUFUNC(op_10e8_0), 0, 4328 }, /* MOVE.B (d16,An),(An)+ */
{ CPUFUNC(op_10f0_0), 0, 4336 }, /* MOVE.B (d8,An,Xn),(An)+ */
{ CPUFUNC(op_10f8_0), 0, 4344 }, /* MOVE.B (xxx).W,(An)+ */
{ CPUFUNC(op_10f9_0), 0, 4345 }, /* MOVE.B (xxx).L,(An)+ */
{ CPUFUNC(op_10fa_0), 0, 4346 }, /* MOVE.B (d16,PC),(An)+ */
{ CPUFUNC(op_10fb_0), 0, 4347 }, /* MOVE.B (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_10fc_0), 0, 4348 }, /* MOVE.B #<data>.B,(An)+ */
{ CPUFUNC(op_1100_0), 0, 4352 }, /* MOVE.B Dn,-(An) */
{ CPUFUNC(op_1110_0), 0, 4368 }, /* MOVE.B (An),-(An) */
{ CPUFUNC(op_1118_0), 0, 4376 }, /* MOVE.B (An)+,-(An) */
{ CPUFUNC(op_1120_0), 0, 4384 }, /* MOVE.B -(An),-(An) */
{ CPUFUNC(op_1128_0), 0, 4392 }, /* MOVE.B (d16,An),-(An) */
{ CPUFUNC(op_1130_0), 0, 4400 }, /* MOVE.B (d8,An,Xn),-(An) */
{ CPUFUNC(op_1138_0), 0, 4408 }, /* MOVE.B (xxx).W,-(An) */
{ CPUFUNC(op_1139_0), 0, 4409 }, /* MOVE.B (xxx).L,-(An) */
{ CPUFUNC(op_113a_0), 0, 4410 }, /* MOVE.B (d16,PC),-(An) */
{ CPUFUNC(op_113b_0), 0, 4411 }, /* MOVE.B (d8,PC,Xn),-(An) */
{ CPUFUNC(op_113c_0), 0, 4412 }, /* MOVE.B #<data>.B,-(An) */
{ CPUFUNC(op_1140_0), 0, 4416 }, /* MOVE.B Dn,(d16,An) */
{ CPUFUNC(op_1150_0), 0, 4432 }, /* MOVE.B (An),(d16,An) */
{ CPUFUNC(op_1158_0), 0, 4440 }, /* MOVE.B (An)+,(d16,An) */
{ CPUFUNC(op_1160_0), 0, 4448 }, /* MOVE.B -(An),(d16,An) */
{ CPUFUNC(op_1168_0), 0, 4456 }, /* MOVE.B (d16,An),(d16,An) */
{ CPUFUNC(op_1170_0), 0, 4464 }, /* MOVE.B (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_1178_0), 0, 4472 }, /* MOVE.B (xxx).W,(d16,An) */
{ CPUFUNC(op_1179_0), 0, 4473 }, /* MOVE.B (xxx).L,(d16,An) */
{ CPUFUNC(op_117a_0), 0, 4474 }, /* MOVE.B (d16,PC),(d16,An) */
{ CPUFUNC(op_117b_0), 0, 4475 }, /* MOVE.B (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_117c_0), 0, 4476 }, /* MOVE.B #<data>.B,(d16,An) */
{ CPUFUNC(op_1180_0), 0, 4480 }, /* MOVE.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1190_0), 0, 4496 }, /* MOVE.B (An),(d8,An,Xn) */
{ CPUFUNC(op_1198_0), 0, 4504 }, /* MOVE.B (An)+,(d8,An,Xn) */
{ CPUFUNC(op_11a0_0), 0, 4512 }, /* MOVE.B -(An),(d8,An,Xn) */
{ CPUFUNC(op_11a8_0), 0, 4520 }, /* MOVE.B (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_11b0_0), 0, 4528 }, /* MOVE.B (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11b8_0), 0, 4536 }, /* MOVE.B (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_11b9_0), 0, 4537 }, /* MOVE.B (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_11ba_0), 0, 4538 }, /* MOVE.B (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_11bb_0), 0, 4539 }, /* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11bc_0), 0, 4540 }, /* MOVE.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_11c0_0), 0, 4544 }, /* MOVE.B Dn,(xxx).W */
{ CPUFUNC(op_11d0_0), 0, 4560 }, /* MOVE.B (An),(xxx).W */
{ CPUFUNC(op_11d8_0), 0, 4568 }, /* MOVE.B (An)+,(xxx).W */
{ CPUFUNC(op_11e0_0), 0, 4576 }, /* MOVE.B -(An),(xxx).W */
{ CPUFUNC(op_11e8_0), 0, 4584 }, /* MOVE.B (d16,An),(xxx).W */
{ CPUFUNC(op_11f0_0), 0, 4592 }, /* MOVE.B (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_11f8_0), 0, 4600 }, /* MOVE.B (xxx).W,(xxx).W */
{ CPUFUNC(op_11f9_0), 0, 4601 }, /* MOVE.B (xxx).L,(xxx).W */
{ CPUFUNC(op_11fa_0), 0, 4602 }, /* MOVE.B (d16,PC),(xxx).W */
{ CPUFUNC(op_11fb_0), 0, 4603 }, /* MOVE.B (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_11fc_0), 0, 4604 }, /* MOVE.B #<data>.B,(xxx).W */
{ CPUFUNC(op_13c0_0), 0, 5056 }, /* MOVE.B Dn,(xxx).L */
{ CPUFUNC(op_13d0_0), 0, 5072 }, /* MOVE.B (An),(xxx).L */
{ CPUFUNC(op_13d8_0), 0, 5080 }, /* MOVE.B (An)+,(xxx).L */
{ CPUFUNC(op_13e0_0), 0, 5088 }, /* MOVE.B -(An),(xxx).L */
{ CPUFUNC(op_13e8_0), 0, 5096 }, /* MOVE.B (d16,An),(xxx).L */
{ CPUFUNC(op_13f0_0), 0, 5104 }, /* MOVE.B (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_13f8_0), 0, 5112 }, /* MOVE.B (xxx).W,(xxx).L */
{ CPUFUNC(op_13f9_0), 0, 5113 }, /* MOVE.B (xxx).L,(xxx).L */
{ CPUFUNC(op_13fa_0), 0, 5114 }, /* MOVE.B (d16,PC),(xxx).L */
{ CPUFUNC(op_13fb_0), 0, 5115 }, /* MOVE.B (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_13fc_0), 0, 5116 }, /* MOVE.B #<data>.B,(xxx).L */
{ CPUFUNC(op_2000_0), 0, 8192 }, /* MOVE.L Dn,Dn */
{ CPUFUNC(op_2008_0), 0, 8200 }, /* MOVE.L An,Dn */
{ CPUFUNC(op_2010_0), 0, 8208 }, /* MOVE.L (An),Dn */
{ CPUFUNC(op_2018_0), 0, 8216 }, /* MOVE.L (An)+,Dn */
{ CPUFUNC(op_2020_0), 0, 8224 }, /* MOVE.L -(An),Dn */
{ CPUFUNC(op_2028_0), 0, 8232 }, /* MOVE.L (d16,An),Dn */
{ CPUFUNC(op_2030_0), 0, 8240 }, /* MOVE.L (d8,An,Xn),Dn */
{ CPUFUNC(op_2038_0), 0, 8248 }, /* MOVE.L (xxx).W,Dn */
{ CPUFUNC(op_2039_0), 0, 8249 }, /* MOVE.L (xxx).L,Dn */
{ CPUFUNC(op_203a_0), 0, 8250 }, /* MOVE.L (d16,PC),Dn */
{ CPUFUNC(op_203b_0), 0, 8251 }, /* MOVE.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_203c_0), 0, 8252 }, /* MOVE.L #<data>.L,Dn */
{ CPUFUNC_FF(op_2040_0), 0, 8256 }, /* MOVEA.L Dn,An */
{ CPUFUNC_FF(op_2048_0), 0, 8264 }, /* MOVEA.L An,An */
{ CPUFUNC_FF(op_2050_0), 0, 8272 }, /* MOVEA.L (An),An */
{ CPUFUNC_FF(op_2058_0), 0, 8280 }, /* MOVEA.L (An)+,An */
{ CPUFUNC_FF(op_2060_0), 0, 8288 }, /* MOVEA.L -(An),An */
{ CPUFUNC_FF(op_2068_0), 0, 8296 }, /* MOVEA.L (d16,An),An */
{ CPUFUNC_FF(op_2070_0), 0, 8304 }, /* MOVEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_2078_0), 0, 8312 }, /* MOVEA.L (xxx).W,An */
{ CPUFUNC_FF(op_2079_0), 0, 8313 }, /* MOVEA.L (xxx).L,An */
{ CPUFUNC_FF(op_207a_0), 0, 8314 }, /* MOVEA.L (d16,PC),An */
{ CPUFUNC_FF(op_207b_0), 0, 8315 }, /* MOVEA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_207c_0), 0, 8316 }, /* MOVEA.L #<data>.L,An */
{ CPUFUNC(op_2080_0), 0, 8320 }, /* MOVE.L Dn,(An) */
{ CPUFUNC(op_2088_0), 0, 8328 }, /* MOVE.L An,(An) */
{ CPUFUNC(op_2090_0), 0, 8336 }, /* MOVE.L (An),(An) */
{ CPUFUNC(op_2098_0), 0, 8344 }, /* MOVE.L (An)+,(An) */
{ CPUFUNC(op_20a0_0), 0, 8352 }, /* MOVE.L -(An),(An) */
{ CPUFUNC(op_20a8_0), 0, 8360 }, /* MOVE.L (d16,An),(An) */
{ CPUFUNC(op_20b0_0), 0, 8368 }, /* MOVE.L (d8,An,Xn),(An) */
{ CPUFUNC(op_20b8_0), 0, 8376 }, /* MOVE.L (xxx).W,(An) */
{ CPUFUNC(op_20b9_0), 0, 8377 }, /* MOVE.L (xxx).L,(An) */
{ CPUFUNC(op_20ba_0), 0, 8378 }, /* MOVE.L (d16,PC),(An) */
{ CPUFUNC(op_20bb_0), 0, 8379 }, /* MOVE.L (d8,PC,Xn),(An) */
{ CPUFUNC(op_20bc_0), 0, 8380 }, /* MOVE.L #<data>.L,(An) */
{ CPUFUNC(op_20c0_0), 0, 8384 }, /* MOVE.L Dn,(An)+ */
{ CPUFUNC(op_20c8_0), 0, 8392 }, /* MOVE.L An,(An)+ */
{ CPUFUNC(op_20d0_0), 0, 8400 }, /* MOVE.L (An),(An)+ */
{ CPUFUNC(op_20d8_0), 0, 8408 }, /* MOVE.L (An)+,(An)+ */
{ CPUFUNC(op_20e0_0), 0, 8416 }, /* MOVE.L -(An),(An)+ */
{ CPUFUNC(op_20e8_0), 0, 8424 }, /* MOVE.L (d16,An),(An)+ */
{ CPUFUNC(op_20f0_0), 0, 8432 }, /* MOVE.L (d8,An,Xn),(An)+ */
{ CPUFUNC(op_20f8_0), 0, 8440 }, /* MOVE.L (xxx).W,(An)+ */
{ CPUFUNC(op_20f9_0), 0, 8441 }, /* MOVE.L (xxx).L,(An)+ */
{ CPUFUNC(op_20fa_0), 0, 8442 }, /* MOVE.L (d16,PC),(An)+ */
{ CPUFUNC(op_20fb_0), 0, 8443 }, /* MOVE.L (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_20fc_0), 0, 8444 }, /* MOVE.L #<data>.L,(An)+ */
{ CPUFUNC(op_2100_0), 0, 8448 }, /* MOVE.L Dn,-(An) */
{ CPUFUNC(op_2108_0), 0, 8456 }, /* MOVE.L An,-(An) */
{ CPUFUNC(op_2110_0), 0, 8464 }, /* MOVE.L (An),-(An) */
{ CPUFUNC(op_2118_0), 0, 8472 }, /* MOVE.L (An)+,-(An) */
{ CPUFUNC(op_2120_0), 0, 8480 }, /* MOVE.L -(An),-(An) */
{ CPUFUNC(op_2128_0), 0, 8488 }, /* MOVE.L (d16,An),-(An) */
{ CPUFUNC(op_2130_0), 0, 8496 }, /* MOVE.L (d8,An,Xn),-(An) */
{ CPUFUNC(op_2138_0), 0, 8504 }, /* MOVE.L (xxx).W,-(An) */
{ CPUFUNC(op_2139_0), 0, 8505 }, /* MOVE.L (xxx).L,-(An) */
{ CPUFUNC(op_213a_0), 0, 8506 }, /* MOVE.L (d16,PC),-(An) */
{ CPUFUNC(op_213b_0), 0, 8507 }, /* MOVE.L (d8,PC,Xn),-(An) */
{ CPUFUNC(op_213c_0), 0, 8508 }, /* MOVE.L #<data>.L,-(An) */
{ CPUFUNC(op_2140_0), 0, 8512 }, /* MOVE.L Dn,(d16,An) */
{ CPUFUNC(op_2148_0), 0, 8520 }, /* MOVE.L An,(d16,An) */
{ CPUFUNC(op_2150_0), 0, 8528 }, /* MOVE.L (An),(d16,An) */
{ CPUFUNC(op_2158_0), 0, 8536 }, /* MOVE.L (An)+,(d16,An) */
{ CPUFUNC(op_2160_0), 0, 8544 }, /* MOVE.L -(An),(d16,An) */
{ CPUFUNC(op_2168_0), 0, 8552 }, /* MOVE.L (d16,An),(d16,An) */
{ CPUFUNC(op_2170_0), 0, 8560 }, /* MOVE.L (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_2178_0), 0, 8568 }, /* MOVE.L (xxx).W,(d16,An) */
{ CPUFUNC(op_2179_0), 0, 8569 }, /* MOVE.L (xxx).L,(d16,An) */
{ CPUFUNC(op_217a_0), 0, 8570 }, /* MOVE.L (d16,PC),(d16,An) */
{ CPUFUNC(op_217b_0), 0, 8571 }, /* MOVE.L (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_217c_0), 0, 8572 }, /* MOVE.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2180_0), 0, 8576 }, /* MOVE.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_2188_0), 0, 8584 }, /* MOVE.L An,(d8,An,Xn) */
{ CPUFUNC(op_2190_0), 0, 8592 }, /* MOVE.L (An),(d8,An,Xn) */
{ CPUFUNC(op_2198_0), 0, 8600 }, /* MOVE.L (An)+,(d8,An,Xn) */
{ CPUFUNC(op_21a0_0), 0, 8608 }, /* MOVE.L -(An),(d8,An,Xn) */
{ CPUFUNC(op_21a8_0), 0, 8616 }, /* MOVE.L (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_21b0_0), 0, 8624 }, /* MOVE.L (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21b8_0), 0, 8632 }, /* MOVE.L (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_21b9_0), 0, 8633 }, /* MOVE.L (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_21ba_0), 0, 8634 }, /* MOVE.L (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_21bb_0), 0, 8635 }, /* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21bc_0), 0, 8636 }, /* MOVE.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_21c0_0), 0, 8640 }, /* MOVE.L Dn,(xxx).W */
{ CPUFUNC(op_21c8_0), 0, 8648 }, /* MOVE.L An,(xxx).W */
{ CPUFUNC(op_21d0_0), 0, 8656 }, /* MOVE.L (An),(xxx).W */
{ CPUFUNC(op_21d8_0), 0, 8664 }, /* MOVE.L (An)+,(xxx).W */
{ CPUFUNC(op_21e0_0), 0, 8672 }, /* MOVE.L -(An),(xxx).W */
{ CPUFUNC(op_21e8_0), 0, 8680 }, /* MOVE.L (d16,An),(xxx).W */
{ CPUFUNC(op_21f0_0), 0, 8688 }, /* MOVE.L (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_21f8_0), 0, 8696 }, /* MOVE.L (xxx).W,(xxx).W */
{ CPUFUNC(op_21f9_0), 0, 8697 }, /* MOVE.L (xxx).L,(xxx).W */
{ CPUFUNC(op_21fa_0), 0, 8698 }, /* MOVE.L (d16,PC),(xxx).W */
{ CPUFUNC(op_21fb_0), 0, 8699 }, /* MOVE.L (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_21fc_0), 0, 8700 }, /* MOVE.L #<data>.L,(xxx).W */
{ CPUFUNC(op_23c0_0), 0, 9152 }, /* MOVE.L Dn,(xxx).L */
{ CPUFUNC(op_23c8_0), 0, 9160 }, /* MOVE.L An,(xxx).L */
{ CPUFUNC(op_23d0_0), 0, 9168 }, /* MOVE.L (An),(xxx).L */
{ CPUFUNC(op_23d8_0), 0, 9176 }, /* MOVE.L (An)+,(xxx).L */
{ CPUFUNC(op_23e0_0), 0, 9184 }, /* MOVE.L -(An),(xxx).L */
{ CPUFUNC(op_23e8_0), 0, 9192 }, /* MOVE.L (d16,An),(xxx).L */
{ CPUFUNC(op_23f0_0), 0, 9200 }, /* MOVE.L (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_23f8_0), 0, 9208 }, /* MOVE.L (xxx).W,(xxx).L */
{ CPUFUNC(op_23f9_0), 0, 9209 }, /* MOVE.L (xxx).L,(xxx).L */
{ CPUFUNC(op_23fa_0), 0, 9210 }, /* MOVE.L (d16,PC),(xxx).L */
{ CPUFUNC(op_23fb_0), 0, 9211 }, /* MOVE.L (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_23fc_0), 0, 9212 }, /* MOVE.L #<data>.L,(xxx).L */
{ CPUFUNC(op_3000_0), 0, 12288 }, /* MOVE.W Dn,Dn */
{ CPUFUNC(op_3008_0), 0, 12296 }, /* MOVE.W An,Dn */
{ CPUFUNC(op_3010_0), 0, 12304 }, /* MOVE.W (An),Dn */
{ CPUFUNC(op_3018_0), 0, 12312 }, /* MOVE.W (An)+,Dn */
{ CPUFUNC(op_3020_0), 0, 12320 }, /* MOVE.W -(An),Dn */
{ CPUFUNC(op_3028_0), 0, 12328 }, /* MOVE.W (d16,An),Dn */
{ CPUFUNC(op_3030_0), 0, 12336 }, /* MOVE.W (d8,An,Xn),Dn */
{ CPUFUNC(op_3038_0), 0, 12344 }, /* MOVE.W (xxx).W,Dn */
{ CPUFUNC(op_3039_0), 0, 12345 }, /* MOVE.W (xxx).L,Dn */
{ CPUFUNC(op_303a_0), 0, 12346 }, /* MOVE.W (d16,PC),Dn */
{ CPUFUNC(op_303b_0), 0, 12347 }, /* MOVE.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_303c_0), 0, 12348 }, /* MOVE.W #<data>.W,Dn */
{ CPUFUNC_FF(op_3040_0), 0, 12352 }, /* MOVEA.W Dn,An */
{ CPUFUNC_FF(op_3048_0), 0, 12360 }, /* MOVEA.W An,An */
{ CPUFUNC_FF(op_3050_0), 0, 12368 }, /* MOVEA.W (An),An */
{ CPUFUNC_FF(op_3058_0), 0, 12376 }, /* MOVEA.W (An)+,An */
{ CPUFUNC_FF(op_3060_0), 0, 12384 }, /* MOVEA.W -(An),An */
{ CPUFUNC_FF(op_3068_0), 0, 12392 }, /* MOVEA.W (d16,An),An */
{ CPUFUNC_FF(op_3070_0), 0, 12400 }, /* MOVEA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_3078_0), 0, 12408 }, /* MOVEA.W (xxx).W,An */
{ CPUFUNC_FF(op_3079_0), 0, 12409 }, /* MOVEA.W (xxx).L,An */
{ CPUFUNC_FF(op_307a_0), 0, 12410 }, /* MOVEA.W (d16,PC),An */
{ CPUFUNC_FF(op_307b_0), 0, 12411 }, /* MOVEA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_307c_0), 0, 12412 }, /* MOVEA.W #<data>.W,An */
{ CPUFUNC(op_3080_0), 0, 12416 }, /* MOVE.W Dn,(An) */
{ CPUFUNC(op_3088_0), 0, 12424 }, /* MOVE.W An,(An) */
{ CPUFUNC(op_3090_0), 0, 12432 }, /* MOVE.W (An),(An) */
{ CPUFUNC(op_3098_0), 0, 12440 }, /* MOVE.W (An)+,(An) */
{ CPUFUNC(op_30a0_0), 0, 12448 }, /* MOVE.W -(An),(An) */
{ CPUFUNC(op_30a8_0), 0, 12456 }, /* MOVE.W (d16,An),(An) */
{ CPUFUNC(op_30b0_0), 0, 12464 }, /* MOVE.W (d8,An,Xn),(An) */
{ CPUFUNC(op_30b8_0), 0, 12472 }, /* MOVE.W (xxx).W,(An) */
{ CPUFUNC(op_30b9_0), 0, 12473 }, /* MOVE.W (xxx).L,(An) */
{ CPUFUNC(op_30ba_0), 0, 12474 }, /* MOVE.W (d16,PC),(An) */
{ CPUFUNC(op_30bb_0), 0, 12475 }, /* MOVE.W (d8,PC,Xn),(An) */
{ CPUFUNC(op_30bc_0), 0, 12476 }, /* MOVE.W #<data>.W,(An) */
{ CPUFUNC(op_30c0_0), 0, 12480 }, /* MOVE.W Dn,(An)+ */
{ CPUFUNC(op_30c8_0), 0, 12488 }, /* MOVE.W An,(An)+ */
{ CPUFUNC(op_30d0_0), 0, 12496 }, /* MOVE.W (An),(An)+ */
{ CPUFUNC(op_30d8_0), 0, 12504 }, /* MOVE.W (An)+,(An)+ */
{ CPUFUNC(op_30e0_0), 0, 12512 }, /* MOVE.W -(An),(An)+ */
{ CPUFUNC(op_30e8_0), 0, 12520 }, /* MOVE.W (d16,An),(An)+ */
{ CPUFUNC(op_30f0_0), 0, 12528 }, /* MOVE.W (d8,An,Xn),(An)+ */
{ CPUFUNC(op_30f8_0), 0, 12536 }, /* MOVE.W (xxx).W,(An)+ */
{ CPUFUNC(op_30f9_0), 0, 12537 }, /* MOVE.W (xxx).L,(An)+ */
{ CPUFUNC(op_30fa_0), 0, 12538 }, /* MOVE.W (d16,PC),(An)+ */
{ CPUFUNC(op_30fb_0), 0, 12539 }, /* MOVE.W (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_30fc_0), 0, 12540 }, /* MOVE.W #<data>.W,(An)+ */
{ CPUFUNC(op_3100_0), 0, 12544 }, /* MOVE.W Dn,-(An) */
{ CPUFUNC(op_3108_0), 0, 12552 }, /* MOVE.W An,-(An) */
{ CPUFUNC(op_3110_0), 0, 12560 }, /* MOVE.W (An),-(An) */
{ CPUFUNC(op_3118_0), 0, 12568 }, /* MOVE.W (An)+,-(An) */
{ CPUFUNC(op_3120_0), 0, 12576 }, /* MOVE.W -(An),-(An) */
{ CPUFUNC(op_3128_0), 0, 12584 }, /* MOVE.W (d16,An),-(An) */
{ CPUFUNC(op_3130_0), 0, 12592 }, /* MOVE.W (d8,An,Xn),-(An) */
{ CPUFUNC(op_3138_0), 0, 12600 }, /* MOVE.W (xxx).W,-(An) */
{ CPUFUNC(op_3139_0), 0, 12601 }, /* MOVE.W (xxx).L,-(An) */
{ CPUFUNC(op_313a_0), 0, 12602 }, /* MOVE.W (d16,PC),-(An) */
{ CPUFUNC(op_313b_0), 0, 12603 }, /* MOVE.W (d8,PC,Xn),-(An) */
{ CPUFUNC(op_313c_0), 0, 12604 }, /* MOVE.W #<data>.W,-(An) */
{ CPUFUNC(op_3140_0), 0, 12608 }, /* MOVE.W Dn,(d16,An) */
{ CPUFUNC(op_3148_0), 0, 12616 }, /* MOVE.W An,(d16,An) */
{ CPUFUNC(op_3150_0), 0, 12624 }, /* MOVE.W (An),(d16,An) */
{ CPUFUNC(op_3158_0), 0, 12632 }, /* MOVE.W (An)+,(d16,An) */
{ CPUFUNC(op_3160_0), 0, 12640 }, /* MOVE.W -(An),(d16,An) */
{ CPUFUNC(op_3168_0), 0, 12648 }, /* MOVE.W (d16,An),(d16,An) */
{ CPUFUNC(op_3170_0), 0, 12656 }, /* MOVE.W (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_3178_0), 0, 12664 }, /* MOVE.W (xxx).W,(d16,An) */
{ CPUFUNC(op_3179_0), 0, 12665 }, /* MOVE.W (xxx).L,(d16,An) */
{ CPUFUNC(op_317a_0), 0, 12666 }, /* MOVE.W (d16,PC),(d16,An) */
{ CPUFUNC(op_317b_0), 0, 12667 }, /* MOVE.W (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_317c_0), 0, 12668 }, /* MOVE.W #<data>.W,(d16,An) */
{ CPUFUNC(op_3180_0), 0, 12672 }, /* MOVE.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_3188_0), 0, 12680 }, /* MOVE.W An,(d8,An,Xn) */
{ CPUFUNC(op_3190_0), 0, 12688 }, /* MOVE.W (An),(d8,An,Xn) */
{ CPUFUNC(op_3198_0), 0, 12696 }, /* MOVE.W (An)+,(d8,An,Xn) */
{ CPUFUNC(op_31a0_0), 0, 12704 }, /* MOVE.W -(An),(d8,An,Xn) */
{ CPUFUNC(op_31a8_0), 0, 12712 }, /* MOVE.W (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_31b0_0), 0, 12720 }, /* MOVE.W (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31b8_0), 0, 12728 }, /* MOVE.W (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_31b9_0), 0, 12729 }, /* MOVE.W (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_31ba_0), 0, 12730 }, /* MOVE.W (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_31bb_0), 0, 12731 }, /* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31bc_0), 0, 12732 }, /* MOVE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_31c0_0), 0, 12736 }, /* MOVE.W Dn,(xxx).W */
{ CPUFUNC(op_31c8_0), 0, 12744 }, /* MOVE.W An,(xxx).W */
{ CPUFUNC(op_31d0_0), 0, 12752 }, /* MOVE.W (An),(xxx).W */
{ CPUFUNC(op_31d8_0), 0, 12760 }, /* MOVE.W (An)+,(xxx).W */
{ CPUFUNC(op_31e0_0), 0, 12768 }, /* MOVE.W -(An),(xxx).W */
{ CPUFUNC(op_31e8_0), 0, 12776 }, /* MOVE.W (d16,An),(xxx).W */
{ CPUFUNC(op_31f0_0), 0, 12784 }, /* MOVE.W (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_31f8_0), 0, 12792 }, /* MOVE.W (xxx).W,(xxx).W */
{ CPUFUNC(op_31f9_0), 0, 12793 }, /* MOVE.W (xxx).L,(xxx).W */
{ CPUFUNC(op_31fa_0), 0, 12794 }, /* MOVE.W (d16,PC),(xxx).W */
{ CPUFUNC(op_31fb_0), 0, 12795 }, /* MOVE.W (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_31fc_0), 0, 12796 }, /* MOVE.W #<data>.W,(xxx).W */
{ CPUFUNC(op_33c0_0), 0, 13248 }, /* MOVE.W Dn,(xxx).L */
{ CPUFUNC(op_33c8_0), 0, 13256 }, /* MOVE.W An,(xxx).L */
{ CPUFUNC(op_33d0_0), 0, 13264 }, /* MOVE.W (An),(xxx).L */
{ CPUFUNC(op_33d8_0), 0, 13272 }, /* MOVE.W (An)+,(xxx).L */
{ CPUFUNC(op_33e0_0), 0, 13280 }, /* MOVE.W -(An),(xxx).L */
{ CPUFUNC(op_33e8_0), 0, 13288 }, /* MOVE.W (d16,An),(xxx).L */
{ CPUFUNC(op_33f0_0), 0, 13296 }, /* MOVE.W (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_33f8_0), 0, 13304 }, /* MOVE.W (xxx).W,(xxx).L */
{ CPUFUNC(op_33f9_0), 0, 13305 }, /* MOVE.W (xxx).L,(xxx).L */
{ CPUFUNC(op_33fa_0), 0, 13306 }, /* MOVE.W (d16,PC),(xxx).L */
{ CPUFUNC(op_33fb_0), 0, 13307 }, /* MOVE.W (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_33fc_0), 0, 13308 }, /* MOVE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_4000_0), 0, 16384 }, /* NEGX.B Dn */
{ CPUFUNC(op_4010_0), 0, 16400 }, /* NEGX.B (An) */
{ CPUFUNC(op_4018_0), 0, 16408 }, /* NEGX.B (An)+ */
{ CPUFUNC(op_4020_0), 0, 16416 }, /* NEGX.B -(An) */
{ CPUFUNC(op_4028_0), 0, 16424 }, /* NEGX.B (d16,An) */
{ CPUFUNC(op_4030_0), 0, 16432 }, /* NEGX.B (d8,An,Xn) */
{ CPUFUNC(op_4038_0), 0, 16440 }, /* NEGX.B (xxx).W */
{ CPUFUNC(op_4039_0), 0, 16441 }, /* NEGX.B (xxx).L */
{ CPUFUNC(op_4040_0), 0, 16448 }, /* NEGX.W Dn */
{ CPUFUNC(op_4050_0), 0, 16464 }, /* NEGX.W (An) */
{ CPUFUNC(op_4058_0), 0, 16472 }, /* NEGX.W (An)+ */
{ CPUFUNC(op_4060_0), 0, 16480 }, /* NEGX.W -(An) */
{ CPUFUNC(op_4068_0), 0, 16488 }, /* NEGX.W (d16,An) */
{ CPUFUNC(op_4070_0), 0, 16496 }, /* NEGX.W (d8,An,Xn) */
{ CPUFUNC(op_4078_0), 0, 16504 }, /* NEGX.W (xxx).W */
{ CPUFUNC(op_4079_0), 0, 16505 }, /* NEGX.W (xxx).L */
{ CPUFUNC(op_4080_0), 0, 16512 }, /* NEGX.L Dn */
{ CPUFUNC(op_4090_0), 0, 16528 }, /* NEGX.L (An) */
{ CPUFUNC(op_4098_0), 0, 16536 }, /* NEGX.L (An)+ */
{ CPUFUNC(op_40a0_0), 0, 16544 }, /* NEGX.L -(An) */
{ CPUFUNC(op_40a8_0), 0, 16552 }, /* NEGX.L (d16,An) */
{ CPUFUNC(op_40b0_0), 0, 16560 }, /* NEGX.L (d8,An,Xn) */
{ CPUFUNC(op_40b8_0), 0, 16568 }, /* NEGX.L (xxx).W */
{ CPUFUNC(op_40b9_0), 0, 16569 }, /* NEGX.L (xxx).L */
{ CPUFUNC_FF(op_40c0_0), 0, 16576 }, /* MVSR2.W Dn */
{ CPUFUNC_FF(op_40d0_0), 0, 16592 }, /* MVSR2.W (An) */
{ CPUFUNC_FF(op_40d8_0), 0, 16600 }, /* MVSR2.W (An)+ */
{ CPUFUNC_FF(op_40e0_0), 0, 16608 }, /* MVSR2.W -(An) */
{ CPUFUNC_FF(op_40e8_0), 0, 16616 }, /* MVSR2.W (d16,An) */
{ CPUFUNC_FF(op_40f0_0), 0, 16624 }, /* MVSR2.W (d8,An,Xn) */
{ CPUFUNC_FF(op_40f8_0), 0, 16632 }, /* MVSR2.W (xxx).W */
{ CPUFUNC_FF(op_40f9_0), 0, 16633 }, /* MVSR2.W (xxx).L */
{ CPUFUNC(op_4100_0), 0, 16640 }, /* CHK.L Dn,Dn */
{ CPUFUNC(op_4110_0), 0, 16656 }, /* CHK.L (An),Dn */
{ CPUFUNC(op_4118_0), 0, 16664 }, /* CHK.L (An)+,Dn */
{ CPUFUNC(op_4120_0), 0, 16672 }, /* CHK.L -(An),Dn */
{ CPUFUNC(op_4128_0), 0, 16680 }, /* CHK.L (d16,An),Dn */
{ CPUFUNC(op_4130_0), 0, 16688 }, /* CHK.L (d8,An,Xn),Dn */
{ CPUFUNC(op_4138_0), 0, 16696 }, /* CHK.L (xxx).W,Dn */
{ CPUFUNC(op_4139_0), 0, 16697 }, /* CHK.L (xxx).L,Dn */
{ CPUFUNC(op_413a_0), 0, 16698 }, /* CHK.L (d16,PC),Dn */
{ CPUFUNC(op_413b_0), 0, 16699 }, /* CHK.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_413c_0), 0, 16700 }, /* CHK.L #<data>.L,Dn */
{ CPUFUNC(op_4180_0), 0, 16768 }, /* CHK.W Dn,Dn */
{ CPUFUNC(op_4190_0), 0, 16784 }, /* CHK.W (An),Dn */
{ CPUFUNC(op_4198_0), 0, 16792 }, /* CHK.W (An)+,Dn */
{ CPUFUNC(op_41a0_0), 0, 16800 }, /* CHK.W -(An),Dn */
{ CPUFUNC(op_41a8_0), 0, 16808 }, /* CHK.W (d16,An),Dn */
{ CPUFUNC(op_41b0_0), 0, 16816 }, /* CHK.W (d8,An,Xn),Dn */
{ CPUFUNC(op_41b8_0), 0, 16824 }, /* CHK.W (xxx).W,Dn */
{ CPUFUNC(op_41b9_0), 0, 16825 }, /* CHK.W (xxx).L,Dn */
{ CPUFUNC(op_41ba_0), 0, 16826 }, /* CHK.W (d16,PC),Dn */
{ CPUFUNC(op_41bb_0), 0, 16827 }, /* CHK.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_41bc_0), 0, 16828 }, /* CHK.W #<data>.W,Dn */
{ CPUFUNC_FF(op_41d0_0), 0, 16848 }, /* LEA.L (An),An */
{ CPUFUNC_FF(op_41e8_0), 0, 16872 }, /* LEA.L (d16,An),An */
{ CPUFUNC_FF(op_41f0_0), 0, 16880 }, /* LEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_41f8_0), 0, 16888 }, /* LEA.L (xxx).W,An */
{ CPUFUNC_FF(op_41f9_0), 0, 16889 }, /* LEA.L (xxx).L,An */
{ CPUFUNC_FF(op_41fa_0), 0, 16890 }, /* LEA.L (d16,PC),An */
{ CPUFUNC_FF(op_41fb_0), 0, 16891 }, /* LEA.L (d8,PC,Xn),An */
{ CPUFUNC(op_4200_0), 0, 16896 }, /* CLR.B Dn */
{ CPUFUNC(op_4210_0), 0, 16912 }, /* CLR.B (An) */
{ CPUFUNC(op_4218_0), 0, 16920 }, /* CLR.B (An)+ */
{ CPUFUNC(op_4220_0), 0, 16928 }, /* CLR.B -(An) */
{ CPUFUNC(op_4228_0), 0, 16936 }, /* CLR.B (d16,An) */
{ CPUFUNC(op_4230_0), 0, 16944 }, /* CLR.B (d8,An,Xn) */
{ CPUFUNC(op_4238_0), 0, 16952 }, /* CLR.B (xxx).W */
{ CPUFUNC(op_4239_0), 0, 16953 }, /* CLR.B (xxx).L */
{ CPUFUNC(op_4240_0), 0, 16960 }, /* CLR.W Dn */
{ CPUFUNC(op_4250_0), 0, 16976 }, /* CLR.W (An) */
{ CPUFUNC(op_4258_0), 0, 16984 }, /* CLR.W (An)+ */
{ CPUFUNC(op_4260_0), 0, 16992 }, /* CLR.W -(An) */
{ CPUFUNC(op_4268_0), 0, 17000 }, /* CLR.W (d16,An) */
{ CPUFUNC(op_4270_0), 0, 17008 }, /* CLR.W (d8,An,Xn) */
{ CPUFUNC(op_4278_0), 0, 17016 }, /* CLR.W (xxx).W */
{ CPUFUNC(op_4279_0), 0, 17017 }, /* CLR.W (xxx).L */
{ CPUFUNC(op_4280_0), 0, 17024 }, /* CLR.L Dn */
{ CPUFUNC(op_4290_0), 0, 17040 }, /* CLR.L (An) */
{ CPUFUNC(op_4298_0), 0, 17048 }, /* CLR.L (An)+ */
{ CPUFUNC(op_42a0_0), 0, 17056 }, /* CLR.L -(An) */
{ CPUFUNC(op_42a8_0), 0, 17064 }, /* CLR.L (d16,An) */
{ CPUFUNC(op_42b0_0), 0, 17072 }, /* CLR.L (d8,An,Xn) */
{ CPUFUNC(op_42b8_0), 0, 17080 }, /* CLR.L (xxx).W */
{ CPUFUNC(op_42b9_0), 0, 17081 }, /* CLR.L (xxx).L */
{ CPUFUNC_FF(op_42c0_0), 0, 17088 }, /* MVSR2.B Dn */
{ CPUFUNC_FF(op_42d0_0), 0, 17104 }, /* MVSR2.B (An) */
{ CPUFUNC_FF(op_42d8_0), 0, 17112 }, /* MVSR2.B (An)+ */
{ CPUFUNC_FF(op_42e0_0), 0, 17120 }, /* MVSR2.B -(An) */
{ CPUFUNC_FF(op_42e8_0), 0, 17128 }, /* MVSR2.B (d16,An) */
{ CPUFUNC_FF(op_42f0_0), 0, 17136 }, /* MVSR2.B (d8,An,Xn) */
{ CPUFUNC_FF(op_42f8_0), 0, 17144 }, /* MVSR2.B (xxx).W */
{ CPUFUNC_FF(op_42f9_0), 0, 17145 }, /* MVSR2.B (xxx).L */
{ CPUFUNC(op_4400_0), 0, 17408 }, /* NEG.B Dn */
{ CPUFUNC(op_4410_0), 0, 17424 }, /* NEG.B (An) */
{ CPUFUNC(op_4418_0), 0, 17432 }, /* NEG.B (An)+ */
{ CPUFUNC(op_4420_0), 0, 17440 }, /* NEG.B -(An) */
{ CPUFUNC(op_4428_0), 0, 17448 }, /* NEG.B (d16,An) */
{ CPUFUNC(op_4430_0), 0, 17456 }, /* NEG.B (d8,An,Xn) */
{ CPUFUNC(op_4438_0), 0, 17464 }, /* NEG.B (xxx).W */
{ CPUFUNC(op_4439_0), 0, 17465 }, /* NEG.B (xxx).L */
{ CPUFUNC(op_4440_0), 0, 17472 }, /* NEG.W Dn */
{ CPUFUNC(op_4450_0), 0, 17488 }, /* NEG.W (An) */
{ CPUFUNC(op_4458_0), 0, 17496 }, /* NEG.W (An)+ */
{ CPUFUNC(op_4460_0), 0, 17504 }, /* NEG.W -(An) */
{ CPUFUNC(op_4468_0), 0, 17512 }, /* NEG.W (d16,An) */
{ CPUFUNC(op_4470_0), 0, 17520 }, /* NEG.W (d8,An,Xn) */
{ CPUFUNC(op_4478_0), 0, 17528 }, /* NEG.W (xxx).W */
{ CPUFUNC(op_4479_0), 0, 17529 }, /* NEG.W (xxx).L */
{ CPUFUNC(op_4480_0), 0, 17536 }, /* NEG.L Dn */
{ CPUFUNC(op_4490_0), 0, 17552 }, /* NEG.L (An) */
{ CPUFUNC(op_4498_0), 0, 17560 }, /* NEG.L (An)+ */
{ CPUFUNC(op_44a0_0), 0, 17568 }, /* NEG.L -(An) */
{ CPUFUNC(op_44a8_0), 0, 17576 }, /* NEG.L (d16,An) */
{ CPUFUNC(op_44b0_0), 0, 17584 }, /* NEG.L (d8,An,Xn) */
{ CPUFUNC(op_44b8_0), 0, 17592 }, /* NEG.L (xxx).W */
{ CPUFUNC(op_44b9_0), 0, 17593 }, /* NEG.L (xxx).L */
{ CPUFUNC(op_44c0_0), 0, 17600 }, /* MV2SR.B Dn */
{ CPUFUNC(op_44d0_0), 0, 17616 }, /* MV2SR.B (An) */
{ CPUFUNC(op_44d8_0), 0, 17624 }, /* MV2SR.B (An)+ */
{ CPUFUNC(op_44e0_0), 0, 17632 }, /* MV2SR.B -(An) */
{ CPUFUNC(op_44e8_0), 0, 17640 }, /* MV2SR.B (d16,An) */
{ CPUFUNC(op_44f0_0), 0, 17648 }, /* MV2SR.B (d8,An,Xn) */
{ CPUFUNC(op_44f8_0), 0, 17656 }, /* MV2SR.B (xxx).W */
{ CPUFUNC(op_44f9_0), 0, 17657 }, /* MV2SR.B (xxx).L */
{ CPUFUNC(op_44fa_0), 0, 17658 }, /* MV2SR.B (d16,PC) */
{ CPUFUNC(op_44fb_0), 0, 17659 }, /* MV2SR.B (d8,PC,Xn) */
{ CPUFUNC(op_44fc_0), 0, 17660 }, /* MV2SR.B #<data>.B */
{ CPUFUNC(op_4600_0), 0, 17920 }, /* NOT.B Dn */
{ CPUFUNC(op_4610_0), 0, 17936 }, /* NOT.B (An) */
{ CPUFUNC(op_4618_0), 0, 17944 }, /* NOT.B (An)+ */
{ CPUFUNC(op_4620_0), 0, 17952 }, /* NOT.B -(An) */
{ CPUFUNC(op_4628_0), 0, 17960 }, /* NOT.B (d16,An) */
{ CPUFUNC(op_4630_0), 0, 17968 }, /* NOT.B (d8,An,Xn) */
{ CPUFUNC(op_4638_0), 0, 17976 }, /* NOT.B (xxx).W */
{ CPUFUNC(op_4639_0), 0, 17977 }, /* NOT.B (xxx).L */
{ CPUFUNC(op_4640_0), 0, 17984 }, /* NOT.W Dn */
{ CPUFUNC(op_4650_0), 0, 18000 }, /* NOT.W (An) */
{ CPUFUNC(op_4658_0), 0, 18008 }, /* NOT.W (An)+ */
{ CPUFUNC(op_4660_0), 0, 18016 }, /* NOT.W -(An) */
{ CPUFUNC(op_4668_0), 0, 18024 }, /* NOT.W (d16,An) */
{ CPUFUNC(op_4670_0), 0, 18032 }, /* NOT.W (d8,An,Xn) */
{ CPUFUNC(op_4678_0), 0, 18040 }, /* NOT.W (xxx).W */
{ CPUFUNC(op_4679_0), 0, 18041 }, /* NOT.W (xxx).L */
{ CPUFUNC(op_4680_0), 0, 18048 }, /* NOT.L Dn */
{ CPUFUNC(op_4690_0), 0, 18064 }, /* NOT.L (An) */
{ CPUFUNC(op_4698_0), 0, 18072 }, /* NOT.L (An)+ */
{ CPUFUNC(op_46a0_0), 0, 18080 }, /* NOT.L -(An) */
{ CPUFUNC(op_46a8_0), 0, 18088 }, /* NOT.L (d16,An) */
{ CPUFUNC(op_46b0_0), 0, 18096 }, /* NOT.L (d8,An,Xn) */
{ CPUFUNC(op_46b8_0), 0, 18104 }, /* NOT.L (xxx).W */
{ CPUFUNC(op_46b9_0), 0, 18105 }, /* NOT.L (xxx).L */
{ CPUFUNC(op_46c0_0), 0, 18112 }, /* MV2SR.W Dn */
{ CPUFUNC(op_46d0_0), 0, 18128 }, /* MV2SR.W (An) */
{ CPUFUNC(op_46d8_0), 0, 18136 }, /* MV2SR.W (An)+ */
{ CPUFUNC(op_46e0_0), 0, 18144 }, /* MV2SR.W -(An) */
{ CPUFUNC(op_46e8_0), 0, 18152 }, /* MV2SR.W (d16,An) */
{ CPUFUNC(op_46f0_0), 0, 18160 }, /* MV2SR.W (d8,An,Xn) */
{ CPUFUNC(op_46f8_0), 0, 18168 }, /* MV2SR.W (xxx).W */
{ CPUFUNC(op_46f9_0), 0, 18169 }, /* MV2SR.W (xxx).L */
{ CPUFUNC(op_46fa_0), 0, 18170 }, /* MV2SR.W (d16,PC) */
{ CPUFUNC(op_46fb_0), 0, 18171 }, /* MV2SR.W (d8,PC,Xn) */
{ CPUFUNC(op_46fc_0), 0, 18172 }, /* MV2SR.W #<data>.W */
{ CPUFUNC(op_4800_0), 0, 18432 }, /* NBCD.B Dn */
{ CPUFUNC_FF(op_4808_0), 0, 18440 }, /* LINK.L An,#<data>.L */
{ CPUFUNC(op_4810_0), 0, 18448 }, /* NBCD.B (An) */
{ CPUFUNC(op_4818_0), 0, 18456 }, /* NBCD.B (An)+ */
{ CPUFUNC(op_4820_0), 0, 18464 }, /* NBCD.B -(An) */
{ CPUFUNC(op_4828_0), 0, 18472 }, /* NBCD.B (d16,An) */
{ CPUFUNC(op_4830_0), 0, 18480 }, /* NBCD.B (d8,An,Xn) */
{ CPUFUNC(op_4838_0), 0, 18488 }, /* NBCD.B (xxx).W */
{ CPUFUNC(op_4839_0), 0, 18489 }, /* NBCD.B (xxx).L */
{ CPUFUNC(op_4840_0), 0, 18496 }, /* SWAP.W Dn */
{ CPUFUNC_FF(op_4848_0), 0, 18504 }, /* BKPT.L #<data> */
{ CPUFUNC_FF(op_4850_0), 0, 18512 }, /* PEA.L (An) */
{ CPUFUNC_FF(op_4868_0), 0, 18536 }, /* PEA.L (d16,An) */
{ CPUFUNC_FF(op_4870_0), 0, 18544 }, /* PEA.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4878_0), 0, 18552 }, /* PEA.L (xxx).W */
{ CPUFUNC_FF(op_4879_0), 0, 18553 }, /* PEA.L (xxx).L */
{ CPUFUNC_FF(op_487a_0), 0, 18554 }, /* PEA.L (d16,PC) */
{ CPUFUNC_FF(op_487b_0), 0, 18555 }, /* PEA.L (d8,PC,Xn) */
{ CPUFUNC(op_4880_0), 0, 18560 }, /* EXT.W Dn */
{ CPUFUNC_FF(op_4890_0), 0, 18576 }, /* MVMLE.W #<data>.W,(An) */
{ CPUFUNC_FF(op_48a0_0), 0, 18592 }, /* MVMLE.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_48a8_0), 0, 18600 }, /* MVMLE.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48b0_0), 0, 18608 }, /* MVMLE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48b8_0), 0, 18616 }, /* MVMLE.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48b9_0), 0, 18617 }, /* MVMLE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_48c0_0), 0, 18624 }, /* EXT.L Dn */
{ CPUFUNC_FF(op_48d0_0), 0, 18640 }, /* MVMLE.L #<data>.W,(An) */
{ CPUFUNC_FF(op_48e0_0), 0, 18656 }, /* MVMLE.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_48e8_0), 0, 18664 }, /* MVMLE.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48f0_0), 0, 18672 }, /* MVMLE.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48f8_0), 0, 18680 }, /* MVMLE.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48f9_0), 0, 18681 }, /* MVMLE.L #<data>.W,(xxx).L */
{ CPUFUNC(op_49c0_0), 0, 18880 }, /* EXT.B Dn */
{ CPUFUNC(op_4a00_0), 0, 18944 }, /* TST.B Dn */
{ CPUFUNC(op_4a10_0), 0, 18960 }, /* TST.B (An) */
{ CPUFUNC(op_4a18_0), 0, 18968 }, /* TST.B (An)+ */
{ CPUFUNC(op_4a20_0), 0, 18976 }, /* TST.B -(An) */
{ CPUFUNC(op_4a28_0), 0, 18984 }, /* TST.B (d16,An) */
{ CPUFUNC(op_4a30_0), 0, 18992 }, /* TST.B (d8,An,Xn) */
{ CPUFUNC(op_4a38_0), 0, 19000 }, /* TST.B (xxx).W */
{ CPUFUNC(op_4a39_0), 0, 19001 }, /* TST.B (xxx).L */
{ CPUFUNC(op_4a3a_0), 0, 19002 }, /* TST.B (d16,PC) */
{ CPUFUNC(op_4a3b_0), 0, 19003 }, /* TST.B (d8,PC,Xn) */
{ CPUFUNC(op_4a3c_0), 0, 19004 }, /* TST.B #<data>.B */
{ CPUFUNC(op_4a40_0), 0, 19008 }, /* TST.W Dn */
{ CPUFUNC(op_4a48_0), 0, 19016 }, /* TST.W An */
{ CPUFUNC(op_4a50_0), 0, 19024 }, /* TST.W (An) */
{ CPUFUNC(op_4a58_0), 0, 19032 }, /* TST.W (An)+ */
{ CPUFUNC(op_4a60_0), 0, 19040 }, /* TST.W -(An) */
{ CPUFUNC(op_4a68_0), 0, 19048 }, /* TST.W (d16,An) */
{ CPUFUNC(op_4a70_0), 0, 19056 }, /* TST.W (d8,An,Xn) */
{ CPUFUNC(op_4a78_0), 0, 19064 }, /* TST.W (xxx).W */
{ CPUFUNC(op_4a79_0), 0, 19065 }, /* TST.W (xxx).L */
{ CPUFUNC(op_4a7a_0), 0, 19066 }, /* TST.W (d16,PC) */
{ CPUFUNC(op_4a7b_0), 0, 19067 }, /* TST.W (d8,PC,Xn) */
{ CPUFUNC(op_4a7c_0), 0, 19068 }, /* TST.W #<data>.W */
{ CPUFUNC(op_4a80_0), 0, 19072 }, /* TST.L Dn */
{ CPUFUNC(op_4a88_0), 0, 19080 }, /* TST.L An */
{ CPUFUNC(op_4a90_0), 0, 19088 }, /* TST.L (An) */
{ CPUFUNC(op_4a98_0), 0, 19096 }, /* TST.L (An)+ */
{ CPUFUNC(op_4aa0_0), 0, 19104 }, /* TST.L -(An) */
{ CPUFUNC(op_4aa8_0), 0, 19112 }, /* TST.L (d16,An) */
{ CPUFUNC(op_4ab0_0), 0, 19120 }, /* TST.L (d8,An,Xn) */
{ CPUFUNC(op_4ab8_0), 0, 19128 }, /* TST.L (xxx).W */
{ CPUFUNC(op_4ab9_0), 0, 19129 }, /* TST.L (xxx).L */
{ CPUFUNC(op_4aba_0), 0, 19130 }, /* TST.L (d16,PC) */
{ CPUFUNC(op_4abb_0), 0, 19131 }, /* TST.L (d8,PC,Xn) */
{ CPUFUNC(op_4abc_0), 0, 19132 }, /* TST.L #<data>.L */
{ CPUFUNC(op_4ac0_0), 0, 19136 }, /* TAS.B Dn */
{ CPUFUNC(op_4ad0_0), 0, 19152 }, /* TAS.B (An) */
{ CPUFUNC(op_4ad8_0), 0, 19160 }, /* TAS.B (An)+ */
{ CPUFUNC(op_4ae0_0), 0, 19168 }, /* TAS.B -(An) */
{ CPUFUNC(op_4ae8_0), 0, 19176 }, /* TAS.B (d16,An) */
{ CPUFUNC(op_4af0_0), 0, 19184 }, /* TAS.B (d8,An,Xn) */
{ CPUFUNC(op_4af8_0), 0, 19192 }, /* TAS.B (xxx).W */
{ CPUFUNC(op_4af9_0), 0, 19193 }, /* TAS.B (xxx).L */
{ CPUFUNC(op_4c00_0), 0, 19456 }, /* MULL.L #<data>.W,Dn */
{ CPUFUNC(op_4c10_0), 0, 19472 }, /* MULL.L #<data>.W,(An) */
{ CPUFUNC(op_4c18_0), 0, 19480 }, /* MULL.L #<data>.W,(An)+ */
{ CPUFUNC(op_4c20_0), 0, 19488 }, /* MULL.L #<data>.W,-(An) */
{ CPUFUNC(op_4c28_0), 0, 19496 }, /* MULL.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4c30_0), 0, 19504 }, /* MULL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4c38_0), 0, 19512 }, /* MULL.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4c39_0), 0, 19513 }, /* MULL.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4c3a_0), 0, 19514 }, /* MULL.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4c3b_0), 0, 19515 }, /* MULL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_4c3c_0), 0, 19516 }, /* MULL.L #<data>.W,#<data>.L */
{ CPUFUNC(op_4c40_0), 0, 19520 }, /* DIVL.L #<data>.W,Dn */
{ CPUFUNC(op_4c50_0), 0, 19536 }, /* DIVL.L #<data>.W,(An) */
{ CPUFUNC(op_4c58_0), 0, 19544 }, /* DIVL.L #<data>.W,(An)+ */
{ CPUFUNC(op_4c60_0), 0, 19552 }, /* DIVL.L #<data>.W,-(An) */
{ CPUFUNC(op_4c68_0), 0, 19560 }, /* DIVL.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4c70_0), 0, 19568 }, /* DIVL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4c78_0), 0, 19576 }, /* DIVL.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4c79_0), 0, 19577 }, /* DIVL.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4c7a_0), 0, 19578 }, /* DIVL.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4c7b_0), 0, 19579 }, /* DIVL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_4c7c_0), 0, 19580 }, /* DIVL.L #<data>.W,#<data>.L */
{ CPUFUNC_FF(op_4c90_0), 0, 19600 }, /* MVMEL.W #<data>.W,(An) */
{ CPUFUNC_FF(op_4c98_0), 0, 19608 }, /* MVMEL.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ca8_0), 0, 19624 }, /* MVMEL.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cb0_0), 0, 19632 }, /* MVMEL.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cb8_0), 0, 19640 }, /* MVMEL.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cb9_0), 0, 19641 }, /* MVMEL.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cba_0), 0, 19642 }, /* MVMEL.W #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cbb_0), 0, 19643 }, /* MVMEL.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4cd0_0), 0, 19664 }, /* MVMEL.L #<data>.W,(An) */
{ CPUFUNC_FF(op_4cd8_0), 0, 19672 }, /* MVMEL.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ce8_0), 0, 19688 }, /* MVMEL.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cf0_0), 0, 19696 }, /* MVMEL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cf8_0), 0, 19704 }, /* MVMEL.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cf9_0), 0, 19705 }, /* MVMEL.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cfa_0), 0, 19706 }, /* MVMEL.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cfb_0), 0, 19707 }, /* MVMEL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4e40_0), 0, 20032 }, /* TRAP.L #<data> */
{ CPUFUNC_FF(op_4e50_0), 0, 20048 }, /* LINK.W An,#<data>.W */
{ CPUFUNC_FF(op_4e58_0), 0, 20056 }, /* UNLK.L An */
{ CPUFUNC_FF(op_4e60_0), 0, 20064 }, /* MVR2USP.L An */
{ CPUFUNC_FF(op_4e68_0), 0, 20072 }, /* MVUSP2R.L An */
{ CPUFUNC_FF(op_4e70_0), 0, 20080 }, /* RESET.L  */
{ CPUFUNC_FF(op_4e71_0), 0, 20081 }, /* NOP.L  */
{ CPUFUNC(op_4e72_0), 0, 20082 }, /* STOP.L #<data>.W */
{ CPUFUNC(op_4e73_0), 0, 20083 }, /* RTE.L  */
{ CPUFUNC_FF(op_4e74_0), 0, 20084 }, /* RTD.L #<data>.W */
{ CPUFUNC_FF(op_4e75_0), 0, 20085 }, /* RTS.L  */
{ CPUFUNC_FF(op_4e76_0), 0, 20086 }, /* TRAPV.L  */
{ CPUFUNC(op_4e77_0), 0, 20087 }, /* RTR.L  */
{ CPUFUNC_FF(op_4e7a_0), 0, 20090 }, /* MOVEC2.L #<data>.W */
{ CPUFUNC_FF(op_4e7b_0), 0, 20091 }, /* MOVE2C.L #<data>.W */
{ CPUFUNC_FF(op_4e90_0), 0, 20112 }, /* JSR.L (An) */
{ CPUFUNC_FF(op_4ea8_0), 0, 20136 }, /* JSR.L (d16,An) */
{ CPUFUNC_FF(op_4eb0_0), 0, 20144 }, /* JSR.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4eb8_0), 0, 20152 }, /* JSR.L (xxx).W */
{ CPUFUNC_FF(op_4eb9_0), 0, 20153 }, /* JSR.L (xxx).L */
{ CPUFUNC_FF(op_4eba_0), 0, 20154 }, /* JSR.L (d16,PC) */
{ CPUFUNC_FF(op_4ebb_0), 0, 20155 }, /* JSR.L (d8,PC,Xn) */
{ CPUFUNC_FF(op_4ed0_0), 0, 20176 }, /* JMP.L (An) */
{ CPUFUNC_FF(op_4ee8_0), 0, 20200 }, /* JMP.L (d16,An) */
{ CPUFUNC_FF(op_4ef0_0), 0, 20208 }, /* JMP.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4ef8_0), 0, 20216 }, /* JMP.L (xxx).W */
{ CPUFUNC_FF(op_4ef9_0), 0, 20217 }, /* JMP.L (xxx).L */
{ CPUFUNC_FF(op_4efa_0), 0, 20218 }, /* JMP.L (d16,PC) */
{ CPUFUNC_FF(op_4efb_0), 0, 20219 }, /* JMP.L (d8,PC,Xn) */
{ CPUFUNC(op_5000_0), 0, 20480 }, /* ADD.B #<data>,Dn */
{ CPUFUNC(op_5010_0), 0, 20496 }, /* ADD.B #<data>,(An) */
{ CPUFUNC(op_5018_0), 0, 20504 }, /* ADD.B #<data>,(An)+ */
{ CPUFUNC(op_5020_0), 0, 20512 }, /* ADD.B #<data>,-(An) */
{ CPUFUNC(op_5028_0), 0, 20520 }, /* ADD.B #<data>,(d16,An) */
{ CPUFUNC(op_5030_0), 0, 20528 }, /* ADD.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5038_0), 0, 20536 }, /* ADD.B #<data>,(xxx).W */
{ CPUFUNC(op_5039_0), 0, 20537 }, /* ADD.B #<data>,(xxx).L */
{ CPUFUNC(op_5040_0), 0, 20544 }, /* ADD.W #<data>,Dn */
{ CPUFUNC_FF(op_5048_0), 0, 20552 }, /* ADDA.W #<data>,An */
{ CPUFUNC(op_5050_0), 0, 20560 }, /* ADD.W #<data>,(An) */
{ CPUFUNC(op_5058_0), 0, 20568 }, /* ADD.W #<data>,(An)+ */
{ CPUFUNC(op_5060_0), 0, 20576 }, /* ADD.W #<data>,-(An) */
{ CPUFUNC(op_5068_0), 0, 20584 }, /* ADD.W #<data>,(d16,An) */
{ CPUFUNC(op_5070_0), 0, 20592 }, /* ADD.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5078_0), 0, 20600 }, /* ADD.W #<data>,(xxx).W */
{ CPUFUNC(op_5079_0), 0, 20601 }, /* ADD.W #<data>,(xxx).L */
{ CPUFUNC(op_5080_0), 0, 20608 }, /* ADD.L #<data>,Dn */
{ CPUFUNC_FF(op_5088_0), 0, 20616 }, /* ADDA.L #<data>,An */
{ CPUFUNC(op_5090_0), 0, 20624 }, /* ADD.L #<data>,(An) */
{ CPUFUNC(op_5098_0), 0, 20632 }, /* ADD.L #<data>,(An)+ */
{ CPUFUNC(op_50a0_0), 0, 20640 }, /* ADD.L #<data>,-(An) */
{ CPUFUNC(op_50a8_0), 0, 20648 }, /* ADD.L #<data>,(d16,An) */
{ CPUFUNC(op_50b0_0), 0, 20656 }, /* ADD.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_50b8_0), 0, 20664 }, /* ADD.L #<data>,(xxx).W */
{ CPUFUNC(op_50b9_0), 0, 20665 }, /* ADD.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_50c0_0), 0, 20672 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_50c8_0), 0, 20680 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_50d0_0), 0, 20688 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_50d8_0), 0, 20696 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_50e0_0), 0, 20704 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_50e8_0), 0, 20712 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_50f0_0), 0, 20720 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_50f8_0), 0, 20728 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_50f9_0), 0, 20729 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_50fa_0), 0, 20730 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_50fb_0), 0, 20731 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_50fc_0), 0, 20732 }, /* TRAPcc.L  */
{ CPUFUNC(op_5100_0), 0, 20736 }, /* SUB.B #<data>,Dn */
{ CPUFUNC(op_5110_0), 0, 20752 }, /* SUB.B #<data>,(An) */
{ CPUFUNC(op_5118_0), 0, 20760 }, /* SUB.B #<data>,(An)+ */
{ CPUFUNC(op_5120_0), 0, 20768 }, /* SUB.B #<data>,-(An) */
{ CPUFUNC(op_5128_0), 0, 20776 }, /* SUB.B #<data>,(d16,An) */
{ CPUFUNC(op_5130_0), 0, 20784 }, /* SUB.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5138_0), 0, 20792 }, /* SUB.B #<data>,(xxx).W */
{ CPUFUNC(op_5139_0), 0, 20793 }, /* SUB.B #<data>,(xxx).L */
{ CPUFUNC(op_5140_0), 0, 20800 }, /* SUB.W #<data>,Dn */
{ CPUFUNC_FF(op_5148_0), 0, 20808 }, /* SUBA.W #<data>,An */
{ CPUFUNC(op_5150_0), 0, 20816 }, /* SUB.W #<data>,(An) */
{ CPUFUNC(op_5158_0), 0, 20824 }, /* SUB.W #<data>,(An)+ */
{ CPUFUNC(op_5160_0), 0, 20832 }, /* SUB.W #<data>,-(An) */
{ CPUFUNC(op_5168_0), 0, 20840 }, /* SUB.W #<data>,(d16,An) */
{ CPUFUNC(op_5170_0), 0, 20848 }, /* SUB.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5178_0), 0, 20856 }, /* SUB.W #<data>,(xxx).W */
{ CPUFUNC(op_5179_0), 0, 20857 }, /* SUB.W #<data>,(xxx).L */
{ CPUFUNC(op_5180_0), 0, 20864 }, /* SUB.L #<data>,Dn */
{ CPUFUNC_FF(op_5188_0), 0, 20872 }, /* SUBA.L #<data>,An */
{ CPUFUNC(op_5190_0), 0, 20880 }, /* SUB.L #<data>,(An) */
{ CPUFUNC(op_5198_0), 0, 20888 }, /* SUB.L #<data>,(An)+ */
{ CPUFUNC(op_51a0_0), 0, 20896 }, /* SUB.L #<data>,-(An) */
{ CPUFUNC(op_51a8_0), 0, 20904 }, /* SUB.L #<data>,(d16,An) */
{ CPUFUNC(op_51b0_0), 0, 20912 }, /* SUB.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_51b8_0), 0, 20920 }, /* SUB.L #<data>,(xxx).W */
{ CPUFUNC(op_51b9_0), 0, 20921 }, /* SUB.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_51c0_0), 0, 20928 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_51c8_0), 0, 20936 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_51d0_0), 0, 20944 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_51d8_0), 0, 20952 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_51e0_0), 0, 20960 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_51e8_0), 0, 20968 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_51f0_0), 0, 20976 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_51f8_0), 0, 20984 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_51f9_0), 0, 20985 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_51fa_0), 0, 20986 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_51fb_0), 0, 20987 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_51fc_0), 0, 20988 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_52c0_0), 0, 21184 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_52c8_0), 0, 21192 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_52d0_0), 0, 21200 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_52d8_0), 0, 21208 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_52e0_0), 0, 21216 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_52e8_0), 0, 21224 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_52f0_0), 0, 21232 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_52f8_0), 0, 21240 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_52f9_0), 0, 21241 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_52fa_0), 0, 21242 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_52fb_0), 0, 21243 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_52fc_0), 0, 21244 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_53c0_0), 0, 21440 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_53c8_0), 0, 21448 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_53d0_0), 0, 21456 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_53d8_0), 0, 21464 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_53e0_0), 0, 21472 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_53e8_0), 0, 21480 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_53f0_0), 0, 21488 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_53f8_0), 0, 21496 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_53f9_0), 0, 21497 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_53fa_0), 0, 21498 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_53fb_0), 0, 21499 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_53fc_0), 0, 21500 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_54c0_0), 0, 21696 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_54c8_0), 0, 21704 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_54d0_0), 0, 21712 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_54d8_0), 0, 21720 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_54e0_0), 0, 21728 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_54e8_0), 0, 21736 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_54f0_0), 0, 21744 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_54f8_0), 0, 21752 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_54f9_0), 0, 21753 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_54fa_0), 0, 21754 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_54fb_0), 0, 21755 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_54fc_0), 0, 21756 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_55c0_0), 0, 21952 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_55c8_0), 0, 21960 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_55d0_0), 0, 21968 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_55d8_0), 0, 21976 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_55e0_0), 0, 21984 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_55e8_0), 0, 21992 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_55f0_0), 0, 22000 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_55f8_0), 0, 22008 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_55f9_0), 0, 22009 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_55fa_0), 0, 22010 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_55fb_0), 0, 22011 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_55fc_0), 0, 22012 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_56c0_0), 0, 22208 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_56c8_0), 0, 22216 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_56d0_0), 0, 22224 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_56d8_0), 0, 22232 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_56e0_0), 0, 22240 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_56e8_0), 0, 22248 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_56f0_0), 0, 22256 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_56f8_0), 0, 22264 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_56f9_0), 0, 22265 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_56fa_0), 0, 22266 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_56fb_0), 0, 22267 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_56fc_0), 0, 22268 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_57c0_0), 0, 22464 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_57c8_0), 0, 22472 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_57d0_0), 0, 22480 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_57d8_0), 0, 22488 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_57e0_0), 0, 22496 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_57e8_0), 0, 22504 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_57f0_0), 0, 22512 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_57f8_0), 0, 22520 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_57f9_0), 0, 22521 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_57fa_0), 0, 22522 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_57fb_0), 0, 22523 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_57fc_0), 0, 22524 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_58c0_0), 0, 22720 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_58c8_0), 0, 22728 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_58d0_0), 0, 22736 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_58d8_0), 0, 22744 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_58e0_0), 0, 22752 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_58e8_0), 0, 22760 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_58f0_0), 0, 22768 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_58f8_0), 0, 22776 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_58f9_0), 0, 22777 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_58fa_0), 0, 22778 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_58fb_0), 0, 22779 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_58fc_0), 0, 22780 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_59c0_0), 0, 22976 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_59c8_0), 0, 22984 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_59d0_0), 0, 22992 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_59d8_0), 0, 23000 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_59e0_0), 0, 23008 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_59e8_0), 0, 23016 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_59f0_0), 0, 23024 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_59f8_0), 0, 23032 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_59f9_0), 0, 23033 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_59fa_0), 0, 23034 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_59fb_0), 0, 23035 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_59fc_0), 0, 23036 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5ac0_0), 0, 23232 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ac8_0), 0, 23240 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ad0_0), 0, 23248 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ad8_0), 0, 23256 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ae0_0), 0, 23264 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ae8_0), 0, 23272 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5af0_0), 0, 23280 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5af8_0), 0, 23288 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5af9_0), 0, 23289 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5afa_0), 0, 23290 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5afb_0), 0, 23291 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5afc_0), 0, 23292 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5bc0_0), 0, 23488 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5bc8_0), 0, 23496 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5bd0_0), 0, 23504 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5bd8_0), 0, 23512 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5be0_0), 0, 23520 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5be8_0), 0, 23528 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5bf0_0), 0, 23536 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5bf8_0), 0, 23544 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5bf9_0), 0, 23545 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5bfa_0), 0, 23546 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5bfb_0), 0, 23547 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5bfc_0), 0, 23548 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5cc0_0), 0, 23744 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5cc8_0), 0, 23752 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5cd0_0), 0, 23760 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5cd8_0), 0, 23768 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ce0_0), 0, 23776 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ce8_0), 0, 23784 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5cf0_0), 0, 23792 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5cf8_0), 0, 23800 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5cf9_0), 0, 23801 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5cfa_0), 0, 23802 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5cfb_0), 0, 23803 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5cfc_0), 0, 23804 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5dc0_0), 0, 24000 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5dc8_0), 0, 24008 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5dd0_0), 0, 24016 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5dd8_0), 0, 24024 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5de0_0), 0, 24032 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5de8_0), 0, 24040 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5df0_0), 0, 24048 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5df8_0), 0, 24056 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5df9_0), 0, 24057 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5dfa_0), 0, 24058 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5dfb_0), 0, 24059 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5dfc_0), 0, 24060 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5ec0_0), 0, 24256 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ec8_0), 0, 24264 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ed0_0), 0, 24272 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ed8_0), 0, 24280 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ee0_0), 0, 24288 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ee8_0), 0, 24296 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ef0_0), 0, 24304 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ef8_0), 0, 24312 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ef9_0), 0, 24313 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5efa_0), 0, 24314 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5efb_0), 0, 24315 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5efc_0), 0, 24316 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5fc0_0), 0, 24512 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5fc8_0), 0, 24520 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5fd0_0), 0, 24528 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5fd8_0), 0, 24536 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5fe0_0), 0, 24544 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5fe8_0), 0, 24552 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ff0_0), 0, 24560 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ff8_0), 0, 24568 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ff9_0), 0, 24569 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ffa_0), 0, 24570 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5ffb_0), 0, 24571 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5ffc_0), 0, 24572 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_6000_0), 0, 24576 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6001_0), 0, 24577 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_60ff_0), 0, 24831 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6100_0), 0, 24832 }, /* BSR.W #<data>.W */
{ CPUFUNC_FF(op_6101_0), 0, 24833 }, /* BSR.B #<data> */
{ CPUFUNC_FF(op_61ff_0), 0, 25087 }, /* BSR.L #<data>.L */
{ CPUFUNC_FF(op_6200_0), 0, 25088 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6201_0), 0, 25089 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_62ff_0), 0, 25343 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6300_0), 0, 25344 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6301_0), 0, 25345 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_63ff_0), 0, 25599 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6400_0), 0, 25600 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6401_0), 0, 25601 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_64ff_0), 0, 25855 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6500_0), 0, 25856 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6501_0), 0, 25857 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_65ff_0), 0, 26111 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6600_0), 0, 26112 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6601_0), 0, 26113 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_66ff_0), 0, 26367 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6700_0), 0, 26368 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6701_0), 0, 26369 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_67ff_0), 0, 26623 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6800_0), 0, 26624 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6801_0), 0, 26625 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_68ff_0), 0, 26879 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6900_0), 0, 26880 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6901_0), 0, 26881 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_69ff_0), 0, 27135 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6a00_0), 0, 27136 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6a01_0), 0, 27137 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6aff_0), 0, 27391 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6b00_0), 0, 27392 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6b01_0), 0, 27393 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6bff_0), 0, 27647 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6c00_0), 0, 27648 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6c01_0), 0, 27649 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6cff_0), 0, 27903 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6d00_0), 0, 27904 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6d01_0), 0, 27905 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6dff_0), 0, 28159 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6e00_0), 0, 28160 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6e01_0), 0, 28161 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6eff_0), 0, 28415 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6f00_0), 0, 28416 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6f01_0), 0, 28417 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6fff_0), 0, 28671 }, /* Bcc.L #<data>.L */
{ CPUFUNC(op_7000_0), 0, 28672 }, /* MOVE.L #<data>,Dn */
{ CPUFUNC_FF(op_7100_0), 0, 28928 }, /* EMULOP_RETURN.L  */
{ CPUFUNC_FF(op_7101_0), 0, 28929 }, /* EMULOP.L #<data> */
{ CPUFUNC(op_8000_0), 0, 32768 }, /* OR.B Dn,Dn */
{ CPUFUNC(op_8010_0), 0, 32784 }, /* OR.B (An),Dn */
{ CPUFUNC(op_8018_0), 0, 32792 }, /* OR.B (An)+,Dn */
{ CPUFUNC(op_8020_0), 0, 32800 }, /* OR.B -(An),Dn */
{ CPUFUNC(op_8028_0), 0, 32808 }, /* OR.B (d16,An),Dn */
{ CPUFUNC(op_8030_0), 0, 32816 }, /* OR.B (d8,An,Xn),Dn */
{ CPUFUNC(op_8038_0), 0, 32824 }, /* OR.B (xxx).W,Dn */
{ CPUFUNC(op_8039_0), 0, 32825 }, /* OR.B (xxx).L,Dn */
{ CPUFUNC(op_803a_0), 0, 32826 }, /* OR.B (d16,PC),Dn */
{ CPUFUNC(op_803b_0), 0, 32827 }, /* OR.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_803c_0), 0, 32828 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_8040_0), 0, 32832 }, /* OR.W Dn,Dn */
{ CPUFUNC(op_8050_0), 0, 32848 }, /* OR.W (An),Dn */
{ CPUFUNC(op_8058_0), 0, 32856 }, /* OR.W (An)+,Dn */
{ CPUFUNC(op_8060_0), 0, 32864 }, /* OR.W -(An),Dn */
{ CPUFUNC(op_8068_0), 0, 32872 }, /* OR.W (d16,An),Dn */
{ CPUFUNC(op_8070_0), 0, 32880 }, /* OR.W (d8,An,Xn),Dn */
{ CPUFUNC(op_8078_0), 0, 32888 }, /* OR.W (xxx).W,Dn */
{ CPUFUNC(op_8079_0), 0, 32889 }, /* OR.W (xxx).L,Dn */
{ CPUFUNC(op_807a_0), 0, 32890 }, /* OR.W (d16,PC),Dn */
{ CPUFUNC(op_807b_0), 0, 32891 }, /* OR.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_807c_0), 0, 32892 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_8080_0), 0, 32896 }, /* OR.L Dn,Dn */
{ CPUFUNC(op_8090_0), 0, 32912 }, /* OR.L (An),Dn */
{ CPUFUNC(op_8098_0), 0, 32920 }, /* OR.L (An)+,Dn */
{ CPUFUNC(op_80a0_0), 0, 32928 }, /* OR.L -(An),Dn */
{ CPUFUNC(op_80a8_0), 0, 32936 }, /* OR.L (d16,An),Dn */
{ CPUFUNC(op_80b0_0), 0, 32944 }, /* OR.L (d8,An,Xn),Dn */
{ CPUFUNC(op_80b8_0), 0, 32952 }, /* OR.L (xxx).W,Dn */
{ CPUFUNC(op_80b9_0), 0, 32953 }, /* OR.L (xxx).L,Dn */
{ CPUFUNC(op_80ba_0), 0, 32954 }, /* OR.L (d16,PC),Dn */
{ CPUFUNC(op_80bb_0), 0, 32955 }, /* OR.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_80bc_0), 0, 32956 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_80c0_0), 0, 32960 }, /* DIVU.W Dn,Dn */
{ CPUFUNC(op_80d0_0), 0, 32976 }, /* DIVU.W (An),Dn */
{ CPUFUNC(op_80d8_0), 0, 32984 }, /* DIVU.W (An)+,Dn */
{ CPUFUNC(op_80e0_0), 0, 32992 }, /* DIVU.W -(An),Dn */
{ CPUFUNC(op_80e8_0), 0, 33000 }, /* DIVU.W (d16,An),Dn */
{ CPUFUNC(op_80f0_0), 0, 33008 }, /* DIVU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_80f8_0), 0, 33016 }, /* DIVU.W (xxx).W,Dn */
{ CPUFUNC(op_80f9_0), 0, 33017 }, /* DIVU.W (xxx).L,Dn */
{ CPUFUNC(op_80fa_0), 0, 33018 }, /* DIVU.W (d16,PC),Dn */
{ CPUFUNC(op_80fb_0), 0, 33019 }, /* DIVU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_80fc_0), 0, 33020 }, /* DIVU.W #<data>.W,Dn */
{ CPUFUNC(op_8100_0), 0, 33024 }, /* SBCD.B Dn,Dn */
{ CPUFUNC(op_8108_0), 0, 33032 }, /* SBCD.B -(An),-(An) */
{ CPUFUNC(op_8110_0), 0, 33040 }, /* OR.B Dn,(An) */
{ CPUFUNC(op_8118_0), 0, 33048 }, /* OR.B Dn,(An)+ */
{ CPUFUNC(op_8120_0), 0, 33056 }, /* OR.B Dn,-(An) */
{ CPUFUNC(op_8128_0), 0, 33064 }, /* OR.B Dn,(d16,An) */
{ CPUFUNC(op_8130_0), 0, 33072 }, /* OR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_8138_0), 0, 33080 }, /* OR.B Dn,(xxx).W */
{ CPUFUNC(op_8139_0), 0, 33081 }, /* OR.B Dn,(xxx).L */
{ CPUFUNC_FF(op_8140_0), 0, 33088 }, /* PACK.L Dn,Dn */
{ CPUFUNC_FF(op_8148_0), 0, 33096 }, /* PACK.L -(An),-(An) */
{ CPUFUNC(op_8150_0), 0, 33104 }, /* OR.W Dn,(An) */
{ CPUFUNC(op_8158_0), 0, 33112 }, /* OR.W Dn,(An)+ */
{ CPUFUNC(op_8160_0), 0, 33120 }, /* OR.W Dn,-(An) */
{ CPUFUNC(op_8168_0), 0, 33128 }, /* OR.W Dn,(d16,An) */
{ CPUFUNC(op_8170_0), 0, 33136 }, /* OR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_8178_0), 0, 33144 }, /* OR.W Dn,(xxx).W */
{ CPUFUNC(op_8179_0), 0, 33145 }, /* OR.W Dn,(xxx).L */
{ CPUFUNC_FF(op_8180_0), 0, 33152 }, /* UNPK.L Dn,Dn */
{ CPUFUNC_FF(op_8188_0), 0, 33160 }, /* UNPK.L -(An),-(An) */
{ CPUFUNC(op_8190_0), 0, 33168 }, /* OR.L Dn,(An) */
{ CPUFUNC(op_8198_0), 0, 33176 }, /* OR.L Dn,(An)+ */
{ CPUFUNC(op_81a0_0), 0, 33184 }, /* OR.L Dn,-(An) */
{ CPUFUNC(op_81a8_0), 0, 33192 }, /* OR.L Dn,(d16,An) */
{ CPUFUNC(op_81b0_0), 0, 33200 }, /* OR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_81b8_0), 0, 33208 }, /* OR.L Dn,(xxx).W */
{ CPUFUNC(op_81b9_0), 0, 33209 }, /* OR.L Dn,(xxx).L */
{ CPUFUNC(op_81c0_0), 0, 33216 }, /* DIVS.W Dn,Dn */
{ CPUFUNC(op_81d0_0), 0, 33232 }, /* DIVS.W (An),Dn */
{ CPUFUNC(op_81d8_0), 0, 33240 }, /* DIVS.W (An)+,Dn */
{ CPUFUNC(op_81e0_0), 0, 33248 }, /* DIVS.W -(An),Dn */
{ CPUFUNC(op_81e8_0), 0, 33256 }, /* DIVS.W (d16,An),Dn */
{ CPUFUNC(op_81f0_0), 0, 33264 }, /* DIVS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_81f8_0), 0, 33272 }, /* DIVS.W (xxx).W,Dn */
{ CPUFUNC(op_81f9_0), 0, 33273 }, /* DIVS.W (xxx).L,Dn */
{ CPUFUNC(op_81fa_0), 0, 33274 }, /* DIVS.W (d16,PC),Dn */
{ CPUFUNC(op_81fb_0), 0, 33275 }, /* DIVS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_81fc_0), 0, 33276 }, /* DIVS.W #<data>.W,Dn */
{ CPUFUNC(op_9000_0), 0, 36864 }, /* SUB.B Dn,Dn */
{ CPUFUNC(op_9010_0), 0, 36880 }, /* SUB.B (An),Dn */
{ CPUFUNC(op_9018_0), 0, 36888 }, /* SUB.B (An)+,Dn */
{ CPUFUNC(op_9020_0), 0, 36896 }, /* SUB.B -(An),Dn */
{ CPUFUNC(op_9028_0), 0, 36904 }, /* SUB.B (d16,An),Dn */
{ CPUFUNC(op_9030_0), 0, 36912 }, /* SUB.B (d8,An,Xn),Dn */
{ CPUFUNC(op_9038_0), 0, 36920 }, /* SUB.B (xxx).W,Dn */
{ CPUFUNC(op_9039_0), 0, 36921 }, /* SUB.B (xxx).L,Dn */
{ CPUFUNC(op_903a_0), 0, 36922 }, /* SUB.B (d16,PC),Dn */
{ CPUFUNC(op_903b_0), 0, 36923 }, /* SUB.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_903c_0), 0, 36924 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_9040_0), 0, 36928 }, /* SUB.W Dn,Dn */
{ CPUFUNC(op_9048_0), 0, 36936 }, /* SUB.W An,Dn */
{ CPUFUNC(op_9050_0), 0, 36944 }, /* SUB.W (An),Dn */
{ CPUFUNC(op_9058_0), 0, 36952 }, /* SUB.W (An)+,Dn */
{ CPUFUNC(op_9060_0), 0, 36960 }, /* SUB.W -(An),Dn */
{ CPUFUNC(op_9068_0), 0, 36968 }, /* SUB.W (d16,An),Dn */
{ CPUFUNC(op_9070_0), 0, 36976 }, /* SUB.W (d8,An,Xn),Dn */
{ CPUFUNC(op_9078_0), 0, 36984 }, /* SUB.W (xxx).W,Dn */
{ CPUFUNC(op_9079_0), 0, 36985 }, /* SUB.W (xxx).L,Dn */
{ CPUFUNC(op_907a_0), 0, 36986 }, /* SUB.W (d16,PC),Dn */
{ CPUFUNC(op_907b_0), 0, 36987 }, /* SUB.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_907c_0), 0, 36988 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_9080_0), 0, 36992 }, /* SUB.L Dn,Dn */
{ CPUFUNC(op_9088_0), 0, 37000 }, /* SUB.L An,Dn */
{ CPUFUNC(op_9090_0), 0, 37008 }, /* SUB.L (An),Dn */
{ CPUFUNC(op_9098_0), 0, 37016 }, /* SUB.L (An)+,Dn */
{ CPUFUNC(op_90a0_0), 0, 37024 }, /* SUB.L -(An),Dn */
{ CPUFUNC(op_90a8_0), 0, 37032 }, /* SUB.L (d16,An),Dn */
{ CPUFUNC(op_90b0_0), 0, 37040 }, /* SUB.L (d8,An,Xn),Dn */
{ CPUFUNC(op_90b8_0), 0, 37048 }, /* SUB.L (xxx).W,Dn */
{ CPUFUNC(op_90b9_0), 0, 37049 }, /* SUB.L (xxx).L,Dn */
{ CPUFUNC(op_90ba_0), 0, 37050 }, /* SUB.L (d16,PC),Dn */
{ CPUFUNC(op_90bb_0), 0, 37051 }, /* SUB.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_90bc_0), 0, 37052 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC_FF(op_90c0_0), 0, 37056 }, /* SUBA.W Dn,An */
{ CPUFUNC_FF(op_90c8_0), 0, 37064 }, /* SUBA.W An,An */
{ CPUFUNC_FF(op_90d0_0), 0, 37072 }, /* SUBA.W (An),An */
{ CPUFUNC_FF(op_90d8_0), 0, 37080 }, /* SUBA.W (An)+,An */
{ CPUFUNC_FF(op_90e0_0), 0, 37088 }, /* SUBA.W -(An),An */
{ CPUFUNC_FF(op_90e8_0), 0, 37096 }, /* SUBA.W (d16,An),An */
{ CPUFUNC_FF(op_90f0_0), 0, 37104 }, /* SUBA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_90f8_0), 0, 37112 }, /* SUBA.W (xxx).W,An */
{ CPUFUNC_FF(op_90f9_0), 0, 37113 }, /* SUBA.W (xxx).L,An */
{ CPUFUNC_FF(op_90fa_0), 0, 37114 }, /* SUBA.W (d16,PC),An */
{ CPUFUNC_FF(op_90fb_0), 0, 37115 }, /* SUBA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_90fc_0), 0, 37116 }, /* SUBA.W #<data>.W,An */
{ CPUFUNC(op_9100_0), 0, 37120 }, /* SUBX.B Dn,Dn */
{ CPUFUNC(op_9108_0), 0, 37128 }, /* SUBX.B -(An),-(An) */
{ CPUFUNC(op_9110_0), 0, 37136 }, /* SUB.B Dn,(An) */
{ CPUFUNC(op_9118_0), 0, 37144 }, /* SUB.B Dn,(An)+ */
{ CPUFUNC(op_9120_0), 0, 37152 }, /* SUB.B Dn,-(An) */
{ CPUFUNC(op_9128_0), 0, 37160 }, /* SUB.B Dn,(d16,An) */
{ CPUFUNC(op_9130_0), 0, 37168 }, /* SUB.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_9138_0), 0, 37176 }, /* SUB.B Dn,(xxx).W */
{ CPUFUNC(op_9139_0), 0, 37177 }, /* SUB.B Dn,(xxx).L */
{ CPUFUNC(op_9140_0), 0, 37184 }, /* SUBX.W Dn,Dn */
{ CPUFUNC(op_9148_0), 0, 37192 }, /* SUBX.W -(An),-(An) */
{ CPUFUNC(op_9150_0), 0, 37200 }, /* SUB.W Dn,(An) */
{ CPUFUNC(op_9158_0), 0, 37208 }, /* SUB.W Dn,(An)+ */
{ CPUFUNC(op_9160_0), 0, 37216 }, /* SUB.W Dn,-(An) */
{ CPUFUNC(op_9168_0), 0, 37224 }, /* SUB.W Dn,(d16,An) */
{ CPUFUNC(op_9170_0), 0, 37232 }, /* SUB.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_9178_0), 0, 37240 }, /* SUB.W Dn,(xxx).W */
{ CPUFUNC(op_9179_0), 0, 37241 }, /* SUB.W Dn,(xxx).L */
{ CPUFUNC(op_9180_0), 0, 37248 }, /* SUBX.L Dn,Dn */
{ CPUFUNC(op_9188_0), 0, 37256 }, /* SUBX.L -(An),-(An) */
{ CPUFUNC(op_9190_0), 0, 37264 }, /* SUB.L Dn,(An) */
{ CPUFUNC(op_9198_0), 0, 37272 }, /* SUB.L Dn,(An)+ */
{ CPUFUNC(op_91a0_0), 0, 37280 }, /* SUB.L Dn,-(An) */
{ CPUFUNC(op_91a8_0), 0, 37288 }, /* SUB.L Dn,(d16,An) */
{ CPUFUNC(op_91b0_0), 0, 37296 }, /* SUB.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_91b8_0), 0, 37304 }, /* SUB.L Dn,(xxx).W */
{ CPUFUNC(op_91b9_0), 0, 37305 }, /* SUB.L Dn,(xxx).L */
{ CPUFUNC_FF(op_91c0_0), 0, 37312 }, /* SUBA.L Dn,An */
{ CPUFUNC_FF(op_91c8_0), 0, 37320 }, /* SUBA.L An,An */
{ CPUFUNC_FF(op_91d0_0), 0, 37328 }, /* SUBA.L (An),An */
{ CPUFUNC_FF(op_91d8_0), 0, 37336 }, /* SUBA.L (An)+,An */
{ CPUFUNC_FF(op_91e0_0), 0, 37344 }, /* SUBA.L -(An),An */
{ CPUFUNC_FF(op_91e8_0), 0, 37352 }, /* SUBA.L (d16,An),An */
{ CPUFUNC_FF(op_91f0_0), 0, 37360 }, /* SUBA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_91f8_0), 0, 37368 }, /* SUBA.L (xxx).W,An */
{ CPUFUNC_FF(op_91f9_0), 0, 37369 }, /* SUBA.L (xxx).L,An */
{ CPUFUNC_FF(op_91fa_0), 0, 37370 }, /* SUBA.L (d16,PC),An */
{ CPUFUNC_FF(op_91fb_0), 0, 37371 }, /* SUBA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_91fc_0), 0, 37372 }, /* SUBA.L #<data>.L,An */
{ CPUFUNC(op_b000_0), 0, 45056 }, /* CMP.B Dn,Dn */
{ CPUFUNC(op_b010_0), 0, 45072 }, /* CMP.B (An),Dn */
{ CPUFUNC(op_b018_0), 0, 45080 }, /* CMP.B (An)+,Dn */
{ CPUFUNC(op_b020_0), 0, 45088 }, /* CMP.B -(An),Dn */
{ CPUFUNC(op_b028_0), 0, 45096 }, /* CMP.B (d16,An),Dn */
{ CPUFUNC(op_b030_0), 0, 45104 }, /* CMP.B (d8,An,Xn),Dn */
{ CPUFUNC(op_b038_0), 0, 45112 }, /* CMP.B (xxx).W,Dn */
{ CPUFUNC(op_b039_0), 0, 45113 }, /* CMP.B (xxx).L,Dn */
{ CPUFUNC(op_b03a_0), 0, 45114 }, /* CMP.B (d16,PC),Dn */
{ CPUFUNC(op_b03b_0), 0, 45115 }, /* CMP.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_b03c_0), 0, 45116 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_b040_0), 0, 45120 }, /* CMP.W Dn,Dn */
{ CPUFUNC(op_b048_0), 0, 45128 }, /* CMP.W An,Dn */
{ CPUFUNC(op_b050_0), 0, 45136 }, /* CMP.W (An),Dn */
{ CPUFUNC(op_b058_0), 0, 45144 }, /* CMP.W (An)+,Dn */
{ CPUFUNC(op_b060_0), 0, 45152 }, /* CMP.W -(An),Dn */
{ CPUFUNC(op_b068_0), 0, 45160 }, /* CMP.W (d16,An),Dn */
{ CPUFUNC(op_b070_0), 0, 45168 }, /* CMP.W (d8,An,Xn),Dn */
{ CPUFUNC(op_b078_0), 0, 45176 }, /* CMP.W (xxx).W,Dn */
{ CPUFUNC(op_b079_0), 0, 45177 }, /* CMP.W (xxx).L,Dn */
{ CPUFUNC(op_b07a_0), 0, 45178 }, /* CMP.W (d16,PC),Dn */
{ CPUFUNC(op_b07b_0), 0, 45179 }, /* CMP.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_b07c_0), 0, 45180 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_b080_0), 0, 45184 }, /* CMP.L Dn,Dn */
{ CPUFUNC(op_b088_0), 0, 45192 }, /* CMP.L An,Dn */
{ CPUFUNC(op_b090_0), 0, 45200 }, /* CMP.L (An),Dn */
{ CPUFUNC(op_b098_0), 0, 45208 }, /* CMP.L (An)+,Dn */
{ CPUFUNC(op_b0a0_0), 0, 45216 }, /* CMP.L -(An),Dn */
{ CPUFUNC(op_b0a8_0), 0, 45224 }, /* CMP.L (d16,An),Dn */
{ CPUFUNC(op_b0b0_0), 0, 45232 }, /* CMP.L (d8,An,Xn),Dn */
{ CPUFUNC(op_b0b8_0), 0, 45240 }, /* CMP.L (xxx).W,Dn */
{ CPUFUNC(op_b0b9_0), 0, 45241 }, /* CMP.L (xxx).L,Dn */
{ CPUFUNC(op_b0ba_0), 0, 45242 }, /* CMP.L (d16,PC),Dn */
{ CPUFUNC(op_b0bb_0), 0, 45243 }, /* CMP.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_b0bc_0), 0, 45244 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_b0c0_0), 0, 45248 }, /* CMPA.W Dn,An */
{ CPUFUNC(op_b0c8_0), 0, 45256 }, /* CMPA.W An,An */
{ CPUFUNC(op_b0d0_0), 0, 45264 }, /* CMPA.W (An),An */
{ CPUFUNC(op_b0d8_0), 0, 45272 }, /* CMPA.W (An)+,An */
{ CPUFUNC(op_b0e0_0), 0, 45280 }, /* CMPA.W -(An),An */
{ CPUFUNC(op_b0e8_0), 0, 45288 }, /* CMPA.W (d16,An),An */
{ CPUFUNC(op_b0f0_0), 0, 45296 }, /* CMPA.W (d8,An,Xn),An */
{ CPUFUNC(op_b0f8_0), 0, 45304 }, /* CMPA.W (xxx).W,An */
{ CPUFUNC(op_b0f9_0), 0, 45305 }, /* CMPA.W (xxx).L,An */
{ CPUFUNC(op_b0fa_0), 0, 45306 }, /* CMPA.W (d16,PC),An */
{ CPUFUNC(op_b0fb_0), 0, 45307 }, /* CMPA.W (d8,PC,Xn),An */
{ CPUFUNC(op_b0fc_0), 0, 45308 }, /* CMPA.W #<data>.W,An */
{ CPUFUNC(op_b100_0), 0, 45312 }, /* EOR.B Dn,Dn */
{ CPUFUNC(op_b108_0), 0, 45320 }, /* CMPM.B (An)+,(An)+ */
{ CPUFUNC(op_b110_0), 0, 45328 }, /* EOR.B Dn,(An) */
{ CPUFUNC(op_b118_0), 0, 45336 }, /* EOR.B Dn,(An)+ */
{ CPUFUNC(op_b120_0), 0, 45344 }, /* EOR.B Dn,-(An) */
{ CPUFUNC(op_b128_0), 0, 45352 }, /* EOR.B Dn,(d16,An) */
{ CPUFUNC(op_b130_0), 0, 45360 }, /* EOR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_b138_0), 0, 45368 }, /* EOR.B Dn,(xxx).W */
{ CPUFUNC(op_b139_0), 0, 45369 }, /* EOR.B Dn,(xxx).L */
{ CPUFUNC(op_b140_0), 0, 45376 }, /* EOR.W Dn,Dn */
{ CPUFUNC(op_b148_0), 0, 45384 }, /* CMPM.W (An)+,(An)+ */
{ CPUFUNC(op_b150_0), 0, 45392 }, /* EOR.W Dn,(An) */
{ CPUFUNC(op_b158_0), 0, 45400 }, /* EOR.W Dn,(An)+ */
{ CPUFUNC(op_b160_0), 0, 45408 }, /* EOR.W Dn,-(An) */
{ CPUFUNC(op_b168_0), 0, 45416 }, /* EOR.W Dn,(d16,An) */
{ CPUFUNC(op_b170_0), 0, 45424 }, /* EOR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_b178_0), 0, 45432 }, /* EOR.W Dn,(xxx).W */
{ CPUFUNC(op_b179_0), 0, 45433 }, /* EOR.W Dn,(xxx).L */
{ CPUFUNC(op_b180_0), 0, 45440 }, /* EOR.L Dn,Dn */
{ CPUFUNC(op_b188_0), 0, 45448 }, /* CMPM.L (An)+,(An)+ */
{ CPUFUNC(op_b190_0), 0, 45456 }, /* EOR.L Dn,(An) */
{ CPUFUNC(op_b198_0), 0, 45464 }, /* EOR.L Dn,(An)+ */
{ CPUFUNC(op_b1a0_0), 0, 45472 }, /* EOR.L Dn,-(An) */
{ CPUFUNC(op_b1a8_0), 0, 45480 }, /* EOR.L Dn,(d16,An) */
{ CPUFUNC(op_b1b0_0), 0, 45488 }, /* EOR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_b1b8_0), 0, 45496 }, /* EOR.L Dn,(xxx).W */
{ CPUFUNC(op_b1b9_0), 0, 45497 }, /* EOR.L Dn,(xxx).L */
{ CPUFUNC(op_b1c0_0), 0, 45504 }, /* CMPA.L Dn,An */
{ CPUFUNC(op_b1c8_0), 0, 45512 }, /* CMPA.L An,An */
{ CPUFUNC(op_b1d0_0), 0, 45520 }, /* CMPA.L (An),An */
{ CPUFUNC(op_b1d8_0), 0, 45528 }, /* CMPA.L (An)+,An */
{ CPUFUNC(op_b1e0_0), 0, 45536 }, /* CMPA.L -(An),An */
{ CPUFUNC(op_b1e8_0), 0, 45544 }, /* CMPA.L (d16,An),An */
{ CPUFUNC(op_b1f0_0), 0, 45552 }, /* CMPA.L (d8,An,Xn),An */
{ CPUFUNC(op_b1f8_0), 0, 45560 }, /* CMPA.L (xxx).W,An */
{ CPUFUNC(op_b1f9_0), 0, 45561 }, /* CMPA.L (xxx).L,An */
{ CPUFUNC(op_b1fa_0), 0, 45562 }, /* CMPA.L (d16,PC),An */
{ CPUFUNC(op_b1fb_0), 0, 45563 }, /* CMPA.L (d8,PC,Xn),An */
{ CPUFUNC(op_b1fc_0), 0, 45564 }, /* CMPA.L #<data>.L,An */
{ CPUFUNC(op_c000_0), 0, 49152 }, /* AND.B Dn,Dn */
{ CPUFUNC(op_c010_0), 0, 49168 }, /* AND.B (An),Dn */
{ CPUFUNC(op_c018_0), 0, 49176 }, /* AND.B (An)+,Dn */
{ CPUFUNC(op_c020_0), 0, 49184 }, /* AND.B -(An),Dn */
{ CPUFUNC(op_c028_0), 0, 49192 }, /* AND.B (d16,An),Dn */
{ CPUFUNC(op_c030_0), 0, 49200 }, /* AND.B (d8,An,Xn),Dn */
{ CPUFUNC(op_c038_0), 0, 49208 }, /* AND.B (xxx).W,Dn */
{ CPUFUNC(op_c039_0), 0, 49209 }, /* AND.B (xxx).L,Dn */
{ CPUFUNC(op_c03a_0), 0, 49210 }, /* AND.B (d16,PC),Dn */
{ CPUFUNC(op_c03b_0), 0, 49211 }, /* AND.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_c03c_0), 0, 49212 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_c040_0), 0, 49216 }, /* AND.W Dn,Dn */
{ CPUFUNC(op_c050_0), 0, 49232 }, /* AND.W (An),Dn */
{ CPUFUNC(op_c058_0), 0, 49240 }, /* AND.W (An)+,Dn */
{ CPUFUNC(op_c060_0), 0, 49248 }, /* AND.W -(An),Dn */
{ CPUFUNC(op_c068_0), 0, 49256 }, /* AND.W (d16,An),Dn */
{ CPUFUNC(op_c070_0), 0, 49264 }, /* AND.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c078_0), 0, 49272 }, /* AND.W (xxx).W,Dn */
{ CPUFUNC(op_c079_0), 0, 49273 }, /* AND.W (xxx).L,Dn */
{ CPUFUNC(op_c07a_0), 0, 49274 }, /* AND.W (d16,PC),Dn */
{ CPUFUNC(op_c07b_0), 0, 49275 }, /* AND.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c07c_0), 0, 49276 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_c080_0), 0, 49280 }, /* AND.L Dn,Dn */
{ CPUFUNC(op_c090_0), 0, 49296 }, /* AND.L (An),Dn */
{ CPUFUNC(op_c098_0), 0, 49304 }, /* AND.L (An)+,Dn */
{ CPUFUNC(op_c0a0_0), 0, 49312 }, /* AND.L -(An),Dn */
{ CPUFUNC(op_c0a8_0), 0, 49320 }, /* AND.L (d16,An),Dn */
{ CPUFUNC(op_c0b0_0), 0, 49328 }, /* AND.L (d8,An,Xn),Dn */
{ CPUFUNC(op_c0b8_0), 0, 49336 }, /* AND.L (xxx).W,Dn */
{ CPUFUNC(op_c0b9_0), 0, 49337 }, /* AND.L (xxx).L,Dn */
{ CPUFUNC(op_c0ba_0), 0, 49338 }, /* AND.L (d16,PC),Dn */
{ CPUFUNC(op_c0bb_0), 0, 49339 }, /* AND.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0bc_0), 0, 49340 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_c0c0_0), 0, 49344 }, /* MULU.W Dn,Dn */
{ CPUFUNC(op_c0d0_0), 0, 49360 }, /* MULU.W (An),Dn */
{ CPUFUNC(op_c0d8_0), 0, 49368 }, /* MULU.W (An)+,Dn */
{ CPUFUNC(op_c0e0_0), 0, 49376 }, /* MULU.W -(An),Dn */
{ CPUFUNC(op_c0e8_0), 0, 49384 }, /* MULU.W (d16,An),Dn */
{ CPUFUNC(op_c0f0_0), 0, 49392 }, /* MULU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c0f8_0), 0, 49400 }, /* MULU.W (xxx).W,Dn */
{ CPUFUNC(op_c0f9_0), 0, 49401 }, /* MULU.W (xxx).L,Dn */
{ CPUFUNC(op_c0fa_0), 0, 49402 }, /* MULU.W (d16,PC),Dn */
{ CPUFUNC(op_c0fb_0), 0, 49403 }, /* MULU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0fc_0), 0, 49404 }, /* MULU.W #<data>.W,Dn */
{ CPUFUNC(op_c100_0), 0, 49408 }, /* ABCD.B Dn,Dn */
{ CPUFUNC(op_c108_0), 0, 49416 }, /* ABCD.B -(An),-(An) */
{ CPUFUNC(op_c110_0), 0, 49424 }, /* AND.B Dn,(An) */
{ CPUFUNC(op_c118_0), 0, 49432 }, /* AND.B Dn,(An)+ */
{ CPUFUNC(op_c120_0), 0, 49440 }, /* AND.B Dn,-(An) */
{ CPUFUNC(op_c128_0), 0, 49448 }, /* AND.B Dn,(d16,An) */
{ CPUFUNC(op_c130_0), 0, 49456 }, /* AND.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_c138_0), 0, 49464 }, /* AND.B Dn,(xxx).W */
{ CPUFUNC(op_c139_0), 0, 49465 }, /* AND.B Dn,(xxx).L */
{ CPUFUNC_FF(op_c140_0), 0, 49472 }, /* EXG.L Dn,Dn */
{ CPUFUNC_FF(op_c148_0), 0, 49480 }, /* EXG.L An,An */
{ CPUFUNC(op_c150_0), 0, 49488 }, /* AND.W Dn,(An) */
{ CPUFUNC(op_c158_0), 0, 49496 }, /* AND.W Dn,(An)+ */
{ CPUFUNC(op_c160_0), 0, 49504 }, /* AND.W Dn,-(An) */
{ CPUFUNC(op_c168_0), 0, 49512 }, /* AND.W Dn,(d16,An) */
{ CPUFUNC(op_c170_0), 0, 49520 }, /* AND.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_c178_0), 0, 49528 }, /* AND.W Dn,(xxx).W */
{ CPUFUNC(op_c179_0), 0, 49529 }, /* AND.W Dn,(xxx).L */
{ CPUFUNC_FF(op_c188_0), 0, 49544 }, /* EXG.L Dn,An */
{ CPUFUNC(op_c190_0), 0, 49552 }, /* AND.L Dn,(An) */
{ CPUFUNC(op_c198_0), 0, 49560 }, /* AND.L Dn,(An)+ */
{ CPUFUNC(op_c1a0_0), 0, 49568 }, /* AND.L Dn,-(An) */
{ CPUFUNC(op_c1a8_0), 0, 49576 }, /* AND.L Dn,(d16,An) */
{ CPUFUNC(op_c1b0_0), 0, 49584 }, /* AND.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_c1b8_0), 0, 49592 }, /* AND.L Dn,(xxx).W */
{ CPUFUNC(op_c1b9_0), 0, 49593 }, /* AND.L Dn,(xxx).L */
{ CPUFUNC(op_c1c0_0), 0, 49600 }, /* MULS.W Dn,Dn */
{ CPUFUNC(op_c1d0_0), 0, 49616 }, /* MULS.W (An),Dn */
{ CPUFUNC(op_c1d8_0), 0, 49624 }, /* MULS.W (An)+,Dn */
{ CPUFUNC(op_c1e0_0), 0, 49632 }, /* MULS.W -(An),Dn */
{ CPUFUNC(op_c1e8_0), 0, 49640 }, /* MULS.W (d16,An),Dn */
{ CPUFUNC(op_c1f0_0), 0, 49648 }, /* MULS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c1f8_0), 0, 49656 }, /* MULS.W (xxx).W,Dn */
{ CPUFUNC(op_c1f9_0), 0, 49657 }, /* MULS.W (xxx).L,Dn */
{ CPUFUNC(op_c1fa_0), 0, 49658 }, /* MULS.W (d16,PC),Dn */
{ CPUFUNC(op_c1fb_0), 0, 49659 }, /* MULS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c1fc_0), 0, 49660 }, /* MULS.W #<data>.W,Dn */
{ CPUFUNC(op_d000_0), 0, 53248 }, /* ADD.B Dn,Dn */
{ CPUFUNC(op_d010_0), 0, 53264 }, /* ADD.B (An),Dn */
{ CPUFUNC(op_d018_0), 0, 53272 }, /* ADD.B (An)+,Dn */
{ CPUFUNC(op_d020_0), 0, 53280 }, /* ADD.B -(An),Dn */
{ CPUFUNC(op_d028_0), 0, 53288 }, /* ADD.B (d16,An),Dn */
{ CPUFUNC(op_d030_0), 0, 53296 }, /* ADD.B (d8,An,Xn),Dn */
{ CPUFUNC(op_d038_0), 0, 53304 }, /* ADD.B (xxx).W,Dn */
{ CPUFUNC(op_d039_0), 0, 53305 }, /* ADD.B (xxx).L,Dn */
{ CPUFUNC(op_d03a_0), 0, 53306 }, /* ADD.B (d16,PC),Dn */
{ CPUFUNC(op_d03b_0), 0, 53307 }, /* ADD.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_d03c_0), 0, 53308 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_d040_0), 0, 53312 }, /* ADD.W Dn,Dn */
{ CPUFUNC(op_d048_0), 0, 53320 }, /* ADD.W An,Dn */
{ CPUFUNC(op_d050_0), 0, 53328 }, /* ADD.W (An),Dn */
{ CPUFUNC(op_d058_0), 0, 53336 }, /* ADD.W (An)+,Dn */
{ CPUFUNC(op_d060_0), 0, 53344 }, /* ADD.W -(An),Dn */
{ CPUFUNC(op_d068_0), 0, 53352 }, /* ADD.W (d16,An),Dn */
{ CPUFUNC(op_d070_0), 0, 53360 }, /* ADD.W (d8,An,Xn),Dn */
{ CPUFUNC(op_d078_0), 0, 53368 }, /* ADD.W (xxx).W,Dn */
{ CPUFUNC(op_d079_0), 0, 53369 }, /* ADD.W (xxx).L,Dn */
{ CPUFUNC(op_d07a_0), 0, 53370 }, /* ADD.W (d16,PC),Dn */
{ CPUFUNC(op_d07b_0), 0, 53371 }, /* ADD.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_d07c_0), 0, 53372 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_d080_0), 0, 53376 }, /* ADD.L Dn,Dn */
{ CPUFUNC(op_d088_0), 0, 53384 }, /* ADD.L An,Dn */
{ CPUFUNC(op_d090_0), 0, 53392 }, /* ADD.L (An),Dn */
{ CPUFUNC(op_d098_0), 0, 53400 }, /* ADD.L (An)+,Dn */
{ CPUFUNC(op_d0a0_0), 0, 53408 }, /* ADD.L -(An),Dn */
{ CPUFUNC(op_d0a8_0), 0, 53416 }, /* ADD.L (d16,An),Dn */
{ CPUFUNC(op_d0b0_0), 0, 53424 }, /* ADD.L (d8,An,Xn),Dn */
{ CPUFUNC(op_d0b8_0), 0, 53432 }, /* ADD.L (xxx).W,Dn */
{ CPUFUNC(op_d0b9_0), 0, 53433 }, /* ADD.L (xxx).L,Dn */
{ CPUFUNC(op_d0ba_0), 0, 53434 }, /* ADD.L (d16,PC),Dn */
{ CPUFUNC(op_d0bb_0), 0, 53435 }, /* ADD.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_d0bc_0), 0, 53436 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC_FF(op_d0c0_0), 0, 53440 }, /* ADDA.W Dn,An */
{ CPUFUNC_FF(op_d0c8_0), 0, 53448 }, /* ADDA.W An,An */
{ CPUFUNC_FF(op_d0d0_0), 0, 53456 }, /* ADDA.W (An),An */
{ CPUFUNC_FF(op_d0d8_0), 0, 53464 }, /* ADDA.W (An)+,An */
{ CPUFUNC_FF(op_d0e0_0), 0, 53472 }, /* ADDA.W -(An),An */
{ CPUFUNC_FF(op_d0e8_0), 0, 53480 }, /* ADDA.W (d16,An),An */
{ CPUFUNC_FF(op_d0f0_0), 0, 53488 }, /* ADDA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_d0f8_0), 0, 53496 }, /* ADDA.W (xxx).W,An */
{ CPUFUNC_FF(op_d0f9_0), 0, 53497 }, /* ADDA.W (xxx).L,An */
{ CPUFUNC_FF(op_d0fa_0), 0, 53498 }, /* ADDA.W (d16,PC),An */
{ CPUFUNC_FF(op_d0fb_0), 0, 53499 }, /* ADDA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d0fc_0), 0, 53500 }, /* ADDA.W #<data>.W,An */
{ CPUFUNC(op_d100_0), 0, 53504 }, /* ADDX.B Dn,Dn */
{ CPUFUNC(op_d108_0), 0, 53512 }, /* ADDX.B -(An),-(An) */
{ CPUFUNC(op_d110_0), 0, 53520 }, /* ADD.B Dn,(An) */
{ CPUFUNC(op_d118_0), 0, 53528 }, /* ADD.B Dn,(An)+ */
{ CPUFUNC(op_d120_0), 0, 53536 }, /* ADD.B Dn,-(An) */
{ CPUFUNC(op_d128_0), 0, 53544 }, /* ADD.B Dn,(d16,An) */
{ CPUFUNC(op_d130_0), 0, 53552 }, /* ADD.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_d138_0), 0, 53560 }, /* ADD.B Dn,(xxx).W */
{ CPUFUNC(op_d139_0), 0, 53561 }, /* ADD.B Dn,(xxx).L */
{ CPUFUNC(op_d140_0), 0, 53568 }, /* ADDX.W Dn,Dn */
{ CPUFUNC(op_d148_0), 0, 53576 }, /* ADDX.W -(An),-(An) */
{ CPUFUNC(op_d150_0), 0, 53584 }, /* ADD.W Dn,(An) */
{ CPUFUNC(op_d158_0), 0, 53592 }, /* ADD.W Dn,(An)+ */
{ CPUFUNC(op_d160_0), 0, 53600 }, /* ADD.W Dn,-(An) */
{ CPUFUNC(op_d168_0), 0, 53608 }, /* ADD.W Dn,(d16,An) */
{ CPUFUNC(op_d170_0), 0, 53616 }, /* ADD.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_d178_0), 0, 53624 }, /* ADD.W Dn,(xxx).W */
{ CPUFUNC(op_d179_0), 0, 53625 }, /* ADD.W Dn,(xxx).L */
{ CPUFUNC(op_d180_0), 0, 53632 }, /* ADDX.L Dn,Dn */
{ CPUFUNC(op_d188_0), 0, 53640 }, /* ADDX.L -(An),-(An) */
{ CPUFUNC(op_d190_0), 0, 53648 }, /* ADD.L Dn,(An) */
{ CPUFUNC(op_d198_0), 0, 53656 }, /* ADD.L Dn,(An)+ */
{ CPUFUNC(op_d1a0_0), 0, 53664 }, /* ADD.L Dn,-(An) */
{ CPUFUNC(op_d1a8_0), 0, 53672 }, /* ADD.L Dn,(d16,An) */
{ CPUFUNC(op_d1b0_0), 0, 53680 }, /* ADD.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_d1b8_0), 0, 53688 }, /* ADD.L Dn,(xxx).W */
{ CPUFUNC(op_d1b9_0), 0, 53689 }, /* ADD.L Dn,(xxx).L */
{ CPUFUNC_FF(op_d1c0_0), 0, 53696 }, /* ADDA.L Dn,An */
{ CPUFUNC_FF(op_d1c8_0), 0, 53704 }, /* ADDA.L An,An */
{ CPUFUNC_FF(op_d1d0_0), 0, 53712 }, /* ADDA.L (An),An */
{ CPUFUNC_FF(op_d1d8_0), 0, 53720 }, /* ADDA.L (An)+,An */
{ CPUFUNC_FF(op_d1e0_0), 0, 53728 }, /* ADDA.L -(An),An */
{ CPUFUNC_FF(op_d1e8_0), 0, 53736 }, /* ADDA.L (d16,An),An */
{ CPUFUNC_FF(op_d1f0_0), 0, 53744 }, /* ADDA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_d1f8_0), 0, 53752 }, /* ADDA.L (xxx).W,An */
{ CPUFUNC_FF(op_d1f9_0), 0, 53753 }, /* ADDA.L (xxx).L,An */
{ CPUFUNC_FF(op_d1fa_0), 0, 53754 }, /* ADDA.L (d16,PC),An */
{ CPUFUNC_FF(op_d1fb_0), 0, 53755 }, /* ADDA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d1fc_0), 0, 53756 }, /* ADDA.L #<data>.L,An */
{ CPUFUNC(op_e000_0), 0, 57344 }, /* ASR.B #<data>,Dn */
{ CPUFUNC(op_e008_0), 0, 57352 }, /* LSR.B #<data>,Dn */
{ CPUFUNC(op_e010_0), 0, 57360 }, /* ROXR.B #<data>,Dn */
{ CPUFUNC(op_e018_0), 0, 57368 }, /* ROR.B #<data>,Dn */
{ CPUFUNC(op_e020_0), 0, 57376 }, /* ASR.B Dn,Dn */
{ CPUFUNC(op_e028_0), 0, 57384 }, /* LSR.B Dn,Dn */
{ CPUFUNC(op_e030_0), 0, 57392 }, /* ROXR.B Dn,Dn */
{ CPUFUNC(op_e038_0), 0, 57400 }, /* ROR.B Dn,Dn */
{ CPUFUNC(op_e040_0), 0, 57408 }, /* ASR.W #<data>,Dn */
{ CPUFUNC(op_e048_0), 0, 57416 }, /* LSR.W #<data>,Dn */
{ CPUFUNC(op_e050_0), 0, 57424 }, /* ROXR.W #<data>,Dn */
{ CPUFUNC(op_e058_0), 0, 57432 }, /* ROR.W #<data>,Dn */
{ CPUFUNC(op_e060_0), 0, 57440 }, /* ASR.W Dn,Dn */
{ CPUFUNC(op_e068_0), 0, 57448 }, /* LSR.W Dn,Dn */
{ CPUFUNC(op_e070_0), 0, 57456 }, /* ROXR.W Dn,Dn */
{ CPUFUNC(op_e078_0), 0, 57464 }, /* ROR.W Dn,Dn */
{ CPUFUNC(op_e080_0), 0, 57472 }, /* ASR.L #<data>,Dn */
{ CPUFUNC(op_e088_0), 0, 57480 }, /* LSR.L #<data>,Dn */
{ CPUFUNC(op_e090_0), 0, 57488 }, /* ROXR.L #<data>,Dn */
{ CPUFUNC(op_e098_0), 0, 57496 }, /* ROR.L #<data>,Dn */
{ CPUFUNC(op_e0a0_0), 0, 57504 }, /* ASR.L Dn,Dn */
{ CPUFUNC(op_e0a8_0), 0, 57512 }, /* LSR.L Dn,Dn */
{ CPUFUNC(op_e0b0_0), 0, 57520 }, /* ROXR.L Dn,Dn */
{ CPUFUNC(op_e0b8_0), 0, 57528 }, /* ROR.L Dn,Dn */
{ CPUFUNC(op_e0d0_0), 0, 57552 }, /* ASRW.W (An) */
{ CPUFUNC(op_e0d8_0), 0, 57560 }, /* ASRW.W (An)+ */
{ CPUFUNC(op_e0e0_0), 0, 57568 }, /* ASRW.W -(An) */
{ CPUFUNC(op_e0e8_0), 0, 57576 }, /* ASRW.W (d16,An) */
{ CPUFUNC(op_e0f0_0), 0, 57584 }, /* ASRW.W (d8,An,Xn) */
{ CPUFUNC(op_e0f8_0), 0, 57592 }, /* ASRW.W (xxx).W */
{ CPUFUNC(op_e0f9_0), 0, 57593 }, /* ASRW.W (xxx).L */
{ CPUFUNC(op_e100_0), 0, 57600 }, /* ASL.B #<data>,Dn */
{ CPUFUNC(op_e108_0), 0, 57608 }, /* LSL.B #<data>,Dn */
{ CPUFUNC(op_e110_0), 0, 57616 }, /* ROXL.B #<data>,Dn */
{ CPUFUNC(op_e118_0), 0, 57624 }, /* ROL.B #<data>,Dn */
{ CPUFUNC(op_e120_0), 0, 57632 }, /* ASL.B Dn,Dn */
{ CPUFUNC(op_e128_0), 0, 57640 }, /* LSL.B Dn,Dn */
{ CPUFUNC(op_e130_0), 0, 57648 }, /* ROXL.B Dn,Dn */
{ CPUFUNC(op_e138_0), 0, 57656 }, /* ROL.B Dn,Dn */
{ CPUFUNC(op_e140_0), 0, 57664 }, /* ASL.W #<data>,Dn */
{ CPUFUNC(op_e148_0), 0, 57672 }, /* LSL.W #<data>,Dn */
{ CPUFUNC(op_e150_0), 0, 57680 }, /* ROXL.W #<data>,Dn */
{ CPUFUNC(op_e158_0), 0, 57688 }, /* ROL.W #<data>,Dn */
{ CPUFUNC(op_e160_0), 0, 57696 }, /* ASL.W Dn,Dn */
{ CPUFUNC(op_e168_0), 0, 57704 }, /* LSL.W Dn,Dn */
{ CPUFUNC(op_e170_0), 0, 57712 }, /* ROXL.W Dn,Dn */
{ CPUFUNC(op_e178_0), 0, 57720 }, /* ROL.W Dn,Dn */
{ CPUFUNC(op_e180_0), 0, 57728 }, /* ASL.L #<data>,Dn */
{ CPUFUNC(op_e188_0), 0, 57736 }, /* LSL.L #<data>,Dn */
{ CPUFUNC(op_e190_0), 0, 57744 }, /* ROXL.L #<data>,Dn */
{ CPUFUNC(op_e198_0), 0, 57752 }, /* ROL.L #<data>,Dn */
{ CPUFUNC(op_e1a0_0), 0, 57760 }, /* ASL.L Dn,Dn */
{ CPUFUNC(op_e1a8_0), 0, 57768 }, /* LSL.L Dn,Dn */
{ CPUFUNC(op_e1b0_0), 0, 57776 }, /* ROXL.L Dn,Dn */
{ CPUFUNC(op_e1b8_0), 0, 57784 }, /* ROL.L Dn,Dn */
{ CPUFUNC(op_e1d0_0), 0, 57808 }, /* ASLW.W (An) */
{ CPUFUNC(op_e1d8_0), 0, 57816 }, /* ASLW.W (An)+ */
{ CPUFUNC(op_e1e0_0), 0, 57824 }, /* ASLW.W -(An) */
{ CPUFUNC(op_e1e8_0), 0, 57832 }, /* ASLW.W (d16,An) */
{ CPUFUNC(op_e1f0_0), 0, 57840 }, /* ASLW.W (d8,An,Xn) */
{ CPUFUNC(op_e1f8_0), 0, 57848 }, /* ASLW.W (xxx).W */
{ CPUFUNC(op_e1f9_0), 0, 57849 }, /* ASLW.W (xxx).L */
{ CPUFUNC(op_e2d0_0), 0, 58064 }, /* LSRW.W (An) */
{ CPUFUNC(op_e2d8_0), 0, 58072 }, /* LSRW.W (An)+ */
{ CPUFUNC(op_e2e0_0), 0, 58080 }, /* LSRW.W -(An) */
{ CPUFUNC(op_e2e8_0), 0, 58088 }, /* LSRW.W (d16,An) */
{ CPUFUNC(op_e2f0_0), 0, 58096 }, /* LSRW.W (d8,An,Xn) */
{ CPUFUNC(op_e2f8_0), 0, 58104 }, /* LSRW.W (xxx).W */
{ CPUFUNC(op_e2f9_0), 0, 58105 }, /* LSRW.W (xxx).L */
{ CPUFUNC(op_e3d0_0), 0, 58320 }, /* LSLW.W (An) */
{ CPUFUNC(op_e3d8_0), 0, 58328 }, /* LSLW.W (An)+ */
{ CPUFUNC(op_e3e0_0), 0, 58336 }, /* LSLW.W -(An) */
{ CPUFUNC(op_e3e8_0), 0, 58344 }, /* LSLW.W (d16,An) */
{ CPUFUNC(op_e3f0_0), 0, 58352 }, /* LSLW.W (d8,An,Xn) */
{ CPUFUNC(op_e3f8_0), 0, 58360 }, /* LSLW.W (xxx).W */
{ CPUFUNC(op_e3f9_0), 0, 58361 }, /* LSLW.W (xxx).L */
{ CPUFUNC(op_e4d0_0), 0, 58576 }, /* ROXRW.W (An) */
{ CPUFUNC(op_e4d8_0), 0, 58584 }, /* ROXRW.W (An)+ */
{ CPUFUNC(op_e4e0_0), 0, 58592 }, /* ROXRW.W -(An) */
{ CPUFUNC(op_e4e8_0), 0, 58600 }, /* ROXRW.W (d16,An) */
{ CPUFUNC(op_e4f0_0), 0, 58608 }, /* ROXRW.W (d8,An,Xn) */
{ CPUFUNC(op_e4f8_0), 0, 58616 }, /* ROXRW.W (xxx).W */
{ CPUFUNC(op_e4f9_0), 0, 58617 }, /* ROXRW.W (xxx).L */
{ CPUFUNC(op_e5d0_0), 0, 58832 }, /* ROXLW.W (An) */
{ CPUFUNC(op_e5d8_0), 0, 58840 }, /* ROXLW.W (An)+ */
{ CPUFUNC(op_e5e0_0), 0, 58848 }, /* ROXLW.W -(An) */
{ CPUFUNC(op_e5e8_0), 0, 58856 }, /* ROXLW.W (d16,An) */
{ CPUFUNC(op_e5f0_0), 0, 58864 }, /* ROXLW.W (d8,An,Xn) */
{ CPUFUNC(op_e5f8_0), 0, 58872 }, /* ROXLW.W (xxx).W */
{ CPUFUNC(op_e5f9_0), 0, 58873 }, /* ROXLW.W (xxx).L */
{ CPUFUNC(op_e6d0_0), 0, 59088 }, /* RORW.W (An) */
{ CPUFUNC(op_e6d8_0), 0, 59096 }, /* RORW.W (An)+ */
{ CPUFUNC(op_e6e0_0), 0, 59104 }, /* RORW.W -(An) */
{ CPUFUNC(op_e6e8_0), 0, 59112 }, /* RORW.W (d16,An) */
{ CPUFUNC(op_e6f0_0), 0, 59120 }, /* RORW.W (d8,An,Xn) */
{ CPUFUNC(op_e6f8_0), 0, 59128 }, /* RORW.W (xxx).W */
{ CPUFUNC(op_e6f9_0), 0, 59129 }, /* RORW.W (xxx).L */
{ CPUFUNC(op_e7d0_0), 0, 59344 }, /* ROLW.W (An) */
{ CPUFUNC(op_e7d8_0), 0, 59352 }, /* ROLW.W (An)+ */
{ CPUFUNC(op_e7e0_0), 0, 59360 }, /* ROLW.W -(An) */
{ CPUFUNC(op_e7e8_0), 0, 59368 }, /* ROLW.W (d16,An) */
{ CPUFUNC(op_e7f0_0), 0, 59376 }, /* ROLW.W (d8,An,Xn) */
{ CPUFUNC(op_e7f8_0), 0, 59384 }, /* ROLW.W (xxx).W */
{ CPUFUNC(op_e7f9_0), 0, 59385 }, /* ROLW.W (xxx).L */
{ CPUFUNC(op_e8c0_0), 0, 59584 }, /* BFTST.L #<data>.W,Dn */
{ CPUFUNC(op_e8d0_0), 0, 59600 }, /* BFTST.L #<data>.W,(An) */
{ CPUFUNC(op_e8e8_0), 0, 59624 }, /* BFTST.L #<data>.W,(d16,An) */
{ CPUFUNC(op_e8f0_0), 0, 59632 }, /* BFTST.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_e8f8_0), 0, 59640 }, /* BFTST.L #<data>.W,(xxx).W */
{ CPUFUNC(op_e8f9_0), 0, 59641 }, /* BFTST.L #<data>.W,(xxx).L */
{ CPUFUNC(op_e8fa_0), 0, 59642 }, /* BFTST.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_e8fb_0), 0, 59643 }, /* BFTST.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_e9c0_0), 0, 59840 }, /* BFEXTU.L #<data>.W,Dn */
{ CPUFUNC(op_e9d0_0), 0, 59856 }, /* BFEXTU.L #<data>.W,(An) */
{ CPUFUNC(op_e9e8_0), 0, 59880 }, /* BFEXTU.L #<data>.W,(d16,An) */
{ CPUFUNC(op_e9f0_0), 0, 59888 }, /* BFEXTU.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_e9f8_0), 0, 59896 }, /* BFEXTU.L #<data>.W,(xxx).W */
{ CPUFUNC(op_e9f9_0), 0, 59897 }, /* BFEXTU.L #<data>.W,(xxx).L */
{ CPUFUNC(op_e9fa_0), 0, 59898 }, /* BFEXTU.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_e9fb_0), 0, 59899 }, /* BFEXTU.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_eac0_0), 0, 60096 }, /* BFCHG.L #<data>.W,Dn */
{ CPUFUNC(op_ead0_0), 0, 60112 }, /* BFCHG.L #<data>.W,(An) */
{ CPUFUNC(op_eae8_0), 0, 60136 }, /* BFCHG.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eaf0_0), 0, 60144 }, /* BFCHG.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eaf8_0), 0, 60152 }, /* BFCHG.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eaf9_0), 0, 60153 }, /* BFCHG.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ebc0_0), 0, 60352 }, /* BFEXTS.L #<data>.W,Dn */
{ CPUFUNC(op_ebd0_0), 0, 60368 }, /* BFEXTS.L #<data>.W,(An) */
{ CPUFUNC(op_ebe8_0), 0, 60392 }, /* BFEXTS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ebf0_0), 0, 60400 }, /* BFEXTS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ebf8_0), 0, 60408 }, /* BFEXTS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ebf9_0), 0, 60409 }, /* BFEXTS.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ebfa_0), 0, 60410 }, /* BFEXTS.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_ebfb_0), 0, 60411 }, /* BFEXTS.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_ecc0_0), 0, 60608 }, /* BFCLR.L #<data>.W,Dn */
{ CPUFUNC(op_ecd0_0), 0, 60624 }, /* BFCLR.L #<data>.W,(An) */
{ CPUFUNC(op_ece8_0), 0, 60648 }, /* BFCLR.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ecf0_0), 0, 60656 }, /* BFCLR.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ecf8_0), 0, 60664 }, /* BFCLR.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ecf9_0), 0, 60665 }, /* BFCLR.L #<data>.W,(xxx).L */
{ CPUFUNC(op_edc0_0), 0, 60864 }, /* BFFFO.L #<data>.W,Dn */
{ CPUFUNC(op_edd0_0), 0, 60880 }, /* BFFFO.L #<data>.W,(An) */
{ CPUFUNC(op_ede8_0), 0, 60904 }, /* BFFFO.L #<data>.W,(d16,An) */
{ CPUFUNC(op_edf0_0), 0, 60912 }, /* BFFFO.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_edf8_0), 0, 60920 }, /* BFFFO.L #<data>.W,(xxx).W */
{ CPUFUNC(op_edf9_0), 0, 60921 }, /* BFFFO.L #<data>.W,(xxx).L */
{ CPUFUNC(op_edfa_0), 0, 60922 }, /* BFFFO.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_edfb_0), 0, 60923 }, /* BFFFO.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_eec0_0), 0, 61120 }, /* BFSET.L #<data>.W,Dn */
{ CPUFUNC(op_eed0_0), 0, 61136 }, /* BFSET.L #<data>.W,(An) */
{ CPUFUNC(op_eee8_0), 0, 61160 }, /* BFSET.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eef0_0), 0, 61168 }, /* BFSET.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eef8_0), 0, 61176 }, /* BFSET.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eef9_0), 0, 61177 }, /* BFSET.L #<data>.W,(xxx).L */
{ CPUFUNC(op_efc0_0), 0, 61376 }, /* BFINS.L #<data>.W,Dn */
{ CPUFUNC(op_efd0_0), 0, 61392 }, /* BFINS.L #<data>.W,(An) */
{ CPUFUNC(op_efe8_0), 0, 61416 }, /* BFINS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eff0_0), 0, 61424 }, /* BFINS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eff8_0), 0, 61432 }, /* BFINS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eff9_0), 0, 61433 }, /* BFINS.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_f200_0), 0, 61952 }, /* FPP.L #<data>.W,Dn */
{ CPUFUNC_FF(op_f208_0), 0, 61960 }, /* FPP.L #<data>.W,An */
{ CPUFUNC_FF(op_f210_0), 0, 61968 }, /* FPP.L #<data>.W,(An) */
{ CPUFUNC_FF(op_f218_0), 0, 61976 }, /* FPP.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_f220_0), 0, 61984 }, /* FPP.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_f228_0), 0, 61992 }, /* FPP.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_f230_0), 0, 62000 }, /* FPP.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_f238_0), 0, 62008 }, /* FPP.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_f239_0), 0, 62009 }, /* FPP.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_f23a_0), 0, 62010 }, /* FPP.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_f23b_0), 0, 62011 }, /* FPP.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_f23c_0), 0, 62012 }, /* FPP.L #<data>.W,#<data>.L */
{ CPUFUNC_FF(op_f240_0), 0, 62016 }, /* FScc.L #<data>.W,Dn */
{ CPUFUNC_FF(op_f248_0), 0, 62024 }, /* FDBcc.L #<data>.W,Dn */
{ CPUFUNC_FF(op_f250_0), 0, 62032 }, /* FScc.L #<data>.W,(An) */
{ CPUFUNC_FF(op_f258_0), 0, 62040 }, /* FScc.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_f260_0), 0, 62048 }, /* FScc.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_f268_0), 0, 62056 }, /* FScc.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_f270_0), 0, 62064 }, /* FScc.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_f278_0), 0, 62072 }, /* FScc.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_f279_0), 0, 62073 }, /* FScc.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_f27a_0), 0, 62074 }, /* FTRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_f27b_0), 0, 62075 }, /* FTRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_f27c_0), 0, 62076 }, /* FTRAPcc.L  */
{ CPUFUNC_FF(op_f280_0), 0, 62080 }, /* FBcc.L #<data>,#<data>.W */
{ CPUFUNC_FF(op_f2c0_0), 0, 62144 }, /* FBcc.L #<data>,#<data>.L */
{ CPUFUNC_FF(op_f310_0), 0, 62224 }, /* FSAVE.L (An) */
{ CPUFUNC_FF(op_f320_0), 0, 62240 }, /* FSAVE.L -(An) */
{ CPUFUNC_FF(op_f328_0), 0, 62248 }, /* FSAVE.L (d16,An) */
{ CPUFUNC_FF(op_f330_0), 0, 62256 }, /* FSAVE.L (d8,An,Xn) */
{ CPUFUNC_FF(op_f338_0), 0, 62264 }, /* FSAVE.L (xxx).W */
{ CPUFUNC_FF(op_f339_0), 0, 62265 }, /* FSAVE.L (xxx).L */
{ CPUFUNC_FF(op_f350_0), 0, 62288 }, /* FRESTORE.L (An) */
{ CPUFUNC_FF(op_f358_0), 0, 62296 }, /* FRESTORE.L (An)+ */
{ CPUFUNC_FF(op_f368_0), 0, 62312 }, /* FRESTORE.L (d16,An) */
{ CPUFUNC_FF(op_f370_0), 0, 62320 }, /* FRESTORE.L (d8,An,Xn) */
{ CPUFUNC_FF(op_f378_0), 0, 62328 }, /* FRESTORE.L (xxx).W */
{ CPUFUNC_FF(op_f379_0), 0, 62329 }, /* FRESTORE.L (xxx).L */
{ CPUFUNC_FF(op_f37a_0), 0, 62330 }, /* FRESTORE.L (d16,PC) */
{ CPUFUNC_FF(op_f37b_0), 0, 62331 }, /* FRESTORE.L (d8,PC,Xn) */
{ CPUFUNC_FF(op_f408_0), 0, 62472 }, /* CINVL.L #<data>,An */
{ CPUFUNC_FF(op_f410_0), 0, 62480 }, /* CINVP.L #<data>,An */
{ CPUFUNC_FF(op_f418_0), 0, 62488 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f419_0), 0, 62489 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f41a_0), 0, 62490 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f41b_0), 0, 62491 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f41c_0), 0, 62492 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f41d_0), 0, 62493 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f41e_0), 0, 62494 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f41f_0), 0, 62495 }, /* CINVA.L #<data> */
{ CPUFUNC_FF(op_f428_0), 0, 62504 }, /* CPUSHL.L #<data>,An */
{ CPUFUNC_FF(op_f430_0), 0, 62512 }, /* CPUSHP.L #<data>,An */
{ CPUFUNC_FF(op_f438_0), 0, 62520 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f439_0), 0, 62521 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f43a_0), 0, 62522 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f43b_0), 0, 62523 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f43c_0), 0, 62524 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f43d_0), 0, 62525 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f43e_0), 0, 62526 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f43f_0), 0, 62527 }, /* CPUSHA.L #<data> */
{ CPUFUNC_FF(op_f500_0), 0, 62720 }, /* MMUOP.L #<data>,Dn */
{ CPUFUNC_FF(op_f600_0), 0, 62976 }, /* MOVE16.L (An)+,(xxx).L */
{ CPUFUNC_FF(op_f608_0), 0, 62984 }, /* MOVE16.L (xxx).L,(An)+ */
{ CPUFUNC_FF(op_f610_0), 0, 62992 }, /* MOVE16.L (An),(xxx).L */
{ CPUFUNC_FF(op_f618_0), 0, 63000 }, /* MOVE16.L (xxx).L,(An) */
{ CPUFUNC_FF(op_f620_0), 0, 63008 }, /* MOVE16.L (An)+,(An)+ */
{ 0, 0, 0 }};
struct cputbl CPUFUNC(op_smalltbl_1)[] = {
{ CPUFUNC(op_0_0), 0, 0 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_10_0), 0, 16 }, /* OR.B #<data>.B,(An) */
{ CPUFUNC(op_18_0), 0, 24 }, /* OR.B #<data>.B,(An)+ */
{ CPUFUNC(op_20_0), 0, 32 }, /* OR.B #<data>.B,-(An) */
{ CPUFUNC(op_28_0), 0, 40 }, /* OR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_30_0), 0, 48 }, /* OR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_38_0), 0, 56 }, /* OR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_39_0), 0, 57 }, /* OR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_3c_0), 0, 60 }, /* ORSR.B #<data>.W */
{ CPUFUNC(op_40_0), 0, 64 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_50_0), 0, 80 }, /* OR.W #<data>.W,(An) */
{ CPUFUNC(op_58_0), 0, 88 }, /* OR.W #<data>.W,(An)+ */
{ CPUFUNC(op_60_0), 0, 96 }, /* OR.W #<data>.W,-(An) */
{ CPUFUNC(op_68_0), 0, 104 }, /* OR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_70_0), 0, 112 }, /* OR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_78_0), 0, 120 }, /* OR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_79_0), 0, 121 }, /* OR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_7c_0), 0, 124 }, /* ORSR.W #<data>.W */
{ CPUFUNC(op_80_0), 0, 128 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_90_0), 0, 144 }, /* OR.L #<data>.L,(An) */
{ CPUFUNC(op_98_0), 0, 152 }, /* OR.L #<data>.L,(An)+ */
{ CPUFUNC(op_a0_0), 0, 160 }, /* OR.L #<data>.L,-(An) */
{ CPUFUNC(op_a8_0), 0, 168 }, /* OR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_b0_0), 0, 176 }, /* OR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_b8_0), 0, 184 }, /* OR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_b9_0), 0, 185 }, /* OR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_d0_0), 0, 208 }, /* CHK2.B #<data>.W,(An) */
{ CPUFUNC(op_e8_0), 0, 232 }, /* CHK2.B #<data>.W,(d16,An) */
{ CPUFUNC(op_f0_0), 0, 240 }, /* CHK2.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_f8_0), 0, 248 }, /* CHK2.B #<data>.W,(xxx).W */
{ CPUFUNC(op_f9_0), 0, 249 }, /* CHK2.B #<data>.W,(xxx).L */
{ CPUFUNC(op_fa_0), 0, 250 }, /* CHK2.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_fb_0), 0, 251 }, /* CHK2.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_100_0), 0, 256 }, /* BTST.L Dn,Dn */
{ CPUFUNC_FF(op_108_0), 0, 264 }, /* MVPMR.W (d16,An),Dn */
{ CPUFUNC(op_110_0), 0, 272 }, /* BTST.B Dn,(An) */
{ CPUFUNC(op_118_0), 0, 280 }, /* BTST.B Dn,(An)+ */
{ CPUFUNC(op_120_0), 0, 288 }, /* BTST.B Dn,-(An) */
{ CPUFUNC(op_128_0), 0, 296 }, /* BTST.B Dn,(d16,An) */
{ CPUFUNC(op_130_0), 0, 304 }, /* BTST.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_138_0), 0, 312 }, /* BTST.B Dn,(xxx).W */
{ CPUFUNC(op_139_0), 0, 313 }, /* BTST.B Dn,(xxx).L */
{ CPUFUNC(op_13a_0), 0, 314 }, /* BTST.B Dn,(d16,PC) */
{ CPUFUNC(op_13b_0), 0, 315 }, /* BTST.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_13c_0), 0, 316 }, /* BTST.B Dn,#<data>.B */
{ CPUFUNC(op_140_0), 0, 320 }, /* BCHG.L Dn,Dn */
{ CPUFUNC_FF(op_148_0), 0, 328 }, /* MVPMR.L (d16,An),Dn */
{ CPUFUNC(op_150_0), 0, 336 }, /* BCHG.B Dn,(An) */
{ CPUFUNC(op_158_0), 0, 344 }, /* BCHG.B Dn,(An)+ */
{ CPUFUNC(op_160_0), 0, 352 }, /* BCHG.B Dn,-(An) */
{ CPUFUNC(op_168_0), 0, 360 }, /* BCHG.B Dn,(d16,An) */
{ CPUFUNC(op_170_0), 0, 368 }, /* BCHG.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_178_0), 0, 376 }, /* BCHG.B Dn,(xxx).W */
{ CPUFUNC(op_179_0), 0, 377 }, /* BCHG.B Dn,(xxx).L */
{ CPUFUNC(op_17a_0), 0, 378 }, /* BCHG.B Dn,(d16,PC) */
{ CPUFUNC(op_17b_0), 0, 379 }, /* BCHG.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_180_0), 0, 384 }, /* BCLR.L Dn,Dn */
{ CPUFUNC_FF(op_188_0), 0, 392 }, /* MVPRM.W Dn,(d16,An) */
{ CPUFUNC(op_190_0), 0, 400 }, /* BCLR.B Dn,(An) */
{ CPUFUNC(op_198_0), 0, 408 }, /* BCLR.B Dn,(An)+ */
{ CPUFUNC(op_1a0_0), 0, 416 }, /* BCLR.B Dn,-(An) */
{ CPUFUNC(op_1a8_0), 0, 424 }, /* BCLR.B Dn,(d16,An) */
{ CPUFUNC(op_1b0_0), 0, 432 }, /* BCLR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1b8_0), 0, 440 }, /* BCLR.B Dn,(xxx).W */
{ CPUFUNC(op_1b9_0), 0, 441 }, /* BCLR.B Dn,(xxx).L */
{ CPUFUNC(op_1ba_0), 0, 442 }, /* BCLR.B Dn,(d16,PC) */
{ CPUFUNC(op_1bb_0), 0, 443 }, /* BCLR.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_1c0_0), 0, 448 }, /* BSET.L Dn,Dn */
{ CPUFUNC_FF(op_1c8_0), 0, 456 }, /* MVPRM.L Dn,(d16,An) */
{ CPUFUNC(op_1d0_0), 0, 464 }, /* BSET.B Dn,(An) */
{ CPUFUNC(op_1d8_0), 0, 472 }, /* BSET.B Dn,(An)+ */
{ CPUFUNC(op_1e0_0), 0, 480 }, /* BSET.B Dn,-(An) */
{ CPUFUNC(op_1e8_0), 0, 488 }, /* BSET.B Dn,(d16,An) */
{ CPUFUNC(op_1f0_0), 0, 496 }, /* BSET.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1f8_0), 0, 504 }, /* BSET.B Dn,(xxx).W */
{ CPUFUNC(op_1f9_0), 0, 505 }, /* BSET.B Dn,(xxx).L */
{ CPUFUNC(op_1fa_0), 0, 506 }, /* BSET.B Dn,(d16,PC) */
{ CPUFUNC(op_1fb_0), 0, 507 }, /* BSET.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_200_0), 0, 512 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_210_0), 0, 528 }, /* AND.B #<data>.B,(An) */
{ CPUFUNC(op_218_0), 0, 536 }, /* AND.B #<data>.B,(An)+ */
{ CPUFUNC(op_220_0), 0, 544 }, /* AND.B #<data>.B,-(An) */
{ CPUFUNC(op_228_0), 0, 552 }, /* AND.B #<data>.B,(d16,An) */
{ CPUFUNC(op_230_0), 0, 560 }, /* AND.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_238_0), 0, 568 }, /* AND.B #<data>.B,(xxx).W */
{ CPUFUNC(op_239_0), 0, 569 }, /* AND.B #<data>.B,(xxx).L */
{ CPUFUNC(op_23c_0), 0, 572 }, /* ANDSR.B #<data>.W */
{ CPUFUNC(op_240_0), 0, 576 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_250_0), 0, 592 }, /* AND.W #<data>.W,(An) */
{ CPUFUNC(op_258_0), 0, 600 }, /* AND.W #<data>.W,(An)+ */
{ CPUFUNC(op_260_0), 0, 608 }, /* AND.W #<data>.W,-(An) */
{ CPUFUNC(op_268_0), 0, 616 }, /* AND.W #<data>.W,(d16,An) */
{ CPUFUNC(op_270_0), 0, 624 }, /* AND.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_278_0), 0, 632 }, /* AND.W #<data>.W,(xxx).W */
{ CPUFUNC(op_279_0), 0, 633 }, /* AND.W #<data>.W,(xxx).L */
{ CPUFUNC(op_27c_0), 0, 636 }, /* ANDSR.W #<data>.W */
{ CPUFUNC(op_280_0), 0, 640 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_290_0), 0, 656 }, /* AND.L #<data>.L,(An) */
{ CPUFUNC(op_298_0), 0, 664 }, /* AND.L #<data>.L,(An)+ */
{ CPUFUNC(op_2a0_0), 0, 672 }, /* AND.L #<data>.L,-(An) */
{ CPUFUNC(op_2a8_0), 0, 680 }, /* AND.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2b0_0), 0, 688 }, /* AND.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_2b8_0), 0, 696 }, /* AND.L #<data>.L,(xxx).W */
{ CPUFUNC(op_2b9_0), 0, 697 }, /* AND.L #<data>.L,(xxx).L */
{ CPUFUNC(op_2d0_0), 0, 720 }, /* CHK2.W #<data>.W,(An) */
{ CPUFUNC(op_2e8_0), 0, 744 }, /* CHK2.W #<data>.W,(d16,An) */
{ CPUFUNC(op_2f0_0), 0, 752 }, /* CHK2.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_2f8_0), 0, 760 }, /* CHK2.W #<data>.W,(xxx).W */
{ CPUFUNC(op_2f9_0), 0, 761 }, /* CHK2.W #<data>.W,(xxx).L */
{ CPUFUNC(op_2fa_0), 0, 762 }, /* CHK2.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_2fb_0), 0, 763 }, /* CHK2.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_400_0), 0, 1024 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_410_0), 0, 1040 }, /* SUB.B #<data>.B,(An) */
{ CPUFUNC(op_418_0), 0, 1048 }, /* SUB.B #<data>.B,(An)+ */
{ CPUFUNC(op_420_0), 0, 1056 }, /* SUB.B #<data>.B,-(An) */
{ CPUFUNC(op_428_0), 0, 1064 }, /* SUB.B #<data>.B,(d16,An) */
{ CPUFUNC(op_430_0), 0, 1072 }, /* SUB.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_438_0), 0, 1080 }, /* SUB.B #<data>.B,(xxx).W */
{ CPUFUNC(op_439_0), 0, 1081 }, /* SUB.B #<data>.B,(xxx).L */
{ CPUFUNC(op_440_0), 0, 1088 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_450_0), 0, 1104 }, /* SUB.W #<data>.W,(An) */
{ CPUFUNC(op_458_0), 0, 1112 }, /* SUB.W #<data>.W,(An)+ */
{ CPUFUNC(op_460_0), 0, 1120 }, /* SUB.W #<data>.W,-(An) */
{ CPUFUNC(op_468_0), 0, 1128 }, /* SUB.W #<data>.W,(d16,An) */
{ CPUFUNC(op_470_0), 0, 1136 }, /* SUB.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_478_0), 0, 1144 }, /* SUB.W #<data>.W,(xxx).W */
{ CPUFUNC(op_479_0), 0, 1145 }, /* SUB.W #<data>.W,(xxx).L */
{ CPUFUNC(op_480_0), 0, 1152 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC(op_490_0), 0, 1168 }, /* SUB.L #<data>.L,(An) */
{ CPUFUNC(op_498_0), 0, 1176 }, /* SUB.L #<data>.L,(An)+ */
{ CPUFUNC(op_4a0_0), 0, 1184 }, /* SUB.L #<data>.L,-(An) */
{ CPUFUNC(op_4a8_0), 0, 1192 }, /* SUB.L #<data>.L,(d16,An) */
{ CPUFUNC(op_4b0_0), 0, 1200 }, /* SUB.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_4b8_0), 0, 1208 }, /* SUB.L #<data>.L,(xxx).W */
{ CPUFUNC(op_4b9_0), 0, 1209 }, /* SUB.L #<data>.L,(xxx).L */
{ CPUFUNC(op_4d0_0), 0, 1232 }, /* CHK2.L #<data>.W,(An) */
{ CPUFUNC(op_4e8_0), 0, 1256 }, /* CHK2.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4f0_0), 0, 1264 }, /* CHK2.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4f8_0), 0, 1272 }, /* CHK2.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4f9_0), 0, 1273 }, /* CHK2.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4fa_0), 0, 1274 }, /* CHK2.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4fb_0), 0, 1275 }, /* CHK2.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_600_0), 0, 1536 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_610_0), 0, 1552 }, /* ADD.B #<data>.B,(An) */
{ CPUFUNC(op_618_0), 0, 1560 }, /* ADD.B #<data>.B,(An)+ */
{ CPUFUNC(op_620_0), 0, 1568 }, /* ADD.B #<data>.B,-(An) */
{ CPUFUNC(op_628_0), 0, 1576 }, /* ADD.B #<data>.B,(d16,An) */
{ CPUFUNC(op_630_0), 0, 1584 }, /* ADD.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_638_0), 0, 1592 }, /* ADD.B #<data>.B,(xxx).W */
{ CPUFUNC(op_639_0), 0, 1593 }, /* ADD.B #<data>.B,(xxx).L */
{ CPUFUNC(op_640_0), 0, 1600 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_650_0), 0, 1616 }, /* ADD.W #<data>.W,(An) */
{ CPUFUNC(op_658_0), 0, 1624 }, /* ADD.W #<data>.W,(An)+ */
{ CPUFUNC(op_660_0), 0, 1632 }, /* ADD.W #<data>.W,-(An) */
{ CPUFUNC(op_668_0), 0, 1640 }, /* ADD.W #<data>.W,(d16,An) */
{ CPUFUNC(op_670_0), 0, 1648 }, /* ADD.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_678_0), 0, 1656 }, /* ADD.W #<data>.W,(xxx).W */
{ CPUFUNC(op_679_0), 0, 1657 }, /* ADD.W #<data>.W,(xxx).L */
{ CPUFUNC(op_680_0), 0, 1664 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC(op_690_0), 0, 1680 }, /* ADD.L #<data>.L,(An) */
{ CPUFUNC(op_698_0), 0, 1688 }, /* ADD.L #<data>.L,(An)+ */
{ CPUFUNC(op_6a0_0), 0, 1696 }, /* ADD.L #<data>.L,-(An) */
{ CPUFUNC(op_6a8_0), 0, 1704 }, /* ADD.L #<data>.L,(d16,An) */
{ CPUFUNC(op_6b0_0), 0, 1712 }, /* ADD.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_6b8_0), 0, 1720 }, /* ADD.L #<data>.L,(xxx).W */
{ CPUFUNC(op_6b9_0), 0, 1721 }, /* ADD.L #<data>.L,(xxx).L */
{ CPUFUNC(op_6c0_0), 0, 1728 }, /* RTM.L Dn */
{ CPUFUNC(op_6c8_0), 0, 1736 }, /* RTM.L An */
{ CPUFUNC_FF(op_6d0_0), 0, 1744 }, /* CALLM.L (An) */
{ CPUFUNC_FF(op_6e8_0), 0, 1768 }, /* CALLM.L (d16,An) */
{ CPUFUNC_FF(op_6f0_0), 0, 1776 }, /* CALLM.L (d8,An,Xn) */
{ CPUFUNC_FF(op_6f8_0), 0, 1784 }, /* CALLM.L (xxx).W */
{ CPUFUNC_FF(op_6f9_0), 0, 1785 }, /* CALLM.L (xxx).L */
{ CPUFUNC_FF(op_6fa_0), 0, 1786 }, /* CALLM.L (d16,PC) */
{ CPUFUNC_FF(op_6fb_0), 0, 1787 }, /* CALLM.L (d8,PC,Xn) */
{ CPUFUNC(op_800_0), 0, 2048 }, /* BTST.L #<data>.W,Dn */
{ CPUFUNC(op_810_0), 0, 2064 }, /* BTST.B #<data>.W,(An) */
{ CPUFUNC(op_818_0), 0, 2072 }, /* BTST.B #<data>.W,(An)+ */
{ CPUFUNC(op_820_0), 0, 2080 }, /* BTST.B #<data>.W,-(An) */
{ CPUFUNC(op_828_0), 0, 2088 }, /* BTST.B #<data>.W,(d16,An) */
{ CPUFUNC(op_830_0), 0, 2096 }, /* BTST.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_838_0), 0, 2104 }, /* BTST.B #<data>.W,(xxx).W */
{ CPUFUNC(op_839_0), 0, 2105 }, /* BTST.B #<data>.W,(xxx).L */
{ CPUFUNC(op_83a_0), 0, 2106 }, /* BTST.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_83b_0), 0, 2107 }, /* BTST.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_83c_0), 0, 2108 }, /* BTST.B #<data>.W,#<data>.B */
{ CPUFUNC(op_840_0), 0, 2112 }, /* BCHG.L #<data>.W,Dn */
{ CPUFUNC(op_850_0), 0, 2128 }, /* BCHG.B #<data>.W,(An) */
{ CPUFUNC(op_858_0), 0, 2136 }, /* BCHG.B #<data>.W,(An)+ */
{ CPUFUNC(op_860_0), 0, 2144 }, /* BCHG.B #<data>.W,-(An) */
{ CPUFUNC(op_868_0), 0, 2152 }, /* BCHG.B #<data>.W,(d16,An) */
{ CPUFUNC(op_870_0), 0, 2160 }, /* BCHG.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_878_0), 0, 2168 }, /* BCHG.B #<data>.W,(xxx).W */
{ CPUFUNC(op_879_0), 0, 2169 }, /* BCHG.B #<data>.W,(xxx).L */
{ CPUFUNC(op_87a_0), 0, 2170 }, /* BCHG.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_87b_0), 0, 2171 }, /* BCHG.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_880_0), 0, 2176 }, /* BCLR.L #<data>.W,Dn */
{ CPUFUNC(op_890_0), 0, 2192 }, /* BCLR.B #<data>.W,(An) */
{ CPUFUNC(op_898_0), 0, 2200 }, /* BCLR.B #<data>.W,(An)+ */
{ CPUFUNC(op_8a0_0), 0, 2208 }, /* BCLR.B #<data>.W,-(An) */
{ CPUFUNC(op_8a8_0), 0, 2216 }, /* BCLR.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8b0_0), 0, 2224 }, /* BCLR.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8b8_0), 0, 2232 }, /* BCLR.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8b9_0), 0, 2233 }, /* BCLR.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8ba_0), 0, 2234 }, /* BCLR.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8bb_0), 0, 2235 }, /* BCLR.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_8c0_0), 0, 2240 }, /* BSET.L #<data>.W,Dn */
{ CPUFUNC(op_8d0_0), 0, 2256 }, /* BSET.B #<data>.W,(An) */
{ CPUFUNC(op_8d8_0), 0, 2264 }, /* BSET.B #<data>.W,(An)+ */
{ CPUFUNC(op_8e0_0), 0, 2272 }, /* BSET.B #<data>.W,-(An) */
{ CPUFUNC(op_8e8_0), 0, 2280 }, /* BSET.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8f0_0), 0, 2288 }, /* BSET.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8f8_0), 0, 2296 }, /* BSET.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8f9_0), 0, 2297 }, /* BSET.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8fa_0), 0, 2298 }, /* BSET.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8fb_0), 0, 2299 }, /* BSET.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_a00_0), 0, 2560 }, /* EOR.B #<data>.B,Dn */
{ CPUFUNC(op_a10_0), 0, 2576 }, /* EOR.B #<data>.B,(An) */
{ CPUFUNC(op_a18_0), 0, 2584 }, /* EOR.B #<data>.B,(An)+ */
{ CPUFUNC(op_a20_0), 0, 2592 }, /* EOR.B #<data>.B,-(An) */
{ CPUFUNC(op_a28_0), 0, 2600 }, /* EOR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_a30_0), 0, 2608 }, /* EOR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_a38_0), 0, 2616 }, /* EOR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_a39_0), 0, 2617 }, /* EOR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_a3c_0), 0, 2620 }, /* EORSR.B #<data>.W */
{ CPUFUNC(op_a40_0), 0, 2624 }, /* EOR.W #<data>.W,Dn */
{ CPUFUNC(op_a50_0), 0, 2640 }, /* EOR.W #<data>.W,(An) */
{ CPUFUNC(op_a58_0), 0, 2648 }, /* EOR.W #<data>.W,(An)+ */
{ CPUFUNC(op_a60_0), 0, 2656 }, /* EOR.W #<data>.W,-(An) */
{ CPUFUNC(op_a68_0), 0, 2664 }, /* EOR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_a70_0), 0, 2672 }, /* EOR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_a78_0), 0, 2680 }, /* EOR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_a79_0), 0, 2681 }, /* EOR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_a7c_0), 0, 2684 }, /* EORSR.W #<data>.W */
{ CPUFUNC(op_a80_0), 0, 2688 }, /* EOR.L #<data>.L,Dn */
{ CPUFUNC(op_a90_0), 0, 2704 }, /* EOR.L #<data>.L,(An) */
{ CPUFUNC(op_a98_0), 0, 2712 }, /* EOR.L #<data>.L,(An)+ */
{ CPUFUNC(op_aa0_0), 0, 2720 }, /* EOR.L #<data>.L,-(An) */
{ CPUFUNC(op_aa8_0), 0, 2728 }, /* EOR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_ab0_0), 0, 2736 }, /* EOR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_ab8_0), 0, 2744 }, /* EOR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_ab9_0), 0, 2745 }, /* EOR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_ad0_0), 0, 2768 }, /* CAS.B #<data>.W,(An) */
{ CPUFUNC(op_ad8_0), 0, 2776 }, /* CAS.B #<data>.W,(An)+ */
{ CPUFUNC(op_ae0_0), 0, 2784 }, /* CAS.B #<data>.W,-(An) */
{ CPUFUNC(op_ae8_0), 0, 2792 }, /* CAS.B #<data>.W,(d16,An) */
{ CPUFUNC(op_af0_0), 0, 2800 }, /* CAS.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_af8_0), 0, 2808 }, /* CAS.B #<data>.W,(xxx).W */
{ CPUFUNC(op_af9_0), 0, 2809 }, /* CAS.B #<data>.W,(xxx).L */
{ CPUFUNC(op_c00_0), 0, 3072 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_c10_0), 0, 3088 }, /* CMP.B #<data>.B,(An) */
{ CPUFUNC(op_c18_0), 0, 3096 }, /* CMP.B #<data>.B,(An)+ */
{ CPUFUNC(op_c20_0), 0, 3104 }, /* CMP.B #<data>.B,-(An) */
{ CPUFUNC(op_c28_0), 0, 3112 }, /* CMP.B #<data>.B,(d16,An) */
{ CPUFUNC(op_c30_0), 0, 3120 }, /* CMP.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_c38_0), 0, 3128 }, /* CMP.B #<data>.B,(xxx).W */
{ CPUFUNC(op_c39_0), 0, 3129 }, /* CMP.B #<data>.B,(xxx).L */
{ CPUFUNC(op_c3a_0), 0, 3130 }, /* CMP.B #<data>.B,(d16,PC) */
{ CPUFUNC(op_c3b_0), 0, 3131 }, /* CMP.B #<data>.B,(d8,PC,Xn) */
{ CPUFUNC(op_c40_0), 0, 3136 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_c50_0), 0, 3152 }, /* CMP.W #<data>.W,(An) */
{ CPUFUNC(op_c58_0), 0, 3160 }, /* CMP.W #<data>.W,(An)+ */
{ CPUFUNC(op_c60_0), 0, 3168 }, /* CMP.W #<data>.W,-(An) */
{ CPUFUNC(op_c68_0), 0, 3176 }, /* CMP.W #<data>.W,(d16,An) */
{ CPUFUNC(op_c70_0), 0, 3184 }, /* CMP.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_c78_0), 0, 3192 }, /* CMP.W #<data>.W,(xxx).W */
{ CPUFUNC(op_c79_0), 0, 3193 }, /* CMP.W #<data>.W,(xxx).L */
{ CPUFUNC(op_c7a_0), 0, 3194 }, /* CMP.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_c7b_0), 0, 3195 }, /* CMP.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_c80_0), 0, 3200 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_c90_0), 0, 3216 }, /* CMP.L #<data>.L,(An) */
{ CPUFUNC(op_c98_0), 0, 3224 }, /* CMP.L #<data>.L,(An)+ */
{ CPUFUNC(op_ca0_0), 0, 3232 }, /* CMP.L #<data>.L,-(An) */
{ CPUFUNC(op_ca8_0), 0, 3240 }, /* CMP.L #<data>.L,(d16,An) */
{ CPUFUNC(op_cb0_0), 0, 3248 }, /* CMP.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_cb8_0), 0, 3256 }, /* CMP.L #<data>.L,(xxx).W */
{ CPUFUNC(op_cb9_0), 0, 3257 }, /* CMP.L #<data>.L,(xxx).L */
{ CPUFUNC(op_cba_0), 0, 3258 }, /* CMP.L #<data>.L,(d16,PC) */
{ CPUFUNC(op_cbb_0), 0, 3259 }, /* CMP.L #<data>.L,(d8,PC,Xn) */
{ CPUFUNC(op_cd0_0), 0, 3280 }, /* CAS.W #<data>.W,(An) */
{ CPUFUNC(op_cd8_0), 0, 3288 }, /* CAS.W #<data>.W,(An)+ */
{ CPUFUNC(op_ce0_0), 0, 3296 }, /* CAS.W #<data>.W,-(An) */
{ CPUFUNC(op_ce8_0), 0, 3304 }, /* CAS.W #<data>.W,(d16,An) */
{ CPUFUNC(op_cf0_0), 0, 3312 }, /* CAS.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_cf8_0), 0, 3320 }, /* CAS.W #<data>.W,(xxx).W */
{ CPUFUNC(op_cf9_0), 0, 3321 }, /* CAS.W #<data>.W,(xxx).L */
{ CPUFUNC(op_cfc_0), 0, 3324 }, /* CAS2.W #<data>.L */
{ CPUFUNC_FF(op_e10_0), 0, 3600 }, /* MOVES.B #<data>.W,(An) */
{ CPUFUNC_FF(op_e18_0), 0, 3608 }, /* MOVES.B #<data>.W,(An)+ */
{ CPUFUNC_FF(op_e20_0), 0, 3616 }, /* MOVES.B #<data>.W,-(An) */
{ CPUFUNC_FF(op_e28_0), 0, 3624 }, /* MOVES.B #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_e30_0), 0, 3632 }, /* MOVES.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_e38_0), 0, 3640 }, /* MOVES.B #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_e39_0), 0, 3641 }, /* MOVES.B #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_e50_0), 0, 3664 }, /* MOVES.W #<data>.W,(An) */
{ CPUFUNC_FF(op_e58_0), 0, 3672 }, /* MOVES.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_e60_0), 0, 3680 }, /* MOVES.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_e68_0), 0, 3688 }, /* MOVES.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_e70_0), 0, 3696 }, /* MOVES.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_e78_0), 0, 3704 }, /* MOVES.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_e79_0), 0, 3705 }, /* MOVES.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_e90_0), 0, 3728 }, /* MOVES.L #<data>.W,(An) */
{ CPUFUNC_FF(op_e98_0), 0, 3736 }, /* MOVES.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_ea0_0), 0, 3744 }, /* MOVES.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_ea8_0), 0, 3752 }, /* MOVES.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_eb0_0), 0, 3760 }, /* MOVES.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_eb8_0), 0, 3768 }, /* MOVES.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_eb9_0), 0, 3769 }, /* MOVES.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ed0_0), 0, 3792 }, /* CAS.L #<data>.W,(An) */
{ CPUFUNC(op_ed8_0), 0, 3800 }, /* CAS.L #<data>.W,(An)+ */
{ CPUFUNC(op_ee0_0), 0, 3808 }, /* CAS.L #<data>.W,-(An) */
{ CPUFUNC(op_ee8_0), 0, 3816 }, /* CAS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ef0_0), 0, 3824 }, /* CAS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ef8_0), 0, 3832 }, /* CAS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ef9_0), 0, 3833 }, /* CAS.L #<data>.W,(xxx).L */
{ CPUFUNC(op_efc_0), 0, 3836 }, /* CAS2.L #<data>.L */
{ CPUFUNC(op_1000_0), 0, 4096 }, /* MOVE.B Dn,Dn */
{ CPUFUNC(op_1010_0), 0, 4112 }, /* MOVE.B (An),Dn */
{ CPUFUNC(op_1018_0), 0, 4120 }, /* MOVE.B (An)+,Dn */
{ CPUFUNC(op_1020_0), 0, 4128 }, /* MOVE.B -(An),Dn */
{ CPUFUNC(op_1028_0), 0, 4136 }, /* MOVE.B (d16,An),Dn */
{ CPUFUNC(op_1030_0), 0, 4144 }, /* MOVE.B (d8,An,Xn),Dn */
{ CPUFUNC(op_1038_0), 0, 4152 }, /* MOVE.B (xxx).W,Dn */
{ CPUFUNC(op_1039_0), 0, 4153 }, /* MOVE.B (xxx).L,Dn */
{ CPUFUNC(op_103a_0), 0, 4154 }, /* MOVE.B (d16,PC),Dn */
{ CPUFUNC(op_103b_0), 0, 4155 }, /* MOVE.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_103c_0), 0, 4156 }, /* MOVE.B #<data>.B,Dn */
{ CPUFUNC(op_1080_0), 0, 4224 }, /* MOVE.B Dn,(An) */
{ CPUFUNC(op_1090_0), 0, 4240 }, /* MOVE.B (An),(An) */
{ CPUFUNC(op_1098_0), 0, 4248 }, /* MOVE.B (An)+,(An) */
{ CPUFUNC(op_10a0_0), 0, 4256 }, /* MOVE.B -(An),(An) */
{ CPUFUNC(op_10a8_0), 0, 4264 }, /* MOVE.B (d16,An),(An) */
{ CPUFUNC(op_10b0_0), 0, 4272 }, /* MOVE.B (d8,An,Xn),(An) */
{ CPUFUNC(op_10b8_0), 0, 4280 }, /* MOVE.B (xxx).W,(An) */
{ CPUFUNC(op_10b9_0), 0, 4281 }, /* MOVE.B (xxx).L,(An) */
{ CPUFUNC(op_10ba_0), 0, 4282 }, /* MOVE.B (d16,PC),(An) */
{ CPUFUNC(op_10bb_0), 0, 4283 }, /* MOVE.B (d8,PC,Xn),(An) */
{ CPUFUNC(op_10bc_0), 0, 4284 }, /* MOVE.B #<data>.B,(An) */
{ CPUFUNC(op_10c0_0), 0, 4288 }, /* MOVE.B Dn,(An)+ */
{ CPUFUNC(op_10d0_0), 0, 4304 }, /* MOVE.B (An),(An)+ */
{ CPUFUNC(op_10d8_0), 0, 4312 }, /* MOVE.B (An)+,(An)+ */
{ CPUFUNC(op_10e0_0), 0, 4320 }, /* MOVE.B -(An),(An)+ */
{ CPUFUNC(op_10e8_0), 0, 4328 }, /* MOVE.B (d16,An),(An)+ */
{ CPUFUNC(op_10f0_0), 0, 4336 }, /* MOVE.B (d8,An,Xn),(An)+ */
{ CPUFUNC(op_10f8_0), 0, 4344 }, /* MOVE.B (xxx).W,(An)+ */
{ CPUFUNC(op_10f9_0), 0, 4345 }, /* MOVE.B (xxx).L,(An)+ */
{ CPUFUNC(op_10fa_0), 0, 4346 }, /* MOVE.B (d16,PC),(An)+ */
{ CPUFUNC(op_10fb_0), 0, 4347 }, /* MOVE.B (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_10fc_0), 0, 4348 }, /* MOVE.B #<data>.B,(An)+ */
{ CPUFUNC(op_1100_0), 0, 4352 }, /* MOVE.B Dn,-(An) */
{ CPUFUNC(op_1110_0), 0, 4368 }, /* MOVE.B (An),-(An) */
{ CPUFUNC(op_1118_0), 0, 4376 }, /* MOVE.B (An)+,-(An) */
{ CPUFUNC(op_1120_0), 0, 4384 }, /* MOVE.B -(An),-(An) */
{ CPUFUNC(op_1128_0), 0, 4392 }, /* MOVE.B (d16,An),-(An) */
{ CPUFUNC(op_1130_0), 0, 4400 }, /* MOVE.B (d8,An,Xn),-(An) */
{ CPUFUNC(op_1138_0), 0, 4408 }, /* MOVE.B (xxx).W,-(An) */
{ CPUFUNC(op_1139_0), 0, 4409 }, /* MOVE.B (xxx).L,-(An) */
{ CPUFUNC(op_113a_0), 0, 4410 }, /* MOVE.B (d16,PC),-(An) */
{ CPUFUNC(op_113b_0), 0, 4411 }, /* MOVE.B (d8,PC,Xn),-(An) */
{ CPUFUNC(op_113c_0), 0, 4412 }, /* MOVE.B #<data>.B,-(An) */
{ CPUFUNC(op_1140_0), 0, 4416 }, /* MOVE.B Dn,(d16,An) */
{ CPUFUNC(op_1150_0), 0, 4432 }, /* MOVE.B (An),(d16,An) */
{ CPUFUNC(op_1158_0), 0, 4440 }, /* MOVE.B (An)+,(d16,An) */
{ CPUFUNC(op_1160_0), 0, 4448 }, /* MOVE.B -(An),(d16,An) */
{ CPUFUNC(op_1168_0), 0, 4456 }, /* MOVE.B (d16,An),(d16,An) */
{ CPUFUNC(op_1170_0), 0, 4464 }, /* MOVE.B (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_1178_0), 0, 4472 }, /* MOVE.B (xxx).W,(d16,An) */
{ CPUFUNC(op_1179_0), 0, 4473 }, /* MOVE.B (xxx).L,(d16,An) */
{ CPUFUNC(op_117a_0), 0, 4474 }, /* MOVE.B (d16,PC),(d16,An) */
{ CPUFUNC(op_117b_0), 0, 4475 }, /* MOVE.B (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_117c_0), 0, 4476 }, /* MOVE.B #<data>.B,(d16,An) */
{ CPUFUNC(op_1180_0), 0, 4480 }, /* MOVE.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1190_0), 0, 4496 }, /* MOVE.B (An),(d8,An,Xn) */
{ CPUFUNC(op_1198_0), 0, 4504 }, /* MOVE.B (An)+,(d8,An,Xn) */
{ CPUFUNC(op_11a0_0), 0, 4512 }, /* MOVE.B -(An),(d8,An,Xn) */
{ CPUFUNC(op_11a8_0), 0, 4520 }, /* MOVE.B (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_11b0_0), 0, 4528 }, /* MOVE.B (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11b8_0), 0, 4536 }, /* MOVE.B (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_11b9_0), 0, 4537 }, /* MOVE.B (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_11ba_0), 0, 4538 }, /* MOVE.B (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_11bb_0), 0, 4539 }, /* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11bc_0), 0, 4540 }, /* MOVE.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_11c0_0), 0, 4544 }, /* MOVE.B Dn,(xxx).W */
{ CPUFUNC(op_11d0_0), 0, 4560 }, /* MOVE.B (An),(xxx).W */
{ CPUFUNC(op_11d8_0), 0, 4568 }, /* MOVE.B (An)+,(xxx).W */
{ CPUFUNC(op_11e0_0), 0, 4576 }, /* MOVE.B -(An),(xxx).W */
{ CPUFUNC(op_11e8_0), 0, 4584 }, /* MOVE.B (d16,An),(xxx).W */
{ CPUFUNC(op_11f0_0), 0, 4592 }, /* MOVE.B (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_11f8_0), 0, 4600 }, /* MOVE.B (xxx).W,(xxx).W */
{ CPUFUNC(op_11f9_0), 0, 4601 }, /* MOVE.B (xxx).L,(xxx).W */
{ CPUFUNC(op_11fa_0), 0, 4602 }, /* MOVE.B (d16,PC),(xxx).W */
{ CPUFUNC(op_11fb_0), 0, 4603 }, /* MOVE.B (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_11fc_0), 0, 4604 }, /* MOVE.B #<data>.B,(xxx).W */
{ CPUFUNC(op_13c0_0), 0, 5056 }, /* MOVE.B Dn,(xxx).L */
{ CPUFUNC(op_13d0_0), 0, 5072 }, /* MOVE.B (An),(xxx).L */
{ CPUFUNC(op_13d8_0), 0, 5080 }, /* MOVE.B (An)+,(xxx).L */
{ CPUFUNC(op_13e0_0), 0, 5088 }, /* MOVE.B -(An),(xxx).L */
{ CPUFUNC(op_13e8_0), 0, 5096 }, /* MOVE.B (d16,An),(xxx).L */
{ CPUFUNC(op_13f0_0), 0, 5104 }, /* MOVE.B (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_13f8_0), 0, 5112 }, /* MOVE.B (xxx).W,(xxx).L */
{ CPUFUNC(op_13f9_0), 0, 5113 }, /* MOVE.B (xxx).L,(xxx).L */
{ CPUFUNC(op_13fa_0), 0, 5114 }, /* MOVE.B (d16,PC),(xxx).L */
{ CPUFUNC(op_13fb_0), 0, 5115 }, /* MOVE.B (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_13fc_0), 0, 5116 }, /* MOVE.B #<data>.B,(xxx).L */
{ CPUFUNC(op_2000_0), 0, 8192 }, /* MOVE.L Dn,Dn */
{ CPUFUNC(op_2008_0), 0, 8200 }, /* MOVE.L An,Dn */
{ CPUFUNC(op_2010_0), 0, 8208 }, /* MOVE.L (An),Dn */
{ CPUFUNC(op_2018_0), 0, 8216 }, /* MOVE.L (An)+,Dn */
{ CPUFUNC(op_2020_0), 0, 8224 }, /* MOVE.L -(An),Dn */
{ CPUFUNC(op_2028_0), 0, 8232 }, /* MOVE.L (d16,An),Dn */
{ CPUFUNC(op_2030_0), 0, 8240 }, /* MOVE.L (d8,An,Xn),Dn */
{ CPUFUNC(op_2038_0), 0, 8248 }, /* MOVE.L (xxx).W,Dn */
{ CPUFUNC(op_2039_0), 0, 8249 }, /* MOVE.L (xxx).L,Dn */
{ CPUFUNC(op_203a_0), 0, 8250 }, /* MOVE.L (d16,PC),Dn */
{ CPUFUNC(op_203b_0), 0, 8251 }, /* MOVE.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_203c_0), 0, 8252 }, /* MOVE.L #<data>.L,Dn */
{ CPUFUNC_FF(op_2040_0), 0, 8256 }, /* MOVEA.L Dn,An */
{ CPUFUNC_FF(op_2048_0), 0, 8264 }, /* MOVEA.L An,An */
{ CPUFUNC_FF(op_2050_0), 0, 8272 }, /* MOVEA.L (An),An */
{ CPUFUNC_FF(op_2058_0), 0, 8280 }, /* MOVEA.L (An)+,An */
{ CPUFUNC_FF(op_2060_0), 0, 8288 }, /* MOVEA.L -(An),An */
{ CPUFUNC_FF(op_2068_0), 0, 8296 }, /* MOVEA.L (d16,An),An */
{ CPUFUNC_FF(op_2070_0), 0, 8304 }, /* MOVEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_2078_0), 0, 8312 }, /* MOVEA.L (xxx).W,An */
{ CPUFUNC_FF(op_2079_0), 0, 8313 }, /* MOVEA.L (xxx).L,An */
{ CPUFUNC_FF(op_207a_0), 0, 8314 }, /* MOVEA.L (d16,PC),An */
{ CPUFUNC_FF(op_207b_0), 0, 8315 }, /* MOVEA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_207c_0), 0, 8316 }, /* MOVEA.L #<data>.L,An */
{ CPUFUNC(op_2080_0), 0, 8320 }, /* MOVE.L Dn,(An) */
{ CPUFUNC(op_2088_0), 0, 8328 }, /* MOVE.L An,(An) */
{ CPUFUNC(op_2090_0), 0, 8336 }, /* MOVE.L (An),(An) */
{ CPUFUNC(op_2098_0), 0, 8344 }, /* MOVE.L (An)+,(An) */
{ CPUFUNC(op_20a0_0), 0, 8352 }, /* MOVE.L -(An),(An) */
{ CPUFUNC(op_20a8_0), 0, 8360 }, /* MOVE.L (d16,An),(An) */
{ CPUFUNC(op_20b0_0), 0, 8368 }, /* MOVE.L (d8,An,Xn),(An) */
{ CPUFUNC(op_20b8_0), 0, 8376 }, /* MOVE.L (xxx).W,(An) */
{ CPUFUNC(op_20b9_0), 0, 8377 }, /* MOVE.L (xxx).L,(An) */
{ CPUFUNC(op_20ba_0), 0, 8378 }, /* MOVE.L (d16,PC),(An) */
{ CPUFUNC(op_20bb_0), 0, 8379 }, /* MOVE.L (d8,PC,Xn),(An) */
{ CPUFUNC(op_20bc_0), 0, 8380 }, /* MOVE.L #<data>.L,(An) */
{ CPUFUNC(op_20c0_0), 0, 8384 }, /* MOVE.L Dn,(An)+ */
{ CPUFUNC(op_20c8_0), 0, 8392 }, /* MOVE.L An,(An)+ */
{ CPUFUNC(op_20d0_0), 0, 8400 }, /* MOVE.L (An),(An)+ */
{ CPUFUNC(op_20d8_0), 0, 8408 }, /* MOVE.L (An)+,(An)+ */
{ CPUFUNC(op_20e0_0), 0, 8416 }, /* MOVE.L -(An),(An)+ */
{ CPUFUNC(op_20e8_0), 0, 8424 }, /* MOVE.L (d16,An),(An)+ */
{ CPUFUNC(op_20f0_0), 0, 8432 }, /* MOVE.L (d8,An,Xn),(An)+ */
{ CPUFUNC(op_20f8_0), 0, 8440 }, /* MOVE.L (xxx).W,(An)+ */
{ CPUFUNC(op_20f9_0), 0, 8441 }, /* MOVE.L (xxx).L,(An)+ */
{ CPUFUNC(op_20fa_0), 0, 8442 }, /* MOVE.L (d16,PC),(An)+ */
{ CPUFUNC(op_20fb_0), 0, 8443 }, /* MOVE.L (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_20fc_0), 0, 8444 }, /* MOVE.L #<data>.L,(An)+ */
{ CPUFUNC(op_2100_0), 0, 8448 }, /* MOVE.L Dn,-(An) */
{ CPUFUNC(op_2108_0), 0, 8456 }, /* MOVE.L An,-(An) */
{ CPUFUNC(op_2110_0), 0, 8464 }, /* MOVE.L (An),-(An) */
{ CPUFUNC(op_2118_0), 0, 8472 }, /* MOVE.L (An)+,-(An) */
{ CPUFUNC(op_2120_0), 0, 8480 }, /* MOVE.L -(An),-(An) */
{ CPUFUNC(op_2128_0), 0, 8488 }, /* MOVE.L (d16,An),-(An) */
{ CPUFUNC(op_2130_0), 0, 8496 }, /* MOVE.L (d8,An,Xn),-(An) */
{ CPUFUNC(op_2138_0), 0, 8504 }, /* MOVE.L (xxx).W,-(An) */
{ CPUFUNC(op_2139_0), 0, 8505 }, /* MOVE.L (xxx).L,-(An) */
{ CPUFUNC(op_213a_0), 0, 8506 }, /* MOVE.L (d16,PC),-(An) */
{ CPUFUNC(op_213b_0), 0, 8507 }, /* MOVE.L (d8,PC,Xn),-(An) */
{ CPUFUNC(op_213c_0), 0, 8508 }, /* MOVE.L #<data>.L,-(An) */
{ CPUFUNC(op_2140_0), 0, 8512 }, /* MOVE.L Dn,(d16,An) */
{ CPUFUNC(op_2148_0), 0, 8520 }, /* MOVE.L An,(d16,An) */
{ CPUFUNC(op_2150_0), 0, 8528 }, /* MOVE.L (An),(d16,An) */
{ CPUFUNC(op_2158_0), 0, 8536 }, /* MOVE.L (An)+,(d16,An) */
{ CPUFUNC(op_2160_0), 0, 8544 }, /* MOVE.L -(An),(d16,An) */
{ CPUFUNC(op_2168_0), 0, 8552 }, /* MOVE.L (d16,An),(d16,An) */
{ CPUFUNC(op_2170_0), 0, 8560 }, /* MOVE.L (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_2178_0), 0, 8568 }, /* MOVE.L (xxx).W,(d16,An) */
{ CPUFUNC(op_2179_0), 0, 8569 }, /* MOVE.L (xxx).L,(d16,An) */
{ CPUFUNC(op_217a_0), 0, 8570 }, /* MOVE.L (d16,PC),(d16,An) */
{ CPUFUNC(op_217b_0), 0, 8571 }, /* MOVE.L (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_217c_0), 0, 8572 }, /* MOVE.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2180_0), 0, 8576 }, /* MOVE.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_2188_0), 0, 8584 }, /* MOVE.L An,(d8,An,Xn) */
{ CPUFUNC(op_2190_0), 0, 8592 }, /* MOVE.L (An),(d8,An,Xn) */
{ CPUFUNC(op_2198_0), 0, 8600 }, /* MOVE.L (An)+,(d8,An,Xn) */
{ CPUFUNC(op_21a0_0), 0, 8608 }, /* MOVE.L -(An),(d8,An,Xn) */
{ CPUFUNC(op_21a8_0), 0, 8616 }, /* MOVE.L (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_21b0_0), 0, 8624 }, /* MOVE.L (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21b8_0), 0, 8632 }, /* MOVE.L (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_21b9_0), 0, 8633 }, /* MOVE.L (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_21ba_0), 0, 8634 }, /* MOVE.L (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_21bb_0), 0, 8635 }, /* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21bc_0), 0, 8636 }, /* MOVE.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_21c0_0), 0, 8640 }, /* MOVE.L Dn,(xxx).W */
{ CPUFUNC(op_21c8_0), 0, 8648 }, /* MOVE.L An,(xxx).W */
{ CPUFUNC(op_21d0_0), 0, 8656 }, /* MOVE.L (An),(xxx).W */
{ CPUFUNC(op_21d8_0), 0, 8664 }, /* MOVE.L (An)+,(xxx).W */
{ CPUFUNC(op_21e0_0), 0, 8672 }, /* MOVE.L -(An),(xxx).W */
{ CPUFUNC(op_21e8_0), 0, 8680 }, /* MOVE.L (d16,An),(xxx).W */
{ CPUFUNC(op_21f0_0), 0, 8688 }, /* MOVE.L (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_21f8_0), 0, 8696 }, /* MOVE.L (xxx).W,(xxx).W */
{ CPUFUNC(op_21f9_0), 0, 8697 }, /* MOVE.L (xxx).L,(xxx).W */
{ CPUFUNC(op_21fa_0), 0, 8698 }, /* MOVE.L (d16,PC),(xxx).W */
{ CPUFUNC(op_21fb_0), 0, 8699 }, /* MOVE.L (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_21fc_0), 0, 8700 }, /* MOVE.L #<data>.L,(xxx).W */
{ CPUFUNC(op_23c0_0), 0, 9152 }, /* MOVE.L Dn,(xxx).L */
{ CPUFUNC(op_23c8_0), 0, 9160 }, /* MOVE.L An,(xxx).L */
{ CPUFUNC(op_23d0_0), 0, 9168 }, /* MOVE.L (An),(xxx).L */
{ CPUFUNC(op_23d8_0), 0, 9176 }, /* MOVE.L (An)+,(xxx).L */
{ CPUFUNC(op_23e0_0), 0, 9184 }, /* MOVE.L -(An),(xxx).L */
{ CPUFUNC(op_23e8_0), 0, 9192 }, /* MOVE.L (d16,An),(xxx).L */
{ CPUFUNC(op_23f0_0), 0, 9200 }, /* MOVE.L (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_23f8_0), 0, 9208 }, /* MOVE.L (xxx).W,(xxx).L */
{ CPUFUNC(op_23f9_0), 0, 9209 }, /* MOVE.L (xxx).L,(xxx).L */
{ CPUFUNC(op_23fa_0), 0, 9210 }, /* MOVE.L (d16,PC),(xxx).L */
{ CPUFUNC(op_23fb_0), 0, 9211 }, /* MOVE.L (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_23fc_0), 0, 9212 }, /* MOVE.L #<data>.L,(xxx).L */
{ CPUFUNC(op_3000_0), 0, 12288 }, /* MOVE.W Dn,Dn */
{ CPUFUNC(op_3008_0), 0, 12296 }, /* MOVE.W An,Dn */
{ CPUFUNC(op_3010_0), 0, 12304 }, /* MOVE.W (An),Dn */
{ CPUFUNC(op_3018_0), 0, 12312 }, /* MOVE.W (An)+,Dn */
{ CPUFUNC(op_3020_0), 0, 12320 }, /* MOVE.W -(An),Dn */
{ CPUFUNC(op_3028_0), 0, 12328 }, /* MOVE.W (d16,An),Dn */
{ CPUFUNC(op_3030_0), 0, 12336 }, /* MOVE.W (d8,An,Xn),Dn */
{ CPUFUNC(op_3038_0), 0, 12344 }, /* MOVE.W (xxx).W,Dn */
{ CPUFUNC(op_3039_0), 0, 12345 }, /* MOVE.W (xxx).L,Dn */
{ CPUFUNC(op_303a_0), 0, 12346 }, /* MOVE.W (d16,PC),Dn */
{ CPUFUNC(op_303b_0), 0, 12347 }, /* MOVE.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_303c_0), 0, 12348 }, /* MOVE.W #<data>.W,Dn */
{ CPUFUNC_FF(op_3040_0), 0, 12352 }, /* MOVEA.W Dn,An */
{ CPUFUNC_FF(op_3048_0), 0, 12360 }, /* MOVEA.W An,An */
{ CPUFUNC_FF(op_3050_0), 0, 12368 }, /* MOVEA.W (An),An */
{ CPUFUNC_FF(op_3058_0), 0, 12376 }, /* MOVEA.W (An)+,An */
{ CPUFUNC_FF(op_3060_0), 0, 12384 }, /* MOVEA.W -(An),An */
{ CPUFUNC_FF(op_3068_0), 0, 12392 }, /* MOVEA.W (d16,An),An */
{ CPUFUNC_FF(op_3070_0), 0, 12400 }, /* MOVEA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_3078_0), 0, 12408 }, /* MOVEA.W (xxx).W,An */
{ CPUFUNC_FF(op_3079_0), 0, 12409 }, /* MOVEA.W (xxx).L,An */
{ CPUFUNC_FF(op_307a_0), 0, 12410 }, /* MOVEA.W (d16,PC),An */
{ CPUFUNC_FF(op_307b_0), 0, 12411 }, /* MOVEA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_307c_0), 0, 12412 }, /* MOVEA.W #<data>.W,An */
{ CPUFUNC(op_3080_0), 0, 12416 }, /* MOVE.W Dn,(An) */
{ CPUFUNC(op_3088_0), 0, 12424 }, /* MOVE.W An,(An) */
{ CPUFUNC(op_3090_0), 0, 12432 }, /* MOVE.W (An),(An) */
{ CPUFUNC(op_3098_0), 0, 12440 }, /* MOVE.W (An)+,(An) */
{ CPUFUNC(op_30a0_0), 0, 12448 }, /* MOVE.W -(An),(An) */
{ CPUFUNC(op_30a8_0), 0, 12456 }, /* MOVE.W (d16,An),(An) */
{ CPUFUNC(op_30b0_0), 0, 12464 }, /* MOVE.W (d8,An,Xn),(An) */
{ CPUFUNC(op_30b8_0), 0, 12472 }, /* MOVE.W (xxx).W,(An) */
{ CPUFUNC(op_30b9_0), 0, 12473 }, /* MOVE.W (xxx).L,(An) */
{ CPUFUNC(op_30ba_0), 0, 12474 }, /* MOVE.W (d16,PC),(An) */
{ CPUFUNC(op_30bb_0), 0, 12475 }, /* MOVE.W (d8,PC,Xn),(An) */
{ CPUFUNC(op_30bc_0), 0, 12476 }, /* MOVE.W #<data>.W,(An) */
{ CPUFUNC(op_30c0_0), 0, 12480 }, /* MOVE.W Dn,(An)+ */
{ CPUFUNC(op_30c8_0), 0, 12488 }, /* MOVE.W An,(An)+ */
{ CPUFUNC(op_30d0_0), 0, 12496 }, /* MOVE.W (An),(An)+ */
{ CPUFUNC(op_30d8_0), 0, 12504 }, /* MOVE.W (An)+,(An)+ */
{ CPUFUNC(op_30e0_0), 0, 12512 }, /* MOVE.W -(An),(An)+ */
{ CPUFUNC(op_30e8_0), 0, 12520 }, /* MOVE.W (d16,An),(An)+ */
{ CPUFUNC(op_30f0_0), 0, 12528 }, /* MOVE.W (d8,An,Xn),(An)+ */
{ CPUFUNC(op_30f8_0), 0, 12536 }, /* MOVE.W (xxx).W,(An)+ */
{ CPUFUNC(op_30f9_0), 0, 12537 }, /* MOVE.W (xxx).L,(An)+ */
{ CPUFUNC(op_30fa_0), 0, 12538 }, /* MOVE.W (d16,PC),(An)+ */
{ CPUFUNC(op_30fb_0), 0, 12539 }, /* MOVE.W (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_30fc_0), 0, 12540 }, /* MOVE.W #<data>.W,(An)+ */
{ CPUFUNC(op_3100_0), 0, 12544 }, /* MOVE.W Dn,-(An) */
{ CPUFUNC(op_3108_0), 0, 12552 }, /* MOVE.W An,-(An) */
{ CPUFUNC(op_3110_0), 0, 12560 }, /* MOVE.W (An),-(An) */
{ CPUFUNC(op_3118_0), 0, 12568 }, /* MOVE.W (An)+,-(An) */
{ CPUFUNC(op_3120_0), 0, 12576 }, /* MOVE.W -(An),-(An) */
{ CPUFUNC(op_3128_0), 0, 12584 }, /* MOVE.W (d16,An),-(An) */
{ CPUFUNC(op_3130_0), 0, 12592 }, /* MOVE.W (d8,An,Xn),-(An) */
{ CPUFUNC(op_3138_0), 0, 12600 }, /* MOVE.W (xxx).W,-(An) */
{ CPUFUNC(op_3139_0), 0, 12601 }, /* MOVE.W (xxx).L,-(An) */
{ CPUFUNC(op_313a_0), 0, 12602 }, /* MOVE.W (d16,PC),-(An) */
{ CPUFUNC(op_313b_0), 0, 12603 }, /* MOVE.W (d8,PC,Xn),-(An) */
{ CPUFUNC(op_313c_0), 0, 12604 }, /* MOVE.W #<data>.W,-(An) */
{ CPUFUNC(op_3140_0), 0, 12608 }, /* MOVE.W Dn,(d16,An) */
{ CPUFUNC(op_3148_0), 0, 12616 }, /* MOVE.W An,(d16,An) */
{ CPUFUNC(op_3150_0), 0, 12624 }, /* MOVE.W (An),(d16,An) */
{ CPUFUNC(op_3158_0), 0, 12632 }, /* MOVE.W (An)+,(d16,An) */
{ CPUFUNC(op_3160_0), 0, 12640 }, /* MOVE.W -(An),(d16,An) */
{ CPUFUNC(op_3168_0), 0, 12648 }, /* MOVE.W (d16,An),(d16,An) */
{ CPUFUNC(op_3170_0), 0, 12656 }, /* MOVE.W (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_3178_0), 0, 12664 }, /* MOVE.W (xxx).W,(d16,An) */
{ CPUFUNC(op_3179_0), 0, 12665 }, /* MOVE.W (xxx).L,(d16,An) */
{ CPUFUNC(op_317a_0), 0, 12666 }, /* MOVE.W (d16,PC),(d16,An) */
{ CPUFUNC(op_317b_0), 0, 12667 }, /* MOVE.W (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_317c_0), 0, 12668 }, /* MOVE.W #<data>.W,(d16,An) */
{ CPUFUNC(op_3180_0), 0, 12672 }, /* MOVE.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_3188_0), 0, 12680 }, /* MOVE.W An,(d8,An,Xn) */
{ CPUFUNC(op_3190_0), 0, 12688 }, /* MOVE.W (An),(d8,An,Xn) */
{ CPUFUNC(op_3198_0), 0, 12696 }, /* MOVE.W (An)+,(d8,An,Xn) */
{ CPUFUNC(op_31a0_0), 0, 12704 }, /* MOVE.W -(An),(d8,An,Xn) */
{ CPUFUNC(op_31a8_0), 0, 12712 }, /* MOVE.W (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_31b0_0), 0, 12720 }, /* MOVE.W (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31b8_0), 0, 12728 }, /* MOVE.W (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_31b9_0), 0, 12729 }, /* MOVE.W (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_31ba_0), 0, 12730 }, /* MOVE.W (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_31bb_0), 0, 12731 }, /* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31bc_0), 0, 12732 }, /* MOVE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_31c0_0), 0, 12736 }, /* MOVE.W Dn,(xxx).W */
{ CPUFUNC(op_31c8_0), 0, 12744 }, /* MOVE.W An,(xxx).W */
{ CPUFUNC(op_31d0_0), 0, 12752 }, /* MOVE.W (An),(xxx).W */
{ CPUFUNC(op_31d8_0), 0, 12760 }, /* MOVE.W (An)+,(xxx).W */
{ CPUFUNC(op_31e0_0), 0, 12768 }, /* MOVE.W -(An),(xxx).W */
{ CPUFUNC(op_31e8_0), 0, 12776 }, /* MOVE.W (d16,An),(xxx).W */
{ CPUFUNC(op_31f0_0), 0, 12784 }, /* MOVE.W (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_31f8_0), 0, 12792 }, /* MOVE.W (xxx).W,(xxx).W */
{ CPUFUNC(op_31f9_0), 0, 12793 }, /* MOVE.W (xxx).L,(xxx).W */
{ CPUFUNC(op_31fa_0), 0, 12794 }, /* MOVE.W (d16,PC),(xxx).W */
{ CPUFUNC(op_31fb_0), 0, 12795 }, /* MOVE.W (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_31fc_0), 0, 12796 }, /* MOVE.W #<data>.W,(xxx).W */
{ CPUFUNC(op_33c0_0), 0, 13248 }, /* MOVE.W Dn,(xxx).L */
{ CPUFUNC(op_33c8_0), 0, 13256 }, /* MOVE.W An,(xxx).L */
{ CPUFUNC(op_33d0_0), 0, 13264 }, /* MOVE.W (An),(xxx).L */
{ CPUFUNC(op_33d8_0), 0, 13272 }, /* MOVE.W (An)+,(xxx).L */
{ CPUFUNC(op_33e0_0), 0, 13280 }, /* MOVE.W -(An),(xxx).L */
{ CPUFUNC(op_33e8_0), 0, 13288 }, /* MOVE.W (d16,An),(xxx).L */
{ CPUFUNC(op_33f0_0), 0, 13296 }, /* MOVE.W (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_33f8_0), 0, 13304 }, /* MOVE.W (xxx).W,(xxx).L */
{ CPUFUNC(op_33f9_0), 0, 13305 }, /* MOVE.W (xxx).L,(xxx).L */
{ CPUFUNC(op_33fa_0), 0, 13306 }, /* MOVE.W (d16,PC),(xxx).L */
{ CPUFUNC(op_33fb_0), 0, 13307 }, /* MOVE.W (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_33fc_0), 0, 13308 }, /* MOVE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_4000_0), 0, 16384 }, /* NEGX.B Dn */
{ CPUFUNC(op_4010_0), 0, 16400 }, /* NEGX.B (An) */
{ CPUFUNC(op_4018_0), 0, 16408 }, /* NEGX.B (An)+ */
{ CPUFUNC(op_4020_0), 0, 16416 }, /* NEGX.B -(An) */
{ CPUFUNC(op_4028_0), 0, 16424 }, /* NEGX.B (d16,An) */
{ CPUFUNC(op_4030_0), 0, 16432 }, /* NEGX.B (d8,An,Xn) */
{ CPUFUNC(op_4038_0), 0, 16440 }, /* NEGX.B (xxx).W */
{ CPUFUNC(op_4039_0), 0, 16441 }, /* NEGX.B (xxx).L */
{ CPUFUNC(op_4040_0), 0, 16448 }, /* NEGX.W Dn */
{ CPUFUNC(op_4050_0), 0, 16464 }, /* NEGX.W (An) */
{ CPUFUNC(op_4058_0), 0, 16472 }, /* NEGX.W (An)+ */
{ CPUFUNC(op_4060_0), 0, 16480 }, /* NEGX.W -(An) */
{ CPUFUNC(op_4068_0), 0, 16488 }, /* NEGX.W (d16,An) */
{ CPUFUNC(op_4070_0), 0, 16496 }, /* NEGX.W (d8,An,Xn) */
{ CPUFUNC(op_4078_0), 0, 16504 }, /* NEGX.W (xxx).W */
{ CPUFUNC(op_4079_0), 0, 16505 }, /* NEGX.W (xxx).L */
{ CPUFUNC(op_4080_0), 0, 16512 }, /* NEGX.L Dn */
{ CPUFUNC(op_4090_0), 0, 16528 }, /* NEGX.L (An) */
{ CPUFUNC(op_4098_0), 0, 16536 }, /* NEGX.L (An)+ */
{ CPUFUNC(op_40a0_0), 0, 16544 }, /* NEGX.L -(An) */
{ CPUFUNC(op_40a8_0), 0, 16552 }, /* NEGX.L (d16,An) */
{ CPUFUNC(op_40b0_0), 0, 16560 }, /* NEGX.L (d8,An,Xn) */
{ CPUFUNC(op_40b8_0), 0, 16568 }, /* NEGX.L (xxx).W */
{ CPUFUNC(op_40b9_0), 0, 16569 }, /* NEGX.L (xxx).L */
{ CPUFUNC_FF(op_40c0_0), 0, 16576 }, /* MVSR2.W Dn */
{ CPUFUNC_FF(op_40d0_0), 0, 16592 }, /* MVSR2.W (An) */
{ CPUFUNC_FF(op_40d8_0), 0, 16600 }, /* MVSR2.W (An)+ */
{ CPUFUNC_FF(op_40e0_0), 0, 16608 }, /* MVSR2.W -(An) */
{ CPUFUNC_FF(op_40e8_0), 0, 16616 }, /* MVSR2.W (d16,An) */
{ CPUFUNC_FF(op_40f0_0), 0, 16624 }, /* MVSR2.W (d8,An,Xn) */
{ CPUFUNC_FF(op_40f8_0), 0, 16632 }, /* MVSR2.W (xxx).W */
{ CPUFUNC_FF(op_40f9_0), 0, 16633 }, /* MVSR2.W (xxx).L */
{ CPUFUNC(op_4100_0), 0, 16640 }, /* CHK.L Dn,Dn */
{ CPUFUNC(op_4110_0), 0, 16656 }, /* CHK.L (An),Dn */
{ CPUFUNC(op_4118_0), 0, 16664 }, /* CHK.L (An)+,Dn */
{ CPUFUNC(op_4120_0), 0, 16672 }, /* CHK.L -(An),Dn */
{ CPUFUNC(op_4128_0), 0, 16680 }, /* CHK.L (d16,An),Dn */
{ CPUFUNC(op_4130_0), 0, 16688 }, /* CHK.L (d8,An,Xn),Dn */
{ CPUFUNC(op_4138_0), 0, 16696 }, /* CHK.L (xxx).W,Dn */
{ CPUFUNC(op_4139_0), 0, 16697 }, /* CHK.L (xxx).L,Dn */
{ CPUFUNC(op_413a_0), 0, 16698 }, /* CHK.L (d16,PC),Dn */
{ CPUFUNC(op_413b_0), 0, 16699 }, /* CHK.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_413c_0), 0, 16700 }, /* CHK.L #<data>.L,Dn */
{ CPUFUNC(op_4180_0), 0, 16768 }, /* CHK.W Dn,Dn */
{ CPUFUNC(op_4190_0), 0, 16784 }, /* CHK.W (An),Dn */
{ CPUFUNC(op_4198_0), 0, 16792 }, /* CHK.W (An)+,Dn */
{ CPUFUNC(op_41a0_0), 0, 16800 }, /* CHK.W -(An),Dn */
{ CPUFUNC(op_41a8_0), 0, 16808 }, /* CHK.W (d16,An),Dn */
{ CPUFUNC(op_41b0_0), 0, 16816 }, /* CHK.W (d8,An,Xn),Dn */
{ CPUFUNC(op_41b8_0), 0, 16824 }, /* CHK.W (xxx).W,Dn */
{ CPUFUNC(op_41b9_0), 0, 16825 }, /* CHK.W (xxx).L,Dn */
{ CPUFUNC(op_41ba_0), 0, 16826 }, /* CHK.W (d16,PC),Dn */
{ CPUFUNC(op_41bb_0), 0, 16827 }, /* CHK.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_41bc_0), 0, 16828 }, /* CHK.W #<data>.W,Dn */
{ CPUFUNC_FF(op_41d0_0), 0, 16848 }, /* LEA.L (An),An */
{ CPUFUNC_FF(op_41e8_0), 0, 16872 }, /* LEA.L (d16,An),An */
{ CPUFUNC_FF(op_41f0_0), 0, 16880 }, /* LEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_41f8_0), 0, 16888 }, /* LEA.L (xxx).W,An */
{ CPUFUNC_FF(op_41f9_0), 0, 16889 }, /* LEA.L (xxx).L,An */
{ CPUFUNC_FF(op_41fa_0), 0, 16890 }, /* LEA.L (d16,PC),An */
{ CPUFUNC_FF(op_41fb_0), 0, 16891 }, /* LEA.L (d8,PC,Xn),An */
{ CPUFUNC(op_4200_0), 0, 16896 }, /* CLR.B Dn */
{ CPUFUNC(op_4210_0), 0, 16912 }, /* CLR.B (An) */
{ CPUFUNC(op_4218_0), 0, 16920 }, /* CLR.B (An)+ */
{ CPUFUNC(op_4220_0), 0, 16928 }, /* CLR.B -(An) */
{ CPUFUNC(op_4228_0), 0, 16936 }, /* CLR.B (d16,An) */
{ CPUFUNC(op_4230_0), 0, 16944 }, /* CLR.B (d8,An,Xn) */
{ CPUFUNC(op_4238_0), 0, 16952 }, /* CLR.B (xxx).W */
{ CPUFUNC(op_4239_0), 0, 16953 }, /* CLR.B (xxx).L */
{ CPUFUNC(op_4240_0), 0, 16960 }, /* CLR.W Dn */
{ CPUFUNC(op_4250_0), 0, 16976 }, /* CLR.W (An) */
{ CPUFUNC(op_4258_0), 0, 16984 }, /* CLR.W (An)+ */
{ CPUFUNC(op_4260_0), 0, 16992 }, /* CLR.W -(An) */
{ CPUFUNC(op_4268_0), 0, 17000 }, /* CLR.W (d16,An) */
{ CPUFUNC(op_4270_0), 0, 17008 }, /* CLR.W (d8,An,Xn) */
{ CPUFUNC(op_4278_0), 0, 17016 }, /* CLR.W (xxx).W */
{ CPUFUNC(op_4279_0), 0, 17017 }, /* CLR.W (xxx).L */
{ CPUFUNC(op_4280_0), 0, 17024 }, /* CLR.L Dn */
{ CPUFUNC(op_4290_0), 0, 17040 }, /* CLR.L (An) */
{ CPUFUNC(op_4298_0), 0, 17048 }, /* CLR.L (An)+ */
{ CPUFUNC(op_42a0_0), 0, 17056 }, /* CLR.L -(An) */
{ CPUFUNC(op_42a8_0), 0, 17064 }, /* CLR.L (d16,An) */
{ CPUFUNC(op_42b0_0), 0, 17072 }, /* CLR.L (d8,An,Xn) */
{ CPUFUNC(op_42b8_0), 0, 17080 }, /* CLR.L (xxx).W */
{ CPUFUNC(op_42b9_0), 0, 17081 }, /* CLR.L (xxx).L */
{ CPUFUNC_FF(op_42c0_0), 0, 17088 }, /* MVSR2.B Dn */
{ CPUFUNC_FF(op_42d0_0), 0, 17104 }, /* MVSR2.B (An) */
{ CPUFUNC_FF(op_42d8_0), 0, 17112 }, /* MVSR2.B (An)+ */
{ CPUFUNC_FF(op_42e0_0), 0, 17120 }, /* MVSR2.B -(An) */
{ CPUFUNC_FF(op_42e8_0), 0, 17128 }, /* MVSR2.B (d16,An) */
{ CPUFUNC_FF(op_42f0_0), 0, 17136 }, /* MVSR2.B (d8,An,Xn) */
{ CPUFUNC_FF(op_42f8_0), 0, 17144 }, /* MVSR2.B (xxx).W */
{ CPUFUNC_FF(op_42f9_0), 0, 17145 }, /* MVSR2.B (xxx).L */
{ CPUFUNC(op_4400_0), 0, 17408 }, /* NEG.B Dn */
{ CPUFUNC(op_4410_0), 0, 17424 }, /* NEG.B (An) */
{ CPUFUNC(op_4418_0), 0, 17432 }, /* NEG.B (An)+ */
{ CPUFUNC(op_4420_0), 0, 17440 }, /* NEG.B -(An) */
{ CPUFUNC(op_4428_0), 0, 17448 }, /* NEG.B (d16,An) */
{ CPUFUNC(op_4430_0), 0, 17456 }, /* NEG.B (d8,An,Xn) */
{ CPUFUNC(op_4438_0), 0, 17464 }, /* NEG.B (xxx).W */
{ CPUFUNC(op_4439_0), 0, 17465 }, /* NEG.B (xxx).L */
{ CPUFUNC(op_4440_0), 0, 17472 }, /* NEG.W Dn */
{ CPUFUNC(op_4450_0), 0, 17488 }, /* NEG.W (An) */
{ CPUFUNC(op_4458_0), 0, 17496 }, /* NEG.W (An)+ */
{ CPUFUNC(op_4460_0), 0, 17504 }, /* NEG.W -(An) */
{ CPUFUNC(op_4468_0), 0, 17512 }, /* NEG.W (d16,An) */
{ CPUFUNC(op_4470_0), 0, 17520 }, /* NEG.W (d8,An,Xn) */
{ CPUFUNC(op_4478_0), 0, 17528 }, /* NEG.W (xxx).W */
{ CPUFUNC(op_4479_0), 0, 17529 }, /* NEG.W (xxx).L */
{ CPUFUNC(op_4480_0), 0, 17536 }, /* NEG.L Dn */
{ CPUFUNC(op_4490_0), 0, 17552 }, /* NEG.L (An) */
{ CPUFUNC(op_4498_0), 0, 17560 }, /* NEG.L (An)+ */
{ CPUFUNC(op_44a0_0), 0, 17568 }, /* NEG.L -(An) */
{ CPUFUNC(op_44a8_0), 0, 17576 }, /* NEG.L (d16,An) */
{ CPUFUNC(op_44b0_0), 0, 17584 }, /* NEG.L (d8,An,Xn) */
{ CPUFUNC(op_44b8_0), 0, 17592 }, /* NEG.L (xxx).W */
{ CPUFUNC(op_44b9_0), 0, 17593 }, /* NEG.L (xxx).L */
{ CPUFUNC(op_44c0_0), 0, 17600 }, /* MV2SR.B Dn */
{ CPUFUNC(op_44d0_0), 0, 17616 }, /* MV2SR.B (An) */
{ CPUFUNC(op_44d8_0), 0, 17624 }, /* MV2SR.B (An)+ */
{ CPUFUNC(op_44e0_0), 0, 17632 }, /* MV2SR.B -(An) */
{ CPUFUNC(op_44e8_0), 0, 17640 }, /* MV2SR.B (d16,An) */
{ CPUFUNC(op_44f0_0), 0, 17648 }, /* MV2SR.B (d8,An,Xn) */
{ CPUFUNC(op_44f8_0), 0, 17656 }, /* MV2SR.B (xxx).W */
{ CPUFUNC(op_44f9_0), 0, 17657 }, /* MV2SR.B (xxx).L */
{ CPUFUNC(op_44fa_0), 0, 17658 }, /* MV2SR.B (d16,PC) */
{ CPUFUNC(op_44fb_0), 0, 17659 }, /* MV2SR.B (d8,PC,Xn) */
{ CPUFUNC(op_44fc_0), 0, 17660 }, /* MV2SR.B #<data>.B */
{ CPUFUNC(op_4600_0), 0, 17920 }, /* NOT.B Dn */
{ CPUFUNC(op_4610_0), 0, 17936 }, /* NOT.B (An) */
{ CPUFUNC(op_4618_0), 0, 17944 }, /* NOT.B (An)+ */
{ CPUFUNC(op_4620_0), 0, 17952 }, /* NOT.B -(An) */
{ CPUFUNC(op_4628_0), 0, 17960 }, /* NOT.B (d16,An) */
{ CPUFUNC(op_4630_0), 0, 17968 }, /* NOT.B (d8,An,Xn) */
{ CPUFUNC(op_4638_0), 0, 17976 }, /* NOT.B (xxx).W */
{ CPUFUNC(op_4639_0), 0, 17977 }, /* NOT.B (xxx).L */
{ CPUFUNC(op_4640_0), 0, 17984 }, /* NOT.W Dn */
{ CPUFUNC(op_4650_0), 0, 18000 }, /* NOT.W (An) */
{ CPUFUNC(op_4658_0), 0, 18008 }, /* NOT.W (An)+ */
{ CPUFUNC(op_4660_0), 0, 18016 }, /* NOT.W -(An) */
{ CPUFUNC(op_4668_0), 0, 18024 }, /* NOT.W (d16,An) */
{ CPUFUNC(op_4670_0), 0, 18032 }, /* NOT.W (d8,An,Xn) */
{ CPUFUNC(op_4678_0), 0, 18040 }, /* NOT.W (xxx).W */
{ CPUFUNC(op_4679_0), 0, 18041 }, /* NOT.W (xxx).L */
{ CPUFUNC(op_4680_0), 0, 18048 }, /* NOT.L Dn */
{ CPUFUNC(op_4690_0), 0, 18064 }, /* NOT.L (An) */
{ CPUFUNC(op_4698_0), 0, 18072 }, /* NOT.L (An)+ */
{ CPUFUNC(op_46a0_0), 0, 18080 }, /* NOT.L -(An) */
{ CPUFUNC(op_46a8_0), 0, 18088 }, /* NOT.L (d16,An) */
{ CPUFUNC(op_46b0_0), 0, 18096 }, /* NOT.L (d8,An,Xn) */
{ CPUFUNC(op_46b8_0), 0, 18104 }, /* NOT.L (xxx).W */
{ CPUFUNC(op_46b9_0), 0, 18105 }, /* NOT.L (xxx).L */
{ CPUFUNC(op_46c0_0), 0, 18112 }, /* MV2SR.W Dn */
{ CPUFUNC(op_46d0_0), 0, 18128 }, /* MV2SR.W (An) */
{ CPUFUNC(op_46d8_0), 0, 18136 }, /* MV2SR.W (An)+ */
{ CPUFUNC(op_46e0_0), 0, 18144 }, /* MV2SR.W -(An) */
{ CPUFUNC(op_46e8_0), 0, 18152 }, /* MV2SR.W (d16,An) */
{ CPUFUNC(op_46f0_0), 0, 18160 }, /* MV2SR.W (d8,An,Xn) */
{ CPUFUNC(op_46f8_0), 0, 18168 }, /* MV2SR.W (xxx).W */
{ CPUFUNC(op_46f9_0), 0, 18169 }, /* MV2SR.W (xxx).L */
{ CPUFUNC(op_46fa_0), 0, 18170 }, /* MV2SR.W (d16,PC) */
{ CPUFUNC(op_46fb_0), 0, 18171 }, /* MV2SR.W (d8,PC,Xn) */
{ CPUFUNC(op_46fc_0), 0, 18172 }, /* MV2SR.W #<data>.W */
{ CPUFUNC(op_4800_1), 0, 18432 }, /* NBCD.B Dn */
{ CPUFUNC_FF(op_4808_0), 0, 18440 }, /* LINK.L An,#<data>.L */
{ CPUFUNC(op_4810_1), 0, 18448 }, /* NBCD.B (An) */
{ CPUFUNC(op_4818_1), 0, 18456 }, /* NBCD.B (An)+ */
{ CPUFUNC(op_4820_1), 0, 18464 }, /* NBCD.B -(An) */
{ CPUFUNC(op_4828_1), 0, 18472 }, /* NBCD.B (d16,An) */
{ CPUFUNC(op_4830_1), 0, 18480 }, /* NBCD.B (d8,An,Xn) */
{ CPUFUNC(op_4838_1), 0, 18488 }, /* NBCD.B (xxx).W */
{ CPUFUNC(op_4839_1), 0, 18489 }, /* NBCD.B (xxx).L */
{ CPUFUNC(op_4840_0), 0, 18496 }, /* SWAP.W Dn */
{ CPUFUNC_FF(op_4848_0), 0, 18504 }, /* BKPT.L #<data> */
{ CPUFUNC_FF(op_4850_0), 0, 18512 }, /* PEA.L (An) */
{ CPUFUNC_FF(op_4868_0), 0, 18536 }, /* PEA.L (d16,An) */
{ CPUFUNC_FF(op_4870_0), 0, 18544 }, /* PEA.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4878_0), 0, 18552 }, /* PEA.L (xxx).W */
{ CPUFUNC_FF(op_4879_0), 0, 18553 }, /* PEA.L (xxx).L */
{ CPUFUNC_FF(op_487a_0), 0, 18554 }, /* PEA.L (d16,PC) */
{ CPUFUNC_FF(op_487b_0), 0, 18555 }, /* PEA.L (d8,PC,Xn) */
{ CPUFUNC(op_4880_0), 0, 18560 }, /* EXT.W Dn */
{ CPUFUNC_FF(op_4890_0), 0, 18576 }, /* MVMLE.W #<data>.W,(An) */
{ CPUFUNC_FF(op_48a0_0), 0, 18592 }, /* MVMLE.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_48a8_0), 0, 18600 }, /* MVMLE.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48b0_0), 0, 18608 }, /* MVMLE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48b8_0), 0, 18616 }, /* MVMLE.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48b9_0), 0, 18617 }, /* MVMLE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_48c0_0), 0, 18624 }, /* EXT.L Dn */
{ CPUFUNC_FF(op_48d0_0), 0, 18640 }, /* MVMLE.L #<data>.W,(An) */
{ CPUFUNC_FF(op_48e0_0), 0, 18656 }, /* MVMLE.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_48e8_0), 0, 18664 }, /* MVMLE.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48f0_0), 0, 18672 }, /* MVMLE.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48f8_0), 0, 18680 }, /* MVMLE.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48f9_0), 0, 18681 }, /* MVMLE.L #<data>.W,(xxx).L */
{ CPUFUNC(op_49c0_0), 0, 18880 }, /* EXT.B Dn */
{ CPUFUNC(op_4a00_0), 0, 18944 }, /* TST.B Dn */
{ CPUFUNC(op_4a10_0), 0, 18960 }, /* TST.B (An) */
{ CPUFUNC(op_4a18_0), 0, 18968 }, /* TST.B (An)+ */
{ CPUFUNC(op_4a20_0), 0, 18976 }, /* TST.B -(An) */
{ CPUFUNC(op_4a28_0), 0, 18984 }, /* TST.B (d16,An) */
{ CPUFUNC(op_4a30_0), 0, 18992 }, /* TST.B (d8,An,Xn) */
{ CPUFUNC(op_4a38_0), 0, 19000 }, /* TST.B (xxx).W */
{ CPUFUNC(op_4a39_0), 0, 19001 }, /* TST.B (xxx).L */
{ CPUFUNC(op_4a3a_0), 0, 19002 }, /* TST.B (d16,PC) */
{ CPUFUNC(op_4a3b_0), 0, 19003 }, /* TST.B (d8,PC,Xn) */
{ CPUFUNC(op_4a3c_0), 0, 19004 }, /* TST.B #<data>.B */
{ CPUFUNC(op_4a40_0), 0, 19008 }, /* TST.W Dn */
{ CPUFUNC(op_4a48_0), 0, 19016 }, /* TST.W An */
{ CPUFUNC(op_4a50_0), 0, 19024 }, /* TST.W (An) */
{ CPUFUNC(op_4a58_0), 0, 19032 }, /* TST.W (An)+ */
{ CPUFUNC(op_4a60_0), 0, 19040 }, /* TST.W -(An) */
{ CPUFUNC(op_4a68_0), 0, 19048 }, /* TST.W (d16,An) */
{ CPUFUNC(op_4a70_0), 0, 19056 }, /* TST.W (d8,An,Xn) */
{ CPUFUNC(op_4a78_0), 0, 19064 }, /* TST.W (xxx).W */
{ CPUFUNC(op_4a79_0), 0, 19065 }, /* TST.W (xxx).L */
{ CPUFUNC(op_4a7a_0), 0, 19066 }, /* TST.W (d16,PC) */
{ CPUFUNC(op_4a7b_0), 0, 19067 }, /* TST.W (d8,PC,Xn) */
{ CPUFUNC(op_4a7c_0), 0, 19068 }, /* TST.W #<data>.W */
{ CPUFUNC(op_4a80_0), 0, 19072 }, /* TST.L Dn */
{ CPUFUNC(op_4a88_0), 0, 19080 }, /* TST.L An */
{ CPUFUNC(op_4a90_0), 0, 19088 }, /* TST.L (An) */
{ CPUFUNC(op_4a98_0), 0, 19096 }, /* TST.L (An)+ */
{ CPUFUNC(op_4aa0_0), 0, 19104 }, /* TST.L -(An) */
{ CPUFUNC(op_4aa8_0), 0, 19112 }, /* TST.L (d16,An) */
{ CPUFUNC(op_4ab0_0), 0, 19120 }, /* TST.L (d8,An,Xn) */
{ CPUFUNC(op_4ab8_0), 0, 19128 }, /* TST.L (xxx).W */
{ CPUFUNC(op_4ab9_0), 0, 19129 }, /* TST.L (xxx).L */
{ CPUFUNC(op_4aba_0), 0, 19130 }, /* TST.L (d16,PC) */
{ CPUFUNC(op_4abb_0), 0, 19131 }, /* TST.L (d8,PC,Xn) */
{ CPUFUNC(op_4abc_0), 0, 19132 }, /* TST.L #<data>.L */
{ CPUFUNC(op_4ac0_0), 0, 19136 }, /* TAS.B Dn */
{ CPUFUNC(op_4ad0_0), 0, 19152 }, /* TAS.B (An) */
{ CPUFUNC(op_4ad8_0), 0, 19160 }, /* TAS.B (An)+ */
{ CPUFUNC(op_4ae0_0), 0, 19168 }, /* TAS.B -(An) */
{ CPUFUNC(op_4ae8_0), 0, 19176 }, /* TAS.B (d16,An) */
{ CPUFUNC(op_4af0_0), 0, 19184 }, /* TAS.B (d8,An,Xn) */
{ CPUFUNC(op_4af8_0), 0, 19192 }, /* TAS.B (xxx).W */
{ CPUFUNC(op_4af9_0), 0, 19193 }, /* TAS.B (xxx).L */
{ CPUFUNC(op_4c00_0), 0, 19456 }, /* MULL.L #<data>.W,Dn */
{ CPUFUNC(op_4c10_0), 0, 19472 }, /* MULL.L #<data>.W,(An) */
{ CPUFUNC(op_4c18_0), 0, 19480 }, /* MULL.L #<data>.W,(An)+ */
{ CPUFUNC(op_4c20_0), 0, 19488 }, /* MULL.L #<data>.W,-(An) */
{ CPUFUNC(op_4c28_0), 0, 19496 }, /* MULL.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4c30_0), 0, 19504 }, /* MULL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4c38_0), 0, 19512 }, /* MULL.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4c39_0), 0, 19513 }, /* MULL.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4c3a_0), 0, 19514 }, /* MULL.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4c3b_0), 0, 19515 }, /* MULL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_4c3c_0), 0, 19516 }, /* MULL.L #<data>.W,#<data>.L */
{ CPUFUNC(op_4c40_0), 0, 19520 }, /* DIVL.L #<data>.W,Dn */
{ CPUFUNC(op_4c50_0), 0, 19536 }, /* DIVL.L #<data>.W,(An) */
{ CPUFUNC(op_4c58_0), 0, 19544 }, /* DIVL.L #<data>.W,(An)+ */
{ CPUFUNC(op_4c60_0), 0, 19552 }, /* DIVL.L #<data>.W,-(An) */
{ CPUFUNC(op_4c68_0), 0, 19560 }, /* DIVL.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4c70_0), 0, 19568 }, /* DIVL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4c78_0), 0, 19576 }, /* DIVL.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4c79_0), 0, 19577 }, /* DIVL.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4c7a_0), 0, 19578 }, /* DIVL.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4c7b_0), 0, 19579 }, /* DIVL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_4c7c_0), 0, 19580 }, /* DIVL.L #<data>.W,#<data>.L */
{ CPUFUNC_FF(op_4c90_0), 0, 19600 }, /* MVMEL.W #<data>.W,(An) */
{ CPUFUNC_FF(op_4c98_0), 0, 19608 }, /* MVMEL.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ca8_0), 0, 19624 }, /* MVMEL.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cb0_0), 0, 19632 }, /* MVMEL.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cb8_0), 0, 19640 }, /* MVMEL.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cb9_0), 0, 19641 }, /* MVMEL.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cba_0), 0, 19642 }, /* MVMEL.W #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cbb_0), 0, 19643 }, /* MVMEL.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4cd0_0), 0, 19664 }, /* MVMEL.L #<data>.W,(An) */
{ CPUFUNC_FF(op_4cd8_0), 0, 19672 }, /* MVMEL.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ce8_0), 0, 19688 }, /* MVMEL.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cf0_0), 0, 19696 }, /* MVMEL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cf8_0), 0, 19704 }, /* MVMEL.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cf9_0), 0, 19705 }, /* MVMEL.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cfa_0), 0, 19706 }, /* MVMEL.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cfb_0), 0, 19707 }, /* MVMEL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4e40_0), 0, 20032 }, /* TRAP.L #<data> */
{ CPUFUNC_FF(op_4e50_0), 0, 20048 }, /* LINK.W An,#<data>.W */
{ CPUFUNC_FF(op_4e58_0), 0, 20056 }, /* UNLK.L An */
{ CPUFUNC_FF(op_4e60_0), 0, 20064 }, /* MVR2USP.L An */
{ CPUFUNC_FF(op_4e68_0), 0, 20072 }, /* MVUSP2R.L An */
{ CPUFUNC_FF(op_4e70_0), 0, 20080 }, /* RESET.L  */
{ CPUFUNC_FF(op_4e71_0), 0, 20081 }, /* NOP.L  */
{ CPUFUNC(op_4e72_0), 0, 20082 }, /* STOP.L #<data>.W */
{ CPUFUNC(op_4e73_0), 0, 20083 }, /* RTE.L  */
{ CPUFUNC_FF(op_4e74_0), 0, 20084 }, /* RTD.L #<data>.W */
{ CPUFUNC_FF(op_4e75_0), 0, 20085 }, /* RTS.L  */
{ CPUFUNC_FF(op_4e76_0), 0, 20086 }, /* TRAPV.L  */
{ CPUFUNC(op_4e77_0), 0, 20087 }, /* RTR.L  */
{ CPUFUNC_FF(op_4e7a_0), 0, 20090 }, /* MOVEC2.L #<data>.W */
{ CPUFUNC_FF(op_4e7b_0), 0, 20091 }, /* MOVE2C.L #<data>.W */
{ CPUFUNC_FF(op_4e90_0), 0, 20112 }, /* JSR.L (An) */
{ CPUFUNC_FF(op_4ea8_0), 0, 20136 }, /* JSR.L (d16,An) */
{ CPUFUNC_FF(op_4eb0_0), 0, 20144 }, /* JSR.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4eb8_0), 0, 20152 }, /* JSR.L (xxx).W */
{ CPUFUNC_FF(op_4eb9_0), 0, 20153 }, /* JSR.L (xxx).L */
{ CPUFUNC_FF(op_4eba_0), 0, 20154 }, /* JSR.L (d16,PC) */
{ CPUFUNC_FF(op_4ebb_0), 0, 20155 }, /* JSR.L (d8,PC,Xn) */
{ CPUFUNC_FF(op_4ed0_0), 0, 20176 }, /* JMP.L (An) */
{ CPUFUNC_FF(op_4ee8_0), 0, 20200 }, /* JMP.L (d16,An) */
{ CPUFUNC_FF(op_4ef0_0), 0, 20208 }, /* JMP.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4ef8_0), 0, 20216 }, /* JMP.L (xxx).W */
{ CPUFUNC_FF(op_4ef9_0), 0, 20217 }, /* JMP.L (xxx).L */
{ CPUFUNC_FF(op_4efa_0), 0, 20218 }, /* JMP.L (d16,PC) */
{ CPUFUNC_FF(op_4efb_0), 0, 20219 }, /* JMP.L (d8,PC,Xn) */
{ CPUFUNC(op_5000_0), 0, 20480 }, /* ADD.B #<data>,Dn */
{ CPUFUNC(op_5010_0), 0, 20496 }, /* ADD.B #<data>,(An) */
{ CPUFUNC(op_5018_0), 0, 20504 }, /* ADD.B #<data>,(An)+ */
{ CPUFUNC(op_5020_0), 0, 20512 }, /* ADD.B #<data>,-(An) */
{ CPUFUNC(op_5028_0), 0, 20520 }, /* ADD.B #<data>,(d16,An) */
{ CPUFUNC(op_5030_0), 0, 20528 }, /* ADD.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5038_0), 0, 20536 }, /* ADD.B #<data>,(xxx).W */
{ CPUFUNC(op_5039_0), 0, 20537 }, /* ADD.B #<data>,(xxx).L */
{ CPUFUNC(op_5040_0), 0, 20544 }, /* ADD.W #<data>,Dn */
{ CPUFUNC_FF(op_5048_0), 0, 20552 }, /* ADDA.W #<data>,An */
{ CPUFUNC(op_5050_0), 0, 20560 }, /* ADD.W #<data>,(An) */
{ CPUFUNC(op_5058_0), 0, 20568 }, /* ADD.W #<data>,(An)+ */
{ CPUFUNC(op_5060_0), 0, 20576 }, /* ADD.W #<data>,-(An) */
{ CPUFUNC(op_5068_0), 0, 20584 }, /* ADD.W #<data>,(d16,An) */
{ CPUFUNC(op_5070_0), 0, 20592 }, /* ADD.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5078_0), 0, 20600 }, /* ADD.W #<data>,(xxx).W */
{ CPUFUNC(op_5079_0), 0, 20601 }, /* ADD.W #<data>,(xxx).L */
{ CPUFUNC(op_5080_0), 0, 20608 }, /* ADD.L #<data>,Dn */
{ CPUFUNC_FF(op_5088_0), 0, 20616 }, /* ADDA.L #<data>,An */
{ CPUFUNC(op_5090_0), 0, 20624 }, /* ADD.L #<data>,(An) */
{ CPUFUNC(op_5098_0), 0, 20632 }, /* ADD.L #<data>,(An)+ */
{ CPUFUNC(op_50a0_0), 0, 20640 }, /* ADD.L #<data>,-(An) */
{ CPUFUNC(op_50a8_0), 0, 20648 }, /* ADD.L #<data>,(d16,An) */
{ CPUFUNC(op_50b0_0), 0, 20656 }, /* ADD.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_50b8_0), 0, 20664 }, /* ADD.L #<data>,(xxx).W */
{ CPUFUNC(op_50b9_0), 0, 20665 }, /* ADD.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_50c0_0), 0, 20672 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_50c8_0), 0, 20680 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_50d0_0), 0, 20688 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_50d8_0), 0, 20696 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_50e0_0), 0, 20704 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_50e8_0), 0, 20712 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_50f0_0), 0, 20720 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_50f8_0), 0, 20728 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_50f9_0), 0, 20729 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_50fa_0), 0, 20730 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_50fb_0), 0, 20731 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_50fc_0), 0, 20732 }, /* TRAPcc.L  */
{ CPUFUNC(op_5100_0), 0, 20736 }, /* SUB.B #<data>,Dn */
{ CPUFUNC(op_5110_0), 0, 20752 }, /* SUB.B #<data>,(An) */
{ CPUFUNC(op_5118_0), 0, 20760 }, /* SUB.B #<data>,(An)+ */
{ CPUFUNC(op_5120_0), 0, 20768 }, /* SUB.B #<data>,-(An) */
{ CPUFUNC(op_5128_0), 0, 20776 }, /* SUB.B #<data>,(d16,An) */
{ CPUFUNC(op_5130_0), 0, 20784 }, /* SUB.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5138_0), 0, 20792 }, /* SUB.B #<data>,(xxx).W */
{ CPUFUNC(op_5139_0), 0, 20793 }, /* SUB.B #<data>,(xxx).L */
{ CPUFUNC(op_5140_0), 0, 20800 }, /* SUB.W #<data>,Dn */
{ CPUFUNC_FF(op_5148_0), 0, 20808 }, /* SUBA.W #<data>,An */
{ CPUFUNC(op_5150_0), 0, 20816 }, /* SUB.W #<data>,(An) */
{ CPUFUNC(op_5158_0), 0, 20824 }, /* SUB.W #<data>,(An)+ */
{ CPUFUNC(op_5160_0), 0, 20832 }, /* SUB.W #<data>,-(An) */
{ CPUFUNC(op_5168_0), 0, 20840 }, /* SUB.W #<data>,(d16,An) */
{ CPUFUNC(op_5170_0), 0, 20848 }, /* SUB.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5178_0), 0, 20856 }, /* SUB.W #<data>,(xxx).W */
{ CPUFUNC(op_5179_0), 0, 20857 }, /* SUB.W #<data>,(xxx).L */
{ CPUFUNC(op_5180_0), 0, 20864 }, /* SUB.L #<data>,Dn */
{ CPUFUNC_FF(op_5188_0), 0, 20872 }, /* SUBA.L #<data>,An */
{ CPUFUNC(op_5190_0), 0, 20880 }, /* SUB.L #<data>,(An) */
{ CPUFUNC(op_5198_0), 0, 20888 }, /* SUB.L #<data>,(An)+ */
{ CPUFUNC(op_51a0_0), 0, 20896 }, /* SUB.L #<data>,-(An) */
{ CPUFUNC(op_51a8_0), 0, 20904 }, /* SUB.L #<data>,(d16,An) */
{ CPUFUNC(op_51b0_0), 0, 20912 }, /* SUB.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_51b8_0), 0, 20920 }, /* SUB.L #<data>,(xxx).W */
{ CPUFUNC(op_51b9_0), 0, 20921 }, /* SUB.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_51c0_0), 0, 20928 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_51c8_0), 0, 20936 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_51d0_0), 0, 20944 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_51d8_0), 0, 20952 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_51e0_0), 0, 20960 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_51e8_0), 0, 20968 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_51f0_0), 0, 20976 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_51f8_0), 0, 20984 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_51f9_0), 0, 20985 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_51fa_0), 0, 20986 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_51fb_0), 0, 20987 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_51fc_0), 0, 20988 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_52c0_0), 0, 21184 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_52c8_0), 0, 21192 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_52d0_0), 0, 21200 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_52d8_0), 0, 21208 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_52e0_0), 0, 21216 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_52e8_0), 0, 21224 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_52f0_0), 0, 21232 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_52f8_0), 0, 21240 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_52f9_0), 0, 21241 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_52fa_0), 0, 21242 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_52fb_0), 0, 21243 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_52fc_0), 0, 21244 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_53c0_0), 0, 21440 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_53c8_0), 0, 21448 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_53d0_0), 0, 21456 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_53d8_0), 0, 21464 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_53e0_0), 0, 21472 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_53e8_0), 0, 21480 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_53f0_0), 0, 21488 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_53f8_0), 0, 21496 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_53f9_0), 0, 21497 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_53fa_0), 0, 21498 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_53fb_0), 0, 21499 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_53fc_0), 0, 21500 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_54c0_0), 0, 21696 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_54c8_0), 0, 21704 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_54d0_0), 0, 21712 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_54d8_0), 0, 21720 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_54e0_0), 0, 21728 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_54e8_0), 0, 21736 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_54f0_0), 0, 21744 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_54f8_0), 0, 21752 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_54f9_0), 0, 21753 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_54fa_0), 0, 21754 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_54fb_0), 0, 21755 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_54fc_0), 0, 21756 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_55c0_0), 0, 21952 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_55c8_0), 0, 21960 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_55d0_0), 0, 21968 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_55d8_0), 0, 21976 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_55e0_0), 0, 21984 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_55e8_0), 0, 21992 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_55f0_0), 0, 22000 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_55f8_0), 0, 22008 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_55f9_0), 0, 22009 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_55fa_0), 0, 22010 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_55fb_0), 0, 22011 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_55fc_0), 0, 22012 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_56c0_0), 0, 22208 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_56c8_0), 0, 22216 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_56d0_0), 0, 22224 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_56d8_0), 0, 22232 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_56e0_0), 0, 22240 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_56e8_0), 0, 22248 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_56f0_0), 0, 22256 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_56f8_0), 0, 22264 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_56f9_0), 0, 22265 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_56fa_0), 0, 22266 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_56fb_0), 0, 22267 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_56fc_0), 0, 22268 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_57c0_0), 0, 22464 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_57c8_0), 0, 22472 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_57d0_0), 0, 22480 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_57d8_0), 0, 22488 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_57e0_0), 0, 22496 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_57e8_0), 0, 22504 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_57f0_0), 0, 22512 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_57f8_0), 0, 22520 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_57f9_0), 0, 22521 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_57fa_0), 0, 22522 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_57fb_0), 0, 22523 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_57fc_0), 0, 22524 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_58c0_0), 0, 22720 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_58c8_0), 0, 22728 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_58d0_0), 0, 22736 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_58d8_0), 0, 22744 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_58e0_0), 0, 22752 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_58e8_0), 0, 22760 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_58f0_0), 0, 22768 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_58f8_0), 0, 22776 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_58f9_0), 0, 22777 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_58fa_0), 0, 22778 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_58fb_0), 0, 22779 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_58fc_0), 0, 22780 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_59c0_0), 0, 22976 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_59c8_0), 0, 22984 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_59d0_0), 0, 22992 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_59d8_0), 0, 23000 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_59e0_0), 0, 23008 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_59e8_0), 0, 23016 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_59f0_0), 0, 23024 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_59f8_0), 0, 23032 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_59f9_0), 0, 23033 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_59fa_0), 0, 23034 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_59fb_0), 0, 23035 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_59fc_0), 0, 23036 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5ac0_0), 0, 23232 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ac8_0), 0, 23240 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ad0_0), 0, 23248 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ad8_0), 0, 23256 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ae0_0), 0, 23264 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ae8_0), 0, 23272 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5af0_0), 0, 23280 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5af8_0), 0, 23288 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5af9_0), 0, 23289 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5afa_0), 0, 23290 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5afb_0), 0, 23291 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5afc_0), 0, 23292 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5bc0_0), 0, 23488 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5bc8_0), 0, 23496 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5bd0_0), 0, 23504 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5bd8_0), 0, 23512 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5be0_0), 0, 23520 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5be8_0), 0, 23528 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5bf0_0), 0, 23536 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5bf8_0), 0, 23544 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5bf9_0), 0, 23545 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5bfa_0), 0, 23546 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5bfb_0), 0, 23547 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5bfc_0), 0, 23548 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5cc0_0), 0, 23744 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5cc8_0), 0, 23752 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5cd0_0), 0, 23760 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5cd8_0), 0, 23768 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ce0_0), 0, 23776 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ce8_0), 0, 23784 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5cf0_0), 0, 23792 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5cf8_0), 0, 23800 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5cf9_0), 0, 23801 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5cfa_0), 0, 23802 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5cfb_0), 0, 23803 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5cfc_0), 0, 23804 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5dc0_0), 0, 24000 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5dc8_0), 0, 24008 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5dd0_0), 0, 24016 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5dd8_0), 0, 24024 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5de0_0), 0, 24032 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5de8_0), 0, 24040 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5df0_0), 0, 24048 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5df8_0), 0, 24056 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5df9_0), 0, 24057 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5dfa_0), 0, 24058 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5dfb_0), 0, 24059 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5dfc_0), 0, 24060 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5ec0_0), 0, 24256 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ec8_0), 0, 24264 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ed0_0), 0, 24272 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ed8_0), 0, 24280 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ee0_0), 0, 24288 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ee8_0), 0, 24296 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ef0_0), 0, 24304 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ef8_0), 0, 24312 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ef9_0), 0, 24313 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5efa_0), 0, 24314 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5efb_0), 0, 24315 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5efc_0), 0, 24316 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5fc0_0), 0, 24512 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5fc8_0), 0, 24520 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5fd0_0), 0, 24528 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5fd8_0), 0, 24536 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5fe0_0), 0, 24544 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5fe8_0), 0, 24552 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ff0_0), 0, 24560 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ff8_0), 0, 24568 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ff9_0), 0, 24569 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ffa_0), 0, 24570 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5ffb_0), 0, 24571 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5ffc_0), 0, 24572 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_6000_0), 0, 24576 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6001_0), 0, 24577 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_60ff_0), 0, 24831 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6100_0), 0, 24832 }, /* BSR.W #<data>.W */
{ CPUFUNC_FF(op_6101_0), 0, 24833 }, /* BSR.B #<data> */
{ CPUFUNC_FF(op_61ff_0), 0, 25087 }, /* BSR.L #<data>.L */
{ CPUFUNC_FF(op_6200_0), 0, 25088 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6201_0), 0, 25089 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_62ff_0), 0, 25343 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6300_0), 0, 25344 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6301_0), 0, 25345 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_63ff_0), 0, 25599 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6400_0), 0, 25600 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6401_0), 0, 25601 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_64ff_0), 0, 25855 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6500_0), 0, 25856 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6501_0), 0, 25857 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_65ff_0), 0, 26111 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6600_0), 0, 26112 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6601_0), 0, 26113 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_66ff_0), 0, 26367 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6700_0), 0, 26368 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6701_0), 0, 26369 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_67ff_0), 0, 26623 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6800_0), 0, 26624 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6801_0), 0, 26625 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_68ff_0), 0, 26879 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6900_0), 0, 26880 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6901_0), 0, 26881 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_69ff_0), 0, 27135 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6a00_0), 0, 27136 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6a01_0), 0, 27137 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6aff_0), 0, 27391 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6b00_0), 0, 27392 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6b01_0), 0, 27393 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6bff_0), 0, 27647 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6c00_0), 0, 27648 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6c01_0), 0, 27649 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6cff_0), 0, 27903 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6d00_0), 0, 27904 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6d01_0), 0, 27905 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6dff_0), 0, 28159 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6e00_0), 0, 28160 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6e01_0), 0, 28161 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6eff_0), 0, 28415 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6f00_0), 0, 28416 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6f01_0), 0, 28417 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6fff_0), 0, 28671 }, /* Bcc.L #<data>.L */
{ CPUFUNC(op_7000_0), 0, 28672 }, /* MOVE.L #<data>,Dn */
{ CPUFUNC_FF(op_7100_0), 0, 28928 }, /* EMULOP_RETURN.L  */
{ CPUFUNC_FF(op_7101_0), 0, 28929 }, /* EMULOP.L #<data> */
{ CPUFUNC(op_8000_0), 0, 32768 }, /* OR.B Dn,Dn */
{ CPUFUNC(op_8010_0), 0, 32784 }, /* OR.B (An),Dn */
{ CPUFUNC(op_8018_0), 0, 32792 }, /* OR.B (An)+,Dn */
{ CPUFUNC(op_8020_0), 0, 32800 }, /* OR.B -(An),Dn */
{ CPUFUNC(op_8028_0), 0, 32808 }, /* OR.B (d16,An),Dn */
{ CPUFUNC(op_8030_0), 0, 32816 }, /* OR.B (d8,An,Xn),Dn */
{ CPUFUNC(op_8038_0), 0, 32824 }, /* OR.B (xxx).W,Dn */
{ CPUFUNC(op_8039_0), 0, 32825 }, /* OR.B (xxx).L,Dn */
{ CPUFUNC(op_803a_0), 0, 32826 }, /* OR.B (d16,PC),Dn */
{ CPUFUNC(op_803b_0), 0, 32827 }, /* OR.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_803c_0), 0, 32828 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_8040_0), 0, 32832 }, /* OR.W Dn,Dn */
{ CPUFUNC(op_8050_0), 0, 32848 }, /* OR.W (An),Dn */
{ CPUFUNC(op_8058_0), 0, 32856 }, /* OR.W (An)+,Dn */
{ CPUFUNC(op_8060_0), 0, 32864 }, /* OR.W -(An),Dn */
{ CPUFUNC(op_8068_0), 0, 32872 }, /* OR.W (d16,An),Dn */
{ CPUFUNC(op_8070_0), 0, 32880 }, /* OR.W (d8,An,Xn),Dn */
{ CPUFUNC(op_8078_0), 0, 32888 }, /* OR.W (xxx).W,Dn */
{ CPUFUNC(op_8079_0), 0, 32889 }, /* OR.W (xxx).L,Dn */
{ CPUFUNC(op_807a_0), 0, 32890 }, /* OR.W (d16,PC),Dn */
{ CPUFUNC(op_807b_0), 0, 32891 }, /* OR.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_807c_0), 0, 32892 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_8080_0), 0, 32896 }, /* OR.L Dn,Dn */
{ CPUFUNC(op_8090_0), 0, 32912 }, /* OR.L (An),Dn */
{ CPUFUNC(op_8098_0), 0, 32920 }, /* OR.L (An)+,Dn */
{ CPUFUNC(op_80a0_0), 0, 32928 }, /* OR.L -(An),Dn */
{ CPUFUNC(op_80a8_0), 0, 32936 }, /* OR.L (d16,An),Dn */
{ CPUFUNC(op_80b0_0), 0, 32944 }, /* OR.L (d8,An,Xn),Dn */
{ CPUFUNC(op_80b8_0), 0, 32952 }, /* OR.L (xxx).W,Dn */
{ CPUFUNC(op_80b9_0), 0, 32953 }, /* OR.L (xxx).L,Dn */
{ CPUFUNC(op_80ba_0), 0, 32954 }, /* OR.L (d16,PC),Dn */
{ CPUFUNC(op_80bb_0), 0, 32955 }, /* OR.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_80bc_0), 0, 32956 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_80c0_0), 0, 32960 }, /* DIVU.W Dn,Dn */
{ CPUFUNC(op_80d0_0), 0, 32976 }, /* DIVU.W (An),Dn */
{ CPUFUNC(op_80d8_0), 0, 32984 }, /* DIVU.W (An)+,Dn */
{ CPUFUNC(op_80e0_0), 0, 32992 }, /* DIVU.W -(An),Dn */
{ CPUFUNC(op_80e8_0), 0, 33000 }, /* DIVU.W (d16,An),Dn */
{ CPUFUNC(op_80f0_0), 0, 33008 }, /* DIVU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_80f8_0), 0, 33016 }, /* DIVU.W (xxx).W,Dn */
{ CPUFUNC(op_80f9_0), 0, 33017 }, /* DIVU.W (xxx).L,Dn */
{ CPUFUNC(op_80fa_0), 0, 33018 }, /* DIVU.W (d16,PC),Dn */
{ CPUFUNC(op_80fb_0), 0, 33019 }, /* DIVU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_80fc_0), 0, 33020 }, /* DIVU.W #<data>.W,Dn */
{ CPUFUNC(op_8100_1), 0, 33024 }, /* SBCD.B Dn,Dn */
{ CPUFUNC(op_8108_1), 0, 33032 }, /* SBCD.B -(An),-(An) */
{ CPUFUNC(op_8110_0), 0, 33040 }, /* OR.B Dn,(An) */
{ CPUFUNC(op_8118_0), 0, 33048 }, /* OR.B Dn,(An)+ */
{ CPUFUNC(op_8120_0), 0, 33056 }, /* OR.B Dn,-(An) */
{ CPUFUNC(op_8128_0), 0, 33064 }, /* OR.B Dn,(d16,An) */
{ CPUFUNC(op_8130_0), 0, 33072 }, /* OR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_8138_0), 0, 33080 }, /* OR.B Dn,(xxx).W */
{ CPUFUNC(op_8139_0), 0, 33081 }, /* OR.B Dn,(xxx).L */
{ CPUFUNC_FF(op_8140_0), 0, 33088 }, /* PACK.L Dn,Dn */
{ CPUFUNC_FF(op_8148_0), 0, 33096 }, /* PACK.L -(An),-(An) */
{ CPUFUNC(op_8150_0), 0, 33104 }, /* OR.W Dn,(An) */
{ CPUFUNC(op_8158_0), 0, 33112 }, /* OR.W Dn,(An)+ */
{ CPUFUNC(op_8160_0), 0, 33120 }, /* OR.W Dn,-(An) */
{ CPUFUNC(op_8168_0), 0, 33128 }, /* OR.W Dn,(d16,An) */
{ CPUFUNC(op_8170_0), 0, 33136 }, /* OR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_8178_0), 0, 33144 }, /* OR.W Dn,(xxx).W */
{ CPUFUNC(op_8179_0), 0, 33145 }, /* OR.W Dn,(xxx).L */
{ CPUFUNC_FF(op_8180_0), 0, 33152 }, /* UNPK.L Dn,Dn */
{ CPUFUNC_FF(op_8188_0), 0, 33160 }, /* UNPK.L -(An),-(An) */
{ CPUFUNC(op_8190_0), 0, 33168 }, /* OR.L Dn,(An) */
{ CPUFUNC(op_8198_0), 0, 33176 }, /* OR.L Dn,(An)+ */
{ CPUFUNC(op_81a0_0), 0, 33184 }, /* OR.L Dn,-(An) */
{ CPUFUNC(op_81a8_0), 0, 33192 }, /* OR.L Dn,(d16,An) */
{ CPUFUNC(op_81b0_0), 0, 33200 }, /* OR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_81b8_0), 0, 33208 }, /* OR.L Dn,(xxx).W */
{ CPUFUNC(op_81b9_0), 0, 33209 }, /* OR.L Dn,(xxx).L */
{ CPUFUNC(op_81c0_0), 0, 33216 }, /* DIVS.W Dn,Dn */
{ CPUFUNC(op_81d0_0), 0, 33232 }, /* DIVS.W (An),Dn */
{ CPUFUNC(op_81d8_0), 0, 33240 }, /* DIVS.W (An)+,Dn */
{ CPUFUNC(op_81e0_0), 0, 33248 }, /* DIVS.W -(An),Dn */
{ CPUFUNC(op_81e8_0), 0, 33256 }, /* DIVS.W (d16,An),Dn */
{ CPUFUNC(op_81f0_0), 0, 33264 }, /* DIVS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_81f8_0), 0, 33272 }, /* DIVS.W (xxx).W,Dn */
{ CPUFUNC(op_81f9_0), 0, 33273 }, /* DIVS.W (xxx).L,Dn */
{ CPUFUNC(op_81fa_0), 0, 33274 }, /* DIVS.W (d16,PC),Dn */
{ CPUFUNC(op_81fb_0), 0, 33275 }, /* DIVS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_81fc_0), 0, 33276 }, /* DIVS.W #<data>.W,Dn */
{ CPUFUNC(op_9000_0), 0, 36864 }, /* SUB.B Dn,Dn */
{ CPUFUNC(op_9010_0), 0, 36880 }, /* SUB.B (An),Dn */
{ CPUFUNC(op_9018_0), 0, 36888 }, /* SUB.B (An)+,Dn */
{ CPUFUNC(op_9020_0), 0, 36896 }, /* SUB.B -(An),Dn */
{ CPUFUNC(op_9028_0), 0, 36904 }, /* SUB.B (d16,An),Dn */
{ CPUFUNC(op_9030_0), 0, 36912 }, /* SUB.B (d8,An,Xn),Dn */
{ CPUFUNC(op_9038_0), 0, 36920 }, /* SUB.B (xxx).W,Dn */
{ CPUFUNC(op_9039_0), 0, 36921 }, /* SUB.B (xxx).L,Dn */
{ CPUFUNC(op_903a_0), 0, 36922 }, /* SUB.B (d16,PC),Dn */
{ CPUFUNC(op_903b_0), 0, 36923 }, /* SUB.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_903c_0), 0, 36924 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_9040_0), 0, 36928 }, /* SUB.W Dn,Dn */
{ CPUFUNC(op_9048_0), 0, 36936 }, /* SUB.W An,Dn */
{ CPUFUNC(op_9050_0), 0, 36944 }, /* SUB.W (An),Dn */
{ CPUFUNC(op_9058_0), 0, 36952 }, /* SUB.W (An)+,Dn */
{ CPUFUNC(op_9060_0), 0, 36960 }, /* SUB.W -(An),Dn */
{ CPUFUNC(op_9068_0), 0, 36968 }, /* SUB.W (d16,An),Dn */
{ CPUFUNC(op_9070_0), 0, 36976 }, /* SUB.W (d8,An,Xn),Dn */
{ CPUFUNC(op_9078_0), 0, 36984 }, /* SUB.W (xxx).W,Dn */
{ CPUFUNC(op_9079_0), 0, 36985 }, /* SUB.W (xxx).L,Dn */
{ CPUFUNC(op_907a_0), 0, 36986 }, /* SUB.W (d16,PC),Dn */
{ CPUFUNC(op_907b_0), 0, 36987 }, /* SUB.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_907c_0), 0, 36988 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_9080_0), 0, 36992 }, /* SUB.L Dn,Dn */
{ CPUFUNC(op_9088_0), 0, 37000 }, /* SUB.L An,Dn */
{ CPUFUNC(op_9090_0), 0, 37008 }, /* SUB.L (An),Dn */
{ CPUFUNC(op_9098_0), 0, 37016 }, /* SUB.L (An)+,Dn */
{ CPUFUNC(op_90a0_0), 0, 37024 }, /* SUB.L -(An),Dn */
{ CPUFUNC(op_90a8_0), 0, 37032 }, /* SUB.L (d16,An),Dn */
{ CPUFUNC(op_90b0_0), 0, 37040 }, /* SUB.L (d8,An,Xn),Dn */
{ CPUFUNC(op_90b8_0), 0, 37048 }, /* SUB.L (xxx).W,Dn */
{ CPUFUNC(op_90b9_0), 0, 37049 }, /* SUB.L (xxx).L,Dn */
{ CPUFUNC(op_90ba_0), 0, 37050 }, /* SUB.L (d16,PC),Dn */
{ CPUFUNC(op_90bb_0), 0, 37051 }, /* SUB.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_90bc_0), 0, 37052 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC_FF(op_90c0_0), 0, 37056 }, /* SUBA.W Dn,An */
{ CPUFUNC_FF(op_90c8_0), 0, 37064 }, /* SUBA.W An,An */
{ CPUFUNC_FF(op_90d0_0), 0, 37072 }, /* SUBA.W (An),An */
{ CPUFUNC_FF(op_90d8_0), 0, 37080 }, /* SUBA.W (An)+,An */
{ CPUFUNC_FF(op_90e0_0), 0, 37088 }, /* SUBA.W -(An),An */
{ CPUFUNC_FF(op_90e8_0), 0, 37096 }, /* SUBA.W (d16,An),An */
{ CPUFUNC_FF(op_90f0_0), 0, 37104 }, /* SUBA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_90f8_0), 0, 37112 }, /* SUBA.W (xxx).W,An */
{ CPUFUNC_FF(op_90f9_0), 0, 37113 }, /* SUBA.W (xxx).L,An */
{ CPUFUNC_FF(op_90fa_0), 0, 37114 }, /* SUBA.W (d16,PC),An */
{ CPUFUNC_FF(op_90fb_0), 0, 37115 }, /* SUBA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_90fc_0), 0, 37116 }, /* SUBA.W #<data>.W,An */
{ CPUFUNC(op_9100_0), 0, 37120 }, /* SUBX.B Dn,Dn */
{ CPUFUNC(op_9108_0), 0, 37128 }, /* SUBX.B -(An),-(An) */
{ CPUFUNC(op_9110_0), 0, 37136 }, /* SUB.B Dn,(An) */
{ CPUFUNC(op_9118_0), 0, 37144 }, /* SUB.B Dn,(An)+ */
{ CPUFUNC(op_9120_0), 0, 37152 }, /* SUB.B Dn,-(An) */
{ CPUFUNC(op_9128_0), 0, 37160 }, /* SUB.B Dn,(d16,An) */
{ CPUFUNC(op_9130_0), 0, 37168 }, /* SUB.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_9138_0), 0, 37176 }, /* SUB.B Dn,(xxx).W */
{ CPUFUNC(op_9139_0), 0, 37177 }, /* SUB.B Dn,(xxx).L */
{ CPUFUNC(op_9140_0), 0, 37184 }, /* SUBX.W Dn,Dn */
{ CPUFUNC(op_9148_0), 0, 37192 }, /* SUBX.W -(An),-(An) */
{ CPUFUNC(op_9150_0), 0, 37200 }, /* SUB.W Dn,(An) */
{ CPUFUNC(op_9158_0), 0, 37208 }, /* SUB.W Dn,(An)+ */
{ CPUFUNC(op_9160_0), 0, 37216 }, /* SUB.W Dn,-(An) */
{ CPUFUNC(op_9168_0), 0, 37224 }, /* SUB.W Dn,(d16,An) */
{ CPUFUNC(op_9170_0), 0, 37232 }, /* SUB.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_9178_0), 0, 37240 }, /* SUB.W Dn,(xxx).W */
{ CPUFUNC(op_9179_0), 0, 37241 }, /* SUB.W Dn,(xxx).L */
{ CPUFUNC(op_9180_0), 0, 37248 }, /* SUBX.L Dn,Dn */
{ CPUFUNC(op_9188_0), 0, 37256 }, /* SUBX.L -(An),-(An) */
{ CPUFUNC(op_9190_0), 0, 37264 }, /* SUB.L Dn,(An) */
{ CPUFUNC(op_9198_0), 0, 37272 }, /* SUB.L Dn,(An)+ */
{ CPUFUNC(op_91a0_0), 0, 37280 }, /* SUB.L Dn,-(An) */
{ CPUFUNC(op_91a8_0), 0, 37288 }, /* SUB.L Dn,(d16,An) */
{ CPUFUNC(op_91b0_0), 0, 37296 }, /* SUB.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_91b8_0), 0, 37304 }, /* SUB.L Dn,(xxx).W */
{ CPUFUNC(op_91b9_0), 0, 37305 }, /* SUB.L Dn,(xxx).L */
{ CPUFUNC_FF(op_91c0_0), 0, 37312 }, /* SUBA.L Dn,An */
{ CPUFUNC_FF(op_91c8_0), 0, 37320 }, /* SUBA.L An,An */
{ CPUFUNC_FF(op_91d0_0), 0, 37328 }, /* SUBA.L (An),An */
{ CPUFUNC_FF(op_91d8_0), 0, 37336 }, /* SUBA.L (An)+,An */
{ CPUFUNC_FF(op_91e0_0), 0, 37344 }, /* SUBA.L -(An),An */
{ CPUFUNC_FF(op_91e8_0), 0, 37352 }, /* SUBA.L (d16,An),An */
{ CPUFUNC_FF(op_91f0_0), 0, 37360 }, /* SUBA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_91f8_0), 0, 37368 }, /* SUBA.L (xxx).W,An */
{ CPUFUNC_FF(op_91f9_0), 0, 37369 }, /* SUBA.L (xxx).L,An */
{ CPUFUNC_FF(op_91fa_0), 0, 37370 }, /* SUBA.L (d16,PC),An */
{ CPUFUNC_FF(op_91fb_0), 0, 37371 }, /* SUBA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_91fc_0), 0, 37372 }, /* SUBA.L #<data>.L,An */
{ CPUFUNC(op_b000_0), 0, 45056 }, /* CMP.B Dn,Dn */
{ CPUFUNC(op_b010_0), 0, 45072 }, /* CMP.B (An),Dn */
{ CPUFUNC(op_b018_0), 0, 45080 }, /* CMP.B (An)+,Dn */
{ CPUFUNC(op_b020_0), 0, 45088 }, /* CMP.B -(An),Dn */
{ CPUFUNC(op_b028_0), 0, 45096 }, /* CMP.B (d16,An),Dn */
{ CPUFUNC(op_b030_0), 0, 45104 }, /* CMP.B (d8,An,Xn),Dn */
{ CPUFUNC(op_b038_0), 0, 45112 }, /* CMP.B (xxx).W,Dn */
{ CPUFUNC(op_b039_0), 0, 45113 }, /* CMP.B (xxx).L,Dn */
{ CPUFUNC(op_b03a_0), 0, 45114 }, /* CMP.B (d16,PC),Dn */
{ CPUFUNC(op_b03b_0), 0, 45115 }, /* CMP.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_b03c_0), 0, 45116 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_b040_0), 0, 45120 }, /* CMP.W Dn,Dn */
{ CPUFUNC(op_b048_0), 0, 45128 }, /* CMP.W An,Dn */
{ CPUFUNC(op_b050_0), 0, 45136 }, /* CMP.W (An),Dn */
{ CPUFUNC(op_b058_0), 0, 45144 }, /* CMP.W (An)+,Dn */
{ CPUFUNC(op_b060_0), 0, 45152 }, /* CMP.W -(An),Dn */
{ CPUFUNC(op_b068_0), 0, 45160 }, /* CMP.W (d16,An),Dn */
{ CPUFUNC(op_b070_0), 0, 45168 }, /* CMP.W (d8,An,Xn),Dn */
{ CPUFUNC(op_b078_0), 0, 45176 }, /* CMP.W (xxx).W,Dn */
{ CPUFUNC(op_b079_0), 0, 45177 }, /* CMP.W (xxx).L,Dn */
{ CPUFUNC(op_b07a_0), 0, 45178 }, /* CMP.W (d16,PC),Dn */
{ CPUFUNC(op_b07b_0), 0, 45179 }, /* CMP.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_b07c_0), 0, 45180 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_b080_0), 0, 45184 }, /* CMP.L Dn,Dn */
{ CPUFUNC(op_b088_0), 0, 45192 }, /* CMP.L An,Dn */
{ CPUFUNC(op_b090_0), 0, 45200 }, /* CMP.L (An),Dn */
{ CPUFUNC(op_b098_0), 0, 45208 }, /* CMP.L (An)+,Dn */
{ CPUFUNC(op_b0a0_0), 0, 45216 }, /* CMP.L -(An),Dn */
{ CPUFUNC(op_b0a8_0), 0, 45224 }, /* CMP.L (d16,An),Dn */
{ CPUFUNC(op_b0b0_0), 0, 45232 }, /* CMP.L (d8,An,Xn),Dn */
{ CPUFUNC(op_b0b8_0), 0, 45240 }, /* CMP.L (xxx).W,Dn */
{ CPUFUNC(op_b0b9_0), 0, 45241 }, /* CMP.L (xxx).L,Dn */
{ CPUFUNC(op_b0ba_0), 0, 45242 }, /* CMP.L (d16,PC),Dn */
{ CPUFUNC(op_b0bb_0), 0, 45243 }, /* CMP.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_b0bc_0), 0, 45244 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_b0c0_0), 0, 45248 }, /* CMPA.W Dn,An */
{ CPUFUNC(op_b0c8_0), 0, 45256 }, /* CMPA.W An,An */
{ CPUFUNC(op_b0d0_0), 0, 45264 }, /* CMPA.W (An),An */
{ CPUFUNC(op_b0d8_0), 0, 45272 }, /* CMPA.W (An)+,An */
{ CPUFUNC(op_b0e0_0), 0, 45280 }, /* CMPA.W -(An),An */
{ CPUFUNC(op_b0e8_0), 0, 45288 }, /* CMPA.W (d16,An),An */
{ CPUFUNC(op_b0f0_0), 0, 45296 }, /* CMPA.W (d8,An,Xn),An */
{ CPUFUNC(op_b0f8_0), 0, 45304 }, /* CMPA.W (xxx).W,An */
{ CPUFUNC(op_b0f9_0), 0, 45305 }, /* CMPA.W (xxx).L,An */
{ CPUFUNC(op_b0fa_0), 0, 45306 }, /* CMPA.W (d16,PC),An */
{ CPUFUNC(op_b0fb_0), 0, 45307 }, /* CMPA.W (d8,PC,Xn),An */
{ CPUFUNC(op_b0fc_0), 0, 45308 }, /* CMPA.W #<data>.W,An */
{ CPUFUNC(op_b100_0), 0, 45312 }, /* EOR.B Dn,Dn */
{ CPUFUNC(op_b108_0), 0, 45320 }, /* CMPM.B (An)+,(An)+ */
{ CPUFUNC(op_b110_0), 0, 45328 }, /* EOR.B Dn,(An) */
{ CPUFUNC(op_b118_0), 0, 45336 }, /* EOR.B Dn,(An)+ */
{ CPUFUNC(op_b120_0), 0, 45344 }, /* EOR.B Dn,-(An) */
{ CPUFUNC(op_b128_0), 0, 45352 }, /* EOR.B Dn,(d16,An) */
{ CPUFUNC(op_b130_0), 0, 45360 }, /* EOR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_b138_0), 0, 45368 }, /* EOR.B Dn,(xxx).W */
{ CPUFUNC(op_b139_0), 0, 45369 }, /* EOR.B Dn,(xxx).L */
{ CPUFUNC(op_b140_0), 0, 45376 }, /* EOR.W Dn,Dn */
{ CPUFUNC(op_b148_0), 0, 45384 }, /* CMPM.W (An)+,(An)+ */
{ CPUFUNC(op_b150_0), 0, 45392 }, /* EOR.W Dn,(An) */
{ CPUFUNC(op_b158_0), 0, 45400 }, /* EOR.W Dn,(An)+ */
{ CPUFUNC(op_b160_0), 0, 45408 }, /* EOR.W Dn,-(An) */
{ CPUFUNC(op_b168_0), 0, 45416 }, /* EOR.W Dn,(d16,An) */
{ CPUFUNC(op_b170_0), 0, 45424 }, /* EOR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_b178_0), 0, 45432 }, /* EOR.W Dn,(xxx).W */
{ CPUFUNC(op_b179_0), 0, 45433 }, /* EOR.W Dn,(xxx).L */
{ CPUFUNC(op_b180_0), 0, 45440 }, /* EOR.L Dn,Dn */
{ CPUFUNC(op_b188_0), 0, 45448 }, /* CMPM.L (An)+,(An)+ */
{ CPUFUNC(op_b190_0), 0, 45456 }, /* EOR.L Dn,(An) */
{ CPUFUNC(op_b198_0), 0, 45464 }, /* EOR.L Dn,(An)+ */
{ CPUFUNC(op_b1a0_0), 0, 45472 }, /* EOR.L Dn,-(An) */
{ CPUFUNC(op_b1a8_0), 0, 45480 }, /* EOR.L Dn,(d16,An) */
{ CPUFUNC(op_b1b0_0), 0, 45488 }, /* EOR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_b1b8_0), 0, 45496 }, /* EOR.L Dn,(xxx).W */
{ CPUFUNC(op_b1b9_0), 0, 45497 }, /* EOR.L Dn,(xxx).L */
{ CPUFUNC(op_b1c0_0), 0, 45504 }, /* CMPA.L Dn,An */
{ CPUFUNC(op_b1c8_0), 0, 45512 }, /* CMPA.L An,An */
{ CPUFUNC(op_b1d0_0), 0, 45520 }, /* CMPA.L (An),An */
{ CPUFUNC(op_b1d8_0), 0, 45528 }, /* CMPA.L (An)+,An */
{ CPUFUNC(op_b1e0_0), 0, 45536 }, /* CMPA.L -(An),An */
{ CPUFUNC(op_b1e8_0), 0, 45544 }, /* CMPA.L (d16,An),An */
{ CPUFUNC(op_b1f0_0), 0, 45552 }, /* CMPA.L (d8,An,Xn),An */
{ CPUFUNC(op_b1f8_0), 0, 45560 }, /* CMPA.L (xxx).W,An */
{ CPUFUNC(op_b1f9_0), 0, 45561 }, /* CMPA.L (xxx).L,An */
{ CPUFUNC(op_b1fa_0), 0, 45562 }, /* CMPA.L (d16,PC),An */
{ CPUFUNC(op_b1fb_0), 0, 45563 }, /* CMPA.L (d8,PC,Xn),An */
{ CPUFUNC(op_b1fc_0), 0, 45564 }, /* CMPA.L #<data>.L,An */
{ CPUFUNC(op_c000_0), 0, 49152 }, /* AND.B Dn,Dn */
{ CPUFUNC(op_c010_0), 0, 49168 }, /* AND.B (An),Dn */
{ CPUFUNC(op_c018_0), 0, 49176 }, /* AND.B (An)+,Dn */
{ CPUFUNC(op_c020_0), 0, 49184 }, /* AND.B -(An),Dn */
{ CPUFUNC(op_c028_0), 0, 49192 }, /* AND.B (d16,An),Dn */
{ CPUFUNC(op_c030_0), 0, 49200 }, /* AND.B (d8,An,Xn),Dn */
{ CPUFUNC(op_c038_0), 0, 49208 }, /* AND.B (xxx).W,Dn */
{ CPUFUNC(op_c039_0), 0, 49209 }, /* AND.B (xxx).L,Dn */
{ CPUFUNC(op_c03a_0), 0, 49210 }, /* AND.B (d16,PC),Dn */
{ CPUFUNC(op_c03b_0), 0, 49211 }, /* AND.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_c03c_0), 0, 49212 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_c040_0), 0, 49216 }, /* AND.W Dn,Dn */
{ CPUFUNC(op_c050_0), 0, 49232 }, /* AND.W (An),Dn */
{ CPUFUNC(op_c058_0), 0, 49240 }, /* AND.W (An)+,Dn */
{ CPUFUNC(op_c060_0), 0, 49248 }, /* AND.W -(An),Dn */
{ CPUFUNC(op_c068_0), 0, 49256 }, /* AND.W (d16,An),Dn */
{ CPUFUNC(op_c070_0), 0, 49264 }, /* AND.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c078_0), 0, 49272 }, /* AND.W (xxx).W,Dn */
{ CPUFUNC(op_c079_0), 0, 49273 }, /* AND.W (xxx).L,Dn */
{ CPUFUNC(op_c07a_0), 0, 49274 }, /* AND.W (d16,PC),Dn */
{ CPUFUNC(op_c07b_0), 0, 49275 }, /* AND.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c07c_0), 0, 49276 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_c080_0), 0, 49280 }, /* AND.L Dn,Dn */
{ CPUFUNC(op_c090_0), 0, 49296 }, /* AND.L (An),Dn */
{ CPUFUNC(op_c098_0), 0, 49304 }, /* AND.L (An)+,Dn */
{ CPUFUNC(op_c0a0_0), 0, 49312 }, /* AND.L -(An),Dn */
{ CPUFUNC(op_c0a8_0), 0, 49320 }, /* AND.L (d16,An),Dn */
{ CPUFUNC(op_c0b0_0), 0, 49328 }, /* AND.L (d8,An,Xn),Dn */
{ CPUFUNC(op_c0b8_0), 0, 49336 }, /* AND.L (xxx).W,Dn */
{ CPUFUNC(op_c0b9_0), 0, 49337 }, /* AND.L (xxx).L,Dn */
{ CPUFUNC(op_c0ba_0), 0, 49338 }, /* AND.L (d16,PC),Dn */
{ CPUFUNC(op_c0bb_0), 0, 49339 }, /* AND.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0bc_0), 0, 49340 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_c0c0_0), 0, 49344 }, /* MULU.W Dn,Dn */
{ CPUFUNC(op_c0d0_0), 0, 49360 }, /* MULU.W (An),Dn */
{ CPUFUNC(op_c0d8_0), 0, 49368 }, /* MULU.W (An)+,Dn */
{ CPUFUNC(op_c0e0_0), 0, 49376 }, /* MULU.W -(An),Dn */
{ CPUFUNC(op_c0e8_0), 0, 49384 }, /* MULU.W (d16,An),Dn */
{ CPUFUNC(op_c0f0_0), 0, 49392 }, /* MULU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c0f8_0), 0, 49400 }, /* MULU.W (xxx).W,Dn */
{ CPUFUNC(op_c0f9_0), 0, 49401 }, /* MULU.W (xxx).L,Dn */
{ CPUFUNC(op_c0fa_0), 0, 49402 }, /* MULU.W (d16,PC),Dn */
{ CPUFUNC(op_c0fb_0), 0, 49403 }, /* MULU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0fc_0), 0, 49404 }, /* MULU.W #<data>.W,Dn */
{ CPUFUNC(op_c100_1), 0, 49408 }, /* ABCD.B Dn,Dn */
{ CPUFUNC(op_c108_1), 0, 49416 }, /* ABCD.B -(An),-(An) */
{ CPUFUNC(op_c110_0), 0, 49424 }, /* AND.B Dn,(An) */
{ CPUFUNC(op_c118_0), 0, 49432 }, /* AND.B Dn,(An)+ */
{ CPUFUNC(op_c120_0), 0, 49440 }, /* AND.B Dn,-(An) */
{ CPUFUNC(op_c128_0), 0, 49448 }, /* AND.B Dn,(d16,An) */
{ CPUFUNC(op_c130_0), 0, 49456 }, /* AND.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_c138_0), 0, 49464 }, /* AND.B Dn,(xxx).W */
{ CPUFUNC(op_c139_0), 0, 49465 }, /* AND.B Dn,(xxx).L */
{ CPUFUNC_FF(op_c140_0), 0, 49472 }, /* EXG.L Dn,Dn */
{ CPUFUNC_FF(op_c148_0), 0, 49480 }, /* EXG.L An,An */
{ CPUFUNC(op_c150_0), 0, 49488 }, /* AND.W Dn,(An) */
{ CPUFUNC(op_c158_0), 0, 49496 }, /* AND.W Dn,(An)+ */
{ CPUFUNC(op_c160_0), 0, 49504 }, /* AND.W Dn,-(An) */
{ CPUFUNC(op_c168_0), 0, 49512 }, /* AND.W Dn,(d16,An) */
{ CPUFUNC(op_c170_0), 0, 49520 }, /* AND.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_c178_0), 0, 49528 }, /* AND.W Dn,(xxx).W */
{ CPUFUNC(op_c179_0), 0, 49529 }, /* AND.W Dn,(xxx).L */
{ CPUFUNC_FF(op_c188_0), 0, 49544 }, /* EXG.L Dn,An */
{ CPUFUNC(op_c190_0), 0, 49552 }, /* AND.L Dn,(An) */
{ CPUFUNC(op_c198_0), 0, 49560 }, /* AND.L Dn,(An)+ */
{ CPUFUNC(op_c1a0_0), 0, 49568 }, /* AND.L Dn,-(An) */
{ CPUFUNC(op_c1a8_0), 0, 49576 }, /* AND.L Dn,(d16,An) */
{ CPUFUNC(op_c1b0_0), 0, 49584 }, /* AND.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_c1b8_0), 0, 49592 }, /* AND.L Dn,(xxx).W */
{ CPUFUNC(op_c1b9_0), 0, 49593 }, /* AND.L Dn,(xxx).L */
{ CPUFUNC(op_c1c0_0), 0, 49600 }, /* MULS.W Dn,Dn */
{ CPUFUNC(op_c1d0_0), 0, 49616 }, /* MULS.W (An),Dn */
{ CPUFUNC(op_c1d8_0), 0, 49624 }, /* MULS.W (An)+,Dn */
{ CPUFUNC(op_c1e0_0), 0, 49632 }, /* MULS.W -(An),Dn */
{ CPUFUNC(op_c1e8_0), 0, 49640 }, /* MULS.W (d16,An),Dn */
{ CPUFUNC(op_c1f0_0), 0, 49648 }, /* MULS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c1f8_0), 0, 49656 }, /* MULS.W (xxx).W,Dn */
{ CPUFUNC(op_c1f9_0), 0, 49657 }, /* MULS.W (xxx).L,Dn */
{ CPUFUNC(op_c1fa_0), 0, 49658 }, /* MULS.W (d16,PC),Dn */
{ CPUFUNC(op_c1fb_0), 0, 49659 }, /* MULS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c1fc_0), 0, 49660 }, /* MULS.W #<data>.W,Dn */
{ CPUFUNC(op_d000_0), 0, 53248 }, /* ADD.B Dn,Dn */
{ CPUFUNC(op_d010_0), 0, 53264 }, /* ADD.B (An),Dn */
{ CPUFUNC(op_d018_0), 0, 53272 }, /* ADD.B (An)+,Dn */
{ CPUFUNC(op_d020_0), 0, 53280 }, /* ADD.B -(An),Dn */
{ CPUFUNC(op_d028_0), 0, 53288 }, /* ADD.B (d16,An),Dn */
{ CPUFUNC(op_d030_0), 0, 53296 }, /* ADD.B (d8,An,Xn),Dn */
{ CPUFUNC(op_d038_0), 0, 53304 }, /* ADD.B (xxx).W,Dn */
{ CPUFUNC(op_d039_0), 0, 53305 }, /* ADD.B (xxx).L,Dn */
{ CPUFUNC(op_d03a_0), 0, 53306 }, /* ADD.B (d16,PC),Dn */
{ CPUFUNC(op_d03b_0), 0, 53307 }, /* ADD.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_d03c_0), 0, 53308 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_d040_0), 0, 53312 }, /* ADD.W Dn,Dn */
{ CPUFUNC(op_d048_0), 0, 53320 }, /* ADD.W An,Dn */
{ CPUFUNC(op_d050_0), 0, 53328 }, /* ADD.W (An),Dn */
{ CPUFUNC(op_d058_0), 0, 53336 }, /* ADD.W (An)+,Dn */
{ CPUFUNC(op_d060_0), 0, 53344 }, /* ADD.W -(An),Dn */
{ CPUFUNC(op_d068_0), 0, 53352 }, /* ADD.W (d16,An),Dn */
{ CPUFUNC(op_d070_0), 0, 53360 }, /* ADD.W (d8,An,Xn),Dn */
{ CPUFUNC(op_d078_0), 0, 53368 }, /* ADD.W (xxx).W,Dn */
{ CPUFUNC(op_d079_0), 0, 53369 }, /* ADD.W (xxx).L,Dn */
{ CPUFUNC(op_d07a_0), 0, 53370 }, /* ADD.W (d16,PC),Dn */
{ CPUFUNC(op_d07b_0), 0, 53371 }, /* ADD.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_d07c_0), 0, 53372 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_d080_0), 0, 53376 }, /* ADD.L Dn,Dn */
{ CPUFUNC(op_d088_0), 0, 53384 }, /* ADD.L An,Dn */
{ CPUFUNC(op_d090_0), 0, 53392 }, /* ADD.L (An),Dn */
{ CPUFUNC(op_d098_0), 0, 53400 }, /* ADD.L (An)+,Dn */
{ CPUFUNC(op_d0a0_0), 0, 53408 }, /* ADD.L -(An),Dn */
{ CPUFUNC(op_d0a8_0), 0, 53416 }, /* ADD.L (d16,An),Dn */
{ CPUFUNC(op_d0b0_0), 0, 53424 }, /* ADD.L (d8,An,Xn),Dn */
{ CPUFUNC(op_d0b8_0), 0, 53432 }, /* ADD.L (xxx).W,Dn */
{ CPUFUNC(op_d0b9_0), 0, 53433 }, /* ADD.L (xxx).L,Dn */
{ CPUFUNC(op_d0ba_0), 0, 53434 }, /* ADD.L (d16,PC),Dn */
{ CPUFUNC(op_d0bb_0), 0, 53435 }, /* ADD.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_d0bc_0), 0, 53436 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC_FF(op_d0c0_0), 0, 53440 }, /* ADDA.W Dn,An */
{ CPUFUNC_FF(op_d0c8_0), 0, 53448 }, /* ADDA.W An,An */
{ CPUFUNC_FF(op_d0d0_0), 0, 53456 }, /* ADDA.W (An),An */
{ CPUFUNC_FF(op_d0d8_0), 0, 53464 }, /* ADDA.W (An)+,An */
{ CPUFUNC_FF(op_d0e0_0), 0, 53472 }, /* ADDA.W -(An),An */
{ CPUFUNC_FF(op_d0e8_0), 0, 53480 }, /* ADDA.W (d16,An),An */
{ CPUFUNC_FF(op_d0f0_0), 0, 53488 }, /* ADDA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_d0f8_0), 0, 53496 }, /* ADDA.W (xxx).W,An */
{ CPUFUNC_FF(op_d0f9_0), 0, 53497 }, /* ADDA.W (xxx).L,An */
{ CPUFUNC_FF(op_d0fa_0), 0, 53498 }, /* ADDA.W (d16,PC),An */
{ CPUFUNC_FF(op_d0fb_0), 0, 53499 }, /* ADDA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d0fc_0), 0, 53500 }, /* ADDA.W #<data>.W,An */
{ CPUFUNC(op_d100_0), 0, 53504 }, /* ADDX.B Dn,Dn */
{ CPUFUNC(op_d108_0), 0, 53512 }, /* ADDX.B -(An),-(An) */
{ CPUFUNC(op_d110_0), 0, 53520 }, /* ADD.B Dn,(An) */
{ CPUFUNC(op_d118_0), 0, 53528 }, /* ADD.B Dn,(An)+ */
{ CPUFUNC(op_d120_0), 0, 53536 }, /* ADD.B Dn,-(An) */
{ CPUFUNC(op_d128_0), 0, 53544 }, /* ADD.B Dn,(d16,An) */
{ CPUFUNC(op_d130_0), 0, 53552 }, /* ADD.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_d138_0), 0, 53560 }, /* ADD.B Dn,(xxx).W */
{ CPUFUNC(op_d139_0), 0, 53561 }, /* ADD.B Dn,(xxx).L */
{ CPUFUNC(op_d140_0), 0, 53568 }, /* ADDX.W Dn,Dn */
{ CPUFUNC(op_d148_0), 0, 53576 }, /* ADDX.W -(An),-(An) */
{ CPUFUNC(op_d150_0), 0, 53584 }, /* ADD.W Dn,(An) */
{ CPUFUNC(op_d158_0), 0, 53592 }, /* ADD.W Dn,(An)+ */
{ CPUFUNC(op_d160_0), 0, 53600 }, /* ADD.W Dn,-(An) */
{ CPUFUNC(op_d168_0), 0, 53608 }, /* ADD.W Dn,(d16,An) */
{ CPUFUNC(op_d170_0), 0, 53616 }, /* ADD.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_d178_0), 0, 53624 }, /* ADD.W Dn,(xxx).W */
{ CPUFUNC(op_d179_0), 0, 53625 }, /* ADD.W Dn,(xxx).L */
{ CPUFUNC(op_d180_0), 0, 53632 }, /* ADDX.L Dn,Dn */
{ CPUFUNC(op_d188_0), 0, 53640 }, /* ADDX.L -(An),-(An) */
{ CPUFUNC(op_d190_0), 0, 53648 }, /* ADD.L Dn,(An) */
{ CPUFUNC(op_d198_0), 0, 53656 }, /* ADD.L Dn,(An)+ */
{ CPUFUNC(op_d1a0_0), 0, 53664 }, /* ADD.L Dn,-(An) */
{ CPUFUNC(op_d1a8_0), 0, 53672 }, /* ADD.L Dn,(d16,An) */
{ CPUFUNC(op_d1b0_0), 0, 53680 }, /* ADD.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_d1b8_0), 0, 53688 }, /* ADD.L Dn,(xxx).W */
{ CPUFUNC(op_d1b9_0), 0, 53689 }, /* ADD.L Dn,(xxx).L */
{ CPUFUNC_FF(op_d1c0_0), 0, 53696 }, /* ADDA.L Dn,An */
{ CPUFUNC_FF(op_d1c8_0), 0, 53704 }, /* ADDA.L An,An */
{ CPUFUNC_FF(op_d1d0_0), 0, 53712 }, /* ADDA.L (An),An */
{ CPUFUNC_FF(op_d1d8_0), 0, 53720 }, /* ADDA.L (An)+,An */
{ CPUFUNC_FF(op_d1e0_0), 0, 53728 }, /* ADDA.L -(An),An */
{ CPUFUNC_FF(op_d1e8_0), 0, 53736 }, /* ADDA.L (d16,An),An */
{ CPUFUNC_FF(op_d1f0_0), 0, 53744 }, /* ADDA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_d1f8_0), 0, 53752 }, /* ADDA.L (xxx).W,An */
{ CPUFUNC_FF(op_d1f9_0), 0, 53753 }, /* ADDA.L (xxx).L,An */
{ CPUFUNC_FF(op_d1fa_0), 0, 53754 }, /* ADDA.L (d16,PC),An */
{ CPUFUNC_FF(op_d1fb_0), 0, 53755 }, /* ADDA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d1fc_0), 0, 53756 }, /* ADDA.L #<data>.L,An */
{ CPUFUNC(op_e000_0), 0, 57344 }, /* ASR.B #<data>,Dn */
{ CPUFUNC(op_e008_0), 0, 57352 }, /* LSR.B #<data>,Dn */
{ CPUFUNC(op_e010_0), 0, 57360 }, /* ROXR.B #<data>,Dn */
{ CPUFUNC(op_e018_0), 0, 57368 }, /* ROR.B #<data>,Dn */
{ CPUFUNC(op_e020_0), 0, 57376 }, /* ASR.B Dn,Dn */
{ CPUFUNC(op_e028_0), 0, 57384 }, /* LSR.B Dn,Dn */
{ CPUFUNC(op_e030_0), 0, 57392 }, /* ROXR.B Dn,Dn */
{ CPUFUNC(op_e038_0), 0, 57400 }, /* ROR.B Dn,Dn */
{ CPUFUNC(op_e040_0), 0, 57408 }, /* ASR.W #<data>,Dn */
{ CPUFUNC(op_e048_0), 0, 57416 }, /* LSR.W #<data>,Dn */
{ CPUFUNC(op_e050_0), 0, 57424 }, /* ROXR.W #<data>,Dn */
{ CPUFUNC(op_e058_0), 0, 57432 }, /* ROR.W #<data>,Dn */
{ CPUFUNC(op_e060_0), 0, 57440 }, /* ASR.W Dn,Dn */
{ CPUFUNC(op_e068_0), 0, 57448 }, /* LSR.W Dn,Dn */
{ CPUFUNC(op_e070_0), 0, 57456 }, /* ROXR.W Dn,Dn */
{ CPUFUNC(op_e078_0), 0, 57464 }, /* ROR.W Dn,Dn */
{ CPUFUNC(op_e080_0), 0, 57472 }, /* ASR.L #<data>,Dn */
{ CPUFUNC(op_e088_0), 0, 57480 }, /* LSR.L #<data>,Dn */
{ CPUFUNC(op_e090_0), 0, 57488 }, /* ROXR.L #<data>,Dn */
{ CPUFUNC(op_e098_0), 0, 57496 }, /* ROR.L #<data>,Dn */
{ CPUFUNC(op_e0a0_0), 0, 57504 }, /* ASR.L Dn,Dn */
{ CPUFUNC(op_e0a8_0), 0, 57512 }, /* LSR.L Dn,Dn */
{ CPUFUNC(op_e0b0_0), 0, 57520 }, /* ROXR.L Dn,Dn */
{ CPUFUNC(op_e0b8_0), 0, 57528 }, /* ROR.L Dn,Dn */
{ CPUFUNC(op_e0d0_0), 0, 57552 }, /* ASRW.W (An) */
{ CPUFUNC(op_e0d8_0), 0, 57560 }, /* ASRW.W (An)+ */
{ CPUFUNC(op_e0e0_0), 0, 57568 }, /* ASRW.W -(An) */
{ CPUFUNC(op_e0e8_0), 0, 57576 }, /* ASRW.W (d16,An) */
{ CPUFUNC(op_e0f0_0), 0, 57584 }, /* ASRW.W (d8,An,Xn) */
{ CPUFUNC(op_e0f8_0), 0, 57592 }, /* ASRW.W (xxx).W */
{ CPUFUNC(op_e0f9_0), 0, 57593 }, /* ASRW.W (xxx).L */
{ CPUFUNC(op_e100_0), 0, 57600 }, /* ASL.B #<data>,Dn */
{ CPUFUNC(op_e108_0), 0, 57608 }, /* LSL.B #<data>,Dn */
{ CPUFUNC(op_e110_0), 0, 57616 }, /* ROXL.B #<data>,Dn */
{ CPUFUNC(op_e118_0), 0, 57624 }, /* ROL.B #<data>,Dn */
{ CPUFUNC(op_e120_0), 0, 57632 }, /* ASL.B Dn,Dn */
{ CPUFUNC(op_e128_0), 0, 57640 }, /* LSL.B Dn,Dn */
{ CPUFUNC(op_e130_0), 0, 57648 }, /* ROXL.B Dn,Dn */
{ CPUFUNC(op_e138_0), 0, 57656 }, /* ROL.B Dn,Dn */
{ CPUFUNC(op_e140_0), 0, 57664 }, /* ASL.W #<data>,Dn */
{ CPUFUNC(op_e148_0), 0, 57672 }, /* LSL.W #<data>,Dn */
{ CPUFUNC(op_e150_0), 0, 57680 }, /* ROXL.W #<data>,Dn */
{ CPUFUNC(op_e158_0), 0, 57688 }, /* ROL.W #<data>,Dn */
{ CPUFUNC(op_e160_0), 0, 57696 }, /* ASL.W Dn,Dn */
{ CPUFUNC(op_e168_0), 0, 57704 }, /* LSL.W Dn,Dn */
{ CPUFUNC(op_e170_0), 0, 57712 }, /* ROXL.W Dn,Dn */
{ CPUFUNC(op_e178_0), 0, 57720 }, /* ROL.W Dn,Dn */
{ CPUFUNC(op_e180_0), 0, 57728 }, /* ASL.L #<data>,Dn */
{ CPUFUNC(op_e188_0), 0, 57736 }, /* LSL.L #<data>,Dn */
{ CPUFUNC(op_e190_0), 0, 57744 }, /* ROXL.L #<data>,Dn */
{ CPUFUNC(op_e198_0), 0, 57752 }, /* ROL.L #<data>,Dn */
{ CPUFUNC(op_e1a0_0), 0, 57760 }, /* ASL.L Dn,Dn */
{ CPUFUNC(op_e1a8_0), 0, 57768 }, /* LSL.L Dn,Dn */
{ CPUFUNC(op_e1b0_0), 0, 57776 }, /* ROXL.L Dn,Dn */
{ CPUFUNC(op_e1b8_0), 0, 57784 }, /* ROL.L Dn,Dn */
{ CPUFUNC(op_e1d0_0), 0, 57808 }, /* ASLW.W (An) */
{ CPUFUNC(op_e1d8_0), 0, 57816 }, /* ASLW.W (An)+ */
{ CPUFUNC(op_e1e0_0), 0, 57824 }, /* ASLW.W -(An) */
{ CPUFUNC(op_e1e8_0), 0, 57832 }, /* ASLW.W (d16,An) */
{ CPUFUNC(op_e1f0_0), 0, 57840 }, /* ASLW.W (d8,An,Xn) */
{ CPUFUNC(op_e1f8_0), 0, 57848 }, /* ASLW.W (xxx).W */
{ CPUFUNC(op_e1f9_0), 0, 57849 }, /* ASLW.W (xxx).L */
{ CPUFUNC(op_e2d0_0), 0, 58064 }, /* LSRW.W (An) */
{ CPUFUNC(op_e2d8_0), 0, 58072 }, /* LSRW.W (An)+ */
{ CPUFUNC(op_e2e0_0), 0, 58080 }, /* LSRW.W -(An) */
{ CPUFUNC(op_e2e8_0), 0, 58088 }, /* LSRW.W (d16,An) */
{ CPUFUNC(op_e2f0_0), 0, 58096 }, /* LSRW.W (d8,An,Xn) */
{ CPUFUNC(op_e2f8_0), 0, 58104 }, /* LSRW.W (xxx).W */
{ CPUFUNC(op_e2f9_0), 0, 58105 }, /* LSRW.W (xxx).L */
{ CPUFUNC(op_e3d0_0), 0, 58320 }, /* LSLW.W (An) */
{ CPUFUNC(op_e3d8_0), 0, 58328 }, /* LSLW.W (An)+ */
{ CPUFUNC(op_e3e0_0), 0, 58336 }, /* LSLW.W -(An) */
{ CPUFUNC(op_e3e8_0), 0, 58344 }, /* LSLW.W (d16,An) */
{ CPUFUNC(op_e3f0_0), 0, 58352 }, /* LSLW.W (d8,An,Xn) */
{ CPUFUNC(op_e3f8_0), 0, 58360 }, /* LSLW.W (xxx).W */
{ CPUFUNC(op_e3f9_0), 0, 58361 }, /* LSLW.W (xxx).L */
{ CPUFUNC(op_e4d0_0), 0, 58576 }, /* ROXRW.W (An) */
{ CPUFUNC(op_e4d8_0), 0, 58584 }, /* ROXRW.W (An)+ */
{ CPUFUNC(op_e4e0_0), 0, 58592 }, /* ROXRW.W -(An) */
{ CPUFUNC(op_e4e8_0), 0, 58600 }, /* ROXRW.W (d16,An) */
{ CPUFUNC(op_e4f0_0), 0, 58608 }, /* ROXRW.W (d8,An,Xn) */
{ CPUFUNC(op_e4f8_0), 0, 58616 }, /* ROXRW.W (xxx).W */
{ CPUFUNC(op_e4f9_0), 0, 58617 }, /* ROXRW.W (xxx).L */
{ CPUFUNC(op_e5d0_0), 0, 58832 }, /* ROXLW.W (An) */
{ CPUFUNC(op_e5d8_0), 0, 58840 }, /* ROXLW.W (An)+ */
{ CPUFUNC(op_e5e0_0), 0, 58848 }, /* ROXLW.W -(An) */
{ CPUFUNC(op_e5e8_0), 0, 58856 }, /* ROXLW.W (d16,An) */
{ CPUFUNC(op_e5f0_0), 0, 58864 }, /* ROXLW.W (d8,An,Xn) */
{ CPUFUNC(op_e5f8_0), 0, 58872 }, /* ROXLW.W (xxx).W */
{ CPUFUNC(op_e5f9_0), 0, 58873 }, /* ROXLW.W (xxx).L */
{ CPUFUNC(op_e6d0_0), 0, 59088 }, /* RORW.W (An) */
{ CPUFUNC(op_e6d8_0), 0, 59096 }, /* RORW.W (An)+ */
{ CPUFUNC(op_e6e0_0), 0, 59104 }, /* RORW.W -(An) */
{ CPUFUNC(op_e6e8_0), 0, 59112 }, /* RORW.W (d16,An) */
{ CPUFUNC(op_e6f0_0), 0, 59120 }, /* RORW.W (d8,An,Xn) */
{ CPUFUNC(op_e6f8_0), 0, 59128 }, /* RORW.W (xxx).W */
{ CPUFUNC(op_e6f9_0), 0, 59129 }, /* RORW.W (xxx).L */
{ CPUFUNC(op_e7d0_0), 0, 59344 }, /* ROLW.W (An) */
{ CPUFUNC(op_e7d8_0), 0, 59352 }, /* ROLW.W (An)+ */
{ CPUFUNC(op_e7e0_0), 0, 59360 }, /* ROLW.W -(An) */
{ CPUFUNC(op_e7e8_0), 0, 59368 }, /* ROLW.W (d16,An) */
{ CPUFUNC(op_e7f0_0), 0, 59376 }, /* ROLW.W (d8,An,Xn) */
{ CPUFUNC(op_e7f8_0), 0, 59384 }, /* ROLW.W (xxx).W */
{ CPUFUNC(op_e7f9_0), 0, 59385 }, /* ROLW.W (xxx).L */
{ CPUFUNC(op_e8c0_0), 0, 59584 }, /* BFTST.L #<data>.W,Dn */
{ CPUFUNC(op_e8d0_0), 0, 59600 }, /* BFTST.L #<data>.W,(An) */
{ CPUFUNC(op_e8e8_0), 0, 59624 }, /* BFTST.L #<data>.W,(d16,An) */
{ CPUFUNC(op_e8f0_0), 0, 59632 }, /* BFTST.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_e8f8_0), 0, 59640 }, /* BFTST.L #<data>.W,(xxx).W */
{ CPUFUNC(op_e8f9_0), 0, 59641 }, /* BFTST.L #<data>.W,(xxx).L */
{ CPUFUNC(op_e8fa_0), 0, 59642 }, /* BFTST.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_e8fb_0), 0, 59643 }, /* BFTST.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_e9c0_0), 0, 59840 }, /* BFEXTU.L #<data>.W,Dn */
{ CPUFUNC(op_e9d0_0), 0, 59856 }, /* BFEXTU.L #<data>.W,(An) */
{ CPUFUNC(op_e9e8_0), 0, 59880 }, /* BFEXTU.L #<data>.W,(d16,An) */
{ CPUFUNC(op_e9f0_0), 0, 59888 }, /* BFEXTU.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_e9f8_0), 0, 59896 }, /* BFEXTU.L #<data>.W,(xxx).W */
{ CPUFUNC(op_e9f9_0), 0, 59897 }, /* BFEXTU.L #<data>.W,(xxx).L */
{ CPUFUNC(op_e9fa_0), 0, 59898 }, /* BFEXTU.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_e9fb_0), 0, 59899 }, /* BFEXTU.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_eac0_0), 0, 60096 }, /* BFCHG.L #<data>.W,Dn */
{ CPUFUNC(op_ead0_0), 0, 60112 }, /* BFCHG.L #<data>.W,(An) */
{ CPUFUNC(op_eae8_0), 0, 60136 }, /* BFCHG.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eaf0_0), 0, 60144 }, /* BFCHG.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eaf8_0), 0, 60152 }, /* BFCHG.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eaf9_0), 0, 60153 }, /* BFCHG.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ebc0_0), 0, 60352 }, /* BFEXTS.L #<data>.W,Dn */
{ CPUFUNC(op_ebd0_0), 0, 60368 }, /* BFEXTS.L #<data>.W,(An) */
{ CPUFUNC(op_ebe8_0), 0, 60392 }, /* BFEXTS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ebf0_0), 0, 60400 }, /* BFEXTS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ebf8_0), 0, 60408 }, /* BFEXTS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ebf9_0), 0, 60409 }, /* BFEXTS.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ebfa_0), 0, 60410 }, /* BFEXTS.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_ebfb_0), 0, 60411 }, /* BFEXTS.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_ecc0_0), 0, 60608 }, /* BFCLR.L #<data>.W,Dn */
{ CPUFUNC(op_ecd0_0), 0, 60624 }, /* BFCLR.L #<data>.W,(An) */
{ CPUFUNC(op_ece8_0), 0, 60648 }, /* BFCLR.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ecf0_0), 0, 60656 }, /* BFCLR.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ecf8_0), 0, 60664 }, /* BFCLR.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ecf9_0), 0, 60665 }, /* BFCLR.L #<data>.W,(xxx).L */
{ CPUFUNC(op_edc0_0), 0, 60864 }, /* BFFFO.L #<data>.W,Dn */
{ CPUFUNC(op_edd0_0), 0, 60880 }, /* BFFFO.L #<data>.W,(An) */
{ CPUFUNC(op_ede8_0), 0, 60904 }, /* BFFFO.L #<data>.W,(d16,An) */
{ CPUFUNC(op_edf0_0), 0, 60912 }, /* BFFFO.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_edf8_0), 0, 60920 }, /* BFFFO.L #<data>.W,(xxx).W */
{ CPUFUNC(op_edf9_0), 0, 60921 }, /* BFFFO.L #<data>.W,(xxx).L */
{ CPUFUNC(op_edfa_0), 0, 60922 }, /* BFFFO.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_edfb_0), 0, 60923 }, /* BFFFO.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_eec0_0), 0, 61120 }, /* BFSET.L #<data>.W,Dn */
{ CPUFUNC(op_eed0_0), 0, 61136 }, /* BFSET.L #<data>.W,(An) */
{ CPUFUNC(op_eee8_0), 0, 61160 }, /* BFSET.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eef0_0), 0, 61168 }, /* BFSET.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eef8_0), 0, 61176 }, /* BFSET.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eef9_0), 0, 61177 }, /* BFSET.L #<data>.W,(xxx).L */
{ CPUFUNC(op_efc0_0), 0, 61376 }, /* BFINS.L #<data>.W,Dn */
{ CPUFUNC(op_efd0_0), 0, 61392 }, /* BFINS.L #<data>.W,(An) */
{ CPUFUNC(op_efe8_0), 0, 61416 }, /* BFINS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eff0_0), 0, 61424 }, /* BFINS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eff8_0), 0, 61432 }, /* BFINS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eff9_0), 0, 61433 }, /* BFINS.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_f200_0), 0, 61952 }, /* FPP.L #<data>.W,Dn */
{ CPUFUNC_FF(op_f208_0), 0, 61960 }, /* FPP.L #<data>.W,An */
{ CPUFUNC_FF(op_f210_0), 0, 61968 }, /* FPP.L #<data>.W,(An) */
{ CPUFUNC_FF(op_f218_0), 0, 61976 }, /* FPP.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_f220_0), 0, 61984 }, /* FPP.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_f228_0), 0, 61992 }, /* FPP.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_f230_0), 0, 62000 }, /* FPP.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_f238_0), 0, 62008 }, /* FPP.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_f239_0), 0, 62009 }, /* FPP.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_f23a_0), 0, 62010 }, /* FPP.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_f23b_0), 0, 62011 }, /* FPP.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_f23c_0), 0, 62012 }, /* FPP.L #<data>.W,#<data>.L */
{ CPUFUNC_FF(op_f240_0), 0, 62016 }, /* FScc.L #<data>.W,Dn */
{ CPUFUNC_FF(op_f248_0), 0, 62024 }, /* FDBcc.L #<data>.W,Dn */
{ CPUFUNC_FF(op_f250_0), 0, 62032 }, /* FScc.L #<data>.W,(An) */
{ CPUFUNC_FF(op_f258_0), 0, 62040 }, /* FScc.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_f260_0), 0, 62048 }, /* FScc.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_f268_0), 0, 62056 }, /* FScc.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_f270_0), 0, 62064 }, /* FScc.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_f278_0), 0, 62072 }, /* FScc.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_f279_0), 0, 62073 }, /* FScc.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_f27a_0), 0, 62074 }, /* FTRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_f27b_0), 0, 62075 }, /* FTRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_f27c_0), 0, 62076 }, /* FTRAPcc.L  */
{ CPUFUNC_FF(op_f280_0), 0, 62080 }, /* FBcc.L #<data>,#<data>.W */
{ CPUFUNC_FF(op_f2c0_0), 0, 62144 }, /* FBcc.L #<data>,#<data>.L */
{ CPUFUNC_FF(op_f310_0), 0, 62224 }, /* FSAVE.L (An) */
{ CPUFUNC_FF(op_f320_0), 0, 62240 }, /* FSAVE.L -(An) */
{ CPUFUNC_FF(op_f328_0), 0, 62248 }, /* FSAVE.L (d16,An) */
{ CPUFUNC_FF(op_f330_0), 0, 62256 }, /* FSAVE.L (d8,An,Xn) */
{ CPUFUNC_FF(op_f338_0), 0, 62264 }, /* FSAVE.L (xxx).W */
{ CPUFUNC_FF(op_f339_0), 0, 62265 }, /* FSAVE.L (xxx).L */
{ CPUFUNC_FF(op_f350_0), 0, 62288 }, /* FRESTORE.L (An) */
{ CPUFUNC_FF(op_f358_0), 0, 62296 }, /* FRESTORE.L (An)+ */
{ CPUFUNC_FF(op_f368_0), 0, 62312 }, /* FRESTORE.L (d16,An) */
{ CPUFUNC_FF(op_f370_0), 0, 62320 }, /* FRESTORE.L (d8,An,Xn) */
{ CPUFUNC_FF(op_f378_0), 0, 62328 }, /* FRESTORE.L (xxx).W */
{ CPUFUNC_FF(op_f379_0), 0, 62329 }, /* FRESTORE.L (xxx).L */
{ CPUFUNC_FF(op_f37a_0), 0, 62330 }, /* FRESTORE.L (d16,PC) */
{ CPUFUNC_FF(op_f37b_0), 0, 62331 }, /* FRESTORE.L (d8,PC,Xn) */
{ 0, 0, 0 }};
struct cputbl CPUFUNC(op_smalltbl_2)[] = {
{ CPUFUNC(op_0_0), 0, 0 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_10_0), 0, 16 }, /* OR.B #<data>.B,(An) */
{ CPUFUNC(op_18_0), 0, 24 }, /* OR.B #<data>.B,(An)+ */
{ CPUFUNC(op_20_0), 0, 32 }, /* OR.B #<data>.B,-(An) */
{ CPUFUNC(op_28_0), 0, 40 }, /* OR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_30_0), 0, 48 }, /* OR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_38_0), 0, 56 }, /* OR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_39_0), 0, 57 }, /* OR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_3c_0), 0, 60 }, /* ORSR.B #<data>.W */
{ CPUFUNC(op_40_0), 0, 64 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_50_0), 0, 80 }, /* OR.W #<data>.W,(An) */
{ CPUFUNC(op_58_0), 0, 88 }, /* OR.W #<data>.W,(An)+ */
{ CPUFUNC(op_60_0), 0, 96 }, /* OR.W #<data>.W,-(An) */
{ CPUFUNC(op_68_0), 0, 104 }, /* OR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_70_0), 0, 112 }, /* OR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_78_0), 0, 120 }, /* OR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_79_0), 0, 121 }, /* OR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_7c_0), 0, 124 }, /* ORSR.W #<data>.W */
{ CPUFUNC(op_80_0), 0, 128 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_90_0), 0, 144 }, /* OR.L #<data>.L,(An) */
{ CPUFUNC(op_98_0), 0, 152 }, /* OR.L #<data>.L,(An)+ */
{ CPUFUNC(op_a0_0), 0, 160 }, /* OR.L #<data>.L,-(An) */
{ CPUFUNC(op_a8_0), 0, 168 }, /* OR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_b0_0), 0, 176 }, /* OR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_b8_0), 0, 184 }, /* OR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_b9_0), 0, 185 }, /* OR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_d0_0), 0, 208 }, /* CHK2.B #<data>.W,(An) */
{ CPUFUNC(op_e8_0), 0, 232 }, /* CHK2.B #<data>.W,(d16,An) */
{ CPUFUNC(op_f0_0), 0, 240 }, /* CHK2.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_f8_0), 0, 248 }, /* CHK2.B #<data>.W,(xxx).W */
{ CPUFUNC(op_f9_0), 0, 249 }, /* CHK2.B #<data>.W,(xxx).L */
{ CPUFUNC(op_fa_0), 0, 250 }, /* CHK2.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_fb_0), 0, 251 }, /* CHK2.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_100_0), 0, 256 }, /* BTST.L Dn,Dn */
{ CPUFUNC_FF(op_108_0), 0, 264 }, /* MVPMR.W (d16,An),Dn */
{ CPUFUNC(op_110_0), 0, 272 }, /* BTST.B Dn,(An) */
{ CPUFUNC(op_118_0), 0, 280 }, /* BTST.B Dn,(An)+ */
{ CPUFUNC(op_120_0), 0, 288 }, /* BTST.B Dn,-(An) */
{ CPUFUNC(op_128_0), 0, 296 }, /* BTST.B Dn,(d16,An) */
{ CPUFUNC(op_130_0), 0, 304 }, /* BTST.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_138_0), 0, 312 }, /* BTST.B Dn,(xxx).W */
{ CPUFUNC(op_139_0), 0, 313 }, /* BTST.B Dn,(xxx).L */
{ CPUFUNC(op_13a_0), 0, 314 }, /* BTST.B Dn,(d16,PC) */
{ CPUFUNC(op_13b_0), 0, 315 }, /* BTST.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_13c_0), 0, 316 }, /* BTST.B Dn,#<data>.B */
{ CPUFUNC(op_140_0), 0, 320 }, /* BCHG.L Dn,Dn */
{ CPUFUNC_FF(op_148_0), 0, 328 }, /* MVPMR.L (d16,An),Dn */
{ CPUFUNC(op_150_0), 0, 336 }, /* BCHG.B Dn,(An) */
{ CPUFUNC(op_158_0), 0, 344 }, /* BCHG.B Dn,(An)+ */
{ CPUFUNC(op_160_0), 0, 352 }, /* BCHG.B Dn,-(An) */
{ CPUFUNC(op_168_0), 0, 360 }, /* BCHG.B Dn,(d16,An) */
{ CPUFUNC(op_170_0), 0, 368 }, /* BCHG.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_178_0), 0, 376 }, /* BCHG.B Dn,(xxx).W */
{ CPUFUNC(op_179_0), 0, 377 }, /* BCHG.B Dn,(xxx).L */
{ CPUFUNC(op_17a_0), 0, 378 }, /* BCHG.B Dn,(d16,PC) */
{ CPUFUNC(op_17b_0), 0, 379 }, /* BCHG.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_180_0), 0, 384 }, /* BCLR.L Dn,Dn */
{ CPUFUNC_FF(op_188_0), 0, 392 }, /* MVPRM.W Dn,(d16,An) */
{ CPUFUNC(op_190_0), 0, 400 }, /* BCLR.B Dn,(An) */
{ CPUFUNC(op_198_0), 0, 408 }, /* BCLR.B Dn,(An)+ */
{ CPUFUNC(op_1a0_0), 0, 416 }, /* BCLR.B Dn,-(An) */
{ CPUFUNC(op_1a8_0), 0, 424 }, /* BCLR.B Dn,(d16,An) */
{ CPUFUNC(op_1b0_0), 0, 432 }, /* BCLR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1b8_0), 0, 440 }, /* BCLR.B Dn,(xxx).W */
{ CPUFUNC(op_1b9_0), 0, 441 }, /* BCLR.B Dn,(xxx).L */
{ CPUFUNC(op_1ba_0), 0, 442 }, /* BCLR.B Dn,(d16,PC) */
{ CPUFUNC(op_1bb_0), 0, 443 }, /* BCLR.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_1c0_0), 0, 448 }, /* BSET.L Dn,Dn */
{ CPUFUNC_FF(op_1c8_0), 0, 456 }, /* MVPRM.L Dn,(d16,An) */
{ CPUFUNC(op_1d0_0), 0, 464 }, /* BSET.B Dn,(An) */
{ CPUFUNC(op_1d8_0), 0, 472 }, /* BSET.B Dn,(An)+ */
{ CPUFUNC(op_1e0_0), 0, 480 }, /* BSET.B Dn,-(An) */
{ CPUFUNC(op_1e8_0), 0, 488 }, /* BSET.B Dn,(d16,An) */
{ CPUFUNC(op_1f0_0), 0, 496 }, /* BSET.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1f8_0), 0, 504 }, /* BSET.B Dn,(xxx).W */
{ CPUFUNC(op_1f9_0), 0, 505 }, /* BSET.B Dn,(xxx).L */
{ CPUFUNC(op_1fa_0), 0, 506 }, /* BSET.B Dn,(d16,PC) */
{ CPUFUNC(op_1fb_0), 0, 507 }, /* BSET.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_200_0), 0, 512 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_210_0), 0, 528 }, /* AND.B #<data>.B,(An) */
{ CPUFUNC(op_218_0), 0, 536 }, /* AND.B #<data>.B,(An)+ */
{ CPUFUNC(op_220_0), 0, 544 }, /* AND.B #<data>.B,-(An) */
{ CPUFUNC(op_228_0), 0, 552 }, /* AND.B #<data>.B,(d16,An) */
{ CPUFUNC(op_230_0), 0, 560 }, /* AND.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_238_0), 0, 568 }, /* AND.B #<data>.B,(xxx).W */
{ CPUFUNC(op_239_0), 0, 569 }, /* AND.B #<data>.B,(xxx).L */
{ CPUFUNC(op_23c_0), 0, 572 }, /* ANDSR.B #<data>.W */
{ CPUFUNC(op_240_0), 0, 576 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_250_0), 0, 592 }, /* AND.W #<data>.W,(An) */
{ CPUFUNC(op_258_0), 0, 600 }, /* AND.W #<data>.W,(An)+ */
{ CPUFUNC(op_260_0), 0, 608 }, /* AND.W #<data>.W,-(An) */
{ CPUFUNC(op_268_0), 0, 616 }, /* AND.W #<data>.W,(d16,An) */
{ CPUFUNC(op_270_0), 0, 624 }, /* AND.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_278_0), 0, 632 }, /* AND.W #<data>.W,(xxx).W */
{ CPUFUNC(op_279_0), 0, 633 }, /* AND.W #<data>.W,(xxx).L */
{ CPUFUNC(op_27c_0), 0, 636 }, /* ANDSR.W #<data>.W */
{ CPUFUNC(op_280_0), 0, 640 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_290_0), 0, 656 }, /* AND.L #<data>.L,(An) */
{ CPUFUNC(op_298_0), 0, 664 }, /* AND.L #<data>.L,(An)+ */
{ CPUFUNC(op_2a0_0), 0, 672 }, /* AND.L #<data>.L,-(An) */
{ CPUFUNC(op_2a8_0), 0, 680 }, /* AND.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2b0_0), 0, 688 }, /* AND.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_2b8_0), 0, 696 }, /* AND.L #<data>.L,(xxx).W */
{ CPUFUNC(op_2b9_0), 0, 697 }, /* AND.L #<data>.L,(xxx).L */
{ CPUFUNC(op_2d0_0), 0, 720 }, /* CHK2.W #<data>.W,(An) */
{ CPUFUNC(op_2e8_0), 0, 744 }, /* CHK2.W #<data>.W,(d16,An) */
{ CPUFUNC(op_2f0_0), 0, 752 }, /* CHK2.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_2f8_0), 0, 760 }, /* CHK2.W #<data>.W,(xxx).W */
{ CPUFUNC(op_2f9_0), 0, 761 }, /* CHK2.W #<data>.W,(xxx).L */
{ CPUFUNC(op_2fa_0), 0, 762 }, /* CHK2.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_2fb_0), 0, 763 }, /* CHK2.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_400_0), 0, 1024 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_410_0), 0, 1040 }, /* SUB.B #<data>.B,(An) */
{ CPUFUNC(op_418_0), 0, 1048 }, /* SUB.B #<data>.B,(An)+ */
{ CPUFUNC(op_420_0), 0, 1056 }, /* SUB.B #<data>.B,-(An) */
{ CPUFUNC(op_428_0), 0, 1064 }, /* SUB.B #<data>.B,(d16,An) */
{ CPUFUNC(op_430_0), 0, 1072 }, /* SUB.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_438_0), 0, 1080 }, /* SUB.B #<data>.B,(xxx).W */
{ CPUFUNC(op_439_0), 0, 1081 }, /* SUB.B #<data>.B,(xxx).L */
{ CPUFUNC(op_440_0), 0, 1088 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_450_0), 0, 1104 }, /* SUB.W #<data>.W,(An) */
{ CPUFUNC(op_458_0), 0, 1112 }, /* SUB.W #<data>.W,(An)+ */
{ CPUFUNC(op_460_0), 0, 1120 }, /* SUB.W #<data>.W,-(An) */
{ CPUFUNC(op_468_0), 0, 1128 }, /* SUB.W #<data>.W,(d16,An) */
{ CPUFUNC(op_470_0), 0, 1136 }, /* SUB.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_478_0), 0, 1144 }, /* SUB.W #<data>.W,(xxx).W */
{ CPUFUNC(op_479_0), 0, 1145 }, /* SUB.W #<data>.W,(xxx).L */
{ CPUFUNC(op_480_0), 0, 1152 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC(op_490_0), 0, 1168 }, /* SUB.L #<data>.L,(An) */
{ CPUFUNC(op_498_0), 0, 1176 }, /* SUB.L #<data>.L,(An)+ */
{ CPUFUNC(op_4a0_0), 0, 1184 }, /* SUB.L #<data>.L,-(An) */
{ CPUFUNC(op_4a8_0), 0, 1192 }, /* SUB.L #<data>.L,(d16,An) */
{ CPUFUNC(op_4b0_0), 0, 1200 }, /* SUB.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_4b8_0), 0, 1208 }, /* SUB.L #<data>.L,(xxx).W */
{ CPUFUNC(op_4b9_0), 0, 1209 }, /* SUB.L #<data>.L,(xxx).L */
{ CPUFUNC(op_4d0_0), 0, 1232 }, /* CHK2.L #<data>.W,(An) */
{ CPUFUNC(op_4e8_0), 0, 1256 }, /* CHK2.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4f0_0), 0, 1264 }, /* CHK2.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4f8_0), 0, 1272 }, /* CHK2.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4f9_0), 0, 1273 }, /* CHK2.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4fa_0), 0, 1274 }, /* CHK2.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4fb_0), 0, 1275 }, /* CHK2.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_600_0), 0, 1536 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_610_0), 0, 1552 }, /* ADD.B #<data>.B,(An) */
{ CPUFUNC(op_618_0), 0, 1560 }, /* ADD.B #<data>.B,(An)+ */
{ CPUFUNC(op_620_0), 0, 1568 }, /* ADD.B #<data>.B,-(An) */
{ CPUFUNC(op_628_0), 0, 1576 }, /* ADD.B #<data>.B,(d16,An) */
{ CPUFUNC(op_630_0), 0, 1584 }, /* ADD.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_638_0), 0, 1592 }, /* ADD.B #<data>.B,(xxx).W */
{ CPUFUNC(op_639_0), 0, 1593 }, /* ADD.B #<data>.B,(xxx).L */
{ CPUFUNC(op_640_0), 0, 1600 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_650_0), 0, 1616 }, /* ADD.W #<data>.W,(An) */
{ CPUFUNC(op_658_0), 0, 1624 }, /* ADD.W #<data>.W,(An)+ */
{ CPUFUNC(op_660_0), 0, 1632 }, /* ADD.W #<data>.W,-(An) */
{ CPUFUNC(op_668_0), 0, 1640 }, /* ADD.W #<data>.W,(d16,An) */
{ CPUFUNC(op_670_0), 0, 1648 }, /* ADD.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_678_0), 0, 1656 }, /* ADD.W #<data>.W,(xxx).W */
{ CPUFUNC(op_679_0), 0, 1657 }, /* ADD.W #<data>.W,(xxx).L */
{ CPUFUNC(op_680_0), 0, 1664 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC(op_690_0), 0, 1680 }, /* ADD.L #<data>.L,(An) */
{ CPUFUNC(op_698_0), 0, 1688 }, /* ADD.L #<data>.L,(An)+ */
{ CPUFUNC(op_6a0_0), 0, 1696 }, /* ADD.L #<data>.L,-(An) */
{ CPUFUNC(op_6a8_0), 0, 1704 }, /* ADD.L #<data>.L,(d16,An) */
{ CPUFUNC(op_6b0_0), 0, 1712 }, /* ADD.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_6b8_0), 0, 1720 }, /* ADD.L #<data>.L,(xxx).W */
{ CPUFUNC(op_6b9_0), 0, 1721 }, /* ADD.L #<data>.L,(xxx).L */
{ CPUFUNC(op_6c0_0), 0, 1728 }, /* RTM.L Dn */
{ CPUFUNC(op_6c8_0), 0, 1736 }, /* RTM.L An */
{ CPUFUNC_FF(op_6d0_0), 0, 1744 }, /* CALLM.L (An) */
{ CPUFUNC_FF(op_6e8_0), 0, 1768 }, /* CALLM.L (d16,An) */
{ CPUFUNC_FF(op_6f0_0), 0, 1776 }, /* CALLM.L (d8,An,Xn) */
{ CPUFUNC_FF(op_6f8_0), 0, 1784 }, /* CALLM.L (xxx).W */
{ CPUFUNC_FF(op_6f9_0), 0, 1785 }, /* CALLM.L (xxx).L */
{ CPUFUNC_FF(op_6fa_0), 0, 1786 }, /* CALLM.L (d16,PC) */
{ CPUFUNC_FF(op_6fb_0), 0, 1787 }, /* CALLM.L (d8,PC,Xn) */
{ CPUFUNC(op_800_0), 0, 2048 }, /* BTST.L #<data>.W,Dn */
{ CPUFUNC(op_810_0), 0, 2064 }, /* BTST.B #<data>.W,(An) */
{ CPUFUNC(op_818_0), 0, 2072 }, /* BTST.B #<data>.W,(An)+ */
{ CPUFUNC(op_820_0), 0, 2080 }, /* BTST.B #<data>.W,-(An) */
{ CPUFUNC(op_828_0), 0, 2088 }, /* BTST.B #<data>.W,(d16,An) */
{ CPUFUNC(op_830_0), 0, 2096 }, /* BTST.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_838_0), 0, 2104 }, /* BTST.B #<data>.W,(xxx).W */
{ CPUFUNC(op_839_0), 0, 2105 }, /* BTST.B #<data>.W,(xxx).L */
{ CPUFUNC(op_83a_0), 0, 2106 }, /* BTST.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_83b_0), 0, 2107 }, /* BTST.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_83c_0), 0, 2108 }, /* BTST.B #<data>.W,#<data>.B */
{ CPUFUNC(op_840_0), 0, 2112 }, /* BCHG.L #<data>.W,Dn */
{ CPUFUNC(op_850_0), 0, 2128 }, /* BCHG.B #<data>.W,(An) */
{ CPUFUNC(op_858_0), 0, 2136 }, /* BCHG.B #<data>.W,(An)+ */
{ CPUFUNC(op_860_0), 0, 2144 }, /* BCHG.B #<data>.W,-(An) */
{ CPUFUNC(op_868_0), 0, 2152 }, /* BCHG.B #<data>.W,(d16,An) */
{ CPUFUNC(op_870_0), 0, 2160 }, /* BCHG.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_878_0), 0, 2168 }, /* BCHG.B #<data>.W,(xxx).W */
{ CPUFUNC(op_879_0), 0, 2169 }, /* BCHG.B #<data>.W,(xxx).L */
{ CPUFUNC(op_87a_0), 0, 2170 }, /* BCHG.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_87b_0), 0, 2171 }, /* BCHG.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_880_0), 0, 2176 }, /* BCLR.L #<data>.W,Dn */
{ CPUFUNC(op_890_0), 0, 2192 }, /* BCLR.B #<data>.W,(An) */
{ CPUFUNC(op_898_0), 0, 2200 }, /* BCLR.B #<data>.W,(An)+ */
{ CPUFUNC(op_8a0_0), 0, 2208 }, /* BCLR.B #<data>.W,-(An) */
{ CPUFUNC(op_8a8_0), 0, 2216 }, /* BCLR.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8b0_0), 0, 2224 }, /* BCLR.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8b8_0), 0, 2232 }, /* BCLR.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8b9_0), 0, 2233 }, /* BCLR.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8ba_0), 0, 2234 }, /* BCLR.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8bb_0), 0, 2235 }, /* BCLR.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_8c0_0), 0, 2240 }, /* BSET.L #<data>.W,Dn */
{ CPUFUNC(op_8d0_0), 0, 2256 }, /* BSET.B #<data>.W,(An) */
{ CPUFUNC(op_8d8_0), 0, 2264 }, /* BSET.B #<data>.W,(An)+ */
{ CPUFUNC(op_8e0_0), 0, 2272 }, /* BSET.B #<data>.W,-(An) */
{ CPUFUNC(op_8e8_0), 0, 2280 }, /* BSET.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8f0_0), 0, 2288 }, /* BSET.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8f8_0), 0, 2296 }, /* BSET.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8f9_0), 0, 2297 }, /* BSET.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8fa_0), 0, 2298 }, /* BSET.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8fb_0), 0, 2299 }, /* BSET.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_a00_0), 0, 2560 }, /* EOR.B #<data>.B,Dn */
{ CPUFUNC(op_a10_0), 0, 2576 }, /* EOR.B #<data>.B,(An) */
{ CPUFUNC(op_a18_0), 0, 2584 }, /* EOR.B #<data>.B,(An)+ */
{ CPUFUNC(op_a20_0), 0, 2592 }, /* EOR.B #<data>.B,-(An) */
{ CPUFUNC(op_a28_0), 0, 2600 }, /* EOR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_a30_0), 0, 2608 }, /* EOR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_a38_0), 0, 2616 }, /* EOR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_a39_0), 0, 2617 }, /* EOR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_a3c_0), 0, 2620 }, /* EORSR.B #<data>.W */
{ CPUFUNC(op_a40_0), 0, 2624 }, /* EOR.W #<data>.W,Dn */
{ CPUFUNC(op_a50_0), 0, 2640 }, /* EOR.W #<data>.W,(An) */
{ CPUFUNC(op_a58_0), 0, 2648 }, /* EOR.W #<data>.W,(An)+ */
{ CPUFUNC(op_a60_0), 0, 2656 }, /* EOR.W #<data>.W,-(An) */
{ CPUFUNC(op_a68_0), 0, 2664 }, /* EOR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_a70_0), 0, 2672 }, /* EOR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_a78_0), 0, 2680 }, /* EOR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_a79_0), 0, 2681 }, /* EOR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_a7c_0), 0, 2684 }, /* EORSR.W #<data>.W */
{ CPUFUNC(op_a80_0), 0, 2688 }, /* EOR.L #<data>.L,Dn */
{ CPUFUNC(op_a90_0), 0, 2704 }, /* EOR.L #<data>.L,(An) */
{ CPUFUNC(op_a98_0), 0, 2712 }, /* EOR.L #<data>.L,(An)+ */
{ CPUFUNC(op_aa0_0), 0, 2720 }, /* EOR.L #<data>.L,-(An) */
{ CPUFUNC(op_aa8_0), 0, 2728 }, /* EOR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_ab0_0), 0, 2736 }, /* EOR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_ab8_0), 0, 2744 }, /* EOR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_ab9_0), 0, 2745 }, /* EOR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_ad0_0), 0, 2768 }, /* CAS.B #<data>.W,(An) */
{ CPUFUNC(op_ad8_0), 0, 2776 }, /* CAS.B #<data>.W,(An)+ */
{ CPUFUNC(op_ae0_0), 0, 2784 }, /* CAS.B #<data>.W,-(An) */
{ CPUFUNC(op_ae8_0), 0, 2792 }, /* CAS.B #<data>.W,(d16,An) */
{ CPUFUNC(op_af0_0), 0, 2800 }, /* CAS.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_af8_0), 0, 2808 }, /* CAS.B #<data>.W,(xxx).W */
{ CPUFUNC(op_af9_0), 0, 2809 }, /* CAS.B #<data>.W,(xxx).L */
{ CPUFUNC(op_c00_0), 0, 3072 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_c10_0), 0, 3088 }, /* CMP.B #<data>.B,(An) */
{ CPUFUNC(op_c18_0), 0, 3096 }, /* CMP.B #<data>.B,(An)+ */
{ CPUFUNC(op_c20_0), 0, 3104 }, /* CMP.B #<data>.B,-(An) */
{ CPUFUNC(op_c28_0), 0, 3112 }, /* CMP.B #<data>.B,(d16,An) */
{ CPUFUNC(op_c30_0), 0, 3120 }, /* CMP.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_c38_0), 0, 3128 }, /* CMP.B #<data>.B,(xxx).W */
{ CPUFUNC(op_c39_0), 0, 3129 }, /* CMP.B #<data>.B,(xxx).L */
{ CPUFUNC(op_c3a_0), 0, 3130 }, /* CMP.B #<data>.B,(d16,PC) */
{ CPUFUNC(op_c3b_0), 0, 3131 }, /* CMP.B #<data>.B,(d8,PC,Xn) */
{ CPUFUNC(op_c40_0), 0, 3136 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_c50_0), 0, 3152 }, /* CMP.W #<data>.W,(An) */
{ CPUFUNC(op_c58_0), 0, 3160 }, /* CMP.W #<data>.W,(An)+ */
{ CPUFUNC(op_c60_0), 0, 3168 }, /* CMP.W #<data>.W,-(An) */
{ CPUFUNC(op_c68_0), 0, 3176 }, /* CMP.W #<data>.W,(d16,An) */
{ CPUFUNC(op_c70_0), 0, 3184 }, /* CMP.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_c78_0), 0, 3192 }, /* CMP.W #<data>.W,(xxx).W */
{ CPUFUNC(op_c79_0), 0, 3193 }, /* CMP.W #<data>.W,(xxx).L */
{ CPUFUNC(op_c7a_0), 0, 3194 }, /* CMP.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_c7b_0), 0, 3195 }, /* CMP.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_c80_0), 0, 3200 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_c90_0), 0, 3216 }, /* CMP.L #<data>.L,(An) */
{ CPUFUNC(op_c98_0), 0, 3224 }, /* CMP.L #<data>.L,(An)+ */
{ CPUFUNC(op_ca0_0), 0, 3232 }, /* CMP.L #<data>.L,-(An) */
{ CPUFUNC(op_ca8_0), 0, 3240 }, /* CMP.L #<data>.L,(d16,An) */
{ CPUFUNC(op_cb0_0), 0, 3248 }, /* CMP.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_cb8_0), 0, 3256 }, /* CMP.L #<data>.L,(xxx).W */
{ CPUFUNC(op_cb9_0), 0, 3257 }, /* CMP.L #<data>.L,(xxx).L */
{ CPUFUNC(op_cba_0), 0, 3258 }, /* CMP.L #<data>.L,(d16,PC) */
{ CPUFUNC(op_cbb_0), 0, 3259 }, /* CMP.L #<data>.L,(d8,PC,Xn) */
{ CPUFUNC(op_cd0_0), 0, 3280 }, /* CAS.W #<data>.W,(An) */
{ CPUFUNC(op_cd8_0), 0, 3288 }, /* CAS.W #<data>.W,(An)+ */
{ CPUFUNC(op_ce0_0), 0, 3296 }, /* CAS.W #<data>.W,-(An) */
{ CPUFUNC(op_ce8_0), 0, 3304 }, /* CAS.W #<data>.W,(d16,An) */
{ CPUFUNC(op_cf0_0), 0, 3312 }, /* CAS.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_cf8_0), 0, 3320 }, /* CAS.W #<data>.W,(xxx).W */
{ CPUFUNC(op_cf9_0), 0, 3321 }, /* CAS.W #<data>.W,(xxx).L */
{ CPUFUNC(op_cfc_0), 0, 3324 }, /* CAS2.W #<data>.L */
{ CPUFUNC_FF(op_e10_0), 0, 3600 }, /* MOVES.B #<data>.W,(An) */
{ CPUFUNC_FF(op_e18_0), 0, 3608 }, /* MOVES.B #<data>.W,(An)+ */
{ CPUFUNC_FF(op_e20_0), 0, 3616 }, /* MOVES.B #<data>.W,-(An) */
{ CPUFUNC_FF(op_e28_0), 0, 3624 }, /* MOVES.B #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_e30_0), 0, 3632 }, /* MOVES.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_e38_0), 0, 3640 }, /* MOVES.B #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_e39_0), 0, 3641 }, /* MOVES.B #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_e50_0), 0, 3664 }, /* MOVES.W #<data>.W,(An) */
{ CPUFUNC_FF(op_e58_0), 0, 3672 }, /* MOVES.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_e60_0), 0, 3680 }, /* MOVES.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_e68_0), 0, 3688 }, /* MOVES.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_e70_0), 0, 3696 }, /* MOVES.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_e78_0), 0, 3704 }, /* MOVES.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_e79_0), 0, 3705 }, /* MOVES.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_e90_0), 0, 3728 }, /* MOVES.L #<data>.W,(An) */
{ CPUFUNC_FF(op_e98_0), 0, 3736 }, /* MOVES.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_ea0_0), 0, 3744 }, /* MOVES.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_ea8_0), 0, 3752 }, /* MOVES.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_eb0_0), 0, 3760 }, /* MOVES.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_eb8_0), 0, 3768 }, /* MOVES.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_eb9_0), 0, 3769 }, /* MOVES.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ed0_0), 0, 3792 }, /* CAS.L #<data>.W,(An) */
{ CPUFUNC(op_ed8_0), 0, 3800 }, /* CAS.L #<data>.W,(An)+ */
{ CPUFUNC(op_ee0_0), 0, 3808 }, /* CAS.L #<data>.W,-(An) */
{ CPUFUNC(op_ee8_0), 0, 3816 }, /* CAS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ef0_0), 0, 3824 }, /* CAS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ef8_0), 0, 3832 }, /* CAS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ef9_0), 0, 3833 }, /* CAS.L #<data>.W,(xxx).L */
{ CPUFUNC(op_efc_0), 0, 3836 }, /* CAS2.L #<data>.L */
{ CPUFUNC(op_1000_0), 0, 4096 }, /* MOVE.B Dn,Dn */
{ CPUFUNC(op_1010_0), 0, 4112 }, /* MOVE.B (An),Dn */
{ CPUFUNC(op_1018_0), 0, 4120 }, /* MOVE.B (An)+,Dn */
{ CPUFUNC(op_1020_0), 0, 4128 }, /* MOVE.B -(An),Dn */
{ CPUFUNC(op_1028_0), 0, 4136 }, /* MOVE.B (d16,An),Dn */
{ CPUFUNC(op_1030_0), 0, 4144 }, /* MOVE.B (d8,An,Xn),Dn */
{ CPUFUNC(op_1038_0), 0, 4152 }, /* MOVE.B (xxx).W,Dn */
{ CPUFUNC(op_1039_0), 0, 4153 }, /* MOVE.B (xxx).L,Dn */
{ CPUFUNC(op_103a_0), 0, 4154 }, /* MOVE.B (d16,PC),Dn */
{ CPUFUNC(op_103b_0), 0, 4155 }, /* MOVE.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_103c_0), 0, 4156 }, /* MOVE.B #<data>.B,Dn */
{ CPUFUNC(op_1080_0), 0, 4224 }, /* MOVE.B Dn,(An) */
{ CPUFUNC(op_1090_0), 0, 4240 }, /* MOVE.B (An),(An) */
{ CPUFUNC(op_1098_0), 0, 4248 }, /* MOVE.B (An)+,(An) */
{ CPUFUNC(op_10a0_0), 0, 4256 }, /* MOVE.B -(An),(An) */
{ CPUFUNC(op_10a8_0), 0, 4264 }, /* MOVE.B (d16,An),(An) */
{ CPUFUNC(op_10b0_0), 0, 4272 }, /* MOVE.B (d8,An,Xn),(An) */
{ CPUFUNC(op_10b8_0), 0, 4280 }, /* MOVE.B (xxx).W,(An) */
{ CPUFUNC(op_10b9_0), 0, 4281 }, /* MOVE.B (xxx).L,(An) */
{ CPUFUNC(op_10ba_0), 0, 4282 }, /* MOVE.B (d16,PC),(An) */
{ CPUFUNC(op_10bb_0), 0, 4283 }, /* MOVE.B (d8,PC,Xn),(An) */
{ CPUFUNC(op_10bc_0), 0, 4284 }, /* MOVE.B #<data>.B,(An) */
{ CPUFUNC(op_10c0_0), 0, 4288 }, /* MOVE.B Dn,(An)+ */
{ CPUFUNC(op_10d0_0), 0, 4304 }, /* MOVE.B (An),(An)+ */
{ CPUFUNC(op_10d8_0), 0, 4312 }, /* MOVE.B (An)+,(An)+ */
{ CPUFUNC(op_10e0_0), 0, 4320 }, /* MOVE.B -(An),(An)+ */
{ CPUFUNC(op_10e8_0), 0, 4328 }, /* MOVE.B (d16,An),(An)+ */
{ CPUFUNC(op_10f0_0), 0, 4336 }, /* MOVE.B (d8,An,Xn),(An)+ */
{ CPUFUNC(op_10f8_0), 0, 4344 }, /* MOVE.B (xxx).W,(An)+ */
{ CPUFUNC(op_10f9_0), 0, 4345 }, /* MOVE.B (xxx).L,(An)+ */
{ CPUFUNC(op_10fa_0), 0, 4346 }, /* MOVE.B (d16,PC),(An)+ */
{ CPUFUNC(op_10fb_0), 0, 4347 }, /* MOVE.B (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_10fc_0), 0, 4348 }, /* MOVE.B #<data>.B,(An)+ */
{ CPUFUNC(op_1100_0), 0, 4352 }, /* MOVE.B Dn,-(An) */
{ CPUFUNC(op_1110_0), 0, 4368 }, /* MOVE.B (An),-(An) */
{ CPUFUNC(op_1118_0), 0, 4376 }, /* MOVE.B (An)+,-(An) */
{ CPUFUNC(op_1120_0), 0, 4384 }, /* MOVE.B -(An),-(An) */
{ CPUFUNC(op_1128_0), 0, 4392 }, /* MOVE.B (d16,An),-(An) */
{ CPUFUNC(op_1130_0), 0, 4400 }, /* MOVE.B (d8,An,Xn),-(An) */
{ CPUFUNC(op_1138_0), 0, 4408 }, /* MOVE.B (xxx).W,-(An) */
{ CPUFUNC(op_1139_0), 0, 4409 }, /* MOVE.B (xxx).L,-(An) */
{ CPUFUNC(op_113a_0), 0, 4410 }, /* MOVE.B (d16,PC),-(An) */
{ CPUFUNC(op_113b_0), 0, 4411 }, /* MOVE.B (d8,PC,Xn),-(An) */
{ CPUFUNC(op_113c_0), 0, 4412 }, /* MOVE.B #<data>.B,-(An) */
{ CPUFUNC(op_1140_0), 0, 4416 }, /* MOVE.B Dn,(d16,An) */
{ CPUFUNC(op_1150_0), 0, 4432 }, /* MOVE.B (An),(d16,An) */
{ CPUFUNC(op_1158_0), 0, 4440 }, /* MOVE.B (An)+,(d16,An) */
{ CPUFUNC(op_1160_0), 0, 4448 }, /* MOVE.B -(An),(d16,An) */
{ CPUFUNC(op_1168_0), 0, 4456 }, /* MOVE.B (d16,An),(d16,An) */
{ CPUFUNC(op_1170_0), 0, 4464 }, /* MOVE.B (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_1178_0), 0, 4472 }, /* MOVE.B (xxx).W,(d16,An) */
{ CPUFUNC(op_1179_0), 0, 4473 }, /* MOVE.B (xxx).L,(d16,An) */
{ CPUFUNC(op_117a_0), 0, 4474 }, /* MOVE.B (d16,PC),(d16,An) */
{ CPUFUNC(op_117b_0), 0, 4475 }, /* MOVE.B (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_117c_0), 0, 4476 }, /* MOVE.B #<data>.B,(d16,An) */
{ CPUFUNC(op_1180_0), 0, 4480 }, /* MOVE.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1190_0), 0, 4496 }, /* MOVE.B (An),(d8,An,Xn) */
{ CPUFUNC(op_1198_0), 0, 4504 }, /* MOVE.B (An)+,(d8,An,Xn) */
{ CPUFUNC(op_11a0_0), 0, 4512 }, /* MOVE.B -(An),(d8,An,Xn) */
{ CPUFUNC(op_11a8_0), 0, 4520 }, /* MOVE.B (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_11b0_0), 0, 4528 }, /* MOVE.B (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11b8_0), 0, 4536 }, /* MOVE.B (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_11b9_0), 0, 4537 }, /* MOVE.B (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_11ba_0), 0, 4538 }, /* MOVE.B (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_11bb_0), 0, 4539 }, /* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11bc_0), 0, 4540 }, /* MOVE.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_11c0_0), 0, 4544 }, /* MOVE.B Dn,(xxx).W */
{ CPUFUNC(op_11d0_0), 0, 4560 }, /* MOVE.B (An),(xxx).W */
{ CPUFUNC(op_11d8_0), 0, 4568 }, /* MOVE.B (An)+,(xxx).W */
{ CPUFUNC(op_11e0_0), 0, 4576 }, /* MOVE.B -(An),(xxx).W */
{ CPUFUNC(op_11e8_0), 0, 4584 }, /* MOVE.B (d16,An),(xxx).W */
{ CPUFUNC(op_11f0_0), 0, 4592 }, /* MOVE.B (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_11f8_0), 0, 4600 }, /* MOVE.B (xxx).W,(xxx).W */
{ CPUFUNC(op_11f9_0), 0, 4601 }, /* MOVE.B (xxx).L,(xxx).W */
{ CPUFUNC(op_11fa_0), 0, 4602 }, /* MOVE.B (d16,PC),(xxx).W */
{ CPUFUNC(op_11fb_0), 0, 4603 }, /* MOVE.B (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_11fc_0), 0, 4604 }, /* MOVE.B #<data>.B,(xxx).W */
{ CPUFUNC(op_13c0_0), 0, 5056 }, /* MOVE.B Dn,(xxx).L */
{ CPUFUNC(op_13d0_0), 0, 5072 }, /* MOVE.B (An),(xxx).L */
{ CPUFUNC(op_13d8_0), 0, 5080 }, /* MOVE.B (An)+,(xxx).L */
{ CPUFUNC(op_13e0_0), 0, 5088 }, /* MOVE.B -(An),(xxx).L */
{ CPUFUNC(op_13e8_0), 0, 5096 }, /* MOVE.B (d16,An),(xxx).L */
{ CPUFUNC(op_13f0_0), 0, 5104 }, /* MOVE.B (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_13f8_0), 0, 5112 }, /* MOVE.B (xxx).W,(xxx).L */
{ CPUFUNC(op_13f9_0), 0, 5113 }, /* MOVE.B (xxx).L,(xxx).L */
{ CPUFUNC(op_13fa_0), 0, 5114 }, /* MOVE.B (d16,PC),(xxx).L */
{ CPUFUNC(op_13fb_0), 0, 5115 }, /* MOVE.B (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_13fc_0), 0, 5116 }, /* MOVE.B #<data>.B,(xxx).L */
{ CPUFUNC(op_2000_0), 0, 8192 }, /* MOVE.L Dn,Dn */
{ CPUFUNC(op_2008_0), 0, 8200 }, /* MOVE.L An,Dn */
{ CPUFUNC(op_2010_0), 0, 8208 }, /* MOVE.L (An),Dn */
{ CPUFUNC(op_2018_0), 0, 8216 }, /* MOVE.L (An)+,Dn */
{ CPUFUNC(op_2020_0), 0, 8224 }, /* MOVE.L -(An),Dn */
{ CPUFUNC(op_2028_0), 0, 8232 }, /* MOVE.L (d16,An),Dn */
{ CPUFUNC(op_2030_0), 0, 8240 }, /* MOVE.L (d8,An,Xn),Dn */
{ CPUFUNC(op_2038_0), 0, 8248 }, /* MOVE.L (xxx).W,Dn */
{ CPUFUNC(op_2039_0), 0, 8249 }, /* MOVE.L (xxx).L,Dn */
{ CPUFUNC(op_203a_0), 0, 8250 }, /* MOVE.L (d16,PC),Dn */
{ CPUFUNC(op_203b_0), 0, 8251 }, /* MOVE.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_203c_0), 0, 8252 }, /* MOVE.L #<data>.L,Dn */
{ CPUFUNC_FF(op_2040_0), 0, 8256 }, /* MOVEA.L Dn,An */
{ CPUFUNC_FF(op_2048_0), 0, 8264 }, /* MOVEA.L An,An */
{ CPUFUNC_FF(op_2050_0), 0, 8272 }, /* MOVEA.L (An),An */
{ CPUFUNC_FF(op_2058_0), 0, 8280 }, /* MOVEA.L (An)+,An */
{ CPUFUNC_FF(op_2060_0), 0, 8288 }, /* MOVEA.L -(An),An */
{ CPUFUNC_FF(op_2068_0), 0, 8296 }, /* MOVEA.L (d16,An),An */
{ CPUFUNC_FF(op_2070_0), 0, 8304 }, /* MOVEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_2078_0), 0, 8312 }, /* MOVEA.L (xxx).W,An */
{ CPUFUNC_FF(op_2079_0), 0, 8313 }, /* MOVEA.L (xxx).L,An */
{ CPUFUNC_FF(op_207a_0), 0, 8314 }, /* MOVEA.L (d16,PC),An */
{ CPUFUNC_FF(op_207b_0), 0, 8315 }, /* MOVEA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_207c_0), 0, 8316 }, /* MOVEA.L #<data>.L,An */
{ CPUFUNC(op_2080_0), 0, 8320 }, /* MOVE.L Dn,(An) */
{ CPUFUNC(op_2088_0), 0, 8328 }, /* MOVE.L An,(An) */
{ CPUFUNC(op_2090_0), 0, 8336 }, /* MOVE.L (An),(An) */
{ CPUFUNC(op_2098_0), 0, 8344 }, /* MOVE.L (An)+,(An) */
{ CPUFUNC(op_20a0_0), 0, 8352 }, /* MOVE.L -(An),(An) */
{ CPUFUNC(op_20a8_0), 0, 8360 }, /* MOVE.L (d16,An),(An) */
{ CPUFUNC(op_20b0_0), 0, 8368 }, /* MOVE.L (d8,An,Xn),(An) */
{ CPUFUNC(op_20b8_0), 0, 8376 }, /* MOVE.L (xxx).W,(An) */
{ CPUFUNC(op_20b9_0), 0, 8377 }, /* MOVE.L (xxx).L,(An) */
{ CPUFUNC(op_20ba_0), 0, 8378 }, /* MOVE.L (d16,PC),(An) */
{ CPUFUNC(op_20bb_0), 0, 8379 }, /* MOVE.L (d8,PC,Xn),(An) */
{ CPUFUNC(op_20bc_0), 0, 8380 }, /* MOVE.L #<data>.L,(An) */
{ CPUFUNC(op_20c0_0), 0, 8384 }, /* MOVE.L Dn,(An)+ */
{ CPUFUNC(op_20c8_0), 0, 8392 }, /* MOVE.L An,(An)+ */
{ CPUFUNC(op_20d0_0), 0, 8400 }, /* MOVE.L (An),(An)+ */
{ CPUFUNC(op_20d8_0), 0, 8408 }, /* MOVE.L (An)+,(An)+ */
{ CPUFUNC(op_20e0_0), 0, 8416 }, /* MOVE.L -(An),(An)+ */
{ CPUFUNC(op_20e8_0), 0, 8424 }, /* MOVE.L (d16,An),(An)+ */
{ CPUFUNC(op_20f0_0), 0, 8432 }, /* MOVE.L (d8,An,Xn),(An)+ */
{ CPUFUNC(op_20f8_0), 0, 8440 }, /* MOVE.L (xxx).W,(An)+ */
{ CPUFUNC(op_20f9_0), 0, 8441 }, /* MOVE.L (xxx).L,(An)+ */
{ CPUFUNC(op_20fa_0), 0, 8442 }, /* MOVE.L (d16,PC),(An)+ */
{ CPUFUNC(op_20fb_0), 0, 8443 }, /* MOVE.L (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_20fc_0), 0, 8444 }, /* MOVE.L #<data>.L,(An)+ */
{ CPUFUNC(op_2100_0), 0, 8448 }, /* MOVE.L Dn,-(An) */
{ CPUFUNC(op_2108_0), 0, 8456 }, /* MOVE.L An,-(An) */
{ CPUFUNC(op_2110_0), 0, 8464 }, /* MOVE.L (An),-(An) */
{ CPUFUNC(op_2118_0), 0, 8472 }, /* MOVE.L (An)+,-(An) */
{ CPUFUNC(op_2120_0), 0, 8480 }, /* MOVE.L -(An),-(An) */
{ CPUFUNC(op_2128_0), 0, 8488 }, /* MOVE.L (d16,An),-(An) */
{ CPUFUNC(op_2130_0), 0, 8496 }, /* MOVE.L (d8,An,Xn),-(An) */
{ CPUFUNC(op_2138_0), 0, 8504 }, /* MOVE.L (xxx).W,-(An) */
{ CPUFUNC(op_2139_0), 0, 8505 }, /* MOVE.L (xxx).L,-(An) */
{ CPUFUNC(op_213a_0), 0, 8506 }, /* MOVE.L (d16,PC),-(An) */
{ CPUFUNC(op_213b_0), 0, 8507 }, /* MOVE.L (d8,PC,Xn),-(An) */
{ CPUFUNC(op_213c_0), 0, 8508 }, /* MOVE.L #<data>.L,-(An) */
{ CPUFUNC(op_2140_0), 0, 8512 }, /* MOVE.L Dn,(d16,An) */
{ CPUFUNC(op_2148_0), 0, 8520 }, /* MOVE.L An,(d16,An) */
{ CPUFUNC(op_2150_0), 0, 8528 }, /* MOVE.L (An),(d16,An) */
{ CPUFUNC(op_2158_0), 0, 8536 }, /* MOVE.L (An)+,(d16,An) */
{ CPUFUNC(op_2160_0), 0, 8544 }, /* MOVE.L -(An),(d16,An) */
{ CPUFUNC(op_2168_0), 0, 8552 }, /* MOVE.L (d16,An),(d16,An) */
{ CPUFUNC(op_2170_0), 0, 8560 }, /* MOVE.L (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_2178_0), 0, 8568 }, /* MOVE.L (xxx).W,(d16,An) */
{ CPUFUNC(op_2179_0), 0, 8569 }, /* MOVE.L (xxx).L,(d16,An) */
{ CPUFUNC(op_217a_0), 0, 8570 }, /* MOVE.L (d16,PC),(d16,An) */
{ CPUFUNC(op_217b_0), 0, 8571 }, /* MOVE.L (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_217c_0), 0, 8572 }, /* MOVE.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2180_0), 0, 8576 }, /* MOVE.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_2188_0), 0, 8584 }, /* MOVE.L An,(d8,An,Xn) */
{ CPUFUNC(op_2190_0), 0, 8592 }, /* MOVE.L (An),(d8,An,Xn) */
{ CPUFUNC(op_2198_0), 0, 8600 }, /* MOVE.L (An)+,(d8,An,Xn) */
{ CPUFUNC(op_21a0_0), 0, 8608 }, /* MOVE.L -(An),(d8,An,Xn) */
{ CPUFUNC(op_21a8_0), 0, 8616 }, /* MOVE.L (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_21b0_0), 0, 8624 }, /* MOVE.L (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21b8_0), 0, 8632 }, /* MOVE.L (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_21b9_0), 0, 8633 }, /* MOVE.L (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_21ba_0), 0, 8634 }, /* MOVE.L (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_21bb_0), 0, 8635 }, /* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21bc_0), 0, 8636 }, /* MOVE.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_21c0_0), 0, 8640 }, /* MOVE.L Dn,(xxx).W */
{ CPUFUNC(op_21c8_0), 0, 8648 }, /* MOVE.L An,(xxx).W */
{ CPUFUNC(op_21d0_0), 0, 8656 }, /* MOVE.L (An),(xxx).W */
{ CPUFUNC(op_21d8_0), 0, 8664 }, /* MOVE.L (An)+,(xxx).W */
{ CPUFUNC(op_21e0_0), 0, 8672 }, /* MOVE.L -(An),(xxx).W */
{ CPUFUNC(op_21e8_0), 0, 8680 }, /* MOVE.L (d16,An),(xxx).W */
{ CPUFUNC(op_21f0_0), 0, 8688 }, /* MOVE.L (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_21f8_0), 0, 8696 }, /* MOVE.L (xxx).W,(xxx).W */
{ CPUFUNC(op_21f9_0), 0, 8697 }, /* MOVE.L (xxx).L,(xxx).W */
{ CPUFUNC(op_21fa_0), 0, 8698 }, /* MOVE.L (d16,PC),(xxx).W */
{ CPUFUNC(op_21fb_0), 0, 8699 }, /* MOVE.L (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_21fc_0), 0, 8700 }, /* MOVE.L #<data>.L,(xxx).W */
{ CPUFUNC(op_23c0_0), 0, 9152 }, /* MOVE.L Dn,(xxx).L */
{ CPUFUNC(op_23c8_0), 0, 9160 }, /* MOVE.L An,(xxx).L */
{ CPUFUNC(op_23d0_0), 0, 9168 }, /* MOVE.L (An),(xxx).L */
{ CPUFUNC(op_23d8_0), 0, 9176 }, /* MOVE.L (An)+,(xxx).L */
{ CPUFUNC(op_23e0_0), 0, 9184 }, /* MOVE.L -(An),(xxx).L */
{ CPUFUNC(op_23e8_0), 0, 9192 }, /* MOVE.L (d16,An),(xxx).L */
{ CPUFUNC(op_23f0_0), 0, 9200 }, /* MOVE.L (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_23f8_0), 0, 9208 }, /* MOVE.L (xxx).W,(xxx).L */
{ CPUFUNC(op_23f9_0), 0, 9209 }, /* MOVE.L (xxx).L,(xxx).L */
{ CPUFUNC(op_23fa_0), 0, 9210 }, /* MOVE.L (d16,PC),(xxx).L */
{ CPUFUNC(op_23fb_0), 0, 9211 }, /* MOVE.L (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_23fc_0), 0, 9212 }, /* MOVE.L #<data>.L,(xxx).L */
{ CPUFUNC(op_3000_0), 0, 12288 }, /* MOVE.W Dn,Dn */
{ CPUFUNC(op_3008_0), 0, 12296 }, /* MOVE.W An,Dn */
{ CPUFUNC(op_3010_0), 0, 12304 }, /* MOVE.W (An),Dn */
{ CPUFUNC(op_3018_0), 0, 12312 }, /* MOVE.W (An)+,Dn */
{ CPUFUNC(op_3020_0), 0, 12320 }, /* MOVE.W -(An),Dn */
{ CPUFUNC(op_3028_0), 0, 12328 }, /* MOVE.W (d16,An),Dn */
{ CPUFUNC(op_3030_0), 0, 12336 }, /* MOVE.W (d8,An,Xn),Dn */
{ CPUFUNC(op_3038_0), 0, 12344 }, /* MOVE.W (xxx).W,Dn */
{ CPUFUNC(op_3039_0), 0, 12345 }, /* MOVE.W (xxx).L,Dn */
{ CPUFUNC(op_303a_0), 0, 12346 }, /* MOVE.W (d16,PC),Dn */
{ CPUFUNC(op_303b_0), 0, 12347 }, /* MOVE.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_303c_0), 0, 12348 }, /* MOVE.W #<data>.W,Dn */
{ CPUFUNC_FF(op_3040_0), 0, 12352 }, /* MOVEA.W Dn,An */
{ CPUFUNC_FF(op_3048_0), 0, 12360 }, /* MOVEA.W An,An */
{ CPUFUNC_FF(op_3050_0), 0, 12368 }, /* MOVEA.W (An),An */
{ CPUFUNC_FF(op_3058_0), 0, 12376 }, /* MOVEA.W (An)+,An */
{ CPUFUNC_FF(op_3060_0), 0, 12384 }, /* MOVEA.W -(An),An */
{ CPUFUNC_FF(op_3068_0), 0, 12392 }, /* MOVEA.W (d16,An),An */
{ CPUFUNC_FF(op_3070_0), 0, 12400 }, /* MOVEA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_3078_0), 0, 12408 }, /* MOVEA.W (xxx).W,An */
{ CPUFUNC_FF(op_3079_0), 0, 12409 }, /* MOVEA.W (xxx).L,An */
{ CPUFUNC_FF(op_307a_0), 0, 12410 }, /* MOVEA.W (d16,PC),An */
{ CPUFUNC_FF(op_307b_0), 0, 12411 }, /* MOVEA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_307c_0), 0, 12412 }, /* MOVEA.W #<data>.W,An */
{ CPUFUNC(op_3080_0), 0, 12416 }, /* MOVE.W Dn,(An) */
{ CPUFUNC(op_3088_0), 0, 12424 }, /* MOVE.W An,(An) */
{ CPUFUNC(op_3090_0), 0, 12432 }, /* MOVE.W (An),(An) */
{ CPUFUNC(op_3098_0), 0, 12440 }, /* MOVE.W (An)+,(An) */
{ CPUFUNC(op_30a0_0), 0, 12448 }, /* MOVE.W -(An),(An) */
{ CPUFUNC(op_30a8_0), 0, 12456 }, /* MOVE.W (d16,An),(An) */
{ CPUFUNC(op_30b0_0), 0, 12464 }, /* MOVE.W (d8,An,Xn),(An) */
{ CPUFUNC(op_30b8_0), 0, 12472 }, /* MOVE.W (xxx).W,(An) */
{ CPUFUNC(op_30b9_0), 0, 12473 }, /* MOVE.W (xxx).L,(An) */
{ CPUFUNC(op_30ba_0), 0, 12474 }, /* MOVE.W (d16,PC),(An) */
{ CPUFUNC(op_30bb_0), 0, 12475 }, /* MOVE.W (d8,PC,Xn),(An) */
{ CPUFUNC(op_30bc_0), 0, 12476 }, /* MOVE.W #<data>.W,(An) */
{ CPUFUNC(op_30c0_0), 0, 12480 }, /* MOVE.W Dn,(An)+ */
{ CPUFUNC(op_30c8_0), 0, 12488 }, /* MOVE.W An,(An)+ */
{ CPUFUNC(op_30d0_0), 0, 12496 }, /* MOVE.W (An),(An)+ */
{ CPUFUNC(op_30d8_0), 0, 12504 }, /* MOVE.W (An)+,(An)+ */
{ CPUFUNC(op_30e0_0), 0, 12512 }, /* MOVE.W -(An),(An)+ */
{ CPUFUNC(op_30e8_0), 0, 12520 }, /* MOVE.W (d16,An),(An)+ */
{ CPUFUNC(op_30f0_0), 0, 12528 }, /* MOVE.W (d8,An,Xn),(An)+ */
{ CPUFUNC(op_30f8_0), 0, 12536 }, /* MOVE.W (xxx).W,(An)+ */
{ CPUFUNC(op_30f9_0), 0, 12537 }, /* MOVE.W (xxx).L,(An)+ */
{ CPUFUNC(op_30fa_0), 0, 12538 }, /* MOVE.W (d16,PC),(An)+ */
{ CPUFUNC(op_30fb_0), 0, 12539 }, /* MOVE.W (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_30fc_0), 0, 12540 }, /* MOVE.W #<data>.W,(An)+ */
{ CPUFUNC(op_3100_0), 0, 12544 }, /* MOVE.W Dn,-(An) */
{ CPUFUNC(op_3108_0), 0, 12552 }, /* MOVE.W An,-(An) */
{ CPUFUNC(op_3110_0), 0, 12560 }, /* MOVE.W (An),-(An) */
{ CPUFUNC(op_3118_0), 0, 12568 }, /* MOVE.W (An)+,-(An) */
{ CPUFUNC(op_3120_0), 0, 12576 }, /* MOVE.W -(An),-(An) */
{ CPUFUNC(op_3128_0), 0, 12584 }, /* MOVE.W (d16,An),-(An) */
{ CPUFUNC(op_3130_0), 0, 12592 }, /* MOVE.W (d8,An,Xn),-(An) */
{ CPUFUNC(op_3138_0), 0, 12600 }, /* MOVE.W (xxx).W,-(An) */
{ CPUFUNC(op_3139_0), 0, 12601 }, /* MOVE.W (xxx).L,-(An) */
{ CPUFUNC(op_313a_0), 0, 12602 }, /* MOVE.W (d16,PC),-(An) */
{ CPUFUNC(op_313b_0), 0, 12603 }, /* MOVE.W (d8,PC,Xn),-(An) */
{ CPUFUNC(op_313c_0), 0, 12604 }, /* MOVE.W #<data>.W,-(An) */
{ CPUFUNC(op_3140_0), 0, 12608 }, /* MOVE.W Dn,(d16,An) */
{ CPUFUNC(op_3148_0), 0, 12616 }, /* MOVE.W An,(d16,An) */
{ CPUFUNC(op_3150_0), 0, 12624 }, /* MOVE.W (An),(d16,An) */
{ CPUFUNC(op_3158_0), 0, 12632 }, /* MOVE.W (An)+,(d16,An) */
{ CPUFUNC(op_3160_0), 0, 12640 }, /* MOVE.W -(An),(d16,An) */
{ CPUFUNC(op_3168_0), 0, 12648 }, /* MOVE.W (d16,An),(d16,An) */
{ CPUFUNC(op_3170_0), 0, 12656 }, /* MOVE.W (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_3178_0), 0, 12664 }, /* MOVE.W (xxx).W,(d16,An) */
{ CPUFUNC(op_3179_0), 0, 12665 }, /* MOVE.W (xxx).L,(d16,An) */
{ CPUFUNC(op_317a_0), 0, 12666 }, /* MOVE.W (d16,PC),(d16,An) */
{ CPUFUNC(op_317b_0), 0, 12667 }, /* MOVE.W (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_317c_0), 0, 12668 }, /* MOVE.W #<data>.W,(d16,An) */
{ CPUFUNC(op_3180_0), 0, 12672 }, /* MOVE.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_3188_0), 0, 12680 }, /* MOVE.W An,(d8,An,Xn) */
{ CPUFUNC(op_3190_0), 0, 12688 }, /* MOVE.W (An),(d8,An,Xn) */
{ CPUFUNC(op_3198_0), 0, 12696 }, /* MOVE.W (An)+,(d8,An,Xn) */
{ CPUFUNC(op_31a0_0), 0, 12704 }, /* MOVE.W -(An),(d8,An,Xn) */
{ CPUFUNC(op_31a8_0), 0, 12712 }, /* MOVE.W (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_31b0_0), 0, 12720 }, /* MOVE.W (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31b8_0), 0, 12728 }, /* MOVE.W (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_31b9_0), 0, 12729 }, /* MOVE.W (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_31ba_0), 0, 12730 }, /* MOVE.W (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_31bb_0), 0, 12731 }, /* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31bc_0), 0, 12732 }, /* MOVE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_31c0_0), 0, 12736 }, /* MOVE.W Dn,(xxx).W */
{ CPUFUNC(op_31c8_0), 0, 12744 }, /* MOVE.W An,(xxx).W */
{ CPUFUNC(op_31d0_0), 0, 12752 }, /* MOVE.W (An),(xxx).W */
{ CPUFUNC(op_31d8_0), 0, 12760 }, /* MOVE.W (An)+,(xxx).W */
{ CPUFUNC(op_31e0_0), 0, 12768 }, /* MOVE.W -(An),(xxx).W */
{ CPUFUNC(op_31e8_0), 0, 12776 }, /* MOVE.W (d16,An),(xxx).W */
{ CPUFUNC(op_31f0_0), 0, 12784 }, /* MOVE.W (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_31f8_0), 0, 12792 }, /* MOVE.W (xxx).W,(xxx).W */
{ CPUFUNC(op_31f9_0), 0, 12793 }, /* MOVE.W (xxx).L,(xxx).W */
{ CPUFUNC(op_31fa_0), 0, 12794 }, /* MOVE.W (d16,PC),(xxx).W */
{ CPUFUNC(op_31fb_0), 0, 12795 }, /* MOVE.W (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_31fc_0), 0, 12796 }, /* MOVE.W #<data>.W,(xxx).W */
{ CPUFUNC(op_33c0_0), 0, 13248 }, /* MOVE.W Dn,(xxx).L */
{ CPUFUNC(op_33c8_0), 0, 13256 }, /* MOVE.W An,(xxx).L */
{ CPUFUNC(op_33d0_0), 0, 13264 }, /* MOVE.W (An),(xxx).L */
{ CPUFUNC(op_33d8_0), 0, 13272 }, /* MOVE.W (An)+,(xxx).L */
{ CPUFUNC(op_33e0_0), 0, 13280 }, /* MOVE.W -(An),(xxx).L */
{ CPUFUNC(op_33e8_0), 0, 13288 }, /* MOVE.W (d16,An),(xxx).L */
{ CPUFUNC(op_33f0_0), 0, 13296 }, /* MOVE.W (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_33f8_0), 0, 13304 }, /* MOVE.W (xxx).W,(xxx).L */
{ CPUFUNC(op_33f9_0), 0, 13305 }, /* MOVE.W (xxx).L,(xxx).L */
{ CPUFUNC(op_33fa_0), 0, 13306 }, /* MOVE.W (d16,PC),(xxx).L */
{ CPUFUNC(op_33fb_0), 0, 13307 }, /* MOVE.W (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_33fc_0), 0, 13308 }, /* MOVE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_4000_0), 0, 16384 }, /* NEGX.B Dn */
{ CPUFUNC(op_4010_0), 0, 16400 }, /* NEGX.B (An) */
{ CPUFUNC(op_4018_0), 0, 16408 }, /* NEGX.B (An)+ */
{ CPUFUNC(op_4020_0), 0, 16416 }, /* NEGX.B -(An) */
{ CPUFUNC(op_4028_0), 0, 16424 }, /* NEGX.B (d16,An) */
{ CPUFUNC(op_4030_0), 0, 16432 }, /* NEGX.B (d8,An,Xn) */
{ CPUFUNC(op_4038_0), 0, 16440 }, /* NEGX.B (xxx).W */
{ CPUFUNC(op_4039_0), 0, 16441 }, /* NEGX.B (xxx).L */
{ CPUFUNC(op_4040_0), 0, 16448 }, /* NEGX.W Dn */
{ CPUFUNC(op_4050_0), 0, 16464 }, /* NEGX.W (An) */
{ CPUFUNC(op_4058_0), 0, 16472 }, /* NEGX.W (An)+ */
{ CPUFUNC(op_4060_0), 0, 16480 }, /* NEGX.W -(An) */
{ CPUFUNC(op_4068_0), 0, 16488 }, /* NEGX.W (d16,An) */
{ CPUFUNC(op_4070_0), 0, 16496 }, /* NEGX.W (d8,An,Xn) */
{ CPUFUNC(op_4078_0), 0, 16504 }, /* NEGX.W (xxx).W */
{ CPUFUNC(op_4079_0), 0, 16505 }, /* NEGX.W (xxx).L */
{ CPUFUNC(op_4080_0), 0, 16512 }, /* NEGX.L Dn */
{ CPUFUNC(op_4090_0), 0, 16528 }, /* NEGX.L (An) */
{ CPUFUNC(op_4098_0), 0, 16536 }, /* NEGX.L (An)+ */
{ CPUFUNC(op_40a0_0), 0, 16544 }, /* NEGX.L -(An) */
{ CPUFUNC(op_40a8_0), 0, 16552 }, /* NEGX.L (d16,An) */
{ CPUFUNC(op_40b0_0), 0, 16560 }, /* NEGX.L (d8,An,Xn) */
{ CPUFUNC(op_40b8_0), 0, 16568 }, /* NEGX.L (xxx).W */
{ CPUFUNC(op_40b9_0), 0, 16569 }, /* NEGX.L (xxx).L */
{ CPUFUNC_FF(op_40c0_0), 0, 16576 }, /* MVSR2.W Dn */
{ CPUFUNC_FF(op_40d0_0), 0, 16592 }, /* MVSR2.W (An) */
{ CPUFUNC_FF(op_40d8_0), 0, 16600 }, /* MVSR2.W (An)+ */
{ CPUFUNC_FF(op_40e0_0), 0, 16608 }, /* MVSR2.W -(An) */
{ CPUFUNC_FF(op_40e8_0), 0, 16616 }, /* MVSR2.W (d16,An) */
{ CPUFUNC_FF(op_40f0_0), 0, 16624 }, /* MVSR2.W (d8,An,Xn) */
{ CPUFUNC_FF(op_40f8_0), 0, 16632 }, /* MVSR2.W (xxx).W */
{ CPUFUNC_FF(op_40f9_0), 0, 16633 }, /* MVSR2.W (xxx).L */
{ CPUFUNC(op_4100_0), 0, 16640 }, /* CHK.L Dn,Dn */
{ CPUFUNC(op_4110_0), 0, 16656 }, /* CHK.L (An),Dn */
{ CPUFUNC(op_4118_0), 0, 16664 }, /* CHK.L (An)+,Dn */
{ CPUFUNC(op_4120_0), 0, 16672 }, /* CHK.L -(An),Dn */
{ CPUFUNC(op_4128_0), 0, 16680 }, /* CHK.L (d16,An),Dn */
{ CPUFUNC(op_4130_0), 0, 16688 }, /* CHK.L (d8,An,Xn),Dn */
{ CPUFUNC(op_4138_0), 0, 16696 }, /* CHK.L (xxx).W,Dn */
{ CPUFUNC(op_4139_0), 0, 16697 }, /* CHK.L (xxx).L,Dn */
{ CPUFUNC(op_413a_0), 0, 16698 }, /* CHK.L (d16,PC),Dn */
{ CPUFUNC(op_413b_0), 0, 16699 }, /* CHK.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_413c_0), 0, 16700 }, /* CHK.L #<data>.L,Dn */
{ CPUFUNC(op_4180_0), 0, 16768 }, /* CHK.W Dn,Dn */
{ CPUFUNC(op_4190_0), 0, 16784 }, /* CHK.W (An),Dn */
{ CPUFUNC(op_4198_0), 0, 16792 }, /* CHK.W (An)+,Dn */
{ CPUFUNC(op_41a0_0), 0, 16800 }, /* CHK.W -(An),Dn */
{ CPUFUNC(op_41a8_0), 0, 16808 }, /* CHK.W (d16,An),Dn */
{ CPUFUNC(op_41b0_0), 0, 16816 }, /* CHK.W (d8,An,Xn),Dn */
{ CPUFUNC(op_41b8_0), 0, 16824 }, /* CHK.W (xxx).W,Dn */
{ CPUFUNC(op_41b9_0), 0, 16825 }, /* CHK.W (xxx).L,Dn */
{ CPUFUNC(op_41ba_0), 0, 16826 }, /* CHK.W (d16,PC),Dn */
{ CPUFUNC(op_41bb_0), 0, 16827 }, /* CHK.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_41bc_0), 0, 16828 }, /* CHK.W #<data>.W,Dn */
{ CPUFUNC_FF(op_41d0_0), 0, 16848 }, /* LEA.L (An),An */
{ CPUFUNC_FF(op_41e8_0), 0, 16872 }, /* LEA.L (d16,An),An */
{ CPUFUNC_FF(op_41f0_0), 0, 16880 }, /* LEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_41f8_0), 0, 16888 }, /* LEA.L (xxx).W,An */
{ CPUFUNC_FF(op_41f9_0), 0, 16889 }, /* LEA.L (xxx).L,An */
{ CPUFUNC_FF(op_41fa_0), 0, 16890 }, /* LEA.L (d16,PC),An */
{ CPUFUNC_FF(op_41fb_0), 0, 16891 }, /* LEA.L (d8,PC,Xn),An */
{ CPUFUNC(op_4200_0), 0, 16896 }, /* CLR.B Dn */
{ CPUFUNC(op_4210_0), 0, 16912 }, /* CLR.B (An) */
{ CPUFUNC(op_4218_0), 0, 16920 }, /* CLR.B (An)+ */
{ CPUFUNC(op_4220_0), 0, 16928 }, /* CLR.B -(An) */
{ CPUFUNC(op_4228_0), 0, 16936 }, /* CLR.B (d16,An) */
{ CPUFUNC(op_4230_0), 0, 16944 }, /* CLR.B (d8,An,Xn) */
{ CPUFUNC(op_4238_0), 0, 16952 }, /* CLR.B (xxx).W */
{ CPUFUNC(op_4239_0), 0, 16953 }, /* CLR.B (xxx).L */
{ CPUFUNC(op_4240_0), 0, 16960 }, /* CLR.W Dn */
{ CPUFUNC(op_4250_0), 0, 16976 }, /* CLR.W (An) */
{ CPUFUNC(op_4258_0), 0, 16984 }, /* CLR.W (An)+ */
{ CPUFUNC(op_4260_0), 0, 16992 }, /* CLR.W -(An) */
{ CPUFUNC(op_4268_0), 0, 17000 }, /* CLR.W (d16,An) */
{ CPUFUNC(op_4270_0), 0, 17008 }, /* CLR.W (d8,An,Xn) */
{ CPUFUNC(op_4278_0), 0, 17016 }, /* CLR.W (xxx).W */
{ CPUFUNC(op_4279_0), 0, 17017 }, /* CLR.W (xxx).L */
{ CPUFUNC(op_4280_0), 0, 17024 }, /* CLR.L Dn */
{ CPUFUNC(op_4290_0), 0, 17040 }, /* CLR.L (An) */
{ CPUFUNC(op_4298_0), 0, 17048 }, /* CLR.L (An)+ */
{ CPUFUNC(op_42a0_0), 0, 17056 }, /* CLR.L -(An) */
{ CPUFUNC(op_42a8_0), 0, 17064 }, /* CLR.L (d16,An) */
{ CPUFUNC(op_42b0_0), 0, 17072 }, /* CLR.L (d8,An,Xn) */
{ CPUFUNC(op_42b8_0), 0, 17080 }, /* CLR.L (xxx).W */
{ CPUFUNC(op_42b9_0), 0, 17081 }, /* CLR.L (xxx).L */
{ CPUFUNC_FF(op_42c0_0), 0, 17088 }, /* MVSR2.B Dn */
{ CPUFUNC_FF(op_42d0_0), 0, 17104 }, /* MVSR2.B (An) */
{ CPUFUNC_FF(op_42d8_0), 0, 17112 }, /* MVSR2.B (An)+ */
{ CPUFUNC_FF(op_42e0_0), 0, 17120 }, /* MVSR2.B -(An) */
{ CPUFUNC_FF(op_42e8_0), 0, 17128 }, /* MVSR2.B (d16,An) */
{ CPUFUNC_FF(op_42f0_0), 0, 17136 }, /* MVSR2.B (d8,An,Xn) */
{ CPUFUNC_FF(op_42f8_0), 0, 17144 }, /* MVSR2.B (xxx).W */
{ CPUFUNC_FF(op_42f9_0), 0, 17145 }, /* MVSR2.B (xxx).L */
{ CPUFUNC(op_4400_0), 0, 17408 }, /* NEG.B Dn */
{ CPUFUNC(op_4410_0), 0, 17424 }, /* NEG.B (An) */
{ CPUFUNC(op_4418_0), 0, 17432 }, /* NEG.B (An)+ */
{ CPUFUNC(op_4420_0), 0, 17440 }, /* NEG.B -(An) */
{ CPUFUNC(op_4428_0), 0, 17448 }, /* NEG.B (d16,An) */
{ CPUFUNC(op_4430_0), 0, 17456 }, /* NEG.B (d8,An,Xn) */
{ CPUFUNC(op_4438_0), 0, 17464 }, /* NEG.B (xxx).W */
{ CPUFUNC(op_4439_0), 0, 17465 }, /* NEG.B (xxx).L */
{ CPUFUNC(op_4440_0), 0, 17472 }, /* NEG.W Dn */
{ CPUFUNC(op_4450_0), 0, 17488 }, /* NEG.W (An) */
{ CPUFUNC(op_4458_0), 0, 17496 }, /* NEG.W (An)+ */
{ CPUFUNC(op_4460_0), 0, 17504 }, /* NEG.W -(An) */
{ CPUFUNC(op_4468_0), 0, 17512 }, /* NEG.W (d16,An) */
{ CPUFUNC(op_4470_0), 0, 17520 }, /* NEG.W (d8,An,Xn) */
{ CPUFUNC(op_4478_0), 0, 17528 }, /* NEG.W (xxx).W */
{ CPUFUNC(op_4479_0), 0, 17529 }, /* NEG.W (xxx).L */
{ CPUFUNC(op_4480_0), 0, 17536 }, /* NEG.L Dn */
{ CPUFUNC(op_4490_0), 0, 17552 }, /* NEG.L (An) */
{ CPUFUNC(op_4498_0), 0, 17560 }, /* NEG.L (An)+ */
{ CPUFUNC(op_44a0_0), 0, 17568 }, /* NEG.L -(An) */
{ CPUFUNC(op_44a8_0), 0, 17576 }, /* NEG.L (d16,An) */
{ CPUFUNC(op_44b0_0), 0, 17584 }, /* NEG.L (d8,An,Xn) */
{ CPUFUNC(op_44b8_0), 0, 17592 }, /* NEG.L (xxx).W */
{ CPUFUNC(op_44b9_0), 0, 17593 }, /* NEG.L (xxx).L */
{ CPUFUNC(op_44c0_0), 0, 17600 }, /* MV2SR.B Dn */
{ CPUFUNC(op_44d0_0), 0, 17616 }, /* MV2SR.B (An) */
{ CPUFUNC(op_44d8_0), 0, 17624 }, /* MV2SR.B (An)+ */
{ CPUFUNC(op_44e0_0), 0, 17632 }, /* MV2SR.B -(An) */
{ CPUFUNC(op_44e8_0), 0, 17640 }, /* MV2SR.B (d16,An) */
{ CPUFUNC(op_44f0_0), 0, 17648 }, /* MV2SR.B (d8,An,Xn) */
{ CPUFUNC(op_44f8_0), 0, 17656 }, /* MV2SR.B (xxx).W */
{ CPUFUNC(op_44f9_0), 0, 17657 }, /* MV2SR.B (xxx).L */
{ CPUFUNC(op_44fa_0), 0, 17658 }, /* MV2SR.B (d16,PC) */
{ CPUFUNC(op_44fb_0), 0, 17659 }, /* MV2SR.B (d8,PC,Xn) */
{ CPUFUNC(op_44fc_0), 0, 17660 }, /* MV2SR.B #<data>.B */
{ CPUFUNC(op_4600_0), 0, 17920 }, /* NOT.B Dn */
{ CPUFUNC(op_4610_0), 0, 17936 }, /* NOT.B (An) */
{ CPUFUNC(op_4618_0), 0, 17944 }, /* NOT.B (An)+ */
{ CPUFUNC(op_4620_0), 0, 17952 }, /* NOT.B -(An) */
{ CPUFUNC(op_4628_0), 0, 17960 }, /* NOT.B (d16,An) */
{ CPUFUNC(op_4630_0), 0, 17968 }, /* NOT.B (d8,An,Xn) */
{ CPUFUNC(op_4638_0), 0, 17976 }, /* NOT.B (xxx).W */
{ CPUFUNC(op_4639_0), 0, 17977 }, /* NOT.B (xxx).L */
{ CPUFUNC(op_4640_0), 0, 17984 }, /* NOT.W Dn */
{ CPUFUNC(op_4650_0), 0, 18000 }, /* NOT.W (An) */
{ CPUFUNC(op_4658_0), 0, 18008 }, /* NOT.W (An)+ */
{ CPUFUNC(op_4660_0), 0, 18016 }, /* NOT.W -(An) */
{ CPUFUNC(op_4668_0), 0, 18024 }, /* NOT.W (d16,An) */
{ CPUFUNC(op_4670_0), 0, 18032 }, /* NOT.W (d8,An,Xn) */
{ CPUFUNC(op_4678_0), 0, 18040 }, /* NOT.W (xxx).W */
{ CPUFUNC(op_4679_0), 0, 18041 }, /* NOT.W (xxx).L */
{ CPUFUNC(op_4680_0), 0, 18048 }, /* NOT.L Dn */
{ CPUFUNC(op_4690_0), 0, 18064 }, /* NOT.L (An) */
{ CPUFUNC(op_4698_0), 0, 18072 }, /* NOT.L (An)+ */
{ CPUFUNC(op_46a0_0), 0, 18080 }, /* NOT.L -(An) */
{ CPUFUNC(op_46a8_0), 0, 18088 }, /* NOT.L (d16,An) */
{ CPUFUNC(op_46b0_0), 0, 18096 }, /* NOT.L (d8,An,Xn) */
{ CPUFUNC(op_46b8_0), 0, 18104 }, /* NOT.L (xxx).W */
{ CPUFUNC(op_46b9_0), 0, 18105 }, /* NOT.L (xxx).L */
{ CPUFUNC(op_46c0_0), 0, 18112 }, /* MV2SR.W Dn */
{ CPUFUNC(op_46d0_0), 0, 18128 }, /* MV2SR.W (An) */
{ CPUFUNC(op_46d8_0), 0, 18136 }, /* MV2SR.W (An)+ */
{ CPUFUNC(op_46e0_0), 0, 18144 }, /* MV2SR.W -(An) */
{ CPUFUNC(op_46e8_0), 0, 18152 }, /* MV2SR.W (d16,An) */
{ CPUFUNC(op_46f0_0), 0, 18160 }, /* MV2SR.W (d8,An,Xn) */
{ CPUFUNC(op_46f8_0), 0, 18168 }, /* MV2SR.W (xxx).W */
{ CPUFUNC(op_46f9_0), 0, 18169 }, /* MV2SR.W (xxx).L */
{ CPUFUNC(op_46fa_0), 0, 18170 }, /* MV2SR.W (d16,PC) */
{ CPUFUNC(op_46fb_0), 0, 18171 }, /* MV2SR.W (d8,PC,Xn) */
{ CPUFUNC(op_46fc_0), 0, 18172 }, /* MV2SR.W #<data>.W */
{ CPUFUNC(op_4800_1), 0, 18432 }, /* NBCD.B Dn */
{ CPUFUNC_FF(op_4808_0), 0, 18440 }, /* LINK.L An,#<data>.L */
{ CPUFUNC(op_4810_1), 0, 18448 }, /* NBCD.B (An) */
{ CPUFUNC(op_4818_1), 0, 18456 }, /* NBCD.B (An)+ */
{ CPUFUNC(op_4820_1), 0, 18464 }, /* NBCD.B -(An) */
{ CPUFUNC(op_4828_1), 0, 18472 }, /* NBCD.B (d16,An) */
{ CPUFUNC(op_4830_1), 0, 18480 }, /* NBCD.B (d8,An,Xn) */
{ CPUFUNC(op_4838_1), 0, 18488 }, /* NBCD.B (xxx).W */
{ CPUFUNC(op_4839_1), 0, 18489 }, /* NBCD.B (xxx).L */
{ CPUFUNC(op_4840_0), 0, 18496 }, /* SWAP.W Dn */
{ CPUFUNC_FF(op_4848_0), 0, 18504 }, /* BKPT.L #<data> */
{ CPUFUNC_FF(op_4850_0), 0, 18512 }, /* PEA.L (An) */
{ CPUFUNC_FF(op_4868_0), 0, 18536 }, /* PEA.L (d16,An) */
{ CPUFUNC_FF(op_4870_0), 0, 18544 }, /* PEA.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4878_0), 0, 18552 }, /* PEA.L (xxx).W */
{ CPUFUNC_FF(op_4879_0), 0, 18553 }, /* PEA.L (xxx).L */
{ CPUFUNC_FF(op_487a_0), 0, 18554 }, /* PEA.L (d16,PC) */
{ CPUFUNC_FF(op_487b_0), 0, 18555 }, /* PEA.L (d8,PC,Xn) */
{ CPUFUNC(op_4880_0), 0, 18560 }, /* EXT.W Dn */
{ CPUFUNC_FF(op_4890_0), 0, 18576 }, /* MVMLE.W #<data>.W,(An) */
{ CPUFUNC_FF(op_48a0_0), 0, 18592 }, /* MVMLE.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_48a8_0), 0, 18600 }, /* MVMLE.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48b0_0), 0, 18608 }, /* MVMLE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48b8_0), 0, 18616 }, /* MVMLE.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48b9_0), 0, 18617 }, /* MVMLE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_48c0_0), 0, 18624 }, /* EXT.L Dn */
{ CPUFUNC_FF(op_48d0_0), 0, 18640 }, /* MVMLE.L #<data>.W,(An) */
{ CPUFUNC_FF(op_48e0_0), 0, 18656 }, /* MVMLE.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_48e8_0), 0, 18664 }, /* MVMLE.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48f0_0), 0, 18672 }, /* MVMLE.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48f8_0), 0, 18680 }, /* MVMLE.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48f9_0), 0, 18681 }, /* MVMLE.L #<data>.W,(xxx).L */
{ CPUFUNC(op_49c0_0), 0, 18880 }, /* EXT.B Dn */
{ CPUFUNC(op_4a00_0), 0, 18944 }, /* TST.B Dn */
{ CPUFUNC(op_4a10_0), 0, 18960 }, /* TST.B (An) */
{ CPUFUNC(op_4a18_0), 0, 18968 }, /* TST.B (An)+ */
{ CPUFUNC(op_4a20_0), 0, 18976 }, /* TST.B -(An) */
{ CPUFUNC(op_4a28_0), 0, 18984 }, /* TST.B (d16,An) */
{ CPUFUNC(op_4a30_0), 0, 18992 }, /* TST.B (d8,An,Xn) */
{ CPUFUNC(op_4a38_0), 0, 19000 }, /* TST.B (xxx).W */
{ CPUFUNC(op_4a39_0), 0, 19001 }, /* TST.B (xxx).L */
{ CPUFUNC(op_4a3a_0), 0, 19002 }, /* TST.B (d16,PC) */
{ CPUFUNC(op_4a3b_0), 0, 19003 }, /* TST.B (d8,PC,Xn) */
{ CPUFUNC(op_4a3c_0), 0, 19004 }, /* TST.B #<data>.B */
{ CPUFUNC(op_4a40_0), 0, 19008 }, /* TST.W Dn */
{ CPUFUNC(op_4a48_0), 0, 19016 }, /* TST.W An */
{ CPUFUNC(op_4a50_0), 0, 19024 }, /* TST.W (An) */
{ CPUFUNC(op_4a58_0), 0, 19032 }, /* TST.W (An)+ */
{ CPUFUNC(op_4a60_0), 0, 19040 }, /* TST.W -(An) */
{ CPUFUNC(op_4a68_0), 0, 19048 }, /* TST.W (d16,An) */
{ CPUFUNC(op_4a70_0), 0, 19056 }, /* TST.W (d8,An,Xn) */
{ CPUFUNC(op_4a78_0), 0, 19064 }, /* TST.W (xxx).W */
{ CPUFUNC(op_4a79_0), 0, 19065 }, /* TST.W (xxx).L */
{ CPUFUNC(op_4a7a_0), 0, 19066 }, /* TST.W (d16,PC) */
{ CPUFUNC(op_4a7b_0), 0, 19067 }, /* TST.W (d8,PC,Xn) */
{ CPUFUNC(op_4a7c_0), 0, 19068 }, /* TST.W #<data>.W */
{ CPUFUNC(op_4a80_0), 0, 19072 }, /* TST.L Dn */
{ CPUFUNC(op_4a88_0), 0, 19080 }, /* TST.L An */
{ CPUFUNC(op_4a90_0), 0, 19088 }, /* TST.L (An) */
{ CPUFUNC(op_4a98_0), 0, 19096 }, /* TST.L (An)+ */
{ CPUFUNC(op_4aa0_0), 0, 19104 }, /* TST.L -(An) */
{ CPUFUNC(op_4aa8_0), 0, 19112 }, /* TST.L (d16,An) */
{ CPUFUNC(op_4ab0_0), 0, 19120 }, /* TST.L (d8,An,Xn) */
{ CPUFUNC(op_4ab8_0), 0, 19128 }, /* TST.L (xxx).W */
{ CPUFUNC(op_4ab9_0), 0, 19129 }, /* TST.L (xxx).L */
{ CPUFUNC(op_4aba_0), 0, 19130 }, /* TST.L (d16,PC) */
{ CPUFUNC(op_4abb_0), 0, 19131 }, /* TST.L (d8,PC,Xn) */
{ CPUFUNC(op_4abc_0), 0, 19132 }, /* TST.L #<data>.L */
{ CPUFUNC(op_4ac0_0), 0, 19136 }, /* TAS.B Dn */
{ CPUFUNC(op_4ad0_0), 0, 19152 }, /* TAS.B (An) */
{ CPUFUNC(op_4ad8_0), 0, 19160 }, /* TAS.B (An)+ */
{ CPUFUNC(op_4ae0_0), 0, 19168 }, /* TAS.B -(An) */
{ CPUFUNC(op_4ae8_0), 0, 19176 }, /* TAS.B (d16,An) */
{ CPUFUNC(op_4af0_0), 0, 19184 }, /* TAS.B (d8,An,Xn) */
{ CPUFUNC(op_4af8_0), 0, 19192 }, /* TAS.B (xxx).W */
{ CPUFUNC(op_4af9_0), 0, 19193 }, /* TAS.B (xxx).L */
{ CPUFUNC(op_4c00_0), 0, 19456 }, /* MULL.L #<data>.W,Dn */
{ CPUFUNC(op_4c10_0), 0, 19472 }, /* MULL.L #<data>.W,(An) */
{ CPUFUNC(op_4c18_0), 0, 19480 }, /* MULL.L #<data>.W,(An)+ */
{ CPUFUNC(op_4c20_0), 0, 19488 }, /* MULL.L #<data>.W,-(An) */
{ CPUFUNC(op_4c28_0), 0, 19496 }, /* MULL.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4c30_0), 0, 19504 }, /* MULL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4c38_0), 0, 19512 }, /* MULL.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4c39_0), 0, 19513 }, /* MULL.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4c3a_0), 0, 19514 }, /* MULL.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4c3b_0), 0, 19515 }, /* MULL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_4c3c_0), 0, 19516 }, /* MULL.L #<data>.W,#<data>.L */
{ CPUFUNC(op_4c40_0), 0, 19520 }, /* DIVL.L #<data>.W,Dn */
{ CPUFUNC(op_4c50_0), 0, 19536 }, /* DIVL.L #<data>.W,(An) */
{ CPUFUNC(op_4c58_0), 0, 19544 }, /* DIVL.L #<data>.W,(An)+ */
{ CPUFUNC(op_4c60_0), 0, 19552 }, /* DIVL.L #<data>.W,-(An) */
{ CPUFUNC(op_4c68_0), 0, 19560 }, /* DIVL.L #<data>.W,(d16,An) */
{ CPUFUNC(op_4c70_0), 0, 19568 }, /* DIVL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_4c78_0), 0, 19576 }, /* DIVL.L #<data>.W,(xxx).W */
{ CPUFUNC(op_4c79_0), 0, 19577 }, /* DIVL.L #<data>.W,(xxx).L */
{ CPUFUNC(op_4c7a_0), 0, 19578 }, /* DIVL.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_4c7b_0), 0, 19579 }, /* DIVL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_4c7c_0), 0, 19580 }, /* DIVL.L #<data>.W,#<data>.L */
{ CPUFUNC_FF(op_4c90_0), 0, 19600 }, /* MVMEL.W #<data>.W,(An) */
{ CPUFUNC_FF(op_4c98_0), 0, 19608 }, /* MVMEL.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ca8_0), 0, 19624 }, /* MVMEL.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cb0_0), 0, 19632 }, /* MVMEL.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cb8_0), 0, 19640 }, /* MVMEL.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cb9_0), 0, 19641 }, /* MVMEL.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cba_0), 0, 19642 }, /* MVMEL.W #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cbb_0), 0, 19643 }, /* MVMEL.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4cd0_0), 0, 19664 }, /* MVMEL.L #<data>.W,(An) */
{ CPUFUNC_FF(op_4cd8_0), 0, 19672 }, /* MVMEL.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ce8_0), 0, 19688 }, /* MVMEL.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cf0_0), 0, 19696 }, /* MVMEL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cf8_0), 0, 19704 }, /* MVMEL.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cf9_0), 0, 19705 }, /* MVMEL.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cfa_0), 0, 19706 }, /* MVMEL.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cfb_0), 0, 19707 }, /* MVMEL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4e40_0), 0, 20032 }, /* TRAP.L #<data> */
{ CPUFUNC_FF(op_4e50_0), 0, 20048 }, /* LINK.W An,#<data>.W */
{ CPUFUNC_FF(op_4e58_0), 0, 20056 }, /* UNLK.L An */
{ CPUFUNC_FF(op_4e60_0), 0, 20064 }, /* MVR2USP.L An */
{ CPUFUNC_FF(op_4e68_0), 0, 20072 }, /* MVUSP2R.L An */
{ CPUFUNC_FF(op_4e70_0), 0, 20080 }, /* RESET.L  */
{ CPUFUNC_FF(op_4e71_0), 0, 20081 }, /* NOP.L  */
{ CPUFUNC(op_4e72_0), 0, 20082 }, /* STOP.L #<data>.W */
{ CPUFUNC(op_4e73_0), 0, 20083 }, /* RTE.L  */
{ CPUFUNC_FF(op_4e74_0), 0, 20084 }, /* RTD.L #<data>.W */
{ CPUFUNC_FF(op_4e75_0), 0, 20085 }, /* RTS.L  */
{ CPUFUNC_FF(op_4e76_0), 0, 20086 }, /* TRAPV.L  */
{ CPUFUNC(op_4e77_0), 0, 20087 }, /* RTR.L  */
{ CPUFUNC_FF(op_4e7a_0), 0, 20090 }, /* MOVEC2.L #<data>.W */
{ CPUFUNC_FF(op_4e7b_0), 0, 20091 }, /* MOVE2C.L #<data>.W */
{ CPUFUNC_FF(op_4e90_0), 0, 20112 }, /* JSR.L (An) */
{ CPUFUNC_FF(op_4ea8_0), 0, 20136 }, /* JSR.L (d16,An) */
{ CPUFUNC_FF(op_4eb0_0), 0, 20144 }, /* JSR.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4eb8_0), 0, 20152 }, /* JSR.L (xxx).W */
{ CPUFUNC_FF(op_4eb9_0), 0, 20153 }, /* JSR.L (xxx).L */
{ CPUFUNC_FF(op_4eba_0), 0, 20154 }, /* JSR.L (d16,PC) */
{ CPUFUNC_FF(op_4ebb_0), 0, 20155 }, /* JSR.L (d8,PC,Xn) */
{ CPUFUNC_FF(op_4ed0_0), 0, 20176 }, /* JMP.L (An) */
{ CPUFUNC_FF(op_4ee8_0), 0, 20200 }, /* JMP.L (d16,An) */
{ CPUFUNC_FF(op_4ef0_0), 0, 20208 }, /* JMP.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4ef8_0), 0, 20216 }, /* JMP.L (xxx).W */
{ CPUFUNC_FF(op_4ef9_0), 0, 20217 }, /* JMP.L (xxx).L */
{ CPUFUNC_FF(op_4efa_0), 0, 20218 }, /* JMP.L (d16,PC) */
{ CPUFUNC_FF(op_4efb_0), 0, 20219 }, /* JMP.L (d8,PC,Xn) */
{ CPUFUNC(op_5000_0), 0, 20480 }, /* ADD.B #<data>,Dn */
{ CPUFUNC(op_5010_0), 0, 20496 }, /* ADD.B #<data>,(An) */
{ CPUFUNC(op_5018_0), 0, 20504 }, /* ADD.B #<data>,(An)+ */
{ CPUFUNC(op_5020_0), 0, 20512 }, /* ADD.B #<data>,-(An) */
{ CPUFUNC(op_5028_0), 0, 20520 }, /* ADD.B #<data>,(d16,An) */
{ CPUFUNC(op_5030_0), 0, 20528 }, /* ADD.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5038_0), 0, 20536 }, /* ADD.B #<data>,(xxx).W */
{ CPUFUNC(op_5039_0), 0, 20537 }, /* ADD.B #<data>,(xxx).L */
{ CPUFUNC(op_5040_0), 0, 20544 }, /* ADD.W #<data>,Dn */
{ CPUFUNC_FF(op_5048_0), 0, 20552 }, /* ADDA.W #<data>,An */
{ CPUFUNC(op_5050_0), 0, 20560 }, /* ADD.W #<data>,(An) */
{ CPUFUNC(op_5058_0), 0, 20568 }, /* ADD.W #<data>,(An)+ */
{ CPUFUNC(op_5060_0), 0, 20576 }, /* ADD.W #<data>,-(An) */
{ CPUFUNC(op_5068_0), 0, 20584 }, /* ADD.W #<data>,(d16,An) */
{ CPUFUNC(op_5070_0), 0, 20592 }, /* ADD.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5078_0), 0, 20600 }, /* ADD.W #<data>,(xxx).W */
{ CPUFUNC(op_5079_0), 0, 20601 }, /* ADD.W #<data>,(xxx).L */
{ CPUFUNC(op_5080_0), 0, 20608 }, /* ADD.L #<data>,Dn */
{ CPUFUNC_FF(op_5088_0), 0, 20616 }, /* ADDA.L #<data>,An */
{ CPUFUNC(op_5090_0), 0, 20624 }, /* ADD.L #<data>,(An) */
{ CPUFUNC(op_5098_0), 0, 20632 }, /* ADD.L #<data>,(An)+ */
{ CPUFUNC(op_50a0_0), 0, 20640 }, /* ADD.L #<data>,-(An) */
{ CPUFUNC(op_50a8_0), 0, 20648 }, /* ADD.L #<data>,(d16,An) */
{ CPUFUNC(op_50b0_0), 0, 20656 }, /* ADD.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_50b8_0), 0, 20664 }, /* ADD.L #<data>,(xxx).W */
{ CPUFUNC(op_50b9_0), 0, 20665 }, /* ADD.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_50c0_0), 0, 20672 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_50c8_0), 0, 20680 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_50d0_0), 0, 20688 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_50d8_0), 0, 20696 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_50e0_0), 0, 20704 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_50e8_0), 0, 20712 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_50f0_0), 0, 20720 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_50f8_0), 0, 20728 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_50f9_0), 0, 20729 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_50fa_0), 0, 20730 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_50fb_0), 0, 20731 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_50fc_0), 0, 20732 }, /* TRAPcc.L  */
{ CPUFUNC(op_5100_0), 0, 20736 }, /* SUB.B #<data>,Dn */
{ CPUFUNC(op_5110_0), 0, 20752 }, /* SUB.B #<data>,(An) */
{ CPUFUNC(op_5118_0), 0, 20760 }, /* SUB.B #<data>,(An)+ */
{ CPUFUNC(op_5120_0), 0, 20768 }, /* SUB.B #<data>,-(An) */
{ CPUFUNC(op_5128_0), 0, 20776 }, /* SUB.B #<data>,(d16,An) */
{ CPUFUNC(op_5130_0), 0, 20784 }, /* SUB.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5138_0), 0, 20792 }, /* SUB.B #<data>,(xxx).W */
{ CPUFUNC(op_5139_0), 0, 20793 }, /* SUB.B #<data>,(xxx).L */
{ CPUFUNC(op_5140_0), 0, 20800 }, /* SUB.W #<data>,Dn */
{ CPUFUNC_FF(op_5148_0), 0, 20808 }, /* SUBA.W #<data>,An */
{ CPUFUNC(op_5150_0), 0, 20816 }, /* SUB.W #<data>,(An) */
{ CPUFUNC(op_5158_0), 0, 20824 }, /* SUB.W #<data>,(An)+ */
{ CPUFUNC(op_5160_0), 0, 20832 }, /* SUB.W #<data>,-(An) */
{ CPUFUNC(op_5168_0), 0, 20840 }, /* SUB.W #<data>,(d16,An) */
{ CPUFUNC(op_5170_0), 0, 20848 }, /* SUB.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5178_0), 0, 20856 }, /* SUB.W #<data>,(xxx).W */
{ CPUFUNC(op_5179_0), 0, 20857 }, /* SUB.W #<data>,(xxx).L */
{ CPUFUNC(op_5180_0), 0, 20864 }, /* SUB.L #<data>,Dn */
{ CPUFUNC_FF(op_5188_0), 0, 20872 }, /* SUBA.L #<data>,An */
{ CPUFUNC(op_5190_0), 0, 20880 }, /* SUB.L #<data>,(An) */
{ CPUFUNC(op_5198_0), 0, 20888 }, /* SUB.L #<data>,(An)+ */
{ CPUFUNC(op_51a0_0), 0, 20896 }, /* SUB.L #<data>,-(An) */
{ CPUFUNC(op_51a8_0), 0, 20904 }, /* SUB.L #<data>,(d16,An) */
{ CPUFUNC(op_51b0_0), 0, 20912 }, /* SUB.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_51b8_0), 0, 20920 }, /* SUB.L #<data>,(xxx).W */
{ CPUFUNC(op_51b9_0), 0, 20921 }, /* SUB.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_51c0_0), 0, 20928 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_51c8_0), 0, 20936 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_51d0_0), 0, 20944 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_51d8_0), 0, 20952 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_51e0_0), 0, 20960 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_51e8_0), 0, 20968 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_51f0_0), 0, 20976 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_51f8_0), 0, 20984 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_51f9_0), 0, 20985 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_51fa_0), 0, 20986 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_51fb_0), 0, 20987 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_51fc_0), 0, 20988 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_52c0_0), 0, 21184 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_52c8_0), 0, 21192 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_52d0_0), 0, 21200 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_52d8_0), 0, 21208 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_52e0_0), 0, 21216 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_52e8_0), 0, 21224 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_52f0_0), 0, 21232 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_52f8_0), 0, 21240 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_52f9_0), 0, 21241 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_52fa_0), 0, 21242 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_52fb_0), 0, 21243 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_52fc_0), 0, 21244 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_53c0_0), 0, 21440 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_53c8_0), 0, 21448 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_53d0_0), 0, 21456 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_53d8_0), 0, 21464 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_53e0_0), 0, 21472 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_53e8_0), 0, 21480 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_53f0_0), 0, 21488 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_53f8_0), 0, 21496 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_53f9_0), 0, 21497 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_53fa_0), 0, 21498 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_53fb_0), 0, 21499 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_53fc_0), 0, 21500 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_54c0_0), 0, 21696 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_54c8_0), 0, 21704 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_54d0_0), 0, 21712 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_54d8_0), 0, 21720 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_54e0_0), 0, 21728 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_54e8_0), 0, 21736 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_54f0_0), 0, 21744 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_54f8_0), 0, 21752 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_54f9_0), 0, 21753 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_54fa_0), 0, 21754 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_54fb_0), 0, 21755 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_54fc_0), 0, 21756 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_55c0_0), 0, 21952 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_55c8_0), 0, 21960 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_55d0_0), 0, 21968 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_55d8_0), 0, 21976 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_55e0_0), 0, 21984 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_55e8_0), 0, 21992 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_55f0_0), 0, 22000 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_55f8_0), 0, 22008 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_55f9_0), 0, 22009 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_55fa_0), 0, 22010 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_55fb_0), 0, 22011 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_55fc_0), 0, 22012 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_56c0_0), 0, 22208 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_56c8_0), 0, 22216 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_56d0_0), 0, 22224 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_56d8_0), 0, 22232 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_56e0_0), 0, 22240 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_56e8_0), 0, 22248 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_56f0_0), 0, 22256 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_56f8_0), 0, 22264 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_56f9_0), 0, 22265 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_56fa_0), 0, 22266 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_56fb_0), 0, 22267 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_56fc_0), 0, 22268 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_57c0_0), 0, 22464 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_57c8_0), 0, 22472 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_57d0_0), 0, 22480 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_57d8_0), 0, 22488 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_57e0_0), 0, 22496 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_57e8_0), 0, 22504 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_57f0_0), 0, 22512 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_57f8_0), 0, 22520 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_57f9_0), 0, 22521 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_57fa_0), 0, 22522 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_57fb_0), 0, 22523 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_57fc_0), 0, 22524 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_58c0_0), 0, 22720 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_58c8_0), 0, 22728 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_58d0_0), 0, 22736 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_58d8_0), 0, 22744 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_58e0_0), 0, 22752 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_58e8_0), 0, 22760 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_58f0_0), 0, 22768 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_58f8_0), 0, 22776 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_58f9_0), 0, 22777 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_58fa_0), 0, 22778 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_58fb_0), 0, 22779 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_58fc_0), 0, 22780 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_59c0_0), 0, 22976 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_59c8_0), 0, 22984 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_59d0_0), 0, 22992 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_59d8_0), 0, 23000 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_59e0_0), 0, 23008 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_59e8_0), 0, 23016 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_59f0_0), 0, 23024 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_59f8_0), 0, 23032 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_59f9_0), 0, 23033 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_59fa_0), 0, 23034 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_59fb_0), 0, 23035 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_59fc_0), 0, 23036 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5ac0_0), 0, 23232 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ac8_0), 0, 23240 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ad0_0), 0, 23248 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ad8_0), 0, 23256 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ae0_0), 0, 23264 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ae8_0), 0, 23272 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5af0_0), 0, 23280 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5af8_0), 0, 23288 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5af9_0), 0, 23289 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5afa_0), 0, 23290 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5afb_0), 0, 23291 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5afc_0), 0, 23292 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5bc0_0), 0, 23488 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5bc8_0), 0, 23496 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5bd0_0), 0, 23504 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5bd8_0), 0, 23512 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5be0_0), 0, 23520 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5be8_0), 0, 23528 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5bf0_0), 0, 23536 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5bf8_0), 0, 23544 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5bf9_0), 0, 23545 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5bfa_0), 0, 23546 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5bfb_0), 0, 23547 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5bfc_0), 0, 23548 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5cc0_0), 0, 23744 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5cc8_0), 0, 23752 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5cd0_0), 0, 23760 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5cd8_0), 0, 23768 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ce0_0), 0, 23776 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ce8_0), 0, 23784 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5cf0_0), 0, 23792 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5cf8_0), 0, 23800 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5cf9_0), 0, 23801 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5cfa_0), 0, 23802 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5cfb_0), 0, 23803 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5cfc_0), 0, 23804 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5dc0_0), 0, 24000 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5dc8_0), 0, 24008 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5dd0_0), 0, 24016 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5dd8_0), 0, 24024 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5de0_0), 0, 24032 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5de8_0), 0, 24040 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5df0_0), 0, 24048 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5df8_0), 0, 24056 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5df9_0), 0, 24057 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5dfa_0), 0, 24058 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5dfb_0), 0, 24059 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5dfc_0), 0, 24060 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5ec0_0), 0, 24256 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ec8_0), 0, 24264 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ed0_0), 0, 24272 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ed8_0), 0, 24280 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ee0_0), 0, 24288 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ee8_0), 0, 24296 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ef0_0), 0, 24304 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ef8_0), 0, 24312 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ef9_0), 0, 24313 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5efa_0), 0, 24314 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5efb_0), 0, 24315 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5efc_0), 0, 24316 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_5fc0_0), 0, 24512 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5fc8_0), 0, 24520 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5fd0_0), 0, 24528 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5fd8_0), 0, 24536 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5fe0_0), 0, 24544 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5fe8_0), 0, 24552 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ff0_0), 0, 24560 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ff8_0), 0, 24568 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ff9_0), 0, 24569 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ffa_0), 0, 24570 }, /* TRAPcc.L #<data>.W */
{ CPUFUNC_FF(op_5ffb_0), 0, 24571 }, /* TRAPcc.L #<data>.L */
{ CPUFUNC_FF(op_5ffc_0), 0, 24572 }, /* TRAPcc.L  */
{ CPUFUNC_FF(op_6000_0), 0, 24576 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6001_0), 0, 24577 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_60ff_0), 0, 24831 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6100_0), 0, 24832 }, /* BSR.W #<data>.W */
{ CPUFUNC_FF(op_6101_0), 0, 24833 }, /* BSR.B #<data> */
{ CPUFUNC_FF(op_61ff_0), 0, 25087 }, /* BSR.L #<data>.L */
{ CPUFUNC_FF(op_6200_0), 0, 25088 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6201_0), 0, 25089 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_62ff_0), 0, 25343 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6300_0), 0, 25344 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6301_0), 0, 25345 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_63ff_0), 0, 25599 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6400_0), 0, 25600 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6401_0), 0, 25601 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_64ff_0), 0, 25855 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6500_0), 0, 25856 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6501_0), 0, 25857 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_65ff_0), 0, 26111 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6600_0), 0, 26112 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6601_0), 0, 26113 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_66ff_0), 0, 26367 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6700_0), 0, 26368 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6701_0), 0, 26369 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_67ff_0), 0, 26623 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6800_0), 0, 26624 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6801_0), 0, 26625 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_68ff_0), 0, 26879 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6900_0), 0, 26880 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6901_0), 0, 26881 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_69ff_0), 0, 27135 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6a00_0), 0, 27136 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6a01_0), 0, 27137 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6aff_0), 0, 27391 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6b00_0), 0, 27392 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6b01_0), 0, 27393 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6bff_0), 0, 27647 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6c00_0), 0, 27648 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6c01_0), 0, 27649 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6cff_0), 0, 27903 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6d00_0), 0, 27904 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6d01_0), 0, 27905 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6dff_0), 0, 28159 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6e00_0), 0, 28160 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6e01_0), 0, 28161 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6eff_0), 0, 28415 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6f00_0), 0, 28416 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6f01_0), 0, 28417 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6fff_0), 0, 28671 }, /* Bcc.L #<data>.L */
{ CPUFUNC(op_7000_0), 0, 28672 }, /* MOVE.L #<data>,Dn */
{ CPUFUNC_FF(op_7100_0), 0, 28928 }, /* EMULOP_RETURN.L  */
{ CPUFUNC_FF(op_7101_0), 0, 28929 }, /* EMULOP.L #<data> */
{ CPUFUNC(op_8000_0), 0, 32768 }, /* OR.B Dn,Dn */
{ CPUFUNC(op_8010_0), 0, 32784 }, /* OR.B (An),Dn */
{ CPUFUNC(op_8018_0), 0, 32792 }, /* OR.B (An)+,Dn */
{ CPUFUNC(op_8020_0), 0, 32800 }, /* OR.B -(An),Dn */
{ CPUFUNC(op_8028_0), 0, 32808 }, /* OR.B (d16,An),Dn */
{ CPUFUNC(op_8030_0), 0, 32816 }, /* OR.B (d8,An,Xn),Dn */
{ CPUFUNC(op_8038_0), 0, 32824 }, /* OR.B (xxx).W,Dn */
{ CPUFUNC(op_8039_0), 0, 32825 }, /* OR.B (xxx).L,Dn */
{ CPUFUNC(op_803a_0), 0, 32826 }, /* OR.B (d16,PC),Dn */
{ CPUFUNC(op_803b_0), 0, 32827 }, /* OR.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_803c_0), 0, 32828 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_8040_0), 0, 32832 }, /* OR.W Dn,Dn */
{ CPUFUNC(op_8050_0), 0, 32848 }, /* OR.W (An),Dn */
{ CPUFUNC(op_8058_0), 0, 32856 }, /* OR.W (An)+,Dn */
{ CPUFUNC(op_8060_0), 0, 32864 }, /* OR.W -(An),Dn */
{ CPUFUNC(op_8068_0), 0, 32872 }, /* OR.W (d16,An),Dn */
{ CPUFUNC(op_8070_0), 0, 32880 }, /* OR.W (d8,An,Xn),Dn */
{ CPUFUNC(op_8078_0), 0, 32888 }, /* OR.W (xxx).W,Dn */
{ CPUFUNC(op_8079_0), 0, 32889 }, /* OR.W (xxx).L,Dn */
{ CPUFUNC(op_807a_0), 0, 32890 }, /* OR.W (d16,PC),Dn */
{ CPUFUNC(op_807b_0), 0, 32891 }, /* OR.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_807c_0), 0, 32892 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_8080_0), 0, 32896 }, /* OR.L Dn,Dn */
{ CPUFUNC(op_8090_0), 0, 32912 }, /* OR.L (An),Dn */
{ CPUFUNC(op_8098_0), 0, 32920 }, /* OR.L (An)+,Dn */
{ CPUFUNC(op_80a0_0), 0, 32928 }, /* OR.L -(An),Dn */
{ CPUFUNC(op_80a8_0), 0, 32936 }, /* OR.L (d16,An),Dn */
{ CPUFUNC(op_80b0_0), 0, 32944 }, /* OR.L (d8,An,Xn),Dn */
{ CPUFUNC(op_80b8_0), 0, 32952 }, /* OR.L (xxx).W,Dn */
{ CPUFUNC(op_80b9_0), 0, 32953 }, /* OR.L (xxx).L,Dn */
{ CPUFUNC(op_80ba_0), 0, 32954 }, /* OR.L (d16,PC),Dn */
{ CPUFUNC(op_80bb_0), 0, 32955 }, /* OR.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_80bc_0), 0, 32956 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_80c0_0), 0, 32960 }, /* DIVU.W Dn,Dn */
{ CPUFUNC(op_80d0_0), 0, 32976 }, /* DIVU.W (An),Dn */
{ CPUFUNC(op_80d8_0), 0, 32984 }, /* DIVU.W (An)+,Dn */
{ CPUFUNC(op_80e0_0), 0, 32992 }, /* DIVU.W -(An),Dn */
{ CPUFUNC(op_80e8_0), 0, 33000 }, /* DIVU.W (d16,An),Dn */
{ CPUFUNC(op_80f0_0), 0, 33008 }, /* DIVU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_80f8_0), 0, 33016 }, /* DIVU.W (xxx).W,Dn */
{ CPUFUNC(op_80f9_0), 0, 33017 }, /* DIVU.W (xxx).L,Dn */
{ CPUFUNC(op_80fa_0), 0, 33018 }, /* DIVU.W (d16,PC),Dn */
{ CPUFUNC(op_80fb_0), 0, 33019 }, /* DIVU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_80fc_0), 0, 33020 }, /* DIVU.W #<data>.W,Dn */
{ CPUFUNC(op_8100_1), 0, 33024 }, /* SBCD.B Dn,Dn */
{ CPUFUNC(op_8108_1), 0, 33032 }, /* SBCD.B -(An),-(An) */
{ CPUFUNC(op_8110_0), 0, 33040 }, /* OR.B Dn,(An) */
{ CPUFUNC(op_8118_0), 0, 33048 }, /* OR.B Dn,(An)+ */
{ CPUFUNC(op_8120_0), 0, 33056 }, /* OR.B Dn,-(An) */
{ CPUFUNC(op_8128_0), 0, 33064 }, /* OR.B Dn,(d16,An) */
{ CPUFUNC(op_8130_0), 0, 33072 }, /* OR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_8138_0), 0, 33080 }, /* OR.B Dn,(xxx).W */
{ CPUFUNC(op_8139_0), 0, 33081 }, /* OR.B Dn,(xxx).L */
{ CPUFUNC_FF(op_8140_0), 0, 33088 }, /* PACK.L Dn,Dn */
{ CPUFUNC_FF(op_8148_0), 0, 33096 }, /* PACK.L -(An),-(An) */
{ CPUFUNC(op_8150_0), 0, 33104 }, /* OR.W Dn,(An) */
{ CPUFUNC(op_8158_0), 0, 33112 }, /* OR.W Dn,(An)+ */
{ CPUFUNC(op_8160_0), 0, 33120 }, /* OR.W Dn,-(An) */
{ CPUFUNC(op_8168_0), 0, 33128 }, /* OR.W Dn,(d16,An) */
{ CPUFUNC(op_8170_0), 0, 33136 }, /* OR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_8178_0), 0, 33144 }, /* OR.W Dn,(xxx).W */
{ CPUFUNC(op_8179_0), 0, 33145 }, /* OR.W Dn,(xxx).L */
{ CPUFUNC_FF(op_8180_0), 0, 33152 }, /* UNPK.L Dn,Dn */
{ CPUFUNC_FF(op_8188_0), 0, 33160 }, /* UNPK.L -(An),-(An) */
{ CPUFUNC(op_8190_0), 0, 33168 }, /* OR.L Dn,(An) */
{ CPUFUNC(op_8198_0), 0, 33176 }, /* OR.L Dn,(An)+ */
{ CPUFUNC(op_81a0_0), 0, 33184 }, /* OR.L Dn,-(An) */
{ CPUFUNC(op_81a8_0), 0, 33192 }, /* OR.L Dn,(d16,An) */
{ CPUFUNC(op_81b0_0), 0, 33200 }, /* OR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_81b8_0), 0, 33208 }, /* OR.L Dn,(xxx).W */
{ CPUFUNC(op_81b9_0), 0, 33209 }, /* OR.L Dn,(xxx).L */
{ CPUFUNC(op_81c0_0), 0, 33216 }, /* DIVS.W Dn,Dn */
{ CPUFUNC(op_81d0_0), 0, 33232 }, /* DIVS.W (An),Dn */
{ CPUFUNC(op_81d8_0), 0, 33240 }, /* DIVS.W (An)+,Dn */
{ CPUFUNC(op_81e0_0), 0, 33248 }, /* DIVS.W -(An),Dn */
{ CPUFUNC(op_81e8_0), 0, 33256 }, /* DIVS.W (d16,An),Dn */
{ CPUFUNC(op_81f0_0), 0, 33264 }, /* DIVS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_81f8_0), 0, 33272 }, /* DIVS.W (xxx).W,Dn */
{ CPUFUNC(op_81f9_0), 0, 33273 }, /* DIVS.W (xxx).L,Dn */
{ CPUFUNC(op_81fa_0), 0, 33274 }, /* DIVS.W (d16,PC),Dn */
{ CPUFUNC(op_81fb_0), 0, 33275 }, /* DIVS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_81fc_0), 0, 33276 }, /* DIVS.W #<data>.W,Dn */
{ CPUFUNC(op_9000_0), 0, 36864 }, /* SUB.B Dn,Dn */
{ CPUFUNC(op_9010_0), 0, 36880 }, /* SUB.B (An),Dn */
{ CPUFUNC(op_9018_0), 0, 36888 }, /* SUB.B (An)+,Dn */
{ CPUFUNC(op_9020_0), 0, 36896 }, /* SUB.B -(An),Dn */
{ CPUFUNC(op_9028_0), 0, 36904 }, /* SUB.B (d16,An),Dn */
{ CPUFUNC(op_9030_0), 0, 36912 }, /* SUB.B (d8,An,Xn),Dn */
{ CPUFUNC(op_9038_0), 0, 36920 }, /* SUB.B (xxx).W,Dn */
{ CPUFUNC(op_9039_0), 0, 36921 }, /* SUB.B (xxx).L,Dn */
{ CPUFUNC(op_903a_0), 0, 36922 }, /* SUB.B (d16,PC),Dn */
{ CPUFUNC(op_903b_0), 0, 36923 }, /* SUB.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_903c_0), 0, 36924 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_9040_0), 0, 36928 }, /* SUB.W Dn,Dn */
{ CPUFUNC(op_9048_0), 0, 36936 }, /* SUB.W An,Dn */
{ CPUFUNC(op_9050_0), 0, 36944 }, /* SUB.W (An),Dn */
{ CPUFUNC(op_9058_0), 0, 36952 }, /* SUB.W (An)+,Dn */
{ CPUFUNC(op_9060_0), 0, 36960 }, /* SUB.W -(An),Dn */
{ CPUFUNC(op_9068_0), 0, 36968 }, /* SUB.W (d16,An),Dn */
{ CPUFUNC(op_9070_0), 0, 36976 }, /* SUB.W (d8,An,Xn),Dn */
{ CPUFUNC(op_9078_0), 0, 36984 }, /* SUB.W (xxx).W,Dn */
{ CPUFUNC(op_9079_0), 0, 36985 }, /* SUB.W (xxx).L,Dn */
{ CPUFUNC(op_907a_0), 0, 36986 }, /* SUB.W (d16,PC),Dn */
{ CPUFUNC(op_907b_0), 0, 36987 }, /* SUB.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_907c_0), 0, 36988 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_9080_0), 0, 36992 }, /* SUB.L Dn,Dn */
{ CPUFUNC(op_9088_0), 0, 37000 }, /* SUB.L An,Dn */
{ CPUFUNC(op_9090_0), 0, 37008 }, /* SUB.L (An),Dn */
{ CPUFUNC(op_9098_0), 0, 37016 }, /* SUB.L (An)+,Dn */
{ CPUFUNC(op_90a0_0), 0, 37024 }, /* SUB.L -(An),Dn */
{ CPUFUNC(op_90a8_0), 0, 37032 }, /* SUB.L (d16,An),Dn */
{ CPUFUNC(op_90b0_0), 0, 37040 }, /* SUB.L (d8,An,Xn),Dn */
{ CPUFUNC(op_90b8_0), 0, 37048 }, /* SUB.L (xxx).W,Dn */
{ CPUFUNC(op_90b9_0), 0, 37049 }, /* SUB.L (xxx).L,Dn */
{ CPUFUNC(op_90ba_0), 0, 37050 }, /* SUB.L (d16,PC),Dn */
{ CPUFUNC(op_90bb_0), 0, 37051 }, /* SUB.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_90bc_0), 0, 37052 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC_FF(op_90c0_0), 0, 37056 }, /* SUBA.W Dn,An */
{ CPUFUNC_FF(op_90c8_0), 0, 37064 }, /* SUBA.W An,An */
{ CPUFUNC_FF(op_90d0_0), 0, 37072 }, /* SUBA.W (An),An */
{ CPUFUNC_FF(op_90d8_0), 0, 37080 }, /* SUBA.W (An)+,An */
{ CPUFUNC_FF(op_90e0_0), 0, 37088 }, /* SUBA.W -(An),An */
{ CPUFUNC_FF(op_90e8_0), 0, 37096 }, /* SUBA.W (d16,An),An */
{ CPUFUNC_FF(op_90f0_0), 0, 37104 }, /* SUBA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_90f8_0), 0, 37112 }, /* SUBA.W (xxx).W,An */
{ CPUFUNC_FF(op_90f9_0), 0, 37113 }, /* SUBA.W (xxx).L,An */
{ CPUFUNC_FF(op_90fa_0), 0, 37114 }, /* SUBA.W (d16,PC),An */
{ CPUFUNC_FF(op_90fb_0), 0, 37115 }, /* SUBA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_90fc_0), 0, 37116 }, /* SUBA.W #<data>.W,An */
{ CPUFUNC(op_9100_0), 0, 37120 }, /* SUBX.B Dn,Dn */
{ CPUFUNC(op_9108_0), 0, 37128 }, /* SUBX.B -(An),-(An) */
{ CPUFUNC(op_9110_0), 0, 37136 }, /* SUB.B Dn,(An) */
{ CPUFUNC(op_9118_0), 0, 37144 }, /* SUB.B Dn,(An)+ */
{ CPUFUNC(op_9120_0), 0, 37152 }, /* SUB.B Dn,-(An) */
{ CPUFUNC(op_9128_0), 0, 37160 }, /* SUB.B Dn,(d16,An) */
{ CPUFUNC(op_9130_0), 0, 37168 }, /* SUB.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_9138_0), 0, 37176 }, /* SUB.B Dn,(xxx).W */
{ CPUFUNC(op_9139_0), 0, 37177 }, /* SUB.B Dn,(xxx).L */
{ CPUFUNC(op_9140_0), 0, 37184 }, /* SUBX.W Dn,Dn */
{ CPUFUNC(op_9148_0), 0, 37192 }, /* SUBX.W -(An),-(An) */
{ CPUFUNC(op_9150_0), 0, 37200 }, /* SUB.W Dn,(An) */
{ CPUFUNC(op_9158_0), 0, 37208 }, /* SUB.W Dn,(An)+ */
{ CPUFUNC(op_9160_0), 0, 37216 }, /* SUB.W Dn,-(An) */
{ CPUFUNC(op_9168_0), 0, 37224 }, /* SUB.W Dn,(d16,An) */
{ CPUFUNC(op_9170_0), 0, 37232 }, /* SUB.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_9178_0), 0, 37240 }, /* SUB.W Dn,(xxx).W */
{ CPUFUNC(op_9179_0), 0, 37241 }, /* SUB.W Dn,(xxx).L */
{ CPUFUNC(op_9180_0), 0, 37248 }, /* SUBX.L Dn,Dn */
{ CPUFUNC(op_9188_0), 0, 37256 }, /* SUBX.L -(An),-(An) */
{ CPUFUNC(op_9190_0), 0, 37264 }, /* SUB.L Dn,(An) */
{ CPUFUNC(op_9198_0), 0, 37272 }, /* SUB.L Dn,(An)+ */
{ CPUFUNC(op_91a0_0), 0, 37280 }, /* SUB.L Dn,-(An) */
{ CPUFUNC(op_91a8_0), 0, 37288 }, /* SUB.L Dn,(d16,An) */
{ CPUFUNC(op_91b0_0), 0, 37296 }, /* SUB.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_91b8_0), 0, 37304 }, /* SUB.L Dn,(xxx).W */
{ CPUFUNC(op_91b9_0), 0, 37305 }, /* SUB.L Dn,(xxx).L */
{ CPUFUNC_FF(op_91c0_0), 0, 37312 }, /* SUBA.L Dn,An */
{ CPUFUNC_FF(op_91c8_0), 0, 37320 }, /* SUBA.L An,An */
{ CPUFUNC_FF(op_91d0_0), 0, 37328 }, /* SUBA.L (An),An */
{ CPUFUNC_FF(op_91d8_0), 0, 37336 }, /* SUBA.L (An)+,An */
{ CPUFUNC_FF(op_91e0_0), 0, 37344 }, /* SUBA.L -(An),An */
{ CPUFUNC_FF(op_91e8_0), 0, 37352 }, /* SUBA.L (d16,An),An */
{ CPUFUNC_FF(op_91f0_0), 0, 37360 }, /* SUBA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_91f8_0), 0, 37368 }, /* SUBA.L (xxx).W,An */
{ CPUFUNC_FF(op_91f9_0), 0, 37369 }, /* SUBA.L (xxx).L,An */
{ CPUFUNC_FF(op_91fa_0), 0, 37370 }, /* SUBA.L (d16,PC),An */
{ CPUFUNC_FF(op_91fb_0), 0, 37371 }, /* SUBA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_91fc_0), 0, 37372 }, /* SUBA.L #<data>.L,An */
{ CPUFUNC(op_b000_0), 0, 45056 }, /* CMP.B Dn,Dn */
{ CPUFUNC(op_b010_0), 0, 45072 }, /* CMP.B (An),Dn */
{ CPUFUNC(op_b018_0), 0, 45080 }, /* CMP.B (An)+,Dn */
{ CPUFUNC(op_b020_0), 0, 45088 }, /* CMP.B -(An),Dn */
{ CPUFUNC(op_b028_0), 0, 45096 }, /* CMP.B (d16,An),Dn */
{ CPUFUNC(op_b030_0), 0, 45104 }, /* CMP.B (d8,An,Xn),Dn */
{ CPUFUNC(op_b038_0), 0, 45112 }, /* CMP.B (xxx).W,Dn */
{ CPUFUNC(op_b039_0), 0, 45113 }, /* CMP.B (xxx).L,Dn */
{ CPUFUNC(op_b03a_0), 0, 45114 }, /* CMP.B (d16,PC),Dn */
{ CPUFUNC(op_b03b_0), 0, 45115 }, /* CMP.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_b03c_0), 0, 45116 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_b040_0), 0, 45120 }, /* CMP.W Dn,Dn */
{ CPUFUNC(op_b048_0), 0, 45128 }, /* CMP.W An,Dn */
{ CPUFUNC(op_b050_0), 0, 45136 }, /* CMP.W (An),Dn */
{ CPUFUNC(op_b058_0), 0, 45144 }, /* CMP.W (An)+,Dn */
{ CPUFUNC(op_b060_0), 0, 45152 }, /* CMP.W -(An),Dn */
{ CPUFUNC(op_b068_0), 0, 45160 }, /* CMP.W (d16,An),Dn */
{ CPUFUNC(op_b070_0), 0, 45168 }, /* CMP.W (d8,An,Xn),Dn */
{ CPUFUNC(op_b078_0), 0, 45176 }, /* CMP.W (xxx).W,Dn */
{ CPUFUNC(op_b079_0), 0, 45177 }, /* CMP.W (xxx).L,Dn */
{ CPUFUNC(op_b07a_0), 0, 45178 }, /* CMP.W (d16,PC),Dn */
{ CPUFUNC(op_b07b_0), 0, 45179 }, /* CMP.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_b07c_0), 0, 45180 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_b080_0), 0, 45184 }, /* CMP.L Dn,Dn */
{ CPUFUNC(op_b088_0), 0, 45192 }, /* CMP.L An,Dn */
{ CPUFUNC(op_b090_0), 0, 45200 }, /* CMP.L (An),Dn */
{ CPUFUNC(op_b098_0), 0, 45208 }, /* CMP.L (An)+,Dn */
{ CPUFUNC(op_b0a0_0), 0, 45216 }, /* CMP.L -(An),Dn */
{ CPUFUNC(op_b0a8_0), 0, 45224 }, /* CMP.L (d16,An),Dn */
{ CPUFUNC(op_b0b0_0), 0, 45232 }, /* CMP.L (d8,An,Xn),Dn */
{ CPUFUNC(op_b0b8_0), 0, 45240 }, /* CMP.L (xxx).W,Dn */
{ CPUFUNC(op_b0b9_0), 0, 45241 }, /* CMP.L (xxx).L,Dn */
{ CPUFUNC(op_b0ba_0), 0, 45242 }, /* CMP.L (d16,PC),Dn */
{ CPUFUNC(op_b0bb_0), 0, 45243 }, /* CMP.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_b0bc_0), 0, 45244 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_b0c0_0), 0, 45248 }, /* CMPA.W Dn,An */
{ CPUFUNC(op_b0c8_0), 0, 45256 }, /* CMPA.W An,An */
{ CPUFUNC(op_b0d0_0), 0, 45264 }, /* CMPA.W (An),An */
{ CPUFUNC(op_b0d8_0), 0, 45272 }, /* CMPA.W (An)+,An */
{ CPUFUNC(op_b0e0_0), 0, 45280 }, /* CMPA.W -(An),An */
{ CPUFUNC(op_b0e8_0), 0, 45288 }, /* CMPA.W (d16,An),An */
{ CPUFUNC(op_b0f0_0), 0, 45296 }, /* CMPA.W (d8,An,Xn),An */
{ CPUFUNC(op_b0f8_0), 0, 45304 }, /* CMPA.W (xxx).W,An */
{ CPUFUNC(op_b0f9_0), 0, 45305 }, /* CMPA.W (xxx).L,An */
{ CPUFUNC(op_b0fa_0), 0, 45306 }, /* CMPA.W (d16,PC),An */
{ CPUFUNC(op_b0fb_0), 0, 45307 }, /* CMPA.W (d8,PC,Xn),An */
{ CPUFUNC(op_b0fc_0), 0, 45308 }, /* CMPA.W #<data>.W,An */
{ CPUFUNC(op_b100_0), 0, 45312 }, /* EOR.B Dn,Dn */
{ CPUFUNC(op_b108_0), 0, 45320 }, /* CMPM.B (An)+,(An)+ */
{ CPUFUNC(op_b110_0), 0, 45328 }, /* EOR.B Dn,(An) */
{ CPUFUNC(op_b118_0), 0, 45336 }, /* EOR.B Dn,(An)+ */
{ CPUFUNC(op_b120_0), 0, 45344 }, /* EOR.B Dn,-(An) */
{ CPUFUNC(op_b128_0), 0, 45352 }, /* EOR.B Dn,(d16,An) */
{ CPUFUNC(op_b130_0), 0, 45360 }, /* EOR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_b138_0), 0, 45368 }, /* EOR.B Dn,(xxx).W */
{ CPUFUNC(op_b139_0), 0, 45369 }, /* EOR.B Dn,(xxx).L */
{ CPUFUNC(op_b140_0), 0, 45376 }, /* EOR.W Dn,Dn */
{ CPUFUNC(op_b148_0), 0, 45384 }, /* CMPM.W (An)+,(An)+ */
{ CPUFUNC(op_b150_0), 0, 45392 }, /* EOR.W Dn,(An) */
{ CPUFUNC(op_b158_0), 0, 45400 }, /* EOR.W Dn,(An)+ */
{ CPUFUNC(op_b160_0), 0, 45408 }, /* EOR.W Dn,-(An) */
{ CPUFUNC(op_b168_0), 0, 45416 }, /* EOR.W Dn,(d16,An) */
{ CPUFUNC(op_b170_0), 0, 45424 }, /* EOR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_b178_0), 0, 45432 }, /* EOR.W Dn,(xxx).W */
{ CPUFUNC(op_b179_0), 0, 45433 }, /* EOR.W Dn,(xxx).L */
{ CPUFUNC(op_b180_0), 0, 45440 }, /* EOR.L Dn,Dn */
{ CPUFUNC(op_b188_0), 0, 45448 }, /* CMPM.L (An)+,(An)+ */
{ CPUFUNC(op_b190_0), 0, 45456 }, /* EOR.L Dn,(An) */
{ CPUFUNC(op_b198_0), 0, 45464 }, /* EOR.L Dn,(An)+ */
{ CPUFUNC(op_b1a0_0), 0, 45472 }, /* EOR.L Dn,-(An) */
{ CPUFUNC(op_b1a8_0), 0, 45480 }, /* EOR.L Dn,(d16,An) */
{ CPUFUNC(op_b1b0_0), 0, 45488 }, /* EOR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_b1b8_0), 0, 45496 }, /* EOR.L Dn,(xxx).W */
{ CPUFUNC(op_b1b9_0), 0, 45497 }, /* EOR.L Dn,(xxx).L */
{ CPUFUNC(op_b1c0_0), 0, 45504 }, /* CMPA.L Dn,An */
{ CPUFUNC(op_b1c8_0), 0, 45512 }, /* CMPA.L An,An */
{ CPUFUNC(op_b1d0_0), 0, 45520 }, /* CMPA.L (An),An */
{ CPUFUNC(op_b1d8_0), 0, 45528 }, /* CMPA.L (An)+,An */
{ CPUFUNC(op_b1e0_0), 0, 45536 }, /* CMPA.L -(An),An */
{ CPUFUNC(op_b1e8_0), 0, 45544 }, /* CMPA.L (d16,An),An */
{ CPUFUNC(op_b1f0_0), 0, 45552 }, /* CMPA.L (d8,An,Xn),An */
{ CPUFUNC(op_b1f8_0), 0, 45560 }, /* CMPA.L (xxx).W,An */
{ CPUFUNC(op_b1f9_0), 0, 45561 }, /* CMPA.L (xxx).L,An */
{ CPUFUNC(op_b1fa_0), 0, 45562 }, /* CMPA.L (d16,PC),An */
{ CPUFUNC(op_b1fb_0), 0, 45563 }, /* CMPA.L (d8,PC,Xn),An */
{ CPUFUNC(op_b1fc_0), 0, 45564 }, /* CMPA.L #<data>.L,An */
{ CPUFUNC(op_c000_0), 0, 49152 }, /* AND.B Dn,Dn */
{ CPUFUNC(op_c010_0), 0, 49168 }, /* AND.B (An),Dn */
{ CPUFUNC(op_c018_0), 0, 49176 }, /* AND.B (An)+,Dn */
{ CPUFUNC(op_c020_0), 0, 49184 }, /* AND.B -(An),Dn */
{ CPUFUNC(op_c028_0), 0, 49192 }, /* AND.B (d16,An),Dn */
{ CPUFUNC(op_c030_0), 0, 49200 }, /* AND.B (d8,An,Xn),Dn */
{ CPUFUNC(op_c038_0), 0, 49208 }, /* AND.B (xxx).W,Dn */
{ CPUFUNC(op_c039_0), 0, 49209 }, /* AND.B (xxx).L,Dn */
{ CPUFUNC(op_c03a_0), 0, 49210 }, /* AND.B (d16,PC),Dn */
{ CPUFUNC(op_c03b_0), 0, 49211 }, /* AND.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_c03c_0), 0, 49212 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_c040_0), 0, 49216 }, /* AND.W Dn,Dn */
{ CPUFUNC(op_c050_0), 0, 49232 }, /* AND.W (An),Dn */
{ CPUFUNC(op_c058_0), 0, 49240 }, /* AND.W (An)+,Dn */
{ CPUFUNC(op_c060_0), 0, 49248 }, /* AND.W -(An),Dn */
{ CPUFUNC(op_c068_0), 0, 49256 }, /* AND.W (d16,An),Dn */
{ CPUFUNC(op_c070_0), 0, 49264 }, /* AND.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c078_0), 0, 49272 }, /* AND.W (xxx).W,Dn */
{ CPUFUNC(op_c079_0), 0, 49273 }, /* AND.W (xxx).L,Dn */
{ CPUFUNC(op_c07a_0), 0, 49274 }, /* AND.W (d16,PC),Dn */
{ CPUFUNC(op_c07b_0), 0, 49275 }, /* AND.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c07c_0), 0, 49276 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_c080_0), 0, 49280 }, /* AND.L Dn,Dn */
{ CPUFUNC(op_c090_0), 0, 49296 }, /* AND.L (An),Dn */
{ CPUFUNC(op_c098_0), 0, 49304 }, /* AND.L (An)+,Dn */
{ CPUFUNC(op_c0a0_0), 0, 49312 }, /* AND.L -(An),Dn */
{ CPUFUNC(op_c0a8_0), 0, 49320 }, /* AND.L (d16,An),Dn */
{ CPUFUNC(op_c0b0_0), 0, 49328 }, /* AND.L (d8,An,Xn),Dn */
{ CPUFUNC(op_c0b8_0), 0, 49336 }, /* AND.L (xxx).W,Dn */
{ CPUFUNC(op_c0b9_0), 0, 49337 }, /* AND.L (xxx).L,Dn */
{ CPUFUNC(op_c0ba_0), 0, 49338 }, /* AND.L (d16,PC),Dn */
{ CPUFUNC(op_c0bb_0), 0, 49339 }, /* AND.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0bc_0), 0, 49340 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_c0c0_0), 0, 49344 }, /* MULU.W Dn,Dn */
{ CPUFUNC(op_c0d0_0), 0, 49360 }, /* MULU.W (An),Dn */
{ CPUFUNC(op_c0d8_0), 0, 49368 }, /* MULU.W (An)+,Dn */
{ CPUFUNC(op_c0e0_0), 0, 49376 }, /* MULU.W -(An),Dn */
{ CPUFUNC(op_c0e8_0), 0, 49384 }, /* MULU.W (d16,An),Dn */
{ CPUFUNC(op_c0f0_0), 0, 49392 }, /* MULU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c0f8_0), 0, 49400 }, /* MULU.W (xxx).W,Dn */
{ CPUFUNC(op_c0f9_0), 0, 49401 }, /* MULU.W (xxx).L,Dn */
{ CPUFUNC(op_c0fa_0), 0, 49402 }, /* MULU.W (d16,PC),Dn */
{ CPUFUNC(op_c0fb_0), 0, 49403 }, /* MULU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0fc_0), 0, 49404 }, /* MULU.W #<data>.W,Dn */
{ CPUFUNC(op_c100_1), 0, 49408 }, /* ABCD.B Dn,Dn */
{ CPUFUNC(op_c108_1), 0, 49416 }, /* ABCD.B -(An),-(An) */
{ CPUFUNC(op_c110_0), 0, 49424 }, /* AND.B Dn,(An) */
{ CPUFUNC(op_c118_0), 0, 49432 }, /* AND.B Dn,(An)+ */
{ CPUFUNC(op_c120_0), 0, 49440 }, /* AND.B Dn,-(An) */
{ CPUFUNC(op_c128_0), 0, 49448 }, /* AND.B Dn,(d16,An) */
{ CPUFUNC(op_c130_0), 0, 49456 }, /* AND.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_c138_0), 0, 49464 }, /* AND.B Dn,(xxx).W */
{ CPUFUNC(op_c139_0), 0, 49465 }, /* AND.B Dn,(xxx).L */
{ CPUFUNC_FF(op_c140_0), 0, 49472 }, /* EXG.L Dn,Dn */
{ CPUFUNC_FF(op_c148_0), 0, 49480 }, /* EXG.L An,An */
{ CPUFUNC(op_c150_0), 0, 49488 }, /* AND.W Dn,(An) */
{ CPUFUNC(op_c158_0), 0, 49496 }, /* AND.W Dn,(An)+ */
{ CPUFUNC(op_c160_0), 0, 49504 }, /* AND.W Dn,-(An) */
{ CPUFUNC(op_c168_0), 0, 49512 }, /* AND.W Dn,(d16,An) */
{ CPUFUNC(op_c170_0), 0, 49520 }, /* AND.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_c178_0), 0, 49528 }, /* AND.W Dn,(xxx).W */
{ CPUFUNC(op_c179_0), 0, 49529 }, /* AND.W Dn,(xxx).L */
{ CPUFUNC_FF(op_c188_0), 0, 49544 }, /* EXG.L Dn,An */
{ CPUFUNC(op_c190_0), 0, 49552 }, /* AND.L Dn,(An) */
{ CPUFUNC(op_c198_0), 0, 49560 }, /* AND.L Dn,(An)+ */
{ CPUFUNC(op_c1a0_0), 0, 49568 }, /* AND.L Dn,-(An) */
{ CPUFUNC(op_c1a8_0), 0, 49576 }, /* AND.L Dn,(d16,An) */
{ CPUFUNC(op_c1b0_0), 0, 49584 }, /* AND.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_c1b8_0), 0, 49592 }, /* AND.L Dn,(xxx).W */
{ CPUFUNC(op_c1b9_0), 0, 49593 }, /* AND.L Dn,(xxx).L */
{ CPUFUNC(op_c1c0_0), 0, 49600 }, /* MULS.W Dn,Dn */
{ CPUFUNC(op_c1d0_0), 0, 49616 }, /* MULS.W (An),Dn */
{ CPUFUNC(op_c1d8_0), 0, 49624 }, /* MULS.W (An)+,Dn */
{ CPUFUNC(op_c1e0_0), 0, 49632 }, /* MULS.W -(An),Dn */
{ CPUFUNC(op_c1e8_0), 0, 49640 }, /* MULS.W (d16,An),Dn */
{ CPUFUNC(op_c1f0_0), 0, 49648 }, /* MULS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c1f8_0), 0, 49656 }, /* MULS.W (xxx).W,Dn */
{ CPUFUNC(op_c1f9_0), 0, 49657 }, /* MULS.W (xxx).L,Dn */
{ CPUFUNC(op_c1fa_0), 0, 49658 }, /* MULS.W (d16,PC),Dn */
{ CPUFUNC(op_c1fb_0), 0, 49659 }, /* MULS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c1fc_0), 0, 49660 }, /* MULS.W #<data>.W,Dn */
{ CPUFUNC(op_d000_0), 0, 53248 }, /* ADD.B Dn,Dn */
{ CPUFUNC(op_d010_0), 0, 53264 }, /* ADD.B (An),Dn */
{ CPUFUNC(op_d018_0), 0, 53272 }, /* ADD.B (An)+,Dn */
{ CPUFUNC(op_d020_0), 0, 53280 }, /* ADD.B -(An),Dn */
{ CPUFUNC(op_d028_0), 0, 53288 }, /* ADD.B (d16,An),Dn */
{ CPUFUNC(op_d030_0), 0, 53296 }, /* ADD.B (d8,An,Xn),Dn */
{ CPUFUNC(op_d038_0), 0, 53304 }, /* ADD.B (xxx).W,Dn */
{ CPUFUNC(op_d039_0), 0, 53305 }, /* ADD.B (xxx).L,Dn */
{ CPUFUNC(op_d03a_0), 0, 53306 }, /* ADD.B (d16,PC),Dn */
{ CPUFUNC(op_d03b_0), 0, 53307 }, /* ADD.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_d03c_0), 0, 53308 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_d040_0), 0, 53312 }, /* ADD.W Dn,Dn */
{ CPUFUNC(op_d048_0), 0, 53320 }, /* ADD.W An,Dn */
{ CPUFUNC(op_d050_0), 0, 53328 }, /* ADD.W (An),Dn */
{ CPUFUNC(op_d058_0), 0, 53336 }, /* ADD.W (An)+,Dn */
{ CPUFUNC(op_d060_0), 0, 53344 }, /* ADD.W -(An),Dn */
{ CPUFUNC(op_d068_0), 0, 53352 }, /* ADD.W (d16,An),Dn */
{ CPUFUNC(op_d070_0), 0, 53360 }, /* ADD.W (d8,An,Xn),Dn */
{ CPUFUNC(op_d078_0), 0, 53368 }, /* ADD.W (xxx).W,Dn */
{ CPUFUNC(op_d079_0), 0, 53369 }, /* ADD.W (xxx).L,Dn */
{ CPUFUNC(op_d07a_0), 0, 53370 }, /* ADD.W (d16,PC),Dn */
{ CPUFUNC(op_d07b_0), 0, 53371 }, /* ADD.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_d07c_0), 0, 53372 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_d080_0), 0, 53376 }, /* ADD.L Dn,Dn */
{ CPUFUNC(op_d088_0), 0, 53384 }, /* ADD.L An,Dn */
{ CPUFUNC(op_d090_0), 0, 53392 }, /* ADD.L (An),Dn */
{ CPUFUNC(op_d098_0), 0, 53400 }, /* ADD.L (An)+,Dn */
{ CPUFUNC(op_d0a0_0), 0, 53408 }, /* ADD.L -(An),Dn */
{ CPUFUNC(op_d0a8_0), 0, 53416 }, /* ADD.L (d16,An),Dn */
{ CPUFUNC(op_d0b0_0), 0, 53424 }, /* ADD.L (d8,An,Xn),Dn */
{ CPUFUNC(op_d0b8_0), 0, 53432 }, /* ADD.L (xxx).W,Dn */
{ CPUFUNC(op_d0b9_0), 0, 53433 }, /* ADD.L (xxx).L,Dn */
{ CPUFUNC(op_d0ba_0), 0, 53434 }, /* ADD.L (d16,PC),Dn */
{ CPUFUNC(op_d0bb_0), 0, 53435 }, /* ADD.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_d0bc_0), 0, 53436 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC_FF(op_d0c0_0), 0, 53440 }, /* ADDA.W Dn,An */
{ CPUFUNC_FF(op_d0c8_0), 0, 53448 }, /* ADDA.W An,An */
{ CPUFUNC_FF(op_d0d0_0), 0, 53456 }, /* ADDA.W (An),An */
{ CPUFUNC_FF(op_d0d8_0), 0, 53464 }, /* ADDA.W (An)+,An */
{ CPUFUNC_FF(op_d0e0_0), 0, 53472 }, /* ADDA.W -(An),An */
{ CPUFUNC_FF(op_d0e8_0), 0, 53480 }, /* ADDA.W (d16,An),An */
{ CPUFUNC_FF(op_d0f0_0), 0, 53488 }, /* ADDA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_d0f8_0), 0, 53496 }, /* ADDA.W (xxx).W,An */
{ CPUFUNC_FF(op_d0f9_0), 0, 53497 }, /* ADDA.W (xxx).L,An */
{ CPUFUNC_FF(op_d0fa_0), 0, 53498 }, /* ADDA.W (d16,PC),An */
{ CPUFUNC_FF(op_d0fb_0), 0, 53499 }, /* ADDA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d0fc_0), 0, 53500 }, /* ADDA.W #<data>.W,An */
{ CPUFUNC(op_d100_0), 0, 53504 }, /* ADDX.B Dn,Dn */
{ CPUFUNC(op_d108_0), 0, 53512 }, /* ADDX.B -(An),-(An) */
{ CPUFUNC(op_d110_0), 0, 53520 }, /* ADD.B Dn,(An) */
{ CPUFUNC(op_d118_0), 0, 53528 }, /* ADD.B Dn,(An)+ */
{ CPUFUNC(op_d120_0), 0, 53536 }, /* ADD.B Dn,-(An) */
{ CPUFUNC(op_d128_0), 0, 53544 }, /* ADD.B Dn,(d16,An) */
{ CPUFUNC(op_d130_0), 0, 53552 }, /* ADD.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_d138_0), 0, 53560 }, /* ADD.B Dn,(xxx).W */
{ CPUFUNC(op_d139_0), 0, 53561 }, /* ADD.B Dn,(xxx).L */
{ CPUFUNC(op_d140_0), 0, 53568 }, /* ADDX.W Dn,Dn */
{ CPUFUNC(op_d148_0), 0, 53576 }, /* ADDX.W -(An),-(An) */
{ CPUFUNC(op_d150_0), 0, 53584 }, /* ADD.W Dn,(An) */
{ CPUFUNC(op_d158_0), 0, 53592 }, /* ADD.W Dn,(An)+ */
{ CPUFUNC(op_d160_0), 0, 53600 }, /* ADD.W Dn,-(An) */
{ CPUFUNC(op_d168_0), 0, 53608 }, /* ADD.W Dn,(d16,An) */
{ CPUFUNC(op_d170_0), 0, 53616 }, /* ADD.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_d178_0), 0, 53624 }, /* ADD.W Dn,(xxx).W */
{ CPUFUNC(op_d179_0), 0, 53625 }, /* ADD.W Dn,(xxx).L */
{ CPUFUNC(op_d180_0), 0, 53632 }, /* ADDX.L Dn,Dn */
{ CPUFUNC(op_d188_0), 0, 53640 }, /* ADDX.L -(An),-(An) */
{ CPUFUNC(op_d190_0), 0, 53648 }, /* ADD.L Dn,(An) */
{ CPUFUNC(op_d198_0), 0, 53656 }, /* ADD.L Dn,(An)+ */
{ CPUFUNC(op_d1a0_0), 0, 53664 }, /* ADD.L Dn,-(An) */
{ CPUFUNC(op_d1a8_0), 0, 53672 }, /* ADD.L Dn,(d16,An) */
{ CPUFUNC(op_d1b0_0), 0, 53680 }, /* ADD.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_d1b8_0), 0, 53688 }, /* ADD.L Dn,(xxx).W */
{ CPUFUNC(op_d1b9_0), 0, 53689 }, /* ADD.L Dn,(xxx).L */
{ CPUFUNC_FF(op_d1c0_0), 0, 53696 }, /* ADDA.L Dn,An */
{ CPUFUNC_FF(op_d1c8_0), 0, 53704 }, /* ADDA.L An,An */
{ CPUFUNC_FF(op_d1d0_0), 0, 53712 }, /* ADDA.L (An),An */
{ CPUFUNC_FF(op_d1d8_0), 0, 53720 }, /* ADDA.L (An)+,An */
{ CPUFUNC_FF(op_d1e0_0), 0, 53728 }, /* ADDA.L -(An),An */
{ CPUFUNC_FF(op_d1e8_0), 0, 53736 }, /* ADDA.L (d16,An),An */
{ CPUFUNC_FF(op_d1f0_0), 0, 53744 }, /* ADDA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_d1f8_0), 0, 53752 }, /* ADDA.L (xxx).W,An */
{ CPUFUNC_FF(op_d1f9_0), 0, 53753 }, /* ADDA.L (xxx).L,An */
{ CPUFUNC_FF(op_d1fa_0), 0, 53754 }, /* ADDA.L (d16,PC),An */
{ CPUFUNC_FF(op_d1fb_0), 0, 53755 }, /* ADDA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d1fc_0), 0, 53756 }, /* ADDA.L #<data>.L,An */
{ CPUFUNC(op_e000_0), 0, 57344 }, /* ASR.B #<data>,Dn */
{ CPUFUNC(op_e008_0), 0, 57352 }, /* LSR.B #<data>,Dn */
{ CPUFUNC(op_e010_0), 0, 57360 }, /* ROXR.B #<data>,Dn */
{ CPUFUNC(op_e018_0), 0, 57368 }, /* ROR.B #<data>,Dn */
{ CPUFUNC(op_e020_0), 0, 57376 }, /* ASR.B Dn,Dn */
{ CPUFUNC(op_e028_0), 0, 57384 }, /* LSR.B Dn,Dn */
{ CPUFUNC(op_e030_0), 0, 57392 }, /* ROXR.B Dn,Dn */
{ CPUFUNC(op_e038_0), 0, 57400 }, /* ROR.B Dn,Dn */
{ CPUFUNC(op_e040_0), 0, 57408 }, /* ASR.W #<data>,Dn */
{ CPUFUNC(op_e048_0), 0, 57416 }, /* LSR.W #<data>,Dn */
{ CPUFUNC(op_e050_0), 0, 57424 }, /* ROXR.W #<data>,Dn */
{ CPUFUNC(op_e058_0), 0, 57432 }, /* ROR.W #<data>,Dn */
{ CPUFUNC(op_e060_0), 0, 57440 }, /* ASR.W Dn,Dn */
{ CPUFUNC(op_e068_0), 0, 57448 }, /* LSR.W Dn,Dn */
{ CPUFUNC(op_e070_0), 0, 57456 }, /* ROXR.W Dn,Dn */
{ CPUFUNC(op_e078_0), 0, 57464 }, /* ROR.W Dn,Dn */
{ CPUFUNC(op_e080_0), 0, 57472 }, /* ASR.L #<data>,Dn */
{ CPUFUNC(op_e088_0), 0, 57480 }, /* LSR.L #<data>,Dn */
{ CPUFUNC(op_e090_0), 0, 57488 }, /* ROXR.L #<data>,Dn */
{ CPUFUNC(op_e098_0), 0, 57496 }, /* ROR.L #<data>,Dn */
{ CPUFUNC(op_e0a0_0), 0, 57504 }, /* ASR.L Dn,Dn */
{ CPUFUNC(op_e0a8_0), 0, 57512 }, /* LSR.L Dn,Dn */
{ CPUFUNC(op_e0b0_0), 0, 57520 }, /* ROXR.L Dn,Dn */
{ CPUFUNC(op_e0b8_0), 0, 57528 }, /* ROR.L Dn,Dn */
{ CPUFUNC(op_e0d0_0), 0, 57552 }, /* ASRW.W (An) */
{ CPUFUNC(op_e0d8_0), 0, 57560 }, /* ASRW.W (An)+ */
{ CPUFUNC(op_e0e0_0), 0, 57568 }, /* ASRW.W -(An) */
{ CPUFUNC(op_e0e8_0), 0, 57576 }, /* ASRW.W (d16,An) */
{ CPUFUNC(op_e0f0_0), 0, 57584 }, /* ASRW.W (d8,An,Xn) */
{ CPUFUNC(op_e0f8_0), 0, 57592 }, /* ASRW.W (xxx).W */
{ CPUFUNC(op_e0f9_0), 0, 57593 }, /* ASRW.W (xxx).L */
{ CPUFUNC(op_e100_0), 0, 57600 }, /* ASL.B #<data>,Dn */
{ CPUFUNC(op_e108_0), 0, 57608 }, /* LSL.B #<data>,Dn */
{ CPUFUNC(op_e110_0), 0, 57616 }, /* ROXL.B #<data>,Dn */
{ CPUFUNC(op_e118_0), 0, 57624 }, /* ROL.B #<data>,Dn */
{ CPUFUNC(op_e120_0), 0, 57632 }, /* ASL.B Dn,Dn */
{ CPUFUNC(op_e128_0), 0, 57640 }, /* LSL.B Dn,Dn */
{ CPUFUNC(op_e130_0), 0, 57648 }, /* ROXL.B Dn,Dn */
{ CPUFUNC(op_e138_0), 0, 57656 }, /* ROL.B Dn,Dn */
{ CPUFUNC(op_e140_0), 0, 57664 }, /* ASL.W #<data>,Dn */
{ CPUFUNC(op_e148_0), 0, 57672 }, /* LSL.W #<data>,Dn */
{ CPUFUNC(op_e150_0), 0, 57680 }, /* ROXL.W #<data>,Dn */
{ CPUFUNC(op_e158_0), 0, 57688 }, /* ROL.W #<data>,Dn */
{ CPUFUNC(op_e160_0), 0, 57696 }, /* ASL.W Dn,Dn */
{ CPUFUNC(op_e168_0), 0, 57704 }, /* LSL.W Dn,Dn */
{ CPUFUNC(op_e170_0), 0, 57712 }, /* ROXL.W Dn,Dn */
{ CPUFUNC(op_e178_0), 0, 57720 }, /* ROL.W Dn,Dn */
{ CPUFUNC(op_e180_0), 0, 57728 }, /* ASL.L #<data>,Dn */
{ CPUFUNC(op_e188_0), 0, 57736 }, /* LSL.L #<data>,Dn */
{ CPUFUNC(op_e190_0), 0, 57744 }, /* ROXL.L #<data>,Dn */
{ CPUFUNC(op_e198_0), 0, 57752 }, /* ROL.L #<data>,Dn */
{ CPUFUNC(op_e1a0_0), 0, 57760 }, /* ASL.L Dn,Dn */
{ CPUFUNC(op_e1a8_0), 0, 57768 }, /* LSL.L Dn,Dn */
{ CPUFUNC(op_e1b0_0), 0, 57776 }, /* ROXL.L Dn,Dn */
{ CPUFUNC(op_e1b8_0), 0, 57784 }, /* ROL.L Dn,Dn */
{ CPUFUNC(op_e1d0_0), 0, 57808 }, /* ASLW.W (An) */
{ CPUFUNC(op_e1d8_0), 0, 57816 }, /* ASLW.W (An)+ */
{ CPUFUNC(op_e1e0_0), 0, 57824 }, /* ASLW.W -(An) */
{ CPUFUNC(op_e1e8_0), 0, 57832 }, /* ASLW.W (d16,An) */
{ CPUFUNC(op_e1f0_0), 0, 57840 }, /* ASLW.W (d8,An,Xn) */
{ CPUFUNC(op_e1f8_0), 0, 57848 }, /* ASLW.W (xxx).W */
{ CPUFUNC(op_e1f9_0), 0, 57849 }, /* ASLW.W (xxx).L */
{ CPUFUNC(op_e2d0_0), 0, 58064 }, /* LSRW.W (An) */
{ CPUFUNC(op_e2d8_0), 0, 58072 }, /* LSRW.W (An)+ */
{ CPUFUNC(op_e2e0_0), 0, 58080 }, /* LSRW.W -(An) */
{ CPUFUNC(op_e2e8_0), 0, 58088 }, /* LSRW.W (d16,An) */
{ CPUFUNC(op_e2f0_0), 0, 58096 }, /* LSRW.W (d8,An,Xn) */
{ CPUFUNC(op_e2f8_0), 0, 58104 }, /* LSRW.W (xxx).W */
{ CPUFUNC(op_e2f9_0), 0, 58105 }, /* LSRW.W (xxx).L */
{ CPUFUNC(op_e3d0_0), 0, 58320 }, /* LSLW.W (An) */
{ CPUFUNC(op_e3d8_0), 0, 58328 }, /* LSLW.W (An)+ */
{ CPUFUNC(op_e3e0_0), 0, 58336 }, /* LSLW.W -(An) */
{ CPUFUNC(op_e3e8_0), 0, 58344 }, /* LSLW.W (d16,An) */
{ CPUFUNC(op_e3f0_0), 0, 58352 }, /* LSLW.W (d8,An,Xn) */
{ CPUFUNC(op_e3f8_0), 0, 58360 }, /* LSLW.W (xxx).W */
{ CPUFUNC(op_e3f9_0), 0, 58361 }, /* LSLW.W (xxx).L */
{ CPUFUNC(op_e4d0_0), 0, 58576 }, /* ROXRW.W (An) */
{ CPUFUNC(op_e4d8_0), 0, 58584 }, /* ROXRW.W (An)+ */
{ CPUFUNC(op_e4e0_0), 0, 58592 }, /* ROXRW.W -(An) */
{ CPUFUNC(op_e4e8_0), 0, 58600 }, /* ROXRW.W (d16,An) */
{ CPUFUNC(op_e4f0_0), 0, 58608 }, /* ROXRW.W (d8,An,Xn) */
{ CPUFUNC(op_e4f8_0), 0, 58616 }, /* ROXRW.W (xxx).W */
{ CPUFUNC(op_e4f9_0), 0, 58617 }, /* ROXRW.W (xxx).L */
{ CPUFUNC(op_e5d0_0), 0, 58832 }, /* ROXLW.W (An) */
{ CPUFUNC(op_e5d8_0), 0, 58840 }, /* ROXLW.W (An)+ */
{ CPUFUNC(op_e5e0_0), 0, 58848 }, /* ROXLW.W -(An) */
{ CPUFUNC(op_e5e8_0), 0, 58856 }, /* ROXLW.W (d16,An) */
{ CPUFUNC(op_e5f0_0), 0, 58864 }, /* ROXLW.W (d8,An,Xn) */
{ CPUFUNC(op_e5f8_0), 0, 58872 }, /* ROXLW.W (xxx).W */
{ CPUFUNC(op_e5f9_0), 0, 58873 }, /* ROXLW.W (xxx).L */
{ CPUFUNC(op_e6d0_0), 0, 59088 }, /* RORW.W (An) */
{ CPUFUNC(op_e6d8_0), 0, 59096 }, /* RORW.W (An)+ */
{ CPUFUNC(op_e6e0_0), 0, 59104 }, /* RORW.W -(An) */
{ CPUFUNC(op_e6e8_0), 0, 59112 }, /* RORW.W (d16,An) */
{ CPUFUNC(op_e6f0_0), 0, 59120 }, /* RORW.W (d8,An,Xn) */
{ CPUFUNC(op_e6f8_0), 0, 59128 }, /* RORW.W (xxx).W */
{ CPUFUNC(op_e6f9_0), 0, 59129 }, /* RORW.W (xxx).L */
{ CPUFUNC(op_e7d0_0), 0, 59344 }, /* ROLW.W (An) */
{ CPUFUNC(op_e7d8_0), 0, 59352 }, /* ROLW.W (An)+ */
{ CPUFUNC(op_e7e0_0), 0, 59360 }, /* ROLW.W -(An) */
{ CPUFUNC(op_e7e8_0), 0, 59368 }, /* ROLW.W (d16,An) */
{ CPUFUNC(op_e7f0_0), 0, 59376 }, /* ROLW.W (d8,An,Xn) */
{ CPUFUNC(op_e7f8_0), 0, 59384 }, /* ROLW.W (xxx).W */
{ CPUFUNC(op_e7f9_0), 0, 59385 }, /* ROLW.W (xxx).L */
{ CPUFUNC(op_e8c0_0), 0, 59584 }, /* BFTST.L #<data>.W,Dn */
{ CPUFUNC(op_e8d0_0), 0, 59600 }, /* BFTST.L #<data>.W,(An) */
{ CPUFUNC(op_e8e8_0), 0, 59624 }, /* BFTST.L #<data>.W,(d16,An) */
{ CPUFUNC(op_e8f0_0), 0, 59632 }, /* BFTST.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_e8f8_0), 0, 59640 }, /* BFTST.L #<data>.W,(xxx).W */
{ CPUFUNC(op_e8f9_0), 0, 59641 }, /* BFTST.L #<data>.W,(xxx).L */
{ CPUFUNC(op_e8fa_0), 0, 59642 }, /* BFTST.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_e8fb_0), 0, 59643 }, /* BFTST.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_e9c0_0), 0, 59840 }, /* BFEXTU.L #<data>.W,Dn */
{ CPUFUNC(op_e9d0_0), 0, 59856 }, /* BFEXTU.L #<data>.W,(An) */
{ CPUFUNC(op_e9e8_0), 0, 59880 }, /* BFEXTU.L #<data>.W,(d16,An) */
{ CPUFUNC(op_e9f0_0), 0, 59888 }, /* BFEXTU.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_e9f8_0), 0, 59896 }, /* BFEXTU.L #<data>.W,(xxx).W */
{ CPUFUNC(op_e9f9_0), 0, 59897 }, /* BFEXTU.L #<data>.W,(xxx).L */
{ CPUFUNC(op_e9fa_0), 0, 59898 }, /* BFEXTU.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_e9fb_0), 0, 59899 }, /* BFEXTU.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_eac0_0), 0, 60096 }, /* BFCHG.L #<data>.W,Dn */
{ CPUFUNC(op_ead0_0), 0, 60112 }, /* BFCHG.L #<data>.W,(An) */
{ CPUFUNC(op_eae8_0), 0, 60136 }, /* BFCHG.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eaf0_0), 0, 60144 }, /* BFCHG.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eaf8_0), 0, 60152 }, /* BFCHG.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eaf9_0), 0, 60153 }, /* BFCHG.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ebc0_0), 0, 60352 }, /* BFEXTS.L #<data>.W,Dn */
{ CPUFUNC(op_ebd0_0), 0, 60368 }, /* BFEXTS.L #<data>.W,(An) */
{ CPUFUNC(op_ebe8_0), 0, 60392 }, /* BFEXTS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ebf0_0), 0, 60400 }, /* BFEXTS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ebf8_0), 0, 60408 }, /* BFEXTS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ebf9_0), 0, 60409 }, /* BFEXTS.L #<data>.W,(xxx).L */
{ CPUFUNC(op_ebfa_0), 0, 60410 }, /* BFEXTS.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_ebfb_0), 0, 60411 }, /* BFEXTS.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_ecc0_0), 0, 60608 }, /* BFCLR.L #<data>.W,Dn */
{ CPUFUNC(op_ecd0_0), 0, 60624 }, /* BFCLR.L #<data>.W,(An) */
{ CPUFUNC(op_ece8_0), 0, 60648 }, /* BFCLR.L #<data>.W,(d16,An) */
{ CPUFUNC(op_ecf0_0), 0, 60656 }, /* BFCLR.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_ecf8_0), 0, 60664 }, /* BFCLR.L #<data>.W,(xxx).W */
{ CPUFUNC(op_ecf9_0), 0, 60665 }, /* BFCLR.L #<data>.W,(xxx).L */
{ CPUFUNC(op_edc0_0), 0, 60864 }, /* BFFFO.L #<data>.W,Dn */
{ CPUFUNC(op_edd0_0), 0, 60880 }, /* BFFFO.L #<data>.W,(An) */
{ CPUFUNC(op_ede8_0), 0, 60904 }, /* BFFFO.L #<data>.W,(d16,An) */
{ CPUFUNC(op_edf0_0), 0, 60912 }, /* BFFFO.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_edf8_0), 0, 60920 }, /* BFFFO.L #<data>.W,(xxx).W */
{ CPUFUNC(op_edf9_0), 0, 60921 }, /* BFFFO.L #<data>.W,(xxx).L */
{ CPUFUNC(op_edfa_0), 0, 60922 }, /* BFFFO.L #<data>.W,(d16,PC) */
{ CPUFUNC(op_edfb_0), 0, 60923 }, /* BFFFO.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_eec0_0), 0, 61120 }, /* BFSET.L #<data>.W,Dn */
{ CPUFUNC(op_eed0_0), 0, 61136 }, /* BFSET.L #<data>.W,(An) */
{ CPUFUNC(op_eee8_0), 0, 61160 }, /* BFSET.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eef0_0), 0, 61168 }, /* BFSET.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eef8_0), 0, 61176 }, /* BFSET.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eef9_0), 0, 61177 }, /* BFSET.L #<data>.W,(xxx).L */
{ CPUFUNC(op_efc0_0), 0, 61376 }, /* BFINS.L #<data>.W,Dn */
{ CPUFUNC(op_efd0_0), 0, 61392 }, /* BFINS.L #<data>.W,(An) */
{ CPUFUNC(op_efe8_0), 0, 61416 }, /* BFINS.L #<data>.W,(d16,An) */
{ CPUFUNC(op_eff0_0), 0, 61424 }, /* BFINS.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_eff8_0), 0, 61432 }, /* BFINS.L #<data>.W,(xxx).W */
{ CPUFUNC(op_eff9_0), 0, 61433 }, /* BFINS.L #<data>.W,(xxx).L */
{ 0, 0, 0 }};
struct cputbl CPUFUNC(op_smalltbl_3)[] = {
{ CPUFUNC(op_0_0), 0, 0 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_10_0), 0, 16 }, /* OR.B #<data>.B,(An) */
{ CPUFUNC(op_18_0), 0, 24 }, /* OR.B #<data>.B,(An)+ */
{ CPUFUNC(op_20_0), 0, 32 }, /* OR.B #<data>.B,-(An) */
{ CPUFUNC(op_28_0), 0, 40 }, /* OR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_30_3), 0, 48 }, /* OR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_38_0), 0, 56 }, /* OR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_39_0), 0, 57 }, /* OR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_3c_0), 0, 60 }, /* ORSR.B #<data>.W */
{ CPUFUNC(op_40_0), 0, 64 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_50_0), 0, 80 }, /* OR.W #<data>.W,(An) */
{ CPUFUNC(op_58_0), 0, 88 }, /* OR.W #<data>.W,(An)+ */
{ CPUFUNC(op_60_0), 0, 96 }, /* OR.W #<data>.W,-(An) */
{ CPUFUNC(op_68_0), 0, 104 }, /* OR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_70_3), 0, 112 }, /* OR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_78_0), 0, 120 }, /* OR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_79_0), 0, 121 }, /* OR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_7c_0), 0, 124 }, /* ORSR.W #<data>.W */
{ CPUFUNC(op_80_0), 0, 128 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_90_0), 0, 144 }, /* OR.L #<data>.L,(An) */
{ CPUFUNC(op_98_0), 0, 152 }, /* OR.L #<data>.L,(An)+ */
{ CPUFUNC(op_a0_0), 0, 160 }, /* OR.L #<data>.L,-(An) */
{ CPUFUNC(op_a8_0), 0, 168 }, /* OR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_b0_3), 0, 176 }, /* OR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_b8_0), 0, 184 }, /* OR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_b9_0), 0, 185 }, /* OR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_100_0), 0, 256 }, /* BTST.L Dn,Dn */
{ CPUFUNC_FF(op_108_0), 0, 264 }, /* MVPMR.W (d16,An),Dn */
{ CPUFUNC(op_110_0), 0, 272 }, /* BTST.B Dn,(An) */
{ CPUFUNC(op_118_0), 0, 280 }, /* BTST.B Dn,(An)+ */
{ CPUFUNC(op_120_0), 0, 288 }, /* BTST.B Dn,-(An) */
{ CPUFUNC(op_128_0), 0, 296 }, /* BTST.B Dn,(d16,An) */
{ CPUFUNC(op_130_3), 0, 304 }, /* BTST.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_138_0), 0, 312 }, /* BTST.B Dn,(xxx).W */
{ CPUFUNC(op_139_0), 0, 313 }, /* BTST.B Dn,(xxx).L */
{ CPUFUNC(op_13a_0), 0, 314 }, /* BTST.B Dn,(d16,PC) */
{ CPUFUNC(op_13b_3), 0, 315 }, /* BTST.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_13c_0), 0, 316 }, /* BTST.B Dn,#<data>.B */
{ CPUFUNC(op_140_0), 0, 320 }, /* BCHG.L Dn,Dn */
{ CPUFUNC_FF(op_148_0), 0, 328 }, /* MVPMR.L (d16,An),Dn */
{ CPUFUNC(op_150_0), 0, 336 }, /* BCHG.B Dn,(An) */
{ CPUFUNC(op_158_0), 0, 344 }, /* BCHG.B Dn,(An)+ */
{ CPUFUNC(op_160_0), 0, 352 }, /* BCHG.B Dn,-(An) */
{ CPUFUNC(op_168_0), 0, 360 }, /* BCHG.B Dn,(d16,An) */
{ CPUFUNC(op_170_3), 0, 368 }, /* BCHG.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_178_0), 0, 376 }, /* BCHG.B Dn,(xxx).W */
{ CPUFUNC(op_179_0), 0, 377 }, /* BCHG.B Dn,(xxx).L */
{ CPUFUNC(op_17a_0), 0, 378 }, /* BCHG.B Dn,(d16,PC) */
{ CPUFUNC(op_17b_3), 0, 379 }, /* BCHG.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_180_0), 0, 384 }, /* BCLR.L Dn,Dn */
{ CPUFUNC_FF(op_188_0), 0, 392 }, /* MVPRM.W Dn,(d16,An) */
{ CPUFUNC(op_190_0), 0, 400 }, /* BCLR.B Dn,(An) */
{ CPUFUNC(op_198_0), 0, 408 }, /* BCLR.B Dn,(An)+ */
{ CPUFUNC(op_1a0_0), 0, 416 }, /* BCLR.B Dn,-(An) */
{ CPUFUNC(op_1a8_0), 0, 424 }, /* BCLR.B Dn,(d16,An) */
{ CPUFUNC(op_1b0_3), 0, 432 }, /* BCLR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1b8_0), 0, 440 }, /* BCLR.B Dn,(xxx).W */
{ CPUFUNC(op_1b9_0), 0, 441 }, /* BCLR.B Dn,(xxx).L */
{ CPUFUNC(op_1ba_0), 0, 442 }, /* BCLR.B Dn,(d16,PC) */
{ CPUFUNC(op_1bb_3), 0, 443 }, /* BCLR.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_1c0_0), 0, 448 }, /* BSET.L Dn,Dn */
{ CPUFUNC_FF(op_1c8_0), 0, 456 }, /* MVPRM.L Dn,(d16,An) */
{ CPUFUNC(op_1d0_0), 0, 464 }, /* BSET.B Dn,(An) */
{ CPUFUNC(op_1d8_0), 0, 472 }, /* BSET.B Dn,(An)+ */
{ CPUFUNC(op_1e0_0), 0, 480 }, /* BSET.B Dn,-(An) */
{ CPUFUNC(op_1e8_0), 0, 488 }, /* BSET.B Dn,(d16,An) */
{ CPUFUNC(op_1f0_3), 0, 496 }, /* BSET.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1f8_0), 0, 504 }, /* BSET.B Dn,(xxx).W */
{ CPUFUNC(op_1f9_0), 0, 505 }, /* BSET.B Dn,(xxx).L */
{ CPUFUNC(op_1fa_0), 0, 506 }, /* BSET.B Dn,(d16,PC) */
{ CPUFUNC(op_1fb_3), 0, 507 }, /* BSET.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_200_0), 0, 512 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_210_0), 0, 528 }, /* AND.B #<data>.B,(An) */
{ CPUFUNC(op_218_0), 0, 536 }, /* AND.B #<data>.B,(An)+ */
{ CPUFUNC(op_220_0), 0, 544 }, /* AND.B #<data>.B,-(An) */
{ CPUFUNC(op_228_0), 0, 552 }, /* AND.B #<data>.B,(d16,An) */
{ CPUFUNC(op_230_3), 0, 560 }, /* AND.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_238_0), 0, 568 }, /* AND.B #<data>.B,(xxx).W */
{ CPUFUNC(op_239_0), 0, 569 }, /* AND.B #<data>.B,(xxx).L */
{ CPUFUNC(op_23c_0), 0, 572 }, /* ANDSR.B #<data>.W */
{ CPUFUNC(op_240_0), 0, 576 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_250_0), 0, 592 }, /* AND.W #<data>.W,(An) */
{ CPUFUNC(op_258_0), 0, 600 }, /* AND.W #<data>.W,(An)+ */
{ CPUFUNC(op_260_0), 0, 608 }, /* AND.W #<data>.W,-(An) */
{ CPUFUNC(op_268_0), 0, 616 }, /* AND.W #<data>.W,(d16,An) */
{ CPUFUNC(op_270_3), 0, 624 }, /* AND.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_278_0), 0, 632 }, /* AND.W #<data>.W,(xxx).W */
{ CPUFUNC(op_279_0), 0, 633 }, /* AND.W #<data>.W,(xxx).L */
{ CPUFUNC(op_27c_0), 0, 636 }, /* ANDSR.W #<data>.W */
{ CPUFUNC(op_280_0), 0, 640 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_290_0), 0, 656 }, /* AND.L #<data>.L,(An) */
{ CPUFUNC(op_298_0), 0, 664 }, /* AND.L #<data>.L,(An)+ */
{ CPUFUNC(op_2a0_0), 0, 672 }, /* AND.L #<data>.L,-(An) */
{ CPUFUNC(op_2a8_0), 0, 680 }, /* AND.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2b0_3), 0, 688 }, /* AND.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_2b8_0), 0, 696 }, /* AND.L #<data>.L,(xxx).W */
{ CPUFUNC(op_2b9_0), 0, 697 }, /* AND.L #<data>.L,(xxx).L */
{ CPUFUNC(op_400_0), 0, 1024 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_410_0), 0, 1040 }, /* SUB.B #<data>.B,(An) */
{ CPUFUNC(op_418_0), 0, 1048 }, /* SUB.B #<data>.B,(An)+ */
{ CPUFUNC(op_420_0), 0, 1056 }, /* SUB.B #<data>.B,-(An) */
{ CPUFUNC(op_428_0), 0, 1064 }, /* SUB.B #<data>.B,(d16,An) */
{ CPUFUNC(op_430_3), 0, 1072 }, /* SUB.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_438_0), 0, 1080 }, /* SUB.B #<data>.B,(xxx).W */
{ CPUFUNC(op_439_0), 0, 1081 }, /* SUB.B #<data>.B,(xxx).L */
{ CPUFUNC(op_440_0), 0, 1088 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_450_0), 0, 1104 }, /* SUB.W #<data>.W,(An) */
{ CPUFUNC(op_458_0), 0, 1112 }, /* SUB.W #<data>.W,(An)+ */
{ CPUFUNC(op_460_0), 0, 1120 }, /* SUB.W #<data>.W,-(An) */
{ CPUFUNC(op_468_0), 0, 1128 }, /* SUB.W #<data>.W,(d16,An) */
{ CPUFUNC(op_470_3), 0, 1136 }, /* SUB.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_478_0), 0, 1144 }, /* SUB.W #<data>.W,(xxx).W */
{ CPUFUNC(op_479_0), 0, 1145 }, /* SUB.W #<data>.W,(xxx).L */
{ CPUFUNC(op_480_0), 0, 1152 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC(op_490_0), 0, 1168 }, /* SUB.L #<data>.L,(An) */
{ CPUFUNC(op_498_0), 0, 1176 }, /* SUB.L #<data>.L,(An)+ */
{ CPUFUNC(op_4a0_0), 0, 1184 }, /* SUB.L #<data>.L,-(An) */
{ CPUFUNC(op_4a8_0), 0, 1192 }, /* SUB.L #<data>.L,(d16,An) */
{ CPUFUNC(op_4b0_3), 0, 1200 }, /* SUB.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_4b8_0), 0, 1208 }, /* SUB.L #<data>.L,(xxx).W */
{ CPUFUNC(op_4b9_0), 0, 1209 }, /* SUB.L #<data>.L,(xxx).L */
{ CPUFUNC(op_600_0), 0, 1536 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_610_0), 0, 1552 }, /* ADD.B #<data>.B,(An) */
{ CPUFUNC(op_618_0), 0, 1560 }, /* ADD.B #<data>.B,(An)+ */
{ CPUFUNC(op_620_0), 0, 1568 }, /* ADD.B #<data>.B,-(An) */
{ CPUFUNC(op_628_0), 0, 1576 }, /* ADD.B #<data>.B,(d16,An) */
{ CPUFUNC(op_630_3), 0, 1584 }, /* ADD.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_638_0), 0, 1592 }, /* ADD.B #<data>.B,(xxx).W */
{ CPUFUNC(op_639_0), 0, 1593 }, /* ADD.B #<data>.B,(xxx).L */
{ CPUFUNC(op_640_0), 0, 1600 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_650_0), 0, 1616 }, /* ADD.W #<data>.W,(An) */
{ CPUFUNC(op_658_0), 0, 1624 }, /* ADD.W #<data>.W,(An)+ */
{ CPUFUNC(op_660_0), 0, 1632 }, /* ADD.W #<data>.W,-(An) */
{ CPUFUNC(op_668_0), 0, 1640 }, /* ADD.W #<data>.W,(d16,An) */
{ CPUFUNC(op_670_3), 0, 1648 }, /* ADD.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_678_0), 0, 1656 }, /* ADD.W #<data>.W,(xxx).W */
{ CPUFUNC(op_679_0), 0, 1657 }, /* ADD.W #<data>.W,(xxx).L */
{ CPUFUNC(op_680_0), 0, 1664 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC(op_690_0), 0, 1680 }, /* ADD.L #<data>.L,(An) */
{ CPUFUNC(op_698_0), 0, 1688 }, /* ADD.L #<data>.L,(An)+ */
{ CPUFUNC(op_6a0_0), 0, 1696 }, /* ADD.L #<data>.L,-(An) */
{ CPUFUNC(op_6a8_0), 0, 1704 }, /* ADD.L #<data>.L,(d16,An) */
{ CPUFUNC(op_6b0_3), 0, 1712 }, /* ADD.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_6b8_0), 0, 1720 }, /* ADD.L #<data>.L,(xxx).W */
{ CPUFUNC(op_6b9_0), 0, 1721 }, /* ADD.L #<data>.L,(xxx).L */
{ CPUFUNC(op_800_0), 0, 2048 }, /* BTST.L #<data>.W,Dn */
{ CPUFUNC(op_810_0), 0, 2064 }, /* BTST.B #<data>.W,(An) */
{ CPUFUNC(op_818_0), 0, 2072 }, /* BTST.B #<data>.W,(An)+ */
{ CPUFUNC(op_820_0), 0, 2080 }, /* BTST.B #<data>.W,-(An) */
{ CPUFUNC(op_828_0), 0, 2088 }, /* BTST.B #<data>.W,(d16,An) */
{ CPUFUNC(op_830_3), 0, 2096 }, /* BTST.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_838_0), 0, 2104 }, /* BTST.B #<data>.W,(xxx).W */
{ CPUFUNC(op_839_0), 0, 2105 }, /* BTST.B #<data>.W,(xxx).L */
{ CPUFUNC(op_83a_0), 0, 2106 }, /* BTST.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_83b_3), 0, 2107 }, /* BTST.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_83c_0), 0, 2108 }, /* BTST.B #<data>.W,#<data>.B */
{ CPUFUNC(op_840_0), 0, 2112 }, /* BCHG.L #<data>.W,Dn */
{ CPUFUNC(op_850_0), 0, 2128 }, /* BCHG.B #<data>.W,(An) */
{ CPUFUNC(op_858_0), 0, 2136 }, /* BCHG.B #<data>.W,(An)+ */
{ CPUFUNC(op_860_0), 0, 2144 }, /* BCHG.B #<data>.W,-(An) */
{ CPUFUNC(op_868_0), 0, 2152 }, /* BCHG.B #<data>.W,(d16,An) */
{ CPUFUNC(op_870_3), 0, 2160 }, /* BCHG.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_878_0), 0, 2168 }, /* BCHG.B #<data>.W,(xxx).W */
{ CPUFUNC(op_879_0), 0, 2169 }, /* BCHG.B #<data>.W,(xxx).L */
{ CPUFUNC(op_87a_0), 0, 2170 }, /* BCHG.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_87b_3), 0, 2171 }, /* BCHG.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_880_0), 0, 2176 }, /* BCLR.L #<data>.W,Dn */
{ CPUFUNC(op_890_0), 0, 2192 }, /* BCLR.B #<data>.W,(An) */
{ CPUFUNC(op_898_0), 0, 2200 }, /* BCLR.B #<data>.W,(An)+ */
{ CPUFUNC(op_8a0_0), 0, 2208 }, /* BCLR.B #<data>.W,-(An) */
{ CPUFUNC(op_8a8_0), 0, 2216 }, /* BCLR.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8b0_3), 0, 2224 }, /* BCLR.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8b8_0), 0, 2232 }, /* BCLR.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8b9_0), 0, 2233 }, /* BCLR.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8ba_0), 0, 2234 }, /* BCLR.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8bb_3), 0, 2235 }, /* BCLR.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_8c0_0), 0, 2240 }, /* BSET.L #<data>.W,Dn */
{ CPUFUNC(op_8d0_0), 0, 2256 }, /* BSET.B #<data>.W,(An) */
{ CPUFUNC(op_8d8_0), 0, 2264 }, /* BSET.B #<data>.W,(An)+ */
{ CPUFUNC(op_8e0_0), 0, 2272 }, /* BSET.B #<data>.W,-(An) */
{ CPUFUNC(op_8e8_0), 0, 2280 }, /* BSET.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8f0_3), 0, 2288 }, /* BSET.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8f8_0), 0, 2296 }, /* BSET.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8f9_0), 0, 2297 }, /* BSET.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8fa_0), 0, 2298 }, /* BSET.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8fb_3), 0, 2299 }, /* BSET.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_a00_0), 0, 2560 }, /* EOR.B #<data>.B,Dn */
{ CPUFUNC(op_a10_0), 0, 2576 }, /* EOR.B #<data>.B,(An) */
{ CPUFUNC(op_a18_0), 0, 2584 }, /* EOR.B #<data>.B,(An)+ */
{ CPUFUNC(op_a20_0), 0, 2592 }, /* EOR.B #<data>.B,-(An) */
{ CPUFUNC(op_a28_0), 0, 2600 }, /* EOR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_a30_3), 0, 2608 }, /* EOR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_a38_0), 0, 2616 }, /* EOR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_a39_0), 0, 2617 }, /* EOR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_a3c_0), 0, 2620 }, /* EORSR.B #<data>.W */
{ CPUFUNC(op_a40_0), 0, 2624 }, /* EOR.W #<data>.W,Dn */
{ CPUFUNC(op_a50_0), 0, 2640 }, /* EOR.W #<data>.W,(An) */
{ CPUFUNC(op_a58_0), 0, 2648 }, /* EOR.W #<data>.W,(An)+ */
{ CPUFUNC(op_a60_0), 0, 2656 }, /* EOR.W #<data>.W,-(An) */
{ CPUFUNC(op_a68_0), 0, 2664 }, /* EOR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_a70_3), 0, 2672 }, /* EOR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_a78_0), 0, 2680 }, /* EOR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_a79_0), 0, 2681 }, /* EOR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_a7c_0), 0, 2684 }, /* EORSR.W #<data>.W */
{ CPUFUNC(op_a80_0), 0, 2688 }, /* EOR.L #<data>.L,Dn */
{ CPUFUNC(op_a90_0), 0, 2704 }, /* EOR.L #<data>.L,(An) */
{ CPUFUNC(op_a98_0), 0, 2712 }, /* EOR.L #<data>.L,(An)+ */
{ CPUFUNC(op_aa0_0), 0, 2720 }, /* EOR.L #<data>.L,-(An) */
{ CPUFUNC(op_aa8_0), 0, 2728 }, /* EOR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_ab0_3), 0, 2736 }, /* EOR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_ab8_0), 0, 2744 }, /* EOR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_ab9_0), 0, 2745 }, /* EOR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_c00_0), 0, 3072 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_c10_0), 0, 3088 }, /* CMP.B #<data>.B,(An) */
{ CPUFUNC(op_c18_0), 0, 3096 }, /* CMP.B #<data>.B,(An)+ */
{ CPUFUNC(op_c20_0), 0, 3104 }, /* CMP.B #<data>.B,-(An) */
{ CPUFUNC(op_c28_0), 0, 3112 }, /* CMP.B #<data>.B,(d16,An) */
{ CPUFUNC(op_c30_3), 0, 3120 }, /* CMP.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_c38_0), 0, 3128 }, /* CMP.B #<data>.B,(xxx).W */
{ CPUFUNC(op_c39_0), 0, 3129 }, /* CMP.B #<data>.B,(xxx).L */
{ CPUFUNC(op_c3a_0), 0, 3130 }, /* CMP.B #<data>.B,(d16,PC) */
{ CPUFUNC(op_c3b_3), 0, 3131 }, /* CMP.B #<data>.B,(d8,PC,Xn) */
{ CPUFUNC(op_c40_0), 0, 3136 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_c50_0), 0, 3152 }, /* CMP.W #<data>.W,(An) */
{ CPUFUNC(op_c58_0), 0, 3160 }, /* CMP.W #<data>.W,(An)+ */
{ CPUFUNC(op_c60_0), 0, 3168 }, /* CMP.W #<data>.W,-(An) */
{ CPUFUNC(op_c68_0), 0, 3176 }, /* CMP.W #<data>.W,(d16,An) */
{ CPUFUNC(op_c70_3), 0, 3184 }, /* CMP.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_c78_0), 0, 3192 }, /* CMP.W #<data>.W,(xxx).W */
{ CPUFUNC(op_c79_0), 0, 3193 }, /* CMP.W #<data>.W,(xxx).L */
{ CPUFUNC(op_c7a_0), 0, 3194 }, /* CMP.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_c7b_3), 0, 3195 }, /* CMP.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_c80_0), 0, 3200 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_c90_0), 0, 3216 }, /* CMP.L #<data>.L,(An) */
{ CPUFUNC(op_c98_0), 0, 3224 }, /* CMP.L #<data>.L,(An)+ */
{ CPUFUNC(op_ca0_0), 0, 3232 }, /* CMP.L #<data>.L,-(An) */
{ CPUFUNC(op_ca8_0), 0, 3240 }, /* CMP.L #<data>.L,(d16,An) */
{ CPUFUNC(op_cb0_3), 0, 3248 }, /* CMP.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_cb8_0), 0, 3256 }, /* CMP.L #<data>.L,(xxx).W */
{ CPUFUNC(op_cb9_0), 0, 3257 }, /* CMP.L #<data>.L,(xxx).L */
{ CPUFUNC(op_cba_0), 0, 3258 }, /* CMP.L #<data>.L,(d16,PC) */
{ CPUFUNC(op_cbb_3), 0, 3259 }, /* CMP.L #<data>.L,(d8,PC,Xn) */
{ CPUFUNC(op_1000_0), 0, 4096 }, /* MOVE.B Dn,Dn */
{ CPUFUNC(op_1010_0), 0, 4112 }, /* MOVE.B (An),Dn */
{ CPUFUNC(op_1018_0), 0, 4120 }, /* MOVE.B (An)+,Dn */
{ CPUFUNC(op_1020_0), 0, 4128 }, /* MOVE.B -(An),Dn */
{ CPUFUNC(op_1028_0), 0, 4136 }, /* MOVE.B (d16,An),Dn */
{ CPUFUNC(op_1030_3), 0, 4144 }, /* MOVE.B (d8,An,Xn),Dn */
{ CPUFUNC(op_1038_0), 0, 4152 }, /* MOVE.B (xxx).W,Dn */
{ CPUFUNC(op_1039_0), 0, 4153 }, /* MOVE.B (xxx).L,Dn */
{ CPUFUNC(op_103a_0), 0, 4154 }, /* MOVE.B (d16,PC),Dn */
{ CPUFUNC(op_103b_3), 0, 4155 }, /* MOVE.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_103c_0), 0, 4156 }, /* MOVE.B #<data>.B,Dn */
{ CPUFUNC(op_1080_0), 0, 4224 }, /* MOVE.B Dn,(An) */
{ CPUFUNC(op_1090_0), 0, 4240 }, /* MOVE.B (An),(An) */
{ CPUFUNC(op_1098_0), 0, 4248 }, /* MOVE.B (An)+,(An) */
{ CPUFUNC(op_10a0_0), 0, 4256 }, /* MOVE.B -(An),(An) */
{ CPUFUNC(op_10a8_0), 0, 4264 }, /* MOVE.B (d16,An),(An) */
{ CPUFUNC(op_10b0_3), 0, 4272 }, /* MOVE.B (d8,An,Xn),(An) */
{ CPUFUNC(op_10b8_0), 0, 4280 }, /* MOVE.B (xxx).W,(An) */
{ CPUFUNC(op_10b9_0), 0, 4281 }, /* MOVE.B (xxx).L,(An) */
{ CPUFUNC(op_10ba_0), 0, 4282 }, /* MOVE.B (d16,PC),(An) */
{ CPUFUNC(op_10bb_3), 0, 4283 }, /* MOVE.B (d8,PC,Xn),(An) */
{ CPUFUNC(op_10bc_0), 0, 4284 }, /* MOVE.B #<data>.B,(An) */
{ CPUFUNC(op_10c0_0), 0, 4288 }, /* MOVE.B Dn,(An)+ */
{ CPUFUNC(op_10d0_0), 0, 4304 }, /* MOVE.B (An),(An)+ */
{ CPUFUNC(op_10d8_0), 0, 4312 }, /* MOVE.B (An)+,(An)+ */
{ CPUFUNC(op_10e0_0), 0, 4320 }, /* MOVE.B -(An),(An)+ */
{ CPUFUNC(op_10e8_0), 0, 4328 }, /* MOVE.B (d16,An),(An)+ */
{ CPUFUNC(op_10f0_3), 0, 4336 }, /* MOVE.B (d8,An,Xn),(An)+ */
{ CPUFUNC(op_10f8_0), 0, 4344 }, /* MOVE.B (xxx).W,(An)+ */
{ CPUFUNC(op_10f9_0), 0, 4345 }, /* MOVE.B (xxx).L,(An)+ */
{ CPUFUNC(op_10fa_0), 0, 4346 }, /* MOVE.B (d16,PC),(An)+ */
{ CPUFUNC(op_10fb_3), 0, 4347 }, /* MOVE.B (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_10fc_0), 0, 4348 }, /* MOVE.B #<data>.B,(An)+ */
{ CPUFUNC(op_1100_0), 0, 4352 }, /* MOVE.B Dn,-(An) */
{ CPUFUNC(op_1110_0), 0, 4368 }, /* MOVE.B (An),-(An) */
{ CPUFUNC(op_1118_0), 0, 4376 }, /* MOVE.B (An)+,-(An) */
{ CPUFUNC(op_1120_0), 0, 4384 }, /* MOVE.B -(An),-(An) */
{ CPUFUNC(op_1128_0), 0, 4392 }, /* MOVE.B (d16,An),-(An) */
{ CPUFUNC(op_1130_3), 0, 4400 }, /* MOVE.B (d8,An,Xn),-(An) */
{ CPUFUNC(op_1138_0), 0, 4408 }, /* MOVE.B (xxx).W,-(An) */
{ CPUFUNC(op_1139_0), 0, 4409 }, /* MOVE.B (xxx).L,-(An) */
{ CPUFUNC(op_113a_0), 0, 4410 }, /* MOVE.B (d16,PC),-(An) */
{ CPUFUNC(op_113b_3), 0, 4411 }, /* MOVE.B (d8,PC,Xn),-(An) */
{ CPUFUNC(op_113c_0), 0, 4412 }, /* MOVE.B #<data>.B,-(An) */
{ CPUFUNC(op_1140_0), 0, 4416 }, /* MOVE.B Dn,(d16,An) */
{ CPUFUNC(op_1150_0), 0, 4432 }, /* MOVE.B (An),(d16,An) */
{ CPUFUNC(op_1158_0), 0, 4440 }, /* MOVE.B (An)+,(d16,An) */
{ CPUFUNC(op_1160_0), 0, 4448 }, /* MOVE.B -(An),(d16,An) */
{ CPUFUNC(op_1168_0), 0, 4456 }, /* MOVE.B (d16,An),(d16,An) */
{ CPUFUNC(op_1170_3), 0, 4464 }, /* MOVE.B (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_1178_0), 0, 4472 }, /* MOVE.B (xxx).W,(d16,An) */
{ CPUFUNC(op_1179_0), 0, 4473 }, /* MOVE.B (xxx).L,(d16,An) */
{ CPUFUNC(op_117a_0), 0, 4474 }, /* MOVE.B (d16,PC),(d16,An) */
{ CPUFUNC(op_117b_3), 0, 4475 }, /* MOVE.B (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_117c_0), 0, 4476 }, /* MOVE.B #<data>.B,(d16,An) */
{ CPUFUNC(op_1180_3), 0, 4480 }, /* MOVE.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1190_3), 0, 4496 }, /* MOVE.B (An),(d8,An,Xn) */
{ CPUFUNC(op_1198_3), 0, 4504 }, /* MOVE.B (An)+,(d8,An,Xn) */
{ CPUFUNC(op_11a0_3), 0, 4512 }, /* MOVE.B -(An),(d8,An,Xn) */
{ CPUFUNC(op_11a8_3), 0, 4520 }, /* MOVE.B (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_11b0_3), 0, 4528 }, /* MOVE.B (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11b8_3), 0, 4536 }, /* MOVE.B (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_11b9_3), 0, 4537 }, /* MOVE.B (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_11ba_3), 0, 4538 }, /* MOVE.B (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_11bb_3), 0, 4539 }, /* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11bc_3), 0, 4540 }, /* MOVE.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_11c0_0), 0, 4544 }, /* MOVE.B Dn,(xxx).W */
{ CPUFUNC(op_11d0_0), 0, 4560 }, /* MOVE.B (An),(xxx).W */
{ CPUFUNC(op_11d8_0), 0, 4568 }, /* MOVE.B (An)+,(xxx).W */
{ CPUFUNC(op_11e0_0), 0, 4576 }, /* MOVE.B -(An),(xxx).W */
{ CPUFUNC(op_11e8_0), 0, 4584 }, /* MOVE.B (d16,An),(xxx).W */
{ CPUFUNC(op_11f0_3), 0, 4592 }, /* MOVE.B (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_11f8_0), 0, 4600 }, /* MOVE.B (xxx).W,(xxx).W */
{ CPUFUNC(op_11f9_0), 0, 4601 }, /* MOVE.B (xxx).L,(xxx).W */
{ CPUFUNC(op_11fa_0), 0, 4602 }, /* MOVE.B (d16,PC),(xxx).W */
{ CPUFUNC(op_11fb_3), 0, 4603 }, /* MOVE.B (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_11fc_0), 0, 4604 }, /* MOVE.B #<data>.B,(xxx).W */
{ CPUFUNC(op_13c0_0), 0, 5056 }, /* MOVE.B Dn,(xxx).L */
{ CPUFUNC(op_13d0_0), 0, 5072 }, /* MOVE.B (An),(xxx).L */
{ CPUFUNC(op_13d8_0), 0, 5080 }, /* MOVE.B (An)+,(xxx).L */
{ CPUFUNC(op_13e0_0), 0, 5088 }, /* MOVE.B -(An),(xxx).L */
{ CPUFUNC(op_13e8_0), 0, 5096 }, /* MOVE.B (d16,An),(xxx).L */
{ CPUFUNC(op_13f0_3), 0, 5104 }, /* MOVE.B (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_13f8_0), 0, 5112 }, /* MOVE.B (xxx).W,(xxx).L */
{ CPUFUNC(op_13f9_0), 0, 5113 }, /* MOVE.B (xxx).L,(xxx).L */
{ CPUFUNC(op_13fa_0), 0, 5114 }, /* MOVE.B (d16,PC),(xxx).L */
{ CPUFUNC(op_13fb_3), 0, 5115 }, /* MOVE.B (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_13fc_0), 0, 5116 }, /* MOVE.B #<data>.B,(xxx).L */
{ CPUFUNC(op_2000_0), 0, 8192 }, /* MOVE.L Dn,Dn */
{ CPUFUNC(op_2008_0), 0, 8200 }, /* MOVE.L An,Dn */
{ CPUFUNC(op_2010_0), 0, 8208 }, /* MOVE.L (An),Dn */
{ CPUFUNC(op_2018_0), 0, 8216 }, /* MOVE.L (An)+,Dn */
{ CPUFUNC(op_2020_0), 0, 8224 }, /* MOVE.L -(An),Dn */
{ CPUFUNC(op_2028_0), 0, 8232 }, /* MOVE.L (d16,An),Dn */
{ CPUFUNC(op_2030_3), 0, 8240 }, /* MOVE.L (d8,An,Xn),Dn */
{ CPUFUNC(op_2038_0), 0, 8248 }, /* MOVE.L (xxx).W,Dn */
{ CPUFUNC(op_2039_0), 0, 8249 }, /* MOVE.L (xxx).L,Dn */
{ CPUFUNC(op_203a_0), 0, 8250 }, /* MOVE.L (d16,PC),Dn */
{ CPUFUNC(op_203b_3), 0, 8251 }, /* MOVE.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_203c_0), 0, 8252 }, /* MOVE.L #<data>.L,Dn */
{ CPUFUNC_FF(op_2040_0), 0, 8256 }, /* MOVEA.L Dn,An */
{ CPUFUNC_FF(op_2048_0), 0, 8264 }, /* MOVEA.L An,An */
{ CPUFUNC_FF(op_2050_0), 0, 8272 }, /* MOVEA.L (An),An */
{ CPUFUNC_FF(op_2058_0), 0, 8280 }, /* MOVEA.L (An)+,An */
{ CPUFUNC_FF(op_2060_0), 0, 8288 }, /* MOVEA.L -(An),An */
{ CPUFUNC_FF(op_2068_0), 0, 8296 }, /* MOVEA.L (d16,An),An */
{ CPUFUNC_FF(op_2070_3), 0, 8304 }, /* MOVEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_2078_0), 0, 8312 }, /* MOVEA.L (xxx).W,An */
{ CPUFUNC_FF(op_2079_0), 0, 8313 }, /* MOVEA.L (xxx).L,An */
{ CPUFUNC_FF(op_207a_0), 0, 8314 }, /* MOVEA.L (d16,PC),An */
{ CPUFUNC_FF(op_207b_3), 0, 8315 }, /* MOVEA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_207c_0), 0, 8316 }, /* MOVEA.L #<data>.L,An */
{ CPUFUNC(op_2080_0), 0, 8320 }, /* MOVE.L Dn,(An) */
{ CPUFUNC(op_2088_0), 0, 8328 }, /* MOVE.L An,(An) */
{ CPUFUNC(op_2090_0), 0, 8336 }, /* MOVE.L (An),(An) */
{ CPUFUNC(op_2098_0), 0, 8344 }, /* MOVE.L (An)+,(An) */
{ CPUFUNC(op_20a0_0), 0, 8352 }, /* MOVE.L -(An),(An) */
{ CPUFUNC(op_20a8_0), 0, 8360 }, /* MOVE.L (d16,An),(An) */
{ CPUFUNC(op_20b0_3), 0, 8368 }, /* MOVE.L (d8,An,Xn),(An) */
{ CPUFUNC(op_20b8_0), 0, 8376 }, /* MOVE.L (xxx).W,(An) */
{ CPUFUNC(op_20b9_0), 0, 8377 }, /* MOVE.L (xxx).L,(An) */
{ CPUFUNC(op_20ba_0), 0, 8378 }, /* MOVE.L (d16,PC),(An) */
{ CPUFUNC(op_20bb_3), 0, 8379 }, /* MOVE.L (d8,PC,Xn),(An) */
{ CPUFUNC(op_20bc_0), 0, 8380 }, /* MOVE.L #<data>.L,(An) */
{ CPUFUNC(op_20c0_0), 0, 8384 }, /* MOVE.L Dn,(An)+ */
{ CPUFUNC(op_20c8_0), 0, 8392 }, /* MOVE.L An,(An)+ */
{ CPUFUNC(op_20d0_0), 0, 8400 }, /* MOVE.L (An),(An)+ */
{ CPUFUNC(op_20d8_0), 0, 8408 }, /* MOVE.L (An)+,(An)+ */
{ CPUFUNC(op_20e0_0), 0, 8416 }, /* MOVE.L -(An),(An)+ */
{ CPUFUNC(op_20e8_0), 0, 8424 }, /* MOVE.L (d16,An),(An)+ */
{ CPUFUNC(op_20f0_3), 0, 8432 }, /* MOVE.L (d8,An,Xn),(An)+ */
{ CPUFUNC(op_20f8_0), 0, 8440 }, /* MOVE.L (xxx).W,(An)+ */
{ CPUFUNC(op_20f9_0), 0, 8441 }, /* MOVE.L (xxx).L,(An)+ */
{ CPUFUNC(op_20fa_0), 0, 8442 }, /* MOVE.L (d16,PC),(An)+ */
{ CPUFUNC(op_20fb_3), 0, 8443 }, /* MOVE.L (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_20fc_0), 0, 8444 }, /* MOVE.L #<data>.L,(An)+ */
{ CPUFUNC(op_2100_0), 0, 8448 }, /* MOVE.L Dn,-(An) */
{ CPUFUNC(op_2108_0), 0, 8456 }, /* MOVE.L An,-(An) */
{ CPUFUNC(op_2110_0), 0, 8464 }, /* MOVE.L (An),-(An) */
{ CPUFUNC(op_2118_0), 0, 8472 }, /* MOVE.L (An)+,-(An) */
{ CPUFUNC(op_2120_0), 0, 8480 }, /* MOVE.L -(An),-(An) */
{ CPUFUNC(op_2128_0), 0, 8488 }, /* MOVE.L (d16,An),-(An) */
{ CPUFUNC(op_2130_3), 0, 8496 }, /* MOVE.L (d8,An,Xn),-(An) */
{ CPUFUNC(op_2138_0), 0, 8504 }, /* MOVE.L (xxx).W,-(An) */
{ CPUFUNC(op_2139_0), 0, 8505 }, /* MOVE.L (xxx).L,-(An) */
{ CPUFUNC(op_213a_0), 0, 8506 }, /* MOVE.L (d16,PC),-(An) */
{ CPUFUNC(op_213b_3), 0, 8507 }, /* MOVE.L (d8,PC,Xn),-(An) */
{ CPUFUNC(op_213c_0), 0, 8508 }, /* MOVE.L #<data>.L,-(An) */
{ CPUFUNC(op_2140_0), 0, 8512 }, /* MOVE.L Dn,(d16,An) */
{ CPUFUNC(op_2148_0), 0, 8520 }, /* MOVE.L An,(d16,An) */
{ CPUFUNC(op_2150_0), 0, 8528 }, /* MOVE.L (An),(d16,An) */
{ CPUFUNC(op_2158_0), 0, 8536 }, /* MOVE.L (An)+,(d16,An) */
{ CPUFUNC(op_2160_0), 0, 8544 }, /* MOVE.L -(An),(d16,An) */
{ CPUFUNC(op_2168_0), 0, 8552 }, /* MOVE.L (d16,An),(d16,An) */
{ CPUFUNC(op_2170_3), 0, 8560 }, /* MOVE.L (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_2178_0), 0, 8568 }, /* MOVE.L (xxx).W,(d16,An) */
{ CPUFUNC(op_2179_0), 0, 8569 }, /* MOVE.L (xxx).L,(d16,An) */
{ CPUFUNC(op_217a_0), 0, 8570 }, /* MOVE.L (d16,PC),(d16,An) */
{ CPUFUNC(op_217b_3), 0, 8571 }, /* MOVE.L (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_217c_0), 0, 8572 }, /* MOVE.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2180_3), 0, 8576 }, /* MOVE.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_2188_3), 0, 8584 }, /* MOVE.L An,(d8,An,Xn) */
{ CPUFUNC(op_2190_3), 0, 8592 }, /* MOVE.L (An),(d8,An,Xn) */
{ CPUFUNC(op_2198_3), 0, 8600 }, /* MOVE.L (An)+,(d8,An,Xn) */
{ CPUFUNC(op_21a0_3), 0, 8608 }, /* MOVE.L -(An),(d8,An,Xn) */
{ CPUFUNC(op_21a8_3), 0, 8616 }, /* MOVE.L (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_21b0_3), 0, 8624 }, /* MOVE.L (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21b8_3), 0, 8632 }, /* MOVE.L (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_21b9_3), 0, 8633 }, /* MOVE.L (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_21ba_3), 0, 8634 }, /* MOVE.L (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_21bb_3), 0, 8635 }, /* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21bc_3), 0, 8636 }, /* MOVE.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_21c0_0), 0, 8640 }, /* MOVE.L Dn,(xxx).W */
{ CPUFUNC(op_21c8_0), 0, 8648 }, /* MOVE.L An,(xxx).W */
{ CPUFUNC(op_21d0_0), 0, 8656 }, /* MOVE.L (An),(xxx).W */
{ CPUFUNC(op_21d8_0), 0, 8664 }, /* MOVE.L (An)+,(xxx).W */
{ CPUFUNC(op_21e0_0), 0, 8672 }, /* MOVE.L -(An),(xxx).W */
{ CPUFUNC(op_21e8_0), 0, 8680 }, /* MOVE.L (d16,An),(xxx).W */
{ CPUFUNC(op_21f0_3), 0, 8688 }, /* MOVE.L (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_21f8_0), 0, 8696 }, /* MOVE.L (xxx).W,(xxx).W */
{ CPUFUNC(op_21f9_0), 0, 8697 }, /* MOVE.L (xxx).L,(xxx).W */
{ CPUFUNC(op_21fa_0), 0, 8698 }, /* MOVE.L (d16,PC),(xxx).W */
{ CPUFUNC(op_21fb_3), 0, 8699 }, /* MOVE.L (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_21fc_0), 0, 8700 }, /* MOVE.L #<data>.L,(xxx).W */
{ CPUFUNC(op_23c0_0), 0, 9152 }, /* MOVE.L Dn,(xxx).L */
{ CPUFUNC(op_23c8_0), 0, 9160 }, /* MOVE.L An,(xxx).L */
{ CPUFUNC(op_23d0_0), 0, 9168 }, /* MOVE.L (An),(xxx).L */
{ CPUFUNC(op_23d8_0), 0, 9176 }, /* MOVE.L (An)+,(xxx).L */
{ CPUFUNC(op_23e0_0), 0, 9184 }, /* MOVE.L -(An),(xxx).L */
{ CPUFUNC(op_23e8_0), 0, 9192 }, /* MOVE.L (d16,An),(xxx).L */
{ CPUFUNC(op_23f0_3), 0, 9200 }, /* MOVE.L (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_23f8_0), 0, 9208 }, /* MOVE.L (xxx).W,(xxx).L */
{ CPUFUNC(op_23f9_0), 0, 9209 }, /* MOVE.L (xxx).L,(xxx).L */
{ CPUFUNC(op_23fa_0), 0, 9210 }, /* MOVE.L (d16,PC),(xxx).L */
{ CPUFUNC(op_23fb_3), 0, 9211 }, /* MOVE.L (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_23fc_0), 0, 9212 }, /* MOVE.L #<data>.L,(xxx).L */
{ CPUFUNC(op_3000_0), 0, 12288 }, /* MOVE.W Dn,Dn */
{ CPUFUNC(op_3008_0), 0, 12296 }, /* MOVE.W An,Dn */
{ CPUFUNC(op_3010_0), 0, 12304 }, /* MOVE.W (An),Dn */
{ CPUFUNC(op_3018_0), 0, 12312 }, /* MOVE.W (An)+,Dn */
{ CPUFUNC(op_3020_0), 0, 12320 }, /* MOVE.W -(An),Dn */
{ CPUFUNC(op_3028_0), 0, 12328 }, /* MOVE.W (d16,An),Dn */
{ CPUFUNC(op_3030_3), 0, 12336 }, /* MOVE.W (d8,An,Xn),Dn */
{ CPUFUNC(op_3038_0), 0, 12344 }, /* MOVE.W (xxx).W,Dn */
{ CPUFUNC(op_3039_0), 0, 12345 }, /* MOVE.W (xxx).L,Dn */
{ CPUFUNC(op_303a_0), 0, 12346 }, /* MOVE.W (d16,PC),Dn */
{ CPUFUNC(op_303b_3), 0, 12347 }, /* MOVE.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_303c_0), 0, 12348 }, /* MOVE.W #<data>.W,Dn */
{ CPUFUNC_FF(op_3040_0), 0, 12352 }, /* MOVEA.W Dn,An */
{ CPUFUNC_FF(op_3048_0), 0, 12360 }, /* MOVEA.W An,An */
{ CPUFUNC_FF(op_3050_0), 0, 12368 }, /* MOVEA.W (An),An */
{ CPUFUNC_FF(op_3058_0), 0, 12376 }, /* MOVEA.W (An)+,An */
{ CPUFUNC_FF(op_3060_0), 0, 12384 }, /* MOVEA.W -(An),An */
{ CPUFUNC_FF(op_3068_0), 0, 12392 }, /* MOVEA.W (d16,An),An */
{ CPUFUNC_FF(op_3070_3), 0, 12400 }, /* MOVEA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_3078_0), 0, 12408 }, /* MOVEA.W (xxx).W,An */
{ CPUFUNC_FF(op_3079_0), 0, 12409 }, /* MOVEA.W (xxx).L,An */
{ CPUFUNC_FF(op_307a_0), 0, 12410 }, /* MOVEA.W (d16,PC),An */
{ CPUFUNC_FF(op_307b_3), 0, 12411 }, /* MOVEA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_307c_0), 0, 12412 }, /* MOVEA.W #<data>.W,An */
{ CPUFUNC(op_3080_0), 0, 12416 }, /* MOVE.W Dn,(An) */
{ CPUFUNC(op_3088_0), 0, 12424 }, /* MOVE.W An,(An) */
{ CPUFUNC(op_3090_0), 0, 12432 }, /* MOVE.W (An),(An) */
{ CPUFUNC(op_3098_0), 0, 12440 }, /* MOVE.W (An)+,(An) */
{ CPUFUNC(op_30a0_0), 0, 12448 }, /* MOVE.W -(An),(An) */
{ CPUFUNC(op_30a8_0), 0, 12456 }, /* MOVE.W (d16,An),(An) */
{ CPUFUNC(op_30b0_3), 0, 12464 }, /* MOVE.W (d8,An,Xn),(An) */
{ CPUFUNC(op_30b8_0), 0, 12472 }, /* MOVE.W (xxx).W,(An) */
{ CPUFUNC(op_30b9_0), 0, 12473 }, /* MOVE.W (xxx).L,(An) */
{ CPUFUNC(op_30ba_0), 0, 12474 }, /* MOVE.W (d16,PC),(An) */
{ CPUFUNC(op_30bb_3), 0, 12475 }, /* MOVE.W (d8,PC,Xn),(An) */
{ CPUFUNC(op_30bc_0), 0, 12476 }, /* MOVE.W #<data>.W,(An) */
{ CPUFUNC(op_30c0_0), 0, 12480 }, /* MOVE.W Dn,(An)+ */
{ CPUFUNC(op_30c8_0), 0, 12488 }, /* MOVE.W An,(An)+ */
{ CPUFUNC(op_30d0_0), 0, 12496 }, /* MOVE.W (An),(An)+ */
{ CPUFUNC(op_30d8_0), 0, 12504 }, /* MOVE.W (An)+,(An)+ */
{ CPUFUNC(op_30e0_0), 0, 12512 }, /* MOVE.W -(An),(An)+ */
{ CPUFUNC(op_30e8_0), 0, 12520 }, /* MOVE.W (d16,An),(An)+ */
{ CPUFUNC(op_30f0_3), 0, 12528 }, /* MOVE.W (d8,An,Xn),(An)+ */
{ CPUFUNC(op_30f8_0), 0, 12536 }, /* MOVE.W (xxx).W,(An)+ */
{ CPUFUNC(op_30f9_0), 0, 12537 }, /* MOVE.W (xxx).L,(An)+ */
{ CPUFUNC(op_30fa_0), 0, 12538 }, /* MOVE.W (d16,PC),(An)+ */
{ CPUFUNC(op_30fb_3), 0, 12539 }, /* MOVE.W (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_30fc_0), 0, 12540 }, /* MOVE.W #<data>.W,(An)+ */
{ CPUFUNC(op_3100_0), 0, 12544 }, /* MOVE.W Dn,-(An) */
{ CPUFUNC(op_3108_0), 0, 12552 }, /* MOVE.W An,-(An) */
{ CPUFUNC(op_3110_0), 0, 12560 }, /* MOVE.W (An),-(An) */
{ CPUFUNC(op_3118_0), 0, 12568 }, /* MOVE.W (An)+,-(An) */
{ CPUFUNC(op_3120_0), 0, 12576 }, /* MOVE.W -(An),-(An) */
{ CPUFUNC(op_3128_0), 0, 12584 }, /* MOVE.W (d16,An),-(An) */
{ CPUFUNC(op_3130_3), 0, 12592 }, /* MOVE.W (d8,An,Xn),-(An) */
{ CPUFUNC(op_3138_0), 0, 12600 }, /* MOVE.W (xxx).W,-(An) */
{ CPUFUNC(op_3139_0), 0, 12601 }, /* MOVE.W (xxx).L,-(An) */
{ CPUFUNC(op_313a_0), 0, 12602 }, /* MOVE.W (d16,PC),-(An) */
{ CPUFUNC(op_313b_3), 0, 12603 }, /* MOVE.W (d8,PC,Xn),-(An) */
{ CPUFUNC(op_313c_0), 0, 12604 }, /* MOVE.W #<data>.W,-(An) */
{ CPUFUNC(op_3140_0), 0, 12608 }, /* MOVE.W Dn,(d16,An) */
{ CPUFUNC(op_3148_0), 0, 12616 }, /* MOVE.W An,(d16,An) */
{ CPUFUNC(op_3150_0), 0, 12624 }, /* MOVE.W (An),(d16,An) */
{ CPUFUNC(op_3158_0), 0, 12632 }, /* MOVE.W (An)+,(d16,An) */
{ CPUFUNC(op_3160_0), 0, 12640 }, /* MOVE.W -(An),(d16,An) */
{ CPUFUNC(op_3168_0), 0, 12648 }, /* MOVE.W (d16,An),(d16,An) */
{ CPUFUNC(op_3170_3), 0, 12656 }, /* MOVE.W (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_3178_0), 0, 12664 }, /* MOVE.W (xxx).W,(d16,An) */
{ CPUFUNC(op_3179_0), 0, 12665 }, /* MOVE.W (xxx).L,(d16,An) */
{ CPUFUNC(op_317a_0), 0, 12666 }, /* MOVE.W (d16,PC),(d16,An) */
{ CPUFUNC(op_317b_3), 0, 12667 }, /* MOVE.W (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_317c_0), 0, 12668 }, /* MOVE.W #<data>.W,(d16,An) */
{ CPUFUNC(op_3180_3), 0, 12672 }, /* MOVE.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_3188_3), 0, 12680 }, /* MOVE.W An,(d8,An,Xn) */
{ CPUFUNC(op_3190_3), 0, 12688 }, /* MOVE.W (An),(d8,An,Xn) */
{ CPUFUNC(op_3198_3), 0, 12696 }, /* MOVE.W (An)+,(d8,An,Xn) */
{ CPUFUNC(op_31a0_3), 0, 12704 }, /* MOVE.W -(An),(d8,An,Xn) */
{ CPUFUNC(op_31a8_3), 0, 12712 }, /* MOVE.W (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_31b0_3), 0, 12720 }, /* MOVE.W (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31b8_3), 0, 12728 }, /* MOVE.W (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_31b9_3), 0, 12729 }, /* MOVE.W (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_31ba_3), 0, 12730 }, /* MOVE.W (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_31bb_3), 0, 12731 }, /* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31bc_3), 0, 12732 }, /* MOVE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_31c0_0), 0, 12736 }, /* MOVE.W Dn,(xxx).W */
{ CPUFUNC(op_31c8_0), 0, 12744 }, /* MOVE.W An,(xxx).W */
{ CPUFUNC(op_31d0_0), 0, 12752 }, /* MOVE.W (An),(xxx).W */
{ CPUFUNC(op_31d8_0), 0, 12760 }, /* MOVE.W (An)+,(xxx).W */
{ CPUFUNC(op_31e0_0), 0, 12768 }, /* MOVE.W -(An),(xxx).W */
{ CPUFUNC(op_31e8_0), 0, 12776 }, /* MOVE.W (d16,An),(xxx).W */
{ CPUFUNC(op_31f0_3), 0, 12784 }, /* MOVE.W (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_31f8_0), 0, 12792 }, /* MOVE.W (xxx).W,(xxx).W */
{ CPUFUNC(op_31f9_0), 0, 12793 }, /* MOVE.W (xxx).L,(xxx).W */
{ CPUFUNC(op_31fa_0), 0, 12794 }, /* MOVE.W (d16,PC),(xxx).W */
{ CPUFUNC(op_31fb_3), 0, 12795 }, /* MOVE.W (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_31fc_0), 0, 12796 }, /* MOVE.W #<data>.W,(xxx).W */
{ CPUFUNC(op_33c0_0), 0, 13248 }, /* MOVE.W Dn,(xxx).L */
{ CPUFUNC(op_33c8_0), 0, 13256 }, /* MOVE.W An,(xxx).L */
{ CPUFUNC(op_33d0_0), 0, 13264 }, /* MOVE.W (An),(xxx).L */
{ CPUFUNC(op_33d8_0), 0, 13272 }, /* MOVE.W (An)+,(xxx).L */
{ CPUFUNC(op_33e0_0), 0, 13280 }, /* MOVE.W -(An),(xxx).L */
{ CPUFUNC(op_33e8_0), 0, 13288 }, /* MOVE.W (d16,An),(xxx).L */
{ CPUFUNC(op_33f0_3), 0, 13296 }, /* MOVE.W (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_33f8_0), 0, 13304 }, /* MOVE.W (xxx).W,(xxx).L */
{ CPUFUNC(op_33f9_0), 0, 13305 }, /* MOVE.W (xxx).L,(xxx).L */
{ CPUFUNC(op_33fa_0), 0, 13306 }, /* MOVE.W (d16,PC),(xxx).L */
{ CPUFUNC(op_33fb_3), 0, 13307 }, /* MOVE.W (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_33fc_0), 0, 13308 }, /* MOVE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_4000_0), 0, 16384 }, /* NEGX.B Dn */
{ CPUFUNC(op_4010_0), 0, 16400 }, /* NEGX.B (An) */
{ CPUFUNC(op_4018_0), 0, 16408 }, /* NEGX.B (An)+ */
{ CPUFUNC(op_4020_0), 0, 16416 }, /* NEGX.B -(An) */
{ CPUFUNC(op_4028_0), 0, 16424 }, /* NEGX.B (d16,An) */
{ CPUFUNC(op_4030_3), 0, 16432 }, /* NEGX.B (d8,An,Xn) */
{ CPUFUNC(op_4038_0), 0, 16440 }, /* NEGX.B (xxx).W */
{ CPUFUNC(op_4039_0), 0, 16441 }, /* NEGX.B (xxx).L */
{ CPUFUNC(op_4040_0), 0, 16448 }, /* NEGX.W Dn */
{ CPUFUNC(op_4050_0), 0, 16464 }, /* NEGX.W (An) */
{ CPUFUNC(op_4058_0), 0, 16472 }, /* NEGX.W (An)+ */
{ CPUFUNC(op_4060_0), 0, 16480 }, /* NEGX.W -(An) */
{ CPUFUNC(op_4068_0), 0, 16488 }, /* NEGX.W (d16,An) */
{ CPUFUNC(op_4070_3), 0, 16496 }, /* NEGX.W (d8,An,Xn) */
{ CPUFUNC(op_4078_0), 0, 16504 }, /* NEGX.W (xxx).W */
{ CPUFUNC(op_4079_0), 0, 16505 }, /* NEGX.W (xxx).L */
{ CPUFUNC(op_4080_0), 0, 16512 }, /* NEGX.L Dn */
{ CPUFUNC(op_4090_0), 0, 16528 }, /* NEGX.L (An) */
{ CPUFUNC(op_4098_0), 0, 16536 }, /* NEGX.L (An)+ */
{ CPUFUNC(op_40a0_0), 0, 16544 }, /* NEGX.L -(An) */
{ CPUFUNC(op_40a8_0), 0, 16552 }, /* NEGX.L (d16,An) */
{ CPUFUNC(op_40b0_3), 0, 16560 }, /* NEGX.L (d8,An,Xn) */
{ CPUFUNC(op_40b8_0), 0, 16568 }, /* NEGX.L (xxx).W */
{ CPUFUNC(op_40b9_0), 0, 16569 }, /* NEGX.L (xxx).L */
{ CPUFUNC_FF(op_40c0_0), 0, 16576 }, /* MVSR2.W Dn */
{ CPUFUNC_FF(op_40d0_0), 0, 16592 }, /* MVSR2.W (An) */
{ CPUFUNC_FF(op_40d8_0), 0, 16600 }, /* MVSR2.W (An)+ */
{ CPUFUNC_FF(op_40e0_0), 0, 16608 }, /* MVSR2.W -(An) */
{ CPUFUNC_FF(op_40e8_0), 0, 16616 }, /* MVSR2.W (d16,An) */
{ CPUFUNC_FF(op_40f0_3), 0, 16624 }, /* MVSR2.W (d8,An,Xn) */
{ CPUFUNC_FF(op_40f8_0), 0, 16632 }, /* MVSR2.W (xxx).W */
{ CPUFUNC_FF(op_40f9_0), 0, 16633 }, /* MVSR2.W (xxx).L */
{ CPUFUNC(op_4100_0), 0, 16640 }, /* CHK.L Dn,Dn */
{ CPUFUNC(op_4110_0), 0, 16656 }, /* CHK.L (An),Dn */
{ CPUFUNC(op_4118_0), 0, 16664 }, /* CHK.L (An)+,Dn */
{ CPUFUNC(op_4120_0), 0, 16672 }, /* CHK.L -(An),Dn */
{ CPUFUNC(op_4128_0), 0, 16680 }, /* CHK.L (d16,An),Dn */
{ CPUFUNC(op_4130_3), 0, 16688 }, /* CHK.L (d8,An,Xn),Dn */
{ CPUFUNC(op_4138_0), 0, 16696 }, /* CHK.L (xxx).W,Dn */
{ CPUFUNC(op_4139_0), 0, 16697 }, /* CHK.L (xxx).L,Dn */
{ CPUFUNC(op_413a_0), 0, 16698 }, /* CHK.L (d16,PC),Dn */
{ CPUFUNC(op_413b_3), 0, 16699 }, /* CHK.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_413c_0), 0, 16700 }, /* CHK.L #<data>.L,Dn */
{ CPUFUNC(op_4180_0), 0, 16768 }, /* CHK.W Dn,Dn */
{ CPUFUNC(op_4190_0), 0, 16784 }, /* CHK.W (An),Dn */
{ CPUFUNC(op_4198_0), 0, 16792 }, /* CHK.W (An)+,Dn */
{ CPUFUNC(op_41a0_0), 0, 16800 }, /* CHK.W -(An),Dn */
{ CPUFUNC(op_41a8_0), 0, 16808 }, /* CHK.W (d16,An),Dn */
{ CPUFUNC(op_41b0_3), 0, 16816 }, /* CHK.W (d8,An,Xn),Dn */
{ CPUFUNC(op_41b8_0), 0, 16824 }, /* CHK.W (xxx).W,Dn */
{ CPUFUNC(op_41b9_0), 0, 16825 }, /* CHK.W (xxx).L,Dn */
{ CPUFUNC(op_41ba_0), 0, 16826 }, /* CHK.W (d16,PC),Dn */
{ CPUFUNC(op_41bb_3), 0, 16827 }, /* CHK.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_41bc_0), 0, 16828 }, /* CHK.W #<data>.W,Dn */
{ CPUFUNC_FF(op_41d0_0), 0, 16848 }, /* LEA.L (An),An */
{ CPUFUNC_FF(op_41e8_0), 0, 16872 }, /* LEA.L (d16,An),An */
{ CPUFUNC_FF(op_41f0_3), 0, 16880 }, /* LEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_41f8_0), 0, 16888 }, /* LEA.L (xxx).W,An */
{ CPUFUNC_FF(op_41f9_0), 0, 16889 }, /* LEA.L (xxx).L,An */
{ CPUFUNC_FF(op_41fa_0), 0, 16890 }, /* LEA.L (d16,PC),An */
{ CPUFUNC_FF(op_41fb_3), 0, 16891 }, /* LEA.L (d8,PC,Xn),An */
{ CPUFUNC(op_4200_0), 0, 16896 }, /* CLR.B Dn */
{ CPUFUNC(op_4210_0), 0, 16912 }, /* CLR.B (An) */
{ CPUFUNC(op_4218_0), 0, 16920 }, /* CLR.B (An)+ */
{ CPUFUNC(op_4220_0), 0, 16928 }, /* CLR.B -(An) */
{ CPUFUNC(op_4228_0), 0, 16936 }, /* CLR.B (d16,An) */
{ CPUFUNC(op_4230_3), 0, 16944 }, /* CLR.B (d8,An,Xn) */
{ CPUFUNC(op_4238_0), 0, 16952 }, /* CLR.B (xxx).W */
{ CPUFUNC(op_4239_0), 0, 16953 }, /* CLR.B (xxx).L */
{ CPUFUNC(op_4240_0), 0, 16960 }, /* CLR.W Dn */
{ CPUFUNC(op_4250_0), 0, 16976 }, /* CLR.W (An) */
{ CPUFUNC(op_4258_0), 0, 16984 }, /* CLR.W (An)+ */
{ CPUFUNC(op_4260_0), 0, 16992 }, /* CLR.W -(An) */
{ CPUFUNC(op_4268_0), 0, 17000 }, /* CLR.W (d16,An) */
{ CPUFUNC(op_4270_3), 0, 17008 }, /* CLR.W (d8,An,Xn) */
{ CPUFUNC(op_4278_0), 0, 17016 }, /* CLR.W (xxx).W */
{ CPUFUNC(op_4279_0), 0, 17017 }, /* CLR.W (xxx).L */
{ CPUFUNC(op_4280_0), 0, 17024 }, /* CLR.L Dn */
{ CPUFUNC(op_4290_0), 0, 17040 }, /* CLR.L (An) */
{ CPUFUNC(op_4298_0), 0, 17048 }, /* CLR.L (An)+ */
{ CPUFUNC(op_42a0_0), 0, 17056 }, /* CLR.L -(An) */
{ CPUFUNC(op_42a8_0), 0, 17064 }, /* CLR.L (d16,An) */
{ CPUFUNC(op_42b0_3), 0, 17072 }, /* CLR.L (d8,An,Xn) */
{ CPUFUNC(op_42b8_0), 0, 17080 }, /* CLR.L (xxx).W */
{ CPUFUNC(op_42b9_0), 0, 17081 }, /* CLR.L (xxx).L */
{ CPUFUNC_FF(op_42c0_0), 0, 17088 }, /* MVSR2.B Dn */
{ CPUFUNC_FF(op_42d0_0), 0, 17104 }, /* MVSR2.B (An) */
{ CPUFUNC_FF(op_42d8_0), 0, 17112 }, /* MVSR2.B (An)+ */
{ CPUFUNC_FF(op_42e0_0), 0, 17120 }, /* MVSR2.B -(An) */
{ CPUFUNC_FF(op_42e8_0), 0, 17128 }, /* MVSR2.B (d16,An) */
{ CPUFUNC_FF(op_42f0_3), 0, 17136 }, /* MVSR2.B (d8,An,Xn) */
{ CPUFUNC_FF(op_42f8_0), 0, 17144 }, /* MVSR2.B (xxx).W */
{ CPUFUNC_FF(op_42f9_0), 0, 17145 }, /* MVSR2.B (xxx).L */
{ CPUFUNC(op_4400_0), 0, 17408 }, /* NEG.B Dn */
{ CPUFUNC(op_4410_0), 0, 17424 }, /* NEG.B (An) */
{ CPUFUNC(op_4418_0), 0, 17432 }, /* NEG.B (An)+ */
{ CPUFUNC(op_4420_0), 0, 17440 }, /* NEG.B -(An) */
{ CPUFUNC(op_4428_0), 0, 17448 }, /* NEG.B (d16,An) */
{ CPUFUNC(op_4430_3), 0, 17456 }, /* NEG.B (d8,An,Xn) */
{ CPUFUNC(op_4438_0), 0, 17464 }, /* NEG.B (xxx).W */
{ CPUFUNC(op_4439_0), 0, 17465 }, /* NEG.B (xxx).L */
{ CPUFUNC(op_4440_0), 0, 17472 }, /* NEG.W Dn */
{ CPUFUNC(op_4450_0), 0, 17488 }, /* NEG.W (An) */
{ CPUFUNC(op_4458_0), 0, 17496 }, /* NEG.W (An)+ */
{ CPUFUNC(op_4460_0), 0, 17504 }, /* NEG.W -(An) */
{ CPUFUNC(op_4468_0), 0, 17512 }, /* NEG.W (d16,An) */
{ CPUFUNC(op_4470_3), 0, 17520 }, /* NEG.W (d8,An,Xn) */
{ CPUFUNC(op_4478_0), 0, 17528 }, /* NEG.W (xxx).W */
{ CPUFUNC(op_4479_0), 0, 17529 }, /* NEG.W (xxx).L */
{ CPUFUNC(op_4480_0), 0, 17536 }, /* NEG.L Dn */
{ CPUFUNC(op_4490_0), 0, 17552 }, /* NEG.L (An) */
{ CPUFUNC(op_4498_0), 0, 17560 }, /* NEG.L (An)+ */
{ CPUFUNC(op_44a0_0), 0, 17568 }, /* NEG.L -(An) */
{ CPUFUNC(op_44a8_0), 0, 17576 }, /* NEG.L (d16,An) */
{ CPUFUNC(op_44b0_3), 0, 17584 }, /* NEG.L (d8,An,Xn) */
{ CPUFUNC(op_44b8_0), 0, 17592 }, /* NEG.L (xxx).W */
{ CPUFUNC(op_44b9_0), 0, 17593 }, /* NEG.L (xxx).L */
{ CPUFUNC(op_44c0_0), 0, 17600 }, /* MV2SR.B Dn */
{ CPUFUNC(op_44d0_0), 0, 17616 }, /* MV2SR.B (An) */
{ CPUFUNC(op_44d8_0), 0, 17624 }, /* MV2SR.B (An)+ */
{ CPUFUNC(op_44e0_0), 0, 17632 }, /* MV2SR.B -(An) */
{ CPUFUNC(op_44e8_0), 0, 17640 }, /* MV2SR.B (d16,An) */
{ CPUFUNC(op_44f0_3), 0, 17648 }, /* MV2SR.B (d8,An,Xn) */
{ CPUFUNC(op_44f8_0), 0, 17656 }, /* MV2SR.B (xxx).W */
{ CPUFUNC(op_44f9_0), 0, 17657 }, /* MV2SR.B (xxx).L */
{ CPUFUNC(op_44fa_0), 0, 17658 }, /* MV2SR.B (d16,PC) */
{ CPUFUNC(op_44fb_3), 0, 17659 }, /* MV2SR.B (d8,PC,Xn) */
{ CPUFUNC(op_44fc_0), 0, 17660 }, /* MV2SR.B #<data>.B */
{ CPUFUNC(op_4600_0), 0, 17920 }, /* NOT.B Dn */
{ CPUFUNC(op_4610_0), 0, 17936 }, /* NOT.B (An) */
{ CPUFUNC(op_4618_0), 0, 17944 }, /* NOT.B (An)+ */
{ CPUFUNC(op_4620_0), 0, 17952 }, /* NOT.B -(An) */
{ CPUFUNC(op_4628_0), 0, 17960 }, /* NOT.B (d16,An) */
{ CPUFUNC(op_4630_3), 0, 17968 }, /* NOT.B (d8,An,Xn) */
{ CPUFUNC(op_4638_0), 0, 17976 }, /* NOT.B (xxx).W */
{ CPUFUNC(op_4639_0), 0, 17977 }, /* NOT.B (xxx).L */
{ CPUFUNC(op_4640_0), 0, 17984 }, /* NOT.W Dn */
{ CPUFUNC(op_4650_0), 0, 18000 }, /* NOT.W (An) */
{ CPUFUNC(op_4658_0), 0, 18008 }, /* NOT.W (An)+ */
{ CPUFUNC(op_4660_0), 0, 18016 }, /* NOT.W -(An) */
{ CPUFUNC(op_4668_0), 0, 18024 }, /* NOT.W (d16,An) */
{ CPUFUNC(op_4670_3), 0, 18032 }, /* NOT.W (d8,An,Xn) */
{ CPUFUNC(op_4678_0), 0, 18040 }, /* NOT.W (xxx).W */
{ CPUFUNC(op_4679_0), 0, 18041 }, /* NOT.W (xxx).L */
{ CPUFUNC(op_4680_0), 0, 18048 }, /* NOT.L Dn */
{ CPUFUNC(op_4690_0), 0, 18064 }, /* NOT.L (An) */
{ CPUFUNC(op_4698_0), 0, 18072 }, /* NOT.L (An)+ */
{ CPUFUNC(op_46a0_0), 0, 18080 }, /* NOT.L -(An) */
{ CPUFUNC(op_46a8_0), 0, 18088 }, /* NOT.L (d16,An) */
{ CPUFUNC(op_46b0_3), 0, 18096 }, /* NOT.L (d8,An,Xn) */
{ CPUFUNC(op_46b8_0), 0, 18104 }, /* NOT.L (xxx).W */
{ CPUFUNC(op_46b9_0), 0, 18105 }, /* NOT.L (xxx).L */
{ CPUFUNC(op_46c0_0), 0, 18112 }, /* MV2SR.W Dn */
{ CPUFUNC(op_46d0_0), 0, 18128 }, /* MV2SR.W (An) */
{ CPUFUNC(op_46d8_0), 0, 18136 }, /* MV2SR.W (An)+ */
{ CPUFUNC(op_46e0_0), 0, 18144 }, /* MV2SR.W -(An) */
{ CPUFUNC(op_46e8_0), 0, 18152 }, /* MV2SR.W (d16,An) */
{ CPUFUNC(op_46f0_3), 0, 18160 }, /* MV2SR.W (d8,An,Xn) */
{ CPUFUNC(op_46f8_0), 0, 18168 }, /* MV2SR.W (xxx).W */
{ CPUFUNC(op_46f9_0), 0, 18169 }, /* MV2SR.W (xxx).L */
{ CPUFUNC(op_46fa_0), 0, 18170 }, /* MV2SR.W (d16,PC) */
{ CPUFUNC(op_46fb_3), 0, 18171 }, /* MV2SR.W (d8,PC,Xn) */
{ CPUFUNC(op_46fc_0), 0, 18172 }, /* MV2SR.W #<data>.W */
{ CPUFUNC(op_4800_1), 0, 18432 }, /* NBCD.B Dn */
{ CPUFUNC(op_4810_1), 0, 18448 }, /* NBCD.B (An) */
{ CPUFUNC(op_4818_1), 0, 18456 }, /* NBCD.B (An)+ */
{ CPUFUNC(op_4820_1), 0, 18464 }, /* NBCD.B -(An) */
{ CPUFUNC(op_4828_1), 0, 18472 }, /* NBCD.B (d16,An) */
{ CPUFUNC(op_4830_3), 0, 18480 }, /* NBCD.B (d8,An,Xn) */
{ CPUFUNC(op_4838_1), 0, 18488 }, /* NBCD.B (xxx).W */
{ CPUFUNC(op_4839_1), 0, 18489 }, /* NBCD.B (xxx).L */
{ CPUFUNC(op_4840_0), 0, 18496 }, /* SWAP.W Dn */
{ CPUFUNC_FF(op_4850_0), 0, 18512 }, /* PEA.L (An) */
{ CPUFUNC_FF(op_4868_0), 0, 18536 }, /* PEA.L (d16,An) */
{ CPUFUNC_FF(op_4870_3), 0, 18544 }, /* PEA.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4878_0), 0, 18552 }, /* PEA.L (xxx).W */
{ CPUFUNC_FF(op_4879_0), 0, 18553 }, /* PEA.L (xxx).L */
{ CPUFUNC_FF(op_487a_0), 0, 18554 }, /* PEA.L (d16,PC) */
{ CPUFUNC_FF(op_487b_3), 0, 18555 }, /* PEA.L (d8,PC,Xn) */
{ CPUFUNC(op_4880_0), 0, 18560 }, /* EXT.W Dn */
{ CPUFUNC_FF(op_4890_0), 0, 18576 }, /* MVMLE.W #<data>.W,(An) */
{ CPUFUNC_FF(op_48a0_0), 0, 18592 }, /* MVMLE.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_48a8_0), 0, 18600 }, /* MVMLE.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48b0_3), 0, 18608 }, /* MVMLE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48b8_0), 0, 18616 }, /* MVMLE.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48b9_0), 0, 18617 }, /* MVMLE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_48c0_0), 0, 18624 }, /* EXT.L Dn */
{ CPUFUNC_FF(op_48d0_0), 0, 18640 }, /* MVMLE.L #<data>.W,(An) */
{ CPUFUNC_FF(op_48e0_0), 0, 18656 }, /* MVMLE.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_48e8_0), 0, 18664 }, /* MVMLE.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48f0_3), 0, 18672 }, /* MVMLE.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48f8_0), 0, 18680 }, /* MVMLE.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48f9_0), 0, 18681 }, /* MVMLE.L #<data>.W,(xxx).L */
{ CPUFUNC(op_49c0_0), 0, 18880 }, /* EXT.B Dn */
{ CPUFUNC(op_4a00_0), 0, 18944 }, /* TST.B Dn */
{ CPUFUNC(op_4a10_0), 0, 18960 }, /* TST.B (An) */
{ CPUFUNC(op_4a18_0), 0, 18968 }, /* TST.B (An)+ */
{ CPUFUNC(op_4a20_0), 0, 18976 }, /* TST.B -(An) */
{ CPUFUNC(op_4a28_0), 0, 18984 }, /* TST.B (d16,An) */
{ CPUFUNC(op_4a30_3), 0, 18992 }, /* TST.B (d8,An,Xn) */
{ CPUFUNC(op_4a38_0), 0, 19000 }, /* TST.B (xxx).W */
{ CPUFUNC(op_4a39_0), 0, 19001 }, /* TST.B (xxx).L */
{ CPUFUNC(op_4a3a_0), 0, 19002 }, /* TST.B (d16,PC) */
{ CPUFUNC(op_4a3b_3), 0, 19003 }, /* TST.B (d8,PC,Xn) */
{ CPUFUNC(op_4a3c_0), 0, 19004 }, /* TST.B #<data>.B */
{ CPUFUNC(op_4a40_0), 0, 19008 }, /* TST.W Dn */
{ CPUFUNC(op_4a48_0), 0, 19016 }, /* TST.W An */
{ CPUFUNC(op_4a50_0), 0, 19024 }, /* TST.W (An) */
{ CPUFUNC(op_4a58_0), 0, 19032 }, /* TST.W (An)+ */
{ CPUFUNC(op_4a60_0), 0, 19040 }, /* TST.W -(An) */
{ CPUFUNC(op_4a68_0), 0, 19048 }, /* TST.W (d16,An) */
{ CPUFUNC(op_4a70_3), 0, 19056 }, /* TST.W (d8,An,Xn) */
{ CPUFUNC(op_4a78_0), 0, 19064 }, /* TST.W (xxx).W */
{ CPUFUNC(op_4a79_0), 0, 19065 }, /* TST.W (xxx).L */
{ CPUFUNC(op_4a7a_0), 0, 19066 }, /* TST.W (d16,PC) */
{ CPUFUNC(op_4a7b_3), 0, 19067 }, /* TST.W (d8,PC,Xn) */
{ CPUFUNC(op_4a7c_0), 0, 19068 }, /* TST.W #<data>.W */
{ CPUFUNC(op_4a80_0), 0, 19072 }, /* TST.L Dn */
{ CPUFUNC(op_4a88_0), 0, 19080 }, /* TST.L An */
{ CPUFUNC(op_4a90_0), 0, 19088 }, /* TST.L (An) */
{ CPUFUNC(op_4a98_0), 0, 19096 }, /* TST.L (An)+ */
{ CPUFUNC(op_4aa0_0), 0, 19104 }, /* TST.L -(An) */
{ CPUFUNC(op_4aa8_0), 0, 19112 }, /* TST.L (d16,An) */
{ CPUFUNC(op_4ab0_3), 0, 19120 }, /* TST.L (d8,An,Xn) */
{ CPUFUNC(op_4ab8_0), 0, 19128 }, /* TST.L (xxx).W */
{ CPUFUNC(op_4ab9_0), 0, 19129 }, /* TST.L (xxx).L */
{ CPUFUNC(op_4aba_0), 0, 19130 }, /* TST.L (d16,PC) */
{ CPUFUNC(op_4abb_3), 0, 19131 }, /* TST.L (d8,PC,Xn) */
{ CPUFUNC(op_4abc_0), 0, 19132 }, /* TST.L #<data>.L */
{ CPUFUNC(op_4ac0_0), 0, 19136 }, /* TAS.B Dn */
{ CPUFUNC(op_4ad0_0), 0, 19152 }, /* TAS.B (An) */
{ CPUFUNC(op_4ad8_0), 0, 19160 }, /* TAS.B (An)+ */
{ CPUFUNC(op_4ae0_0), 0, 19168 }, /* TAS.B -(An) */
{ CPUFUNC(op_4ae8_0), 0, 19176 }, /* TAS.B (d16,An) */
{ CPUFUNC(op_4af0_3), 0, 19184 }, /* TAS.B (d8,An,Xn) */
{ CPUFUNC(op_4af8_0), 0, 19192 }, /* TAS.B (xxx).W */
{ CPUFUNC(op_4af9_0), 0, 19193 }, /* TAS.B (xxx).L */
{ CPUFUNC_FF(op_4c90_0), 0, 19600 }, /* MVMEL.W #<data>.W,(An) */
{ CPUFUNC_FF(op_4c98_0), 0, 19608 }, /* MVMEL.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ca8_0), 0, 19624 }, /* MVMEL.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cb0_3), 0, 19632 }, /* MVMEL.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cb8_0), 0, 19640 }, /* MVMEL.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cb9_0), 0, 19641 }, /* MVMEL.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cba_0), 0, 19642 }, /* MVMEL.W #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cbb_3), 0, 19643 }, /* MVMEL.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4cd0_0), 0, 19664 }, /* MVMEL.L #<data>.W,(An) */
{ CPUFUNC_FF(op_4cd8_0), 0, 19672 }, /* MVMEL.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ce8_0), 0, 19688 }, /* MVMEL.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cf0_3), 0, 19696 }, /* MVMEL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cf8_0), 0, 19704 }, /* MVMEL.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cf9_0), 0, 19705 }, /* MVMEL.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cfa_0), 0, 19706 }, /* MVMEL.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cfb_3), 0, 19707 }, /* MVMEL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4e40_0), 0, 20032 }, /* TRAP.L #<data> */
{ CPUFUNC_FF(op_4e50_0), 0, 20048 }, /* LINK.W An,#<data>.W */
{ CPUFUNC_FF(op_4e58_0), 0, 20056 }, /* UNLK.L An */
{ CPUFUNC_FF(op_4e60_0), 0, 20064 }, /* MVR2USP.L An */
{ CPUFUNC_FF(op_4e68_0), 0, 20072 }, /* MVUSP2R.L An */
{ CPUFUNC_FF(op_4e70_0), 0, 20080 }, /* RESET.L  */
{ CPUFUNC_FF(op_4e71_0), 0, 20081 }, /* NOP.L  */
{ CPUFUNC(op_4e72_0), 0, 20082 }, /* STOP.L #<data>.W */
{ CPUFUNC(op_4e73_0), 0, 20083 }, /* RTE.L  */
{ CPUFUNC_FF(op_4e74_0), 0, 20084 }, /* RTD.L #<data>.W */
{ CPUFUNC_FF(op_4e75_0), 0, 20085 }, /* RTS.L  */
{ CPUFUNC_FF(op_4e76_0), 0, 20086 }, /* TRAPV.L  */
{ CPUFUNC(op_4e77_0), 0, 20087 }, /* RTR.L  */
{ CPUFUNC_FF(op_4e7a_0), 0, 20090 }, /* MOVEC2.L #<data>.W */
{ CPUFUNC_FF(op_4e7b_0), 0, 20091 }, /* MOVE2C.L #<data>.W */
{ CPUFUNC_FF(op_4e90_0), 0, 20112 }, /* JSR.L (An) */
{ CPUFUNC_FF(op_4ea8_0), 0, 20136 }, /* JSR.L (d16,An) */
{ CPUFUNC_FF(op_4eb0_3), 0, 20144 }, /* JSR.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4eb8_0), 0, 20152 }, /* JSR.L (xxx).W */
{ CPUFUNC_FF(op_4eb9_0), 0, 20153 }, /* JSR.L (xxx).L */
{ CPUFUNC_FF(op_4eba_0), 0, 20154 }, /* JSR.L (d16,PC) */
{ CPUFUNC_FF(op_4ebb_3), 0, 20155 }, /* JSR.L (d8,PC,Xn) */
{ CPUFUNC_FF(op_4ed0_0), 0, 20176 }, /* JMP.L (An) */
{ CPUFUNC_FF(op_4ee8_0), 0, 20200 }, /* JMP.L (d16,An) */
{ CPUFUNC_FF(op_4ef0_3), 0, 20208 }, /* JMP.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4ef8_0), 0, 20216 }, /* JMP.L (xxx).W */
{ CPUFUNC_FF(op_4ef9_0), 0, 20217 }, /* JMP.L (xxx).L */
{ CPUFUNC_FF(op_4efa_0), 0, 20218 }, /* JMP.L (d16,PC) */
{ CPUFUNC_FF(op_4efb_3), 0, 20219 }, /* JMP.L (d8,PC,Xn) */
{ CPUFUNC(op_5000_0), 0, 20480 }, /* ADD.B #<data>,Dn */
{ CPUFUNC(op_5010_0), 0, 20496 }, /* ADD.B #<data>,(An) */
{ CPUFUNC(op_5018_0), 0, 20504 }, /* ADD.B #<data>,(An)+ */
{ CPUFUNC(op_5020_0), 0, 20512 }, /* ADD.B #<data>,-(An) */
{ CPUFUNC(op_5028_0), 0, 20520 }, /* ADD.B #<data>,(d16,An) */
{ CPUFUNC(op_5030_3), 0, 20528 }, /* ADD.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5038_0), 0, 20536 }, /* ADD.B #<data>,(xxx).W */
{ CPUFUNC(op_5039_0), 0, 20537 }, /* ADD.B #<data>,(xxx).L */
{ CPUFUNC(op_5040_0), 0, 20544 }, /* ADD.W #<data>,Dn */
{ CPUFUNC_FF(op_5048_0), 0, 20552 }, /* ADDA.W #<data>,An */
{ CPUFUNC(op_5050_0), 0, 20560 }, /* ADD.W #<data>,(An) */
{ CPUFUNC(op_5058_0), 0, 20568 }, /* ADD.W #<data>,(An)+ */
{ CPUFUNC(op_5060_0), 0, 20576 }, /* ADD.W #<data>,-(An) */
{ CPUFUNC(op_5068_0), 0, 20584 }, /* ADD.W #<data>,(d16,An) */
{ CPUFUNC(op_5070_3), 0, 20592 }, /* ADD.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5078_0), 0, 20600 }, /* ADD.W #<data>,(xxx).W */
{ CPUFUNC(op_5079_0), 0, 20601 }, /* ADD.W #<data>,(xxx).L */
{ CPUFUNC(op_5080_0), 0, 20608 }, /* ADD.L #<data>,Dn */
{ CPUFUNC_FF(op_5088_0), 0, 20616 }, /* ADDA.L #<data>,An */
{ CPUFUNC(op_5090_0), 0, 20624 }, /* ADD.L #<data>,(An) */
{ CPUFUNC(op_5098_0), 0, 20632 }, /* ADD.L #<data>,(An)+ */
{ CPUFUNC(op_50a0_0), 0, 20640 }, /* ADD.L #<data>,-(An) */
{ CPUFUNC(op_50a8_0), 0, 20648 }, /* ADD.L #<data>,(d16,An) */
{ CPUFUNC(op_50b0_3), 0, 20656 }, /* ADD.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_50b8_0), 0, 20664 }, /* ADD.L #<data>,(xxx).W */
{ CPUFUNC(op_50b9_0), 0, 20665 }, /* ADD.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_50c0_0), 0, 20672 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_50c8_0), 0, 20680 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_50d0_0), 0, 20688 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_50d8_0), 0, 20696 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_50e0_0), 0, 20704 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_50e8_0), 0, 20712 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_50f0_3), 0, 20720 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_50f8_0), 0, 20728 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_50f9_0), 0, 20729 }, /* Scc.B (xxx).L */
{ CPUFUNC(op_5100_0), 0, 20736 }, /* SUB.B #<data>,Dn */
{ CPUFUNC(op_5110_0), 0, 20752 }, /* SUB.B #<data>,(An) */
{ CPUFUNC(op_5118_0), 0, 20760 }, /* SUB.B #<data>,(An)+ */
{ CPUFUNC(op_5120_0), 0, 20768 }, /* SUB.B #<data>,-(An) */
{ CPUFUNC(op_5128_0), 0, 20776 }, /* SUB.B #<data>,(d16,An) */
{ CPUFUNC(op_5130_3), 0, 20784 }, /* SUB.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5138_0), 0, 20792 }, /* SUB.B #<data>,(xxx).W */
{ CPUFUNC(op_5139_0), 0, 20793 }, /* SUB.B #<data>,(xxx).L */
{ CPUFUNC(op_5140_0), 0, 20800 }, /* SUB.W #<data>,Dn */
{ CPUFUNC_FF(op_5148_0), 0, 20808 }, /* SUBA.W #<data>,An */
{ CPUFUNC(op_5150_0), 0, 20816 }, /* SUB.W #<data>,(An) */
{ CPUFUNC(op_5158_0), 0, 20824 }, /* SUB.W #<data>,(An)+ */
{ CPUFUNC(op_5160_0), 0, 20832 }, /* SUB.W #<data>,-(An) */
{ CPUFUNC(op_5168_0), 0, 20840 }, /* SUB.W #<data>,(d16,An) */
{ CPUFUNC(op_5170_3), 0, 20848 }, /* SUB.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5178_0), 0, 20856 }, /* SUB.W #<data>,(xxx).W */
{ CPUFUNC(op_5179_0), 0, 20857 }, /* SUB.W #<data>,(xxx).L */
{ CPUFUNC(op_5180_0), 0, 20864 }, /* SUB.L #<data>,Dn */
{ CPUFUNC_FF(op_5188_0), 0, 20872 }, /* SUBA.L #<data>,An */
{ CPUFUNC(op_5190_0), 0, 20880 }, /* SUB.L #<data>,(An) */
{ CPUFUNC(op_5198_0), 0, 20888 }, /* SUB.L #<data>,(An)+ */
{ CPUFUNC(op_51a0_0), 0, 20896 }, /* SUB.L #<data>,-(An) */
{ CPUFUNC(op_51a8_0), 0, 20904 }, /* SUB.L #<data>,(d16,An) */
{ CPUFUNC(op_51b0_3), 0, 20912 }, /* SUB.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_51b8_0), 0, 20920 }, /* SUB.L #<data>,(xxx).W */
{ CPUFUNC(op_51b9_0), 0, 20921 }, /* SUB.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_51c0_0), 0, 20928 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_51c8_0), 0, 20936 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_51d0_0), 0, 20944 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_51d8_0), 0, 20952 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_51e0_0), 0, 20960 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_51e8_0), 0, 20968 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_51f0_3), 0, 20976 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_51f8_0), 0, 20984 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_51f9_0), 0, 20985 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_52c0_0), 0, 21184 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_52c8_0), 0, 21192 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_52d0_0), 0, 21200 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_52d8_0), 0, 21208 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_52e0_0), 0, 21216 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_52e8_0), 0, 21224 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_52f0_3), 0, 21232 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_52f8_0), 0, 21240 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_52f9_0), 0, 21241 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_53c0_0), 0, 21440 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_53c8_0), 0, 21448 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_53d0_0), 0, 21456 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_53d8_0), 0, 21464 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_53e0_0), 0, 21472 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_53e8_0), 0, 21480 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_53f0_3), 0, 21488 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_53f8_0), 0, 21496 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_53f9_0), 0, 21497 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_54c0_0), 0, 21696 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_54c8_0), 0, 21704 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_54d0_0), 0, 21712 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_54d8_0), 0, 21720 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_54e0_0), 0, 21728 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_54e8_0), 0, 21736 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_54f0_3), 0, 21744 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_54f8_0), 0, 21752 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_54f9_0), 0, 21753 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_55c0_0), 0, 21952 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_55c8_0), 0, 21960 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_55d0_0), 0, 21968 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_55d8_0), 0, 21976 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_55e0_0), 0, 21984 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_55e8_0), 0, 21992 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_55f0_3), 0, 22000 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_55f8_0), 0, 22008 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_55f9_0), 0, 22009 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_56c0_0), 0, 22208 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_56c8_0), 0, 22216 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_56d0_0), 0, 22224 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_56d8_0), 0, 22232 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_56e0_0), 0, 22240 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_56e8_0), 0, 22248 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_56f0_3), 0, 22256 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_56f8_0), 0, 22264 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_56f9_0), 0, 22265 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_57c0_0), 0, 22464 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_57c8_0), 0, 22472 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_57d0_0), 0, 22480 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_57d8_0), 0, 22488 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_57e0_0), 0, 22496 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_57e8_0), 0, 22504 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_57f0_3), 0, 22512 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_57f8_0), 0, 22520 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_57f9_0), 0, 22521 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_58c0_0), 0, 22720 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_58c8_0), 0, 22728 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_58d0_0), 0, 22736 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_58d8_0), 0, 22744 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_58e0_0), 0, 22752 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_58e8_0), 0, 22760 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_58f0_3), 0, 22768 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_58f8_0), 0, 22776 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_58f9_0), 0, 22777 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_59c0_0), 0, 22976 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_59c8_0), 0, 22984 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_59d0_0), 0, 22992 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_59d8_0), 0, 23000 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_59e0_0), 0, 23008 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_59e8_0), 0, 23016 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_59f0_3), 0, 23024 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_59f8_0), 0, 23032 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_59f9_0), 0, 23033 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ac0_0), 0, 23232 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ac8_0), 0, 23240 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ad0_0), 0, 23248 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ad8_0), 0, 23256 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ae0_0), 0, 23264 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ae8_0), 0, 23272 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5af0_3), 0, 23280 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5af8_0), 0, 23288 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5af9_0), 0, 23289 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5bc0_0), 0, 23488 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5bc8_0), 0, 23496 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5bd0_0), 0, 23504 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5bd8_0), 0, 23512 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5be0_0), 0, 23520 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5be8_0), 0, 23528 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5bf0_3), 0, 23536 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5bf8_0), 0, 23544 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5bf9_0), 0, 23545 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5cc0_0), 0, 23744 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5cc8_0), 0, 23752 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5cd0_0), 0, 23760 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5cd8_0), 0, 23768 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ce0_0), 0, 23776 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ce8_0), 0, 23784 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5cf0_3), 0, 23792 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5cf8_0), 0, 23800 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5cf9_0), 0, 23801 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5dc0_0), 0, 24000 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5dc8_0), 0, 24008 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5dd0_0), 0, 24016 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5dd8_0), 0, 24024 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5de0_0), 0, 24032 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5de8_0), 0, 24040 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5df0_3), 0, 24048 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5df8_0), 0, 24056 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5df9_0), 0, 24057 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ec0_0), 0, 24256 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ec8_0), 0, 24264 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ed0_0), 0, 24272 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ed8_0), 0, 24280 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ee0_0), 0, 24288 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ee8_0), 0, 24296 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ef0_3), 0, 24304 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ef8_0), 0, 24312 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ef9_0), 0, 24313 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5fc0_0), 0, 24512 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5fc8_0), 0, 24520 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5fd0_0), 0, 24528 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5fd8_0), 0, 24536 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5fe0_0), 0, 24544 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5fe8_0), 0, 24552 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ff0_3), 0, 24560 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ff8_0), 0, 24568 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ff9_0), 0, 24569 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_6000_0), 0, 24576 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6001_0), 0, 24577 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_60ff_3), 0, 24831 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6100_0), 0, 24832 }, /* BSR.W #<data>.W */
{ CPUFUNC_FF(op_6101_0), 0, 24833 }, /* BSR.B #<data> */
{ CPUFUNC_FF(op_61ff_0), 0, 25087 }, /* BSR.L #<data>.L */
{ CPUFUNC_FF(op_6200_0), 0, 25088 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6201_0), 0, 25089 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_62ff_3), 0, 25343 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6300_0), 0, 25344 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6301_0), 0, 25345 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_63ff_3), 0, 25599 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6400_0), 0, 25600 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6401_0), 0, 25601 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_64ff_3), 0, 25855 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6500_0), 0, 25856 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6501_0), 0, 25857 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_65ff_3), 0, 26111 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6600_0), 0, 26112 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6601_0), 0, 26113 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_66ff_3), 0, 26367 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6700_0), 0, 26368 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6701_0), 0, 26369 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_67ff_3), 0, 26623 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6800_0), 0, 26624 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6801_0), 0, 26625 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_68ff_3), 0, 26879 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6900_0), 0, 26880 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6901_0), 0, 26881 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_69ff_3), 0, 27135 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6a00_0), 0, 27136 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6a01_0), 0, 27137 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6aff_3), 0, 27391 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6b00_0), 0, 27392 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6b01_0), 0, 27393 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6bff_3), 0, 27647 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6c00_0), 0, 27648 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6c01_0), 0, 27649 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6cff_3), 0, 27903 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6d00_0), 0, 27904 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6d01_0), 0, 27905 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6dff_3), 0, 28159 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6e00_0), 0, 28160 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6e01_0), 0, 28161 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6eff_3), 0, 28415 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6f00_0), 0, 28416 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6f01_0), 0, 28417 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6fff_3), 0, 28671 }, /* Bcc.L #<data>.L */
{ CPUFUNC(op_7000_0), 0, 28672 }, /* MOVE.L #<data>,Dn */
{ CPUFUNC_FF(op_7100_0), 0, 28928 }, /* EMULOP_RETURN.L  */
{ CPUFUNC_FF(op_7101_0), 0, 28929 }, /* EMULOP.L #<data> */
{ CPUFUNC(op_8000_0), 0, 32768 }, /* OR.B Dn,Dn */
{ CPUFUNC(op_8010_0), 0, 32784 }, /* OR.B (An),Dn */
{ CPUFUNC(op_8018_0), 0, 32792 }, /* OR.B (An)+,Dn */
{ CPUFUNC(op_8020_0), 0, 32800 }, /* OR.B -(An),Dn */
{ CPUFUNC(op_8028_0), 0, 32808 }, /* OR.B (d16,An),Dn */
{ CPUFUNC(op_8030_3), 0, 32816 }, /* OR.B (d8,An,Xn),Dn */
{ CPUFUNC(op_8038_0), 0, 32824 }, /* OR.B (xxx).W,Dn */
{ CPUFUNC(op_8039_0), 0, 32825 }, /* OR.B (xxx).L,Dn */
{ CPUFUNC(op_803a_0), 0, 32826 }, /* OR.B (d16,PC),Dn */
{ CPUFUNC(op_803b_3), 0, 32827 }, /* OR.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_803c_0), 0, 32828 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_8040_0), 0, 32832 }, /* OR.W Dn,Dn */
{ CPUFUNC(op_8050_0), 0, 32848 }, /* OR.W (An),Dn */
{ CPUFUNC(op_8058_0), 0, 32856 }, /* OR.W (An)+,Dn */
{ CPUFUNC(op_8060_0), 0, 32864 }, /* OR.W -(An),Dn */
{ CPUFUNC(op_8068_0), 0, 32872 }, /* OR.W (d16,An),Dn */
{ CPUFUNC(op_8070_3), 0, 32880 }, /* OR.W (d8,An,Xn),Dn */
{ CPUFUNC(op_8078_0), 0, 32888 }, /* OR.W (xxx).W,Dn */
{ CPUFUNC(op_8079_0), 0, 32889 }, /* OR.W (xxx).L,Dn */
{ CPUFUNC(op_807a_0), 0, 32890 }, /* OR.W (d16,PC),Dn */
{ CPUFUNC(op_807b_3), 0, 32891 }, /* OR.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_807c_0), 0, 32892 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_8080_0), 0, 32896 }, /* OR.L Dn,Dn */
{ CPUFUNC(op_8090_0), 0, 32912 }, /* OR.L (An),Dn */
{ CPUFUNC(op_8098_0), 0, 32920 }, /* OR.L (An)+,Dn */
{ CPUFUNC(op_80a0_0), 0, 32928 }, /* OR.L -(An),Dn */
{ CPUFUNC(op_80a8_0), 0, 32936 }, /* OR.L (d16,An),Dn */
{ CPUFUNC(op_80b0_3), 0, 32944 }, /* OR.L (d8,An,Xn),Dn */
{ CPUFUNC(op_80b8_0), 0, 32952 }, /* OR.L (xxx).W,Dn */
{ CPUFUNC(op_80b9_0), 0, 32953 }, /* OR.L (xxx).L,Dn */
{ CPUFUNC(op_80ba_0), 0, 32954 }, /* OR.L (d16,PC),Dn */
{ CPUFUNC(op_80bb_3), 0, 32955 }, /* OR.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_80bc_0), 0, 32956 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_80c0_0), 0, 32960 }, /* DIVU.W Dn,Dn */
{ CPUFUNC(op_80d0_0), 0, 32976 }, /* DIVU.W (An),Dn */
{ CPUFUNC(op_80d8_0), 0, 32984 }, /* DIVU.W (An)+,Dn */
{ CPUFUNC(op_80e0_0), 0, 32992 }, /* DIVU.W -(An),Dn */
{ CPUFUNC(op_80e8_0), 0, 33000 }, /* DIVU.W (d16,An),Dn */
{ CPUFUNC(op_80f0_3), 0, 33008 }, /* DIVU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_80f8_0), 0, 33016 }, /* DIVU.W (xxx).W,Dn */
{ CPUFUNC(op_80f9_0), 0, 33017 }, /* DIVU.W (xxx).L,Dn */
{ CPUFUNC(op_80fa_0), 0, 33018 }, /* DIVU.W (d16,PC),Dn */
{ CPUFUNC(op_80fb_3), 0, 33019 }, /* DIVU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_80fc_0), 0, 33020 }, /* DIVU.W #<data>.W,Dn */
{ CPUFUNC(op_8100_1), 0, 33024 }, /* SBCD.B Dn,Dn */
{ CPUFUNC(op_8108_1), 0, 33032 }, /* SBCD.B -(An),-(An) */
{ CPUFUNC(op_8110_0), 0, 33040 }, /* OR.B Dn,(An) */
{ CPUFUNC(op_8118_0), 0, 33048 }, /* OR.B Dn,(An)+ */
{ CPUFUNC(op_8120_0), 0, 33056 }, /* OR.B Dn,-(An) */
{ CPUFUNC(op_8128_0), 0, 33064 }, /* OR.B Dn,(d16,An) */
{ CPUFUNC(op_8130_3), 0, 33072 }, /* OR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_8138_0), 0, 33080 }, /* OR.B Dn,(xxx).W */
{ CPUFUNC(op_8139_0), 0, 33081 }, /* OR.B Dn,(xxx).L */
{ CPUFUNC(op_8150_0), 0, 33104 }, /* OR.W Dn,(An) */
{ CPUFUNC(op_8158_0), 0, 33112 }, /* OR.W Dn,(An)+ */
{ CPUFUNC(op_8160_0), 0, 33120 }, /* OR.W Dn,-(An) */
{ CPUFUNC(op_8168_0), 0, 33128 }, /* OR.W Dn,(d16,An) */
{ CPUFUNC(op_8170_3), 0, 33136 }, /* OR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_8178_0), 0, 33144 }, /* OR.W Dn,(xxx).W */
{ CPUFUNC(op_8179_0), 0, 33145 }, /* OR.W Dn,(xxx).L */
{ CPUFUNC(op_8190_0), 0, 33168 }, /* OR.L Dn,(An) */
{ CPUFUNC(op_8198_0), 0, 33176 }, /* OR.L Dn,(An)+ */
{ CPUFUNC(op_81a0_0), 0, 33184 }, /* OR.L Dn,-(An) */
{ CPUFUNC(op_81a8_0), 0, 33192 }, /* OR.L Dn,(d16,An) */
{ CPUFUNC(op_81b0_3), 0, 33200 }, /* OR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_81b8_0), 0, 33208 }, /* OR.L Dn,(xxx).W */
{ CPUFUNC(op_81b9_0), 0, 33209 }, /* OR.L Dn,(xxx).L */
{ CPUFUNC(op_81c0_0), 0, 33216 }, /* DIVS.W Dn,Dn */
{ CPUFUNC(op_81d0_0), 0, 33232 }, /* DIVS.W (An),Dn */
{ CPUFUNC(op_81d8_0), 0, 33240 }, /* DIVS.W (An)+,Dn */
{ CPUFUNC(op_81e0_0), 0, 33248 }, /* DIVS.W -(An),Dn */
{ CPUFUNC(op_81e8_0), 0, 33256 }, /* DIVS.W (d16,An),Dn */
{ CPUFUNC(op_81f0_3), 0, 33264 }, /* DIVS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_81f8_0), 0, 33272 }, /* DIVS.W (xxx).W,Dn */
{ CPUFUNC(op_81f9_0), 0, 33273 }, /* DIVS.W (xxx).L,Dn */
{ CPUFUNC(op_81fa_0), 0, 33274 }, /* DIVS.W (d16,PC),Dn */
{ CPUFUNC(op_81fb_3), 0, 33275 }, /* DIVS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_81fc_0), 0, 33276 }, /* DIVS.W #<data>.W,Dn */
{ CPUFUNC(op_9000_0), 0, 36864 }, /* SUB.B Dn,Dn */
{ CPUFUNC(op_9010_0), 0, 36880 }, /* SUB.B (An),Dn */
{ CPUFUNC(op_9018_0), 0, 36888 }, /* SUB.B (An)+,Dn */
{ CPUFUNC(op_9020_0), 0, 36896 }, /* SUB.B -(An),Dn */
{ CPUFUNC(op_9028_0), 0, 36904 }, /* SUB.B (d16,An),Dn */
{ CPUFUNC(op_9030_3), 0, 36912 }, /* SUB.B (d8,An,Xn),Dn */
{ CPUFUNC(op_9038_0), 0, 36920 }, /* SUB.B (xxx).W,Dn */
{ CPUFUNC(op_9039_0), 0, 36921 }, /* SUB.B (xxx).L,Dn */
{ CPUFUNC(op_903a_0), 0, 36922 }, /* SUB.B (d16,PC),Dn */
{ CPUFUNC(op_903b_3), 0, 36923 }, /* SUB.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_903c_0), 0, 36924 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_9040_0), 0, 36928 }, /* SUB.W Dn,Dn */
{ CPUFUNC(op_9048_0), 0, 36936 }, /* SUB.W An,Dn */
{ CPUFUNC(op_9050_0), 0, 36944 }, /* SUB.W (An),Dn */
{ CPUFUNC(op_9058_0), 0, 36952 }, /* SUB.W (An)+,Dn */
{ CPUFUNC(op_9060_0), 0, 36960 }, /* SUB.W -(An),Dn */
{ CPUFUNC(op_9068_0), 0, 36968 }, /* SUB.W (d16,An),Dn */
{ CPUFUNC(op_9070_3), 0, 36976 }, /* SUB.W (d8,An,Xn),Dn */
{ CPUFUNC(op_9078_0), 0, 36984 }, /* SUB.W (xxx).W,Dn */
{ CPUFUNC(op_9079_0), 0, 36985 }, /* SUB.W (xxx).L,Dn */
{ CPUFUNC(op_907a_0), 0, 36986 }, /* SUB.W (d16,PC),Dn */
{ CPUFUNC(op_907b_3), 0, 36987 }, /* SUB.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_907c_0), 0, 36988 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_9080_0), 0, 36992 }, /* SUB.L Dn,Dn */
{ CPUFUNC(op_9088_0), 0, 37000 }, /* SUB.L An,Dn */
{ CPUFUNC(op_9090_0), 0, 37008 }, /* SUB.L (An),Dn */
{ CPUFUNC(op_9098_0), 0, 37016 }, /* SUB.L (An)+,Dn */
{ CPUFUNC(op_90a0_0), 0, 37024 }, /* SUB.L -(An),Dn */
{ CPUFUNC(op_90a8_0), 0, 37032 }, /* SUB.L (d16,An),Dn */
{ CPUFUNC(op_90b0_3), 0, 37040 }, /* SUB.L (d8,An,Xn),Dn */
{ CPUFUNC(op_90b8_0), 0, 37048 }, /* SUB.L (xxx).W,Dn */
{ CPUFUNC(op_90b9_0), 0, 37049 }, /* SUB.L (xxx).L,Dn */
{ CPUFUNC(op_90ba_0), 0, 37050 }, /* SUB.L (d16,PC),Dn */
{ CPUFUNC(op_90bb_3), 0, 37051 }, /* SUB.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_90bc_0), 0, 37052 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC_FF(op_90c0_0), 0, 37056 }, /* SUBA.W Dn,An */
{ CPUFUNC_FF(op_90c8_0), 0, 37064 }, /* SUBA.W An,An */
{ CPUFUNC_FF(op_90d0_0), 0, 37072 }, /* SUBA.W (An),An */
{ CPUFUNC_FF(op_90d8_0), 0, 37080 }, /* SUBA.W (An)+,An */
{ CPUFUNC_FF(op_90e0_0), 0, 37088 }, /* SUBA.W -(An),An */
{ CPUFUNC_FF(op_90e8_0), 0, 37096 }, /* SUBA.W (d16,An),An */
{ CPUFUNC_FF(op_90f0_3), 0, 37104 }, /* SUBA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_90f8_0), 0, 37112 }, /* SUBA.W (xxx).W,An */
{ CPUFUNC_FF(op_90f9_0), 0, 37113 }, /* SUBA.W (xxx).L,An */
{ CPUFUNC_FF(op_90fa_0), 0, 37114 }, /* SUBA.W (d16,PC),An */
{ CPUFUNC_FF(op_90fb_3), 0, 37115 }, /* SUBA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_90fc_0), 0, 37116 }, /* SUBA.W #<data>.W,An */
{ CPUFUNC(op_9100_0), 0, 37120 }, /* SUBX.B Dn,Dn */
{ CPUFUNC(op_9108_0), 0, 37128 }, /* SUBX.B -(An),-(An) */
{ CPUFUNC(op_9110_0), 0, 37136 }, /* SUB.B Dn,(An) */
{ CPUFUNC(op_9118_0), 0, 37144 }, /* SUB.B Dn,(An)+ */
{ CPUFUNC(op_9120_0), 0, 37152 }, /* SUB.B Dn,-(An) */
{ CPUFUNC(op_9128_0), 0, 37160 }, /* SUB.B Dn,(d16,An) */
{ CPUFUNC(op_9130_3), 0, 37168 }, /* SUB.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_9138_0), 0, 37176 }, /* SUB.B Dn,(xxx).W */
{ CPUFUNC(op_9139_0), 0, 37177 }, /* SUB.B Dn,(xxx).L */
{ CPUFUNC(op_9140_0), 0, 37184 }, /* SUBX.W Dn,Dn */
{ CPUFUNC(op_9148_0), 0, 37192 }, /* SUBX.W -(An),-(An) */
{ CPUFUNC(op_9150_0), 0, 37200 }, /* SUB.W Dn,(An) */
{ CPUFUNC(op_9158_0), 0, 37208 }, /* SUB.W Dn,(An)+ */
{ CPUFUNC(op_9160_0), 0, 37216 }, /* SUB.W Dn,-(An) */
{ CPUFUNC(op_9168_0), 0, 37224 }, /* SUB.W Dn,(d16,An) */
{ CPUFUNC(op_9170_3), 0, 37232 }, /* SUB.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_9178_0), 0, 37240 }, /* SUB.W Dn,(xxx).W */
{ CPUFUNC(op_9179_0), 0, 37241 }, /* SUB.W Dn,(xxx).L */
{ CPUFUNC(op_9180_0), 0, 37248 }, /* SUBX.L Dn,Dn */
{ CPUFUNC(op_9188_0), 0, 37256 }, /* SUBX.L -(An),-(An) */
{ CPUFUNC(op_9190_0), 0, 37264 }, /* SUB.L Dn,(An) */
{ CPUFUNC(op_9198_0), 0, 37272 }, /* SUB.L Dn,(An)+ */
{ CPUFUNC(op_91a0_0), 0, 37280 }, /* SUB.L Dn,-(An) */
{ CPUFUNC(op_91a8_0), 0, 37288 }, /* SUB.L Dn,(d16,An) */
{ CPUFUNC(op_91b0_3), 0, 37296 }, /* SUB.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_91b8_0), 0, 37304 }, /* SUB.L Dn,(xxx).W */
{ CPUFUNC(op_91b9_0), 0, 37305 }, /* SUB.L Dn,(xxx).L */
{ CPUFUNC_FF(op_91c0_0), 0, 37312 }, /* SUBA.L Dn,An */
{ CPUFUNC_FF(op_91c8_0), 0, 37320 }, /* SUBA.L An,An */
{ CPUFUNC_FF(op_91d0_0), 0, 37328 }, /* SUBA.L (An),An */
{ CPUFUNC_FF(op_91d8_0), 0, 37336 }, /* SUBA.L (An)+,An */
{ CPUFUNC_FF(op_91e0_0), 0, 37344 }, /* SUBA.L -(An),An */
{ CPUFUNC_FF(op_91e8_0), 0, 37352 }, /* SUBA.L (d16,An),An */
{ CPUFUNC_FF(op_91f0_3), 0, 37360 }, /* SUBA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_91f8_0), 0, 37368 }, /* SUBA.L (xxx).W,An */
{ CPUFUNC_FF(op_91f9_0), 0, 37369 }, /* SUBA.L (xxx).L,An */
{ CPUFUNC_FF(op_91fa_0), 0, 37370 }, /* SUBA.L (d16,PC),An */
{ CPUFUNC_FF(op_91fb_3), 0, 37371 }, /* SUBA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_91fc_0), 0, 37372 }, /* SUBA.L #<data>.L,An */
{ CPUFUNC(op_b000_0), 0, 45056 }, /* CMP.B Dn,Dn */
{ CPUFUNC(op_b010_0), 0, 45072 }, /* CMP.B (An),Dn */
{ CPUFUNC(op_b018_0), 0, 45080 }, /* CMP.B (An)+,Dn */
{ CPUFUNC(op_b020_0), 0, 45088 }, /* CMP.B -(An),Dn */
{ CPUFUNC(op_b028_0), 0, 45096 }, /* CMP.B (d16,An),Dn */
{ CPUFUNC(op_b030_3), 0, 45104 }, /* CMP.B (d8,An,Xn),Dn */
{ CPUFUNC(op_b038_0), 0, 45112 }, /* CMP.B (xxx).W,Dn */
{ CPUFUNC(op_b039_0), 0, 45113 }, /* CMP.B (xxx).L,Dn */
{ CPUFUNC(op_b03a_0), 0, 45114 }, /* CMP.B (d16,PC),Dn */
{ CPUFUNC(op_b03b_3), 0, 45115 }, /* CMP.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_b03c_0), 0, 45116 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_b040_0), 0, 45120 }, /* CMP.W Dn,Dn */
{ CPUFUNC(op_b048_0), 0, 45128 }, /* CMP.W An,Dn */
{ CPUFUNC(op_b050_0), 0, 45136 }, /* CMP.W (An),Dn */
{ CPUFUNC(op_b058_0), 0, 45144 }, /* CMP.W (An)+,Dn */
{ CPUFUNC(op_b060_0), 0, 45152 }, /* CMP.W -(An),Dn */
{ CPUFUNC(op_b068_0), 0, 45160 }, /* CMP.W (d16,An),Dn */
{ CPUFUNC(op_b070_3), 0, 45168 }, /* CMP.W (d8,An,Xn),Dn */
{ CPUFUNC(op_b078_0), 0, 45176 }, /* CMP.W (xxx).W,Dn */
{ CPUFUNC(op_b079_0), 0, 45177 }, /* CMP.W (xxx).L,Dn */
{ CPUFUNC(op_b07a_0), 0, 45178 }, /* CMP.W (d16,PC),Dn */
{ CPUFUNC(op_b07b_3), 0, 45179 }, /* CMP.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_b07c_0), 0, 45180 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_b080_0), 0, 45184 }, /* CMP.L Dn,Dn */
{ CPUFUNC(op_b088_0), 0, 45192 }, /* CMP.L An,Dn */
{ CPUFUNC(op_b090_0), 0, 45200 }, /* CMP.L (An),Dn */
{ CPUFUNC(op_b098_0), 0, 45208 }, /* CMP.L (An)+,Dn */
{ CPUFUNC(op_b0a0_0), 0, 45216 }, /* CMP.L -(An),Dn */
{ CPUFUNC(op_b0a8_0), 0, 45224 }, /* CMP.L (d16,An),Dn */
{ CPUFUNC(op_b0b0_3), 0, 45232 }, /* CMP.L (d8,An,Xn),Dn */
{ CPUFUNC(op_b0b8_0), 0, 45240 }, /* CMP.L (xxx).W,Dn */
{ CPUFUNC(op_b0b9_0), 0, 45241 }, /* CMP.L (xxx).L,Dn */
{ CPUFUNC(op_b0ba_0), 0, 45242 }, /* CMP.L (d16,PC),Dn */
{ CPUFUNC(op_b0bb_3), 0, 45243 }, /* CMP.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_b0bc_0), 0, 45244 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_b0c0_0), 0, 45248 }, /* CMPA.W Dn,An */
{ CPUFUNC(op_b0c8_0), 0, 45256 }, /* CMPA.W An,An */
{ CPUFUNC(op_b0d0_0), 0, 45264 }, /* CMPA.W (An),An */
{ CPUFUNC(op_b0d8_0), 0, 45272 }, /* CMPA.W (An)+,An */
{ CPUFUNC(op_b0e0_0), 0, 45280 }, /* CMPA.W -(An),An */
{ CPUFUNC(op_b0e8_0), 0, 45288 }, /* CMPA.W (d16,An),An */
{ CPUFUNC(op_b0f0_3), 0, 45296 }, /* CMPA.W (d8,An,Xn),An */
{ CPUFUNC(op_b0f8_0), 0, 45304 }, /* CMPA.W (xxx).W,An */
{ CPUFUNC(op_b0f9_0), 0, 45305 }, /* CMPA.W (xxx).L,An */
{ CPUFUNC(op_b0fa_0), 0, 45306 }, /* CMPA.W (d16,PC),An */
{ CPUFUNC(op_b0fb_3), 0, 45307 }, /* CMPA.W (d8,PC,Xn),An */
{ CPUFUNC(op_b0fc_0), 0, 45308 }, /* CMPA.W #<data>.W,An */
{ CPUFUNC(op_b100_0), 0, 45312 }, /* EOR.B Dn,Dn */
{ CPUFUNC(op_b108_0), 0, 45320 }, /* CMPM.B (An)+,(An)+ */
{ CPUFUNC(op_b110_0), 0, 45328 }, /* EOR.B Dn,(An) */
{ CPUFUNC(op_b118_0), 0, 45336 }, /* EOR.B Dn,(An)+ */
{ CPUFUNC(op_b120_0), 0, 45344 }, /* EOR.B Dn,-(An) */
{ CPUFUNC(op_b128_0), 0, 45352 }, /* EOR.B Dn,(d16,An) */
{ CPUFUNC(op_b130_3), 0, 45360 }, /* EOR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_b138_0), 0, 45368 }, /* EOR.B Dn,(xxx).W */
{ CPUFUNC(op_b139_0), 0, 45369 }, /* EOR.B Dn,(xxx).L */
{ CPUFUNC(op_b140_0), 0, 45376 }, /* EOR.W Dn,Dn */
{ CPUFUNC(op_b148_0), 0, 45384 }, /* CMPM.W (An)+,(An)+ */
{ CPUFUNC(op_b150_0), 0, 45392 }, /* EOR.W Dn,(An) */
{ CPUFUNC(op_b158_0), 0, 45400 }, /* EOR.W Dn,(An)+ */
{ CPUFUNC(op_b160_0), 0, 45408 }, /* EOR.W Dn,-(An) */
{ CPUFUNC(op_b168_0), 0, 45416 }, /* EOR.W Dn,(d16,An) */
{ CPUFUNC(op_b170_3), 0, 45424 }, /* EOR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_b178_0), 0, 45432 }, /* EOR.W Dn,(xxx).W */
{ CPUFUNC(op_b179_0), 0, 45433 }, /* EOR.W Dn,(xxx).L */
{ CPUFUNC(op_b180_0), 0, 45440 }, /* EOR.L Dn,Dn */
{ CPUFUNC(op_b188_0), 0, 45448 }, /* CMPM.L (An)+,(An)+ */
{ CPUFUNC(op_b190_0), 0, 45456 }, /* EOR.L Dn,(An) */
{ CPUFUNC(op_b198_0), 0, 45464 }, /* EOR.L Dn,(An)+ */
{ CPUFUNC(op_b1a0_0), 0, 45472 }, /* EOR.L Dn,-(An) */
{ CPUFUNC(op_b1a8_0), 0, 45480 }, /* EOR.L Dn,(d16,An) */
{ CPUFUNC(op_b1b0_3), 0, 45488 }, /* EOR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_b1b8_0), 0, 45496 }, /* EOR.L Dn,(xxx).W */
{ CPUFUNC(op_b1b9_0), 0, 45497 }, /* EOR.L Dn,(xxx).L */
{ CPUFUNC(op_b1c0_0), 0, 45504 }, /* CMPA.L Dn,An */
{ CPUFUNC(op_b1c8_0), 0, 45512 }, /* CMPA.L An,An */
{ CPUFUNC(op_b1d0_0), 0, 45520 }, /* CMPA.L (An),An */
{ CPUFUNC(op_b1d8_0), 0, 45528 }, /* CMPA.L (An)+,An */
{ CPUFUNC(op_b1e0_0), 0, 45536 }, /* CMPA.L -(An),An */
{ CPUFUNC(op_b1e8_0), 0, 45544 }, /* CMPA.L (d16,An),An */
{ CPUFUNC(op_b1f0_3), 0, 45552 }, /* CMPA.L (d8,An,Xn),An */
{ CPUFUNC(op_b1f8_0), 0, 45560 }, /* CMPA.L (xxx).W,An */
{ CPUFUNC(op_b1f9_0), 0, 45561 }, /* CMPA.L (xxx).L,An */
{ CPUFUNC(op_b1fa_0), 0, 45562 }, /* CMPA.L (d16,PC),An */
{ CPUFUNC(op_b1fb_3), 0, 45563 }, /* CMPA.L (d8,PC,Xn),An */
{ CPUFUNC(op_b1fc_0), 0, 45564 }, /* CMPA.L #<data>.L,An */
{ CPUFUNC(op_c000_0), 0, 49152 }, /* AND.B Dn,Dn */
{ CPUFUNC(op_c010_0), 0, 49168 }, /* AND.B (An),Dn */
{ CPUFUNC(op_c018_0), 0, 49176 }, /* AND.B (An)+,Dn */
{ CPUFUNC(op_c020_0), 0, 49184 }, /* AND.B -(An),Dn */
{ CPUFUNC(op_c028_0), 0, 49192 }, /* AND.B (d16,An),Dn */
{ CPUFUNC(op_c030_3), 0, 49200 }, /* AND.B (d8,An,Xn),Dn */
{ CPUFUNC(op_c038_0), 0, 49208 }, /* AND.B (xxx).W,Dn */
{ CPUFUNC(op_c039_0), 0, 49209 }, /* AND.B (xxx).L,Dn */
{ CPUFUNC(op_c03a_0), 0, 49210 }, /* AND.B (d16,PC),Dn */
{ CPUFUNC(op_c03b_3), 0, 49211 }, /* AND.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_c03c_0), 0, 49212 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_c040_0), 0, 49216 }, /* AND.W Dn,Dn */
{ CPUFUNC(op_c050_0), 0, 49232 }, /* AND.W (An),Dn */
{ CPUFUNC(op_c058_0), 0, 49240 }, /* AND.W (An)+,Dn */
{ CPUFUNC(op_c060_0), 0, 49248 }, /* AND.W -(An),Dn */
{ CPUFUNC(op_c068_0), 0, 49256 }, /* AND.W (d16,An),Dn */
{ CPUFUNC(op_c070_3), 0, 49264 }, /* AND.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c078_0), 0, 49272 }, /* AND.W (xxx).W,Dn */
{ CPUFUNC(op_c079_0), 0, 49273 }, /* AND.W (xxx).L,Dn */
{ CPUFUNC(op_c07a_0), 0, 49274 }, /* AND.W (d16,PC),Dn */
{ CPUFUNC(op_c07b_3), 0, 49275 }, /* AND.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c07c_0), 0, 49276 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_c080_0), 0, 49280 }, /* AND.L Dn,Dn */
{ CPUFUNC(op_c090_0), 0, 49296 }, /* AND.L (An),Dn */
{ CPUFUNC(op_c098_0), 0, 49304 }, /* AND.L (An)+,Dn */
{ CPUFUNC(op_c0a0_0), 0, 49312 }, /* AND.L -(An),Dn */
{ CPUFUNC(op_c0a8_0), 0, 49320 }, /* AND.L (d16,An),Dn */
{ CPUFUNC(op_c0b0_3), 0, 49328 }, /* AND.L (d8,An,Xn),Dn */
{ CPUFUNC(op_c0b8_0), 0, 49336 }, /* AND.L (xxx).W,Dn */
{ CPUFUNC(op_c0b9_0), 0, 49337 }, /* AND.L (xxx).L,Dn */
{ CPUFUNC(op_c0ba_0), 0, 49338 }, /* AND.L (d16,PC),Dn */
{ CPUFUNC(op_c0bb_3), 0, 49339 }, /* AND.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0bc_0), 0, 49340 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_c0c0_0), 0, 49344 }, /* MULU.W Dn,Dn */
{ CPUFUNC(op_c0d0_0), 0, 49360 }, /* MULU.W (An),Dn */
{ CPUFUNC(op_c0d8_0), 0, 49368 }, /* MULU.W (An)+,Dn */
{ CPUFUNC(op_c0e0_0), 0, 49376 }, /* MULU.W -(An),Dn */
{ CPUFUNC(op_c0e8_0), 0, 49384 }, /* MULU.W (d16,An),Dn */
{ CPUFUNC(op_c0f0_3), 0, 49392 }, /* MULU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c0f8_0), 0, 49400 }, /* MULU.W (xxx).W,Dn */
{ CPUFUNC(op_c0f9_0), 0, 49401 }, /* MULU.W (xxx).L,Dn */
{ CPUFUNC(op_c0fa_0), 0, 49402 }, /* MULU.W (d16,PC),Dn */
{ CPUFUNC(op_c0fb_3), 0, 49403 }, /* MULU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0fc_0), 0, 49404 }, /* MULU.W #<data>.W,Dn */
{ CPUFUNC(op_c100_1), 0, 49408 }, /* ABCD.B Dn,Dn */
{ CPUFUNC(op_c108_1), 0, 49416 }, /* ABCD.B -(An),-(An) */
{ CPUFUNC(op_c110_0), 0, 49424 }, /* AND.B Dn,(An) */
{ CPUFUNC(op_c118_0), 0, 49432 }, /* AND.B Dn,(An)+ */
{ CPUFUNC(op_c120_0), 0, 49440 }, /* AND.B Dn,-(An) */
{ CPUFUNC(op_c128_0), 0, 49448 }, /* AND.B Dn,(d16,An) */
{ CPUFUNC(op_c130_3), 0, 49456 }, /* AND.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_c138_0), 0, 49464 }, /* AND.B Dn,(xxx).W */
{ CPUFUNC(op_c139_0), 0, 49465 }, /* AND.B Dn,(xxx).L */
{ CPUFUNC_FF(op_c140_0), 0, 49472 }, /* EXG.L Dn,Dn */
{ CPUFUNC_FF(op_c148_0), 0, 49480 }, /* EXG.L An,An */
{ CPUFUNC(op_c150_0), 0, 49488 }, /* AND.W Dn,(An) */
{ CPUFUNC(op_c158_0), 0, 49496 }, /* AND.W Dn,(An)+ */
{ CPUFUNC(op_c160_0), 0, 49504 }, /* AND.W Dn,-(An) */
{ CPUFUNC(op_c168_0), 0, 49512 }, /* AND.W Dn,(d16,An) */
{ CPUFUNC(op_c170_3), 0, 49520 }, /* AND.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_c178_0), 0, 49528 }, /* AND.W Dn,(xxx).W */
{ CPUFUNC(op_c179_0), 0, 49529 }, /* AND.W Dn,(xxx).L */
{ CPUFUNC_FF(op_c188_0), 0, 49544 }, /* EXG.L Dn,An */
{ CPUFUNC(op_c190_0), 0, 49552 }, /* AND.L Dn,(An) */
{ CPUFUNC(op_c198_0), 0, 49560 }, /* AND.L Dn,(An)+ */
{ CPUFUNC(op_c1a0_0), 0, 49568 }, /* AND.L Dn,-(An) */
{ CPUFUNC(op_c1a8_0), 0, 49576 }, /* AND.L Dn,(d16,An) */
{ CPUFUNC(op_c1b0_3), 0, 49584 }, /* AND.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_c1b8_0), 0, 49592 }, /* AND.L Dn,(xxx).W */
{ CPUFUNC(op_c1b9_0), 0, 49593 }, /* AND.L Dn,(xxx).L */
{ CPUFUNC(op_c1c0_0), 0, 49600 }, /* MULS.W Dn,Dn */
{ CPUFUNC(op_c1d0_0), 0, 49616 }, /* MULS.W (An),Dn */
{ CPUFUNC(op_c1d8_0), 0, 49624 }, /* MULS.W (An)+,Dn */
{ CPUFUNC(op_c1e0_0), 0, 49632 }, /* MULS.W -(An),Dn */
{ CPUFUNC(op_c1e8_0), 0, 49640 }, /* MULS.W (d16,An),Dn */
{ CPUFUNC(op_c1f0_3), 0, 49648 }, /* MULS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c1f8_0), 0, 49656 }, /* MULS.W (xxx).W,Dn */
{ CPUFUNC(op_c1f9_0), 0, 49657 }, /* MULS.W (xxx).L,Dn */
{ CPUFUNC(op_c1fa_0), 0, 49658 }, /* MULS.W (d16,PC),Dn */
{ CPUFUNC(op_c1fb_3), 0, 49659 }, /* MULS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c1fc_0), 0, 49660 }, /* MULS.W #<data>.W,Dn */
{ CPUFUNC(op_d000_0), 0, 53248 }, /* ADD.B Dn,Dn */
{ CPUFUNC(op_d010_0), 0, 53264 }, /* ADD.B (An),Dn */
{ CPUFUNC(op_d018_0), 0, 53272 }, /* ADD.B (An)+,Dn */
{ CPUFUNC(op_d020_0), 0, 53280 }, /* ADD.B -(An),Dn */
{ CPUFUNC(op_d028_0), 0, 53288 }, /* ADD.B (d16,An),Dn */
{ CPUFUNC(op_d030_3), 0, 53296 }, /* ADD.B (d8,An,Xn),Dn */
{ CPUFUNC(op_d038_0), 0, 53304 }, /* ADD.B (xxx).W,Dn */
{ CPUFUNC(op_d039_0), 0, 53305 }, /* ADD.B (xxx).L,Dn */
{ CPUFUNC(op_d03a_0), 0, 53306 }, /* ADD.B (d16,PC),Dn */
{ CPUFUNC(op_d03b_3), 0, 53307 }, /* ADD.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_d03c_0), 0, 53308 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_d040_0), 0, 53312 }, /* ADD.W Dn,Dn */
{ CPUFUNC(op_d048_0), 0, 53320 }, /* ADD.W An,Dn */
{ CPUFUNC(op_d050_0), 0, 53328 }, /* ADD.W (An),Dn */
{ CPUFUNC(op_d058_0), 0, 53336 }, /* ADD.W (An)+,Dn */
{ CPUFUNC(op_d060_0), 0, 53344 }, /* ADD.W -(An),Dn */
{ CPUFUNC(op_d068_0), 0, 53352 }, /* ADD.W (d16,An),Dn */
{ CPUFUNC(op_d070_3), 0, 53360 }, /* ADD.W (d8,An,Xn),Dn */
{ CPUFUNC(op_d078_0), 0, 53368 }, /* ADD.W (xxx).W,Dn */
{ CPUFUNC(op_d079_0), 0, 53369 }, /* ADD.W (xxx).L,Dn */
{ CPUFUNC(op_d07a_0), 0, 53370 }, /* ADD.W (d16,PC),Dn */
{ CPUFUNC(op_d07b_3), 0, 53371 }, /* ADD.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_d07c_0), 0, 53372 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_d080_0), 0, 53376 }, /* ADD.L Dn,Dn */
{ CPUFUNC(op_d088_0), 0, 53384 }, /* ADD.L An,Dn */
{ CPUFUNC(op_d090_0), 0, 53392 }, /* ADD.L (An),Dn */
{ CPUFUNC(op_d098_0), 0, 53400 }, /* ADD.L (An)+,Dn */
{ CPUFUNC(op_d0a0_0), 0, 53408 }, /* ADD.L -(An),Dn */
{ CPUFUNC(op_d0a8_0), 0, 53416 }, /* ADD.L (d16,An),Dn */
{ CPUFUNC(op_d0b0_3), 0, 53424 }, /* ADD.L (d8,An,Xn),Dn */
{ CPUFUNC(op_d0b8_0), 0, 53432 }, /* ADD.L (xxx).W,Dn */
{ CPUFUNC(op_d0b9_0), 0, 53433 }, /* ADD.L (xxx).L,Dn */
{ CPUFUNC(op_d0ba_0), 0, 53434 }, /* ADD.L (d16,PC),Dn */
{ CPUFUNC(op_d0bb_3), 0, 53435 }, /* ADD.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_d0bc_0), 0, 53436 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC_FF(op_d0c0_0), 0, 53440 }, /* ADDA.W Dn,An */
{ CPUFUNC_FF(op_d0c8_0), 0, 53448 }, /* ADDA.W An,An */
{ CPUFUNC_FF(op_d0d0_0), 0, 53456 }, /* ADDA.W (An),An */
{ CPUFUNC_FF(op_d0d8_0), 0, 53464 }, /* ADDA.W (An)+,An */
{ CPUFUNC_FF(op_d0e0_0), 0, 53472 }, /* ADDA.W -(An),An */
{ CPUFUNC_FF(op_d0e8_0), 0, 53480 }, /* ADDA.W (d16,An),An */
{ CPUFUNC_FF(op_d0f0_3), 0, 53488 }, /* ADDA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_d0f8_0), 0, 53496 }, /* ADDA.W (xxx).W,An */
{ CPUFUNC_FF(op_d0f9_0), 0, 53497 }, /* ADDA.W (xxx).L,An */
{ CPUFUNC_FF(op_d0fa_0), 0, 53498 }, /* ADDA.W (d16,PC),An */
{ CPUFUNC_FF(op_d0fb_3), 0, 53499 }, /* ADDA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d0fc_0), 0, 53500 }, /* ADDA.W #<data>.W,An */
{ CPUFUNC(op_d100_0), 0, 53504 }, /* ADDX.B Dn,Dn */
{ CPUFUNC(op_d108_0), 0, 53512 }, /* ADDX.B -(An),-(An) */
{ CPUFUNC(op_d110_0), 0, 53520 }, /* ADD.B Dn,(An) */
{ CPUFUNC(op_d118_0), 0, 53528 }, /* ADD.B Dn,(An)+ */
{ CPUFUNC(op_d120_0), 0, 53536 }, /* ADD.B Dn,-(An) */
{ CPUFUNC(op_d128_0), 0, 53544 }, /* ADD.B Dn,(d16,An) */
{ CPUFUNC(op_d130_3), 0, 53552 }, /* ADD.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_d138_0), 0, 53560 }, /* ADD.B Dn,(xxx).W */
{ CPUFUNC(op_d139_0), 0, 53561 }, /* ADD.B Dn,(xxx).L */
{ CPUFUNC(op_d140_0), 0, 53568 }, /* ADDX.W Dn,Dn */
{ CPUFUNC(op_d148_0), 0, 53576 }, /* ADDX.W -(An),-(An) */
{ CPUFUNC(op_d150_0), 0, 53584 }, /* ADD.W Dn,(An) */
{ CPUFUNC(op_d158_0), 0, 53592 }, /* ADD.W Dn,(An)+ */
{ CPUFUNC(op_d160_0), 0, 53600 }, /* ADD.W Dn,-(An) */
{ CPUFUNC(op_d168_0), 0, 53608 }, /* ADD.W Dn,(d16,An) */
{ CPUFUNC(op_d170_3), 0, 53616 }, /* ADD.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_d178_0), 0, 53624 }, /* ADD.W Dn,(xxx).W */
{ CPUFUNC(op_d179_0), 0, 53625 }, /* ADD.W Dn,(xxx).L */
{ CPUFUNC(op_d180_0), 0, 53632 }, /* ADDX.L Dn,Dn */
{ CPUFUNC(op_d188_0), 0, 53640 }, /* ADDX.L -(An),-(An) */
{ CPUFUNC(op_d190_0), 0, 53648 }, /* ADD.L Dn,(An) */
{ CPUFUNC(op_d198_0), 0, 53656 }, /* ADD.L Dn,(An)+ */
{ CPUFUNC(op_d1a0_0), 0, 53664 }, /* ADD.L Dn,-(An) */
{ CPUFUNC(op_d1a8_0), 0, 53672 }, /* ADD.L Dn,(d16,An) */
{ CPUFUNC(op_d1b0_3), 0, 53680 }, /* ADD.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_d1b8_0), 0, 53688 }, /* ADD.L Dn,(xxx).W */
{ CPUFUNC(op_d1b9_0), 0, 53689 }, /* ADD.L Dn,(xxx).L */
{ CPUFUNC_FF(op_d1c0_0), 0, 53696 }, /* ADDA.L Dn,An */
{ CPUFUNC_FF(op_d1c8_0), 0, 53704 }, /* ADDA.L An,An */
{ CPUFUNC_FF(op_d1d0_0), 0, 53712 }, /* ADDA.L (An),An */
{ CPUFUNC_FF(op_d1d8_0), 0, 53720 }, /* ADDA.L (An)+,An */
{ CPUFUNC_FF(op_d1e0_0), 0, 53728 }, /* ADDA.L -(An),An */
{ CPUFUNC_FF(op_d1e8_0), 0, 53736 }, /* ADDA.L (d16,An),An */
{ CPUFUNC_FF(op_d1f0_3), 0, 53744 }, /* ADDA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_d1f8_0), 0, 53752 }, /* ADDA.L (xxx).W,An */
{ CPUFUNC_FF(op_d1f9_0), 0, 53753 }, /* ADDA.L (xxx).L,An */
{ CPUFUNC_FF(op_d1fa_0), 0, 53754 }, /* ADDA.L (d16,PC),An */
{ CPUFUNC_FF(op_d1fb_3), 0, 53755 }, /* ADDA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d1fc_0), 0, 53756 }, /* ADDA.L #<data>.L,An */
{ CPUFUNC(op_e000_0), 0, 57344 }, /* ASR.B #<data>,Dn */
{ CPUFUNC(op_e008_0), 0, 57352 }, /* LSR.B #<data>,Dn */
{ CPUFUNC(op_e010_0), 0, 57360 }, /* ROXR.B #<data>,Dn */
{ CPUFUNC(op_e018_0), 0, 57368 }, /* ROR.B #<data>,Dn */
{ CPUFUNC(op_e020_0), 0, 57376 }, /* ASR.B Dn,Dn */
{ CPUFUNC(op_e028_0), 0, 57384 }, /* LSR.B Dn,Dn */
{ CPUFUNC(op_e030_0), 0, 57392 }, /* ROXR.B Dn,Dn */
{ CPUFUNC(op_e038_0), 0, 57400 }, /* ROR.B Dn,Dn */
{ CPUFUNC(op_e040_0), 0, 57408 }, /* ASR.W #<data>,Dn */
{ CPUFUNC(op_e048_0), 0, 57416 }, /* LSR.W #<data>,Dn */
{ CPUFUNC(op_e050_0), 0, 57424 }, /* ROXR.W #<data>,Dn */
{ CPUFUNC(op_e058_0), 0, 57432 }, /* ROR.W #<data>,Dn */
{ CPUFUNC(op_e060_0), 0, 57440 }, /* ASR.W Dn,Dn */
{ CPUFUNC(op_e068_0), 0, 57448 }, /* LSR.W Dn,Dn */
{ CPUFUNC(op_e070_0), 0, 57456 }, /* ROXR.W Dn,Dn */
{ CPUFUNC(op_e078_0), 0, 57464 }, /* ROR.W Dn,Dn */
{ CPUFUNC(op_e080_0), 0, 57472 }, /* ASR.L #<data>,Dn */
{ CPUFUNC(op_e088_0), 0, 57480 }, /* LSR.L #<data>,Dn */
{ CPUFUNC(op_e090_0), 0, 57488 }, /* ROXR.L #<data>,Dn */
{ CPUFUNC(op_e098_0), 0, 57496 }, /* ROR.L #<data>,Dn */
{ CPUFUNC(op_e0a0_0), 0, 57504 }, /* ASR.L Dn,Dn */
{ CPUFUNC(op_e0a8_0), 0, 57512 }, /* LSR.L Dn,Dn */
{ CPUFUNC(op_e0b0_0), 0, 57520 }, /* ROXR.L Dn,Dn */
{ CPUFUNC(op_e0b8_0), 0, 57528 }, /* ROR.L Dn,Dn */
{ CPUFUNC(op_e0d0_0), 0, 57552 }, /* ASRW.W (An) */
{ CPUFUNC(op_e0d8_0), 0, 57560 }, /* ASRW.W (An)+ */
{ CPUFUNC(op_e0e0_0), 0, 57568 }, /* ASRW.W -(An) */
{ CPUFUNC(op_e0e8_0), 0, 57576 }, /* ASRW.W (d16,An) */
{ CPUFUNC(op_e0f0_3), 0, 57584 }, /* ASRW.W (d8,An,Xn) */
{ CPUFUNC(op_e0f8_0), 0, 57592 }, /* ASRW.W (xxx).W */
{ CPUFUNC(op_e0f9_0), 0, 57593 }, /* ASRW.W (xxx).L */
{ CPUFUNC(op_e100_0), 0, 57600 }, /* ASL.B #<data>,Dn */
{ CPUFUNC(op_e108_0), 0, 57608 }, /* LSL.B #<data>,Dn */
{ CPUFUNC(op_e110_0), 0, 57616 }, /* ROXL.B #<data>,Dn */
{ CPUFUNC(op_e118_0), 0, 57624 }, /* ROL.B #<data>,Dn */
{ CPUFUNC(op_e120_0), 0, 57632 }, /* ASL.B Dn,Dn */
{ CPUFUNC(op_e128_0), 0, 57640 }, /* LSL.B Dn,Dn */
{ CPUFUNC(op_e130_0), 0, 57648 }, /* ROXL.B Dn,Dn */
{ CPUFUNC(op_e138_0), 0, 57656 }, /* ROL.B Dn,Dn */
{ CPUFUNC(op_e140_0), 0, 57664 }, /* ASL.W #<data>,Dn */
{ CPUFUNC(op_e148_0), 0, 57672 }, /* LSL.W #<data>,Dn */
{ CPUFUNC(op_e150_0), 0, 57680 }, /* ROXL.W #<data>,Dn */
{ CPUFUNC(op_e158_0), 0, 57688 }, /* ROL.W #<data>,Dn */
{ CPUFUNC(op_e160_0), 0, 57696 }, /* ASL.W Dn,Dn */
{ CPUFUNC(op_e168_0), 0, 57704 }, /* LSL.W Dn,Dn */
{ CPUFUNC(op_e170_0), 0, 57712 }, /* ROXL.W Dn,Dn */
{ CPUFUNC(op_e178_0), 0, 57720 }, /* ROL.W Dn,Dn */
{ CPUFUNC(op_e180_0), 0, 57728 }, /* ASL.L #<data>,Dn */
{ CPUFUNC(op_e188_0), 0, 57736 }, /* LSL.L #<data>,Dn */
{ CPUFUNC(op_e190_0), 0, 57744 }, /* ROXL.L #<data>,Dn */
{ CPUFUNC(op_e198_0), 0, 57752 }, /* ROL.L #<data>,Dn */
{ CPUFUNC(op_e1a0_0), 0, 57760 }, /* ASL.L Dn,Dn */
{ CPUFUNC(op_e1a8_0), 0, 57768 }, /* LSL.L Dn,Dn */
{ CPUFUNC(op_e1b0_0), 0, 57776 }, /* ROXL.L Dn,Dn */
{ CPUFUNC(op_e1b8_0), 0, 57784 }, /* ROL.L Dn,Dn */
{ CPUFUNC(op_e1d0_0), 0, 57808 }, /* ASLW.W (An) */
{ CPUFUNC(op_e1d8_0), 0, 57816 }, /* ASLW.W (An)+ */
{ CPUFUNC(op_e1e0_0), 0, 57824 }, /* ASLW.W -(An) */
{ CPUFUNC(op_e1e8_0), 0, 57832 }, /* ASLW.W (d16,An) */
{ CPUFUNC(op_e1f0_3), 0, 57840 }, /* ASLW.W (d8,An,Xn) */
{ CPUFUNC(op_e1f8_0), 0, 57848 }, /* ASLW.W (xxx).W */
{ CPUFUNC(op_e1f9_0), 0, 57849 }, /* ASLW.W (xxx).L */
{ CPUFUNC(op_e2d0_0), 0, 58064 }, /* LSRW.W (An) */
{ CPUFUNC(op_e2d8_0), 0, 58072 }, /* LSRW.W (An)+ */
{ CPUFUNC(op_e2e0_0), 0, 58080 }, /* LSRW.W -(An) */
{ CPUFUNC(op_e2e8_0), 0, 58088 }, /* LSRW.W (d16,An) */
{ CPUFUNC(op_e2f0_3), 0, 58096 }, /* LSRW.W (d8,An,Xn) */
{ CPUFUNC(op_e2f8_0), 0, 58104 }, /* LSRW.W (xxx).W */
{ CPUFUNC(op_e2f9_0), 0, 58105 }, /* LSRW.W (xxx).L */
{ CPUFUNC(op_e3d0_0), 0, 58320 }, /* LSLW.W (An) */
{ CPUFUNC(op_e3d8_0), 0, 58328 }, /* LSLW.W (An)+ */
{ CPUFUNC(op_e3e0_0), 0, 58336 }, /* LSLW.W -(An) */
{ CPUFUNC(op_e3e8_0), 0, 58344 }, /* LSLW.W (d16,An) */
{ CPUFUNC(op_e3f0_3), 0, 58352 }, /* LSLW.W (d8,An,Xn) */
{ CPUFUNC(op_e3f8_0), 0, 58360 }, /* LSLW.W (xxx).W */
{ CPUFUNC(op_e3f9_0), 0, 58361 }, /* LSLW.W (xxx).L */
{ CPUFUNC(op_e4d0_0), 0, 58576 }, /* ROXRW.W (An) */
{ CPUFUNC(op_e4d8_0), 0, 58584 }, /* ROXRW.W (An)+ */
{ CPUFUNC(op_e4e0_0), 0, 58592 }, /* ROXRW.W -(An) */
{ CPUFUNC(op_e4e8_0), 0, 58600 }, /* ROXRW.W (d16,An) */
{ CPUFUNC(op_e4f0_3), 0, 58608 }, /* ROXRW.W (d8,An,Xn) */
{ CPUFUNC(op_e4f8_0), 0, 58616 }, /* ROXRW.W (xxx).W */
{ CPUFUNC(op_e4f9_0), 0, 58617 }, /* ROXRW.W (xxx).L */
{ CPUFUNC(op_e5d0_0), 0, 58832 }, /* ROXLW.W (An) */
{ CPUFUNC(op_e5d8_0), 0, 58840 }, /* ROXLW.W (An)+ */
{ CPUFUNC(op_e5e0_0), 0, 58848 }, /* ROXLW.W -(An) */
{ CPUFUNC(op_e5e8_0), 0, 58856 }, /* ROXLW.W (d16,An) */
{ CPUFUNC(op_e5f0_3), 0, 58864 }, /* ROXLW.W (d8,An,Xn) */
{ CPUFUNC(op_e5f8_0), 0, 58872 }, /* ROXLW.W (xxx).W */
{ CPUFUNC(op_e5f9_0), 0, 58873 }, /* ROXLW.W (xxx).L */
{ CPUFUNC(op_e6d0_0), 0, 59088 }, /* RORW.W (An) */
{ CPUFUNC(op_e6d8_0), 0, 59096 }, /* RORW.W (An)+ */
{ CPUFUNC(op_e6e0_0), 0, 59104 }, /* RORW.W -(An) */
{ CPUFUNC(op_e6e8_0), 0, 59112 }, /* RORW.W (d16,An) */
{ CPUFUNC(op_e6f0_3), 0, 59120 }, /* RORW.W (d8,An,Xn) */
{ CPUFUNC(op_e6f8_0), 0, 59128 }, /* RORW.W (xxx).W */
{ CPUFUNC(op_e6f9_0), 0, 59129 }, /* RORW.W (xxx).L */
{ CPUFUNC(op_e7d0_0), 0, 59344 }, /* ROLW.W (An) */
{ CPUFUNC(op_e7d8_0), 0, 59352 }, /* ROLW.W (An)+ */
{ CPUFUNC(op_e7e0_0), 0, 59360 }, /* ROLW.W -(An) */
{ CPUFUNC(op_e7e8_0), 0, 59368 }, /* ROLW.W (d16,An) */
{ CPUFUNC(op_e7f0_3), 0, 59376 }, /* ROLW.W (d8,An,Xn) */
{ CPUFUNC(op_e7f8_0), 0, 59384 }, /* ROLW.W (xxx).W */
{ CPUFUNC(op_e7f9_0), 0, 59385 }, /* ROLW.W (xxx).L */
{ 0, 0, 0 }};
struct cputbl CPUFUNC(op_smalltbl_4)[] = {
{ CPUFUNC(op_0_0), 0, 0 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_10_0), 0, 16 }, /* OR.B #<data>.B,(An) */
{ CPUFUNC(op_18_0), 0, 24 }, /* OR.B #<data>.B,(An)+ */
{ CPUFUNC(op_20_0), 0, 32 }, /* OR.B #<data>.B,-(An) */
{ CPUFUNC(op_28_0), 0, 40 }, /* OR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_30_3), 0, 48 }, /* OR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_38_0), 0, 56 }, /* OR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_39_0), 0, 57 }, /* OR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_3c_0), 0, 60 }, /* ORSR.B #<data>.W */
{ CPUFUNC(op_40_0), 0, 64 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_50_0), 0, 80 }, /* OR.W #<data>.W,(An) */
{ CPUFUNC(op_58_0), 0, 88 }, /* OR.W #<data>.W,(An)+ */
{ CPUFUNC(op_60_0), 0, 96 }, /* OR.W #<data>.W,-(An) */
{ CPUFUNC(op_68_0), 0, 104 }, /* OR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_70_3), 0, 112 }, /* OR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_78_0), 0, 120 }, /* OR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_79_0), 0, 121 }, /* OR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_7c_0), 0, 124 }, /* ORSR.W #<data>.W */
{ CPUFUNC(op_80_0), 0, 128 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_90_0), 0, 144 }, /* OR.L #<data>.L,(An) */
{ CPUFUNC(op_98_0), 0, 152 }, /* OR.L #<data>.L,(An)+ */
{ CPUFUNC(op_a0_0), 0, 160 }, /* OR.L #<data>.L,-(An) */
{ CPUFUNC(op_a8_0), 0, 168 }, /* OR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_b0_3), 0, 176 }, /* OR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_b8_0), 0, 184 }, /* OR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_b9_0), 0, 185 }, /* OR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_100_0), 0, 256 }, /* BTST.L Dn,Dn */
{ CPUFUNC_FF(op_108_0), 0, 264 }, /* MVPMR.W (d16,An),Dn */
{ CPUFUNC(op_110_0), 0, 272 }, /* BTST.B Dn,(An) */
{ CPUFUNC(op_118_0), 0, 280 }, /* BTST.B Dn,(An)+ */
{ CPUFUNC(op_120_0), 0, 288 }, /* BTST.B Dn,-(An) */
{ CPUFUNC(op_128_0), 0, 296 }, /* BTST.B Dn,(d16,An) */
{ CPUFUNC(op_130_3), 0, 304 }, /* BTST.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_138_0), 0, 312 }, /* BTST.B Dn,(xxx).W */
{ CPUFUNC(op_139_0), 0, 313 }, /* BTST.B Dn,(xxx).L */
{ CPUFUNC(op_13a_0), 0, 314 }, /* BTST.B Dn,(d16,PC) */
{ CPUFUNC(op_13b_3), 0, 315 }, /* BTST.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_13c_0), 0, 316 }, /* BTST.B Dn,#<data>.B */
{ CPUFUNC(op_140_0), 0, 320 }, /* BCHG.L Dn,Dn */
{ CPUFUNC_FF(op_148_0), 0, 328 }, /* MVPMR.L (d16,An),Dn */
{ CPUFUNC(op_150_0), 0, 336 }, /* BCHG.B Dn,(An) */
{ CPUFUNC(op_158_0), 0, 344 }, /* BCHG.B Dn,(An)+ */
{ CPUFUNC(op_160_0), 0, 352 }, /* BCHG.B Dn,-(An) */
{ CPUFUNC(op_168_0), 0, 360 }, /* BCHG.B Dn,(d16,An) */
{ CPUFUNC(op_170_3), 0, 368 }, /* BCHG.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_178_0), 0, 376 }, /* BCHG.B Dn,(xxx).W */
{ CPUFUNC(op_179_0), 0, 377 }, /* BCHG.B Dn,(xxx).L */
{ CPUFUNC(op_17a_0), 0, 378 }, /* BCHG.B Dn,(d16,PC) */
{ CPUFUNC(op_17b_3), 0, 379 }, /* BCHG.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_180_0), 0, 384 }, /* BCLR.L Dn,Dn */
{ CPUFUNC_FF(op_188_0), 0, 392 }, /* MVPRM.W Dn,(d16,An) */
{ CPUFUNC(op_190_0), 0, 400 }, /* BCLR.B Dn,(An) */
{ CPUFUNC(op_198_0), 0, 408 }, /* BCLR.B Dn,(An)+ */
{ CPUFUNC(op_1a0_0), 0, 416 }, /* BCLR.B Dn,-(An) */
{ CPUFUNC(op_1a8_0), 0, 424 }, /* BCLR.B Dn,(d16,An) */
{ CPUFUNC(op_1b0_3), 0, 432 }, /* BCLR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1b8_0), 0, 440 }, /* BCLR.B Dn,(xxx).W */
{ CPUFUNC(op_1b9_0), 0, 441 }, /* BCLR.B Dn,(xxx).L */
{ CPUFUNC(op_1ba_0), 0, 442 }, /* BCLR.B Dn,(d16,PC) */
{ CPUFUNC(op_1bb_3), 0, 443 }, /* BCLR.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_1c0_0), 0, 448 }, /* BSET.L Dn,Dn */
{ CPUFUNC_FF(op_1c8_0), 0, 456 }, /* MVPRM.L Dn,(d16,An) */
{ CPUFUNC(op_1d0_0), 0, 464 }, /* BSET.B Dn,(An) */
{ CPUFUNC(op_1d8_0), 0, 472 }, /* BSET.B Dn,(An)+ */
{ CPUFUNC(op_1e0_0), 0, 480 }, /* BSET.B Dn,-(An) */
{ CPUFUNC(op_1e8_0), 0, 488 }, /* BSET.B Dn,(d16,An) */
{ CPUFUNC(op_1f0_3), 0, 496 }, /* BSET.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1f8_0), 0, 504 }, /* BSET.B Dn,(xxx).W */
{ CPUFUNC(op_1f9_0), 0, 505 }, /* BSET.B Dn,(xxx).L */
{ CPUFUNC(op_1fa_0), 0, 506 }, /* BSET.B Dn,(d16,PC) */
{ CPUFUNC(op_1fb_3), 0, 507 }, /* BSET.B Dn,(d8,PC,Xn) */
{ CPUFUNC(op_200_0), 0, 512 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_210_0), 0, 528 }, /* AND.B #<data>.B,(An) */
{ CPUFUNC(op_218_0), 0, 536 }, /* AND.B #<data>.B,(An)+ */
{ CPUFUNC(op_220_0), 0, 544 }, /* AND.B #<data>.B,-(An) */
{ CPUFUNC(op_228_0), 0, 552 }, /* AND.B #<data>.B,(d16,An) */
{ CPUFUNC(op_230_3), 0, 560 }, /* AND.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_238_0), 0, 568 }, /* AND.B #<data>.B,(xxx).W */
{ CPUFUNC(op_239_0), 0, 569 }, /* AND.B #<data>.B,(xxx).L */
{ CPUFUNC(op_23c_0), 0, 572 }, /* ANDSR.B #<data>.W */
{ CPUFUNC(op_240_0), 0, 576 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_250_0), 0, 592 }, /* AND.W #<data>.W,(An) */
{ CPUFUNC(op_258_0), 0, 600 }, /* AND.W #<data>.W,(An)+ */
{ CPUFUNC(op_260_0), 0, 608 }, /* AND.W #<data>.W,-(An) */
{ CPUFUNC(op_268_0), 0, 616 }, /* AND.W #<data>.W,(d16,An) */
{ CPUFUNC(op_270_3), 0, 624 }, /* AND.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_278_0), 0, 632 }, /* AND.W #<data>.W,(xxx).W */
{ CPUFUNC(op_279_0), 0, 633 }, /* AND.W #<data>.W,(xxx).L */
{ CPUFUNC(op_27c_0), 0, 636 }, /* ANDSR.W #<data>.W */
{ CPUFUNC(op_280_0), 0, 640 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_290_0), 0, 656 }, /* AND.L #<data>.L,(An) */
{ CPUFUNC(op_298_0), 0, 664 }, /* AND.L #<data>.L,(An)+ */
{ CPUFUNC(op_2a0_0), 0, 672 }, /* AND.L #<data>.L,-(An) */
{ CPUFUNC(op_2a8_0), 0, 680 }, /* AND.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2b0_3), 0, 688 }, /* AND.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_2b8_0), 0, 696 }, /* AND.L #<data>.L,(xxx).W */
{ CPUFUNC(op_2b9_0), 0, 697 }, /* AND.L #<data>.L,(xxx).L */
{ CPUFUNC(op_400_0), 0, 1024 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_410_0), 0, 1040 }, /* SUB.B #<data>.B,(An) */
{ CPUFUNC(op_418_0), 0, 1048 }, /* SUB.B #<data>.B,(An)+ */
{ CPUFUNC(op_420_0), 0, 1056 }, /* SUB.B #<data>.B,-(An) */
{ CPUFUNC(op_428_0), 0, 1064 }, /* SUB.B #<data>.B,(d16,An) */
{ CPUFUNC(op_430_3), 0, 1072 }, /* SUB.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_438_0), 0, 1080 }, /* SUB.B #<data>.B,(xxx).W */
{ CPUFUNC(op_439_0), 0, 1081 }, /* SUB.B #<data>.B,(xxx).L */
{ CPUFUNC(op_440_0), 0, 1088 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_450_0), 0, 1104 }, /* SUB.W #<data>.W,(An) */
{ CPUFUNC(op_458_0), 0, 1112 }, /* SUB.W #<data>.W,(An)+ */
{ CPUFUNC(op_460_0), 0, 1120 }, /* SUB.W #<data>.W,-(An) */
{ CPUFUNC(op_468_0), 0, 1128 }, /* SUB.W #<data>.W,(d16,An) */
{ CPUFUNC(op_470_3), 0, 1136 }, /* SUB.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_478_0), 0, 1144 }, /* SUB.W #<data>.W,(xxx).W */
{ CPUFUNC(op_479_0), 0, 1145 }, /* SUB.W #<data>.W,(xxx).L */
{ CPUFUNC(op_480_0), 0, 1152 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC(op_490_0), 0, 1168 }, /* SUB.L #<data>.L,(An) */
{ CPUFUNC(op_498_0), 0, 1176 }, /* SUB.L #<data>.L,(An)+ */
{ CPUFUNC(op_4a0_0), 0, 1184 }, /* SUB.L #<data>.L,-(An) */
{ CPUFUNC(op_4a8_0), 0, 1192 }, /* SUB.L #<data>.L,(d16,An) */
{ CPUFUNC(op_4b0_3), 0, 1200 }, /* SUB.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_4b8_0), 0, 1208 }, /* SUB.L #<data>.L,(xxx).W */
{ CPUFUNC(op_4b9_0), 0, 1209 }, /* SUB.L #<data>.L,(xxx).L */
{ CPUFUNC(op_600_0), 0, 1536 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_610_0), 0, 1552 }, /* ADD.B #<data>.B,(An) */
{ CPUFUNC(op_618_0), 0, 1560 }, /* ADD.B #<data>.B,(An)+ */
{ CPUFUNC(op_620_0), 0, 1568 }, /* ADD.B #<data>.B,-(An) */
{ CPUFUNC(op_628_0), 0, 1576 }, /* ADD.B #<data>.B,(d16,An) */
{ CPUFUNC(op_630_3), 0, 1584 }, /* ADD.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_638_0), 0, 1592 }, /* ADD.B #<data>.B,(xxx).W */
{ CPUFUNC(op_639_0), 0, 1593 }, /* ADD.B #<data>.B,(xxx).L */
{ CPUFUNC(op_640_0), 0, 1600 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_650_0), 0, 1616 }, /* ADD.W #<data>.W,(An) */
{ CPUFUNC(op_658_0), 0, 1624 }, /* ADD.W #<data>.W,(An)+ */
{ CPUFUNC(op_660_0), 0, 1632 }, /* ADD.W #<data>.W,-(An) */
{ CPUFUNC(op_668_0), 0, 1640 }, /* ADD.W #<data>.W,(d16,An) */
{ CPUFUNC(op_670_3), 0, 1648 }, /* ADD.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_678_0), 0, 1656 }, /* ADD.W #<data>.W,(xxx).W */
{ CPUFUNC(op_679_0), 0, 1657 }, /* ADD.W #<data>.W,(xxx).L */
{ CPUFUNC(op_680_0), 0, 1664 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC(op_690_0), 0, 1680 }, /* ADD.L #<data>.L,(An) */
{ CPUFUNC(op_698_0), 0, 1688 }, /* ADD.L #<data>.L,(An)+ */
{ CPUFUNC(op_6a0_0), 0, 1696 }, /* ADD.L #<data>.L,-(An) */
{ CPUFUNC(op_6a8_0), 0, 1704 }, /* ADD.L #<data>.L,(d16,An) */
{ CPUFUNC(op_6b0_3), 0, 1712 }, /* ADD.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_6b8_0), 0, 1720 }, /* ADD.L #<data>.L,(xxx).W */
{ CPUFUNC(op_6b9_0), 0, 1721 }, /* ADD.L #<data>.L,(xxx).L */
{ CPUFUNC(op_800_0), 0, 2048 }, /* BTST.L #<data>.W,Dn */
{ CPUFUNC(op_810_0), 0, 2064 }, /* BTST.B #<data>.W,(An) */
{ CPUFUNC(op_818_0), 0, 2072 }, /* BTST.B #<data>.W,(An)+ */
{ CPUFUNC(op_820_0), 0, 2080 }, /* BTST.B #<data>.W,-(An) */
{ CPUFUNC(op_828_0), 0, 2088 }, /* BTST.B #<data>.W,(d16,An) */
{ CPUFUNC(op_830_3), 0, 2096 }, /* BTST.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_838_0), 0, 2104 }, /* BTST.B #<data>.W,(xxx).W */
{ CPUFUNC(op_839_0), 0, 2105 }, /* BTST.B #<data>.W,(xxx).L */
{ CPUFUNC(op_83a_0), 0, 2106 }, /* BTST.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_83b_3), 0, 2107 }, /* BTST.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_83c_0), 0, 2108 }, /* BTST.B #<data>.W,#<data>.B */
{ CPUFUNC(op_840_0), 0, 2112 }, /* BCHG.L #<data>.W,Dn */
{ CPUFUNC(op_850_0), 0, 2128 }, /* BCHG.B #<data>.W,(An) */
{ CPUFUNC(op_858_0), 0, 2136 }, /* BCHG.B #<data>.W,(An)+ */
{ CPUFUNC(op_860_0), 0, 2144 }, /* BCHG.B #<data>.W,-(An) */
{ CPUFUNC(op_868_0), 0, 2152 }, /* BCHG.B #<data>.W,(d16,An) */
{ CPUFUNC(op_870_3), 0, 2160 }, /* BCHG.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_878_0), 0, 2168 }, /* BCHG.B #<data>.W,(xxx).W */
{ CPUFUNC(op_879_0), 0, 2169 }, /* BCHG.B #<data>.W,(xxx).L */
{ CPUFUNC(op_87a_0), 0, 2170 }, /* BCHG.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_87b_3), 0, 2171 }, /* BCHG.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_880_0), 0, 2176 }, /* BCLR.L #<data>.W,Dn */
{ CPUFUNC(op_890_0), 0, 2192 }, /* BCLR.B #<data>.W,(An) */
{ CPUFUNC(op_898_0), 0, 2200 }, /* BCLR.B #<data>.W,(An)+ */
{ CPUFUNC(op_8a0_0), 0, 2208 }, /* BCLR.B #<data>.W,-(An) */
{ CPUFUNC(op_8a8_0), 0, 2216 }, /* BCLR.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8b0_3), 0, 2224 }, /* BCLR.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8b8_0), 0, 2232 }, /* BCLR.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8b9_0), 0, 2233 }, /* BCLR.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8ba_0), 0, 2234 }, /* BCLR.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8bb_3), 0, 2235 }, /* BCLR.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_8c0_0), 0, 2240 }, /* BSET.L #<data>.W,Dn */
{ CPUFUNC(op_8d0_0), 0, 2256 }, /* BSET.B #<data>.W,(An) */
{ CPUFUNC(op_8d8_0), 0, 2264 }, /* BSET.B #<data>.W,(An)+ */
{ CPUFUNC(op_8e0_0), 0, 2272 }, /* BSET.B #<data>.W,-(An) */
{ CPUFUNC(op_8e8_0), 0, 2280 }, /* BSET.B #<data>.W,(d16,An) */
{ CPUFUNC(op_8f0_3), 0, 2288 }, /* BSET.B #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_8f8_0), 0, 2296 }, /* BSET.B #<data>.W,(xxx).W */
{ CPUFUNC(op_8f9_0), 0, 2297 }, /* BSET.B #<data>.W,(xxx).L */
{ CPUFUNC(op_8fa_0), 0, 2298 }, /* BSET.B #<data>.W,(d16,PC) */
{ CPUFUNC(op_8fb_3), 0, 2299 }, /* BSET.B #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_a00_0), 0, 2560 }, /* EOR.B #<data>.B,Dn */
{ CPUFUNC(op_a10_0), 0, 2576 }, /* EOR.B #<data>.B,(An) */
{ CPUFUNC(op_a18_0), 0, 2584 }, /* EOR.B #<data>.B,(An)+ */
{ CPUFUNC(op_a20_0), 0, 2592 }, /* EOR.B #<data>.B,-(An) */
{ CPUFUNC(op_a28_0), 0, 2600 }, /* EOR.B #<data>.B,(d16,An) */
{ CPUFUNC(op_a30_3), 0, 2608 }, /* EOR.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_a38_0), 0, 2616 }, /* EOR.B #<data>.B,(xxx).W */
{ CPUFUNC(op_a39_0), 0, 2617 }, /* EOR.B #<data>.B,(xxx).L */
{ CPUFUNC(op_a3c_0), 0, 2620 }, /* EORSR.B #<data>.W */
{ CPUFUNC(op_a40_0), 0, 2624 }, /* EOR.W #<data>.W,Dn */
{ CPUFUNC(op_a50_0), 0, 2640 }, /* EOR.W #<data>.W,(An) */
{ CPUFUNC(op_a58_0), 0, 2648 }, /* EOR.W #<data>.W,(An)+ */
{ CPUFUNC(op_a60_0), 0, 2656 }, /* EOR.W #<data>.W,-(An) */
{ CPUFUNC(op_a68_0), 0, 2664 }, /* EOR.W #<data>.W,(d16,An) */
{ CPUFUNC(op_a70_3), 0, 2672 }, /* EOR.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_a78_0), 0, 2680 }, /* EOR.W #<data>.W,(xxx).W */
{ CPUFUNC(op_a79_0), 0, 2681 }, /* EOR.W #<data>.W,(xxx).L */
{ CPUFUNC(op_a7c_0), 0, 2684 }, /* EORSR.W #<data>.W */
{ CPUFUNC(op_a80_0), 0, 2688 }, /* EOR.L #<data>.L,Dn */
{ CPUFUNC(op_a90_0), 0, 2704 }, /* EOR.L #<data>.L,(An) */
{ CPUFUNC(op_a98_0), 0, 2712 }, /* EOR.L #<data>.L,(An)+ */
{ CPUFUNC(op_aa0_0), 0, 2720 }, /* EOR.L #<data>.L,-(An) */
{ CPUFUNC(op_aa8_0), 0, 2728 }, /* EOR.L #<data>.L,(d16,An) */
{ CPUFUNC(op_ab0_3), 0, 2736 }, /* EOR.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_ab8_0), 0, 2744 }, /* EOR.L #<data>.L,(xxx).W */
{ CPUFUNC(op_ab9_0), 0, 2745 }, /* EOR.L #<data>.L,(xxx).L */
{ CPUFUNC(op_c00_0), 0, 3072 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_c10_0), 0, 3088 }, /* CMP.B #<data>.B,(An) */
{ CPUFUNC(op_c18_0), 0, 3096 }, /* CMP.B #<data>.B,(An)+ */
{ CPUFUNC(op_c20_0), 0, 3104 }, /* CMP.B #<data>.B,-(An) */
{ CPUFUNC(op_c28_0), 0, 3112 }, /* CMP.B #<data>.B,(d16,An) */
{ CPUFUNC(op_c30_3), 0, 3120 }, /* CMP.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_c38_0), 0, 3128 }, /* CMP.B #<data>.B,(xxx).W */
{ CPUFUNC(op_c39_0), 0, 3129 }, /* CMP.B #<data>.B,(xxx).L */
{ CPUFUNC(op_c3a_0), 0, 3130 }, /* CMP.B #<data>.B,(d16,PC) */
{ CPUFUNC(op_c3b_3), 0, 3131 }, /* CMP.B #<data>.B,(d8,PC,Xn) */
{ CPUFUNC(op_c40_0), 0, 3136 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_c50_0), 0, 3152 }, /* CMP.W #<data>.W,(An) */
{ CPUFUNC(op_c58_0), 0, 3160 }, /* CMP.W #<data>.W,(An)+ */
{ CPUFUNC(op_c60_0), 0, 3168 }, /* CMP.W #<data>.W,-(An) */
{ CPUFUNC(op_c68_0), 0, 3176 }, /* CMP.W #<data>.W,(d16,An) */
{ CPUFUNC(op_c70_3), 0, 3184 }, /* CMP.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_c78_0), 0, 3192 }, /* CMP.W #<data>.W,(xxx).W */
{ CPUFUNC(op_c79_0), 0, 3193 }, /* CMP.W #<data>.W,(xxx).L */
{ CPUFUNC(op_c7a_0), 0, 3194 }, /* CMP.W #<data>.W,(d16,PC) */
{ CPUFUNC(op_c7b_3), 0, 3195 }, /* CMP.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC(op_c80_0), 0, 3200 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_c90_0), 0, 3216 }, /* CMP.L #<data>.L,(An) */
{ CPUFUNC(op_c98_0), 0, 3224 }, /* CMP.L #<data>.L,(An)+ */
{ CPUFUNC(op_ca0_0), 0, 3232 }, /* CMP.L #<data>.L,-(An) */
{ CPUFUNC(op_ca8_0), 0, 3240 }, /* CMP.L #<data>.L,(d16,An) */
{ CPUFUNC(op_cb0_3), 0, 3248 }, /* CMP.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_cb8_0), 0, 3256 }, /* CMP.L #<data>.L,(xxx).W */
{ CPUFUNC(op_cb9_0), 0, 3257 }, /* CMP.L #<data>.L,(xxx).L */
{ CPUFUNC(op_cba_0), 0, 3258 }, /* CMP.L #<data>.L,(d16,PC) */
{ CPUFUNC(op_cbb_3), 0, 3259 }, /* CMP.L #<data>.L,(d8,PC,Xn) */
{ CPUFUNC(op_1000_0), 0, 4096 }, /* MOVE.B Dn,Dn */
{ CPUFUNC(op_1010_0), 0, 4112 }, /* MOVE.B (An),Dn */
{ CPUFUNC(op_1018_0), 0, 4120 }, /* MOVE.B (An)+,Dn */
{ CPUFUNC(op_1020_0), 0, 4128 }, /* MOVE.B -(An),Dn */
{ CPUFUNC(op_1028_0), 0, 4136 }, /* MOVE.B (d16,An),Dn */
{ CPUFUNC(op_1030_3), 0, 4144 }, /* MOVE.B (d8,An,Xn),Dn */
{ CPUFUNC(op_1038_0), 0, 4152 }, /* MOVE.B (xxx).W,Dn */
{ CPUFUNC(op_1039_0), 0, 4153 }, /* MOVE.B (xxx).L,Dn */
{ CPUFUNC(op_103a_0), 0, 4154 }, /* MOVE.B (d16,PC),Dn */
{ CPUFUNC(op_103b_3), 0, 4155 }, /* MOVE.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_103c_0), 0, 4156 }, /* MOVE.B #<data>.B,Dn */
{ CPUFUNC(op_1080_0), 0, 4224 }, /* MOVE.B Dn,(An) */
{ CPUFUNC(op_1090_0), 0, 4240 }, /* MOVE.B (An),(An) */
{ CPUFUNC(op_1098_0), 0, 4248 }, /* MOVE.B (An)+,(An) */
{ CPUFUNC(op_10a0_0), 0, 4256 }, /* MOVE.B -(An),(An) */
{ CPUFUNC(op_10a8_0), 0, 4264 }, /* MOVE.B (d16,An),(An) */
{ CPUFUNC(op_10b0_3), 0, 4272 }, /* MOVE.B (d8,An,Xn),(An) */
{ CPUFUNC(op_10b8_0), 0, 4280 }, /* MOVE.B (xxx).W,(An) */
{ CPUFUNC(op_10b9_0), 0, 4281 }, /* MOVE.B (xxx).L,(An) */
{ CPUFUNC(op_10ba_0), 0, 4282 }, /* MOVE.B (d16,PC),(An) */
{ CPUFUNC(op_10bb_3), 0, 4283 }, /* MOVE.B (d8,PC,Xn),(An) */
{ CPUFUNC(op_10bc_0), 0, 4284 }, /* MOVE.B #<data>.B,(An) */
{ CPUFUNC(op_10c0_0), 0, 4288 }, /* MOVE.B Dn,(An)+ */
{ CPUFUNC(op_10d0_0), 0, 4304 }, /* MOVE.B (An),(An)+ */
{ CPUFUNC(op_10d8_0), 0, 4312 }, /* MOVE.B (An)+,(An)+ */
{ CPUFUNC(op_10e0_0), 0, 4320 }, /* MOVE.B -(An),(An)+ */
{ CPUFUNC(op_10e8_0), 0, 4328 }, /* MOVE.B (d16,An),(An)+ */
{ CPUFUNC(op_10f0_3), 0, 4336 }, /* MOVE.B (d8,An,Xn),(An)+ */
{ CPUFUNC(op_10f8_0), 0, 4344 }, /* MOVE.B (xxx).W,(An)+ */
{ CPUFUNC(op_10f9_0), 0, 4345 }, /* MOVE.B (xxx).L,(An)+ */
{ CPUFUNC(op_10fa_0), 0, 4346 }, /* MOVE.B (d16,PC),(An)+ */
{ CPUFUNC(op_10fb_3), 0, 4347 }, /* MOVE.B (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_10fc_0), 0, 4348 }, /* MOVE.B #<data>.B,(An)+ */
{ CPUFUNC(op_1100_0), 0, 4352 }, /* MOVE.B Dn,-(An) */
{ CPUFUNC(op_1110_0), 0, 4368 }, /* MOVE.B (An),-(An) */
{ CPUFUNC(op_1118_0), 0, 4376 }, /* MOVE.B (An)+,-(An) */
{ CPUFUNC(op_1120_0), 0, 4384 }, /* MOVE.B -(An),-(An) */
{ CPUFUNC(op_1128_0), 0, 4392 }, /* MOVE.B (d16,An),-(An) */
{ CPUFUNC(op_1130_3), 0, 4400 }, /* MOVE.B (d8,An,Xn),-(An) */
{ CPUFUNC(op_1138_0), 0, 4408 }, /* MOVE.B (xxx).W,-(An) */
{ CPUFUNC(op_1139_0), 0, 4409 }, /* MOVE.B (xxx).L,-(An) */
{ CPUFUNC(op_113a_0), 0, 4410 }, /* MOVE.B (d16,PC),-(An) */
{ CPUFUNC(op_113b_3), 0, 4411 }, /* MOVE.B (d8,PC,Xn),-(An) */
{ CPUFUNC(op_113c_0), 0, 4412 }, /* MOVE.B #<data>.B,-(An) */
{ CPUFUNC(op_1140_0), 0, 4416 }, /* MOVE.B Dn,(d16,An) */
{ CPUFUNC(op_1150_0), 0, 4432 }, /* MOVE.B (An),(d16,An) */
{ CPUFUNC(op_1158_0), 0, 4440 }, /* MOVE.B (An)+,(d16,An) */
{ CPUFUNC(op_1160_0), 0, 4448 }, /* MOVE.B -(An),(d16,An) */
{ CPUFUNC(op_1168_0), 0, 4456 }, /* MOVE.B (d16,An),(d16,An) */
{ CPUFUNC(op_1170_3), 0, 4464 }, /* MOVE.B (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_1178_0), 0, 4472 }, /* MOVE.B (xxx).W,(d16,An) */
{ CPUFUNC(op_1179_0), 0, 4473 }, /* MOVE.B (xxx).L,(d16,An) */
{ CPUFUNC(op_117a_0), 0, 4474 }, /* MOVE.B (d16,PC),(d16,An) */
{ CPUFUNC(op_117b_3), 0, 4475 }, /* MOVE.B (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_117c_0), 0, 4476 }, /* MOVE.B #<data>.B,(d16,An) */
{ CPUFUNC(op_1180_3), 0, 4480 }, /* MOVE.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_1190_3), 0, 4496 }, /* MOVE.B (An),(d8,An,Xn) */
{ CPUFUNC(op_1198_3), 0, 4504 }, /* MOVE.B (An)+,(d8,An,Xn) */
{ CPUFUNC(op_11a0_3), 0, 4512 }, /* MOVE.B -(An),(d8,An,Xn) */
{ CPUFUNC(op_11a8_3), 0, 4520 }, /* MOVE.B (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_11b0_3), 0, 4528 }, /* MOVE.B (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11b8_3), 0, 4536 }, /* MOVE.B (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_11b9_3), 0, 4537 }, /* MOVE.B (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_11ba_3), 0, 4538 }, /* MOVE.B (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_11bb_3), 0, 4539 }, /* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_11bc_3), 0, 4540 }, /* MOVE.B #<data>.B,(d8,An,Xn) */
{ CPUFUNC(op_11c0_0), 0, 4544 }, /* MOVE.B Dn,(xxx).W */
{ CPUFUNC(op_11d0_0), 0, 4560 }, /* MOVE.B (An),(xxx).W */
{ CPUFUNC(op_11d8_0), 0, 4568 }, /* MOVE.B (An)+,(xxx).W */
{ CPUFUNC(op_11e0_0), 0, 4576 }, /* MOVE.B -(An),(xxx).W */
{ CPUFUNC(op_11e8_0), 0, 4584 }, /* MOVE.B (d16,An),(xxx).W */
{ CPUFUNC(op_11f0_3), 0, 4592 }, /* MOVE.B (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_11f8_0), 0, 4600 }, /* MOVE.B (xxx).W,(xxx).W */
{ CPUFUNC(op_11f9_0), 0, 4601 }, /* MOVE.B (xxx).L,(xxx).W */
{ CPUFUNC(op_11fa_0), 0, 4602 }, /* MOVE.B (d16,PC),(xxx).W */
{ CPUFUNC(op_11fb_3), 0, 4603 }, /* MOVE.B (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_11fc_0), 0, 4604 }, /* MOVE.B #<data>.B,(xxx).W */
{ CPUFUNC(op_13c0_0), 0, 5056 }, /* MOVE.B Dn,(xxx).L */
{ CPUFUNC(op_13d0_0), 0, 5072 }, /* MOVE.B (An),(xxx).L */
{ CPUFUNC(op_13d8_0), 0, 5080 }, /* MOVE.B (An)+,(xxx).L */
{ CPUFUNC(op_13e0_0), 0, 5088 }, /* MOVE.B -(An),(xxx).L */
{ CPUFUNC(op_13e8_0), 0, 5096 }, /* MOVE.B (d16,An),(xxx).L */
{ CPUFUNC(op_13f0_3), 0, 5104 }, /* MOVE.B (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_13f8_0), 0, 5112 }, /* MOVE.B (xxx).W,(xxx).L */
{ CPUFUNC(op_13f9_0), 0, 5113 }, /* MOVE.B (xxx).L,(xxx).L */
{ CPUFUNC(op_13fa_0), 0, 5114 }, /* MOVE.B (d16,PC),(xxx).L */
{ CPUFUNC(op_13fb_3), 0, 5115 }, /* MOVE.B (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_13fc_0), 0, 5116 }, /* MOVE.B #<data>.B,(xxx).L */
{ CPUFUNC(op_2000_0), 0, 8192 }, /* MOVE.L Dn,Dn */
{ CPUFUNC(op_2008_0), 0, 8200 }, /* MOVE.L An,Dn */
{ CPUFUNC(op_2010_0), 0, 8208 }, /* MOVE.L (An),Dn */
{ CPUFUNC(op_2018_0), 0, 8216 }, /* MOVE.L (An)+,Dn */
{ CPUFUNC(op_2020_0), 0, 8224 }, /* MOVE.L -(An),Dn */
{ CPUFUNC(op_2028_0), 0, 8232 }, /* MOVE.L (d16,An),Dn */
{ CPUFUNC(op_2030_3), 0, 8240 }, /* MOVE.L (d8,An,Xn),Dn */
{ CPUFUNC(op_2038_0), 0, 8248 }, /* MOVE.L (xxx).W,Dn */
{ CPUFUNC(op_2039_0), 0, 8249 }, /* MOVE.L (xxx).L,Dn */
{ CPUFUNC(op_203a_0), 0, 8250 }, /* MOVE.L (d16,PC),Dn */
{ CPUFUNC(op_203b_3), 0, 8251 }, /* MOVE.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_203c_0), 0, 8252 }, /* MOVE.L #<data>.L,Dn */
{ CPUFUNC_FF(op_2040_0), 0, 8256 }, /* MOVEA.L Dn,An */
{ CPUFUNC_FF(op_2048_0), 0, 8264 }, /* MOVEA.L An,An */
{ CPUFUNC_FF(op_2050_0), 0, 8272 }, /* MOVEA.L (An),An */
{ CPUFUNC_FF(op_2058_0), 0, 8280 }, /* MOVEA.L (An)+,An */
{ CPUFUNC_FF(op_2060_0), 0, 8288 }, /* MOVEA.L -(An),An */
{ CPUFUNC_FF(op_2068_0), 0, 8296 }, /* MOVEA.L (d16,An),An */
{ CPUFUNC_FF(op_2070_3), 0, 8304 }, /* MOVEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_2078_0), 0, 8312 }, /* MOVEA.L (xxx).W,An */
{ CPUFUNC_FF(op_2079_0), 0, 8313 }, /* MOVEA.L (xxx).L,An */
{ CPUFUNC_FF(op_207a_0), 0, 8314 }, /* MOVEA.L (d16,PC),An */
{ CPUFUNC_FF(op_207b_3), 0, 8315 }, /* MOVEA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_207c_0), 0, 8316 }, /* MOVEA.L #<data>.L,An */
{ CPUFUNC(op_2080_0), 0, 8320 }, /* MOVE.L Dn,(An) */
{ CPUFUNC(op_2088_0), 0, 8328 }, /* MOVE.L An,(An) */
{ CPUFUNC(op_2090_0), 0, 8336 }, /* MOVE.L (An),(An) */
{ CPUFUNC(op_2098_0), 0, 8344 }, /* MOVE.L (An)+,(An) */
{ CPUFUNC(op_20a0_0), 0, 8352 }, /* MOVE.L -(An),(An) */
{ CPUFUNC(op_20a8_0), 0, 8360 }, /* MOVE.L (d16,An),(An) */
{ CPUFUNC(op_20b0_3), 0, 8368 }, /* MOVE.L (d8,An,Xn),(An) */
{ CPUFUNC(op_20b8_0), 0, 8376 }, /* MOVE.L (xxx).W,(An) */
{ CPUFUNC(op_20b9_0), 0, 8377 }, /* MOVE.L (xxx).L,(An) */
{ CPUFUNC(op_20ba_0), 0, 8378 }, /* MOVE.L (d16,PC),(An) */
{ CPUFUNC(op_20bb_3), 0, 8379 }, /* MOVE.L (d8,PC,Xn),(An) */
{ CPUFUNC(op_20bc_0), 0, 8380 }, /* MOVE.L #<data>.L,(An) */
{ CPUFUNC(op_20c0_0), 0, 8384 }, /* MOVE.L Dn,(An)+ */
{ CPUFUNC(op_20c8_0), 0, 8392 }, /* MOVE.L An,(An)+ */
{ CPUFUNC(op_20d0_0), 0, 8400 }, /* MOVE.L (An),(An)+ */
{ CPUFUNC(op_20d8_0), 0, 8408 }, /* MOVE.L (An)+,(An)+ */
{ CPUFUNC(op_20e0_0), 0, 8416 }, /* MOVE.L -(An),(An)+ */
{ CPUFUNC(op_20e8_0), 0, 8424 }, /* MOVE.L (d16,An),(An)+ */
{ CPUFUNC(op_20f0_3), 0, 8432 }, /* MOVE.L (d8,An,Xn),(An)+ */
{ CPUFUNC(op_20f8_0), 0, 8440 }, /* MOVE.L (xxx).W,(An)+ */
{ CPUFUNC(op_20f9_0), 0, 8441 }, /* MOVE.L (xxx).L,(An)+ */
{ CPUFUNC(op_20fa_0), 0, 8442 }, /* MOVE.L (d16,PC),(An)+ */
{ CPUFUNC(op_20fb_3), 0, 8443 }, /* MOVE.L (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_20fc_0), 0, 8444 }, /* MOVE.L #<data>.L,(An)+ */
{ CPUFUNC(op_2100_0), 0, 8448 }, /* MOVE.L Dn,-(An) */
{ CPUFUNC(op_2108_0), 0, 8456 }, /* MOVE.L An,-(An) */
{ CPUFUNC(op_2110_0), 0, 8464 }, /* MOVE.L (An),-(An) */
{ CPUFUNC(op_2118_0), 0, 8472 }, /* MOVE.L (An)+,-(An) */
{ CPUFUNC(op_2120_0), 0, 8480 }, /* MOVE.L -(An),-(An) */
{ CPUFUNC(op_2128_0), 0, 8488 }, /* MOVE.L (d16,An),-(An) */
{ CPUFUNC(op_2130_3), 0, 8496 }, /* MOVE.L (d8,An,Xn),-(An) */
{ CPUFUNC(op_2138_0), 0, 8504 }, /* MOVE.L (xxx).W,-(An) */
{ CPUFUNC(op_2139_0), 0, 8505 }, /* MOVE.L (xxx).L,-(An) */
{ CPUFUNC(op_213a_0), 0, 8506 }, /* MOVE.L (d16,PC),-(An) */
{ CPUFUNC(op_213b_3), 0, 8507 }, /* MOVE.L (d8,PC,Xn),-(An) */
{ CPUFUNC(op_213c_0), 0, 8508 }, /* MOVE.L #<data>.L,-(An) */
{ CPUFUNC(op_2140_0), 0, 8512 }, /* MOVE.L Dn,(d16,An) */
{ CPUFUNC(op_2148_0), 0, 8520 }, /* MOVE.L An,(d16,An) */
{ CPUFUNC(op_2150_0), 0, 8528 }, /* MOVE.L (An),(d16,An) */
{ CPUFUNC(op_2158_0), 0, 8536 }, /* MOVE.L (An)+,(d16,An) */
{ CPUFUNC(op_2160_0), 0, 8544 }, /* MOVE.L -(An),(d16,An) */
{ CPUFUNC(op_2168_0), 0, 8552 }, /* MOVE.L (d16,An),(d16,An) */
{ CPUFUNC(op_2170_3), 0, 8560 }, /* MOVE.L (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_2178_0), 0, 8568 }, /* MOVE.L (xxx).W,(d16,An) */
{ CPUFUNC(op_2179_0), 0, 8569 }, /* MOVE.L (xxx).L,(d16,An) */
{ CPUFUNC(op_217a_0), 0, 8570 }, /* MOVE.L (d16,PC),(d16,An) */
{ CPUFUNC(op_217b_3), 0, 8571 }, /* MOVE.L (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_217c_0), 0, 8572 }, /* MOVE.L #<data>.L,(d16,An) */
{ CPUFUNC(op_2180_3), 0, 8576 }, /* MOVE.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_2188_3), 0, 8584 }, /* MOVE.L An,(d8,An,Xn) */
{ CPUFUNC(op_2190_3), 0, 8592 }, /* MOVE.L (An),(d8,An,Xn) */
{ CPUFUNC(op_2198_3), 0, 8600 }, /* MOVE.L (An)+,(d8,An,Xn) */
{ CPUFUNC(op_21a0_3), 0, 8608 }, /* MOVE.L -(An),(d8,An,Xn) */
{ CPUFUNC(op_21a8_3), 0, 8616 }, /* MOVE.L (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_21b0_3), 0, 8624 }, /* MOVE.L (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21b8_3), 0, 8632 }, /* MOVE.L (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_21b9_3), 0, 8633 }, /* MOVE.L (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_21ba_3), 0, 8634 }, /* MOVE.L (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_21bb_3), 0, 8635 }, /* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_21bc_3), 0, 8636 }, /* MOVE.L #<data>.L,(d8,An,Xn) */
{ CPUFUNC(op_21c0_0), 0, 8640 }, /* MOVE.L Dn,(xxx).W */
{ CPUFUNC(op_21c8_0), 0, 8648 }, /* MOVE.L An,(xxx).W */
{ CPUFUNC(op_21d0_0), 0, 8656 }, /* MOVE.L (An),(xxx).W */
{ CPUFUNC(op_21d8_0), 0, 8664 }, /* MOVE.L (An)+,(xxx).W */
{ CPUFUNC(op_21e0_0), 0, 8672 }, /* MOVE.L -(An),(xxx).W */
{ CPUFUNC(op_21e8_0), 0, 8680 }, /* MOVE.L (d16,An),(xxx).W */
{ CPUFUNC(op_21f0_3), 0, 8688 }, /* MOVE.L (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_21f8_0), 0, 8696 }, /* MOVE.L (xxx).W,(xxx).W */
{ CPUFUNC(op_21f9_0), 0, 8697 }, /* MOVE.L (xxx).L,(xxx).W */
{ CPUFUNC(op_21fa_0), 0, 8698 }, /* MOVE.L (d16,PC),(xxx).W */
{ CPUFUNC(op_21fb_3), 0, 8699 }, /* MOVE.L (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_21fc_0), 0, 8700 }, /* MOVE.L #<data>.L,(xxx).W */
{ CPUFUNC(op_23c0_0), 0, 9152 }, /* MOVE.L Dn,(xxx).L */
{ CPUFUNC(op_23c8_0), 0, 9160 }, /* MOVE.L An,(xxx).L */
{ CPUFUNC(op_23d0_0), 0, 9168 }, /* MOVE.L (An),(xxx).L */
{ CPUFUNC(op_23d8_0), 0, 9176 }, /* MOVE.L (An)+,(xxx).L */
{ CPUFUNC(op_23e0_0), 0, 9184 }, /* MOVE.L -(An),(xxx).L */
{ CPUFUNC(op_23e8_0), 0, 9192 }, /* MOVE.L (d16,An),(xxx).L */
{ CPUFUNC(op_23f0_3), 0, 9200 }, /* MOVE.L (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_23f8_0), 0, 9208 }, /* MOVE.L (xxx).W,(xxx).L */
{ CPUFUNC(op_23f9_0), 0, 9209 }, /* MOVE.L (xxx).L,(xxx).L */
{ CPUFUNC(op_23fa_0), 0, 9210 }, /* MOVE.L (d16,PC),(xxx).L */
{ CPUFUNC(op_23fb_3), 0, 9211 }, /* MOVE.L (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_23fc_0), 0, 9212 }, /* MOVE.L #<data>.L,(xxx).L */
{ CPUFUNC(op_3000_0), 0, 12288 }, /* MOVE.W Dn,Dn */
{ CPUFUNC(op_3008_0), 0, 12296 }, /* MOVE.W An,Dn */
{ CPUFUNC(op_3010_0), 0, 12304 }, /* MOVE.W (An),Dn */
{ CPUFUNC(op_3018_0), 0, 12312 }, /* MOVE.W (An)+,Dn */
{ CPUFUNC(op_3020_0), 0, 12320 }, /* MOVE.W -(An),Dn */
{ CPUFUNC(op_3028_0), 0, 12328 }, /* MOVE.W (d16,An),Dn */
{ CPUFUNC(op_3030_3), 0, 12336 }, /* MOVE.W (d8,An,Xn),Dn */
{ CPUFUNC(op_3038_0), 0, 12344 }, /* MOVE.W (xxx).W,Dn */
{ CPUFUNC(op_3039_0), 0, 12345 }, /* MOVE.W (xxx).L,Dn */
{ CPUFUNC(op_303a_0), 0, 12346 }, /* MOVE.W (d16,PC),Dn */
{ CPUFUNC(op_303b_3), 0, 12347 }, /* MOVE.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_303c_0), 0, 12348 }, /* MOVE.W #<data>.W,Dn */
{ CPUFUNC_FF(op_3040_0), 0, 12352 }, /* MOVEA.W Dn,An */
{ CPUFUNC_FF(op_3048_0), 0, 12360 }, /* MOVEA.W An,An */
{ CPUFUNC_FF(op_3050_0), 0, 12368 }, /* MOVEA.W (An),An */
{ CPUFUNC_FF(op_3058_0), 0, 12376 }, /* MOVEA.W (An)+,An */
{ CPUFUNC_FF(op_3060_0), 0, 12384 }, /* MOVEA.W -(An),An */
{ CPUFUNC_FF(op_3068_0), 0, 12392 }, /* MOVEA.W (d16,An),An */
{ CPUFUNC_FF(op_3070_3), 0, 12400 }, /* MOVEA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_3078_0), 0, 12408 }, /* MOVEA.W (xxx).W,An */
{ CPUFUNC_FF(op_3079_0), 0, 12409 }, /* MOVEA.W (xxx).L,An */
{ CPUFUNC_FF(op_307a_0), 0, 12410 }, /* MOVEA.W (d16,PC),An */
{ CPUFUNC_FF(op_307b_3), 0, 12411 }, /* MOVEA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_307c_0), 0, 12412 }, /* MOVEA.W #<data>.W,An */
{ CPUFUNC(op_3080_0), 0, 12416 }, /* MOVE.W Dn,(An) */
{ CPUFUNC(op_3088_0), 0, 12424 }, /* MOVE.W An,(An) */
{ CPUFUNC(op_3090_0), 0, 12432 }, /* MOVE.W (An),(An) */
{ CPUFUNC(op_3098_0), 0, 12440 }, /* MOVE.W (An)+,(An) */
{ CPUFUNC(op_30a0_0), 0, 12448 }, /* MOVE.W -(An),(An) */
{ CPUFUNC(op_30a8_0), 0, 12456 }, /* MOVE.W (d16,An),(An) */
{ CPUFUNC(op_30b0_3), 0, 12464 }, /* MOVE.W (d8,An,Xn),(An) */
{ CPUFUNC(op_30b8_0), 0, 12472 }, /* MOVE.W (xxx).W,(An) */
{ CPUFUNC(op_30b9_0), 0, 12473 }, /* MOVE.W (xxx).L,(An) */
{ CPUFUNC(op_30ba_0), 0, 12474 }, /* MOVE.W (d16,PC),(An) */
{ CPUFUNC(op_30bb_3), 0, 12475 }, /* MOVE.W (d8,PC,Xn),(An) */
{ CPUFUNC(op_30bc_0), 0, 12476 }, /* MOVE.W #<data>.W,(An) */
{ CPUFUNC(op_30c0_0), 0, 12480 }, /* MOVE.W Dn,(An)+ */
{ CPUFUNC(op_30c8_0), 0, 12488 }, /* MOVE.W An,(An)+ */
{ CPUFUNC(op_30d0_0), 0, 12496 }, /* MOVE.W (An),(An)+ */
{ CPUFUNC(op_30d8_0), 0, 12504 }, /* MOVE.W (An)+,(An)+ */
{ CPUFUNC(op_30e0_0), 0, 12512 }, /* MOVE.W -(An),(An)+ */
{ CPUFUNC(op_30e8_0), 0, 12520 }, /* MOVE.W (d16,An),(An)+ */
{ CPUFUNC(op_30f0_3), 0, 12528 }, /* MOVE.W (d8,An,Xn),(An)+ */
{ CPUFUNC(op_30f8_0), 0, 12536 }, /* MOVE.W (xxx).W,(An)+ */
{ CPUFUNC(op_30f9_0), 0, 12537 }, /* MOVE.W (xxx).L,(An)+ */
{ CPUFUNC(op_30fa_0), 0, 12538 }, /* MOVE.W (d16,PC),(An)+ */
{ CPUFUNC(op_30fb_3), 0, 12539 }, /* MOVE.W (d8,PC,Xn),(An)+ */
{ CPUFUNC(op_30fc_0), 0, 12540 }, /* MOVE.W #<data>.W,(An)+ */
{ CPUFUNC(op_3100_0), 0, 12544 }, /* MOVE.W Dn,-(An) */
{ CPUFUNC(op_3108_0), 0, 12552 }, /* MOVE.W An,-(An) */
{ CPUFUNC(op_3110_0), 0, 12560 }, /* MOVE.W (An),-(An) */
{ CPUFUNC(op_3118_0), 0, 12568 }, /* MOVE.W (An)+,-(An) */
{ CPUFUNC(op_3120_0), 0, 12576 }, /* MOVE.W -(An),-(An) */
{ CPUFUNC(op_3128_0), 0, 12584 }, /* MOVE.W (d16,An),-(An) */
{ CPUFUNC(op_3130_3), 0, 12592 }, /* MOVE.W (d8,An,Xn),-(An) */
{ CPUFUNC(op_3138_0), 0, 12600 }, /* MOVE.W (xxx).W,-(An) */
{ CPUFUNC(op_3139_0), 0, 12601 }, /* MOVE.W (xxx).L,-(An) */
{ CPUFUNC(op_313a_0), 0, 12602 }, /* MOVE.W (d16,PC),-(An) */
{ CPUFUNC(op_313b_3), 0, 12603 }, /* MOVE.W (d8,PC,Xn),-(An) */
{ CPUFUNC(op_313c_0), 0, 12604 }, /* MOVE.W #<data>.W,-(An) */
{ CPUFUNC(op_3140_0), 0, 12608 }, /* MOVE.W Dn,(d16,An) */
{ CPUFUNC(op_3148_0), 0, 12616 }, /* MOVE.W An,(d16,An) */
{ CPUFUNC(op_3150_0), 0, 12624 }, /* MOVE.W (An),(d16,An) */
{ CPUFUNC(op_3158_0), 0, 12632 }, /* MOVE.W (An)+,(d16,An) */
{ CPUFUNC(op_3160_0), 0, 12640 }, /* MOVE.W -(An),(d16,An) */
{ CPUFUNC(op_3168_0), 0, 12648 }, /* MOVE.W (d16,An),(d16,An) */
{ CPUFUNC(op_3170_3), 0, 12656 }, /* MOVE.W (d8,An,Xn),(d16,An) */
{ CPUFUNC(op_3178_0), 0, 12664 }, /* MOVE.W (xxx).W,(d16,An) */
{ CPUFUNC(op_3179_0), 0, 12665 }, /* MOVE.W (xxx).L,(d16,An) */
{ CPUFUNC(op_317a_0), 0, 12666 }, /* MOVE.W (d16,PC),(d16,An) */
{ CPUFUNC(op_317b_3), 0, 12667 }, /* MOVE.W (d8,PC,Xn),(d16,An) */
{ CPUFUNC(op_317c_0), 0, 12668 }, /* MOVE.W #<data>.W,(d16,An) */
{ CPUFUNC(op_3180_3), 0, 12672 }, /* MOVE.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_3188_3), 0, 12680 }, /* MOVE.W An,(d8,An,Xn) */
{ CPUFUNC(op_3190_3), 0, 12688 }, /* MOVE.W (An),(d8,An,Xn) */
{ CPUFUNC(op_3198_3), 0, 12696 }, /* MOVE.W (An)+,(d8,An,Xn) */
{ CPUFUNC(op_31a0_3), 0, 12704 }, /* MOVE.W -(An),(d8,An,Xn) */
{ CPUFUNC(op_31a8_3), 0, 12712 }, /* MOVE.W (d16,An),(d8,An,Xn) */
{ CPUFUNC(op_31b0_3), 0, 12720 }, /* MOVE.W (d8,An,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31b8_3), 0, 12728 }, /* MOVE.W (xxx).W,(d8,An,Xn) */
{ CPUFUNC(op_31b9_3), 0, 12729 }, /* MOVE.W (xxx).L,(d8,An,Xn) */
{ CPUFUNC(op_31ba_3), 0, 12730 }, /* MOVE.W (d16,PC),(d8,An,Xn) */
{ CPUFUNC(op_31bb_3), 0, 12731 }, /* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
{ CPUFUNC(op_31bc_3), 0, 12732 }, /* MOVE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC(op_31c0_0), 0, 12736 }, /* MOVE.W Dn,(xxx).W */
{ CPUFUNC(op_31c8_0), 0, 12744 }, /* MOVE.W An,(xxx).W */
{ CPUFUNC(op_31d0_0), 0, 12752 }, /* MOVE.W (An),(xxx).W */
{ CPUFUNC(op_31d8_0), 0, 12760 }, /* MOVE.W (An)+,(xxx).W */
{ CPUFUNC(op_31e0_0), 0, 12768 }, /* MOVE.W -(An),(xxx).W */
{ CPUFUNC(op_31e8_0), 0, 12776 }, /* MOVE.W (d16,An),(xxx).W */
{ CPUFUNC(op_31f0_3), 0, 12784 }, /* MOVE.W (d8,An,Xn),(xxx).W */
{ CPUFUNC(op_31f8_0), 0, 12792 }, /* MOVE.W (xxx).W,(xxx).W */
{ CPUFUNC(op_31f9_0), 0, 12793 }, /* MOVE.W (xxx).L,(xxx).W */
{ CPUFUNC(op_31fa_0), 0, 12794 }, /* MOVE.W (d16,PC),(xxx).W */
{ CPUFUNC(op_31fb_3), 0, 12795 }, /* MOVE.W (d8,PC,Xn),(xxx).W */
{ CPUFUNC(op_31fc_0), 0, 12796 }, /* MOVE.W #<data>.W,(xxx).W */
{ CPUFUNC(op_33c0_0), 0, 13248 }, /* MOVE.W Dn,(xxx).L */
{ CPUFUNC(op_33c8_0), 0, 13256 }, /* MOVE.W An,(xxx).L */
{ CPUFUNC(op_33d0_0), 0, 13264 }, /* MOVE.W (An),(xxx).L */
{ CPUFUNC(op_33d8_0), 0, 13272 }, /* MOVE.W (An)+,(xxx).L */
{ CPUFUNC(op_33e0_0), 0, 13280 }, /* MOVE.W -(An),(xxx).L */
{ CPUFUNC(op_33e8_0), 0, 13288 }, /* MOVE.W (d16,An),(xxx).L */
{ CPUFUNC(op_33f0_3), 0, 13296 }, /* MOVE.W (d8,An,Xn),(xxx).L */
{ CPUFUNC(op_33f8_0), 0, 13304 }, /* MOVE.W (xxx).W,(xxx).L */
{ CPUFUNC(op_33f9_0), 0, 13305 }, /* MOVE.W (xxx).L,(xxx).L */
{ CPUFUNC(op_33fa_0), 0, 13306 }, /* MOVE.W (d16,PC),(xxx).L */
{ CPUFUNC(op_33fb_3), 0, 13307 }, /* MOVE.W (d8,PC,Xn),(xxx).L */
{ CPUFUNC(op_33fc_0), 0, 13308 }, /* MOVE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_4000_0), 0, 16384 }, /* NEGX.B Dn */
{ CPUFUNC(op_4010_0), 0, 16400 }, /* NEGX.B (An) */
{ CPUFUNC(op_4018_0), 0, 16408 }, /* NEGX.B (An)+ */
{ CPUFUNC(op_4020_0), 0, 16416 }, /* NEGX.B -(An) */
{ CPUFUNC(op_4028_0), 0, 16424 }, /* NEGX.B (d16,An) */
{ CPUFUNC(op_4030_3), 0, 16432 }, /* NEGX.B (d8,An,Xn) */
{ CPUFUNC(op_4038_0), 0, 16440 }, /* NEGX.B (xxx).W */
{ CPUFUNC(op_4039_0), 0, 16441 }, /* NEGX.B (xxx).L */
{ CPUFUNC(op_4040_0), 0, 16448 }, /* NEGX.W Dn */
{ CPUFUNC(op_4050_0), 0, 16464 }, /* NEGX.W (An) */
{ CPUFUNC(op_4058_0), 0, 16472 }, /* NEGX.W (An)+ */
{ CPUFUNC(op_4060_0), 0, 16480 }, /* NEGX.W -(An) */
{ CPUFUNC(op_4068_0), 0, 16488 }, /* NEGX.W (d16,An) */
{ CPUFUNC(op_4070_3), 0, 16496 }, /* NEGX.W (d8,An,Xn) */
{ CPUFUNC(op_4078_0), 0, 16504 }, /* NEGX.W (xxx).W */
{ CPUFUNC(op_4079_0), 0, 16505 }, /* NEGX.W (xxx).L */
{ CPUFUNC(op_4080_0), 0, 16512 }, /* NEGX.L Dn */
{ CPUFUNC(op_4090_0), 0, 16528 }, /* NEGX.L (An) */
{ CPUFUNC(op_4098_0), 0, 16536 }, /* NEGX.L (An)+ */
{ CPUFUNC(op_40a0_0), 0, 16544 }, /* NEGX.L -(An) */
{ CPUFUNC(op_40a8_0), 0, 16552 }, /* NEGX.L (d16,An) */
{ CPUFUNC(op_40b0_3), 0, 16560 }, /* NEGX.L (d8,An,Xn) */
{ CPUFUNC(op_40b8_0), 0, 16568 }, /* NEGX.L (xxx).W */
{ CPUFUNC(op_40b9_0), 0, 16569 }, /* NEGX.L (xxx).L */
{ CPUFUNC_FF(op_40c0_4), 0, 16576 }, /* MVSR2.W Dn */
{ CPUFUNC_FF(op_40d0_4), 0, 16592 }, /* MVSR2.W (An) */
{ CPUFUNC_FF(op_40d8_4), 0, 16600 }, /* MVSR2.W (An)+ */
{ CPUFUNC_FF(op_40e0_4), 0, 16608 }, /* MVSR2.W -(An) */
{ CPUFUNC_FF(op_40e8_4), 0, 16616 }, /* MVSR2.W (d16,An) */
{ CPUFUNC_FF(op_40f0_4), 0, 16624 }, /* MVSR2.W (d8,An,Xn) */
{ CPUFUNC_FF(op_40f8_4), 0, 16632 }, /* MVSR2.W (xxx).W */
{ CPUFUNC_FF(op_40f9_4), 0, 16633 }, /* MVSR2.W (xxx).L */
{ CPUFUNC(op_4100_0), 0, 16640 }, /* CHK.L Dn,Dn */
{ CPUFUNC(op_4110_0), 0, 16656 }, /* CHK.L (An),Dn */
{ CPUFUNC(op_4118_0), 0, 16664 }, /* CHK.L (An)+,Dn */
{ CPUFUNC(op_4120_0), 0, 16672 }, /* CHK.L -(An),Dn */
{ CPUFUNC(op_4128_0), 0, 16680 }, /* CHK.L (d16,An),Dn */
{ CPUFUNC(op_4130_3), 0, 16688 }, /* CHK.L (d8,An,Xn),Dn */
{ CPUFUNC(op_4138_0), 0, 16696 }, /* CHK.L (xxx).W,Dn */
{ CPUFUNC(op_4139_0), 0, 16697 }, /* CHK.L (xxx).L,Dn */
{ CPUFUNC(op_413a_0), 0, 16698 }, /* CHK.L (d16,PC),Dn */
{ CPUFUNC(op_413b_3), 0, 16699 }, /* CHK.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_413c_0), 0, 16700 }, /* CHK.L #<data>.L,Dn */
{ CPUFUNC(op_4180_0), 0, 16768 }, /* CHK.W Dn,Dn */
{ CPUFUNC(op_4190_0), 0, 16784 }, /* CHK.W (An),Dn */
{ CPUFUNC(op_4198_0), 0, 16792 }, /* CHK.W (An)+,Dn */
{ CPUFUNC(op_41a0_0), 0, 16800 }, /* CHK.W -(An),Dn */
{ CPUFUNC(op_41a8_0), 0, 16808 }, /* CHK.W (d16,An),Dn */
{ CPUFUNC(op_41b0_3), 0, 16816 }, /* CHK.W (d8,An,Xn),Dn */
{ CPUFUNC(op_41b8_0), 0, 16824 }, /* CHK.W (xxx).W,Dn */
{ CPUFUNC(op_41b9_0), 0, 16825 }, /* CHK.W (xxx).L,Dn */
{ CPUFUNC(op_41ba_0), 0, 16826 }, /* CHK.W (d16,PC),Dn */
{ CPUFUNC(op_41bb_3), 0, 16827 }, /* CHK.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_41bc_0), 0, 16828 }, /* CHK.W #<data>.W,Dn */
{ CPUFUNC_FF(op_41d0_0), 0, 16848 }, /* LEA.L (An),An */
{ CPUFUNC_FF(op_41e8_0), 0, 16872 }, /* LEA.L (d16,An),An */
{ CPUFUNC_FF(op_41f0_3), 0, 16880 }, /* LEA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_41f8_0), 0, 16888 }, /* LEA.L (xxx).W,An */
{ CPUFUNC_FF(op_41f9_0), 0, 16889 }, /* LEA.L (xxx).L,An */
{ CPUFUNC_FF(op_41fa_0), 0, 16890 }, /* LEA.L (d16,PC),An */
{ CPUFUNC_FF(op_41fb_3), 0, 16891 }, /* LEA.L (d8,PC,Xn),An */
{ CPUFUNC(op_4200_0), 0, 16896 }, /* CLR.B Dn */
{ CPUFUNC(op_4210_0), 0, 16912 }, /* CLR.B (An) */
{ CPUFUNC(op_4218_0), 0, 16920 }, /* CLR.B (An)+ */
{ CPUFUNC(op_4220_0), 0, 16928 }, /* CLR.B -(An) */
{ CPUFUNC(op_4228_0), 0, 16936 }, /* CLR.B (d16,An) */
{ CPUFUNC(op_4230_3), 0, 16944 }, /* CLR.B (d8,An,Xn) */
{ CPUFUNC(op_4238_0), 0, 16952 }, /* CLR.B (xxx).W */
{ CPUFUNC(op_4239_0), 0, 16953 }, /* CLR.B (xxx).L */
{ CPUFUNC(op_4240_0), 0, 16960 }, /* CLR.W Dn */
{ CPUFUNC(op_4250_0), 0, 16976 }, /* CLR.W (An) */
{ CPUFUNC(op_4258_0), 0, 16984 }, /* CLR.W (An)+ */
{ CPUFUNC(op_4260_0), 0, 16992 }, /* CLR.W -(An) */
{ CPUFUNC(op_4268_0), 0, 17000 }, /* CLR.W (d16,An) */
{ CPUFUNC(op_4270_3), 0, 17008 }, /* CLR.W (d8,An,Xn) */
{ CPUFUNC(op_4278_0), 0, 17016 }, /* CLR.W (xxx).W */
{ CPUFUNC(op_4279_0), 0, 17017 }, /* CLR.W (xxx).L */
{ CPUFUNC(op_4280_0), 0, 17024 }, /* CLR.L Dn */
{ CPUFUNC(op_4290_0), 0, 17040 }, /* CLR.L (An) */
{ CPUFUNC(op_4298_0), 0, 17048 }, /* CLR.L (An)+ */
{ CPUFUNC(op_42a0_0), 0, 17056 }, /* CLR.L -(An) */
{ CPUFUNC(op_42a8_0), 0, 17064 }, /* CLR.L (d16,An) */
{ CPUFUNC(op_42b0_3), 0, 17072 }, /* CLR.L (d8,An,Xn) */
{ CPUFUNC(op_42b8_0), 0, 17080 }, /* CLR.L (xxx).W */
{ CPUFUNC(op_42b9_0), 0, 17081 }, /* CLR.L (xxx).L */
{ CPUFUNC(op_4400_0), 0, 17408 }, /* NEG.B Dn */
{ CPUFUNC(op_4410_0), 0, 17424 }, /* NEG.B (An) */
{ CPUFUNC(op_4418_0), 0, 17432 }, /* NEG.B (An)+ */
{ CPUFUNC(op_4420_0), 0, 17440 }, /* NEG.B -(An) */
{ CPUFUNC(op_4428_0), 0, 17448 }, /* NEG.B (d16,An) */
{ CPUFUNC(op_4430_3), 0, 17456 }, /* NEG.B (d8,An,Xn) */
{ CPUFUNC(op_4438_0), 0, 17464 }, /* NEG.B (xxx).W */
{ CPUFUNC(op_4439_0), 0, 17465 }, /* NEG.B (xxx).L */
{ CPUFUNC(op_4440_0), 0, 17472 }, /* NEG.W Dn */
{ CPUFUNC(op_4450_0), 0, 17488 }, /* NEG.W (An) */
{ CPUFUNC(op_4458_0), 0, 17496 }, /* NEG.W (An)+ */
{ CPUFUNC(op_4460_0), 0, 17504 }, /* NEG.W -(An) */
{ CPUFUNC(op_4468_0), 0, 17512 }, /* NEG.W (d16,An) */
{ CPUFUNC(op_4470_3), 0, 17520 }, /* NEG.W (d8,An,Xn) */
{ CPUFUNC(op_4478_0), 0, 17528 }, /* NEG.W (xxx).W */
{ CPUFUNC(op_4479_0), 0, 17529 }, /* NEG.W (xxx).L */
{ CPUFUNC(op_4480_0), 0, 17536 }, /* NEG.L Dn */
{ CPUFUNC(op_4490_0), 0, 17552 }, /* NEG.L (An) */
{ CPUFUNC(op_4498_0), 0, 17560 }, /* NEG.L (An)+ */
{ CPUFUNC(op_44a0_0), 0, 17568 }, /* NEG.L -(An) */
{ CPUFUNC(op_44a8_0), 0, 17576 }, /* NEG.L (d16,An) */
{ CPUFUNC(op_44b0_3), 0, 17584 }, /* NEG.L (d8,An,Xn) */
{ CPUFUNC(op_44b8_0), 0, 17592 }, /* NEG.L (xxx).W */
{ CPUFUNC(op_44b9_0), 0, 17593 }, /* NEG.L (xxx).L */
{ CPUFUNC(op_44c0_0), 0, 17600 }, /* MV2SR.B Dn */
{ CPUFUNC(op_44d0_0), 0, 17616 }, /* MV2SR.B (An) */
{ CPUFUNC(op_44d8_0), 0, 17624 }, /* MV2SR.B (An)+ */
{ CPUFUNC(op_44e0_0), 0, 17632 }, /* MV2SR.B -(An) */
{ CPUFUNC(op_44e8_0), 0, 17640 }, /* MV2SR.B (d16,An) */
{ CPUFUNC(op_44f0_3), 0, 17648 }, /* MV2SR.B (d8,An,Xn) */
{ CPUFUNC(op_44f8_0), 0, 17656 }, /* MV2SR.B (xxx).W */
{ CPUFUNC(op_44f9_0), 0, 17657 }, /* MV2SR.B (xxx).L */
{ CPUFUNC(op_44fa_0), 0, 17658 }, /* MV2SR.B (d16,PC) */
{ CPUFUNC(op_44fb_3), 0, 17659 }, /* MV2SR.B (d8,PC,Xn) */
{ CPUFUNC(op_44fc_0), 0, 17660 }, /* MV2SR.B #<data>.B */
{ CPUFUNC(op_4600_0), 0, 17920 }, /* NOT.B Dn */
{ CPUFUNC(op_4610_0), 0, 17936 }, /* NOT.B (An) */
{ CPUFUNC(op_4618_0), 0, 17944 }, /* NOT.B (An)+ */
{ CPUFUNC(op_4620_0), 0, 17952 }, /* NOT.B -(An) */
{ CPUFUNC(op_4628_0), 0, 17960 }, /* NOT.B (d16,An) */
{ CPUFUNC(op_4630_3), 0, 17968 }, /* NOT.B (d8,An,Xn) */
{ CPUFUNC(op_4638_0), 0, 17976 }, /* NOT.B (xxx).W */
{ CPUFUNC(op_4639_0), 0, 17977 }, /* NOT.B (xxx).L */
{ CPUFUNC(op_4640_0), 0, 17984 }, /* NOT.W Dn */
{ CPUFUNC(op_4650_0), 0, 18000 }, /* NOT.W (An) */
{ CPUFUNC(op_4658_0), 0, 18008 }, /* NOT.W (An)+ */
{ CPUFUNC(op_4660_0), 0, 18016 }, /* NOT.W -(An) */
{ CPUFUNC(op_4668_0), 0, 18024 }, /* NOT.W (d16,An) */
{ CPUFUNC(op_4670_3), 0, 18032 }, /* NOT.W (d8,An,Xn) */
{ CPUFUNC(op_4678_0), 0, 18040 }, /* NOT.W (xxx).W */
{ CPUFUNC(op_4679_0), 0, 18041 }, /* NOT.W (xxx).L */
{ CPUFUNC(op_4680_0), 0, 18048 }, /* NOT.L Dn */
{ CPUFUNC(op_4690_0), 0, 18064 }, /* NOT.L (An) */
{ CPUFUNC(op_4698_0), 0, 18072 }, /* NOT.L (An)+ */
{ CPUFUNC(op_46a0_0), 0, 18080 }, /* NOT.L -(An) */
{ CPUFUNC(op_46a8_0), 0, 18088 }, /* NOT.L (d16,An) */
{ CPUFUNC(op_46b0_3), 0, 18096 }, /* NOT.L (d8,An,Xn) */
{ CPUFUNC(op_46b8_0), 0, 18104 }, /* NOT.L (xxx).W */
{ CPUFUNC(op_46b9_0), 0, 18105 }, /* NOT.L (xxx).L */
{ CPUFUNC(op_46c0_0), 0, 18112 }, /* MV2SR.W Dn */
{ CPUFUNC(op_46d0_0), 0, 18128 }, /* MV2SR.W (An) */
{ CPUFUNC(op_46d8_0), 0, 18136 }, /* MV2SR.W (An)+ */
{ CPUFUNC(op_46e0_0), 0, 18144 }, /* MV2SR.W -(An) */
{ CPUFUNC(op_46e8_0), 0, 18152 }, /* MV2SR.W (d16,An) */
{ CPUFUNC(op_46f0_3), 0, 18160 }, /* MV2SR.W (d8,An,Xn) */
{ CPUFUNC(op_46f8_0), 0, 18168 }, /* MV2SR.W (xxx).W */
{ CPUFUNC(op_46f9_0), 0, 18169 }, /* MV2SR.W (xxx).L */
{ CPUFUNC(op_46fa_0), 0, 18170 }, /* MV2SR.W (d16,PC) */
{ CPUFUNC(op_46fb_3), 0, 18171 }, /* MV2SR.W (d8,PC,Xn) */
{ CPUFUNC(op_46fc_0), 0, 18172 }, /* MV2SR.W #<data>.W */
{ CPUFUNC(op_4800_1), 0, 18432 }, /* NBCD.B Dn */
{ CPUFUNC(op_4810_1), 0, 18448 }, /* NBCD.B (An) */
{ CPUFUNC(op_4818_1), 0, 18456 }, /* NBCD.B (An)+ */
{ CPUFUNC(op_4820_1), 0, 18464 }, /* NBCD.B -(An) */
{ CPUFUNC(op_4828_1), 0, 18472 }, /* NBCD.B (d16,An) */
{ CPUFUNC(op_4830_3), 0, 18480 }, /* NBCD.B (d8,An,Xn) */
{ CPUFUNC(op_4838_1), 0, 18488 }, /* NBCD.B (xxx).W */
{ CPUFUNC(op_4839_1), 0, 18489 }, /* NBCD.B (xxx).L */
{ CPUFUNC(op_4840_0), 0, 18496 }, /* SWAP.W Dn */
{ CPUFUNC_FF(op_4850_0), 0, 18512 }, /* PEA.L (An) */
{ CPUFUNC_FF(op_4868_0), 0, 18536 }, /* PEA.L (d16,An) */
{ CPUFUNC_FF(op_4870_3), 0, 18544 }, /* PEA.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4878_0), 0, 18552 }, /* PEA.L (xxx).W */
{ CPUFUNC_FF(op_4879_0), 0, 18553 }, /* PEA.L (xxx).L */
{ CPUFUNC_FF(op_487a_0), 0, 18554 }, /* PEA.L (d16,PC) */
{ CPUFUNC_FF(op_487b_3), 0, 18555 }, /* PEA.L (d8,PC,Xn) */
{ CPUFUNC(op_4880_0), 0, 18560 }, /* EXT.W Dn */
{ CPUFUNC_FF(op_4890_0), 0, 18576 }, /* MVMLE.W #<data>.W,(An) */
{ CPUFUNC_FF(op_48a0_0), 0, 18592 }, /* MVMLE.W #<data>.W,-(An) */
{ CPUFUNC_FF(op_48a8_0), 0, 18600 }, /* MVMLE.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48b0_3), 0, 18608 }, /* MVMLE.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48b8_0), 0, 18616 }, /* MVMLE.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48b9_0), 0, 18617 }, /* MVMLE.W #<data>.W,(xxx).L */
{ CPUFUNC(op_48c0_0), 0, 18624 }, /* EXT.L Dn */
{ CPUFUNC_FF(op_48d0_0), 0, 18640 }, /* MVMLE.L #<data>.W,(An) */
{ CPUFUNC_FF(op_48e0_0), 0, 18656 }, /* MVMLE.L #<data>.W,-(An) */
{ CPUFUNC_FF(op_48e8_0), 0, 18664 }, /* MVMLE.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_48f0_3), 0, 18672 }, /* MVMLE.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_48f8_0), 0, 18680 }, /* MVMLE.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_48f9_0), 0, 18681 }, /* MVMLE.L #<data>.W,(xxx).L */
{ CPUFUNC(op_49c0_0), 0, 18880 }, /* EXT.B Dn */
{ CPUFUNC(op_4a00_0), 0, 18944 }, /* TST.B Dn */
{ CPUFUNC(op_4a10_0), 0, 18960 }, /* TST.B (An) */
{ CPUFUNC(op_4a18_0), 0, 18968 }, /* TST.B (An)+ */
{ CPUFUNC(op_4a20_0), 0, 18976 }, /* TST.B -(An) */
{ CPUFUNC(op_4a28_0), 0, 18984 }, /* TST.B (d16,An) */
{ CPUFUNC(op_4a30_3), 0, 18992 }, /* TST.B (d8,An,Xn) */
{ CPUFUNC(op_4a38_0), 0, 19000 }, /* TST.B (xxx).W */
{ CPUFUNC(op_4a39_0), 0, 19001 }, /* TST.B (xxx).L */
{ CPUFUNC(op_4a3a_0), 0, 19002 }, /* TST.B (d16,PC) */
{ CPUFUNC(op_4a3b_3), 0, 19003 }, /* TST.B (d8,PC,Xn) */
{ CPUFUNC(op_4a3c_0), 0, 19004 }, /* TST.B #<data>.B */
{ CPUFUNC(op_4a40_0), 0, 19008 }, /* TST.W Dn */
{ CPUFUNC(op_4a48_0), 0, 19016 }, /* TST.W An */
{ CPUFUNC(op_4a50_0), 0, 19024 }, /* TST.W (An) */
{ CPUFUNC(op_4a58_0), 0, 19032 }, /* TST.W (An)+ */
{ CPUFUNC(op_4a60_0), 0, 19040 }, /* TST.W -(An) */
{ CPUFUNC(op_4a68_0), 0, 19048 }, /* TST.W (d16,An) */
{ CPUFUNC(op_4a70_3), 0, 19056 }, /* TST.W (d8,An,Xn) */
{ CPUFUNC(op_4a78_0), 0, 19064 }, /* TST.W (xxx).W */
{ CPUFUNC(op_4a79_0), 0, 19065 }, /* TST.W (xxx).L */
{ CPUFUNC(op_4a7a_0), 0, 19066 }, /* TST.W (d16,PC) */
{ CPUFUNC(op_4a7b_3), 0, 19067 }, /* TST.W (d8,PC,Xn) */
{ CPUFUNC(op_4a7c_0), 0, 19068 }, /* TST.W #<data>.W */
{ CPUFUNC(op_4a80_0), 0, 19072 }, /* TST.L Dn */
{ CPUFUNC(op_4a88_0), 0, 19080 }, /* TST.L An */
{ CPUFUNC(op_4a90_0), 0, 19088 }, /* TST.L (An) */
{ CPUFUNC(op_4a98_0), 0, 19096 }, /* TST.L (An)+ */
{ CPUFUNC(op_4aa0_0), 0, 19104 }, /* TST.L -(An) */
{ CPUFUNC(op_4aa8_0), 0, 19112 }, /* TST.L (d16,An) */
{ CPUFUNC(op_4ab0_3), 0, 19120 }, /* TST.L (d8,An,Xn) */
{ CPUFUNC(op_4ab8_0), 0, 19128 }, /* TST.L (xxx).W */
{ CPUFUNC(op_4ab9_0), 0, 19129 }, /* TST.L (xxx).L */
{ CPUFUNC(op_4aba_0), 0, 19130 }, /* TST.L (d16,PC) */
{ CPUFUNC(op_4abb_3), 0, 19131 }, /* TST.L (d8,PC,Xn) */
{ CPUFUNC(op_4abc_0), 0, 19132 }, /* TST.L #<data>.L */
{ CPUFUNC(op_4ac0_0), 0, 19136 }, /* TAS.B Dn */
{ CPUFUNC(op_4ad0_0), 0, 19152 }, /* TAS.B (An) */
{ CPUFUNC(op_4ad8_0), 0, 19160 }, /* TAS.B (An)+ */
{ CPUFUNC(op_4ae0_0), 0, 19168 }, /* TAS.B -(An) */
{ CPUFUNC(op_4ae8_0), 0, 19176 }, /* TAS.B (d16,An) */
{ CPUFUNC(op_4af0_3), 0, 19184 }, /* TAS.B (d8,An,Xn) */
{ CPUFUNC(op_4af8_0), 0, 19192 }, /* TAS.B (xxx).W */
{ CPUFUNC(op_4af9_0), 0, 19193 }, /* TAS.B (xxx).L */
{ CPUFUNC_FF(op_4c90_0), 0, 19600 }, /* MVMEL.W #<data>.W,(An) */
{ CPUFUNC_FF(op_4c98_0), 0, 19608 }, /* MVMEL.W #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ca8_0), 0, 19624 }, /* MVMEL.W #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cb0_3), 0, 19632 }, /* MVMEL.W #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cb8_0), 0, 19640 }, /* MVMEL.W #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cb9_0), 0, 19641 }, /* MVMEL.W #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cba_0), 0, 19642 }, /* MVMEL.W #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cbb_3), 0, 19643 }, /* MVMEL.W #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4cd0_0), 0, 19664 }, /* MVMEL.L #<data>.W,(An) */
{ CPUFUNC_FF(op_4cd8_0), 0, 19672 }, /* MVMEL.L #<data>.W,(An)+ */
{ CPUFUNC_FF(op_4ce8_0), 0, 19688 }, /* MVMEL.L #<data>.W,(d16,An) */
{ CPUFUNC_FF(op_4cf0_3), 0, 19696 }, /* MVMEL.L #<data>.W,(d8,An,Xn) */
{ CPUFUNC_FF(op_4cf8_0), 0, 19704 }, /* MVMEL.L #<data>.W,(xxx).W */
{ CPUFUNC_FF(op_4cf9_0), 0, 19705 }, /* MVMEL.L #<data>.W,(xxx).L */
{ CPUFUNC_FF(op_4cfa_0), 0, 19706 }, /* MVMEL.L #<data>.W,(d16,PC) */
{ CPUFUNC_FF(op_4cfb_3), 0, 19707 }, /* MVMEL.L #<data>.W,(d8,PC,Xn) */
{ CPUFUNC_FF(op_4e40_0), 0, 20032 }, /* TRAP.L #<data> */
{ CPUFUNC_FF(op_4e50_0), 0, 20048 }, /* LINK.W An,#<data>.W */
{ CPUFUNC_FF(op_4e58_0), 0, 20056 }, /* UNLK.L An */
{ CPUFUNC_FF(op_4e60_0), 0, 20064 }, /* MVR2USP.L An */
{ CPUFUNC_FF(op_4e68_0), 0, 20072 }, /* MVUSP2R.L An */
{ CPUFUNC_FF(op_4e70_0), 0, 20080 }, /* RESET.L  */
{ CPUFUNC_FF(op_4e71_0), 0, 20081 }, /* NOP.L  */
{ CPUFUNC(op_4e72_0), 0, 20082 }, /* STOP.L #<data>.W */
{ CPUFUNC(op_4e73_4), 0, 20083 }, /* RTE.L  */
{ CPUFUNC_FF(op_4e74_0), 0, 20084 }, /* RTD.L #<data>.W */
{ CPUFUNC_FF(op_4e75_0), 0, 20085 }, /* RTS.L  */
{ CPUFUNC_FF(op_4e76_0), 0, 20086 }, /* TRAPV.L  */
{ CPUFUNC(op_4e77_0), 0, 20087 }, /* RTR.L  */
{ CPUFUNC_FF(op_4e90_0), 0, 20112 }, /* JSR.L (An) */
{ CPUFUNC_FF(op_4ea8_0), 0, 20136 }, /* JSR.L (d16,An) */
{ CPUFUNC_FF(op_4eb0_3), 0, 20144 }, /* JSR.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4eb8_0), 0, 20152 }, /* JSR.L (xxx).W */
{ CPUFUNC_FF(op_4eb9_0), 0, 20153 }, /* JSR.L (xxx).L */
{ CPUFUNC_FF(op_4eba_0), 0, 20154 }, /* JSR.L (d16,PC) */
{ CPUFUNC_FF(op_4ebb_3), 0, 20155 }, /* JSR.L (d8,PC,Xn) */
{ CPUFUNC_FF(op_4ed0_0), 0, 20176 }, /* JMP.L (An) */
{ CPUFUNC_FF(op_4ee8_0), 0, 20200 }, /* JMP.L (d16,An) */
{ CPUFUNC_FF(op_4ef0_3), 0, 20208 }, /* JMP.L (d8,An,Xn) */
{ CPUFUNC_FF(op_4ef8_0), 0, 20216 }, /* JMP.L (xxx).W */
{ CPUFUNC_FF(op_4ef9_0), 0, 20217 }, /* JMP.L (xxx).L */
{ CPUFUNC_FF(op_4efa_0), 0, 20218 }, /* JMP.L (d16,PC) */
{ CPUFUNC_FF(op_4efb_3), 0, 20219 }, /* JMP.L (d8,PC,Xn) */
{ CPUFUNC(op_5000_0), 0, 20480 }, /* ADD.B #<data>,Dn */
{ CPUFUNC(op_5010_0), 0, 20496 }, /* ADD.B #<data>,(An) */
{ CPUFUNC(op_5018_0), 0, 20504 }, /* ADD.B #<data>,(An)+ */
{ CPUFUNC(op_5020_0), 0, 20512 }, /* ADD.B #<data>,-(An) */
{ CPUFUNC(op_5028_0), 0, 20520 }, /* ADD.B #<data>,(d16,An) */
{ CPUFUNC(op_5030_3), 0, 20528 }, /* ADD.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5038_0), 0, 20536 }, /* ADD.B #<data>,(xxx).W */
{ CPUFUNC(op_5039_0), 0, 20537 }, /* ADD.B #<data>,(xxx).L */
{ CPUFUNC(op_5040_0), 0, 20544 }, /* ADD.W #<data>,Dn */
{ CPUFUNC_FF(op_5048_0), 0, 20552 }, /* ADDA.W #<data>,An */
{ CPUFUNC(op_5050_0), 0, 20560 }, /* ADD.W #<data>,(An) */
{ CPUFUNC(op_5058_0), 0, 20568 }, /* ADD.W #<data>,(An)+ */
{ CPUFUNC(op_5060_0), 0, 20576 }, /* ADD.W #<data>,-(An) */
{ CPUFUNC(op_5068_0), 0, 20584 }, /* ADD.W #<data>,(d16,An) */
{ CPUFUNC(op_5070_3), 0, 20592 }, /* ADD.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5078_0), 0, 20600 }, /* ADD.W #<data>,(xxx).W */
{ CPUFUNC(op_5079_0), 0, 20601 }, /* ADD.W #<data>,(xxx).L */
{ CPUFUNC(op_5080_0), 0, 20608 }, /* ADD.L #<data>,Dn */
{ CPUFUNC_FF(op_5088_0), 0, 20616 }, /* ADDA.L #<data>,An */
{ CPUFUNC(op_5090_0), 0, 20624 }, /* ADD.L #<data>,(An) */
{ CPUFUNC(op_5098_0), 0, 20632 }, /* ADD.L #<data>,(An)+ */
{ CPUFUNC(op_50a0_0), 0, 20640 }, /* ADD.L #<data>,-(An) */
{ CPUFUNC(op_50a8_0), 0, 20648 }, /* ADD.L #<data>,(d16,An) */
{ CPUFUNC(op_50b0_3), 0, 20656 }, /* ADD.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_50b8_0), 0, 20664 }, /* ADD.L #<data>,(xxx).W */
{ CPUFUNC(op_50b9_0), 0, 20665 }, /* ADD.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_50c0_0), 0, 20672 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_50c8_0), 0, 20680 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_50d0_0), 0, 20688 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_50d8_0), 0, 20696 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_50e0_0), 0, 20704 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_50e8_0), 0, 20712 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_50f0_3), 0, 20720 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_50f8_0), 0, 20728 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_50f9_0), 0, 20729 }, /* Scc.B (xxx).L */
{ CPUFUNC(op_5100_0), 0, 20736 }, /* SUB.B #<data>,Dn */
{ CPUFUNC(op_5110_0), 0, 20752 }, /* SUB.B #<data>,(An) */
{ CPUFUNC(op_5118_0), 0, 20760 }, /* SUB.B #<data>,(An)+ */
{ CPUFUNC(op_5120_0), 0, 20768 }, /* SUB.B #<data>,-(An) */
{ CPUFUNC(op_5128_0), 0, 20776 }, /* SUB.B #<data>,(d16,An) */
{ CPUFUNC(op_5130_3), 0, 20784 }, /* SUB.B #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5138_0), 0, 20792 }, /* SUB.B #<data>,(xxx).W */
{ CPUFUNC(op_5139_0), 0, 20793 }, /* SUB.B #<data>,(xxx).L */
{ CPUFUNC(op_5140_0), 0, 20800 }, /* SUB.W #<data>,Dn */
{ CPUFUNC_FF(op_5148_0), 0, 20808 }, /* SUBA.W #<data>,An */
{ CPUFUNC(op_5150_0), 0, 20816 }, /* SUB.W #<data>,(An) */
{ CPUFUNC(op_5158_0), 0, 20824 }, /* SUB.W #<data>,(An)+ */
{ CPUFUNC(op_5160_0), 0, 20832 }, /* SUB.W #<data>,-(An) */
{ CPUFUNC(op_5168_0), 0, 20840 }, /* SUB.W #<data>,(d16,An) */
{ CPUFUNC(op_5170_3), 0, 20848 }, /* SUB.W #<data>,(d8,An,Xn) */
{ CPUFUNC(op_5178_0), 0, 20856 }, /* SUB.W #<data>,(xxx).W */
{ CPUFUNC(op_5179_0), 0, 20857 }, /* SUB.W #<data>,(xxx).L */
{ CPUFUNC(op_5180_0), 0, 20864 }, /* SUB.L #<data>,Dn */
{ CPUFUNC_FF(op_5188_0), 0, 20872 }, /* SUBA.L #<data>,An */
{ CPUFUNC(op_5190_0), 0, 20880 }, /* SUB.L #<data>,(An) */
{ CPUFUNC(op_5198_0), 0, 20888 }, /* SUB.L #<data>,(An)+ */
{ CPUFUNC(op_51a0_0), 0, 20896 }, /* SUB.L #<data>,-(An) */
{ CPUFUNC(op_51a8_0), 0, 20904 }, /* SUB.L #<data>,(d16,An) */
{ CPUFUNC(op_51b0_3), 0, 20912 }, /* SUB.L #<data>,(d8,An,Xn) */
{ CPUFUNC(op_51b8_0), 0, 20920 }, /* SUB.L #<data>,(xxx).W */
{ CPUFUNC(op_51b9_0), 0, 20921 }, /* SUB.L #<data>,(xxx).L */
{ CPUFUNC_FF(op_51c0_0), 0, 20928 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_51c8_0), 0, 20936 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_51d0_0), 0, 20944 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_51d8_0), 0, 20952 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_51e0_0), 0, 20960 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_51e8_0), 0, 20968 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_51f0_3), 0, 20976 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_51f8_0), 0, 20984 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_51f9_0), 0, 20985 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_52c0_0), 0, 21184 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_52c8_0), 0, 21192 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_52d0_0), 0, 21200 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_52d8_0), 0, 21208 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_52e0_0), 0, 21216 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_52e8_0), 0, 21224 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_52f0_3), 0, 21232 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_52f8_0), 0, 21240 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_52f9_0), 0, 21241 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_53c0_0), 0, 21440 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_53c8_0), 0, 21448 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_53d0_0), 0, 21456 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_53d8_0), 0, 21464 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_53e0_0), 0, 21472 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_53e8_0), 0, 21480 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_53f0_3), 0, 21488 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_53f8_0), 0, 21496 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_53f9_0), 0, 21497 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_54c0_0), 0, 21696 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_54c8_0), 0, 21704 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_54d0_0), 0, 21712 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_54d8_0), 0, 21720 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_54e0_0), 0, 21728 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_54e8_0), 0, 21736 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_54f0_3), 0, 21744 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_54f8_0), 0, 21752 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_54f9_0), 0, 21753 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_55c0_0), 0, 21952 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_55c8_0), 0, 21960 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_55d0_0), 0, 21968 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_55d8_0), 0, 21976 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_55e0_0), 0, 21984 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_55e8_0), 0, 21992 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_55f0_3), 0, 22000 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_55f8_0), 0, 22008 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_55f9_0), 0, 22009 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_56c0_0), 0, 22208 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_56c8_0), 0, 22216 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_56d0_0), 0, 22224 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_56d8_0), 0, 22232 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_56e0_0), 0, 22240 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_56e8_0), 0, 22248 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_56f0_3), 0, 22256 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_56f8_0), 0, 22264 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_56f9_0), 0, 22265 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_57c0_0), 0, 22464 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_57c8_0), 0, 22472 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_57d0_0), 0, 22480 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_57d8_0), 0, 22488 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_57e0_0), 0, 22496 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_57e8_0), 0, 22504 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_57f0_3), 0, 22512 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_57f8_0), 0, 22520 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_57f9_0), 0, 22521 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_58c0_0), 0, 22720 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_58c8_0), 0, 22728 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_58d0_0), 0, 22736 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_58d8_0), 0, 22744 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_58e0_0), 0, 22752 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_58e8_0), 0, 22760 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_58f0_3), 0, 22768 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_58f8_0), 0, 22776 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_58f9_0), 0, 22777 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_59c0_0), 0, 22976 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_59c8_0), 0, 22984 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_59d0_0), 0, 22992 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_59d8_0), 0, 23000 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_59e0_0), 0, 23008 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_59e8_0), 0, 23016 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_59f0_3), 0, 23024 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_59f8_0), 0, 23032 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_59f9_0), 0, 23033 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ac0_0), 0, 23232 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ac8_0), 0, 23240 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ad0_0), 0, 23248 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ad8_0), 0, 23256 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ae0_0), 0, 23264 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ae8_0), 0, 23272 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5af0_3), 0, 23280 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5af8_0), 0, 23288 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5af9_0), 0, 23289 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5bc0_0), 0, 23488 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5bc8_0), 0, 23496 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5bd0_0), 0, 23504 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5bd8_0), 0, 23512 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5be0_0), 0, 23520 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5be8_0), 0, 23528 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5bf0_3), 0, 23536 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5bf8_0), 0, 23544 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5bf9_0), 0, 23545 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5cc0_0), 0, 23744 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5cc8_0), 0, 23752 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5cd0_0), 0, 23760 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5cd8_0), 0, 23768 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ce0_0), 0, 23776 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ce8_0), 0, 23784 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5cf0_3), 0, 23792 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5cf8_0), 0, 23800 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5cf9_0), 0, 23801 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5dc0_0), 0, 24000 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5dc8_0), 0, 24008 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5dd0_0), 0, 24016 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5dd8_0), 0, 24024 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5de0_0), 0, 24032 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5de8_0), 0, 24040 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5df0_3), 0, 24048 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5df8_0), 0, 24056 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5df9_0), 0, 24057 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5ec0_0), 0, 24256 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5ec8_0), 0, 24264 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5ed0_0), 0, 24272 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5ed8_0), 0, 24280 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5ee0_0), 0, 24288 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5ee8_0), 0, 24296 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ef0_3), 0, 24304 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ef8_0), 0, 24312 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ef9_0), 0, 24313 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_5fc0_0), 0, 24512 }, /* Scc.B Dn */
{ CPUFUNC_FF(op_5fc8_0), 0, 24520 }, /* DBcc.W Dn,#<data>.W */
{ CPUFUNC_FF(op_5fd0_0), 0, 24528 }, /* Scc.B (An) */
{ CPUFUNC_FF(op_5fd8_0), 0, 24536 }, /* Scc.B (An)+ */
{ CPUFUNC_FF(op_5fe0_0), 0, 24544 }, /* Scc.B -(An) */
{ CPUFUNC_FF(op_5fe8_0), 0, 24552 }, /* Scc.B (d16,An) */
{ CPUFUNC_FF(op_5ff0_3), 0, 24560 }, /* Scc.B (d8,An,Xn) */
{ CPUFUNC_FF(op_5ff8_0), 0, 24568 }, /* Scc.B (xxx).W */
{ CPUFUNC_FF(op_5ff9_0), 0, 24569 }, /* Scc.B (xxx).L */
{ CPUFUNC_FF(op_6000_0), 0, 24576 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6001_0), 0, 24577 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_60ff_3), 0, 24831 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6100_0), 0, 24832 }, /* BSR.W #<data>.W */
{ CPUFUNC_FF(op_6101_0), 0, 24833 }, /* BSR.B #<data> */
{ CPUFUNC_FF(op_61ff_0), 0, 25087 }, /* BSR.L #<data>.L */
{ CPUFUNC_FF(op_6200_0), 0, 25088 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6201_0), 0, 25089 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_62ff_3), 0, 25343 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6300_0), 0, 25344 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6301_0), 0, 25345 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_63ff_3), 0, 25599 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6400_0), 0, 25600 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6401_0), 0, 25601 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_64ff_3), 0, 25855 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6500_0), 0, 25856 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6501_0), 0, 25857 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_65ff_3), 0, 26111 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6600_0), 0, 26112 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6601_0), 0, 26113 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_66ff_3), 0, 26367 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6700_0), 0, 26368 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6701_0), 0, 26369 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_67ff_3), 0, 26623 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6800_0), 0, 26624 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6801_0), 0, 26625 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_68ff_3), 0, 26879 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6900_0), 0, 26880 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6901_0), 0, 26881 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_69ff_3), 0, 27135 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6a00_0), 0, 27136 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6a01_0), 0, 27137 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6aff_3), 0, 27391 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6b00_0), 0, 27392 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6b01_0), 0, 27393 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6bff_3), 0, 27647 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6c00_0), 0, 27648 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6c01_0), 0, 27649 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6cff_3), 0, 27903 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6d00_0), 0, 27904 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6d01_0), 0, 27905 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6dff_3), 0, 28159 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6e00_0), 0, 28160 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6e01_0), 0, 28161 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6eff_3), 0, 28415 }, /* Bcc.L #<data>.L */
{ CPUFUNC_FF(op_6f00_0), 0, 28416 }, /* Bcc.W #<data>.W */
{ CPUFUNC_FF(op_6f01_0), 0, 28417 }, /* Bcc.B #<data> */
{ CPUFUNC_FF(op_6fff_3), 0, 28671 }, /* Bcc.L #<data>.L */
{ CPUFUNC(op_7000_0), 0, 28672 }, /* MOVE.L #<data>,Dn */
{ CPUFUNC_FF(op_7100_0), 0, 28928 }, /* EMULOP_RETURN.L  */
{ CPUFUNC_FF(op_7101_0), 0, 28929 }, /* EMULOP.L #<data> */
{ CPUFUNC(op_8000_0), 0, 32768 }, /* OR.B Dn,Dn */
{ CPUFUNC(op_8010_0), 0, 32784 }, /* OR.B (An),Dn */
{ CPUFUNC(op_8018_0), 0, 32792 }, /* OR.B (An)+,Dn */
{ CPUFUNC(op_8020_0), 0, 32800 }, /* OR.B -(An),Dn */
{ CPUFUNC(op_8028_0), 0, 32808 }, /* OR.B (d16,An),Dn */
{ CPUFUNC(op_8030_3), 0, 32816 }, /* OR.B (d8,An,Xn),Dn */
{ CPUFUNC(op_8038_0), 0, 32824 }, /* OR.B (xxx).W,Dn */
{ CPUFUNC(op_8039_0), 0, 32825 }, /* OR.B (xxx).L,Dn */
{ CPUFUNC(op_803a_0), 0, 32826 }, /* OR.B (d16,PC),Dn */
{ CPUFUNC(op_803b_3), 0, 32827 }, /* OR.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_803c_0), 0, 32828 }, /* OR.B #<data>.B,Dn */
{ CPUFUNC(op_8040_0), 0, 32832 }, /* OR.W Dn,Dn */
{ CPUFUNC(op_8050_0), 0, 32848 }, /* OR.W (An),Dn */
{ CPUFUNC(op_8058_0), 0, 32856 }, /* OR.W (An)+,Dn */
{ CPUFUNC(op_8060_0), 0, 32864 }, /* OR.W -(An),Dn */
{ CPUFUNC(op_8068_0), 0, 32872 }, /* OR.W (d16,An),Dn */
{ CPUFUNC(op_8070_3), 0, 32880 }, /* OR.W (d8,An,Xn),Dn */
{ CPUFUNC(op_8078_0), 0, 32888 }, /* OR.W (xxx).W,Dn */
{ CPUFUNC(op_8079_0), 0, 32889 }, /* OR.W (xxx).L,Dn */
{ CPUFUNC(op_807a_0), 0, 32890 }, /* OR.W (d16,PC),Dn */
{ CPUFUNC(op_807b_3), 0, 32891 }, /* OR.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_807c_0), 0, 32892 }, /* OR.W #<data>.W,Dn */
{ CPUFUNC(op_8080_0), 0, 32896 }, /* OR.L Dn,Dn */
{ CPUFUNC(op_8090_0), 0, 32912 }, /* OR.L (An),Dn */
{ CPUFUNC(op_8098_0), 0, 32920 }, /* OR.L (An)+,Dn */
{ CPUFUNC(op_80a0_0), 0, 32928 }, /* OR.L -(An),Dn */
{ CPUFUNC(op_80a8_0), 0, 32936 }, /* OR.L (d16,An),Dn */
{ CPUFUNC(op_80b0_3), 0, 32944 }, /* OR.L (d8,An,Xn),Dn */
{ CPUFUNC(op_80b8_0), 0, 32952 }, /* OR.L (xxx).W,Dn */
{ CPUFUNC(op_80b9_0), 0, 32953 }, /* OR.L (xxx).L,Dn */
{ CPUFUNC(op_80ba_0), 0, 32954 }, /* OR.L (d16,PC),Dn */
{ CPUFUNC(op_80bb_3), 0, 32955 }, /* OR.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_80bc_0), 0, 32956 }, /* OR.L #<data>.L,Dn */
{ CPUFUNC(op_80c0_0), 0, 32960 }, /* DIVU.W Dn,Dn */
{ CPUFUNC(op_80d0_0), 0, 32976 }, /* DIVU.W (An),Dn */
{ CPUFUNC(op_80d8_0), 0, 32984 }, /* DIVU.W (An)+,Dn */
{ CPUFUNC(op_80e0_0), 0, 32992 }, /* DIVU.W -(An),Dn */
{ CPUFUNC(op_80e8_0), 0, 33000 }, /* DIVU.W (d16,An),Dn */
{ CPUFUNC(op_80f0_3), 0, 33008 }, /* DIVU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_80f8_0), 0, 33016 }, /* DIVU.W (xxx).W,Dn */
{ CPUFUNC(op_80f9_0), 0, 33017 }, /* DIVU.W (xxx).L,Dn */
{ CPUFUNC(op_80fa_0), 0, 33018 }, /* DIVU.W (d16,PC),Dn */
{ CPUFUNC(op_80fb_3), 0, 33019 }, /* DIVU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_80fc_0), 0, 33020 }, /* DIVU.W #<data>.W,Dn */
{ CPUFUNC(op_8100_1), 0, 33024 }, /* SBCD.B Dn,Dn */
{ CPUFUNC(op_8108_1), 0, 33032 }, /* SBCD.B -(An),-(An) */
{ CPUFUNC(op_8110_0), 0, 33040 }, /* OR.B Dn,(An) */
{ CPUFUNC(op_8118_0), 0, 33048 }, /* OR.B Dn,(An)+ */
{ CPUFUNC(op_8120_0), 0, 33056 }, /* OR.B Dn,-(An) */
{ CPUFUNC(op_8128_0), 0, 33064 }, /* OR.B Dn,(d16,An) */
{ CPUFUNC(op_8130_3), 0, 33072 }, /* OR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_8138_0), 0, 33080 }, /* OR.B Dn,(xxx).W */
{ CPUFUNC(op_8139_0), 0, 33081 }, /* OR.B Dn,(xxx).L */
{ CPUFUNC(op_8150_0), 0, 33104 }, /* OR.W Dn,(An) */
{ CPUFUNC(op_8158_0), 0, 33112 }, /* OR.W Dn,(An)+ */
{ CPUFUNC(op_8160_0), 0, 33120 }, /* OR.W Dn,-(An) */
{ CPUFUNC(op_8168_0), 0, 33128 }, /* OR.W Dn,(d16,An) */
{ CPUFUNC(op_8170_3), 0, 33136 }, /* OR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_8178_0), 0, 33144 }, /* OR.W Dn,(xxx).W */
{ CPUFUNC(op_8179_0), 0, 33145 }, /* OR.W Dn,(xxx).L */
{ CPUFUNC(op_8190_0), 0, 33168 }, /* OR.L Dn,(An) */
{ CPUFUNC(op_8198_0), 0, 33176 }, /* OR.L Dn,(An)+ */
{ CPUFUNC(op_81a0_0), 0, 33184 }, /* OR.L Dn,-(An) */
{ CPUFUNC(op_81a8_0), 0, 33192 }, /* OR.L Dn,(d16,An) */
{ CPUFUNC(op_81b0_3), 0, 33200 }, /* OR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_81b8_0), 0, 33208 }, /* OR.L Dn,(xxx).W */
{ CPUFUNC(op_81b9_0), 0, 33209 }, /* OR.L Dn,(xxx).L */
{ CPUFUNC(op_81c0_0), 0, 33216 }, /* DIVS.W Dn,Dn */
{ CPUFUNC(op_81d0_0), 0, 33232 }, /* DIVS.W (An),Dn */
{ CPUFUNC(op_81d8_0), 0, 33240 }, /* DIVS.W (An)+,Dn */
{ CPUFUNC(op_81e0_0), 0, 33248 }, /* DIVS.W -(An),Dn */
{ CPUFUNC(op_81e8_0), 0, 33256 }, /* DIVS.W (d16,An),Dn */
{ CPUFUNC(op_81f0_3), 0, 33264 }, /* DIVS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_81f8_0), 0, 33272 }, /* DIVS.W (xxx).W,Dn */
{ CPUFUNC(op_81f9_0), 0, 33273 }, /* DIVS.W (xxx).L,Dn */
{ CPUFUNC(op_81fa_0), 0, 33274 }, /* DIVS.W (d16,PC),Dn */
{ CPUFUNC(op_81fb_3), 0, 33275 }, /* DIVS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_81fc_0), 0, 33276 }, /* DIVS.W #<data>.W,Dn */
{ CPUFUNC(op_9000_0), 0, 36864 }, /* SUB.B Dn,Dn */
{ CPUFUNC(op_9010_0), 0, 36880 }, /* SUB.B (An),Dn */
{ CPUFUNC(op_9018_0), 0, 36888 }, /* SUB.B (An)+,Dn */
{ CPUFUNC(op_9020_0), 0, 36896 }, /* SUB.B -(An),Dn */
{ CPUFUNC(op_9028_0), 0, 36904 }, /* SUB.B (d16,An),Dn */
{ CPUFUNC(op_9030_3), 0, 36912 }, /* SUB.B (d8,An,Xn),Dn */
{ CPUFUNC(op_9038_0), 0, 36920 }, /* SUB.B (xxx).W,Dn */
{ CPUFUNC(op_9039_0), 0, 36921 }, /* SUB.B (xxx).L,Dn */
{ CPUFUNC(op_903a_0), 0, 36922 }, /* SUB.B (d16,PC),Dn */
{ CPUFUNC(op_903b_3), 0, 36923 }, /* SUB.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_903c_0), 0, 36924 }, /* SUB.B #<data>.B,Dn */
{ CPUFUNC(op_9040_0), 0, 36928 }, /* SUB.W Dn,Dn */
{ CPUFUNC(op_9048_0), 0, 36936 }, /* SUB.W An,Dn */
{ CPUFUNC(op_9050_0), 0, 36944 }, /* SUB.W (An),Dn */
{ CPUFUNC(op_9058_0), 0, 36952 }, /* SUB.W (An)+,Dn */
{ CPUFUNC(op_9060_0), 0, 36960 }, /* SUB.W -(An),Dn */
{ CPUFUNC(op_9068_0), 0, 36968 }, /* SUB.W (d16,An),Dn */
{ CPUFUNC(op_9070_3), 0, 36976 }, /* SUB.W (d8,An,Xn),Dn */
{ CPUFUNC(op_9078_0), 0, 36984 }, /* SUB.W (xxx).W,Dn */
{ CPUFUNC(op_9079_0), 0, 36985 }, /* SUB.W (xxx).L,Dn */
{ CPUFUNC(op_907a_0), 0, 36986 }, /* SUB.W (d16,PC),Dn */
{ CPUFUNC(op_907b_3), 0, 36987 }, /* SUB.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_907c_0), 0, 36988 }, /* SUB.W #<data>.W,Dn */
{ CPUFUNC(op_9080_0), 0, 36992 }, /* SUB.L Dn,Dn */
{ CPUFUNC(op_9088_0), 0, 37000 }, /* SUB.L An,Dn */
{ CPUFUNC(op_9090_0), 0, 37008 }, /* SUB.L (An),Dn */
{ CPUFUNC(op_9098_0), 0, 37016 }, /* SUB.L (An)+,Dn */
{ CPUFUNC(op_90a0_0), 0, 37024 }, /* SUB.L -(An),Dn */
{ CPUFUNC(op_90a8_0), 0, 37032 }, /* SUB.L (d16,An),Dn */
{ CPUFUNC(op_90b0_3), 0, 37040 }, /* SUB.L (d8,An,Xn),Dn */
{ CPUFUNC(op_90b8_0), 0, 37048 }, /* SUB.L (xxx).W,Dn */
{ CPUFUNC(op_90b9_0), 0, 37049 }, /* SUB.L (xxx).L,Dn */
{ CPUFUNC(op_90ba_0), 0, 37050 }, /* SUB.L (d16,PC),Dn */
{ CPUFUNC(op_90bb_3), 0, 37051 }, /* SUB.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_90bc_0), 0, 37052 }, /* SUB.L #<data>.L,Dn */
{ CPUFUNC_FF(op_90c0_0), 0, 37056 }, /* SUBA.W Dn,An */
{ CPUFUNC_FF(op_90c8_0), 0, 37064 }, /* SUBA.W An,An */
{ CPUFUNC_FF(op_90d0_0), 0, 37072 }, /* SUBA.W (An),An */
{ CPUFUNC_FF(op_90d8_0), 0, 37080 }, /* SUBA.W (An)+,An */
{ CPUFUNC_FF(op_90e0_0), 0, 37088 }, /* SUBA.W -(An),An */
{ CPUFUNC_FF(op_90e8_0), 0, 37096 }, /* SUBA.W (d16,An),An */
{ CPUFUNC_FF(op_90f0_3), 0, 37104 }, /* SUBA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_90f8_0), 0, 37112 }, /* SUBA.W (xxx).W,An */
{ CPUFUNC_FF(op_90f9_0), 0, 37113 }, /* SUBA.W (xxx).L,An */
{ CPUFUNC_FF(op_90fa_0), 0, 37114 }, /* SUBA.W (d16,PC),An */
{ CPUFUNC_FF(op_90fb_3), 0, 37115 }, /* SUBA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_90fc_0), 0, 37116 }, /* SUBA.W #<data>.W,An */
{ CPUFUNC(op_9100_0), 0, 37120 }, /* SUBX.B Dn,Dn */
{ CPUFUNC(op_9108_0), 0, 37128 }, /* SUBX.B -(An),-(An) */
{ CPUFUNC(op_9110_0), 0, 37136 }, /* SUB.B Dn,(An) */
{ CPUFUNC(op_9118_0), 0, 37144 }, /* SUB.B Dn,(An)+ */
{ CPUFUNC(op_9120_0), 0, 37152 }, /* SUB.B Dn,-(An) */
{ CPUFUNC(op_9128_0), 0, 37160 }, /* SUB.B Dn,(d16,An) */
{ CPUFUNC(op_9130_3), 0, 37168 }, /* SUB.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_9138_0), 0, 37176 }, /* SUB.B Dn,(xxx).W */
{ CPUFUNC(op_9139_0), 0, 37177 }, /* SUB.B Dn,(xxx).L */
{ CPUFUNC(op_9140_0), 0, 37184 }, /* SUBX.W Dn,Dn */
{ CPUFUNC(op_9148_0), 0, 37192 }, /* SUBX.W -(An),-(An) */
{ CPUFUNC(op_9150_0), 0, 37200 }, /* SUB.W Dn,(An) */
{ CPUFUNC(op_9158_0), 0, 37208 }, /* SUB.W Dn,(An)+ */
{ CPUFUNC(op_9160_0), 0, 37216 }, /* SUB.W Dn,-(An) */
{ CPUFUNC(op_9168_0), 0, 37224 }, /* SUB.W Dn,(d16,An) */
{ CPUFUNC(op_9170_3), 0, 37232 }, /* SUB.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_9178_0), 0, 37240 }, /* SUB.W Dn,(xxx).W */
{ CPUFUNC(op_9179_0), 0, 37241 }, /* SUB.W Dn,(xxx).L */
{ CPUFUNC(op_9180_0), 0, 37248 }, /* SUBX.L Dn,Dn */
{ CPUFUNC(op_9188_0), 0, 37256 }, /* SUBX.L -(An),-(An) */
{ CPUFUNC(op_9190_0), 0, 37264 }, /* SUB.L Dn,(An) */
{ CPUFUNC(op_9198_0), 0, 37272 }, /* SUB.L Dn,(An)+ */
{ CPUFUNC(op_91a0_0), 0, 37280 }, /* SUB.L Dn,-(An) */
{ CPUFUNC(op_91a8_0), 0, 37288 }, /* SUB.L Dn,(d16,An) */
{ CPUFUNC(op_91b0_3), 0, 37296 }, /* SUB.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_91b8_0), 0, 37304 }, /* SUB.L Dn,(xxx).W */
{ CPUFUNC(op_91b9_0), 0, 37305 }, /* SUB.L Dn,(xxx).L */
{ CPUFUNC_FF(op_91c0_0), 0, 37312 }, /* SUBA.L Dn,An */
{ CPUFUNC_FF(op_91c8_0), 0, 37320 }, /* SUBA.L An,An */
{ CPUFUNC_FF(op_91d0_0), 0, 37328 }, /* SUBA.L (An),An */
{ CPUFUNC_FF(op_91d8_0), 0, 37336 }, /* SUBA.L (An)+,An */
{ CPUFUNC_FF(op_91e0_0), 0, 37344 }, /* SUBA.L -(An),An */
{ CPUFUNC_FF(op_91e8_0), 0, 37352 }, /* SUBA.L (d16,An),An */
{ CPUFUNC_FF(op_91f0_3), 0, 37360 }, /* SUBA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_91f8_0), 0, 37368 }, /* SUBA.L (xxx).W,An */
{ CPUFUNC_FF(op_91f9_0), 0, 37369 }, /* SUBA.L (xxx).L,An */
{ CPUFUNC_FF(op_91fa_0), 0, 37370 }, /* SUBA.L (d16,PC),An */
{ CPUFUNC_FF(op_91fb_3), 0, 37371 }, /* SUBA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_91fc_0), 0, 37372 }, /* SUBA.L #<data>.L,An */
{ CPUFUNC(op_b000_0), 0, 45056 }, /* CMP.B Dn,Dn */
{ CPUFUNC(op_b010_0), 0, 45072 }, /* CMP.B (An),Dn */
{ CPUFUNC(op_b018_0), 0, 45080 }, /* CMP.B (An)+,Dn */
{ CPUFUNC(op_b020_0), 0, 45088 }, /* CMP.B -(An),Dn */
{ CPUFUNC(op_b028_0), 0, 45096 }, /* CMP.B (d16,An),Dn */
{ CPUFUNC(op_b030_3), 0, 45104 }, /* CMP.B (d8,An,Xn),Dn */
{ CPUFUNC(op_b038_0), 0, 45112 }, /* CMP.B (xxx).W,Dn */
{ CPUFUNC(op_b039_0), 0, 45113 }, /* CMP.B (xxx).L,Dn */
{ CPUFUNC(op_b03a_0), 0, 45114 }, /* CMP.B (d16,PC),Dn */
{ CPUFUNC(op_b03b_3), 0, 45115 }, /* CMP.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_b03c_0), 0, 45116 }, /* CMP.B #<data>.B,Dn */
{ CPUFUNC(op_b040_0), 0, 45120 }, /* CMP.W Dn,Dn */
{ CPUFUNC(op_b048_0), 0, 45128 }, /* CMP.W An,Dn */
{ CPUFUNC(op_b050_0), 0, 45136 }, /* CMP.W (An),Dn */
{ CPUFUNC(op_b058_0), 0, 45144 }, /* CMP.W (An)+,Dn */
{ CPUFUNC(op_b060_0), 0, 45152 }, /* CMP.W -(An),Dn */
{ CPUFUNC(op_b068_0), 0, 45160 }, /* CMP.W (d16,An),Dn */
{ CPUFUNC(op_b070_3), 0, 45168 }, /* CMP.W (d8,An,Xn),Dn */
{ CPUFUNC(op_b078_0), 0, 45176 }, /* CMP.W (xxx).W,Dn */
{ CPUFUNC(op_b079_0), 0, 45177 }, /* CMP.W (xxx).L,Dn */
{ CPUFUNC(op_b07a_0), 0, 45178 }, /* CMP.W (d16,PC),Dn */
{ CPUFUNC(op_b07b_3), 0, 45179 }, /* CMP.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_b07c_0), 0, 45180 }, /* CMP.W #<data>.W,Dn */
{ CPUFUNC(op_b080_0), 0, 45184 }, /* CMP.L Dn,Dn */
{ CPUFUNC(op_b088_0), 0, 45192 }, /* CMP.L An,Dn */
{ CPUFUNC(op_b090_0), 0, 45200 }, /* CMP.L (An),Dn */
{ CPUFUNC(op_b098_0), 0, 45208 }, /* CMP.L (An)+,Dn */
{ CPUFUNC(op_b0a0_0), 0, 45216 }, /* CMP.L -(An),Dn */
{ CPUFUNC(op_b0a8_0), 0, 45224 }, /* CMP.L (d16,An),Dn */
{ CPUFUNC(op_b0b0_3), 0, 45232 }, /* CMP.L (d8,An,Xn),Dn */
{ CPUFUNC(op_b0b8_0), 0, 45240 }, /* CMP.L (xxx).W,Dn */
{ CPUFUNC(op_b0b9_0), 0, 45241 }, /* CMP.L (xxx).L,Dn */
{ CPUFUNC(op_b0ba_0), 0, 45242 }, /* CMP.L (d16,PC),Dn */
{ CPUFUNC(op_b0bb_3), 0, 45243 }, /* CMP.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_b0bc_0), 0, 45244 }, /* CMP.L #<data>.L,Dn */
{ CPUFUNC(op_b0c0_0), 0, 45248 }, /* CMPA.W Dn,An */
{ CPUFUNC(op_b0c8_0), 0, 45256 }, /* CMPA.W An,An */
{ CPUFUNC(op_b0d0_0), 0, 45264 }, /* CMPA.W (An),An */
{ CPUFUNC(op_b0d8_0), 0, 45272 }, /* CMPA.W (An)+,An */
{ CPUFUNC(op_b0e0_0), 0, 45280 }, /* CMPA.W -(An),An */
{ CPUFUNC(op_b0e8_0), 0, 45288 }, /* CMPA.W (d16,An),An */
{ CPUFUNC(op_b0f0_3), 0, 45296 }, /* CMPA.W (d8,An,Xn),An */
{ CPUFUNC(op_b0f8_0), 0, 45304 }, /* CMPA.W (xxx).W,An */
{ CPUFUNC(op_b0f9_0), 0, 45305 }, /* CMPA.W (xxx).L,An */
{ CPUFUNC(op_b0fa_0), 0, 45306 }, /* CMPA.W (d16,PC),An */
{ CPUFUNC(op_b0fb_3), 0, 45307 }, /* CMPA.W (d8,PC,Xn),An */
{ CPUFUNC(op_b0fc_0), 0, 45308 }, /* CMPA.W #<data>.W,An */
{ CPUFUNC(op_b100_0), 0, 45312 }, /* EOR.B Dn,Dn */
{ CPUFUNC(op_b108_0), 0, 45320 }, /* CMPM.B (An)+,(An)+ */
{ CPUFUNC(op_b110_0), 0, 45328 }, /* EOR.B Dn,(An) */
{ CPUFUNC(op_b118_0), 0, 45336 }, /* EOR.B Dn,(An)+ */
{ CPUFUNC(op_b120_0), 0, 45344 }, /* EOR.B Dn,-(An) */
{ CPUFUNC(op_b128_0), 0, 45352 }, /* EOR.B Dn,(d16,An) */
{ CPUFUNC(op_b130_3), 0, 45360 }, /* EOR.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_b138_0), 0, 45368 }, /* EOR.B Dn,(xxx).W */
{ CPUFUNC(op_b139_0), 0, 45369 }, /* EOR.B Dn,(xxx).L */
{ CPUFUNC(op_b140_0), 0, 45376 }, /* EOR.W Dn,Dn */
{ CPUFUNC(op_b148_0), 0, 45384 }, /* CMPM.W (An)+,(An)+ */
{ CPUFUNC(op_b150_0), 0, 45392 }, /* EOR.W Dn,(An) */
{ CPUFUNC(op_b158_0), 0, 45400 }, /* EOR.W Dn,(An)+ */
{ CPUFUNC(op_b160_0), 0, 45408 }, /* EOR.W Dn,-(An) */
{ CPUFUNC(op_b168_0), 0, 45416 }, /* EOR.W Dn,(d16,An) */
{ CPUFUNC(op_b170_3), 0, 45424 }, /* EOR.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_b178_0), 0, 45432 }, /* EOR.W Dn,(xxx).W */
{ CPUFUNC(op_b179_0), 0, 45433 }, /* EOR.W Dn,(xxx).L */
{ CPUFUNC(op_b180_0), 0, 45440 }, /* EOR.L Dn,Dn */
{ CPUFUNC(op_b188_0), 0, 45448 }, /* CMPM.L (An)+,(An)+ */
{ CPUFUNC(op_b190_0), 0, 45456 }, /* EOR.L Dn,(An) */
{ CPUFUNC(op_b198_0), 0, 45464 }, /* EOR.L Dn,(An)+ */
{ CPUFUNC(op_b1a0_0), 0, 45472 }, /* EOR.L Dn,-(An) */
{ CPUFUNC(op_b1a8_0), 0, 45480 }, /* EOR.L Dn,(d16,An) */
{ CPUFUNC(op_b1b0_3), 0, 45488 }, /* EOR.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_b1b8_0), 0, 45496 }, /* EOR.L Dn,(xxx).W */
{ CPUFUNC(op_b1b9_0), 0, 45497 }, /* EOR.L Dn,(xxx).L */
{ CPUFUNC(op_b1c0_0), 0, 45504 }, /* CMPA.L Dn,An */
{ CPUFUNC(op_b1c8_0), 0, 45512 }, /* CMPA.L An,An */
{ CPUFUNC(op_b1d0_0), 0, 45520 }, /* CMPA.L (An),An */
{ CPUFUNC(op_b1d8_0), 0, 45528 }, /* CMPA.L (An)+,An */
{ CPUFUNC(op_b1e0_0), 0, 45536 }, /* CMPA.L -(An),An */
{ CPUFUNC(op_b1e8_0), 0, 45544 }, /* CMPA.L (d16,An),An */
{ CPUFUNC(op_b1f0_3), 0, 45552 }, /* CMPA.L (d8,An,Xn),An */
{ CPUFUNC(op_b1f8_0), 0, 45560 }, /* CMPA.L (xxx).W,An */
{ CPUFUNC(op_b1f9_0), 0, 45561 }, /* CMPA.L (xxx).L,An */
{ CPUFUNC(op_b1fa_0), 0, 45562 }, /* CMPA.L (d16,PC),An */
{ CPUFUNC(op_b1fb_3), 0, 45563 }, /* CMPA.L (d8,PC,Xn),An */
{ CPUFUNC(op_b1fc_0), 0, 45564 }, /* CMPA.L #<data>.L,An */
{ CPUFUNC(op_c000_0), 0, 49152 }, /* AND.B Dn,Dn */
{ CPUFUNC(op_c010_0), 0, 49168 }, /* AND.B (An),Dn */
{ CPUFUNC(op_c018_0), 0, 49176 }, /* AND.B (An)+,Dn */
{ CPUFUNC(op_c020_0), 0, 49184 }, /* AND.B -(An),Dn */
{ CPUFUNC(op_c028_0), 0, 49192 }, /* AND.B (d16,An),Dn */
{ CPUFUNC(op_c030_3), 0, 49200 }, /* AND.B (d8,An,Xn),Dn */
{ CPUFUNC(op_c038_0), 0, 49208 }, /* AND.B (xxx).W,Dn */
{ CPUFUNC(op_c039_0), 0, 49209 }, /* AND.B (xxx).L,Dn */
{ CPUFUNC(op_c03a_0), 0, 49210 }, /* AND.B (d16,PC),Dn */
{ CPUFUNC(op_c03b_3), 0, 49211 }, /* AND.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_c03c_0), 0, 49212 }, /* AND.B #<data>.B,Dn */
{ CPUFUNC(op_c040_0), 0, 49216 }, /* AND.W Dn,Dn */
{ CPUFUNC(op_c050_0), 0, 49232 }, /* AND.W (An),Dn */
{ CPUFUNC(op_c058_0), 0, 49240 }, /* AND.W (An)+,Dn */
{ CPUFUNC(op_c060_0), 0, 49248 }, /* AND.W -(An),Dn */
{ CPUFUNC(op_c068_0), 0, 49256 }, /* AND.W (d16,An),Dn */
{ CPUFUNC(op_c070_3), 0, 49264 }, /* AND.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c078_0), 0, 49272 }, /* AND.W (xxx).W,Dn */
{ CPUFUNC(op_c079_0), 0, 49273 }, /* AND.W (xxx).L,Dn */
{ CPUFUNC(op_c07a_0), 0, 49274 }, /* AND.W (d16,PC),Dn */
{ CPUFUNC(op_c07b_3), 0, 49275 }, /* AND.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c07c_0), 0, 49276 }, /* AND.W #<data>.W,Dn */
{ CPUFUNC(op_c080_0), 0, 49280 }, /* AND.L Dn,Dn */
{ CPUFUNC(op_c090_0), 0, 49296 }, /* AND.L (An),Dn */
{ CPUFUNC(op_c098_0), 0, 49304 }, /* AND.L (An)+,Dn */
{ CPUFUNC(op_c0a0_0), 0, 49312 }, /* AND.L -(An),Dn */
{ CPUFUNC(op_c0a8_0), 0, 49320 }, /* AND.L (d16,An),Dn */
{ CPUFUNC(op_c0b0_3), 0, 49328 }, /* AND.L (d8,An,Xn),Dn */
{ CPUFUNC(op_c0b8_0), 0, 49336 }, /* AND.L (xxx).W,Dn */
{ CPUFUNC(op_c0b9_0), 0, 49337 }, /* AND.L (xxx).L,Dn */
{ CPUFUNC(op_c0ba_0), 0, 49338 }, /* AND.L (d16,PC),Dn */
{ CPUFUNC(op_c0bb_3), 0, 49339 }, /* AND.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0bc_0), 0, 49340 }, /* AND.L #<data>.L,Dn */
{ CPUFUNC(op_c0c0_0), 0, 49344 }, /* MULU.W Dn,Dn */
{ CPUFUNC(op_c0d0_0), 0, 49360 }, /* MULU.W (An),Dn */
{ CPUFUNC(op_c0d8_0), 0, 49368 }, /* MULU.W (An)+,Dn */
{ CPUFUNC(op_c0e0_0), 0, 49376 }, /* MULU.W -(An),Dn */
{ CPUFUNC(op_c0e8_0), 0, 49384 }, /* MULU.W (d16,An),Dn */
{ CPUFUNC(op_c0f0_3), 0, 49392 }, /* MULU.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c0f8_0), 0, 49400 }, /* MULU.W (xxx).W,Dn */
{ CPUFUNC(op_c0f9_0), 0, 49401 }, /* MULU.W (xxx).L,Dn */
{ CPUFUNC(op_c0fa_0), 0, 49402 }, /* MULU.W (d16,PC),Dn */
{ CPUFUNC(op_c0fb_3), 0, 49403 }, /* MULU.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c0fc_0), 0, 49404 }, /* MULU.W #<data>.W,Dn */
{ CPUFUNC(op_c100_1), 0, 49408 }, /* ABCD.B Dn,Dn */
{ CPUFUNC(op_c108_1), 0, 49416 }, /* ABCD.B -(An),-(An) */
{ CPUFUNC(op_c110_0), 0, 49424 }, /* AND.B Dn,(An) */
{ CPUFUNC(op_c118_0), 0, 49432 }, /* AND.B Dn,(An)+ */
{ CPUFUNC(op_c120_0), 0, 49440 }, /* AND.B Dn,-(An) */
{ CPUFUNC(op_c128_0), 0, 49448 }, /* AND.B Dn,(d16,An) */
{ CPUFUNC(op_c130_3), 0, 49456 }, /* AND.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_c138_0), 0, 49464 }, /* AND.B Dn,(xxx).W */
{ CPUFUNC(op_c139_0), 0, 49465 }, /* AND.B Dn,(xxx).L */
{ CPUFUNC_FF(op_c140_0), 0, 49472 }, /* EXG.L Dn,Dn */
{ CPUFUNC_FF(op_c148_0), 0, 49480 }, /* EXG.L An,An */
{ CPUFUNC(op_c150_0), 0, 49488 }, /* AND.W Dn,(An) */
{ CPUFUNC(op_c158_0), 0, 49496 }, /* AND.W Dn,(An)+ */
{ CPUFUNC(op_c160_0), 0, 49504 }, /* AND.W Dn,-(An) */
{ CPUFUNC(op_c168_0), 0, 49512 }, /* AND.W Dn,(d16,An) */
{ CPUFUNC(op_c170_3), 0, 49520 }, /* AND.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_c178_0), 0, 49528 }, /* AND.W Dn,(xxx).W */
{ CPUFUNC(op_c179_0), 0, 49529 }, /* AND.W Dn,(xxx).L */
{ CPUFUNC_FF(op_c188_0), 0, 49544 }, /* EXG.L Dn,An */
{ CPUFUNC(op_c190_0), 0, 49552 }, /* AND.L Dn,(An) */
{ CPUFUNC(op_c198_0), 0, 49560 }, /* AND.L Dn,(An)+ */
{ CPUFUNC(op_c1a0_0), 0, 49568 }, /* AND.L Dn,-(An) */
{ CPUFUNC(op_c1a8_0), 0, 49576 }, /* AND.L Dn,(d16,An) */
{ CPUFUNC(op_c1b0_3), 0, 49584 }, /* AND.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_c1b8_0), 0, 49592 }, /* AND.L Dn,(xxx).W */
{ CPUFUNC(op_c1b9_0), 0, 49593 }, /* AND.L Dn,(xxx).L */
{ CPUFUNC(op_c1c0_0), 0, 49600 }, /* MULS.W Dn,Dn */
{ CPUFUNC(op_c1d0_0), 0, 49616 }, /* MULS.W (An),Dn */
{ CPUFUNC(op_c1d8_0), 0, 49624 }, /* MULS.W (An)+,Dn */
{ CPUFUNC(op_c1e0_0), 0, 49632 }, /* MULS.W -(An),Dn */
{ CPUFUNC(op_c1e8_0), 0, 49640 }, /* MULS.W (d16,An),Dn */
{ CPUFUNC(op_c1f0_3), 0, 49648 }, /* MULS.W (d8,An,Xn),Dn */
{ CPUFUNC(op_c1f8_0), 0, 49656 }, /* MULS.W (xxx).W,Dn */
{ CPUFUNC(op_c1f9_0), 0, 49657 }, /* MULS.W (xxx).L,Dn */
{ CPUFUNC(op_c1fa_0), 0, 49658 }, /* MULS.W (d16,PC),Dn */
{ CPUFUNC(op_c1fb_3), 0, 49659 }, /* MULS.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_c1fc_0), 0, 49660 }, /* MULS.W #<data>.W,Dn */
{ CPUFUNC(op_d000_0), 0, 53248 }, /* ADD.B Dn,Dn */
{ CPUFUNC(op_d010_0), 0, 53264 }, /* ADD.B (An),Dn */
{ CPUFUNC(op_d018_0), 0, 53272 }, /* ADD.B (An)+,Dn */
{ CPUFUNC(op_d020_0), 0, 53280 }, /* ADD.B -(An),Dn */
{ CPUFUNC(op_d028_0), 0, 53288 }, /* ADD.B (d16,An),Dn */
{ CPUFUNC(op_d030_3), 0, 53296 }, /* ADD.B (d8,An,Xn),Dn */
{ CPUFUNC(op_d038_0), 0, 53304 }, /* ADD.B (xxx).W,Dn */
{ CPUFUNC(op_d039_0), 0, 53305 }, /* ADD.B (xxx).L,Dn */
{ CPUFUNC(op_d03a_0), 0, 53306 }, /* ADD.B (d16,PC),Dn */
{ CPUFUNC(op_d03b_3), 0, 53307 }, /* ADD.B (d8,PC,Xn),Dn */
{ CPUFUNC(op_d03c_0), 0, 53308 }, /* ADD.B #<data>.B,Dn */
{ CPUFUNC(op_d040_0), 0, 53312 }, /* ADD.W Dn,Dn */
{ CPUFUNC(op_d048_0), 0, 53320 }, /* ADD.W An,Dn */
{ CPUFUNC(op_d050_0), 0, 53328 }, /* ADD.W (An),Dn */
{ CPUFUNC(op_d058_0), 0, 53336 }, /* ADD.W (An)+,Dn */
{ CPUFUNC(op_d060_0), 0, 53344 }, /* ADD.W -(An),Dn */
{ CPUFUNC(op_d068_0), 0, 53352 }, /* ADD.W (d16,An),Dn */
{ CPUFUNC(op_d070_3), 0, 53360 }, /* ADD.W (d8,An,Xn),Dn */
{ CPUFUNC(op_d078_0), 0, 53368 }, /* ADD.W (xxx).W,Dn */
{ CPUFUNC(op_d079_0), 0, 53369 }, /* ADD.W (xxx).L,Dn */
{ CPUFUNC(op_d07a_0), 0, 53370 }, /* ADD.W (d16,PC),Dn */
{ CPUFUNC(op_d07b_3), 0, 53371 }, /* ADD.W (d8,PC,Xn),Dn */
{ CPUFUNC(op_d07c_0), 0, 53372 }, /* ADD.W #<data>.W,Dn */
{ CPUFUNC(op_d080_0), 0, 53376 }, /* ADD.L Dn,Dn */
{ CPUFUNC(op_d088_0), 0, 53384 }, /* ADD.L An,Dn */
{ CPUFUNC(op_d090_0), 0, 53392 }, /* ADD.L (An),Dn */
{ CPUFUNC(op_d098_0), 0, 53400 }, /* ADD.L (An)+,Dn */
{ CPUFUNC(op_d0a0_0), 0, 53408 }, /* ADD.L -(An),Dn */
{ CPUFUNC(op_d0a8_0), 0, 53416 }, /* ADD.L (d16,An),Dn */
{ CPUFUNC(op_d0b0_3), 0, 53424 }, /* ADD.L (d8,An,Xn),Dn */
{ CPUFUNC(op_d0b8_0), 0, 53432 }, /* ADD.L (xxx).W,Dn */
{ CPUFUNC(op_d0b9_0), 0, 53433 }, /* ADD.L (xxx).L,Dn */
{ CPUFUNC(op_d0ba_0), 0, 53434 }, /* ADD.L (d16,PC),Dn */
{ CPUFUNC(op_d0bb_3), 0, 53435 }, /* ADD.L (d8,PC,Xn),Dn */
{ CPUFUNC(op_d0bc_0), 0, 53436 }, /* ADD.L #<data>.L,Dn */
{ CPUFUNC_FF(op_d0c0_0), 0, 53440 }, /* ADDA.W Dn,An */
{ CPUFUNC_FF(op_d0c8_0), 0, 53448 }, /* ADDA.W An,An */
{ CPUFUNC_FF(op_d0d0_0), 0, 53456 }, /* ADDA.W (An),An */
{ CPUFUNC_FF(op_d0d8_0), 0, 53464 }, /* ADDA.W (An)+,An */
{ CPUFUNC_FF(op_d0e0_0), 0, 53472 }, /* ADDA.W -(An),An */
{ CPUFUNC_FF(op_d0e8_0), 0, 53480 }, /* ADDA.W (d16,An),An */
{ CPUFUNC_FF(op_d0f0_3), 0, 53488 }, /* ADDA.W (d8,An,Xn),An */
{ CPUFUNC_FF(op_d0f8_0), 0, 53496 }, /* ADDA.W (xxx).W,An */
{ CPUFUNC_FF(op_d0f9_0), 0, 53497 }, /* ADDA.W (xxx).L,An */
{ CPUFUNC_FF(op_d0fa_0), 0, 53498 }, /* ADDA.W (d16,PC),An */
{ CPUFUNC_FF(op_d0fb_3), 0, 53499 }, /* ADDA.W (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d0fc_0), 0, 53500 }, /* ADDA.W #<data>.W,An */
{ CPUFUNC(op_d100_0), 0, 53504 }, /* ADDX.B Dn,Dn */
{ CPUFUNC(op_d108_0), 0, 53512 }, /* ADDX.B -(An),-(An) */
{ CPUFUNC(op_d110_0), 0, 53520 }, /* ADD.B Dn,(An) */
{ CPUFUNC(op_d118_0), 0, 53528 }, /* ADD.B Dn,(An)+ */
{ CPUFUNC(op_d120_0), 0, 53536 }, /* ADD.B Dn,-(An) */
{ CPUFUNC(op_d128_0), 0, 53544 }, /* ADD.B Dn,(d16,An) */
{ CPUFUNC(op_d130_3), 0, 53552 }, /* ADD.B Dn,(d8,An,Xn) */
{ CPUFUNC(op_d138_0), 0, 53560 }, /* ADD.B Dn,(xxx).W */
{ CPUFUNC(op_d139_0), 0, 53561 }, /* ADD.B Dn,(xxx).L */
{ CPUFUNC(op_d140_0), 0, 53568 }, /* ADDX.W Dn,Dn */
{ CPUFUNC(op_d148_0), 0, 53576 }, /* ADDX.W -(An),-(An) */
{ CPUFUNC(op_d150_0), 0, 53584 }, /* ADD.W Dn,(An) */
{ CPUFUNC(op_d158_0), 0, 53592 }, /* ADD.W Dn,(An)+ */
{ CPUFUNC(op_d160_0), 0, 53600 }, /* ADD.W Dn,-(An) */
{ CPUFUNC(op_d168_0), 0, 53608 }, /* ADD.W Dn,(d16,An) */
{ CPUFUNC(op_d170_3), 0, 53616 }, /* ADD.W Dn,(d8,An,Xn) */
{ CPUFUNC(op_d178_0), 0, 53624 }, /* ADD.W Dn,(xxx).W */
{ CPUFUNC(op_d179_0), 0, 53625 }, /* ADD.W Dn,(xxx).L */
{ CPUFUNC(op_d180_0), 0, 53632 }, /* ADDX.L Dn,Dn */
{ CPUFUNC(op_d188_0), 0, 53640 }, /* ADDX.L -(An),-(An) */
{ CPUFUNC(op_d190_0), 0, 53648 }, /* ADD.L Dn,(An) */
{ CPUFUNC(op_d198_0), 0, 53656 }, /* ADD.L Dn,(An)+ */
{ CPUFUNC(op_d1a0_0), 0, 53664 }, /* ADD.L Dn,-(An) */
{ CPUFUNC(op_d1a8_0), 0, 53672 }, /* ADD.L Dn,(d16,An) */
{ CPUFUNC(op_d1b0_3), 0, 53680 }, /* ADD.L Dn,(d8,An,Xn) */
{ CPUFUNC(op_d1b8_0), 0, 53688 }, /* ADD.L Dn,(xxx).W */
{ CPUFUNC(op_d1b9_0), 0, 53689 }, /* ADD.L Dn,(xxx).L */
{ CPUFUNC_FF(op_d1c0_0), 0, 53696 }, /* ADDA.L Dn,An */
{ CPUFUNC_FF(op_d1c8_0), 0, 53704 }, /* ADDA.L An,An */
{ CPUFUNC_FF(op_d1d0_0), 0, 53712 }, /* ADDA.L (An),An */
{ CPUFUNC_FF(op_d1d8_0), 0, 53720 }, /* ADDA.L (An)+,An */
{ CPUFUNC_FF(op_d1e0_0), 0, 53728 }, /* ADDA.L -(An),An */
{ CPUFUNC_FF(op_d1e8_0), 0, 53736 }, /* ADDA.L (d16,An),An */
{ CPUFUNC_FF(op_d1f0_3), 0, 53744 }, /* ADDA.L (d8,An,Xn),An */
{ CPUFUNC_FF(op_d1f8_0), 0, 53752 }, /* ADDA.L (xxx).W,An */
{ CPUFUNC_FF(op_d1f9_0), 0, 53753 }, /* ADDA.L (xxx).L,An */
{ CPUFUNC_FF(op_d1fa_0), 0, 53754 }, /* ADDA.L (d16,PC),An */
{ CPUFUNC_FF(op_d1fb_3), 0, 53755 }, /* ADDA.L (d8,PC,Xn),An */
{ CPUFUNC_FF(op_d1fc_0), 0, 53756 }, /* ADDA.L #<data>.L,An */
{ CPUFUNC(op_e000_0), 0, 57344 }, /* ASR.B #<data>,Dn */
{ CPUFUNC(op_e008_0), 0, 57352 }, /* LSR.B #<data>,Dn */
{ CPUFUNC(op_e010_0), 0, 57360 }, /* ROXR.B #<data>,Dn */
{ CPUFUNC(op_e018_0), 0, 57368 }, /* ROR.B #<data>,Dn */
{ CPUFUNC(op_e020_0), 0, 57376 }, /* ASR.B Dn,Dn */
{ CPUFUNC(op_e028_0), 0, 57384 }, /* LSR.B Dn,Dn */
{ CPUFUNC(op_e030_0), 0, 57392 }, /* ROXR.B Dn,Dn */
{ CPUFUNC(op_e038_0), 0, 57400 }, /* ROR.B Dn,Dn */
{ CPUFUNC(op_e040_0), 0, 57408 }, /* ASR.W #<data>,Dn */
{ CPUFUNC(op_e048_0), 0, 57416 }, /* LSR.W #<data>,Dn */
{ CPUFUNC(op_e050_0), 0, 57424 }, /* ROXR.W #<data>,Dn */
{ CPUFUNC(op_e058_0), 0, 57432 }, /* ROR.W #<data>,Dn */
{ CPUFUNC(op_e060_0), 0, 57440 }, /* ASR.W Dn,Dn */
{ CPUFUNC(op_e068_0), 0, 57448 }, /* LSR.W Dn,Dn */
{ CPUFUNC(op_e070_0), 0, 57456 }, /* ROXR.W Dn,Dn */
{ CPUFUNC(op_e078_0), 0, 57464 }, /* ROR.W Dn,Dn */
{ CPUFUNC(op_e080_0), 0, 57472 }, /* ASR.L #<data>,Dn */
{ CPUFUNC(op_e088_0), 0, 57480 }, /* LSR.L #<data>,Dn */
{ CPUFUNC(op_e090_0), 0, 57488 }, /* ROXR.L #<data>,Dn */
{ CPUFUNC(op_e098_0), 0, 57496 }, /* ROR.L #<data>,Dn */
{ CPUFUNC(op_e0a0_0), 0, 57504 }, /* ASR.L Dn,Dn */
{ CPUFUNC(op_e0a8_0), 0, 57512 }, /* LSR.L Dn,Dn */
{ CPUFUNC(op_e0b0_0), 0, 57520 }, /* ROXR.L Dn,Dn */
{ CPUFUNC(op_e0b8_0), 0, 57528 }, /* ROR.L Dn,Dn */
{ CPUFUNC(op_e0d0_0), 0, 57552 }, /* ASRW.W (An) */
{ CPUFUNC(op_e0d8_0), 0, 57560 }, /* ASRW.W (An)+ */
{ CPUFUNC(op_e0e0_0), 0, 57568 }, /* ASRW.W -(An) */
{ CPUFUNC(op_e0e8_0), 0, 57576 }, /* ASRW.W (d16,An) */
{ CPUFUNC(op_e0f0_3), 0, 57584 }, /* ASRW.W (d8,An,Xn) */
{ CPUFUNC(op_e0f8_0), 0, 57592 }, /* ASRW.W (xxx).W */
{ CPUFUNC(op_e0f9_0), 0, 57593 }, /* ASRW.W (xxx).L */
{ CPUFUNC(op_e100_0), 0, 57600 }, /* ASL.B #<data>,Dn */
{ CPUFUNC(op_e108_0), 0, 57608 }, /* LSL.B #<data>,Dn */
{ CPUFUNC(op_e110_0), 0, 57616 }, /* ROXL.B #<data>,Dn */
{ CPUFUNC(op_e118_0), 0, 57624 }, /* ROL.B #<data>,Dn */
{ CPUFUNC(op_e120_0), 0, 57632 }, /* ASL.B Dn,Dn */
{ CPUFUNC(op_e128_0), 0, 57640 }, /* LSL.B Dn,Dn */
{ CPUFUNC(op_e130_0), 0, 57648 }, /* ROXL.B Dn,Dn */
{ CPUFUNC(op_e138_0), 0, 57656 }, /* ROL.B Dn,Dn */
{ CPUFUNC(op_e140_0), 0, 57664 }, /* ASL.W #<data>,Dn */
{ CPUFUNC(op_e148_0), 0, 57672 }, /* LSL.W #<data>,Dn */
{ CPUFUNC(op_e150_0), 0, 57680 }, /* ROXL.W #<data>,Dn */
{ CPUFUNC(op_e158_0), 0, 57688 }, /* ROL.W #<data>,Dn */
{ CPUFUNC(op_e160_0), 0, 57696 }, /* ASL.W Dn,Dn */
{ CPUFUNC(op_e168_0), 0, 57704 }, /* LSL.W Dn,Dn */
{ CPUFUNC(op_e170_0), 0, 57712 }, /* ROXL.W Dn,Dn */
{ CPUFUNC(op_e178_0), 0, 57720 }, /* ROL.W Dn,Dn */
{ CPUFUNC(op_e180_0), 0, 57728 }, /* ASL.L #<data>,Dn */
{ CPUFUNC(op_e188_0), 0, 57736 }, /* LSL.L #<data>,Dn */
{ CPUFUNC(op_e190_0), 0, 57744 }, /* ROXL.L #<data>,Dn */
{ CPUFUNC(op_e198_0), 0, 57752 }, /* ROL.L #<data>,Dn */
{ CPUFUNC(op_e1a0_0), 0, 57760 }, /* ASL.L Dn,Dn */
{ CPUFUNC(op_e1a8_0), 0, 57768 }, /* LSL.L Dn,Dn */
{ CPUFUNC(op_e1b0_0), 0, 57776 }, /* ROXL.L Dn,Dn */
{ CPUFUNC(op_e1b8_0), 0, 57784 }, /* ROL.L Dn,Dn */
{ CPUFUNC(op_e1d0_0), 0, 57808 }, /* ASLW.W (An) */
{ CPUFUNC(op_e1d8_0), 0, 57816 }, /* ASLW.W (An)+ */
{ CPUFUNC(op_e1e0_0), 0, 57824 }, /* ASLW.W -(An) */
{ CPUFUNC(op_e1e8_0), 0, 57832 }, /* ASLW.W (d16,An) */
{ CPUFUNC(op_e1f0_3), 0, 57840 }, /* ASLW.W (d8,An,Xn) */
{ CPUFUNC(op_e1f8_0), 0, 57848 }, /* ASLW.W (xxx).W */
{ CPUFUNC(op_e1f9_0), 0, 57849 }, /* ASLW.W (xxx).L */
{ CPUFUNC(op_e2d0_0), 0, 58064 }, /* LSRW.W (An) */
{ CPUFUNC(op_e2d8_0), 0, 58072 }, /* LSRW.W (An)+ */
{ CPUFUNC(op_e2e0_0), 0, 58080 }, /* LSRW.W -(An) */
{ CPUFUNC(op_e2e8_0), 0, 58088 }, /* LSRW.W (d16,An) */
{ CPUFUNC(op_e2f0_3), 0, 58096 }, /* LSRW.W (d8,An,Xn) */
{ CPUFUNC(op_e2f8_0), 0, 58104 }, /* LSRW.W (xxx).W */
{ CPUFUNC(op_e2f9_0), 0, 58105 }, /* LSRW.W (xxx).L */
{ CPUFUNC(op_e3d0_0), 0, 58320 }, /* LSLW.W (An) */
{ CPUFUNC(op_e3d8_0), 0, 58328 }, /* LSLW.W (An)+ */
{ CPUFUNC(op_e3e0_0), 0, 58336 }, /* LSLW.W -(An) */
{ CPUFUNC(op_e3e8_0), 0, 58344 }, /* LSLW.W (d16,An) */
{ CPUFUNC(op_e3f0_3), 0, 58352 }, /* LSLW.W (d8,An,Xn) */
{ CPUFUNC(op_e3f8_0), 0, 58360 }, /* LSLW.W (xxx).W */
{ CPUFUNC(op_e3f9_0), 0, 58361 }, /* LSLW.W (xxx).L */
{ CPUFUNC(op_e4d0_0), 0, 58576 }, /* ROXRW.W (An) */
{ CPUFUNC(op_e4d8_0), 0, 58584 }, /* ROXRW.W (An)+ */
{ CPUFUNC(op_e4e0_0), 0, 58592 }, /* ROXRW.W -(An) */
{ CPUFUNC(op_e4e8_0), 0, 58600 }, /* ROXRW.W (d16,An) */
{ CPUFUNC(op_e4f0_3), 0, 58608 }, /* ROXRW.W (d8,An,Xn) */
{ CPUFUNC(op_e4f8_0), 0, 58616 }, /* ROXRW.W (xxx).W */
{ CPUFUNC(op_e4f9_0), 0, 58617 }, /* ROXRW.W (xxx).L */
{ CPUFUNC(op_e5d0_0), 0, 58832 }, /* ROXLW.W (An) */
{ CPUFUNC(op_e5d8_0), 0, 58840 }, /* ROXLW.W (An)+ */
{ CPUFUNC(op_e5e0_0), 0, 58848 }, /* ROXLW.W -(An) */
{ CPUFUNC(op_e5e8_0), 0, 58856 }, /* ROXLW.W (d16,An) */
{ CPUFUNC(op_e5f0_3), 0, 58864 }, /* ROXLW.W (d8,An,Xn) */
{ CPUFUNC(op_e5f8_0), 0, 58872 }, /* ROXLW.W (xxx).W */
{ CPUFUNC(op_e5f9_0), 0, 58873 }, /* ROXLW.W (xxx).L */
{ CPUFUNC(op_e6d0_0), 0, 59088 }, /* RORW.W (An) */
{ CPUFUNC(op_e6d8_0), 0, 59096 }, /* RORW.W (An)+ */
{ CPUFUNC(op_e6e0_0), 0, 59104 }, /* RORW.W -(An) */
{ CPUFUNC(op_e6e8_0), 0, 59112 }, /* RORW.W (d16,An) */
{ CPUFUNC(op_e6f0_3), 0, 59120 }, /* RORW.W (d8,An,Xn) */
{ CPUFUNC(op_e6f8_0), 0, 59128 }, /* RORW.W (xxx).W */
{ CPUFUNC(op_e6f9_0), 0, 59129 }, /* RORW.W (xxx).L */
{ CPUFUNC(op_e7d0_0), 0, 59344 }, /* ROLW.W (An) */
{ CPUFUNC(op_e7d8_0), 0, 59352 }, /* ROLW.W (An)+ */
{ CPUFUNC(op_e7e0_0), 0, 59360 }, /* ROLW.W -(An) */
{ CPUFUNC(op_e7e8_0), 0, 59368 }, /* ROLW.W (d16,An) */
{ CPUFUNC(op_e7f0_3), 0, 59376 }, /* ROLW.W (d8,An,Xn) */
{ CPUFUNC(op_e7f8_0), 0, 59384 }, /* ROLW.W (xxx).W */
{ CPUFUNC(op_e7f9_0), 0, 59385 }, /* ROLW.W (xxx).L */
{ 0, 0, 0 }};
