unit gcvunit;
{
Copyright (C) 2000 Patrick Chevalley

http://www.ap-i.net
pch@ap-i.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
}
{$mode objfpc}{$H+}
interface

uses
  skylibcat, sysutils;
type
    GCVrec =  record ar,de,num :longint ;
                period : single;
                max,min : smallint;
                lmax,lmin,mcode : char;
                gcvs,vartype : array[1..10] of char;
                end;
Function IsGCVpath(path : string) : Boolean;
procedure SetGCVpath(path : string);
Procedure OpenGCV(ar1,ar2,de1,de2: double ; var ok : boolean);
Procedure OpenGCVwin(var ok : boolean);
Procedure ReadGCV(var lin : GCVrec; var ok : boolean);
Procedure NextGCV( var ok : boolean);
procedure CloseGCV ;
procedure OpenGCVSFileNum(fnum:integer; var ok:boolean);
Procedure ReadGCVSRec(r: integer; var lin : GCVrec; var ok : boolean);

var
  GCVpath : string;

implementation

var
   fgcv : file of GCVrec ;
   curSM : integer;
   SMname : string;
   Sm,nSM : integer;
   SMlst : array[1..50] of integer;
   FileIsOpen : Boolean = false;

Function IsGCVpath(path : string) : Boolean;
begin
result:= FileExists(slash(path)+'01.dat');
end;

procedure SetGCVpath(path : string);
var buf:string;
begin
buf:=noslash(path);
GCVpath:=buf;
end;

Procedure CloseRegion;
begin
{$I-}
if fileisopen then begin
FileisOpen:=false;
closefile(fgcv);
end;
{$I+}
end;

Procedure OpenRegion(S : integer ; var ok:boolean);
var nomreg,nomfich :string;
begin
str(S:2,nomreg);
nomfich:=GCVpath+slashchar+padzeros(nomreg,2)+'.dat';
if not FileExists(nomfich) then begin ; ok:=false ; exit; end;
if fileisopen then CloseRegion;
AssignFile(fgcv,nomfich);
FileisOpen:=true;
SMname:=nomreg;
FileMode:=0;
reset(fgcv);
ok:=true;
end;

Procedure OpenGCV(ar1,ar2,de1,de2: double ; var ok : boolean);
begin
JDCatalog:=jd2000;
curSM:=1;
ar1:=ar1*15; ar2:=ar2*15;
FindRegionList30(ar1,ar2,de1,de2,nSM,SMlst);
Sm := Smlst[curSM];
OpenRegion(Sm,ok);
end;

Procedure ReadGCV(var lin : GCVrec; var ok : boolean);
begin
ok:=true;
if eof(fgcv) then NextGCV(ok);
if ok then  Read(fgcv,lin);
end;

Procedure NextGCV( var ok : boolean);
begin
  CloseRegion;
  inc(curSM);
  if curSM>nSM then ok:=false
  else begin
    Sm := Smlst[curSM];
    OpenRegion(Sm,ok);
  end;
end;

procedure CloseGCV ;
begin
curSM:=nSM;
CloseRegion;
end;

Procedure OpenGCVwin(var ok : boolean);
begin
JDCatalog:=jd2000;
curSM:=1;
FindRegionListWin30(nSM,SMlst);
Sm := Smlst[curSM];
OpenRegion(Sm,ok);
end;

procedure OpenGCVSFileNum(fnum:integer; var ok:boolean);
begin
 OpenRegion(fnum,ok);
end;

Procedure ReadGCVSRec(r: integer; var lin : GCVrec; var ok : boolean);
begin
ok:=false;
Seek(fgcv,r);
if not eof(fgcv) then begin
   Read(fgcv,lin);
   ok:=true;
end;
end;

end.

