unit u_translation;

{$mode objfpc}{$H+}

interface

uses
  gettext, translations, u_constant, u_util,
  LazUTF8, LazFileUtils, Classes, SysUtils;

procedure GetDefaultLanguage(var buf1, buf2: string);
function Translate(lang: string = ''): string;

resourcestring
  rsHour = 'Hour';
  rsMinute = 'Minute';
  rsSecond = 'Second';
  rsDay = 'Day';
  rsMonth = 'Month';
  rsYear = 'Year';
  rsJulianYear = 'Julian Year';
  rsTropicalYear = 'Tropical year';
  rsSiderealDay = 'Sidereal day';
  rsSynodicMonth = 'Synodic month';
  rsSaros = 'Saros';
  rsSetDateAndTi = 'Set date and time';
  rsSetObservato = 'Set observatory location';
  rsConfigureThe = 'Configure the program';
  rsEquatorialCo = 'Equatorial coordinates';
  rsAltAzCoordin = 'Alt-Az coordinates';
  rsEclipticCoor = 'Ecliptic coordinates';
  rsGalacticCoor = 'Galactic coordinates';
  rsMirrorHorizo = 'Mirror horizontally';
  rsMirrorVertic = 'Mirror vertically';
  rsRotateRight = 'Rotate right';
  rsRotateLeft = 'Rotate left';
  rsShowAllSky = 'Show all sky';
  rsNorth = 'North';
  rsSouth = 'South';
  rsEast = 'East';
  rsWest = 'West';
  rsZenith = 'Zenith';
  rsCreateANewCh = 'Create a new chart';
  rsOpenAChart = 'Open a chart';
  rsSaveTheCurre = 'Save the active chart';
  rsPrintTheChar = 'Print the chart';
  rsNightVisionC = 'Night vision color';
  rsCascade = 'Cascade';
  rsTileVertical = 'Tile vertically';
  rsUndoLastChan = 'Undo last change';
  rsRedoLastChan = 'Redo last change';
  rsZoomIn = 'Zoom in';
  rsZoomOut = 'Zoom out';
  rsSetFOV = 'Set FOV';
  rsAdvancedSear = 'Advanced search';
  rsPosition = 'Position';
  rsObjectList = 'Object list';
  rsEphemerisCal = 'Ephemeris calendar';
  rsDecrementTim = 'Decrement time';
  rsNow = 'Now';
  rsIncrementTim = 'Increment time';
  rsConnectTeles = 'Connect telescope';
  rsSlew = 'Slew';
  rsSync = 'Sync';
  rsShowStars = 'Show stars';
  rsShowNebulae = 'Show deep sky objects';
  rsShowPictures = 'Show pictures';
  rsGetDSSImage = 'Get the DSS image';
  rsShowPlanets = 'Show planets';
  rsShowAsteroid = 'Show asteroids';
  rsShowComets = 'Show comets';
  rsShowMilkyWay = 'Show Milky Way';
  rsShowCoordina = 'Show coordinates grid';
  rsAddEquatoria = 'Show equatorial grid';
  rsShowConstell = 'Show constellation lines';
  rsShowConstell2 = 'Show constellation limits';
  rsShowGalactic = 'Show galactic equator';
  rsShowEcliptic = 'Show ecliptic';
  rsShowMark = 'Show mark';
  rsShowLabels = 'Show labels';
  rsShowObjectBe = 'Show objects below the horizon';
  rsSkyBackgroun = 'Sky background colour';
  rsLinkAllChart = 'Link all charts';
  rsNoObjectToLo = 'No object to lock on';
  rsChangeDrawin = 'Change drawing mode';
  rsFile = 'File';
  rsNewChart = 'New chart';
  rsOpen = 'Open';
  rsSaveAs = 'Save as...';
  rsSaveImage = 'Save image...';
  rsCloseChart = 'Close chart';
  rsCalendar = 'Calendar';
  rsPrint = 'Print';
  rsExit = 'Exit';
  rsEdit = 'Edit';
  rsCopy = 'Copy';
  rsUndo = 'Undo';
  rsRedo = 'Redo';
  rsSetup = 'Setup';
  rsConfiguratio = 'Configuration';
  rsSaveConfigur = 'Save configuration now';
  rsSaveConfigur2 = 'Save configuration on exit';
  rsDateTime = 'Date / time';
  rsObservatory = 'Observatory';
  rsLines = 'Lines';
  rsLabels = 'Labels';
  rsFonts = 'Fonts';
  rsPictures = 'Pictures';
  rsShowHideDSSI = 'Show/hide DSS image';
  rsCatalog = 'Catalog';
  rsView = 'View';
  rsFullScreen = 'Full screen';
  rsNightVision = 'Night vision';
  rsToolBar = 'Toolbar';
  rsAllToolsBar = 'All toolbars';
  rsMainBar = 'Main bar';
  rsObjectBar = 'Object bar';
  rsLeftBar = 'Left bar';
  rsRightBar = 'Right Bar';
  rsStatusBar = 'Status bar';
  rsScrollBar = 'Scroll bar';
  rsServerInform = 'Server information';
  rsChart = 'Chart';
  rsProjection = 'Projection';
  rsTransformati = 'Transformation';
  rsFieldOfVisio = 'Field of vision';
  rsViewHorizon = 'View horizon';
  rsShowObjects = 'Show objects';
  rsLinesGrid = 'Lines / grid';
  rsTelescope = 'Telescope';
  rsControlPanel = 'Control panel';
  rsWindow = 'Window';
  rsTileHorizont = 'Tile horizontally';
  rsMaximize = 'Maximize';
  rsHelp = 'Help';
  rsHelpContents = 'Help contents';
  rsSkychartHome = 'Skychart homepage';
  rsMailList = 'Mail list, discussion group';
  rsReportAProbl = 'Report a problem';
  rsAbout = 'About';
  rsResetAllLabe = 'Reset all labels';
  rsBlueMagnitud = 'Blue magnitude';
  rsVisualMagnit = 'Visual magnitude';
  rsRedMagnitude = 'Red magnitude';
  rsMagnitude = 'Magnitude';
  rsMagnitudeTyc = 'Magnitude Tycho BT';
  rsMagnitudeTyc2 = 'Magnitude Tycho VT';
  rsColorIndex = 'Colour index';
  rsSpectralClas = 'Spectral class';
  rsAnnualProper = 'Annual proper motion';
  rsClass = 'Class';
  rsNote = 'Note';
  rsTypeOfVariab = 'Type of variability';
  rsPeriod = 'Period';
  rsMagnitudeBan = 'Magnitude band';
  rsPhotographic = 'Photographic plate';
  rsMultipleFlag = 'Multiple flag';
  rsFieldNumber = 'Field Number';
  rsMagnitudeErr = 'Magnitude error';
  rsCorrelated = 'Correlated';
  rsDimension = 'Dimension';
  rsConstellatio = 'Constellation';
  rsSurfaceBrigh = 'Surface brightness';
  rsDescription = 'Description';
  rsRadialVeloci = 'Radial velocity';
  rsSurface = 'Surface';
  rsBrightness = 'Brightness';
  rsTrumplerClas = 'Trumpler class';
  rsDistance = 'Distance';
  rsBrightestSta = 'Brightest star magnitude';
  rsNumberOfStar = 'Number of stars';
  rsAge = 'Age';
  rsTotalRadius = 'Total radius';
  rsHalfMassRadi = 'Half-mass radius';
  rsCoreRadius = 'Core radius';
  rsHbetaMagnitu = 'H-Beta magnitude';
  rsCentralStarB = 'Central star B magnitude';
  rsCentralStarV = 'Central star V magnitude';
  rsDiameter = 'Diameter';
  rsIlluminatedF = 'Illuminated fraction';
  rsPhaseAngle = 'Phase angle';
  rsEstimatedTai = 'Estimated tail length';
  rsSolarElongat = 'Solar elongation';
  rsSolarDistanc = 'Solar distance';
  rsVelocity = 'Velocity';
  rsOpenCluster = 'Open cluster';
  rsGlobularClus = 'Globular cluster';
  rsGalaxy = 'Galaxy';
  rsBrightNebula = 'Bright nebula';
  rsNebula = 'Deep sky object';
  rsPlanetaryNeb = 'Planetary nebula';
  rsClusterAndNe = 'Cluster and nebula';
  rsStar = 'Star';
  rsDoubleStar = 'Double star';
  rsTripleStar = 'Triple star';
  rsVariableStar = 'Variable star';
  rsAsterism = 'Asterism';
  rsKnot = 'Knot';
  rsUnknowObject = 'Unknown object';
  rsPlateDefect = 'Plate defect';
  rsPlanet = 'Planet';
  rsAsteroid = 'Asteroid';
  rsComet = 'Comet';
  rsExternalCata = 'External catalog object';
  rsFlamsteedNum = 'Flamsteed number';
  rsBayerLetter = 'Bayer letter';
  rsParallax = 'Parallax';
  rsPositionAngl = 'Position angle';
  rsProperMotion = 'Proper motion in right ascension';
  rsProperMotion2 = 'Proper motion in declination';
  rsMagnitudeAtM = 'Magnitude at maxima';
  rsMagnitudeAtM2 = 'Magnitude at minima';
  rsEpochOfMaxim = 'Epoch of maxima';
  rsRiseTime = 'Rise time';
  rsComponent1Ma = 'Component 1 magnitude';
  rsComponent2Ma = 'Component 2 magnitude';
  rsSeparation = 'Separation';
  rsDate = 'Date';
  rsMinutes = 'minutes';
  rsLightYears = 'light years';
  rsPoleInclinat = 'Pole inclination';
  rsSunInclinati = 'Sun inclination';
  rsCentralMerid = 'Central meridian';
  rsGRSTransit = 'GRS transit';
  rsLibrationInL = 'Libration in latitude';
  rsLibrationInL2 = 'Libration in longitude';
  rsAzimuth = 'Azimuth';
  rsAltitude = 'Altitude';
  rsObsAltitude = '%sAltitude';
  rsRise = 'Rise';
  rsCulmination = 'Culmination';
  rsSet = 'Set';
  rsCircumpolar = 'Circumpolar';
  rsInvisibleAtT = 'Invisible at this latitude';
  rsLocalSideral = 'Local sidereal time';
  rsHourAngle = 'Hour angle';
  rsPlanetarySat = 'Planetary satellite';
  rsUniversalTim = 'Universal Time';
  rsVisibilityFo = 'Visibility for your observatory';
  rsFrom = 'From';
  rsTo = 'to';
  rsOffset = 'Offset';
  rsTooManyOpenW = 'Too many open windows, please close some charts.';
  rsDoYouWantToS = 'Do you want to save the program settings now?';
  rsErrorPleaseC = 'Error! Please check the database parameters.';
  rsComputeAster = 'Compute asteroid data for this month';
  rsErrorPleaseC2 =
    'Error! Please check the database parameters and load the comete data file.';
  rsNotFoundMayb =
    '%s Not found!%sMaybe the catalog is not installed, or there is a wrong path in catalog setting.';
  rsUnlockChart = 'Unlock chart';
  rsLockOn = 'Lock on %s';
  rsNotFoundInAn = '%s  Not found in any of the installed catalog indices.';
  rsSocketError = 'Socket error %s.  %s';
  rsDifferentTha = '%s (different than the configured port, maybe busy or other error.)';
  rsListenOnPort = 'Listen on port: %s';
  rsTCPIPService = 'TCP/IP service not available.';
  rsConnectedToS = 'Connected to the SQL database %s';
  rsSQLDatabaseN = 'SQL database not available.';
  rsInitializeDa = 'Initialize database';
  rsNotConnected = '%s not connected.';
  rsConnectedFro = '%s connected with %s, using chart %s, connected time:%s';
  rsOK = 'OK';
  rsCancel = 'Cancel';
  rsAz = 'Az';
  rsAlt = 'Alt';
  rsRA = 'RA';
  rsDE = 'DE';
  rsFOV = 'FOV';
  rsRotation = 'Rotation';
  rsEquatorialCo2 = 'Equatorial coordinates, equinox: %s';
  rsAltAZCoord = 'Alt/Az coord. ';
  rsGalacticCoor2 = 'Galactic coord.';
  rsLII = 'LII';
  rsBII = 'BII';
  rsL = 'L';
  rsB = 'B';
  rsFilter = 'Filter ->';
  rsMercury = 'Mercury';
  rsVenus = 'Venus';
  rsMars = 'Mars';
  rsJupiter = 'Jupiter';
  rsSaturn = 'Saturn';
  rsUranus = 'Uranus';
  rsNeptune = 'Neptune';
  rsPluto = 'Pluto';
  rsSun = 'Sun';
  rsMoon = 'Moon';
  rsSatRing = 'Sat. ring';
  rsObjectName = 'Object name';
  rsSearchFor = 'Search for';
  rsFind = 'Find';
  rsPleaseEnterA = 'Please enter an object identifier.';
  rsNotFound = '%s not found';
  rsPleaseCheckY = 'Please check your Internet connection and the URL definition';
  rsPleaseConfig = 'Please configure your DSS file path first.';
  rsFieldTooWidt = 'Field too wide! Maximum is %s';
  rsEstimatedFil = 'Estimated file size: %sMB %sDo you want to continue?';
  rsPleaseMountR = 'Please mount RealSky CD number';
  rsInDrive = 'in drive';
  rsListOfAvaila = 'List of available plates';
  rsPlateIdDateE = 'Plate id.    Date  exp.   Margin  CD  Observatory';
  rsManualTelesc = 'Manual telescope';
  rsRATurns = 'RA turns: ';
  rsDECTurns = 'DEC turns: ';
  rsClose = 'Close';
  rsCenterObject = 'Centre on this object';
  rsNeighbor = 'Neighbour';
  rsSelectAll = 'Select all';
  rsTCPIPConnect = 'TCP/IP connection';
  rsRefresh = 'Refresh';
  rsAutoRefresh = 'Auto-refresh';
  rsSearch = 'Search';
  rsSortBy = 'Sort by';
  rsSave = 'Save';
  rsProgressMess = 'Progress messages';
  rsCloseConnect = 'Close connection';
  rsTimeZone = 'Time zone';
  rsDateFrom = 'Date from';
  rsAt = 'at';
  rsBy = 'by';
  rsDays = 'days';
  rsSaveToFile = 'Save to file';
  rsResetChart = 'Reset chart';
  rsTwilight = 'Twilight';
  rsSolarEclipse = 'Solar eclipses';
  rsLunarEclipse = 'Lunar eclipses';
  rsArtificialSa = 'Artificial satellites';
  rsChart2 = 'chart:';
  rsLimitingMagn = 'Limiting magnitude, list:';
  rsMagn = 'Magn.';
  rsDiam = 'Diam.';
  rsIllum = 'Illum.';
  rsMorningTwili = 'Morning twilight';
  rsEveningTwili = 'Evening twilight';
  rsAstronomical = 'Astronomical';
  rsNautical = 'Nautical';
  rsMorning = 'Morning';
  rsEvening = 'Evening';
  rsElong = 'Elong.';
  rsWarningCalcu = 'Warning! Calculation of';
  rsDatesMayTake = 'dates may take a long time. Do you want to continue?';
  rsUT = 'UT';
  rsMax = 'Max.';
  rsType = 'Type';
  rsGamma = 'Gamma';
  rsGreatest = 'Greatest';
  rsEclipse = 'Eclipse';
  rsLatitude = 'Latitude';
  rsLongitude = 'Longitude';
  rsSunAlt = 'Sun alt.';
  rsPathWidth = 'Path width';
  rsDuration = 'Duration';
  rsPenumbra = 'Penumbra';
  rsUmbra = 'Umbra';
  rsSemi = 'Semi';
  rsPartial = 'Partial';
  rsTotal = 'Totality';
  rsSatellite = 'Satellite';
  rsRange = 'Range';
  rsDir = 'Dir';
  rsCoord = 'Coord.';
  rsMap = 'Map';
  rsPrinter = 'Printer:';
  rsResolution = 'Resolution:';
  rsSelectTheSys = 'Select the system printer and options you want to use';
  rsPrinterSetup = 'Printer setup';
  rsRasterResolu = 'Raster resolution';
  rsCommandToUse = 'Command to use to process the file.';
  rsPathToSaveTh = 'Path to save the file:';
  rsPrintMethod = 'Print method';
  rsCommandFound = 'Command found OK.';
  rsCommandNotFo = 'Command not found!';
  rsColor = 'Colour';
  rsOrientation = 'Orientation';
  rsPageMarginIn = 'Page margin in millimeters';
  rsLeft = 'Left';
  rsRight = 'Right';
  rsTop = 'Top';
  rsBottom = 'Bottom';
  rsNoMargin = 'No margin';
  rsDefaultMargi = 'Default margin';
  rsCentre = 'Centre on';
  rsZoomCentre = 'Zoom + and centre on';
  rsZoomCentre2 = 'Zoom - and centre on';
  rsNewFinderCir = 'New finder circle';
  rsRemoveLastCi = 'Remove last circle';
  rsRemoveAllCir = 'Remove all circles';
  rsNewLabel = 'New label';
  rsRemoveLastLa = 'Remove last label';
  rsRemoveAllLab = 'Remove all labels';
  rsAbortSlew = 'Abort Slew';
  rsCreatePostsc = 'Create postscript chart. Please wait...';
  rsSendChartToP = 'Send the chart to the printer.';
  rsCreateRasterWH = 'Create raster chart %d x %d. Please wait...';
  rsOpenTheBitma = 'Open the bitmap.';
  rsAbout2 = 'About %s';
  rsRATurns2 = '%sRA turns:';
  rsCCW = '%sCCW';
  rsDECTurns2 = '%sDEC turns:';
  rsCW = '%sCW';
  rsAzTurns = '%sAz turns:';
  rsAltTurns = '%sAlt turns:';
  rsDesc = 'desc:';
  rsEcliptic = 'Ecliptic';
  rsGalactic = 'Galactic';
  rsOther = 'Other';
  rsTelescopeNot = 'Telescope not connected';
  rsPleaseConfir = 'Please confirm that the telescope is pointed at %s';
  rsSkyCharts = 'Sky Charts';
  rsThisProgramI =
    'This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License';
  rsLabel = 'Label:';
  rsType2 = 'Type:';
  rsMultipleStar = 'Multiple star';
  rsSolarSystem = 'Solar System';
  rsOtherLabel = 'Other label';
  rsChartInforma = 'Chart information';
  rsIndicateHere =
    'Indicate here how to compute the required values from the data stored in the catalog text file.';
  rsSelectTheTyp = 'Select the type of objects in your catalog';
  rsInputCatalog = 'Input catalog files';
  rsCatalogShort = 'Catalog short name';
  rsCatalogLongN = 'Catalog long name';
  rsForALargeCat =
    'For a large catalog, always select Binary. For a small dataset that changes frequently, select Text. This enables you to edit the file and see the result immediately on the chart without the need to rerun this utility.';
  rsCatalogType = 'Catalog type';
  rsOutputCatalo = 'Output catalog type';
  rsGeneralCatal = 'General catalog options';
  rsDefaultNebul = 'Default nebulae parameters';
  rsDimensionAnd = 'Dimension and units';
  rsObjectType = 'Object type';
  rsRecognizeUni = 'Recognize units or object type from the file:';
  rsUsefulToRepr = '(useful to represent a flux)';
  rsDegree = 'Degree';
  rsLogarithmicS = 'Logarithmic scale';
  rsGalaxyCluste = 'Galaxy cluster';
  rsDarkNebula = 'Dark nebula';
  rsNonExistant = 'Non-existent';
  rsUnknow = 'unknown';
  rsCircle = 'Circle';
  rsSquare = 'Square';
  rsLosange = 'Lozenge';
  rsEditObjectTy = 'Edit object types';
  rsEditUnits = 'Edit units';
  rsDefaultOutli = 'Default outline parameters';
  rsLineWidth = 'Line width ';
  rsEditLineOper = 'Edit line operation';
  rsEditColor = 'Edit colour';
  rsDrawingType = 'Drawing type';
  rsClosedContou = 'Closed contour';
  rsRAOptions = 'RA options';
  rsDECOptions = 'DEC options';
  rsCoordinatesE = 'Coordinates equinox';
  rsMaximumMagni = 'Maximum magnitude';
  rsPositionEpoc = 'Position epoch';
  rsFirstChar = 'First char';
  rsLength = 'Length';
  rsSelectTheFie = 'Select the fields to use and their position in the text file';
  rsLabel2 = 'Label';
  rsUseThisField = 'Use this field as an alternative name';
  rsAdvanced = 'Advanced';
  rsOutputCatalo2 = 'Output catalog options';
  rsNumberOfFile = 'Number of files';
  rsOutputDirect = 'Output directory';
  rsAppendToAnEx = 'Append to an existing catalog ';
  rsSearchIndex = 'Search index';
  rsCreateASearc = 'Create a search index file';
  rsAddTheAltern = 'Add the alternative names to the index';
  rsIndicateTheS = 'Indicate the string identifier for each type of object:';
  rsReturn = 'Return';
  rsIndicateHowT = 'Indicate how to recognize the object size unit:';
  rsIndicateTheS2 = 'Indicate the string for each draw operation';
  rsIndicateTheS3 = 'Indicate the string for each colour';
  rsClickToChang = 'Click to change the colour ';
  rsPrev = '<<   Prev';
  rsNext = 'Next   >>';
  rsBuildCatalog = 'Build catalog';
  rsLoadProject = 'Load project';
  rsSaveProject = 'Save project';
  rsCatalogStrin = 'Catalog string';
  rsObjectSizeUn = 'Object size unit';
  rsLineOperatio = 'Line operation';
  rsStartOfObjec = 'Start of object';
  rsEndOfObject = 'End of object';
  rsDrawLine = 'Draw line';
  rsPleaseIndica = 'Please indicate a catalog short name';
  rsPleaseIndica2 = 'Please indicate a catalog long name';
  rsIsCoordinate = 'Is the coordinates epoch really %s?';
  rsRequiredFiel = 'Required field missing!';
  rsAbortedByUse = 'Aborted by user';
  rsConvertCatal = 'Convert catalog file %s';
  rsSortingTheIn = 'Sorting the index file ';
  rsCreateHeader = 'Create header';
  rsCreateFiles = 'Create files';
  rsConvertCatal2 = 'Convert catalog files';
  rsCloseFiles = 'Close files';
  rsSortingFiles = 'Sorting files by magnitude';
  rsSomeRecordsW = 'Some records where rejected, see the file %sreject.txt for details.';
  rsPleaseIndica3 = 'Please indicate the directory where the catalog must be built';
  rsWARNINGYouHa =
    'WARNING !%sYou have chosen to append the data to an existing catalog.%sThis existing catalog and index must be exactly of the same format, '
    +
    'otherwise the catalog will be corrupted.%sIt is a good idea to backup the actual files before proceeding this operation.%sDo you want to continue?';
  rsDateTime2 = 'Date/time';
  rsTimeSimulati = 'Time simulation';
  rsHorizon = 'Horizon';
  rsChartCoordin = 'Chart, coordinates';
  rsObjectFilter = 'Object filter';
  rsGridSpacing = 'Grid spacing';
  rsCdCStars = 'CdC stars';
  rsCdCNebulae = 'CdC deep sky';
  rsObsolete = 'Obsolete';
  rsDisplay = 'Display';
  rsDisplayColou = 'Display colour';
  rsDeepSkyObjec = 'Deep sky object colour';
  rsFinderCircle = 'Finder circle (eyepiece)';
  rsFinderRectan = 'Finder rectangle (CCD)';
  rsObject = 'Object';
  rsBackground = 'Background';
  rsDSSRealSky = 'DSS RealSky';
  rsServer = 'Server';
  rsInternet = 'Internet';
  rsProxy = 'Proxy';
  rsOrbitalEleme = 'Orbital elements';
  rsOnlineDSSPic = 'Online DSS pictures';
  rsApplyChangeT = 'Apply changes to all charts';
  rsStarsAndNebu = 'Stars and deep sky catalogs prepared with ';
  rsAdd = 'Add';
  rsDelete = 'Delete';
  rsCDCStarsCata = 'CdC star catalogs and settings';
  rsMin2 = 'min';
  rsMax2 = 'max';
  rsFilesPath = 'Files path';
  rsStars = 'Stars';
  rsVariables = 'Variables';
  rsDoubles = 'Doubles';
  rsBrightStars = 'Bright stars';
  rsShowIRVariab = 'Show IR variables';
  rsCDCNebulaeCa = 'CdC deep sky catalogs and settings';
  rsNebulae = 'Deep sky objects';
  rsGalaxies = 'Galaxies';
  rsGeneral = 'General';
  rsDefault = 'Default';
  rsCDCObsoleteC = 'Obsolete CdC catalogs and settings (you can still use them)';
  rsReplacedBy = 'Replaced by';
  rsNotAvailable = 'Not available';
  rsFovNumber = 'FOV number:';
  rsApply = 'Apply';
  rsCat = 'Cat.';
  rsPath = 'Path';
  rsChartSetting = 'Chart settings';
  rsYears = 'years';
  rsStarsProperM = 'Stars proper motion options (if available in the catalog)';
  rsUseTheProper = 'Use the proper motion to correct the position for the given epoch';
  rsDrawALineTha = 'Draw a line that displays the proper motion for the next';
  rsEquinox = 'Equinox:';
  rsChartCoordin2 = 'Chart coordinate systems';
  rsNutationAber = 'Nutation, aberration';
  rsFieldOfVisio3 = 'Field of vision settings';
  rsProjectionSe = 'Projection settings';
  rsObjectFilter2 = 'Object filter settings';
  rsStarsFilter = 'Star filter';
  rsFilterStars = 'Filter stars ';
  rsFieldOfVisio5 = 'Field of vision number :';
  rsLimitingMagn2 = 'Limiting magnitude:';
  rsNakedEyeRefe = 'Naked eye reference';
  rsAutomatic = 'Automatic';
  rsNebulaeFilte = 'Deep sky filter';
  rsFilterNebula = 'Filter deep sky objects';
  rsHideObjectWi = 'Hide objects wider than';
  rsLimitingSize = 'Limiting size (arcminutes):';
  rsDegreeGridSp = 'Grid spacing in degree';
  rsHourGridSpac = 'Grid spacing in hour for equatorial grid';
  rsObjectListSe = 'Object list settings';
  rsTypeOfObject = 'Object types to add to the list';
  rsSolarSystemO = 'Solar system object';
  rsStarDisplay = 'Star display';
  rsNebulaDispla = 'Deep sky objects display';
  rsFaintStarsSi = 'Faint Stars Size ';
  rsContrast = 'Contrast';
  rsColorSaturat = 'Colour saturation';
  rsIncrementFor = 'Increment for bright stars';
  rsNakedEye = 'Naked eye';
  rsHighColor = 'High colour';
  rsBlackWhite = 'Black/white';
  rsStarColourBV = 'Star colour (B-V):';
  rsCoordGrid = 'Coord. grid';
  rsEqGrid = 'Eq. grid';
  rsOrbit = 'Orbit';
  rsBoundary = 'Boundary';
  rsEyepiece = 'Eyepiece';
  rsMiscLines = 'Misc. lines';
  rsMilkyWay = 'Milky Way';
  rsStandardColo = 'Standard  colour';
  rsTheme = 'Theme';
  rsDeepSkyColou = 'Deep sky colour';
  rsUseAPresetCo = 'Use a preset colour scheme:';
  rsChooseColour = 'Choose colours for the object types';
  rsSupernovaRem = 'Supernova remnant';
  rsEmissionNebu = 'Emission nebula';
  rsReflectionNe = 'Reflection nebula';
  rsQuasar = 'Quasar';
  rsGravitationa = 'Gravitational lens';
  rsNonExistentU = 'Non-existent/unknown';
  rsFill = 'Fill?';
  rsAdjustColour = 'Adjust colour brightness';
  rsLowSurfaceBr = 'Low surface brightness';
  rsHighSurfaceB = 'High surface brightness';
  rsFainter = 'Fainter';
  rsBrighter = 'Brighter';
  rsSkyColour = 'Sky colour';
  rsDayTime = 'Day Time';
  rsAstronomical2 = 'Astronomical twilight';
  rsDefaultColor = 'Default colour';
  rsShowGridLabe = 'Show grid label';
  rsConstellatio2 = 'Constellation figures';
  rsConstellatio3 = 'Constellation figures file name: ';
  rsShowConstell3 = 'Show constellation figures';
  rsLine1 = 'Line';
  rsDash1 = 'Dash';
  rsDot1 = 'Dot';
  rsDashDot1 = 'Dash dot';
  rsDashDotDot1 = 'Dash dot dot';
  rsConstellatio4 = 'Constellation boundaries';
  rsConstellatio5 = 'Constellation boundaries file name: ';
  rsShowConstell4 = 'Show constellation boundaries';
  rsFillMilkyWay = 'Fill Milky Way';
  rsStarLabel = 'Star label';
  rsConstellatio6 = 'Constellation label';
  rsDisplayTheLa = 'Display the labels';
  rsDisplayTheCh = 'Display the chart information in the menu bar';
  rsLabelObject = 'Label object';
  rsMagnitudeDif = 'Magnitude difference';
  rsSize = 'Size';
  rsConstellatio7 = 'Constellation name';
  rsCoordinatesG = 'Coordinates grid';
  rsLegend = 'Legend';
  rsPrinterLegen = 'Printer legend';
  rsModify = 'Modify';
  rsGreekSymbol = 'Greek symbols';
  rsMarkTheChart = 'Mark the centre of the chart';
  rsWidth = 'Width';
  rsHeight = 'Height';
  rsHTTPProxy = 'HTTP proxy';
  rsUseHTTPProxy = 'Use HTTP proxy';
  rsProxyHost = 'Proxy host';
  rsProxyPort = 'Proxy port';
  rsUserName = 'User name';
  rsPassword = 'Password';
  rsFTP = 'FTP ';
  rsAnonymousPas = 'Anonymous password';
  rsFTPPassiveMo = 'FTP passive mode';
  rsCometElement = 'Sources for comet elements in MPC format (one URL per line)';
  rsAsteroidElem = 'Sources for asteroid elements in MPC format (one URL per line)';
  rsMPCHttp = 'MPC HTTP';
  rsFirst5000 = 'First 5000';
  rsOnlineDSS = 'Online DSS';
  rsOnlinePictur = 'Online pictures servers';
  rsName = 'Name';
  rsURL = 'URL';
  rsSec2 = 'Sec.';
  rsMeters = 'Meters';
  rsLoad = 'Load';
  rsObservatoryD = 'Observatory database';
  rsKm = 'Km.';
  rsDownloadCoun = 'Download country details';
  rsUpdate1 = 'Update';
  rsVicinity = 'Vicinity';
  rsAtmosphericR = 'Atmospheric refraction';
  rsPressureMill = 'Pressure (millibar)';
  rsTemperatureC = 'Temperature (Celsius)';
  rsWantToTrackA = 'Do you want to track an object before it rises?';
  rsLocalHorizon = 'Local horizon';
  rsDisplayTheLo = 'Display the local horizon line';
  rsDepressionOf = 'Depression of the visible horizon';
  rsYouLiveOnABi =
    'If you observe high on a mountain, the horizon line will be lower than it would be at sea level.';
  rsDrawTheAppar = 'Draw the apparent depressed horizon line';
  rsUpdateOrAddT = 'Update/add the current location to the database?';
  rsUpdatedSucce = 'Updated successfully!';
  rsDeleteTheCur = 'Delete the current location from the database?';
  rsDeletedSucce = 'Deleted successfully!';
  rsThisActionRe =
    'This action overwrites all the database content for the country %s, using fresh data from NGA and GNIS.%sAll your editing for this country will be lost, only locations that you added with a new name will be kept.%sDo you want to continue?';
  rsCancel2 = 'Cancel %s';
  rsCancelWrongZ = 'Cancel, wrong zip file ?? %s';
  rsDisplayImage = 'Display images of catalogued objects';
  rsImageDirecto = 'Image directory';
  rsThereAreCata = 'There are %s catalogued images';
  rsScanDirector = 'Scan directory';
  rsLuminosity = 'Luminosity';
  rsReset = 'Reset';
  rsShowObjectPi = 'Show object pictures on the chart';
  rsBackgroundPi = 'Background picture';
  rsFITSFile = 'FITS file';
  rsShowThisPict = 'Show this picture';
  rsAuxiliaryFil = 'Auxiliary files';
  rsDataFilesCDr = 'Data files, CD-ROM';
  rsTemporaryFil = 'temporary file';
  rsPixels = 'pixels';
  rsMBytes = 'MBytes';
  rsRealSkyNorth = 'RealSky North';
  rsRealSkySouth = 'RealSky South';
  rs102CDDSS = '102 CD DSS';
  rsUseSubsampli = 'Use subsampling to limit the image size to';
  rsSelectPlateF = 'Select a plate from the list';
  rsUseOnlineDSS = 'Use online DSS instead of RealSky';
  rsDEC = 'DEC';
  rsNoPicture = 'No picture';
  rsSolarSystemS = 'Solar system settings';
  rsDataFiles = 'Data files:';
  rsPlanetsSetti = 'Planet settings';
  rsJupiterGRSLo = 'Jupiter GRS longitude:';
  rsShowPlanetOn = 'Show planets on the chart';
  rsDrawPlanetAs = 'Draw planet as';
  rsShowEarthSha = 'Show Earth shadow (Lunar eclipses)';
  rsTransparentL = 'Transparent line mode (occultations)';
  rsGeneralSetti = 'General settings';
  rsMagnitudeFai = 'magnitudes fainter than the stars.';
  rsShowCometsOn = 'Show comets on the chart';
  rsDatabaseSett = 'Database setting...';
  rsLoadMPCFile = 'Load MPC file';
  rsMessages = 'Messages:';
  rsOrUseALocalF = 'Or use a local file:';
  rsLoadMPCForma = 'Load MPC format file';
  rsDownloadLate = 'Download the latest orbital elements';
  rsDownload = 'Download';
  rsLoadFile = 'Load file';
  rsDataMaintena = 'Data maintenance';
  rsDeleteMPCDat = 'Delete MPC data selectively';
  rsQuickDelete = 'Quick delete';
  rsQuicklyDelet = 'Quickly delete all data related to comets';
  rsAddASingleEl = 'Add a single element to the database. All fields are mandatory.';
  rsDesignation = 'Designation';
  rsHAbsoluteMag = 'H absolute magnitude';
  rsGSlopeParame = 'G slope parameter';
  rsEpochJD = 'Epoch (JD)';
  rsPerihelionDa = 'Perihelion date';
  rsArgumentOfPe = 'Argument of perihelion';
  rsLongitudeAsc = 'Longitude ascending node';
  rsInclination = 'Inclination';
  rsEccentricity = 'Eccentricity';
  rsPerihelionDi = 'Perihelion distance';
  rsEquinox2 = 'Equinox';
  rsShowAsteroid3 = 'Show asteroids on the chart';
  rsOptions = 'Options';
  rsAsteroidsFro = 'asteroids from the file';
  rsOnlyNumbered = 'Only numbered asteroids';
  rsHaltAfter100 = 'Halt after 1000 errors';
  rsLoadOnlyTheF = 'Load only the first ';
  rsPrepareMonth = 'Prepare monthly data';
  rsPrepareData = 'Prepare data ';
  rsStartMonth = 'Start month';
  rsNumberOfMont = 'Number of months';
  rsCompute = 'Compute';
  rsQuicklyDelet2 = 'Quickly delete all data related to asteroids';
  rsDeleteMonthl = 'Delete monthly data ';
  rsDeleteMonthl2 = 'Delete monthly data older than ';
  rsMeanAnomaly = 'Mean anomaly';
  rsSemimajorAxi = 'Semimajor axis';
  rsReference = 'Reference';
  rsPleaseConfig2 = 'Please configure the orbital elements URL!';
  rsDownload2 = 'Download %s';
  rsToUseThisNew =
    'Before you can use the new orbital elements, you must compute the monthly data.';
  rsNoAsteroidDa = 'No asteroids data found!%sPlease load a MPC file first.';
  rsYouAreNowRea = 'You are now ready to display the asteroid for this time period.';
  rsDBName = 'DB Name:';
  rsHostName = 'Hostname:';
  rsPort = 'Port:';
  rsUserid = 'User id:';
  rsSqliteDataba = 'SQLite database';
  rsDatabaseFile = 'Database file: ';
  rsDirectory = 'Directory';
  rsPersonalData = 'Personal data';
  rsCheck = 'Check';
  rsDesktopEnvir = 'Desktop environment';
  rsURLLaunchCom = 'URL launch command';
  rsTCPIPServer = 'TCP/IP server';
  rsServerIPInte = 'Server IP interface:';
  rsServerIPPort = 'Server IP port:';
  rsUseTCPIPServ = 'Use TCP/IP server';
  rsClientConnec = 'Client connection keep alive';
  rsTelescopeSet = 'Telescope settings';
  rsManualMount = 'Manual mount';
  rsSetHowTheMou =
    'Set how the mount moves for each axis when you turn the driving knob. From then on, a click on the ''Connect telescope'' button will show you how many turns you must make to go from one object to another.';
  rsRightAscensi = 'Right Ascension';
  rsDeclination = 'Declination';
  rsTurnsHour = 'turns / hour';
  rsTurnsDegree = 'turns / degree';
  rsRevertRAKnob = 'Reverse RA knob';
  rsRevertDECKno = 'Reverse DEC knob';
  rsRevertAzKnob = 'Reverse Az knob';
  rsRevertAltKno = 'Reverse Alt knob';
  rsINDIDriverSe = 'INDI driver settings';
  rsINDIServerHo = 'INDI server host ';
  rsINDIServerPo = 'INDI server port';
  rsTelescopeNam = 'Telescope name';
  rsControlPanel2 = 'Control panel command ';
  rsAlsoBeSureTh =
    '%sAlso be sure the required database software is installed.%sPlease consult the documentation if you are unsure.%sDo you want to continue?';
  rsWarningYouAr =
    'Warning!%sYou are about to destroy the database %s and all its content, even if this content is not related to this program.%sAre you sure you want to continue?';
  rsTime = 'Time';
  rsSeconds = 'Seconds';
  rsAutoRefreshE = 'Auto-refresh every ';
  rsDifferenceBe = 'Difference between Terrestrial Time and Universal Time';
  rsTTUT = 'DeltaT: ';
  rsUseAnotherTT = 'Use another DeltaT value';
  rsSHour = 'H';
  rsSMinute = 'M';
  rsSSecond = 'S';
  rsSYear = 'Y';
  rsSMonth = 'M.';
  rsSDay = 'D';
  rsJD = 'JD:';
  rsActualSystem = 'Actual system time';
  rsUseSystemTim = 'Use system time';
  rsSimulation = 'Simulation';
  rsEvery = 'every ';
  rsNumberOfStep = 'Number of steps';
  rsPlotThePosit = 'Plot orbital motion of solar system objects.';
  rsStepUnit = 'Step unit';
  rsConnectionLi = 'Connection lines between each position';
  rsAll = 'All';
  rsNone1 = 'None';
  rsZoom = 'Zoom +';
  rsZoom2 = 'Zoom -';
  rsAbort = 'Abort';
  rsAddLabel = 'Add label';
  rsPrepareACata = 'Prepare a catalog with CatGen';
  rsComputeField = 'Compute field';
  rsChart_ = 'Chart_';
  rsDetails = 'Details';
  rsInfo = 'Information';
  rsPrintChart = 'Print chart';
  rsProgress = 'Progress';
  rsExiting = 'Exiting ...';
  rsErrorPleaseC3 =
    'Error! Please check the database parameters and load the picture package.';
  rsMoreThanObje = 'More than %s objects, the result is truncated.';
  rsThereAreObjec = 'There are %s objects in this field.';
  rsEditLabel = 'Edit label';
  rsEquatorialCo3 = 'Equatorial coord.';
  rsAltAZCoord2 = 'Alt/Az coord.';
  rsEclipticCoor3 = 'Ecliptic coord.';
  rsInclination2 = 'Inclination=';
  rsMag = 'Mag:';
  rsFOV2 = 'FOV:';
  rsConnectToSuc = 'Connection to %s, %s successful.%s';
  rsDatabaseOpen = '%sDatabase %s opened.%s';
  rsCannotOpenDa = '%sCannot open database %s! %s';
  rsTableExist = '%sThis table exists: %s';
  rsTableDoNotEx = '%sTable %s does not exist! %sPlease correct the error and retry.';
  rsAllTablesStr = '%sAll table structures exist.';
  rsSQLDatabaseS = 'SQL database software is probably not installed!';
  rsErrorCreatin = '%sError creating table %s';
  rsFileNotFound = 'File not found!';
  rsProcessingLi = 'Processing line %s';
  rsInsertFailed = 'insert failed line %s: %s';
  rsProcessingEn = 'Processing ended. Total number of comets: %s';
  rsDeleteFromEl = 'Deleting from the element table...';
  rsFailed = 'Failed: %s';
  rsDeleteDailyD = 'Deleting the daily data';
  rsDeleteComple = 'Delete completed';
  rsDeleteFromEl2 = 'Deleting from the element list...';
  rsDeleteFromNa = 'Deleting from the name list...';
  rsInsertFailed2 = 'Insert failed! %s';
  rsThisFileWasN = 'This file was not recognized as a MPCORB file.';
  rsDataStartOnL = 'Data starts on line %s';
  rsInvalidEpoch = 'invalid epoch on line%s: %s';
  rsMoreThan1000 = 'More than 1000 errors! The processing is aborted.';
  rsProcessingEn2 = 'Processing ended. Total number of asteroids: %s';
  rsDeleteFromMo = 'Deleting from the monthly table ...';
  rsDeleteFromMo2 = 'Delete from monthly table for jd<%s';
  rsDBInsertFail = 'DB insert failed for %s: %s';
  rsInvalidFITSF = 'Invalid FITS file: %s';
  rsProcessingEn3 = 'Processing ended. Total number of location :%s';
  rsNotAFITSFile = 'Not a FITS file, SIMPLE = T keyword missing';
  rsEarthShadow = 'Earth shadow';
  rsBeginProcess = 'Begin processing for jd=%s / %s';
  rsDeletePrevio = 'Delete previous data for this date.';
  rsGetAsteroidL = 'Get the asteroids list.';
  rsEndProcessin = 'End of processing: %s asteroids';
  rsProcessing = 'Processing... %s';
  rsMoveLabel = 'Move label';
  rsDefaultLabel = 'Default label';
  rsHideLabel = 'Hide label';
  rsLanguage2 = 'Language';
  rsLanguageSele = 'Language selection';
  rsMoreStars = 'More stars';
  rsLessStars = 'Less stars';
  rsMoreNebulae = 'More deep sky';
  rsLessNebulae = 'Less deep sky';
  rsTimeUnits = 'Time units';
  rsSetFOVTo = 'Set FOV to';
  rsNebulaCommon = 'Deep sky common name';
  rsStarCommonNa = 'Star common name';
  rsCommonName = 'Common name';
  rsPostscript = 'PostScript';
  rsBitmap = 'Bitmap';
  rsColorLineMod = 'Colour, line mode';
  rsBlackWhiteLi = 'Black/white, line mode';
  rsAsOnScreenBl = 'As on screen (black background!)';
  rsPortrait = 'Portrait';
  rsLandscape = 'Landscape';
  rsSystemPrinte = 'System printer';
  rsBitmapFile = 'Bitmap file';
  rsMeanPosition = 'Mean position';
  rsTruePosition = 'True position';
  rsAzimuthalCoo = 'Azimuthal coordinates';
  rsLineMode = 'Line mode';
  rsGraphic = 'Graphic';
  rsPhotographic2 = 'Photographic';
  rsParametric = 'Parametric';
  rsRed = 'Red';
  rsWhiteOnBlack = 'White on black';
  rsBlackOnWhite = 'Black on white';
  rsGreen = 'Green';
  rsFixedBlack = 'Fixed black';
  rsAbbreviation = 'Abbreviation';
  rsGeocentric = 'Geocentric';
  rsTopoCentric = 'Topocentric';
  rsLineModeDraw = 'Line mode drawing';
  rsRealisticsIm = 'Realistic images';
  rsSymbol = 'Symbol';
  rsDisplayAsASy = 'Display as a symbol';
  rsProportional = 'Proportional to the tail length';
  rsProportional2 = 'Proportional to the magnitude';
  rsEquatorialMo = 'Equatorial mount';
  rsAltAzMount = 'Alt/Az mount';
  rsNebulaeOrOth = 'Deep sky or other objects';
  rsNebulaeOutli = 'Nebulae outlines';
  rsBinaryIndexe = 'Binary indexed catalog';
  rsTextFileCata = 'Text file catalog';
  rsHoursMinutes = 'Hours, minutes, seconds';
  rsDecimalHours = 'Decimal hours';
  rsDegreesMinut = 'Degrees, minutes, seconds';
  rsDecimalDegre = 'Decimal degrees';
  rsDecimalSouth = 'Decimal south polar distance';
  rsSpline = 'Spline';
  rs50Recommende = '50   (recommended up to 100,000 objects)';
  rs184Recommend = '184 (recommended up to 1,000,000 objects)';
  rs732Recommend = '732 (recommended up to 5,000,000 objects)';
  rs9537LargerDa = '9537 (larger datasets)';
  rsMonday = 'Mon.';
  rsTuesday = 'Tue.';
  rsWednesday = 'Wed.';
  rsThursday = 'Thu.';
  rsFriday = 'Fri.';
  rsSaturday = 'Sat.';
  rsSunday = 'Sun.';
  rsJulianDay = 'Julian Day =';
  rsToday = 'Today';
  rsJDCalendar = 'JD calendar';
  rsWarningTheCu =
    'Warning! The used date or your observatory location have been changed from the previous settings. You can reply No now, '
    +
    'and use the %s button to return to your original date/time and observation location, otherwise the changes will be applied. Do you want to continue?';
  rsCoordinates = 'Coordinates:';
  rsPleaseReport = 'Please report any problem to:';
  rsProgrammer = 'Programmer:';
  rsTranslator = 'Translator:';
  rsCDCTranslator = 'Patrick Chevalley, Marc Fokker';
  rsAuthors = 'Authors';
  rsLicenseAgree = 'License agreement';
  rsPlutoIsAPlan = 'Pluto is a planet.';
  rsUncheckToAvo = 'Uncheck to avoid duplicate with minor planet 134340';
  rsRequireXplan = '(requires Xplanet 1.2.0)';
  rsEveryPositio = 'Every position';
  rsOnlyTheFirst = 'Only the first';
  rsOnlyTheLast = 'Only the last';
  rsLabelText = 'Label text';
  rsCurrentDate = 'Date of validity';
  rsFillWithHori = 'Fill with horizon colour';
  rsAD = 'AD';
  rsBC = 'BC';
  rsSelectTheTel = 'Select the telescope interface';
  rsINDIDriver = 'INDI driver';
  rsNoPrinterFou = 'No printer found!';
  rsCompassRoseS = 'Compass rose size';
  rsShowCompass = 'Show the compass rose';
  rsProgramInfor = 'Program information';
  rsCountryTimez = 'Country timezone';
  rsMoreOptions = 'More options';
  rsWarningYouAr2 =
    'Warning! you are using multiple catalogs as sources for identical objects. You risk the display of duplicates. Be sure that this is what you want.';
  rsReleaseNotes = 'Release notes';
  rsBlinkingPict = 'Blinking picture';
  rsExpertMode = 'Expert mode';
  rsTypeOfCoordi = 'Type of coordinates';
  rsApparent = 'Apparent';
  rsMeanOfTheDat = 'Mean of the date';
  rsMeanJ2000 = 'Mean J2000';
  rsMean = 'Mean';
  rsNoProperMo = '(uncorrected for proper motion, no pm data available from this catalog)';
  rsAstrometricJ = 'Astrometric J2000';
  rsTrueEquatorE = 'true equator, equinox and epoch of the date';
  rsMeanEquatorE = 'mean equator, equinox and epoch of the date';
  rsMeanEquinoxA = 'mean equinox and epoch J2000';
  rsMeanEquinoxJ = 'mean equinox J2000, epoch of the date';
  rsEpoch = 'Epoch';
  rsAlignment = 'Alignment';
  rsCenter = 'Center';
  rsRequestTimeo =
    'Request timeout. You probably asked a too wide area which demanded too much processing time on the remote server.';
  rsUnableToCrea = 'Unable to create directory ';
  rsPleaseTryToC = 'Please try to create this directory yourself and restart the program.';
  rsCouldNotLoad = 'Could not load library ';
  rsPleaseTryToR = 'Please try to reinstall the program.';
  rsSomethingGoW =
    'Something went wrong during the initialization of the program. The program needs to be closed.';
  rsStopTCPIPSer = 'Stop TCP/IP server';
  rsDateFormat = 'Date format';
  rsFixedSkyColo = 'Fixed sky colour';
  rsProperMotion3 = 'Proper motion';
  rsGetRecentMea = 'Get the recent GRS measurement from JUPOS project.';
  rsReduceDetail = 'Reduce details when moving the chart';
  rsVariableStar2 = 'Variable stars';
  rsAllConfigura = 'All configuration options';
  rsAskConfirmat = 'Ask confirmation before any Internet connection';
  rsInformationD = 'Information detail';
  rsDisplayLabel = 'Display labels for all star catalogs';
  rsUsingExistin = 'Using the existing file %s';
  rsSideral = 'Sidereal';
  rsBrightStarsS = 'Bright star size';
  rsLegal = 'Legal';
  rsMeanLocal = 'Mean local';
  rsJD2 = 'JD';
  rsClock = 'Clock';
  rsSkychartIcon = 'Skychart icon setup';
  rsAppearance = 'Appearance';
  rsIconSize = 'Icon size';
  rsText = 'Text';
  rsTextSize = 'Text size';
  rsIconTime = 'Icon time display';
  rsTrueSolar = 'True solar';
  rsCompiledWith = 'Compiled with:';
  rsFAQ = 'FAQ';
  rsQuickStartGu = 'Quick start guide';
  rsSmallStars = 'Small stars';
  rsBigStars = 'Big stars';
  rsResetChartAn = 'Reset chart and options';
  rsIconClickAct = 'Icon click action';
  rsAction = 'Action';
  rsPrefixNameWi = 'Prefix name with catalog short name';
  rsNextChart = 'Next Chart';
  rsPrintedChart = 'Printed chart';
  rsStarsBitmapF = 'Stars bitmap file';
  rsPastel = 'Pastel';
  rsCannotWriteT = 'Cannot write to';
  rsMagnitudeEcl = 'Eclipse magnitude';
  rsWarningSomeC =
    'Warning! Some comet elements are outdated. Load element valid for the current map date.';
  rsWarningSomeA =
    'Warning! Some asteroid elements are outdated. Load element valid for the current map date.';
  rsDirectoryNot2 = 'Directory not found! Please install the Skychart '
    + 'Pictures package.';
  rsWarning = 'Warning!';
  rsChangeToThis = 'Change to this setting will restart the program now!';
  rsDownloadFile = 'Download File';
  rsCopyFrom = 'Copy from:';
  rsToFile = 'to file:';
  rsASCOMTelesc = 'ASCOM telescope interface';
  rsUseTheMenuOr = 'Use the menu or button "%s" to configure this driver.';
  rsOtherSoftwar = 'Other software data';
  rsInvalidPath = 'Invalid path: ';
  rsShowPosition = 'Show position in title bar';
  rsCopyCoordina = 'Copy coordinates';
  rsResetInitial = 'Reset initial default and restart';
  rsResetToLastT = 'Reset to last time the chart was saved';
  rsNoAstronomic = 'No astronomical twilight today!';
  rsTonight = 'Tonight';
  rsAlwaysSaveWi = 'Always save without asking.';
  rsArtificialSa2 = 'Artificial satellite';
  rsPutTheFilesW = 'Put the files with a .tle extention to the %s folder';
  rsBeSureTheyUs = 'Be sure they use a DOS line end format.';
  rsCleanupMap = 'Cleanup map';
  rsGraphs = 'Graphs';
  rsSatellitesCa = 'Satellites calculation:';
  rsIncludeDayTi = 'Include day time pass';
  rsCannotComput = 'Cannot compute satellites.';
  rsPleaseInstWine =
    'Please install wine http://www.winehq.org/ to compute artificial satellites on your computer.';
  rsIfItIsNotIns = 'If it is not installed try the following depending on '
    + 'your system:';
  rsSorryCopyIsN = 'Sorry, copy is not yet implemented for this page';
  rsDownloadTLE = 'Download TLE';
  rsAnimation = 'Animation';
  rsRealTimeOpti = 'Real time options';
  rsDelayBetween = 'Delay between frame';
  rsRecordingOpt = 'Recording options';
  rsRecordAnimat = 'Record animation to file';
  rsRecordingDir = 'Recording directory';
  rsRecordingPre = 'Recording prefix';
  rsRecordingExt = 'Recording extension';
  rsFramesPerSec = 'Frames per second';
  rsFramesSize = 'Frames size';
  rsAdditionalFf = 'Additional ffmpeg options';
  rsFfmpegProgra = 'ffmpeg program path';
  rsNoChange = 'No change';
  rsFreeSize = 'Free size';
  rsEphemeris = 'Ephemeris';
  rsCannotGetYou = 'Cannot get your IP address, or no location found for this '
    + 'address.';
  rsLocationCode = 'Location code';
  rsUseOnlineSun = 'Use online Sun image from SDO or SOHO';
  rsSunImageSour = 'Sun image source';
  rsFavorite = 'Favorite';
  rsInternetLoca = 'Internet localization';
  rsRefreshImage = 'Refresh image every';
  rsHours = 'hours';
  rsServerRespon = 'Server response: ';
  rsAntiAliasDra = 'Anti Alias drawing';
  rsOffsetLabel = 'Offset label';
  rsShowLineFrom = 'Show line from moved label to object';
  rsInformationF = 'Information from catalog';
  rsNumberOfCopi = 'Number of copies';
  rsPreview = 'Preview';
  rsPrintPreview = 'Print Preview';
  rsTrackTelesco = 'Track telescope';
  rsSlewToCursor = 'Slew to cursor position';
  rsFinderCircle2 = 'Finder Circle';
  rsLoadFromFile = 'Load from file';
  rsASCOMRemote = 'ASCOM Alpaca is available on %s';
  rsDriverSelect = 'Driver Selection';
  rsRefreshRate = 'Refresh rate';
  rsSelect = 'Select';
  rsConfigure = 'Configure';
  rsSetTime = 'Set Time';
  rsTracking = 'Tracking';
  rsConnect = 'Connect';
  rsDisconnect = 'Disconnect';
  rsHide = 'Hide';
  rsPleaseEnsure = 'Please ensure that ASCOM telescope drivers are installed '
    + 'properly.';
  rsSeeHttpAscom = 'See %s for more information.';
  rsClear = 'Clear';
  rsDiconnected = 'Diconnected';
  rsStop = 'Stop';
  rsClearTarget = 'Clear Target';
  rsSetTargetTo = 'Set target to %s';
  rsNoTargetObje = 'No target object';
  rsDrift = 'Yearly drift';
  rsShowVirtualO = 'Show Virtual Observatory data';
  rsConfirmFileD = 'Confirm file delete: ';
  rsVirtualObser = 'Virtual Observatory Catalog';
  rsVOCatalog = 'VO Catalog';
  rsCatalogsAvai = '%s Catalogs available';
  rsVOCatalogBro = 'VO Catalog Browser';
  rsSearchCatalo = 'Search Catalogs';
  rsSelectCatalo = 'Select Catalog';
  rsCannotConnec = 'Cannot connect to server. %s';
  rsFieldName = 'Field Name';
  rsDataType = 'Data Type';
  rsUnits = 'Units';
  rsNoCatalogSel = 'No catalog selected, or no table from the selected catalog '
    + 'contain coordinates information.';
  rsNoData = 'No Data';
  rsLoadingCatal = 'Loading catalog list. Please wait ...';
  rsThisCatalogC = 'This catalog contain %s records. It is not possible to '
    + 'download in full for performance reason.';
  rsTheNumberOfR = 'The number of records for this catalog is unknow. The '
    + 'download will be limited to %s records';
  rsMakeSelectio = 'Make selection of the table and column you want to your '
    + 'catalog';
  rsTable = 'Table';
  rsRows = 'Rows';
  rsDefaultMagni = 'Default magnitude';
  rsDefaultSizeA = 'Default size (arcsec)';
  rsDownloadFull = 'Download full catalog';
  rsBack = 'Back';
  rsDownloadCata = 'Download catalog';
  rsCannotDraw = 'Cannot draw';
  rsDrawAsStar = 'Draw as star';
  rsDrawAsDSO = 'Draw as DSO';
  rsReload = 'Reload';
  rsByName = 'By name';
  rsAroundCurren = 'Around current position';
  rsSelectMirror = 'Select mirror site';
  rsReloadForCur = 'Reload %s for current chart';
  rsDataPreview = 'Data preview';
  rsOnlineSearch = 'Online search failed!';
  rsOnlineSearch2 = 'Online search result';
  rsMoreInformat = 'More informations';
  rsSearchByName = 'Search by name';
  rsSearchByPosi = 'Search by position';
  rsAzimuthOrigi = 'Azimuth origin';
  rsUserDefinedO = 'User defined objects';
  rsShowUserDefi = 'Show User defined objects';
  rsMaximumRows = 'Maximum rows';
  rsSelectColorB = 'Select color (black for catalog default)';
  rsShowOnlyMeri = 'Show only meridian';
  rsOneEvery = 'One every';
  rsComponent = 'Component';
  rsShowDSOLines = 'Show nebulae outlines';
  rsTransparency = 'Transparency';
  rsUseSocksProx = 'Use Socks proxy';
  rsEditDSOLines = 'Edit nebulae lines color';
  rsChartLegend = 'Chart legend';
  rsDistanceMeas = 'Distance measurement';
  rsExampleOfUse = 'Example of user defined object: North galactic pole';
  rsShowMarkInde = 'Show mark index';
  rsAbrevAsteroid = 'Ast';
  rsAbrevComet = 'Com';
  rsAbrevVariable = 'Var';
  rsAbrevDouble = 'Dbl';
  rsAbrevDark = 'Drk';
  rsAbrevGalaxyCluster = 'Gcl';
  rsAbrevGalaxy = 'Gx';
  rsAbrevOpenCluster = 'OC';
  rsAbrevGlobularCluster = 'Gb';
  rsAbrevPlanetaryNebula = 'Pl';
  rsAbrevNebula = 'Nb';
  rsAbrevClusterNebula = 'C+N';
  rsShowOnlyText = 'Show only text in detail window';
  rsButNeverFain = 'But never fainter than magnitude';
  rsShowNearEart = 'Show near Earth asteroids independently of the magnitude';
  rsAutomaticall2 = 'Automatically optimize the labels placement';
  rsDoNotFilterM = 'Do not filter Messier objects';
  rsAllObjectsAt = 'All the objects at this position';
  rsZoomMoreToVi = 'Object too faint to show on the chart';
  rsRotateBy180D = 'Rotate by 180 degrees';
  rsResetRotatio = 'Reset rotation';
  rsRotateCylind = 'Use oblique cylindrical projections';
  rsHammerAitoff = 'Hammer-Aitoff';
  rsMercator = 'Mercator';
  rsCartesian = 'Cartesian';
  rsZenitalEquid = 'Zenital equidistant';
  rsGnomonic = 'Gnomonic';
  rsSlantOrthogr = 'Slant orthographic';
  rsMinimalAltit = 'Minimal altitude';
  rsEphemerisPro = 'Ephemeris probably out of range, disabling any solar '
    + 'system object';
  rsHumidity = 'Humidity %';
  rsTroposphereT = 'Troposphere temperature lapse rate (K/km)';
  rsEarth = 'Earth';
  rsPlanetVisibi = 'Planet visibility';
  rsInnerSolarSy = 'Inner Solar System';
  rsOuterSolarSy = 'Outer Solar System';
  rsSolarSystemI = 'Solar System Information';
  rsWarningLowRe = 'Warning! Low resolution mode. Use PostScript instead and '
    + 'print the result file.';
  rsDisplayTheHo = 'Display the horizon picture';
  rsPictureAngle = 'Picture angle offset';
  rsMillionKm = 'million Km.';
  rsDSOCatalogPi = 'DSO Catalog pictures';
  rsTheImageDire =
    'The image directory contains sub-directories with the same names as the DSO catalogs. Each sub-directory contains FITS files with the names of the catalog objects. These images are used to replace the DSO symbols on the map.';
  rsShowASingleP = 'Show a single picture on the map.';
  rsViewHeader = 'View header';
  rsImageArchive = 'Image archive';
  rsDownloadArch = 'Download archive';
  rsArchiveToDir = 'Archive to directory:';
  rsImageList = 'Image list';
  rsArchiveThisI = 'Archive this image?';
  rsFilenameWith = 'Filename without path or extension';
  rsVisualisatio = 'Visualisation scale';
  rsLinear = 'Linear';
  rsScaled = 'Scaled';
  rsLog = 'Log';
  rsSqrt = 'Sqrt';
  rsConfirmation = 'Confirmation prompt before saving a file.';
  rsCount = 'Count';
  rsScanArchives = 'Scan archives';
  rsMaximumNumbe = 'Maximum number of image to show simultaneously';
  rsShowTheImage = 'Show the images on the map';
  rsAdjustTheVis = 'Adjust the visualisation scale';
  rsUseASimplePo = 'Use a simple pointer';
  rsErrorFileNot = 'Error, file not downloaded:';
  rsHighQuality = 'High quality';
  rsDarkNight = 'Dark night';
  rsStart = 'Start';
  rsEnd = 'End';
  rsStartGraphAt = 'Start graph at local noon';
  rsSelectCircle = 'Select Circle';
  rsSelectRectan = 'Select Rectangle';
  rsDoNotChangeA = 'Do not change anything here if you are not sure what you do!';
  rsForceEqSys = 'Force EqSys';
  rsBrightest = 'Brightest';
  rsAllSAMPClien = 'All SAMP clients';
  rsSAMPConfirma = 'SAMP Confirmation';
  rsASAMPApplica = 'A SAMP application send a table to load';
  rsASAMPApplica2 = 'A SAMP application send an image to load';
  rsASAMPApplica3 = 'A SAMP application send coordinates location';
  rsDoYouWantToL = 'Do you want to load it?';
  rsDoYouWantToM = 'Do you want to move the chart there?';
  rsSAMPStatus = 'SAMP status';
  rsClientList = 'Client list';
  rsSAMPIsAMessa =
    'SAMP is a messaging protocol that enables astronomy software tools to interoperate and communicate'
    + '.%sSkychart can send and receive coordinates position, FITS images and VO tables.';
  rsVOSAMPSettin = 'VO SAMP settings';
  rsForMoreInfor = 'For more information, see :';
  rsAskForConfir = 'Ask for confirmation before to jump to coordinates';
  rsAskForConfir2 = 'Ask for confirmation before to load the image';
  rsAskForConfir3 = 'Ask for confirmation before to load the table';
  rsReceiveCoord = 'Receive coordinates from other applications';
  rsReceiveFITSI = 'Receive FITS images from other applications';
  rsReceiveVOTab = 'Receive VO table data from other applications';
  rsTryToAutoCon = 'Try to auto-connect to a SAMP hub when the program start';
  rsKeepTablesOn = 'Keep tables on exit for later use';
  rsKeepImagesOn = 'Keep images on exit for later use';
  rsSendTableTo = 'Send table to';
  rsSendImageTo = 'Send image to';
  rsSAMPSetup = 'SAMP setup';
  rsConnectToSAM = 'Connect to SAMP hub';
  rsDisconnectFr = 'Disconnect from SAMP';
  rsDeltaTError = 'DeltaT uncertainty';
  rsShowImageNam = 'Show image name label';
  rsCalendarGrap = 'Calendar graph setting';
  rsGraphHeight = 'Graph height';
  rsChangeMouseM = 'Change mouse mode';
  rsShowTheSmall = 'Show the faint satellites of the outer planets';
  rsAlways = 'always';
  rsNever = 'never';
  rsTitle = 'Title';
  rsAirmass = 'Airmass';
  rsAddToObservi = 'Add %s to observing list';
  rsViewObservin = 'View observing list';
  rsObservingLis = 'Observing list';
  rsTheObserving = 'The observing list %s was modified.';
  rsDoYouWantToS2 = 'Do you want to save it?';
  rsItTakeTooLon = 'It take too long to draw the %s from catalog %s, please '
    + 'consider to not use this catalog for this FOV.';
  rsOnlyObjectsW = 'Only objects within airmass limits tonight';
  rsOnlyObjectsW2 = 'Only objects within airmass limits now';
  rsFirst = 'First';
  rsLast = 'Last';
  rsNext2 = 'Next';
  rsPrevious = 'Previous';
  rsLimit = 'Limit';
  rsTransit = 'Transit';
  rsOnlyObjectsW3 = 'Only objects within hour angle limits tonight';
  rsOnlyObjectsW4 = 'Only objects within hour angle limits now';
  rsViewOnChart = 'View on chart';
  rsUpdateCoordi = 'Update coordinates';
  rsDuplicate = 'Duplicate';
  rsForceColor = 'Force color';
  rsTelescopeFoc = 'Telescope focal length';
  rsEyepieceFoca = 'Eyepiece focal length';
  rsEyepieceAppa = 'Eyepiece apparent field of vision';
  rsPower = 'Power';
  rsPixelSize = 'Pixel size';
  rsPixelCount = 'Pixel count';
  rsEastSide = 'East side';
  rsCrossMeridia = 'Cross meridian';
  rsWestSide = 'West side';
  rsEyepieceVisi = 'Eyepiece vision';
  rsObservingLis2 = 'Observing list elements';
  rsSelectLabels = 'Select labels to recover';
  rsRecoverHidde = 'Recover hidden label';
  rsHelpBaseDir = 'en/documentation/';
  rsPrintHeader = 'Print header';
  rsPrintFooter = 'Print footer';
  rsSAMPSendCoor = 'SAMP send coordinates';
  rsGeometricAlt = 'Geometric altitude';
  rsUnsupportedS = 'Unsupported SAMP hub profile. Must be a File URL';
  rsSAMPHubProfi = 'SAMP hub profile %s found, but it is missing a required value.';
  rsNoSAMPHubPro = 'No SAMP hub profile found, no hub is running.';
  rsNumberOfIgno = 'Number of ignored invalid rows: %s';
  rsOfficialName = 'Official name';
  rsLocalizedNam = 'Localized name';
  rsIsEmpty = '%s is empty!';
  rsToolBarEdito = 'Toolbar editor';
  rsAvailableAct = 'Available actions';
  rsMinimal = 'Minimal';
  rsStandard = 'Standard';
  rsEmpty = 'Empty';
  rsStarAndNebul = 'Star and nebula limit';
  rsSearchBox = 'Search box';
  rsEditTimeIncr = 'Edit time increment';
  rsSelectTimeUn = 'Select time units';
  rsFOVBar = 'FOV bar';
  rsDivider = 'Divider';
  rsSeparator = 'Separator';
  rsDrawing = 'Drawing';
  rsFilter2 = 'Filter';
  rsLock = 'Lock';
  rsDirection2 = 'Direction';
  rsSetupOption = 'Setup Options';
  rsTools = 'Tools';
  rsZoom3 = 'Zoom';
  rsToolBox = 'Tool box';
  rsScript = 'Script';
  rsEditScript = 'Edit Script';
  rsClearAll = 'Clear all';
  rsGroup = 'Group';
  rsButton = 'Button';
  rsMemo = 'Memo';
  rsSpacer = 'Spacer';
  rsEvent = 'Event';
  rsCaption = 'Caption';
  rsColumns = 'Columns';
  rsScriptEditor = 'Script editor';
  rsDeleteAllThe = 'Delete %s, all the child nodes and the scripts?';
  rsList = 'List';
  rsComboBox = 'Combo box';
  rsActivateTheT = 'Activate the timer event when hidden';
  rsCheckList = 'CheckList';
  rsRun = 'Run';
  rsPause = 'Pause';
  rsStepInto = 'Step Into';
  rsStepOver = 'Step Over';
  rsRemoveAllBre = 'Remove all breakpoints';
  rsAbandonYourC = 'Abandon your changes?';
  rsChartCenterC = 'Add a crosshair to the chart center';
  rsAlwaysAddMer = 'Always add meridian';
  rsHourlyMotion = 'Hourly motion';
  rsKey = 'Key';
  rsManageToolbo = 'Manage tool box script';
  rsSelectScript = 'Select script';
  rsOpenScript = 'Open script';
  rsScriptIsAlre =
    'Script is already assigned to %s are you sure you want to duplicate it to %s ?';
  rsShow0Horizon = 'Show 0d horizon line';
  rsSetOptionsFo = 'Set options for best performance';
  rsVersion = 'Version';
  rsConnectionTo = 'Connection to INDI server failed!';
  rsINDIready    = 'INDI server is ready';
  rsActivateAllT = 'Activate all the functions when hidden';
  rsButtonSize = 'Button size';
  rsShowButtonTe = 'Show button text';
  rsUp = 'Up';
  rsDown = 'Down';
  rsExpand = 'Expand';
  rsCollapse = 'Collapse';
  rsTrajectories = 'Trajectories simulation';
  rsStartForward = 'Animation forward';
  rsStartBackwar = 'Animation backward';
  rsArtificialSa3 = 'Artificial satellites TLE (one URL by line)';
  rsManual = 'Manual';
  rsScreenResolu = 'Screen resolution';
  rsAdjustTheWin = 'Adjust the window size to the screen DPI';
  rsGregorianCal = 'Gregorian calendar start date';
  rsJPLEphemeris = 'JPL ephemeris search order';
  rsSearchSoftwa = 'Search software update';
  rsCometElement2 = 'Comet elements';
  rsAsteroidElem2 = 'Asteroid elements';
  rsAddLabelForE = 'Add label for every object in the list';
  rsCompilationA = 'Compilation and save successful';
  rsMissingScrip = 'Missing script title!';
  rsPleaseDownlo = 'Please download and select TLE file';
  rsTLEDownloadO = 'TLE download OK';
  rsCometUpdateS = 'Comet update successful';
  rsAsteroidUpda = 'Asteroid update successful';
  rsNewVersionAv = 'New version available';
  rsNewBetaVersi = 'New beta version available';
  rsANewVersionO = 'A new version %s of Skychart is available.%sDo you want to'
    + ' download it now?';
  rsYouAlreadyHa = 'You already have the latest available version!';
  rsOrientToTheP = 'Orient to the pole or zenith';
  rsIcons = 'Icons';
  rsChartSync = 'Time sync';
  rsRectangular = 'Rectangular';
  rsLookAt = 'Look at:';
  rsAbove = 'Above %s';
  rsResetTime = 'Reset time';
  rsSlower = 'Slower';
  rsFaster = 'Faster';
  rsCursor = 'Cursor';
  rsLy = 'ly';
  rsAddTelescope = 'Add telescope position';
  rsAddCursorPos = 'Add cursor position';
  rsJanuary = 'January';
  rsFebruary = 'February';
  rsMarch = 'March';
  rsApril = 'April';
  rsMay = 'May';
  rsJune = 'June';
  rsJuly = 'July';
  rsAugust = 'August';
  rsSeptember = 'September';
  rsOctober = 'October';
  rsNovember = 'November';
  rsDecember = 'December';
  rsSlewToChartC = 'Slew to chart center';
  rsTour = 'Tour';
  rsActivateVoic = 'Activate voice';
  rsCannotDownlo = 'Cannot download PDF help now';
  rsComputeRiseS = 'Compute rise/set time relative to this line';
  rsSlewingTo = 'Slewing to %s / %s';
  rsSyncedTo = 'Synced to %s / %s';
  rsSetToTelesco = 'Set to telescope';
  rsGetFromTeles = 'Get from telescope';
  rsMainMenu = 'Main menu';
  rsUnsupportedF = 'Unsupported file extension: %sPlease fix it.';
  rsSwapButton = 'Swap button';
  rsTarget = 'Target';
  rsHandPad = 'HandPad';
  rsSelectNone = 'Select none';
  rsObserverTool = 'Observer tools';
  rsLocationTime = 'Location / Time';
  rsMark = 'Mark';
  rsLockTheChart = 'Lock the chart at this position';
  rsUnpark = 'Unpark';
  rsPark = 'Park';
  rsDoYouReallyW = 'Do you really want to park the mount now?';
  rsUseTheIntern = 'Use the internal INDI gui panel';
  rsCooordinateS = 'Coordinate system to use with the clients';
  rsDoNotFilterB = 'Do not filter bright nebula by magnitude';
  rsDoNotRunAsAd = 'Do not run %s as %s!';
  rsAdministrato = 'administrator';
  rsGet = 'Get';
  rsASCOMDriverE = 'The ASCOM driver report an error';
  rsLoadINDIConf = 'Load INDI configuration';
  rsDeltatRecent = 'DeltaT recent value';
  rsShowCelestia = 'Show celestial equator';
  rsMosaic = 'Mosaic';
  rsMosaicCenter = 'Mosaic center';
  rsMosaicSize = 'Mosaic size';
  rsHorizontalOv = 'Horizontal overlap %';
  rsVerticalOver = 'Vertical overlap %';
  rsSendViaServe = 'Send via server';
  rsSlewComplete = 'Slew complete';
  rsPleaseWait = 'Please wait...';
  rsFlipNSMoveme = 'Flip N/S movement';
  rsSearchRadius = 'Search radius';
  rsForceJ2000 = 'Force J2000';
  rsCurrentChart = 'Current chart coordinate system';
  rsProtocolTrac = 'Protocol trace';
  rsMeasurement = 'Measurement';
  rsPrePointing = 'Pre-Pointing';
  rsObservationT = 'Observation time';
  rsPrePointLine = 'Pre-point line duration in minutes';
  rsDoNotUseRow1 = 'Do not use row %s, reserved for external software interface.';
  rsLHA = 'LHA';
  rsLockChartPos = 'Lock chart position';
  rsReplaceByTic = 'Replace by tick mark';
  rsSpeed = 'Speed';
  rsFillNebulae = 'Fill nebulae';
  rsImportMosaic = 'Import mosaic file';
  rsTruncatedToS = 'Truncated to %s catalogs';
  rsCivil = 'Civil';
  rsFindInfo = 'Find info';
  rsInformationF2 = 'Information from';
  rsFamily = 'Family';
  rsAmplitudeMin = 'Amplitude min.';
  rsAmplitudeMax = 'Amplitude max.';
  rsQualityFlag = 'Quality flag';
  rsTotalAsteroi = 'Total asteroid count';
  rsSolarSystemB = 'Solar system body';
  rsAMaximumOfFi = 'A maximum of %s files can be selected';
  rsEmail = 'email';
  rsSPICEEphemer = 'SPICE ephemeris';
  rsDownloadSola = 'Download Solar System object SPICE kernel from JPL Horizon';
  rsStartDate = 'Start date';
  rsNumberOfDays = 'Number of days';
  rsThisFileCont = 'This file contain %s elements.%sThis is probably a base file you want to load without the "Append" option.%sIt can affect the performance to append all this data to the current file%sDo you want to continue anyway?';
  rsDeleteAllExp = 'Delete all expired ephemeris';
  rsRefreshAllEp = 'Refresh all ephemeris';
  rsAppendToCurr = 'Append to current file';
  rsLineForTeles = 'Line for telescope pointing limit';
  rsMaximumDecli = 'Maximum declination';
  rsMinimumDecli = 'Minimum declination';
  rsEastHourAngl = 'East hour angle';
  rsWestHourAngl = 'West hour angle';
  rsGrids = 'Grids';
  rsEquator = 'Equator';
  rsBlurred = 'Blurred';
  rsAlwaysOnTop = 'Always on top';
  rsNoDecimalSep = 'No decimal separator';
  rsLockMagnitud = 'Lock the magnitude filter';
  rsIfYouCannotF = 'If you cannot fix the error, please contact the telescope driver author for assistance.';
  rsAlbedo = 'Albedo';
  rs63000Billion = '63000 (for billion of objects)';
  rsCursorPositi = 'Cursor position';
  rsSelectedObje = 'Selected object';
  rsChartCenter = 'Chart center';
  rsPasteCoordin = 'Paste coordinates';
  rsRenameChart = 'Rename chart';
  rsChartName = 'Chart name';
  rsRenameTheCur = 'Rename the curent chart';
  rsOrientationF = 'Orientation from zenith in Alt/Az chart';
  rsSelection = 'Selection';
  rsPolePrecessi = 'Pole precession';
  rsDrawThePosit = 'Draw the position of the pole between the following years';
  rsLabelEvery = 'Label every';
  rsInstallObjec = 'Install object catalog';
  rsSelectTheCat = 'Select the catalog to install or remove';
  rsStatus = 'Status';
  rsInstalled = 'Installed';
  rsInstall = 'Install';
  rsMissingPrere = 'Missing prerequisites';
  rsInstallNewVe = 'Install new version %s over %s';
  rsUninstall = 'Uninstall';
  rsInstalling = 'Installing';
  rsCloseTheSetu = 'Close the Setup window and launch the catalog installer tool?';
  rsCloseTheSet2 = 'Close the Setup window and launch the catalog generation tool?';
  rsRefreshTheLi = 'Refresh the list';
  rsUseTheButton = 'Use the button below or the menu "%s/%s" to install a double and variable star catalog';
  rsOpenCatalogS = 'Open Catalog Setup';
  rsStarCatalogI = 'Star catalog index';
  rsToConfigureT = 'To configure the catalog details';
  rsInstallStarC = 'Install more stars down to the lowest required magnitude';
  rsInstallOneOf = 'Install one of the variable star catalog, depending on your interest and instrumentation';
  rsInstallOneOf2 = 'Install one of the double star catalog, depending on your interest and instrumentation';
  rsInstallAddit = 'Install additional DSO catalog for the objects you want to observe';
  rsInstallPictu = 'Install pictures for this DSO catalog';
  rsInstallEphem = 'Install ephemeris data to improve the computation of solar system objects';
  rsInstallSpeci = 'Specialized catalog for specific use';
  rsSpecializedD = 'Specialized data';
  rsUnzipFile = 'Unzip file';
  rsSelectYourPr = 'Select your preference for the button layout';
  rsThisLayoutCa = 'This layout can be modified later using the menu Setup , Toolbar editor';
  rsMoreButtonsF = 'More buttons for quick access to many functions';
  rsFewerButtons = 'Fewer buttons for a cleaner space, access to other functions from the menu';
  rsConnected3 = 'Connected';
  rsDisconnected3 = 'Disconnected';
  rsMountCapabil = 'Mount capabilities: %s';
  rsSlewToEQ = 'Slewing to %s %s/%s';
  rsCannotSyncWh = 'Cannot Sync when the mount is not tracking';
  rsSyncToEQ = 'Sync to %s %s/%s';
  rsStartTracking = 'start tracking';
  rsStopTelescop = 'Stop telescope motion.';
  rsTrue = 'True';
  rsFalse = 'False';
  rsConnectionEr = 'Connection error: %s';
  rsDisconnectio = 'Disconnection error: %s';
  rsError2 = 'Error';
  rsNoResponseFr = 'No response from server';
  rsMessages2 = 'Messages';
  rsDrawAs = 'Draw as';
  rsMarkSize = 'Mark size';

// also update upsi_translation

implementation

procedure GetDefaultLanguage(var buf1, buf2: string);
var
  i: integer;
 {$ifdef darwin}
  response: TStringList;
 {$endif}
begin
  GetLanguageIDs(buf1, buf2);
  i := pos('.', buf1);
  if i > 0 then
    buf1 := copy(buf1, 1, i - 1);
 {$ifdef darwin}
  if (trim(buf1) = '') and (trim(buf2) = '') then
  begin
    writetrace('No language environment, try to read language from user database');
    response := TStringList.Create;
    ExecProcess('defaults read -g AppleLocale', response);
    if response.Count > 0 then
    begin
      buf1 := response[0];
      i := pos('_', buf1);
      if i > 0 then
        buf2 := copy(buf1, 1, i - 1);
    end;
    response.Free;
  end;
 {$endif}
end;

function Translate(lang: string = ''): string;
var
  lang2, pofile: string;
begin
  lang2 := '';
  if lang = 'ua' then
    lang := 'uk'; // new Ukranian code
  if lang = '' then
    GetDefaultLanguage(lang, lang2);
  writetrace('Try language: ' + lang + ', ' + lang2);
  pofile := format(slash(appdir) + slash('data') + slash('language') + 'skychart.%s.po', [lang]);
  if FileExists(pofile) then
    Result := lang
  else
  begin
    pofile := format(slash(appdir) + slash('data') + slash('language') +
      'skychart.%s.po', [lang2]);
    if FileExists(pofile) then
      Result := lang2
    else
    begin
      pofile := format(slash(appdir) + slash('data') + slash('language') +
        'skychart.%s.po', ['en']);
      Result := 'en';
    end;
  end;
  // translate CDC messages
  TranslateUnitResourceStrings('u_translation', systoutf8(
    slash(appdir) + slash('data') + slash('language') + 'skychart.%s.po'), Result, '');
  // translate LCL messages
  TranslateUnitResourceStrings('LCLStrConsts', systoutf8(
    slash(appdir) + slash('data') + slash('language') + 'lclstrconsts.%s.po'), Result, '');
  writetrace('Language: ' + Result);
end;

end.
