//
//  SuperTuxKart - a fun racing game with go-kart
//  Copyright (C) 2011-2015 Marianne Gagnon
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef HEADER_PARTICLE_KIND_MANAGER_HPP
#define HEADER_PARTICLE_KIND_MANAGER_HPP

#include "utils/no_copy.hpp"
#include "graphics/particle_kind.hpp"
#include <string>
#include <map>

class Material;

/**
 * \brief Holds and manages a list of all types of particles
 * \ingroup graphics
 */
class ParticleKindManager : public NoCopy
{
private:

    std::map<std::string, ParticleKind*> m_per_track_kinds;

    std::map<std::string, ParticleKind*> m_kinds;
    static ParticleKindManager* singleton;

    ParticleKindManager();

public:

    virtual   ~ParticleKindManager();

    ParticleKind* getParticles(const std::string &name);

    bool   isGlobalParticleMaterial(Material* m) const;
    void   preloadExplosions();
    void   cleanUpTrackSpecificGfx();
    void   cleanup();

    static ParticleKindManager* get();
};
#endif


