
#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(deny_unknown_fields)]
pub struct ConfigTextRules {
    #[serde(default = "default_as_false")]
    pub header_copyright: bool,
    #[serde(default = "default_as_false")]
    pub style_directives: bool,
    #[serde(default = "default_as_false")]
    pub style_semicolon: bool,
    #[serde(default = "default_as_false")]
    pub style_textwidth: bool,
}

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(deny_unknown_fields)]
pub struct ConfigSyntaxRules {
    #[serde(default = "default_as_false")]
    pub action_block_with_side_effect: bool,
    #[serde(default = "default_as_false")]
    pub blocking_assignment_in_always_at_edge: bool,
    #[serde(default = "default_as_false")]
    pub blocking_assignment_in_always_ff: bool,
    #[serde(default = "default_as_false")]
    pub blocking_assignment_in_always_latch: bool,
    #[serde(default = "default_as_false")]
    pub case_default: bool,
    #[serde(default = "default_as_false")]
    pub default_nettype_none: bool,
    #[serde(default = "default_as_false")]
    pub enum_with_type: bool,
    #[serde(default = "default_as_false")]
    pub eventlist_comma_always_ff: bool,
    #[serde(default = "default_as_false")]
    pub eventlist_or: bool,
    #[serde(default = "default_as_false")]
    pub explicit_case_default: bool,
    #[serde(default = "default_as_false")]
    pub explicit_if_else: bool,
    #[serde(default = "default_as_false")]
    pub function_same_as_system_function: bool,
    #[serde(default = "default_as_false")]
    pub function_with_automatic: bool,
    #[serde(default = "default_as_false")]
    pub general_always_level_sensitive: bool,
    #[serde(default = "default_as_false")]
    pub general_always_no_edge: bool,
    #[serde(default = "default_as_false")]
    pub generate_case_with_label: bool,
    #[serde(default = "default_as_false")]
    pub generate_for_with_label: bool,
    #[serde(default = "default_as_false")]
    pub generate_if_with_label: bool,
    #[serde(default = "default_as_false")]
    pub genvar_declaration_in_loop: bool,
    #[serde(default = "default_as_false")]
    pub genvar_declaration_out_loop: bool,
    #[serde(default = "default_as_false")]
    pub inout_with_tri: bool,
    #[serde(default = "default_as_false")]
    pub input_with_var: bool,
    #[serde(default = "default_as_false")]
    pub interface_port_with_modport: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_always: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_always_comb: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_always_ff: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_always_latch: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_generate: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_logic: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_priority: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_unique: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_unique0: bool,
    #[serde(default = "default_as_false")]
    pub keyword_forbidden_wire_reg: bool,
    #[serde(default = "default_as_false")]
    pub keyword_required_generate: bool,
    #[serde(default = "default_as_false")]
    pub localparam_explicit_type: bool,
    #[serde(default = "default_as_false")]
    pub localparam_type_twostate: bool,
    #[serde(default = "default_as_false")]
    pub loop_statement_in_always_comb: bool,
    #[serde(default = "default_as_false")]
    pub loop_statement_in_always_ff: bool,
    #[serde(default = "default_as_false")]
    pub loop_statement_in_always_latch: bool,
    #[serde(default = "default_as_false")]
    pub loop_variable_declaration: bool,
    #[serde(default = "default_as_false")]
    pub lowercamelcase_interface: bool,
    #[serde(default = "default_as_false")]
    pub lowercamelcase_module: bool,
    #[serde(default = "default_as_false")]
    pub lowercamelcase_package: bool,
    #[serde(default = "default_as_false")]
    pub module_ansi_forbidden: bool,
    #[serde(default = "default_as_false")]
    pub module_nonansi_forbidden: bool,
    #[serde(default = "default_as_false")]
    pub multiline_for_begin: bool,
    #[serde(default = "default_as_false")]
    pub multiline_if_begin: bool,
    #[serde(default = "default_as_false")]
    pub non_blocking_assignment_in_always_comb: bool,
    #[serde(default = "default_as_false")]
    pub non_blocking_assignment_in_always_no_edge: bool,
    #[serde(default = "default_as_false")]
    pub operator_case_equality: bool,
    #[serde(default = "default_as_false")]
    pub operator_incdec: bool,
    #[serde(default = "default_as_false")]
    pub operator_self_assignment: bool,
    #[serde(default = "default_as_false")]
    pub output_with_var: bool,
    #[serde(default = "default_as_false")]
    pub package_item_not_in_package: bool,
    #[serde(default = "default_as_false")]
    pub parameter_default_value: bool,
    #[serde(default = "default_as_false")]
    pub parameter_explicit_type: bool,
    #[serde(default = "default_as_false")]
    pub parameter_in_generate: bool,
    #[serde(default = "default_as_false")]
    pub parameter_in_package: bool,
    #[serde(default = "default_as_false")]
    pub parameter_type_twostate: bool,
    #[serde(default = "default_as_false")]
    pub prefix_inout: bool,
    #[serde(default = "default_as_false")]
    pub prefix_input: bool,
    #[serde(default = "default_as_false")]
    pub prefix_instance: bool,
    #[serde(default = "default_as_false")]
    pub prefix_interface: bool,
    #[serde(default = "default_as_false")]
    pub prefix_module: bool,
    #[serde(default = "default_as_false")]
    pub prefix_output: bool,
    #[serde(default = "default_as_false")]
    pub prefix_package: bool,
    #[serde(default = "default_as_false")]
    pub procedural_continuous_assignment: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_assert: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_assert_property: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_checker: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_class: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_function: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_generateblock: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_genvar: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_instance: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_interface: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_localparam: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_modport: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_module_ansi: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_module_nonansi: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_package: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_parameter: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_port_inout: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_port_input: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_port_interface: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_port_output: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_port_ref: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_program: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_property: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_sequence: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_task: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_var_class: bool,
    #[serde(default = "default_as_false")]
    pub re_forbidden_var_classmethod: bool,
    #[serde(default = "default_as_false")]
    pub re_required_assert: bool,
    #[serde(default = "default_as_false")]
    pub re_required_assert_property: bool,
    #[serde(default = "default_as_false")]
    pub re_required_checker: bool,
    #[serde(default = "default_as_false")]
    pub re_required_class: bool,
    #[serde(default = "default_as_false")]
    pub re_required_function: bool,
    #[serde(default = "default_as_false")]
    pub re_required_generateblock: bool,
    #[serde(default = "default_as_false")]
    pub re_required_genvar: bool,
    #[serde(default = "default_as_false")]
    pub re_required_instance: bool,
    #[serde(default = "default_as_false")]
    pub re_required_interface: bool,
    #[serde(default = "default_as_false")]
    pub re_required_localparam: bool,
    #[serde(default = "default_as_false")]
    pub re_required_modport: bool,
    #[serde(default = "default_as_false")]
    pub re_required_module_ansi: bool,
    #[serde(default = "default_as_false")]
    pub re_required_module_nonansi: bool,
    #[serde(default = "default_as_false")]
    pub re_required_package: bool,
    #[serde(default = "default_as_false")]
    pub re_required_parameter: bool,
    #[serde(default = "default_as_false")]
    pub re_required_port_inout: bool,
    #[serde(default = "default_as_false")]
    pub re_required_port_input: bool,
    #[serde(default = "default_as_false")]
    pub re_required_port_interface: bool,
    #[serde(default = "default_as_false")]
    pub re_required_port_output: bool,
    #[serde(default = "default_as_false")]
    pub re_required_port_ref: bool,
    #[serde(default = "default_as_false")]
    pub re_required_program: bool,
    #[serde(default = "default_as_false")]
    pub re_required_property: bool,
    #[serde(default = "default_as_false")]
    pub re_required_sequence: bool,
    #[serde(default = "default_as_false")]
    pub re_required_task: bool,
    #[serde(default = "default_as_false")]
    pub re_required_var_class: bool,
    #[serde(default = "default_as_false")]
    pub re_required_var_classmethod: bool,
    #[serde(default = "default_as_false")]
    pub sequential_block_in_always_comb: bool,
    #[serde(default = "default_as_false")]
    pub sequential_block_in_always_ff: bool,
    #[serde(default = "default_as_false")]
    pub sequential_block_in_always_latch: bool,
    #[serde(default = "default_as_false")]
    pub style_commaleading: bool,
    #[serde(default = "default_as_false")]
    pub style_indent: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_0or1space: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_0space: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_1or2space: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_1space: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_construct: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_datatype: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_end: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_maybelabel: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_new: bool,
    #[serde(default = "default_as_false")]
    pub style_keyword_newline: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_arithmetic: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_arithmetic_leading_space: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_boolean: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_boolean_leading_space: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_integer: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_integer_leading_space: bool,
    #[serde(default = "default_as_false")]
    pub style_operator_unary: bool,
    #[serde(default = "default_as_false")]
    pub style_trailingwhitespace: bool,
    #[serde(default = "default_as_false")]
    pub tab_character: bool,
    #[serde(default = "default_as_false")]
    pub uppercamelcase_interface: bool,
    #[serde(default = "default_as_false")]
    pub uppercamelcase_module: bool,
    #[serde(default = "default_as_false")]
    pub uppercamelcase_package: bool,

    #[serde(default = "default_as_false", skip_serializing)]
    pub generate_keyword: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub tab_charactor: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub genvar_declaration: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub if_with_begin: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub for_with_begin: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub legacy_always: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub generate_keyword_forbidden: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub priority_keyword: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub unique_keyword: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub unique0_keyword: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub wire_reg: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub generate_keyword_required: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub non_ansi_module: bool,
    #[serde(default = "default_as_false", skip_serializing)]
    pub level_sensitive_always: bool,
}
