
impl Config {
    pub fn new() -> Self {
        toml::from_str("").unwrap()
    }

    pub fn enable_all(mut self) -> Self {
        self.textrules.header_copyright = true;
        self.textrules.style_directives = true;
        self.textrules.style_semicolon = true;
        self.textrules.style_textwidth = true;
        self.syntaxrules.action_block_with_side_effect = true;
        self.syntaxrules.blocking_assignment_in_always_at_edge = true;
        self.syntaxrules.blocking_assignment_in_always_ff = true;
        self.syntaxrules.blocking_assignment_in_always_latch = true;
        self.syntaxrules.case_default = true;
        self.syntaxrules.default_nettype_none = true;
        self.syntaxrules.enum_with_type = true;
        self.syntaxrules.eventlist_comma_always_ff = true;
        self.syntaxrules.eventlist_or = true;
        self.syntaxrules.explicit_case_default = true;
        self.syntaxrules.explicit_if_else = true;
        self.syntaxrules.function_same_as_system_function = true;
        self.syntaxrules.function_with_automatic = true;
        self.syntaxrules.general_always_level_sensitive = true;
        self.syntaxrules.general_always_no_edge = true;
        self.syntaxrules.generate_case_with_label = true;
        self.syntaxrules.generate_for_with_label = true;
        self.syntaxrules.generate_if_with_label = true;
        self.syntaxrules.genvar_declaration_in_loop = true;
        self.syntaxrules.genvar_declaration_out_loop = true;
        self.syntaxrules.inout_with_tri = true;
        self.syntaxrules.input_with_var = true;
        self.syntaxrules.interface_port_with_modport = true;
        self.syntaxrules.keyword_forbidden_always = true;
        self.syntaxrules.keyword_forbidden_always_comb = true;
        self.syntaxrules.keyword_forbidden_always_ff = true;
        self.syntaxrules.keyword_forbidden_always_latch = true;
        self.syntaxrules.keyword_forbidden_generate = true;
        self.syntaxrules.keyword_forbidden_logic = true;
        self.syntaxrules.keyword_forbidden_priority = true;
        self.syntaxrules.keyword_forbidden_unique = true;
        self.syntaxrules.keyword_forbidden_unique0 = true;
        self.syntaxrules.keyword_forbidden_wire_reg = true;
        self.syntaxrules.keyword_required_generate = true;
        self.syntaxrules.localparam_explicit_type = true;
        self.syntaxrules.localparam_type_twostate = true;
        self.syntaxrules.loop_statement_in_always_comb = true;
        self.syntaxrules.loop_statement_in_always_ff = true;
        self.syntaxrules.loop_statement_in_always_latch = true;
        self.syntaxrules.loop_variable_declaration = true;
        self.syntaxrules.lowercamelcase_interface = true;
        self.syntaxrules.lowercamelcase_module = true;
        self.syntaxrules.lowercamelcase_package = true;
        self.syntaxrules.module_ansi_forbidden = true;
        self.syntaxrules.module_nonansi_forbidden = true;
        self.syntaxrules.multiline_for_begin = true;
        self.syntaxrules.multiline_if_begin = true;
        self.syntaxrules.non_blocking_assignment_in_always_comb = true;
        self.syntaxrules.non_blocking_assignment_in_always_no_edge = true;
        self.syntaxrules.operator_case_equality = true;
        self.syntaxrules.operator_incdec = true;
        self.syntaxrules.operator_self_assignment = true;
        self.syntaxrules.output_with_var = true;
        self.syntaxrules.package_item_not_in_package = true;
        self.syntaxrules.parameter_default_value = true;
        self.syntaxrules.parameter_explicit_type = true;
        self.syntaxrules.parameter_in_generate = true;
        self.syntaxrules.parameter_in_package = true;
        self.syntaxrules.parameter_type_twostate = true;
        self.syntaxrules.prefix_inout = true;
        self.syntaxrules.prefix_input = true;
        self.syntaxrules.prefix_instance = true;
        self.syntaxrules.prefix_interface = true;
        self.syntaxrules.prefix_module = true;
        self.syntaxrules.prefix_output = true;
        self.syntaxrules.prefix_package = true;
        self.syntaxrules.procedural_continuous_assignment = true;
        self.syntaxrules.re_forbidden_assert = true;
        self.syntaxrules.re_forbidden_assert_property = true;
        self.syntaxrules.re_forbidden_checker = true;
        self.syntaxrules.re_forbidden_class = true;
        self.syntaxrules.re_forbidden_function = true;
        self.syntaxrules.re_forbidden_generateblock = true;
        self.syntaxrules.re_forbidden_genvar = true;
        self.syntaxrules.re_forbidden_instance = true;
        self.syntaxrules.re_forbidden_interface = true;
        self.syntaxrules.re_forbidden_localparam = true;
        self.syntaxrules.re_forbidden_modport = true;
        self.syntaxrules.re_forbidden_module_ansi = true;
        self.syntaxrules.re_forbidden_module_nonansi = true;
        self.syntaxrules.re_forbidden_package = true;
        self.syntaxrules.re_forbidden_parameter = true;
        self.syntaxrules.re_forbidden_port_inout = true;
        self.syntaxrules.re_forbidden_port_input = true;
        self.syntaxrules.re_forbidden_port_interface = true;
        self.syntaxrules.re_forbidden_port_output = true;
        self.syntaxrules.re_forbidden_port_ref = true;
        self.syntaxrules.re_forbidden_program = true;
        self.syntaxrules.re_forbidden_property = true;
        self.syntaxrules.re_forbidden_sequence = true;
        self.syntaxrules.re_forbidden_task = true;
        self.syntaxrules.re_forbidden_var_class = true;
        self.syntaxrules.re_forbidden_var_classmethod = true;
        self.syntaxrules.re_required_assert = true;
        self.syntaxrules.re_required_assert_property = true;
        self.syntaxrules.re_required_checker = true;
        self.syntaxrules.re_required_class = true;
        self.syntaxrules.re_required_function = true;
        self.syntaxrules.re_required_generateblock = true;
        self.syntaxrules.re_required_genvar = true;
        self.syntaxrules.re_required_instance = true;
        self.syntaxrules.re_required_interface = true;
        self.syntaxrules.re_required_localparam = true;
        self.syntaxrules.re_required_modport = true;
        self.syntaxrules.re_required_module_ansi = true;
        self.syntaxrules.re_required_module_nonansi = true;
        self.syntaxrules.re_required_package = true;
        self.syntaxrules.re_required_parameter = true;
        self.syntaxrules.re_required_port_inout = true;
        self.syntaxrules.re_required_port_input = true;
        self.syntaxrules.re_required_port_interface = true;
        self.syntaxrules.re_required_port_output = true;
        self.syntaxrules.re_required_port_ref = true;
        self.syntaxrules.re_required_program = true;
        self.syntaxrules.re_required_property = true;
        self.syntaxrules.re_required_sequence = true;
        self.syntaxrules.re_required_task = true;
        self.syntaxrules.re_required_var_class = true;
        self.syntaxrules.re_required_var_classmethod = true;
        self.syntaxrules.sequential_block_in_always_comb = true;
        self.syntaxrules.sequential_block_in_always_ff = true;
        self.syntaxrules.sequential_block_in_always_latch = true;
        self.syntaxrules.style_commaleading = true;
        self.syntaxrules.style_indent = true;
        self.syntaxrules.style_keyword_0or1space = true;
        self.syntaxrules.style_keyword_0space = true;
        self.syntaxrules.style_keyword_1or2space = true;
        self.syntaxrules.style_keyword_1space = true;
        self.syntaxrules.style_keyword_construct = true;
        self.syntaxrules.style_keyword_datatype = true;
        self.syntaxrules.style_keyword_end = true;
        self.syntaxrules.style_keyword_maybelabel = true;
        self.syntaxrules.style_keyword_new = true;
        self.syntaxrules.style_keyword_newline = true;
        self.syntaxrules.style_operator_arithmetic = true;
        self.syntaxrules.style_operator_arithmetic_leading_space = true;
        self.syntaxrules.style_operator_boolean = true;
        self.syntaxrules.style_operator_boolean_leading_space = true;
        self.syntaxrules.style_operator_integer = true;
        self.syntaxrules.style_operator_integer_leading_space = true;
        self.syntaxrules.style_operator_unary = true;
        self.syntaxrules.style_trailingwhitespace = true;
        self.syntaxrules.tab_character = true;
        self.syntaxrules.uppercamelcase_interface = true;
        self.syntaxrules.uppercamelcase_module = true;
        self.syntaxrules.uppercamelcase_package = true;

        self
    }

    pub fn gen_textrules(&self) -> Vec<Box<dyn TextRule>> {
        let mut ret: Vec<Box<dyn TextRule>> = Vec::new();
        if self.textrules.header_copyright {
            ret.push(Box::new(HeaderCopyright::default()));
        }
        if self.textrules.style_directives {
            ret.push(Box::new(StyleDirectives::default()));
        }
        if self.textrules.style_semicolon {
            ret.push(Box::new(StyleSemicolon::default()));
        }
        if self.textrules.style_textwidth {
            ret.push(Box::new(StyleTextwidth::default()));
        }
        ret
    }

    pub fn gen_syntaxrules(&self) -> Vec<Box<dyn SyntaxRule>> {
        let mut ret: Vec<Box<dyn SyntaxRule>> = Vec::new();
        if self.syntaxrules.action_block_with_side_effect {
            ret.push(Box::new(ActionBlockWithSideEffect::default()));
        }
        if self.syntaxrules.blocking_assignment_in_always_at_edge {
            ret.push(Box::new(BlockingAssignmentInAlwaysAtEdge::default()));
        }
        if self.syntaxrules.blocking_assignment_in_always_ff {
            ret.push(Box::new(BlockingAssignmentInAlwaysFf::default()));
        }
        if self.syntaxrules.blocking_assignment_in_always_latch {
            ret.push(Box::new(BlockingAssignmentInAlwaysLatch::default()));
        }
        if self.syntaxrules.case_default {
            ret.push(Box::new(CaseDefault::default()));
        }
        if self.syntaxrules.default_nettype_none {
            ret.push(Box::new(DefaultNettypeNone::default()));
        }
        if self.syntaxrules.enum_with_type {
            ret.push(Box::new(EnumWithType::default()));
        }
        if self.syntaxrules.eventlist_comma_always_ff {
            ret.push(Box::new(EventlistCommaAlwaysFf::default()));
        }
        if self.syntaxrules.eventlist_or {
            ret.push(Box::new(EventlistOr::default()));
        }
        if self.syntaxrules.explicit_case_default {
            ret.push(Box::new(ExplicitCaseDefault::default()));
        }
        if self.syntaxrules.explicit_if_else {
            ret.push(Box::new(ExplicitIfElse::default()));
        }
        if self.syntaxrules.function_same_as_system_function {
            ret.push(Box::new(FunctionSameAsSystemFunction::default()));
        }
        if self.syntaxrules.function_with_automatic {
            ret.push(Box::new(FunctionWithAutomatic::default()));
        }
        if self.syntaxrules.general_always_level_sensitive {
            ret.push(Box::new(GeneralAlwaysLevelSensitive::default()));
        }
        if self.syntaxrules.general_always_no_edge {
            ret.push(Box::new(GeneralAlwaysNoEdge::default()));
        }
        if self.syntaxrules.generate_case_with_label {
            ret.push(Box::new(GenerateCaseWithLabel::default()));
        }
        if self.syntaxrules.generate_for_with_label {
            ret.push(Box::new(GenerateForWithLabel::default()));
        }
        if self.syntaxrules.generate_if_with_label {
            ret.push(Box::new(GenerateIfWithLabel::default()));
        }
        if self.syntaxrules.genvar_declaration_in_loop {
            ret.push(Box::new(GenvarDeclarationInLoop::default()));
        }
        if self.syntaxrules.genvar_declaration_out_loop {
            ret.push(Box::new(GenvarDeclarationOutLoop::default()));
        }
        if self.syntaxrules.inout_with_tri {
            ret.push(Box::new(InoutWithTri::default()));
        }
        if self.syntaxrules.input_with_var {
            ret.push(Box::new(InputWithVar::default()));
        }
        if self.syntaxrules.interface_port_with_modport {
            ret.push(Box::new(InterfacePortWithModport::default()));
        }
        if self.syntaxrules.keyword_forbidden_always {
            ret.push(Box::new(KeywordForbiddenAlways::default()));
        }
        if self.syntaxrules.keyword_forbidden_always_comb {
            ret.push(Box::new(KeywordForbiddenAlwaysComb::default()));
        }
        if self.syntaxrules.keyword_forbidden_always_ff {
            ret.push(Box::new(KeywordForbiddenAlwaysFf::default()));
        }
        if self.syntaxrules.keyword_forbidden_always_latch {
            ret.push(Box::new(KeywordForbiddenAlwaysLatch::default()));
        }
        if self.syntaxrules.keyword_forbidden_generate {
            ret.push(Box::new(KeywordForbiddenGenerate::default()));
        }
        if self.syntaxrules.keyword_forbidden_logic {
            ret.push(Box::new(KeywordForbiddenLogic::default()));
        }
        if self.syntaxrules.keyword_forbidden_priority {
            ret.push(Box::new(KeywordForbiddenPriority::default()));
        }
        if self.syntaxrules.keyword_forbidden_unique {
            ret.push(Box::new(KeywordForbiddenUnique::default()));
        }
        if self.syntaxrules.keyword_forbidden_unique0 {
            ret.push(Box::new(KeywordForbiddenUnique0::default()));
        }
        if self.syntaxrules.keyword_forbidden_wire_reg {
            ret.push(Box::new(KeywordForbiddenWireReg::default()));
        }
        if self.syntaxrules.keyword_required_generate {
            ret.push(Box::new(KeywordRequiredGenerate::default()));
        }
        if self.syntaxrules.localparam_explicit_type {
            ret.push(Box::new(LocalparamExplicitType::default()));
        }
        if self.syntaxrules.localparam_type_twostate {
            ret.push(Box::new(LocalparamTypeTwostate::default()));
        }
        if self.syntaxrules.loop_statement_in_always_comb {
            ret.push(Box::new(LoopStatementInAlwaysComb::default()));
        }
        if self.syntaxrules.loop_statement_in_always_ff {
            ret.push(Box::new(LoopStatementInAlwaysFf::default()));
        }
        if self.syntaxrules.loop_statement_in_always_latch {
            ret.push(Box::new(LoopStatementInAlwaysLatch::default()));
        }
        if self.syntaxrules.loop_variable_declaration {
            ret.push(Box::new(LoopVariableDeclaration::default()));
        }
        if self.syntaxrules.lowercamelcase_interface {
            ret.push(Box::new(LowercamelcaseInterface::default()));
        }
        if self.syntaxrules.lowercamelcase_module {
            ret.push(Box::new(LowercamelcaseModule::default()));
        }
        if self.syntaxrules.lowercamelcase_package {
            ret.push(Box::new(LowercamelcasePackage::default()));
        }
        if self.syntaxrules.module_ansi_forbidden {
            ret.push(Box::new(ModuleAnsiForbidden::default()));
        }
        if self.syntaxrules.module_nonansi_forbidden {
            ret.push(Box::new(ModuleNonansiForbidden::default()));
        }
        if self.syntaxrules.multiline_for_begin {
            ret.push(Box::new(MultilineForBegin::default()));
        }
        if self.syntaxrules.multiline_if_begin {
            ret.push(Box::new(MultilineIfBegin::default()));
        }
        if self.syntaxrules.non_blocking_assignment_in_always_comb {
            ret.push(Box::new(NonBlockingAssignmentInAlwaysComb::default()));
        }
        if self.syntaxrules.non_blocking_assignment_in_always_no_edge {
            ret.push(Box::new(NonBlockingAssignmentInAlwaysNoEdge::default()));
        }
        if self.syntaxrules.operator_case_equality {
            ret.push(Box::new(OperatorCaseEquality::default()));
        }
        if self.syntaxrules.operator_incdec {
            ret.push(Box::new(OperatorIncdec::default()));
        }
        if self.syntaxrules.operator_self_assignment {
            ret.push(Box::new(OperatorSelfAssignment::default()));
        }
        if self.syntaxrules.output_with_var {
            ret.push(Box::new(OutputWithVar::default()));
        }
        if self.syntaxrules.package_item_not_in_package {
            ret.push(Box::new(PackageItemNotUnderPackage::default()));
        }
        if self.syntaxrules.parameter_default_value {
            ret.push(Box::new(ParameterDefaultValue::default()));
        }
        if self.syntaxrules.parameter_explicit_type {
            ret.push(Box::new(ParameterExplicitType::default()));
        }
        if self.syntaxrules.parameter_in_generate {
            ret.push(Box::new(ParameterInGenerate::default()));
        }
        if self.syntaxrules.parameter_in_package {
            ret.push(Box::new(ParameterInPackage::default()));
        }
        if self.syntaxrules.parameter_type_twostate {
            ret.push(Box::new(ParameterTypeTwostate::default()));
        }
        if self.syntaxrules.prefix_inout {
            ret.push(Box::new(PrefixInout::default()));
        }
        if self.syntaxrules.prefix_input {
            ret.push(Box::new(PrefixInput::default()));
        }
        if self.syntaxrules.prefix_instance {
            ret.push(Box::new(PrefixInstance::default()));
        }
        if self.syntaxrules.prefix_interface {
            ret.push(Box::new(PrefixInterface::default()));
        }
        if self.syntaxrules.prefix_module {
            ret.push(Box::new(PrefixModule::default()));
        }
        if self.syntaxrules.prefix_output {
            ret.push(Box::new(PrefixOutput::default()));
        }
        if self.syntaxrules.prefix_package {
            ret.push(Box::new(PrefixPackage::default()));
        }
        if self.syntaxrules.procedural_continuous_assignment {
            ret.push(Box::new(ProceduralContinuousAssignment::default()));
        }
        if self.syntaxrules.re_forbidden_assert {
            ret.push(Box::new(ReForbiddenAssert::default()));
        }
        if self.syntaxrules.re_forbidden_assert_property {
            ret.push(Box::new(ReForbiddenAssertProperty::default()));
        }
        if self.syntaxrules.re_forbidden_checker {
            ret.push(Box::new(ReForbiddenChecker::default()));
        }
        if self.syntaxrules.re_forbidden_class {
            ret.push(Box::new(ReForbiddenClass::default()));
        }
        if self.syntaxrules.re_forbidden_function {
            ret.push(Box::new(ReForbiddenFunction::default()));
        }
        if self.syntaxrules.re_forbidden_generateblock {
            ret.push(Box::new(ReForbiddenGenerateblock::default()));
        }
        if self.syntaxrules.re_forbidden_genvar {
            ret.push(Box::new(ReForbiddenGenvar::default()));
        }
        if self.syntaxrules.re_forbidden_instance {
            ret.push(Box::new(ReForbiddenInstance::default()));
        }
        if self.syntaxrules.re_forbidden_interface {
            ret.push(Box::new(ReForbiddenInterface::default()));
        }
        if self.syntaxrules.re_forbidden_localparam {
            ret.push(Box::new(ReForbiddenLocalparam::default()));
        }
        if self.syntaxrules.re_forbidden_modport {
            ret.push(Box::new(ReForbiddenModport::default()));
        }
        if self.syntaxrules.re_forbidden_module_ansi {
            ret.push(Box::new(ReForbiddenModuleAnsi::default()));
        }
        if self.syntaxrules.re_forbidden_module_nonansi {
            ret.push(Box::new(ReForbiddenModuleNonansi::default()));
        }
        if self.syntaxrules.re_forbidden_package {
            ret.push(Box::new(ReForbiddenPackage::default()));
        }
        if self.syntaxrules.re_forbidden_parameter {
            ret.push(Box::new(ReForbiddenParameter::default()));
        }
        if self.syntaxrules.re_forbidden_port_inout {
            ret.push(Box::new(ReForbiddenPortInout::default()));
        }
        if self.syntaxrules.re_forbidden_port_input {
            ret.push(Box::new(ReForbiddenPortInput::default()));
        }
        if self.syntaxrules.re_forbidden_port_interface {
            ret.push(Box::new(ReForbiddenPortInterface::default()));
        }
        if self.syntaxrules.re_forbidden_port_output {
            ret.push(Box::new(ReForbiddenPortOutput::default()));
        }
        if self.syntaxrules.re_forbidden_port_ref {
            ret.push(Box::new(ReForbiddenPortRef::default()));
        }
        if self.syntaxrules.re_forbidden_program {
            ret.push(Box::new(ReForbiddenProgram::default()));
        }
        if self.syntaxrules.re_forbidden_property {
            ret.push(Box::new(ReForbiddenProperty::default()));
        }
        if self.syntaxrules.re_forbidden_sequence {
            ret.push(Box::new(ReForbiddenSequence::default()));
        }
        if self.syntaxrules.re_forbidden_task {
            ret.push(Box::new(ReForbiddenTask::default()));
        }
        if self.syntaxrules.re_forbidden_var_class {
            ret.push(Box::new(ReForbiddenVarClass::default()));
        }
        if self.syntaxrules.re_forbidden_var_classmethod {
            ret.push(Box::new(ReForbiddenVarClassmethod::default()));
        }
        if self.syntaxrules.re_required_assert {
            ret.push(Box::new(ReRequiredAssert::default()));
        }
        if self.syntaxrules.re_required_assert_property {
            ret.push(Box::new(ReRequiredAssertProperty::default()));
        }
        if self.syntaxrules.re_required_checker {
            ret.push(Box::new(ReRequiredChecker::default()));
        }
        if self.syntaxrules.re_required_class {
            ret.push(Box::new(ReRequiredClass::default()));
        }
        if self.syntaxrules.re_required_function {
            ret.push(Box::new(ReRequiredFunction::default()));
        }
        if self.syntaxrules.re_required_generateblock {
            ret.push(Box::new(ReRequiredGenerateblock::default()));
        }
        if self.syntaxrules.re_required_genvar {
            ret.push(Box::new(ReRequiredGenvar::default()));
        }
        if self.syntaxrules.re_required_instance {
            ret.push(Box::new(ReRequiredInstance::default()));
        }
        if self.syntaxrules.re_required_interface {
            ret.push(Box::new(ReRequiredInterface::default()));
        }
        if self.syntaxrules.re_required_localparam {
            ret.push(Box::new(ReRequiredLocalparam::default()));
        }
        if self.syntaxrules.re_required_modport {
            ret.push(Box::new(ReRequiredModport::default()));
        }
        if self.syntaxrules.re_required_module_ansi {
            ret.push(Box::new(ReRequiredModuleAnsi::default()));
        }
        if self.syntaxrules.re_required_module_nonansi {
            ret.push(Box::new(ReRequiredModuleNonansi::default()));
        }
        if self.syntaxrules.re_required_package {
            ret.push(Box::new(ReRequiredPackage::default()));
        }
        if self.syntaxrules.re_required_parameter {
            ret.push(Box::new(ReRequiredParameter::default()));
        }
        if self.syntaxrules.re_required_port_inout {
            ret.push(Box::new(ReRequiredPortInout::default()));
        }
        if self.syntaxrules.re_required_port_input {
            ret.push(Box::new(ReRequiredPortInput::default()));
        }
        if self.syntaxrules.re_required_port_interface {
            ret.push(Box::new(ReRequiredPortInterface::default()));
        }
        if self.syntaxrules.re_required_port_output {
            ret.push(Box::new(ReRequiredPortOutput::default()));
        }
        if self.syntaxrules.re_required_port_ref {
            ret.push(Box::new(ReRequiredPortRef::default()));
        }
        if self.syntaxrules.re_required_program {
            ret.push(Box::new(ReRequiredProgram::default()));
        }
        if self.syntaxrules.re_required_property {
            ret.push(Box::new(ReRequiredProperty::default()));
        }
        if self.syntaxrules.re_required_sequence {
            ret.push(Box::new(ReRequiredSequence::default()));
        }
        if self.syntaxrules.re_required_task {
            ret.push(Box::new(ReRequiredTask::default()));
        }
        if self.syntaxrules.re_required_var_class {
            ret.push(Box::new(ReRequiredVarClass::default()));
        }
        if self.syntaxrules.re_required_var_classmethod {
            ret.push(Box::new(ReRequiredVarClassmethod::default()));
        }
        if self.syntaxrules.sequential_block_in_always_comb {
            ret.push(Box::new(SequentialBlockInAlwaysComb::default()));
        }
        if self.syntaxrules.sequential_block_in_always_ff {
            ret.push(Box::new(SequentialBlockInAlwaysFf::default()));
        }
        if self.syntaxrules.sequential_block_in_always_latch {
            ret.push(Box::new(SequentialBlockInAlwaysLatch::default()));
        }
        if self.syntaxrules.style_commaleading {
            ret.push(Box::new(StyleCommaleading::default()));
        }
        if self.syntaxrules.style_indent {
            ret.push(Box::new(StyleIndent::default()));
        }
        if self.syntaxrules.style_keyword_0or1space {
            ret.push(Box::new(StyleKeyword0Or1Space::default()));
        }
        if self.syntaxrules.style_keyword_0space {
            ret.push(Box::new(StyleKeyword0Space::default()));
        }
        if self.syntaxrules.style_keyword_1or2space {
            ret.push(Box::new(StyleKeyword1Or2Space::default()));
        }
        if self.syntaxrules.style_keyword_1space {
            ret.push(Box::new(StyleKeyword1Space::default()));
        }
        if self.syntaxrules.style_keyword_construct {
            ret.push(Box::new(StyleKeywordConstruct::default()));
        }
        if self.syntaxrules.style_keyword_datatype {
            ret.push(Box::new(StyleKeywordDatatype::default()));
        }
        if self.syntaxrules.style_keyword_end {
            ret.push(Box::new(StyleKeywordEnd::default()));
        }
        if self.syntaxrules.style_keyword_maybelabel {
            ret.push(Box::new(StyleKeywordMaybelabel::default()));
        }
        if self.syntaxrules.style_keyword_new {
            ret.push(Box::new(StyleKeywordNew::default()));
        }
        if self.syntaxrules.style_keyword_newline {
            ret.push(Box::new(StyleKeywordNewline::default()));
        }
        if self.syntaxrules.style_operator_arithmetic {
            ret.push(Box::new(StyleOperatorArithmetic::default()));
        }
        if self.syntaxrules.style_operator_arithmetic_leading_space {
            ret.push(Box::new(StyleOperatorArithmeticLeadingSpace::default()));
        }
        if self.syntaxrules.style_operator_boolean {
            ret.push(Box::new(StyleOperatorBoolean::default()));
        }
        if self.syntaxrules.style_operator_boolean_leading_space {
            ret.push(Box::new(StyleOperatorBooleanLeadingSpace::default()));
        }
        if self.syntaxrules.style_operator_integer {
            ret.push(Box::new(StyleOperatorInteger::default()));
        }
        if self.syntaxrules.style_operator_integer_leading_space {
            ret.push(Box::new(StyleOperatorIntegerLeadingSpace::default()));
        }
        if self.syntaxrules.style_operator_unary {
            ret.push(Box::new(StyleOperatorUnary::default()));
        }
        if self.syntaxrules.style_trailingwhitespace {
            ret.push(Box::new(StyleTrailingwhitespace::default()));
        }
        if self.syntaxrules.tab_character {
            ret.push(Box::new(TabCharacter::default()));
        }
        if self.syntaxrules.uppercamelcase_interface {
            ret.push(Box::new(UppercamelcaseInterface::default()));
        }
        if self.syntaxrules.uppercamelcase_module {
            ret.push(Box::new(UppercamelcaseModule::default()));
        }
        if self.syntaxrules.uppercamelcase_package {
            ret.push(Box::new(UppercamelcasePackage::default()));
        }
        if self.syntaxrules.generate_keyword {
            ret.push(Box::new(KeywordForbiddenGenerate::default()));
        }
        if self.syntaxrules.tab_charactor {
            ret.push(Box::new(TabCharacter::default()));
        }
        if self.syntaxrules.genvar_declaration {
            ret.push(Box::new(GenvarDeclarationInLoop::default()));
        }
        if self.syntaxrules.if_with_begin {
            ret.push(Box::new(MultilineIfBegin::default()));
        }
        if self.syntaxrules.for_with_begin {
            ret.push(Box::new(MultilineForBegin::default()));
        }
        if self.syntaxrules.legacy_always {
            ret.push(Box::new(KeywordForbiddenAlways::default()));
        }
        if self.syntaxrules.generate_keyword_forbidden {
            ret.push(Box::new(KeywordForbiddenGenerate::default()));
        }
        if self.syntaxrules.priority_keyword {
            ret.push(Box::new(KeywordForbiddenPriority::default()));
        }
        if self.syntaxrules.unique_keyword {
            ret.push(Box::new(KeywordForbiddenUnique::default()));
        }
        if self.syntaxrules.unique0_keyword {
            ret.push(Box::new(KeywordForbiddenUnique0::default()));
        }
        if self.syntaxrules.wire_reg {
            ret.push(Box::new(KeywordForbiddenWireReg::default()));
        }
        if self.syntaxrules.generate_keyword_required {
            ret.push(Box::new(KeywordRequiredGenerate::default()));
        }
        if self.syntaxrules.non_ansi_module {
            ret.push(Box::new(ModuleNonansiForbidden::default()));
        }
        if self.syntaxrules.level_sensitive_always {
            ret.push(Box::new(GeneralAlwaysNoEdge::default()));
        }

        ret
    }

    pub fn gen_all_textrules() -> Vec<Box<dyn TextRule>> {
        let mut ret: Vec<Box<dyn TextRule>> = Vec::new();
        ret.push(Box::new(HeaderCopyright::default()));
        ret.push(Box::new(StyleDirectives::default()));
        ret.push(Box::new(StyleSemicolon::default()));
        ret.push(Box::new(StyleTextwidth::default()));

        ret
    }

    pub fn gen_all_syntaxrules() -> Vec<Box<dyn SyntaxRule>> {
        let mut ret: Vec<Box<dyn SyntaxRule>> = Vec::new();
        ret.push(Box::new(ActionBlockWithSideEffect::default()));
        ret.push(Box::new(BlockingAssignmentInAlwaysAtEdge::default()));
        ret.push(Box::new(BlockingAssignmentInAlwaysFf::default()));
        ret.push(Box::new(BlockingAssignmentInAlwaysLatch::default()));
        ret.push(Box::new(CaseDefault::default()));
        ret.push(Box::new(DefaultNettypeNone::default()));
        ret.push(Box::new(EnumWithType::default()));
        ret.push(Box::new(EventlistCommaAlwaysFf::default()));
        ret.push(Box::new(EventlistOr::default()));
        ret.push(Box::new(ExplicitCaseDefault::default()));
        ret.push(Box::new(ExplicitIfElse::default()));
        ret.push(Box::new(FunctionSameAsSystemFunction::default()));
        ret.push(Box::new(FunctionWithAutomatic::default()));
        ret.push(Box::new(GeneralAlwaysLevelSensitive::default()));
        ret.push(Box::new(GeneralAlwaysNoEdge::default()));
        ret.push(Box::new(GenerateCaseWithLabel::default()));
        ret.push(Box::new(GenerateForWithLabel::default()));
        ret.push(Box::new(GenerateIfWithLabel::default()));
        ret.push(Box::new(GenvarDeclarationInLoop::default()));
        ret.push(Box::new(GenvarDeclarationOutLoop::default()));
        ret.push(Box::new(InoutWithTri::default()));
        ret.push(Box::new(InputWithVar::default()));
        ret.push(Box::new(InterfacePortWithModport::default()));
        ret.push(Box::new(KeywordForbiddenAlways::default()));
        ret.push(Box::new(KeywordForbiddenAlwaysComb::default()));
        ret.push(Box::new(KeywordForbiddenAlwaysFf::default()));
        ret.push(Box::new(KeywordForbiddenAlwaysLatch::default()));
        ret.push(Box::new(KeywordForbiddenGenerate::default()));
        ret.push(Box::new(KeywordForbiddenLogic::default()));
        ret.push(Box::new(KeywordForbiddenPriority::default()));
        ret.push(Box::new(KeywordForbiddenUnique::default()));
        ret.push(Box::new(KeywordForbiddenUnique0::default()));
        ret.push(Box::new(KeywordForbiddenWireReg::default()));
        ret.push(Box::new(KeywordRequiredGenerate::default()));
        ret.push(Box::new(LocalparamExplicitType::default()));
        ret.push(Box::new(LocalparamTypeTwostate::default()));
        ret.push(Box::new(LoopStatementInAlwaysComb::default()));
        ret.push(Box::new(LoopStatementInAlwaysFf::default()));
        ret.push(Box::new(LoopStatementInAlwaysLatch::default()));
        ret.push(Box::new(LoopVariableDeclaration::default()));
        ret.push(Box::new(LowercamelcaseInterface::default()));
        ret.push(Box::new(LowercamelcaseModule::default()));
        ret.push(Box::new(LowercamelcasePackage::default()));
        ret.push(Box::new(ModuleAnsiForbidden::default()));
        ret.push(Box::new(ModuleNonansiForbidden::default()));
        ret.push(Box::new(MultilineForBegin::default()));
        ret.push(Box::new(MultilineIfBegin::default()));
        ret.push(Box::new(NonBlockingAssignmentInAlwaysComb::default()));
        ret.push(Box::new(NonBlockingAssignmentInAlwaysNoEdge::default()));
        ret.push(Box::new(OperatorCaseEquality::default()));
        ret.push(Box::new(OperatorIncdec::default()));
        ret.push(Box::new(OperatorSelfAssignment::default()));
        ret.push(Box::new(OutputWithVar::default()));
        ret.push(Box::new(PackageItemNotUnderPackage::default()));
        ret.push(Box::new(ParameterDefaultValue::default()));
        ret.push(Box::new(ParameterExplicitType::default()));
        ret.push(Box::new(ParameterInGenerate::default()));
        ret.push(Box::new(ParameterInPackage::default()));
        ret.push(Box::new(ParameterTypeTwostate::default()));
        ret.push(Box::new(PrefixInout::default()));
        ret.push(Box::new(PrefixInput::default()));
        ret.push(Box::new(PrefixInstance::default()));
        ret.push(Box::new(PrefixInterface::default()));
        ret.push(Box::new(PrefixModule::default()));
        ret.push(Box::new(PrefixOutput::default()));
        ret.push(Box::new(PrefixPackage::default()));
        ret.push(Box::new(ProceduralContinuousAssignment::default()));
        ret.push(Box::new(ReForbiddenAssert::default()));
        ret.push(Box::new(ReForbiddenAssertProperty::default()));
        ret.push(Box::new(ReForbiddenChecker::default()));
        ret.push(Box::new(ReForbiddenClass::default()));
        ret.push(Box::new(ReForbiddenFunction::default()));
        ret.push(Box::new(ReForbiddenGenerateblock::default()));
        ret.push(Box::new(ReForbiddenGenvar::default()));
        ret.push(Box::new(ReForbiddenInstance::default()));
        ret.push(Box::new(ReForbiddenInterface::default()));
        ret.push(Box::new(ReForbiddenLocalparam::default()));
        ret.push(Box::new(ReForbiddenModport::default()));
        ret.push(Box::new(ReForbiddenModuleAnsi::default()));
        ret.push(Box::new(ReForbiddenModuleNonansi::default()));
        ret.push(Box::new(ReForbiddenPackage::default()));
        ret.push(Box::new(ReForbiddenParameter::default()));
        ret.push(Box::new(ReForbiddenPortInout::default()));
        ret.push(Box::new(ReForbiddenPortInput::default()));
        ret.push(Box::new(ReForbiddenPortInterface::default()));
        ret.push(Box::new(ReForbiddenPortOutput::default()));
        ret.push(Box::new(ReForbiddenPortRef::default()));
        ret.push(Box::new(ReForbiddenProgram::default()));
        ret.push(Box::new(ReForbiddenProperty::default()));
        ret.push(Box::new(ReForbiddenSequence::default()));
        ret.push(Box::new(ReForbiddenTask::default()));
        ret.push(Box::new(ReForbiddenVarClass::default()));
        ret.push(Box::new(ReForbiddenVarClassmethod::default()));
        ret.push(Box::new(ReRequiredAssert::default()));
        ret.push(Box::new(ReRequiredAssertProperty::default()));
        ret.push(Box::new(ReRequiredChecker::default()));
        ret.push(Box::new(ReRequiredClass::default()));
        ret.push(Box::new(ReRequiredFunction::default()));
        ret.push(Box::new(ReRequiredGenerateblock::default()));
        ret.push(Box::new(ReRequiredGenvar::default()));
        ret.push(Box::new(ReRequiredInstance::default()));
        ret.push(Box::new(ReRequiredInterface::default()));
        ret.push(Box::new(ReRequiredLocalparam::default()));
        ret.push(Box::new(ReRequiredModport::default()));
        ret.push(Box::new(ReRequiredModuleAnsi::default()));
        ret.push(Box::new(ReRequiredModuleNonansi::default()));
        ret.push(Box::new(ReRequiredPackage::default()));
        ret.push(Box::new(ReRequiredParameter::default()));
        ret.push(Box::new(ReRequiredPortInout::default()));
        ret.push(Box::new(ReRequiredPortInput::default()));
        ret.push(Box::new(ReRequiredPortInterface::default()));
        ret.push(Box::new(ReRequiredPortOutput::default()));
        ret.push(Box::new(ReRequiredPortRef::default()));
        ret.push(Box::new(ReRequiredProgram::default()));
        ret.push(Box::new(ReRequiredProperty::default()));
        ret.push(Box::new(ReRequiredSequence::default()));
        ret.push(Box::new(ReRequiredTask::default()));
        ret.push(Box::new(ReRequiredVarClass::default()));
        ret.push(Box::new(ReRequiredVarClassmethod::default()));
        ret.push(Box::new(SequentialBlockInAlwaysComb::default()));
        ret.push(Box::new(SequentialBlockInAlwaysFf::default()));
        ret.push(Box::new(SequentialBlockInAlwaysLatch::default()));
        ret.push(Box::new(StyleCommaleading::default()));
        ret.push(Box::new(StyleIndent::default()));
        ret.push(Box::new(StyleKeyword0Or1Space::default()));
        ret.push(Box::new(StyleKeyword0Space::default()));
        ret.push(Box::new(StyleKeyword1Or2Space::default()));
        ret.push(Box::new(StyleKeyword1Space::default()));
        ret.push(Box::new(StyleKeywordConstruct::default()));
        ret.push(Box::new(StyleKeywordDatatype::default()));
        ret.push(Box::new(StyleKeywordEnd::default()));
        ret.push(Box::new(StyleKeywordMaybelabel::default()));
        ret.push(Box::new(StyleKeywordNew::default()));
        ret.push(Box::new(StyleKeywordNewline::default()));
        ret.push(Box::new(StyleOperatorArithmetic::default()));
        ret.push(Box::new(StyleOperatorArithmeticLeadingSpace::default()));
        ret.push(Box::new(StyleOperatorBoolean::default()));
        ret.push(Box::new(StyleOperatorBooleanLeadingSpace::default()));
        ret.push(Box::new(StyleOperatorInteger::default()));
        ret.push(Box::new(StyleOperatorIntegerLeadingSpace::default()));
        ret.push(Box::new(StyleOperatorUnary::default()));
        ret.push(Box::new(StyleTrailingwhitespace::default()));
        ret.push(Box::new(TabCharacter::default()));
        ret.push(Box::new(UppercamelcaseInterface::default()));
        ret.push(Box::new(UppercamelcaseModule::default()));
        ret.push(Box::new(UppercamelcasePackage::default()));

        ret
    }

    pub fn check_rename(&self) -> Vec<(String, String)> {
        let mut ret: Vec<(String, String)> = Vec::new();
        if self.syntaxrules.generate_keyword {
            ret.push((String::from("generate_keyword"), String::from("keyword_forbidden_generate")));
        }
        if self.syntaxrules.tab_charactor {
            ret.push((String::from("tab_charactor"), String::from("tab_character")));
        }
        if self.syntaxrules.genvar_declaration {
            ret.push((String::from("genvar_declaration"), String::from("genvar_declaration_in_loop")));
        }
        if self.syntaxrules.if_with_begin {
            ret.push((String::from("if_with_begin"), String::from("multiline_if_begin")));
        }
        if self.syntaxrules.for_with_begin {
            ret.push((String::from("for_with_begin"), String::from("multiline_for_begin")));
        }
        if self.syntaxrules.legacy_always {
            ret.push((String::from("legacy_always"), String::from("keyword_forbidden_always")));
        }
        if self.syntaxrules.generate_keyword_forbidden {
            ret.push((String::from("generate_keyword_forbidden"), String::from("keyword_forbidden_generate")));
        }
        if self.syntaxrules.priority_keyword {
            ret.push((String::from("priority_keyword"), String::from("keyword_forbidden_priority")));
        }
        if self.syntaxrules.unique_keyword {
            ret.push((String::from("unique_keyword"), String::from("keyword_forbidden_unique")));
        }
        if self.syntaxrules.unique0_keyword {
            ret.push((String::from("unique0_keyword"), String::from("keyword_forbidden_unique0")));
        }
        if self.syntaxrules.wire_reg {
            ret.push((String::from("wire_reg"), String::from("keyword_forbidden_wire_reg")));
        }
        if self.syntaxrules.generate_keyword_required {
            ret.push((String::from("generate_keyword_required"), String::from("keyword_required_generate")));
        }
        if self.syntaxrules.non_ansi_module {
            ret.push((String::from("non_ansi_module"), String::from("module_nonansi_forbidden")));
        }
        if self.syntaxrules.level_sensitive_always {
            ret.push((String::from("level_sensitive_always"), String::from("general_always_no_edge")));
        }

        ret
    }

    pub fn migrate(&mut self) {
        self.syntaxrules.keyword_forbidden_generate = self.syntaxrules.generate_keyword;
        self.syntaxrules.tab_character = self.syntaxrules.tab_charactor;
        self.syntaxrules.genvar_declaration_in_loop = self.syntaxrules.genvar_declaration;
        self.syntaxrules.multiline_if_begin = self.syntaxrules.if_with_begin;
        self.syntaxrules.multiline_for_begin = self.syntaxrules.for_with_begin;
        self.syntaxrules.keyword_forbidden_always = self.syntaxrules.legacy_always;
        self.syntaxrules.keyword_forbidden_generate = self.syntaxrules.generate_keyword_forbidden;
        self.syntaxrules.keyword_forbidden_priority = self.syntaxrules.priority_keyword;
        self.syntaxrules.keyword_forbidden_unique = self.syntaxrules.unique_keyword;
        self.syntaxrules.keyword_forbidden_unique0 = self.syntaxrules.unique0_keyword;
        self.syntaxrules.keyword_forbidden_wire_reg = self.syntaxrules.wire_reg;
        self.syntaxrules.keyword_required_generate = self.syntaxrules.generate_keyword_required;
        self.syntaxrules.module_nonansi_forbidden = self.syntaxrules.non_ansi_module;
        self.syntaxrules.general_always_no_edge = self.syntaxrules.level_sensitive_always;
    }
} // impl Config
