/* eslint-disable no-unused-vars */

var snmp = require ("../");
var getopts = require ("getopts");

var options = getopts(process.argv.slice(2));
var providers;
var mibDir = '/var/tmp/mibs/';

var counter64 = function (num) {
    var buf = Buffer.alloc (4);
    buf.writeUInt32BE (num);
    return buf;
};

var snmpOptions = {
    disableAuthorization: options.n,
    port: options.p,
    engineID: options.e,
    debug: options.d
};

var callback = function (error, data) {
    if ( error ) {
        console.error (error);
    } else {
        console.log (data.pdu.varbinds[0].oid);
    }
};

var store = snmp.createModuleStore ();
var agent = snmp.createAgent (snmpOptions, callback);
var mib = agent.getMib ();

var authorizer = agent.getAuthorizer ();
authorizer.addCommunity ("public");

// IF-MIB load and providers registration
store.loadFromFile (mibDir + "IANAifType-MIB.mib");
store.loadFromFile (mibDir + "IF-MIB.mib");
store.loadFromFile (mibDir + "HOST-RESOURCES-MIB.MIB");
store.loadFromFile (mibDir + "IANA-PRINTER-MIB.mib");
store.loadFromFile (mibDir + "IANA-CHARSET-MIB.mib");
store.loadFromFile (mibDir + "PRINTER-MIBv1.mib");
store.loadFromFile (mibDir + "JOB-MONITORING-MIB-RFC.mib");
store.loadFromFile (mibDir + "NETSURE-MIB-001-B.mib");

// const mibModuleOid = store.translate('1.3.6.1.4.1', snmp.OidFormat.module);
// console.log('mibModuleOid: ', mibModuleOid);
// const mibOid = store.translate('Job-Monitoring-MIB::jmJobTable', snmp.OidFormat.oid);
// console.log('mibOid: ', mibOid);
console.log(store.translate('Job-Monitoring-MIB::jmJobTable', snmp.OidFormat.oid));
console.log(store.translate('Job-Monitoring-MIB::jmJobTable', snmp.OidFormat.path));
console.log(store.translate('1.3.6.1.4.1.2699.1.1.1.3.1', snmp.OidFormat.path));
console.log(store.translate('1.3.6.1.4.1.2699.1.1.1.3.1', snmp.OidFormat.module));
console.log(store.translate('iso.org.dod.internet.private.enterprises.pwg.mibs.jobmonMIB.jobmonMIBObjects.jmJob.jmJobTable', snmp.OidFormat.oid));
console.log(store.translate('iso.org.dod.internet.private.enterprises.pwg.mibs.jobmonMIB.jobmonMIBObjects.jmJob.jmJobTable', snmp.OidFormat.module));

// ifNumber
// Scalar type - setScalarValue() and getScalarValue() are the entire API for these

// console.log("All modules: ", JSON.stringify(modules, '', 2));
// const jobModule = store.getModule('Job-Monitoring-MIB');
// console.log('jobModule: ', JSON.stringify(jobModule, null, 2));

// print IF-MIB
// const ifModule = store.getModule('IF-MIB');
// console.log('ifModule: ', JSON.stringify(ifModule, null, 2));
const nsModule = store.getModule('NETSURE-MIB-001-B');
console.log('nsModule: ', JSON.stringify(nsModule, null, 2));
