import { RedBeanNode } from "./redbean-node";
import { SharedList } from "./shared-list";
import { OwnList } from "./own-list";
import { LooseObject } from "./helper/helper";
import AwaitLock from 'await-lock';
import { Knex } from "knex";
import RawBinding = Knex.RawBinding;
export declare class Bean {
    [key: string]: any;
    beanMeta: BeanMeta;
    constructor(type: string, R: RedBeanNode);
    __set(name: any, value: any): void;
    __get(name: any): any;
    __isset(name: any): boolean;
    __unset(name: any): boolean;
    protected setRelationBean(alias: string, bean: Bean | null): void;
    protected getRelationBean(alias: string, type?: string, force?: boolean): Promise<Bean | null>;
    protected ownList(type: string, alias: string, force?: boolean): OwnList;
    protected sharedList(type: string, force?: boolean): SharedList;
    storeTypeBeanList(): Promise<void>;
    storeSharedList(): Promise<void>;
    storeOwnList(): Promise<void>;
    refresh(): Promise<void>;
    import(obj: any): void;
    export(camelCase?: boolean): any;
    fetchAs(type: string): Bean;
    alias(alias: string): Bean;
    via(via: string): Bean;
    withCondition(condition: string, data?: RawBinding[]): Bean;
    with(value: string, data?: RawBinding[]): Bean;
    private createChainBean;
    getType(): string;
    get R(): RedBeanNode;
    static isOwnListProperty(name: string): boolean;
    static getTypeFromOwnListProperty(name: string): string;
    static isSharedListProperty(name: string): boolean;
    static getTypeFromSharedListProperty(name: string): string;
    static isRelationField(name: string): boolean;
    protected static getInternalRelationFieldName(type: string): string;
    static getRelationFieldName(type: string): string;
    static prefixUnderscore(name: string): string;
    static getTypeFromRelationField(name: string): string;
    static removePrefixUnderscore(name: string): string;
    static dbFieldName(name: string): string;
    static internalName(name: string): string;
    protected devLog(...params: any[]): void;
    isTainted(): boolean;
}
declare class BeanMeta {
    #private;
    noCache: boolean;
    fetchAs: string;
    alias: string;
    via: string;
    withCondition: string;
    withConditionData: RawBinding[];
    get R(): RedBeanNode;
    set R(value: RedBeanNode);
    get typeBeanList(): any;
    get type(): string;
    set type(value: string);
    get ownListList(): LooseObject<OwnList>;
    get sharedListList(): LooseObject<SharedList>;
    set chainParentBean(value: Bean);
    isChainBean(): boolean;
    get old(): LooseObject;
    set old(value: LooseObject);
    clearCache(): void;
    clearHistory(): void;
    refresh(): void;
    get lock(): AwaitLock;
}
export {};
